<?php
/**
 * Template part for top panel in header.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package HealthRehub
 */

// Don't show top panel if all elements are disabled.
if ( ! healthrehub_is_top_panel_visible() ) {
	return;
} ?>

<div class="top-panel invert">
	<div <?php echo healthrehub_get_container_classes( array( 'top-panel__wrap container' ), 'header' ); ?>>
		<div class="top_panel_head"><?php
			healthrehub_top_message( '<div class="top-panel__message">%s</div>' );
			healthrehub_social_list( 'header' );
		?></div>
		<div class="top_panel_bottom"><?php
			healthrehub_top_menu();
			healthrehub_top_search( '<div class="top-panel__search">%s</div>' );
		?></div>
	</div>
</div><!-- .top-panel -->