/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-07-25 14:46:45 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `form_id` mediumint(8) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_url` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `submission` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_agent` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `currency` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_status` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_fulfilled` tinyint(1) DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `transaction_type` tinyint(1) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_index` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `is_trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint(8) unsigned NOT NULL,
  `display_meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entries_grid_meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmations` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notifications` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `display_meta` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_view` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mp_timetable_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_id` int(11) NOT NULL,
  `event_id` int(11) NOT NULL,
  `event_start` time NOT NULL,
  `event_end` time NOT NULL,
  `user_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=23719 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5691 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4852 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=176 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=1998 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2018-10-24 06:13:12", "2018-10-24 06:13:12", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "64", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:59:55", "2017-01-20 15:59:55", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("3", "64", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 16:00:04", "2017-01-20 16:00:04", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "2", "1");
INSERT INTO `wp_comments` VALUES("4", "66", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:59:11", "2017-01-20 15:59:11", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("5", "66", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:59:24", "2017-01-20 15:59:24", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "4", "1");
INSERT INTO `wp_comments` VALUES("6", "68", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:58:40", "2017-01-20 15:58:40", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("7", "68", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:58:53", "2017-01-20 15:58:53", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "6", "1");
INSERT INTO `wp_comments` VALUES("8", "70", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:58:13", "2017-01-20 15:58:13", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("9", "70", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:58:20", "2017-01-20 15:58:20", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "8", "1");
INSERT INTO `wp_comments` VALUES("10", "72", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:57:38", "2017-01-20 15:57:38", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("11", "72", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:57:52", "2017-01-20 15:57:52", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "10", "1");
INSERT INTO `wp_comments` VALUES("12", "74", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:57:10", "2017-01-20 15:57:10", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("13", "74", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:57:20", "2017-01-20 15:57:20", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "12", "1");
INSERT INTO `wp_comments` VALUES("14", "401", "admin", "admin@demolink.org", "", "192.168.9.82", "2016-12-24 15:21:06", "2016-12-24 15:21:06", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("15", "401", "admin", "admin@demolink.org", "", "192.168.9.82", "2016-12-24 15:21:22", "2016-12-24 15:21:22", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "14", "1");
INSERT INTO `wp_comments` VALUES("16", "407", "admin", "admin@demolink.org", "", "192.168.9.82", "2016-12-24 15:21:00", "2016-12-24 15:21:00", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("17", "407", "admin", "admin@demolink.org", "", "192.168.9.82", "2016-12-24 15:21:16", "2016-12-24 15:21:16", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "16", "1");
INSERT INTO `wp_comments` VALUES("18", "409", "admin", "admin@demolink.org", "", "192.168.9.82", "2016-12-24 15:20:21", "2016-12-24 15:20:21", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("19", "409", "admin", "admin@demolink.org", "", "192.168.9.82", "2016-12-24 15:20:34", "2016-12-24 15:20:34", "After reading this article I took a consultation with one of your surgeons and now I\'m much more confident about my health, than ever before!", "0", "1", "", "", "18", "1");
INSERT INTO `wp_comments` VALUES("20", "1093", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:56:41", "2017-01-20 15:56:41", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("21", "1093", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:56:51", "2017-01-20 15:56:51", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "20", "1");
INSERT INTO `wp_comments` VALUES("22", "1102", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:56:01", "2017-01-20 15:56:01", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("23", "1102", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:56:10", "2017-01-20 15:56:10", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "22", "1");
INSERT INTO `wp_comments` VALUES("24", "1104", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:55:30", "2017-01-20 15:55:30", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("25", "1104", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:55:37", "2017-01-20 15:55:37", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "24", "1");
INSERT INTO `wp_comments` VALUES("26", "1106", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:55:02", "2017-01-20 15:55:02", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("27", "1106", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:55:10", "2017-01-20 15:55:10", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "26", "1");
INSERT INTO `wp_comments` VALUES("28", "1108", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:54:27", "2017-01-20 15:54:27", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("29", "1108", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:54:37", "2017-01-20 15:54:37", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "28", "1");
INSERT INTO `wp_comments` VALUES("30", "1110", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:52:20", "2017-01-20 15:52:20", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("31", "1110", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:52:30", "2017-01-20 15:52:30", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "30", "1");
INSERT INTO `wp_comments` VALUES("32", "1112", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:51:46", "2017-01-20 15:51:46", "These tips may seem pretty obvious, but they helped me to focus more on my health, thanks!", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("33", "1112", "admin", "admin@demolink.org", "", "192.168.9.82", "2017-01-20 15:51:57", "2017-01-20 15:51:57", "After reading this article I took a consultation with one of your surgeons and now I’m much more confident about my health, than ever before!", "0", "1", "", "", "32", "1");
INSERT INTO `wp_comments` VALUES("34", "407", "https://philosophyessays.net/tag/alzheimers-disease/", "winifredbarham@inbox.com", "https://philosophyessays.net/tag/alzheimers-disease/", "95.158.63.46", "2019-05-11 08:48:14", "2019-05-11 12:48:14", "Veryy beneficial write-up. I usually create a lot about illnesses as \r\nwell as in certain, about Alzheimer\'s disease.\r\nI am a professional writer and if someone will be useful, examples of my work and Alzheimer\'s disease \r\ncan be found here: https://philosophyessays.net/tag/alzheimers-disease/. Have a \r\ngood day!", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.139 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("35", "64", "http://canadianorderpharmacy.com/", "fghserf@bigmir.net", "http://canadianorderpharmacy.com/", "31.184.238.111", "2019-06-04 06:39:05", "2019-06-04 10:39:05", "It\'s truly a great and useful piece of information. I\'m happy that you just shared this useful info with us. Please stay us informed like this. Thank you for sharing.", "0", "0", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "", "0", "0");
INSERT INTO `wp_comments` VALUES("36", "409", "Aislynn", "Aislynn@gmail.com", "https://www.reliable-webhosting.com/", "94.23.158.0", "2019-06-15 12:27:58", "2019-06-15 16:27:58", "Hi, very nice website, cheers!\r\n------------------------------------------------------\r\nNeed cheap and reliable hosting? Our shared plans start at $10 for an year and VPS plans for $6/Mo.\r\n------------------------------------------------------\r\nCheck here: https://www.reliable-webhosting.com/", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0", "", "0", "0");
INSERT INTO `wp_comments` VALUES("37", "2434", "KiaInatA", "marlo@probbox.com", "http://kamagra50.com/", "5.188.210.61", "2019-07-12 03:36:43", "2019-07-12 07:36:43", "<a href=\"http://kamagra50.com/\" rel=\"nofollow\">kamagra tablets</a>", "0", "0", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "20190226_westchesterstair", "a07b0236ed6a8a2c6537_20190318100839", "100", "2019-03-18 10:10:26", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-03-18 10:08:39\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:25:\"20190226_westchesterstair\";s:4:\"Hash\";s:35:\"a07b0236ed6a8a2c6537_20190318100839\";s:8:\"NameHash\";s:61:\"20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";s:71:\"20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"62.72 sec.\";s:7:\"ExeSize\";s:7:\"43.29KB\";s:7:\"ZipSize\";s:8:\"702.59MB\";s:6:\"Status\";i:100;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:73:\"20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/westches/public_html\";s:4:\"Size\";i:736718021;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13010;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/westches/public_html/wp-admin\";i:1;s:45:\"/home/westches/public_html/wp-content/uploads\";i:2;s:47:\"/home/westches/public_html/wp-content/languages\";i:3;s:44:\"/home/westches/public_html/wp-content/themes\";i:4;s:38:\"/home/westches/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/westches/public_html\";i:1;s:37:\"/home/westches/public_html/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:38:\"/home/westches/public_html/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:75:\"20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839_installer.php\";s:4:\"Size\";i:44332;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:20050730;s:4:\"File\";s:74:\"20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:118:\"/home/westches/public_html/wp-snapshots/tmp/20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":3:{s:13:\"collationList\";a:0:{}s:15:\"isNameUpperCase\";N;s:4:\"name\";N;}s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-03-18 10:08:39\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:25:\"20190226_westchesterstair\";s:4:\"Hash\";s:35:\"a07b0236ed6a8a2c6537_20190318100839\";s:8:\"NameHash\";s:61:\"20190226_westchesterstair_a07b0236ed6a8a2c6537_20190318100839\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:107;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("4", "20190226_westchesterstair", "79586909e37cba4b2998_20190318101419", "100", "2019-03-18 10:15:15", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-03-18 10:14:19\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:25:\"20190226_westchesterstair\";s:4:\"Hash\";s:35:\"79586909e37cba4b2998_20190318101419\";s:8:\"NameHash\";s:61:\"20190226_westchesterstair_79586909e37cba4b2998_20190318101419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";s:71:\"20190226_westchesterstair_79586909e37cba4b2998_20190318101419_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"32.10 sec.\";s:7:\"ExeSize\";s:7:\"43.29KB\";s:7:\"ZipSize\";s:8:\"393.52MB\";s:6:\"Status\";i:100;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:50:\"/home/westches/public_html/wp-content/uploads.zip;\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:73:\"20190226_westchesterstair_79586909e37cba4b2998_20190318101419_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/westches/public_html\";s:4:\"Size\";i:412631443;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13009;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/westches/public_html/wp-admin\";i:1;s:45:\"/home/westches/public_html/wp-content/uploads\";i:2;s:47:\"/home/westches/public_html/wp-content/languages\";i:3;s:44:\"/home/westches/public_html/wp-content/themes\";i:4;s:38:\"/home/westches/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/westches/public_html\";i:1;s:37:\"/home/westches/public_html/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:38:\"/home/westches/public_html/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:75:\"20190226_westchesterstair_79586909e37cba4b2998_20190318101419_installer.php\";s:4:\"Size\";i:44332;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:20056475;s:4:\"File\";s:74:\"20190226_westchesterstair_79586909e37cba4b2998_20190318101419_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:118:\"/home/westches/public_html/wp-snapshots/tmp/20190226_westchesterstair_79586909e37cba4b2998_20190318101419_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":3:{s:13:\"collationList\";a:0:{}s:15:\"isNameUpperCase\";N;s:4:\"name\";N;}s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-03-18 10:14:19\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:25:\"20190226_westchesterstair\";s:4:\"Hash\";s:35:\"79586909e37cba4b2998_20190318101419\";s:8:\"NameHash\";s:61:\"20190226_westchesterstair_79586909e37cba4b2998_20190318101419\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:45:\"http://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:107;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("5", "20190406_westchesterstair", "01af91d11158ba893638_20190406123452", "100", "2019-04-06 12:35:07", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-04-06 12:34:52\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:25:\"20190406_westchesterstair\";s:4:\"Hash\";s:35:\"01af91d11158ba893638_20190406123452\";s:8:\"NameHash\";s:61:\"20190406_westchesterstair_01af91d11158ba893638_20190406123452\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"https://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";s:71:\"20190406_westchesterstair_01af91d11158ba893638_20190406123452_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"45.75 sec.\";s:7:\"ExeSize\";s:7:\"43.29KB\";s:7:\"ZipSize\";s:8:\"307.39MB\";s:6:\"Status\";i:100;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:50:\"/home/westches/public_html/wp-content/uploads.zip;\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:73:\"20190406_westchesterstair_01af91d11158ba893638_20190406123452_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/westches/public_html\";s:4:\"Size\";i:322325327;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13120;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/westches/public_html/wp-admin\";i:1;s:45:\"/home/westches/public_html/wp-content/uploads\";i:2;s:47:\"/home/westches/public_html/wp-content/languages\";i:3;s:44:\"/home/westches/public_html/wp-content/themes\";i:4;s:38:\"/home/westches/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/westches/public_html\";i:1;s:37:\"/home/westches/public_html/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:38:\"/home/westches/public_html/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:75:\"20190406_westchesterstair_01af91d11158ba893638_20190406123452_installer.php\";s:4:\"Size\";i:44332;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:24906597;s:4:\"File\";s:74:\"20190406_westchesterstair_01af91d11158ba893638_20190406123452_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:118:\"/home/westches/public_html/wp-snapshots/tmp/20190406_westchesterstair_01af91d11158ba893638_20190406123452_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":3:{s:13:\"collationList\";a:0:{}s:15:\"isNameUpperCase\";N;s:4:\"name\";N;}s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-04-06 12:34:52\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:25:\"20190406_westchesterstair\";s:4:\"Hash\";s:35:\"01af91d11158ba893638_20190406123452\";s:8:\"NameHash\";s:61:\"20190406_westchesterstair_01af91d11158ba893638_20190406123452\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"https://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:107;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("6", "20190406_westchesterstair", "e6b0c2469b2ae8b91558_20190424141211", "100", "2019-04-24 14:12:23", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-04-24 14:12:11\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:25:\"20190406_westchesterstair\";s:4:\"Hash\";s:35:\"e6b0c2469b2ae8b91558_20190424141211\";s:8:\"NameHash\";s:61:\"20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"https://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";s:71:\"20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"44.69 sec.\";s:7:\"ExeSize\";s:7:\"43.29KB\";s:7:\"ZipSize\";s:8:\"312.93MB\";s:6:\"Status\";i:100;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:50:\"/home/westches/public_html/wp-content/uploads.zip;\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:73:\"20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/westches/public_html\";s:4:\"Size\";i:328130286;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14383;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/westches/public_html/wp-admin\";i:1;s:45:\"/home/westches/public_html/wp-content/uploads\";i:2;s:47:\"/home/westches/public_html/wp-content/languages\";i:3;s:44:\"/home/westches/public_html/wp-content/themes\";i:4;s:38:\"/home/westches/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/westches/public_html\";i:1;s:37:\"/home/westches/public_html/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:38:\"/home/westches/public_html/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:75:\"20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211_installer.php\";s:4:\"Size\";i:44332;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:27393596;s:4:\"File\";s:74:\"20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:118:\"/home/westches/public_html/wp-snapshots/tmp/20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":3:{s:13:\"collationList\";a:0:{}s:15:\"isNameUpperCase\";N;s:4:\"name\";N;}s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-04-24 14:12:11\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.1.38\";s:10:\"VersionPHP\";s:6:\"7.1.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:25:\"20190406_westchesterstair\";s:4:\"Hash\";s:35:\"e6b0c2469b2ae8b91558_20190424141211\";s:8:\"NameHash\";s:61:\"20190406_westchesterstair_e6b0c2469b2ae8b91558_20190424141211\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"https://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:107;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("7", "20190406_westchesterstair", "87ca03b691a86cf22411_20190725144635", "20", "2019-07-25 14:46:45", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-07-25 14:46:35\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.2.25\";s:10:\"VersionPHP\";s:6:\"7.1.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:7;s:4:\"Name\";s:25:\"20190406_westchesterstair\";s:4:\"Hash\";s:35:\"87ca03b691a86cf22411_20190725144635\";s:8:\"NameHash\";s:61:\"20190406_westchesterstair_87ca03b691a86cf22411_20190725144635\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"https://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";s:71:\"20190406_westchesterstair_87ca03b691a86cf22411_20190725144635_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";d:20;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:50:\"/home/westches/public_html/wp-content/uploads.zip;\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:73:\"20190406_westchesterstair_87ca03b691a86cf22411_20190725144635_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/westches/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-07-25 14:46:35\";s:7:\"Version\";s:5:\"1.3.8\";s:9:\"VersionWP\";s:6:\"4.9.10\";s:9:\"VersionDB\";s:7:\"10.2.25\";s:10:\"VersionPHP\";s:6:\"7.1.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:25:\"20190406_westchesterstair\";s:4:\"Hash\";s:35:\"87ca03b691a86cf22411_20190725144635\";s:8:\"NameHash\";s:61:\"20190406_westchesterstair_87ca03b691a86cf22411_20190725144635\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:43:\"/home/westches/public_html/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"https://westchesterstairlift.com/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:75:\"20190406_westchesterstair_87ca03b691a86cf22411_20190725144635_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:74:\"20190406_westchesterstair_87ca03b691a86cf22411_20190725144635_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:118:\"/home/westches/public_html/wp-snapshots/tmp/20190406_westchesterstair_87ca03b691a86cf22411_20190725144635_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":3:{s:13:\"collationList\";a:0:{}s:15:\"isNameUpperCase\";N;s:4:\"name\";N;}s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:35:\"/home/westches/public_html/wp-admin\";i:1;s:45:\"/home/westches/public_html/wp-content/uploads\";i:2;s:47:\"/home/westches/public_html/wp-content/languages\";i:3;s:44:\"/home/westches/public_html/wp-content/themes\";i:4;s:38:\"/home/westches/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:26:\"/home/westches/public_html\";i:1;s:37:\"/home/westches/public_html/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:117;}");

/* INSERT TABLE DATA: wp_gf_entry */
INSERT INTO `wp_gf_entry` VALUES("1", "1", "2364", "2019-01-02 05:58:11", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("2", "1", "2370", "2019-01-02 06:36:57", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("3", "1", "2371", "2019-01-02 06:55:35", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("4", "1", "2372", "2019-01-02 07:01:46", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("5", "1", "2373", "2019-01-02 07:14:15", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("6", "1", "2374", "2019-01-02 07:18:43", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("7", "1", "2380", "2019-01-02 07:20:03", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("8", "1", "2381", "2019-01-02 07:22:45", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("9", "1", "2384", "2019-01-02 07:27:04", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("10", "1", "2385", "2019-01-02 07:30:15", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("11", "1", "2388", "2019-01-02 07:33:28", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("12", "1", "2389", "2019-01-02 07:35:37", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("13", "1", "2393", "2019-01-02 09:50:31", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("14", "1", "2394", "2019-01-02 09:52:52", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("15", "1", "2395", "2019-01-02 09:57:00", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("16", "1", "2397", "2019-01-02 10:04:13", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("17", "1", "2398", "2019-01-02 10:11:50", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("18", "1", "2402", "2019-01-02 10:16:53", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("19", "1", "2403", "2019-01-02 10:21:48", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("20", "1", "2404", "2019-01-02 10:24:27", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("21", "1", "2409", "2019-01-02 10:27:12", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("22", "1", "2410", "2019-01-02 10:46:14", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("23", "1", "2412", "2019-01-02 10:52:05", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("24", "1", "2413", "2019-01-02 10:55:26", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("25", "1", "2414", "2019-01-02 10:57:48", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("26", "1", "2419", "2019-01-02 11:04:54", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("27", "1", "2422", "2019-01-02 11:06:33", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("28", "1", "2428", "2019-01-02 11:10:10", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("29", "1", "2434", "2019-01-02 11:20:30", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("30", "1", "2436", "2019-01-02 15:25:54", NULL, "0", "0", "100.1.181.29", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("31", "2", NULL, "2019-02-01 11:40:09", NULL, "0", "1", "103.192.76.163", "http://westchesterstairlift.com/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "trash");
INSERT INTO `wp_gf_entry` VALUES("32", "2", NULL, "2019-02-04 10:25:11", NULL, "0", "0", "103.192.76.163", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("33", "1", "3120", "2019-02-08 12:27:46", NULL, "0", "0", "103.192.76.163", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("34", "1", "3128", "2019-02-08 12:46:28", NULL, "0", "0", "103.192.76.163", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("35", "2", NULL, "2019-02-25 04:59:01", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.109 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("36", "2", NULL, "2019-02-25 20:18:19", NULL, "0", "0", "100.1.181.29", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.109 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("37", "2", NULL, "2019-02-25 20:18:53", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.109 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("38", "2", NULL, "2019-02-28 17:18:34", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/?gf_page=preview&id=2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.119 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("39", "2", NULL, "2019-03-05 00:04:21", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.109 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("40", "1", "3655", "2019-03-05 03:19:46", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.109 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("41", "1", "3656", "2019-03-05 03:25:53", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 OPR/58.0.3135.68", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("42", "1", "3660", "2019-03-06 10:33:03", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("43", "2", NULL, "2019-03-06 22:52:45", NULL, "0", "0", "68.129.147.241", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.3 Safari/605.1.15", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("44", "2", NULL, "2019-03-07 05:27:35", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("45", "2", NULL, "2019-03-07 05:29:13", NULL, "0", "0", "202.166.220.160", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("46", "2", NULL, "2019-03-10 14:46:31", NULL, "0", "0", "107.172.170.161", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("47", "2", NULL, "2019-03-11 03:55:11", NULL, "0", "0", "23.95.185.149", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("48", "2", NULL, "2019-03-11 13:52:10", NULL, "0", "0", "65.96.59.204", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0.2 Safari/605.1.15", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("49", "2", NULL, "2019-03-11 14:17:50", NULL, "0", "0", "188.225.9.121", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("50", "1", "3693", "2019-03-15 04:02:23", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "2", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("51", "2", NULL, "2019-03-16 20:54:05", NULL, "0", "0", "192.210.176.252", "http://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("52", "1", "3712", "2019-03-19 01:02:36", NULL, "0", "0", "68.198.93.246", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "2", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("53", "1", "3713", "2019-03-19 01:05:48", NULL, "0", "1", "68.198.93.246", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "2", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("54", "1", "3719", "2019-03-19 01:20:15", NULL, "0", "1", "68.198.93.246", "http://westchesterstairlift.com/reviews/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "2", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("55", "2", NULL, "2019-03-20 17:22:12", NULL, "0", "0", "207.189.0.88", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("56", "2", NULL, "2019-03-22 01:46:04", NULL, "0", "0", "207.189.0.88", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("57", "2", NULL, "2019-03-22 10:44:08", NULL, "0", "0", "82.102.18.153", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("58", "2", NULL, "2019-03-23 20:00:37", NULL, "0", "0", "46.166.143.108", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("59", "2", NULL, "2019-03-23 21:10:18", NULL, "0", "0", "207.189.0.88", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("60", "2", NULL, "2019-03-23 23:01:23", NULL, "0", "0", "185.189.113.44", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("61", "2", NULL, "2019-03-24 01:53:15", NULL, "0", "0", "109.184.224.24", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("62", "2", NULL, "2019-03-24 03:26:36", NULL, "0", "0", "185.130.184.213", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("63", "2", NULL, "2019-03-25 20:33:13", NULL, "0", "0", "46.166.143.108", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("64", "2", NULL, "2019-03-25 21:12:00", NULL, "0", "0", "207.189.0.88", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("65", "2", NULL, "2019-03-25 22:20:26", NULL, "0", "0", "185.189.113.36", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.106", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("66", "2", NULL, "2019-03-27 08:09:09", NULL, "0", "0", "221.2.174.3", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("67", "2", NULL, "2019-03-27 11:42:57", NULL, "0", "0", "46.166.143.108", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("68", "2", NULL, "2019-03-27 11:48:42", NULL, "0", "0", "89.249.65.21", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("69", "2", NULL, "2019-03-28 01:53:48", NULL, "0", "0", "82.102.18.57", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("70", "2", NULL, "2019-03-28 02:07:31", NULL, "0", "0", "185.130.184.205", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("71", "2", NULL, "2019-03-28 20:08:28", NULL, "0", "0", "89.249.65.21", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("72", "2", NULL, "2019-03-28 21:51:55", NULL, "0", "0", "82.102.18.57", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("73", "2", NULL, "2019-03-29 02:58:48", NULL, "0", "0", "185.130.184.205", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("74", "2", NULL, "2019-03-29 11:34:38", NULL, "0", "0", "31.184.238.190", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("75", "2", NULL, "2019-03-29 22:22:00", NULL, "0", "0", "185.130.184.205", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("76", "2", NULL, "2019-03-30 03:20:44", NULL, "0", "0", "31.173.81.102", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("77", "2", NULL, "2019-03-30 20:45:50", NULL, "0", "0", "89.249.65.21", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("78", "2", NULL, "2019-03-30 22:34:22", NULL, "0", "0", "82.102.18.154", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("79", "2", NULL, "2019-04-01 18:46:22", NULL, "0", "0", "109.184.218.58", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("80", "2", NULL, "2019-04-01 23:45:06", NULL, "0", "0", "185.189.113.46", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64 (Edition Yx)", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("81", "2", NULL, "2019-04-02 00:00:22", NULL, "0", "0", "185.130.184.202", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("82", "2", NULL, "2019-04-02 00:02:04", NULL, "0", "0", "89.249.65.21", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("83", "2", NULL, "2019-04-02 05:49:15", NULL, "0", "0", "186.225.220.18", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("84", "2", NULL, "2019-04-02 07:58:23", NULL, "0", "0", "82.102.18.148", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("85", "2", NULL, "2019-04-02 14:28:08", NULL, "0", "0", "109.184.218.58", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("86", "2", NULL, "2019-04-03 08:33:07", NULL, "0", "0", "31.184.238.190", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("87", "2", NULL, "2019-04-03 09:54:39", NULL, "0", "0", "82.102.18.143", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("88", "2", NULL, "2019-04-03 10:34:41", NULL, "0", "0", "185.212.168.189", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("89", "2", NULL, "2019-04-03 12:47:27", NULL, "0", "0", "185.189.113.44", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("90", "2", NULL, "2019-04-03 21:38:43", NULL, "0", "0", "185.130.184.209", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("91", "2", NULL, "2019-04-03 22:26:26", NULL, "0", "0", "5.188.211.21", "http://westchesterstairlift.com/", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("92", "2", NULL, "2019-04-05 00:47:43", NULL, "0", "0", "34.238.138.59", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; WOW64; rv:26.0) Gecko/20100101 Firefox/26.0", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("93", "2", NULL, "2019-04-05 01:38:10", NULL, "0", "0", "109.184.219.28", "http://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("94", "2", NULL, "2019-04-06 00:32:05", NULL, "0", "0", "185.189.113.44", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("95", "2", NULL, "2019-04-06 00:32:07", NULL, "0", "0", "82.102.18.58", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("96", "2", NULL, "2019-04-06 01:50:44", NULL, "0", "0", "82.102.18.58", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.146 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("97", "2", NULL, "2019-04-06 23:53:36", NULL, "0", "0", "82.102.18.146", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("98", "2", NULL, "2019-04-06 23:53:38", NULL, "0", "0", "82.102.18.139", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("99", "2", NULL, "2019-04-07 00:01:41", NULL, "0", "0", "185.189.113.38", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("100", "2", NULL, "2019-04-07 09:02:44", NULL, "0", "0", "185.130.184.208", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 Kinza/4.9.1", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("101", "2", NULL, "2019-04-08 12:42:00", NULL, "0", "0", "82.102.18.48", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64 (Edition Yx)", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("102", "2", NULL, "2019-04-08 12:42:00", NULL, "0", "0", "82.102.18.144", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("103", "2", NULL, "2019-04-08 16:23:04", NULL, "0", "0", "185.189.113.46", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("104", "2", NULL, "2019-04-08 19:33:04", NULL, "0", "0", "200.62.70.156", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1997", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("105", "2", NULL, "2019-04-08 19:35:03", NULL, "0", "0", "200.62.70.156", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1997", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("106", "2", NULL, "2019-04-09 11:14:12", NULL, "0", "0", "185.17.149.180", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("107", "2", NULL, "2019-04-09 11:19:03", NULL, "0", "0", "82.102.18.132", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("108", "2", NULL, "2019-04-09 13:21:01", NULL, "0", "0", "185.130.184.212", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("109", "2", NULL, "2019-04-09 20:07:26", NULL, "0", "0", "185.130.184.222", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("110", "2", NULL, "2019-04-09 23:14:45", NULL, "0", "0", "80.252.153.33", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("111", "2", NULL, "2019-04-10 13:58:39", NULL, "0", "0", "80.252.153.33", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("112", "2", NULL, "2019-04-11 04:14:47", NULL, "0", "0", "185.189.113.42", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("113", "2", NULL, "2019-04-11 04:54:46", NULL, "0", "0", "185.130.184.251", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("114", "2", NULL, "2019-04-11 05:37:00", NULL, "0", "0", "185.130.184.227", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("115", "2", NULL, "2019-04-11 13:02:22", NULL, "0", "0", "185.130.184.222", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("116", "2", NULL, "2019-04-12 07:13:23", NULL, "0", "0", "5.188.44.47", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("117", "2", NULL, "2019-04-12 18:29:32", NULL, "0", "0", "185.130.184.223", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("118", "2", NULL, "2019-04-12 18:29:32", NULL, "0", "0", "185.130.184.209", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("119", "2", NULL, "2019-04-12 18:30:25", NULL, "0", "0", "185.130.184.212", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("120", "2", NULL, "2019-04-14 22:59:13", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("121", "2", NULL, "2019-04-15 00:00:44", NULL, "0", "0", "185.130.184.224", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("122", "2", NULL, "2019-04-15 02:55:20", NULL, "0", "0", "185.130.184.223", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("123", "2", NULL, "2019-04-15 19:59:20", NULL, "0", "0", "185.17.149.185", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("124", "2", NULL, "2019-04-15 21:30:01", NULL, "0", "0", "185.130.184.224", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("125", "2", NULL, "2019-04-15 21:30:01", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("126", "2", NULL, "2019-04-16 19:47:55", NULL, "0", "0", "185.17.149.185", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("127", "2", NULL, "2019-04-16 20:21:58", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("128", "2", NULL, "2019-04-16 20:40:30", NULL, "0", "0", "185.130.184.224", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("129", "2", NULL, "2019-04-17 22:33:21", NULL, "0", "0", "109.184.168.158", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("130", "2", NULL, "2019-04-18 21:50:01", NULL, "0", "0", "82.102.18.55", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("131", "2", NULL, "2019-04-18 23:05:51", NULL, "0", "0", "185.17.149.137", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("132", "2", NULL, "2019-04-18 23:39:32", NULL, "0", "0", "185.189.113.46", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("133", "2", NULL, "2019-04-19 01:12:22", NULL, "0", "0", "108.62.3.46", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("134", "2", NULL, "2019-04-19 05:48:11", NULL, "0", "0", "185.130.184.238", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("135", "2", NULL, "2019-04-19 21:24:20", NULL, "0", "0", "82.208.100.223", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("136", "2", NULL, "2019-04-20 14:10:09", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("137", "2", NULL, "2019-04-20 16:53:26", NULL, "0", "0", "185.130.184.217", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("138", "2", NULL, "2019-04-21 03:19:14", NULL, "0", "0", "185.104.184.116", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("139", "2", NULL, "2019-04-21 06:04:04", NULL, "0", "0", "82.102.18.61", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("140", "2", NULL, "2019-04-22 18:36:42", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("141", "2", NULL, "2019-04-22 18:36:44", NULL, "0", "0", "185.130.184.235", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("142", "2", NULL, "2019-04-22 21:23:18", NULL, "0", "0", "185.130.184.252", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("143", "2", NULL, "2019-04-23 01:33:18", NULL, "0", "0", "185.104.184.116", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("144", "2", NULL, "2019-04-24 13:30:38", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("145", "2", NULL, "2019-04-24 13:30:39", NULL, "0", "0", "185.130.184.252", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("146", "2", NULL, "2019-04-24 16:05:35", NULL, "0", "0", "185.130.184.235", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("147", "2", NULL, "2019-04-24 16:25:38", NULL, "0", "0", "185.104.184.116", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("148", "2", NULL, "2019-04-24 21:32:32", NULL, "0", "0", "71.234.56.184", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Safari/605.1.15", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("149", "2", NULL, "2019-04-25 20:20:47", NULL, "0", "0", "185.130.184.231", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("150", "2", NULL, "2019-04-25 20:20:48", NULL, "0", "0", "185.130.184.206", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("151", "2", NULL, "2019-04-25 21:03:34", NULL, "0", "0", "82.102.18.150", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("152", "2", NULL, "2019-04-26 06:14:32", NULL, "0", "0", "207.189.0.73", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64 (Edition Yx)", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("153", "2", NULL, "2019-04-27 18:09:12", NULL, "0", "0", "185.189.113.44", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 Kinza/4.9.1", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("154", "2", NULL, "2019-04-27 18:09:16", NULL, "0", "0", "82.102.18.131", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("155", "2", NULL, "2019-04-27 19:46:21", NULL, "0", "0", "31.184.238.190", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("156", "2", NULL, "2019-04-27 20:00:29", NULL, "0", "0", "82.102.18.54", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("157", "2", NULL, "2019-04-28 02:57:07", NULL, "0", "0", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("158", "2", NULL, "2019-04-28 19:11:56", NULL, "0", "0", "109.184.249.125", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("159", "2", NULL, "2019-04-29 11:24:16", NULL, "0", "0", "185.17.149.135", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("160", "2", NULL, "2019-04-29 11:24:18", NULL, "0", "0", "185.17.149.170", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.75 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("161", "2", NULL, "2019-04-29 11:36:48", NULL, "0", "0", "207.189.0.85", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("162", "2", NULL, "2019-04-29 19:25:22", NULL, "0", "0", "5.188.44.47", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("163", "2", NULL, "2019-04-30 22:16:42", NULL, "0", "0", "185.189.113.42", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.99", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("164", "2", NULL, "2019-05-01 10:46:16", NULL, "0", "0", "207.189.0.85", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("165", "2", NULL, "2019-05-01 10:59:10", NULL, "0", "0", "185.17.149.170", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("166", "2", NULL, "2019-05-02 03:29:30", NULL, "0", "0", "185.130.184.199", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 Kinza/4.9.1", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("167", "2", NULL, "2019-05-02 19:23:50", NULL, "0", "0", "185.130.184.228", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("168", "2", NULL, "2019-05-03 00:44:15", NULL, "0", "0", "91.79.29.211", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("169", "2", NULL, "2019-05-03 07:57:04", NULL, "0", "0", "207.189.0.85", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("170", "2", NULL, "2019-05-03 08:20:43", NULL, "0", "0", "185.17.149.170", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("171", "2", NULL, "2019-05-03 18:35:27", NULL, "0", "0", "117.97.141.176", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 5.1; rv:50.0) Gecko/20100101 Firefox/50.0", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("172", "2", NULL, "2019-05-04 09:58:34", NULL, "0", "0", "207.189.0.88", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("173", "2", NULL, "2019-05-04 11:36:26", NULL, "0", "0", "207.189.0.85", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("174", "2", NULL, "2019-05-04 12:03:15", NULL, "0", "0", "5.188.44.47", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("175", "2", NULL, "2019-05-04 14:30:50", NULL, "0", "0", "185.189.113.46", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("176", "2", NULL, "2019-05-04 17:15:51", NULL, "0", "0", "185.189.113.34", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("177", "2", NULL, "2019-05-06 08:34:07", NULL, "0", "0", "185.130.184.208", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("178", "2", NULL, "2019-05-06 10:24:17", NULL, "0", "0", "207.189.0.88", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36 OPR/55.0.2994.44", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("179", "2", NULL, "2019-05-06 14:55:12", NULL, "0", "0", "204.156.166.100", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("180", "2", NULL, "2019-05-06 16:26:33", NULL, "0", "0", "185.130.184.218", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("181", "2", NULL, "2019-05-07 04:12:24", NULL, "0", "0", "109.184.241.30", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("182", "2", NULL, "2019-05-07 05:01:17", NULL, "0", "0", "185.130.184.215", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("183", "2", NULL, "2019-05-08 00:54:15", NULL, "0", "0", "185.130.184.215", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("184", "2", NULL, "2019-05-08 00:54:15", NULL, "0", "0", "185.189.113.40", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("185", "2", NULL, "2019-05-08 00:54:15", NULL, "0", "0", "185.130.184.214", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("186", "2", NULL, "2019-05-08 09:35:02", NULL, "0", "0", "146.196.38.104", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:37.0) Gecko/20100101 Firefox/37.0", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("187", "2", NULL, "2019-05-08 10:38:00", NULL, "0", "0", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("188", "2", NULL, "2019-05-10 06:39:49", NULL, "0", "0", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("189", "2", NULL, "2019-05-10 06:50:23", NULL, "0", "0", "185.130.184.214", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("190", "2", NULL, "2019-05-10 08:40:23", NULL, "0", "0", "185.130.184.204", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("191", "2", NULL, "2019-05-11 19:37:50", NULL, "0", "0", "185.130.184.204", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("192", "2", NULL, "2019-05-11 19:37:51", NULL, "0", "0", "207.189.0.86", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("193", "2", NULL, "2019-05-11 20:36:00", NULL, "0", "0", "185.17.149.187", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("194", "2", NULL, "2019-05-11 21:23:02", NULL, "0", "0", "31.184.238.190", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("195", "2", NULL, "2019-05-12 02:12:06", NULL, "0", "0", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("196", "2", NULL, "2019-05-13 02:51:52", NULL, "0", "0", "5.188.44.47", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("197", "2", NULL, "2019-05-13 08:14:28", NULL, "0", "0", "185.17.149.187", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("198", "2", NULL, "2019-05-13 09:11:00", NULL, "0", "0", "185.130.184.204", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("199", "2", NULL, "2019-05-13 11:18:28", NULL, "0", "0", "207.189.0.86", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.71", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("200", "2", NULL, "2019-05-13 14:31:14", NULL, "0", "0", "71.167.178.172", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("201", "2", NULL, "2019-05-13 15:55:46", NULL, "0", "0", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.64", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("202", "2", NULL, "2019-05-13 19:32:19", NULL, "0", "0", "109.184.186.138", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("203", "2", NULL, "2019-05-13 20:19:30", NULL, "0", "0", "170.228.37.10", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("204", "2", NULL, "2019-05-14 12:59:29", NULL, "0", "0", "49.83.19.70", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("205", "2", NULL, "2019-05-14 18:21:29", NULL, "0", "0", "109.184.186.138", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.54", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("206", "2", NULL, "2019-05-14 19:56:12", NULL, "0", "0", "109.184.186.138", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36 Edge/16.16299", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("207", "2", NULL, "2019-05-14 20:28:16", NULL, "0", "0", "207.189.0.86", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.181 Safari/537.36 Kinza/4.7.2", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("208", "2", NULL, "2019-05-14 23:36:41", NULL, "0", "0", "185.189.113.38", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("209", "2", NULL, "2019-05-15 01:23:42", NULL, "0", "0", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("210", "2", NULL, "2019-05-15 04:37:57", NULL, "0", "0", "207.189.0.74", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36 OPR/54.0.2952.51", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("211", "2", NULL, "2019-05-15 19:44:34", NULL, "0", "0", "91.193.252.250", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("212", "2", NULL, "2019-05-16 07:20:11", NULL, "0", "0", "208.196.3.108", "https://westchesterstairlift.com/?msclkid=088b516ba351134d86910db6aedfe954&utm_source=bing&utm_medium=cpc&utm_campaign=Campaign+%231+Westchester+area&utm_term=stairlifts&utm_content=Ad+group+%231+STAI", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; Trident/7.0; rv:11.0) like Gecko", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("213", "2", NULL, "2019-05-17 10:25:14", NULL, "0", "0", "185.130.184.213", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("214", "2", NULL, "2019-05-17 11:34:48", NULL, "0", "0", "207.189.0.86", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("215", "2", NULL, "2019-05-17 11:34:49", NULL, "0", "0", "207.189.0.74", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.79 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("216", "2", NULL, "2019-05-18 04:09:42", NULL, "0", "1", "74.88.148.135", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("217", "2", NULL, "2019-05-18 04:12:59", NULL, "0", "0", "74.88.148.135", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("218", "2", NULL, "2019-05-19 09:35:03", NULL, "0", "0", "185.104.184.119", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/66.0.3359.170 Safari/537.36 OPR/53.0.2907.68", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("219", "2", NULL, "2019-05-19 09:35:09", NULL, "0", "0", "207.189.0.88", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("220", "2", NULL, "2019-05-19 10:32:09", NULL, "0", "0", "207.189.0.74", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.99 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("221", "2", NULL, "2019-05-19 16:45:19", NULL, "0", "1", "185.130.184.246", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("222", "2", NULL, "2019-05-20 04:32:27", "2019-05-20 04:32:27", "0", "0", "74.88.148.135", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 OPR/58.0.3135.132", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("223", "2", NULL, "2019-05-20 04:36:56", "2019-05-20 04:36:56", "0", "0", "74.88.148.135", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 OPR/58.0.3135.132", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("224", "2", NULL, "2019-05-20 04:39:13", "2019-05-20 04:39:13", "0", "0", "74.88.148.135", "https://westchesterstairlift.com/", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36 OPR/58.0.3135.132", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("225", "2", NULL, "2019-06-02 16:44:18", "2019-06-02 16:44:18", "0", "0", "24.151.99.133", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36 Edge/17.17134", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("226", "2", NULL, "2019-06-06 17:49:19", "2019-06-06 17:49:19", "0", "0", "184.74.191.181", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; Trident/7.0; rv:11.0) like Gecko", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("227", "2", NULL, "2019-06-10 09:02:23", "2019-06-10 09:02:23", "0", "0", "182.64.99.175", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 6.1; rv:47.0) Gecko/20100101 Firefox/47.0", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("228", "2", NULL, "2019-06-26 14:33:36", "2019-06-26 14:33:36", "0", "0", "200.62.70.156", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36", "USD", NULL, NULL, NULL, NULL, NULL, NULL, "1997", NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("229", "1", "4850", "2019-06-28 01:55:42", "2019-06-28 01:55:42", "0", "0", "68.132.207.8", "https://westchesterstairlift.com/reviews/", "Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("230", "2", NULL, "2019-06-29 23:49:43", "2019-06-29 23:49:43", "0", "0", "173.2.44.248", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");
INSERT INTO `wp_gf_entry` VALUES("231", "2", NULL, "2019-07-15 08:34:33", "2019-07-15 08:34:33", "0", "0", "24.186.19.196", "https://westchesterstairlift.com/contacts/", "Mozilla/5.0 (iPhone; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/16A366 Safari/604.1", "USD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active");

/* INSERT TABLE DATA: wp_gf_entry_meta */
INSERT INTO `wp_gf_entry_meta` VALUES("1", "1", "1", "1", "Kenny L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("2", "1", "1", "2", "The stair lifts work very well\r\nThe stair lifts work very well. Quiet and simple to use. We chose the electric seat swivel &amp; auto foot test lowering options and we were happy that we did. My mother is 90, she learned to use the system without help in a couple of weeks.\r\nThe Local Dealer was fantastic. They completed the installation as promised without much inconvenience to our daily routines. We highly recommend the Bruno product and it’s dealers.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("4", "1", "2", "1", "Jang", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("5", "1", "2", "4", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("6", "1", "2", "2", "Test Review", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("18", "1", "5", "2", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("8", "1", "3", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("9", "1", "3", "4", "Smartsite", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("10", "1", "3", "2", "smart review", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("17", "1", "5", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("12", "1", "4", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("13", "1", "4", "4", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("14", "1", "4", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("16", "1", "5", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("20", "1", "6", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("21", "1", "6", "4", "test@test.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("22", "1", "6", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("42", "1", "11", "2", "This is test review.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("24", "1", "7", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("25", "1", "7", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("26", "1", "7", "2", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("28", "1", "8", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("29", "1", "8", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("30", "1", "8", "2", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("41", "1", "11", "4", "This is test title.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("32", "1", "9", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("33", "1", "9", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("34", "1", "9", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("36", "1", "10", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("37", "1", "10", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("38", "1", "10", "2", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("40", "1", "11", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("43", "1", "11", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("44", "1", "12", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("45", "1", "12", "4", "Smartsite", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("46", "1", "12", "2", "This is test review from the smart site.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("47", "1", "12", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("48", "1", "13", "1", "Kenny L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("49", "1", "13", "4", "The stair lifts work very well", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("50", "1", "13", "2", "The stair lifts work very well. Quiet and simple to use. We chose the electric seat swivel &amp; auto foot test lowering options and we were happy that we did. My mother is 90, she learned to use the system without help in a couple of weeks.\r\nThe Local Dealer was fantastic. They completed the installation as promised without much inconvenience to our daily routines. We highly recommend the Bruno product and it’s dealers.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("51", "1", "13", "6", "grating617fed236", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("52", "1", "14", "1", "Ishor", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("53", "1", "14", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("54", "1", "14", "2", "Teset", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("55", "1", "14", "6", "grating6107a7d25", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("56", "1", "15", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("57", "1", "15", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("58", "1", "15", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("59", "1", "15", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("60", "1", "16", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("61", "1", "16", "4", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("62", "1", "16", "2", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("63", "1", "16", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("64", "1", "17", "1", "Test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("65", "1", "17", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("66", "1", "17", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("67", "1", "17", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("68", "1", "18", "1", "Ishor 123", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("69", "1", "18", "4", "Test 12345", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("70", "1", "18", "2", "Testtretr", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("71", "1", "18", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("72", "1", "19", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("73", "1", "19", "4", "alemagarishor@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("74", "1", "19", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("75", "1", "19", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("76", "1", "20", "1", "Smart sitegfgdfgdfg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("77", "1", "20", "4", "alemagarishor@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("78", "1", "20", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("79", "1", "20", "6", "grating6c43de000", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("80", "1", "21", "1", "Smart site Final test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("81", "1", "21", "4", "fdsfsdfsdf", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("82", "1", "21", "2", "fdsfsdfsdfsdfsdfsdfsd", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("83", "1", "21", "6", "grating6107a7d25", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("84", "1", "22", "1", "Smart sitefdhgdfsh", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("85", "1", "22", "4", "hdgsgd", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("86", "1", "22", "2", "fhfghfghfgh", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("87", "1", "22", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("88", "1", "23", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("89", "1", "23", "4", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("90", "1", "23", "2", "ytryrrtyrtytyrtyrttyrtyrtyrty", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("91", "1", "23", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("92", "1", "24", "1", "Smart sitefgdgfdgdfgdfgdfgdf", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("93", "1", "24", "4", "ss.dev.n020@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("94", "1", "24", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("95", "1", "24", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("96", "1", "25", "1", "Smart site", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("97", "1", "25", "4", "alemagarishor@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("98", "1", "25", "2", "sdsgg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("99", "1", "25", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("100", "1", "26", "1", "Kenny L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("101", "1", "26", "4", "The stair lifts work very well", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("102", "1", "26", "2", "The stair lifts work very well. Quiet and simple to use. We chose the electric seat swivel &amp; auto foot test lowering options and we were happy that we did. My mother is 90, she learned to use the system without help in a couple of weeks.\r\nThe Local Dealer was fantastic. They completed the installation as promised without much inconvenience to our daily routines. We highly recommend the Bruno product and it’s dealers.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("103", "1", "26", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("104", "1", "27", "1", "Mary Kelley", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("105", "1", "27", "4", "We got this Bruno chairlift for my 93…", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("106", "1", "27", "2", "We got this Bruno chairlift for my 93 yr. old mother-in-law, it\'s only 6 steps, but it\'s helped her be more sociable and independant when people are here. It was ordered and installed in a few days. It\'s quiet and seems solidly well built. We expect to have many years of usage and intend on installing 2 more to make staying in our home possible when we retire! And the salesman and installers were correct - our grandchildren have no interest in riding it!", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("107", "1", "27", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("108", "1", "28", "1", "EDGAR MACDONALD", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("109", "1", "28", "4", "THIS LIFT IS EASY TO USE", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("110", "1", "28", "2", "THIS LIFT IS EASY TO USE, SMOOTH RIDE, AND A GREAT TRANSPORT DEVICE !!!!!!!! MY WIFE USED IT TO TRANSPORT ALL OUR MOVING BOXES TO THE UPSTAIRS ROOMS, AND OUR PLUMBER ALSO USED IT TO TRANSPORT OUR NEW TOILET TO THE UPSTAIRS BATH ROOM!!!!!!!!!!!!!!!!!!!! \r\n\r\nOUR DEALER PROVIDED EXCELLENT INSTALLATION AND CLEANUP.\r\n\r\nYOU CANNOT GO WRONG BY SELECTING THIS LIFT FOR YOUR HOME !!!!!!!!!!!!\r\n\r\n\r\nEDGAR MACDONALD LEXINGTON, KY", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("111", "1", "28", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("112", "1", "29", "1", "L.Custer", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("113", "1", "29", "4", "Excellent", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("114", "1", "29", "2", "Excellent - so much better than my old Acorn stairlift", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("115", "1", "29", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("116", "1", "30", "1", "Irina", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("117", "1", "30", "4", "Testing", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("118", "1", "30", "2", "hhrh hehgerdh ergherherh", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("119", "1", "30", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("120", "2", "31", "2", "7", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("123", "2", "31", "5", "gg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("124", "2", "31", "6", "ggg", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("125", "2", "32", "2", "devteam05", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("128", "2", "32", "5", "11.45", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("129", "2", "32", "6", "Test message please ignore.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("130", "1", "33", "1", "Smart Sites for test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("131", "1", "33", "4", "Smart Sites, Just for test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("132", "1", "33", "2", "This is just for test.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("133", "1", "33", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("134", "1", "34", "1", "Smart Sites for test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("135", "1", "34", "4", "Smart Sites, Just for test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("136", "1", "34", "2", "Just for test.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("137", "1", "34", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("138", "2", "35", "2", "test chrome", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("140", "2", "35", "5", "any time", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("141", "2", "35", "6", "tttlllttttttt..\' no phone", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("142", "2", "36", "2", "Irina Mircica", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("145", "2", "36", "6", "uguhlkh", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("146", "2", "37", "2", "Martin Friedrichs", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("149", "2", "37", "5", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("150", "2", "37", "6", "test two", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("151", "2", "38", "2", "John doe", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("154", "2", "38", "5", "Friday after 6pm", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("155", "2", "38", "6", "Teset", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("156", "2", "39", "2", "Martin Friedrichs", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("159", "2", "39", "5", "test 1", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("160", "2", "39", "6", "this is a test by martin\r\nffhfhfh\r\nffsfsdzfsd\r\ngfdffd\r\nbv", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("161", "1", "40", "1", "Kelly O. in Brooklyn, NY", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("162", "1", "40", "4", "Install a Chair Lift", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("163", "1", "40", "2", "Every aspect of this project went smoothly. Which is very rare. Jonathon was one of the first companies to return my call - he explained everything and was able to give me as estimate over the phone. I was very worried about the stairlift being able to fit and if it was going to run off the existing outlets in the house. He put me at ease. He worked around my schedule. The engineer, Sheik, could not have been more skilled and professional. The whole install took around 3 hours. Sheik was a pleasure to work with and was also so organized and neat! Very reasonanble price. Would highly recommend.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("164", "1", "40", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("165", "1", "41", "1", "Sheila J. White Plains, NY", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("166", "1", "41", "4", "Westchester Stairlift is a great company", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("167", "1", "41", "2", "Westchester Stairlift is a great company. From the initial consultation with Martin Friedrichs to the installation of the lifts, by Reggie Edwards, the entire process went smoothly. They are a professional company that was on time and on point with the installation. Needless to say, my brothers and I are grateful for the work that they did for our parents.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("168", "1", "41", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("169", "1", "42", "1", "Smartsites", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("170", "1", "42", "4", "WestchesterStairlift", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("171", "1", "42", "2", "just for test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("172", "1", "42", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("173", "2", "43", "2", "Sarah Dillon", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("176", "2", "43", "5", "anytime", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("177", "2", "43", "6", "Need quote for my father in law who lives in Mamaroneck. They have an old Victorian home with a curved staircase.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("178", "2", "44", "2", "puskar", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("181", "2", "44", "5", "4pm", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("182", "2", "44", "6", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("183", "2", "45", "2", "puskar1", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("186", "2", "45", "5", "5", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("187", "2", "45", "6", "good", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("188", "2", "46", "2", "Savnnaah White", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("191", "2", "46", "6", "Hi,\r\nAs you know, we\'re giving companies like yours free trainings as we build up testimonials in the market.\r\n\r\nBasically we can teach you how to get more sales and leads using funnels with westchesterstairlift.com\r\n\r\nGet your training here:\r\n \r\nhttps://funnelmaster.site/funnels?=westchesterstairlift.com\r\n\r\nSincerely,\r\nSavnnaah W\r\n500 Westover Dr #12733\r\nSanford, NC 27330\r\n\r\n\r\n\r\n\r\nNot interested in ads about trainings? You can skip future messages here:\r\nhttps://funnelmaster.site/out.php?site=westchesterstairlift.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("192", "2", "47", "2", "Grace Roberts", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("195", "2", "47", "6", "I see your doing great things with your website, but like I said if you had more traffic, could you handle it? \r\n\r\nWe run a global advertising network that can drive more traffic for you.  \r\n\r\nDo you want more traffic?\r\n\r\nhttps://maxpromo.icu/traffic?=westchesterstairlift.com\r\n\r\nGrace\r\nmaxpromo.icu\r\n\r\n\r\n\r\n\r\n\r\n361 Southwest Drive Suite #731 Jonesboro, AR 72401\r\n\r\nIf you don\'t want to receive future ad messages about traffic, you can avoid them here:  https://maxpromo.icu/unsubscribe.php?site=westchesterstairlift.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("196", "2", "48", "2", "Bob Capurso", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("199", "2", "48", "5", "anytime", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("200", "2", "48", "6", "I spoke to Martin on Saturday regarding a stair lift for my mom\'s Co-op in Yonkers.\r\n\r\nCan you send me some info about your stair lift that I can submt to the Co-op Board?\r\n\r\nThank you.\r\nBob", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("201", "2", "49", "2", "Judson Troup", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("204", "2", "49", "6", "Hi there\r\n \r\nI just checked out your website westchesterstairlift.com and wanted to find out if you need help getting Organic Traffic & Quality Traffic that Buys From You or Converts into Highly Responsive Subscribers ?\r\n \r\nI have 2 promotions for you, read the instructions carefully and choose what is best for you ...\r\n1. Google Organic Traffic => http://bit.ly/Organic_Traffic_From_Google\r\n2. Traffic that Converts  =>  http://bit.ly/Traffic_that_Converts\r\n \r\nDo not forget to read Review to convince you !\r\n \r\nRegards,\r\nTroup\r\n \r\n \r\nUNSUBSCRIBE or REPORT SPAM\r\nATTENTION: sends domain:  westchesterstairlift.com , not email address !!\r\nSEND your domain site here ==>  your-site@myself.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("205", "1", "50", "1", "Helen C.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("206", "1", "50", "4", "Great job", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("207", "1", "50", "2", "Having a Westchester Stairlift in my home has been wonderful. It has greatly enhanced my quality of life. The product is excellent and has never failed me. \r\n\r\nThe Westchester Stairlift representatives are always courteous, professional and knowledgeable. If I call with a question, I always get a call back the same day!\r\n\r\nI highly recommend the Westchester Stairlift. I give them 5 stars!", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("208", "1", "50", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("209", "2", "51", "2", "Eric", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("212", "2", "51", "6", "Hello,\r\n\r\nYou have a website, right? \r\n  \r\nOf course you do. I found westchesterstairlift.com today.\r\n\r\nIt gets traffic every day – that you’re probably spending $2 / $4 / $10 or more a click to get.  Not including all of the work you put into creating social media, videos, blog posts, emails, and so on.\r\n\r\nSo you’re investing seriously in getting people to that site.\r\n\r\nBut how’s it working?  Great? Okay?  Not so much?\r\n\r\nIf that answer could be better, then it’s likely you’re putting a lot of time, effort, and money into an approach that’s not paying off like it should.\r\n\r\nNow… imagine doubling your lead conversion in just minutes… In fact, I’ll go even better.\r\n \r\nYou could actually get up to 100X more conversions!\r\n\r\nI’m not making this up.  As Chris Smith, best-selling author of The Conversion Code says:\r\n-Speed is essential - there is a 100x decrease in Leads when a Lead is contacted within 14 minutes vs being contacted within 5 minutes.\r\n\r\nHe’s backed up by a study at MIT that found the odds of contacting a lead will increase by 100 times if attempted in 5 minutes or less.\r\n\r\nAgain, out of the 100s of visitors to your website, how many actually call to become clients?\r\n\r\nWell, you can significantly increase the number of calls you get – with ZERO extra effort.\r\n\r\nOur software, Talk With Customer, makes it easy, simple, and fast – in fact, you can start getting more calls today… and at absolutely no charge to you.\r\n\r\nCLICK HERE http://www.talkwithcustomer.com to find out how.\r\n\r\nSincerely,\r\n\r\nEric Jones\r\n\r\nPS: Don’t just take my word for it, TalkWithCustomer works:\r\n-EMA has been looking for ways to reach out to an audience. TalkWithCustomer so far is the most direct call of action. It has produced above average closing ratios and we are thrilled. Thank you for providing a real and effective tool to generate REAL leads. - Patrick MontesDeOca, Ema2Trade\r\n\r\nBest of all, act now to get a no-cost 14-Day Test Drive – our gift to you just for giving TalkWithCustomer a try. \r\n\r\nCLICK HERE http://www.talkwithcustomer.com to start converting up to 100X more leads today!\r\n\r\n\r\nIf you\'d like to unsubscribe click here. http://liveserveronline.com/talkwithcustomer.aspx?d=westchesterstairlift.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("213", "1", "52", "1", "Desi Scheck  Flushing", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("214", "1", "52", "4", "Thanks again", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("215", "1", "52", "2", "Before you forget who we are, I\'m Desi Scheck and your guys installed a stairchair for my motherinlaw last month in flushing queens.  I wanted you to know the guy who came to do the installation was simply one of the nicest and most informative service men I\'ve encountered. He spoke slowly and clearly, explained every detail and answered every question that my husband and his parents had.  I would certainly recommend Bruno and when I have some time I will write an online review. Thanks again. Desi", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("216", "1", "52", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("217", "1", "53", "1", "David and Martha Geller  - Nanuet", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("218", "1", "53", "4", "I could not be happier", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("219", "1", "53", "2", "It\'s been about a year and a half since Mom and I purchased a Bruno Stairlift from you guys at Westchester Stairlift.  I\'m 57 years old and I\'ve purchased a lot of things in my life, but I don\'t think I have ever been as satisfied with a purchase as I have with this stairlift.  It really is a rock!  Very reliable.  But of course, you know that already.  I just wanted to thank you again for helping Mom and me with a very important decision.  Simply put ... I could not be happier.  Please let me know if you ever need a recommendation.\r\n\r\nAnyway, a while back, you had sent me a .75 oz. tube of Lubriplate.  I never applied it, but plan to do so this week.  I plan to first wipe and clean the \"gear rail\" off with a t-shirt and then apply the lube by smearing with a rubber glove.  Does that sound ok?  Also, I don\'t want to over apply.  Should I use the entire tube?  Please let me know if you have any other suggestions for routine maintenance.  I know the batteries will probably need some attention in the near future.  Hope you are well and \r\nThank you, \r\nDavid and Martha Geller", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("220", "1", "53", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("221", "1", "54", "1", "Calise    Plainview", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("222", "1", "54", "4", "Just how I wanted it.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("223", "1", "54", "2", "They were professional; they came out and installed the lift just how I wanted it. They were great people and did a wonderful job.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("224", "1", "54", "6", "grating6c73f2247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("225", "2", "55", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("228", "2", "55", "5", "stjg1994@ail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("229", "2", "55", "6", "Forex Trader predicts and makes $10,000 less than 3 hours: http://rih.co/15000investbinarycrypto60099", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("230", "2", "56", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("233", "2", "56", "5", "cefch@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("234", "2", "56", "6", "Sexy girls for the night in your town: http://www.vkvi.net/adultdating31159", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("235", "2", "57", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("238", "2", "57", "5", "annie207@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("239", "2", "57", "6", "Beautiful girls for sex in your city: http://jnl.io/adultdating49247", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("240", "2", "58", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("243", "2", "58", "5", "bentex@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("244", "2", "58", "6", "Wie man aus в‚¬ 3.000 в‚¬ 128.000 macht: http://to.ht/bestinvestcrepto59940", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("245", "2", "59", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("248", "2", "59", "5", "sinned1973@address.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("249", "2", "59", "6", "J\'ai 23 000 в‚¬. Comment l\'utiliser au mieux pour gagner plus d\'argent: https://lil.ink/bestinvestcrepto54734", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("250", "2", "60", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("253", "2", "60", "5", "beautylois@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("254", "2", "60", "6", "10 Best Cryptocurrency to Invest in 2019: http://www.lookweb.it/bestinvestcrepto59197", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("255", "2", "61", "2", "reklamajax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("258", "2", "61", "5", "semizhonowakseniya199639@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("259", "2", "61", "6", "<a href=http://moriart-nn.ru>наружная реклама изготовление</a>  - подробнее на сайте алмазного бурения <a href=http://moriart-nn.ru/>moriart-nn.ru</a>", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("260", "2", "62", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("263", "2", "62", "5", "chrisjones70@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("264", "2", "62", "6", "How to Turn $30,000 into $128,000: http://to.ht/bestinvestcrepto11109", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("265", "2", "63", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("268", "2", "63", "5", "wmnwheels@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("269", "2", "63", "6", "Filles sexy pour la nuit dans votre ville: http://www.lookweb.it/bestadultdating85531", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("270", "2", "64", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("273", "2", "64", "5", "brogaard@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("274", "2", "64", "6", "Suchen Sie sich ein MГ¤dchen fГјr die Nacht in Ihrer Stadt: https://lil.ink/bestadultdating56598", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("275", "2", "65", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("278", "2", "65", "5", "crystal@barkerrealtors.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("279", "2", "65", "6", "Conoce chicas sexy en tu ciudad: http://webhop.se/bestadultdating77153", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("280", "2", "66", "2", "Irenbut", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("283", "2", "66", "5", "iren_24@mail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("284", "2", "66", "6", "Hello, I want to work in your company on a voluntary basis, can you offer me anything? \r\na little about me: https://about.me/iren", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("285", "2", "67", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("288", "2", "67", "5", "coner_18@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("289", "2", "67", "6", "Sexy girls for the night in your town: http://www.vkvi.net/bestadultdating86076", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("290", "2", "68", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("293", "2", "68", "5", "ai1ec-20779@www.theportlandarms.co.uk", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("294", "2", "68", "6", "Beautiful women for sex in your town: http://valeriemace.co.uk/adultdatinginyourcity33460", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("295", "2", "69", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("298", "2", "69", "5", "beach_bum123@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("299", "2", "69", "6", "Beautiful women for sex in your town: http://www.lookweb.it/bestadultdating38710", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("300", "2", "70", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("303", "2", "70", "5", "dx33@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("304", "2", "70", "6", "Beautiful women for sex in your town: http://rih.co/adultdatinginyourcity53535", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("305", "2", "71", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("308", "2", "71", "5", "mlbags@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("309", "2", "71", "6", "The best girls for sex in your town: http://webhop.se/bestadultdating21574", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("310", "2", "72", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("313", "2", "72", "5", "ynax@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("314", "2", "72", "6", "Beautiful girls for sex in your city: http://www.lookweb.it/bestadultdating89422", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("315", "2", "73", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("318", "2", "73", "5", "roja57@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("319", "2", "73", "6", "Beautiful girls for sex in your city: https://aaa.moda/bestadultdating48316", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("320", "2", "74", "2", "HootieFeade", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("323", "2", "74", "5", "pofofedw32f@yandex.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("324", "2", "74", "6", "I like rock bands! I really do! And my favourite yadrock band is Hootie&Blowfish! All band members has reunited to give more than 50 concerts for their fans in 2019! To know more about Hootie&Blowfish in 2019 visit website <a href=https://hootietheblowfishtour.com>Hootie and the Blowfish concert</a>. You won\'t miss concerts this year if you visit the link!", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("325", "2", "75", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("328", "2", "75", "5", "sandrawalz@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("329", "2", "75", "6", "Where to invest $ 3000 once and receive every month from $ 55000: http://valeriemace.co.uk/5000perday57879", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("330", "2", "76", "2", "Timothyrog", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("333", "2", "76", "5", "mitsura76@list.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("334", "2", "76", "6", "Ольга Жунжурова \r\n \r\n<a href=http://www.compromat.ru/page_22434.htm>Ольга Жунжурова</a>", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("335", "2", "77", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("338", "2", "77", "5", "brindee@charter.net", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("339", "2", "77", "6", "Find yourself a girl for the night in your city: http://to.ht/bestadultdating80570", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("340", "2", "78", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("343", "2", "78", "5", "hheater@elthlaw.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("344", "2", "78", "6", "The best women for sex in your town: http://www.lookweb.it/bestadultdating89422", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("345", "2", "79", "2", "krasotannheern", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("348", "2", "79", "5", "konstantinzemlyankin7@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("349", "2", "79", "6", "http://krasotann.ru - курсы маникюра цена  -  подробнее на нашем сайте http://krasotann.ru - krasotann.ru \r\nКурсы парикмахеров, косметологов, визажистов, мастеров ногтевого сервиса (маникюр, педикюр, наращивание ногтей акрилом и гелем), а также обучение различным видам массажа. \r\nОбучение проводится в специально оборудованных классах на профессиональной косметике известных мировых брендов под руководством высококвалифицированных преподавателей, которые обязательно позаботятся о том, чтобы процесс обучения был успешным.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("350", "2", "80", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("353", "2", "80", "5", "aphillco@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("354", "2", "80", "6", "Beautiful women for sex in your town: https://lil.ink/bestadultdating41801", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("355", "2", "81", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("358", "2", "81", "5", "didierkervrann@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("359", "2", "81", "6", "Sexy girls for the night in your town: http://goto.iamaws.com/bestadultdating98732", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("360", "2", "82", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("363", "2", "82", "5", "simpsonlx8@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("364", "2", "82", "6", "Beautiful women for sex in your town: http://www.lookweb.it/bestadultdating43360", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("365", "2", "83", "2", "Stevefug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("368", "2", "83", "5", "k.kampa@op.pl", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("369", "2", "83", "6", "Hello, \r\n \r\nDownload Club Music For DJs, House, Techno, Trance, Dance, Pop... \r\nhttp://0daymusic.org \r\n \r\nBest regards, \r\nWilliam", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("370", "2", "84", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("373", "2", "84", "5", "chicksncharge2002@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("374", "2", "84", "6", "Find yourself a girl for the night in your city USA: http://www.lookweb.it/bestadultdating76261", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("375", "2", "85", "2", "Avtojax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("378", "2", "85", "5", "razgonovmiroslav19882266@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("379", "2", "85", "6", "Интернет-магазин sbk-torg.ru предлагает купить автомобильные масела, антифроз, тосол, присодки, фильтры, автокосметику, автофильтры, незамерзайку. В наличии на складе в Нижнем Новгороде \r\n \r\n \r\nhttp://sbk-torg.ru/Avtomobilnye-masla/MOTUL.html - motul 7100 4t 10w 40", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("380", "2", "86", "2", "TutuFeade", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("383", "2", "86", "5", "sfofdnar@yandex.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("384", "2", "86", "6", "Today anyone has an iOS tablet. iPods are so widespread that this has led to developing a millions of applications that provide servises such as games, entertainment playgrounds and others. To download any of these applications a user must get an account at Apple Store. But not all programs are available there as they don\'t meet the Apple rules. To avoid this a new app was developed - TutuApp. This helper works on iOS run phones and it has the biggest store of apps. We name a few: Minecraft, Fortnite, Pokemon and many others. They come with zero ads and locked content! Whant to know more? Visit <a href=https://tutuapp-app.com/ios/>https://tutuapp-app.com/ios/</a> to download Tutu App for free on your iOS phone. Installation instructions for the app are available there.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("385", "2", "87", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("388", "2", "87", "5", "j_87@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("389", "2", "87", "6", "Wenn Sie im Jahr 2011 1.000 USD in Bitcoin investiert haben, haben Sie jetzt 4 Millionen USD: http://jnl.io/investcrypto96043", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("390", "2", "88", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("393", "2", "88", "5", "ballandchain2000@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("394", "2", "88", "6", "Hoe te beleggen in bitcoins $ 5000 - krijg een rendement van maximaal 2000%: http://jnl.io/investcrypto49754", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("395", "2", "89", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("398", "2", "89", "5", "leespinks@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("399", "2", "89", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://www.vkvi.net/investcrypto31044", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("400", "2", "90", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("403", "2", "90", "5", "jwpowers@northernacres.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("404", "2", "90", "6", "Invest in mining cryptocurrency $ 5000 once and get passive income of $ 7000 per month: http://webhop.se/investcrypto47526", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("405", "2", "91", "2", "oHrYugxWXBXnbzvrjm", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("408", "2", "91", "5", "ysAEVXJfwEZOiS", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("409", "2", "91", "6", "DE1NBx  <a href=\"http://bnolglmwiyxw.com/\">bnolglmwiyxw</a>, [url=http://boxovcvnvltn.com/]boxovcvnvltn[/url], [link=http://izmttzajegah.com/]izmttzajegah[/link], http://xlronxsythed.com/", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("410", "2", "92", "2", "BusinessCapitalNow", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("412", "2", "92", "5", "noreply@business-capital-now.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("413", "2", "92", "6", "Hi, letting you know that http://Business-Capital-Now.com can find your business a SBA or private loan for $2,000 - $350K Without high credit or collateral. \r\n \r\nFind Out how much you qualify for by clicking here: \r\n \r\nhttp://Business-Capital-Now.com \r\n \r\nMinimum requirements include your company being established for at least a year and with current gross revenue of at least 120K. Eligibility and funding can be completed in as fast as 48hrs. Terms are personalized for each business so I suggest applying to find out exactly how much you can get on various terms. \r\n \r\nThis is a free service from a qualified lender and the approval will be based on the annual revenue of your business. These funds are Non-Restrictive, allowing you to spend the full amount in any way you require including business debt consolidation, hiring, marketing, or Absolutely Any Other expense. \r\n \r\nIf you need fast and easy business funding take a look at these programs now as there is limited availability: \r\n \r\nhttp://Business-Capital-Now.com \r\n \r\nHave a great day, \r\nThe Business Capital Now Team \r\n \r\nunsubscribe/remove - http://business-capital-now.com/r.php?url=westchesterstairlift.com&id=ps06", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("414", "2", "93", "2", "reklamajax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("417", "2", "93", "5", "kashtanovalida878@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("418", "2", "93", "6", "<a href=http://arma-nn.ru>плоская вывеска</a>  - подробнее на сайте алмазного бурения <a href=http://arma-nn.ru/>arma-nn.ru</a>", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("419", "2", "94", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("422", "2", "94", "5", "clara.brusamolino@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("423", "2", "94", "6", "Cryptocurrency Trading & Investing Strategy for 2019. Receive passive income of $ 7,000 per month: https://lil.ink/cryptoinvest99500", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("424", "2", "95", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("427", "2", "95", "5", "austinilikemoney1@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("428", "2", "95", "6", "Invest in mining cryptocurrency $ 5000 once and get passive income of $ 7000 per month: http://www.lookweb.it/cryptoinvest80449", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("429", "2", "96", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("432", "2", "96", "5", "WMMA@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("433", "2", "96", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://www.vkvi.net/cryptoinvest49988", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("434", "2", "97", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("437", "2", "97", "5", "erotel@abacho.de", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("438", "2", "97", "6", "Win an iPhone X | Free Competitions: http://www.vkvi.net/winiphone43542", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("439", "2", "98", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("442", "2", "98", "5", "as60512415@yahoo.com.tw", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("443", "2", "98", "6", "Iphone X Giveaway! Win iPhone for free: http://goto.iamaws.com/winiphone13951", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("444", "2", "99", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("447", "2", "99", "5", "petersen.n.jessica@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("448", "2", "99", "6", "iPhone X Giveaway 2019 - Participate to Win an iPhone X: http://www.lookweb.it/winiphone64681", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("449", "2", "100", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("452", "2", "100", "5", "thepfahlers@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("453", "2", "100", "6", "iPhone XS Giveaway Contest - Enter to Win an iPhone XS Free: http://jnl.io/winiphone77976", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("454", "2", "101", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("457", "2", "101", "5", "jjohnisue@aol.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("458", "2", "101", "6", "Enter to win an iPhone XS Max & AirPods in this free giveaway: http://www.vkvi.net/winiphone42521", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("459", "2", "102", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("462", "2", "102", "5", "clugstone26@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("463", "2", "102", "6", "iPhone XS Giveaway Contest - Enter to Win an iPhone XS Free: http://www.vkvi.net/winiphone22650", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("464", "2", "103", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("467", "2", "103", "5", "jwallwork@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("468", "2", "103", "6", "Now\'s your chance to win a free iPhone X: http://jnl.io/winiphone24603", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("469", "2", "104", "2", "test test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("472", "2", "104", "5", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("473", "2", "104", "6", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("474", "2", "105", "2", "Jose Pedro", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("477", "2", "105", "5", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("478", "2", "105", "6", "test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("479", "2", "106", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("482", "2", "106", "5", "thesachs@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("483", "2", "106", "6", "Meet sexy girls in your city: http://www.lookweb.it/adultdatingincity52220", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("484", "2", "107", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("487", "2", "107", "5", "raquelarriola@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("488", "2", "107", "6", "Beautiful women for sex in your town: https://lil.ink/adultdatingincity23577", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("489", "2", "108", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("492", "2", "108", "5", "clf16@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("493", "2", "108", "6", "Beautiful women for sex in your town: http://webhop.se/adultdatingincity70967", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("494", "2", "109", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("497", "2", "109", "5", "rickstockman@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("498", "2", "109", "6", "The best girls for sex in your town: http://www.lookweb.it/adultdatingincity21430", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("499", "2", "110", "2", "ManuelGoofe", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("502", "2", "110", "5", "albert.tsublov@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("503", "2", "110", "6", "Отзывы Иванчук Максим \r\n \r\nhttps://forum.plastic-surgeon.com.ua/showthread.php?t=234", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("504", "2", "111", "2", "ManuelGoofe", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("507", "2", "111", "5", "albert.tsublov@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("508", "2", "111", "6", "максим иванчук пластический хирург отзывы \r\n \r\nhttps://plastic-surgeon.ru/forum/showthread.php?t=13277", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("509", "2", "112", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("512", "2", "112", "5", "pecoranera4@hotmail.it", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("513", "2", "112", "6", "Beautiful girls for sex in your city: http://www.abcagency.se/adultdatingincity80660", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("514", "2", "113", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("517", "2", "113", "5", "Golf_tanaree@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("518", "2", "113", "6", "The best women for sex in your town: http://www.abcagency.se/adultdatingincity21458", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("519", "2", "114", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("522", "2", "114", "5", "flotqdn@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("523", "2", "114", "6", "Meet sexy girls in your city: http://www.abcagency.se/adultdatingincity26935", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("524", "2", "115", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("527", "2", "115", "5", "lachlaane@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("528", "2", "115", "6", "Beautiful girls for sex in your city: http://rih.co/adultdatingincity53127", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("529", "2", "116", "2", "Keldaxy", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("532", "2", "116", "5", "kelSymn@emaill.host", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("533", "2", "116", "6", "Amoxil 2 Comprar Levitra En Andorra Reactions From Keflex  <a href=http://purchasecial.com>buy generic cialis online</a> Valtrex Cialis 5mg Price Cvs", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("534", "2", "117", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("537", "2", "117", "5", "Sille1984@gmx.de", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("538", "2", "117", "6", "UPDATE: Cryptocurrency Investing Strategy - Q2 2019. Receive passive income of $ 7,000 per month: https://aaa.moda/60874", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("539", "2", "118", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("542", "2", "118", "5", "seducater@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("543", "2", "118", "6", "How to invest in bitcoins $ 5000 - get a return of up to 2000%: http://www.vkvi.net/57653", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("544", "2", "119", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("547", "2", "119", "5", "t.u.rne.r.m.elani.e.2.9.4.6@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("548", "2", "119", "6", "UPDATE: Cryptocurrency Investing Strategy - Q2 2019. Receive passive income of $ 7,000 per month: http://goto.iamaws.com/97984", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("549", "2", "120", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("552", "2", "120", "5", "rasmus123@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("553", "2", "120", "6", "UPDATE: Cryptocurrency Investing Strategy - Q2 2019. Receive passive income of $ 7,000 per month: https://aaa.moda/23424", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("554", "2", "121", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("557", "2", "121", "5", "ericsimmons@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("558", "2", "121", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://goto.iamaws.com/23530", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("559", "2", "122", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("562", "2", "122", "5", "s.brandriet@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("563", "2", "122", "6", "If you invested $1,000 in bitcoin in 2011, now you have $4 million: http://swish.st/32226", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("564", "2", "123", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("567", "2", "123", "5", "chks4u2004@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("568", "2", "123", "6", "Iphone X Giveaway! Win iPhone for free: https://tinyurl.com/winiphonex16393", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("569", "2", "124", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("572", "2", "124", "5", "beth_akerman@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("573", "2", "124", "6", "Win an iPhone X | Free Competitions: http://www.lookweb.it/winiphonex42021", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("574", "2", "125", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("577", "2", "125", "5", "brslvr@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("578", "2", "125", "6", "Win an iPhone X | Free Competitions: http://www.lookweb.it/winiphonex95613", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("579", "2", "126", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("582", "2", "126", "5", "chwange19@aol.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("583", "2", "126", "6", "Sexy girls for the night in your town: http://electromiks.ru/bitrix/rk.php?goto=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("584", "2", "127", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("587", "2", "127", "5", "zoila999@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("588", "2", "127", "6", "Beautiful women for sex in your town: http://www.iceinspace.com.au/iisads/pan/iisclick.php?bannerid=93&zoneid=0&source=&dest=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("589", "2", "128", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("592", "2", "128", "5", "westsiderrider@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("593", "2", "128", "6", "The best women for sex in your town: http://acer.su/go.php?go=https%3A%2F%2Fvk.cc%2F9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("594", "2", "129", "2", "ecojax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("597", "2", "129", "5", "kuzovatkinalyubawa825133@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("598", "2", "129", "6", "http://ecowestplus.ru/Skvazhiny.html - бурение в Нижегородской области", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("599", "2", "130", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("602", "2", "130", "5", "lymulajidoxo@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("603", "2", "130", "6", "Beautiful girls for sex in your city: https://www.abfragen.de/redirect.php?url=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("604", "2", "131", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("607", "2", "131", "5", "ashley0606@arcor.de", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("608", "2", "131", "6", "Beautiful girls for sex in your city: http://caminhoescarreta.com.br/Redirect.aspx?url=https%3A%2F%2Fvk.cc%2F9hUq5L&idPlanoCategoria=74&id=1013", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("609", "2", "132", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("612", "2", "132", "5", "toantintuongvu@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("613", "2", "132", "6", "The best women for sex in your town: http://marineinnovation.ru/redirect?url=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("614", "2", "133", "2", "DEANE", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("617", "2", "133", "5", "Pelecaniformes", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("618", "2", "133", "6", "Good man! \r\n \r\nWe present \r\n \r\nSending your business proposition through the Contact us form which can be found on the sites in the Communication section. Feedback forms are filled in by our software and the captcha is solved. The profit of this method is that messages sent through feedback forms are whitelisted. This technique improve the chances that your message will be read. Mailing is done in the same way as you received this message. \r\nYour   message will be open by millions of site administrators and those who have access to the sites! \r\n \r\nThe cost of sending 1 million messages is $ 49 instead of $ 99. (you can select any country or country domain) \r\nAll USA - (10 million messages sent) - $399 instead of $699 \r\nAll Europe (7 million messages sent)- $ 299 instead of $599 \r\nAll sites in the world (25 million messages sent) - $499 instead of $999 \r\n \r\n \r\nDiscounts are valid until April 20. \r\nFeedback and warranty! \r\nDelivery report! \r\nIn the process of sending messages we don\'t break the rules GDRP. \r\n \r\nThis message is automatically generated to use our contacts for communication. \r\n \r\n \r\n \r\nContact us. \r\nTelegram - @FeedbackFormEU \r\nSkype – FeedbackForm2019 \r\nEmail - FeedbackForm@make-success.com \r\n \r\n \r\nAll the best", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("619", "2", "134", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("622", "2", "134", "5", "bwalker123@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("623", "2", "134", "6", "Beautiful girls for sex in your city: http://www.dvls.tv/goto.php?agency=38&property=0000000559&url=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("624", "2", "135", "2", "gruzjax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("627", "2", "135", "5", "izyumowalyuba198828@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("628", "2", "135", "6", "http://refgruz.ru - автомобиль с манипулятором для доставки груза  - подробнее на сайте аренды манинипуляторовhttp://refgruz.ru - refgruz.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("629", "2", "136", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("632", "2", "136", "5", "tava1@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("633", "2", "136", "6", "The best women for sex in your town: http://static.jiuan.org/uchome/link.php?url=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("634", "2", "137", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("637", "2", "137", "5", "carolinelinden@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("638", "2", "137", "6", "The best girls for sex in your town: http://monthly-shinyokohama.jp/cutlinks/rank.php?url=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("639", "2", "138", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("642", "2", "138", "5", "to.na.1024g@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("643", "2", "138", "6", "Sexy girls for the night in your town: http://www.protocallhotline.com/LinkClick.aspx?link=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("644", "2", "139", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("647", "2", "139", "5", "sammyliz@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("648", "2", "139", "6", "Meet sexy girls in your city: http://www.uw-de.com/search/rank.cgi?mode=link&id=3308&url=https://vk.cc/9hUq5L", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("649", "2", "140", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("652", "2", "140", "5", "elisabethvasquez97@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("653", "2", "140", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://www.lookweb.it/investbitcoin99691", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("654", "2", "141", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("657", "2", "141", "5", "maggy6u@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("658", "2", "141", "6", "Invest $ 5,000 in Bitcoin mining once and get $ 7,000 passive income per month: http://www.gleneggers.com/searchpoint/redir.asp?reg_id=ptypes&sname=/searchpoint/search.asp&lid=1&sponsor=lea&url=https://vk.cc/9iSaPJ", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("659", "2", "142", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("662", "2", "142", "5", "h.u.s.weigel@t-online.de", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("663", "2", "142", "6", "Invest $ 5,000 in Bitcoin once and get $ 7,000 passive income per month: http://purenudismpics.com/crtr/cgi/out.cgi?id=101&l=top_top&u=https://vk.cc/9iSaPJ", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("664", "2", "143", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("667", "2", "143", "5", "sofimunnoz@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("668", "2", "143", "6", "Invest $ 5,000 in Bitcoin once and get $ 7,000 passive income per month: http://uszn71.ru/bitrix/redirect.php?event1=&event2=&event3=&goto=https://vk.cc/9iSaPJ", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("669", "2", "144", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("672", "2", "144", "5", "cpmurillo@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("673", "2", "144", "6", "How to invest in bitcoins $ 5000 - get a return of up to 2000%: http://goto.iamaws.com/investbitcoin86276", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("674", "2", "145", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("677", "2", "145", "5", "missubro@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("678", "2", "145", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://park1.wakwak.com/~seitai/cgi-bin/yomi-search/rank.cgi?mode=link&id=44&url=https://vk.cc/9iSaPJ", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("679", "2", "146", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("682", "2", "146", "5", "beck_666@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("683", "2", "146", "6", "If you invested $1,000 in bitcoin in 2011, now you have $4 million: http://www.lookweb.it/investbitcoin11843", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("684", "2", "147", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("687", "2", "147", "5", "hotremom@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("688", "2", "147", "6", "How to invest in bitcoins $ 5000 - get a return of up to 2000%: http://eigaseikatu.com/go/?tbn=777&l=https://vk.cc/9iSaPJ", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("689", "2", "148", "2", "ellen botwin", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("692", "2", "148", "5", "EMAIL", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("693", "2", "148", "6", "YES, I HAVE BEEN SPEAKING WITH JONATHON AND PURCHASED THE ELAN FOR MY PARENTS HOUSE , 25 WEDGEWOOD RD IN WESTPORT CT. I AM MEETING THEM THERE NEXT WEEK, MAY 1, AT 10 OR 11:00 am.    ????? I also paid $1725. CAN YOU PLEASE EMAIL ME AT MY EMAIL ABOVE A RECEIPT, CONTRACT ETC. THANKYOU VERY MUCH\r\nPLEASE CLARIFY THE TIME AND ANY CHANGE ETC AS I HAVE TO DRIVE THERE ALSO.\r\nTHANKYOU, Ellen Botwin", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("694", "2", "149", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("697", "2", "149", "5", "fschuett89@gmx.de", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("698", "2", "149", "6", "Cryptocurrency Trading & Investing Strategy for 2019. Receive passive income of $ 7,000 per month: http://www.abcagency.se/investbitcoin69669", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("699", "2", "150", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("702", "2", "150", "5", "a_and_s_graphix@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("703", "2", "150", "6", "Cryptocurrency Trading & Investing Strategy for 2019. Receive passive income of $ 7,000 per month: http://www.abcagency.se/investbitcoin31562", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("704", "2", "151", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("707", "2", "151", "5", "elaboisen@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("708", "2", "151", "6", "Invest $ 5,000 in Bitcoin once and get $ 7,000 passive income per month: http://www.vkvi.net/investbitcoin70558", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("709", "2", "152", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("712", "2", "152", "5", "jswjunk@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("713", "2", "152", "6", "How to invest in bitcoins in 2019 and receive passive income of $ 7,000 per month: http://rih.co/investbitcoin38343", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("714", "2", "153", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("717", "2", "153", "5", "eliastokes@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("718", "2", "153", "6", "Invest $ 5,000 in Bitcoin mining once and get $ 7,000 passive income per month: http://to.ht/investbitcoin23682", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("719", "2", "154", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("722", "2", "154", "5", "caso10@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("723", "2", "154", "6", "How to invest in bitcoins $ 5000 - get a return of up to 2000%: https://aaa.moda/investbitcoin58781", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("724", "2", "155", "2", "VidmFeade", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("727", "2", "155", "5", "ewrdfrgew32f@yandex.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("728", "2", "155", "6", "Today almost every Internet user uses YT or any other video hosting provider to upload and watch video about cats, free movies and other content. But sometimes you want to download a videofile and the hosting doesn\'t allow you to do so. It\'s where Vidmate App is coming to help you. It allows you to get a movie from may services, including Youtube, Vimeo, Facebook and many other hosting services. To perform this you simply need to open video page and click download button. Plus, the app is 100% free and easy in use! Download <a href=https://vidmateapp.pro>Vidmate</a> now and start downloading very entertaining video to share them with your family and friends!", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("729", "2", "156", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("732", "2", "156", "5", "nattscontacto@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("733", "2", "156", "6", "UPDATE: Cryptocurrency Investing Strategy - Q2 2019. Receive passive income of $ 7,000 per month: http://jnl.io/investbitcoin61183", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("734", "2", "157", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("737", "2", "157", "5", "travisacroom@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("738", "2", "157", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://www.lookweb.it/investbitcoin91604", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("739", "2", "158", "2", "salutjax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("742", "2", "158", "5", "budnikova.lev@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("743", "2", "158", "6", "Пиротехническая компания Земля/Воздух уже более 10 лет раскрашивает небо салютами и фейерверками, комбинируя яркие цвета, необычные формы, высоту раскатов, скорость залпов и различные спецэффекты. Они похожи на природные явления неописуемой красоты — очень органичны и естественны, и при этом необычайно красивы и грандиозны. \r\nМы сделаем Ваш праздник незабываемым! Вы можете заказать <a href=http://zemlya-vozduh.com>салют</a> или <a href=http://zemlya-vozduh.com>фейерверк</a> на свой празник на сайте <a href=http://zemlya-vozduh.com>zemlya-vozduh.com</a> \r\n	 \r\n<a href=http://zemlya-vozduh.com/ognennoe-shou/na-den-rozhdeniya/2/>проведение салютов</a>", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("744", "2", "159", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("747", "2", "159", "5", "lisameryn@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("748", "2", "159", "6", "Now\'s your chance to win a free iPhone X: http://www.lookweb.it/winiphone51542", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("749", "2", "160", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("752", "2", "160", "5", "tammys15@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("753", "2", "160", "6", "Now\'s your chance to win a free iPhone X: http://www.lookweb.it/winiphone74369", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("754", "2", "161", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("757", "2", "161", "5", "hendersonmk@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("758", "2", "161", "6", "Now\'s your chance to win a free iPhone X: http://rih.co/winiphone42639", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("759", "2", "162", "2", "Keldaxy", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("762", "2", "162", "5", "kelSymn@emaill.host", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("763", "2", "162", "6", "Viagra Alcool Tabac  <a href=http://catabs.com>priligy precio</a> Vente De Viagra Quebec Amoxicillin No Script Meds Cipro Vs Cephalexin Interaction", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("764", "2", "163", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("767", "2", "163", "5", "lcofer@bresnan.net", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("768", "2", "163", "6", "iPhone XS Giveaway Contest - Enter to Win an iPhone XS Free: http://www.abcagency.se/winiphone59546", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("769", "2", "164", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("772", "2", "164", "5", "a.melio.r.a.teq.b.m.d@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("773", "2", "164", "6", "Now\'s your chance to win a free iPhone X: http://www.abcagency.se/winiphone81895", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("774", "2", "165", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("777", "2", "165", "5", "alphaxbxu@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("778", "2", "165", "6", "Enter to win an iPhone XS Max & AirPods in this free giveaway: http://webhop.se/winiphone83958", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("779", "2", "166", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("782", "2", "166", "5", "bvbotelliy@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("783", "2", "166", "6", "iPhone XS Giveaway Contest - Enter to Win an iPhone XS Free: http://ttree.co/winiphone41485", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("784", "2", "167", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1100", "2", "231", "5", "8 pm", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1101", "2", "231", "6", "Gooof", "");
INSERT INTO `wp_gf_entry_meta` VALUES("787", "2", "167", "5", "danny-boy1@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("788", "2", "167", "6", "Now\'s your chance to win a free iPhone X: http://goto.iamaws.com/winiphone80825", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("789", "2", "168", "2", "contacthnuzqq", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1099", "2", "231", "9", "alyon1983@gmail.com", "");
INSERT INTO `wp_gf_entry_meta` VALUES("792", "2", "168", "5", "contactwstvej", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("793", "2", "168", "6", "Dear Madame, Dear Sirs! \r\n \r\nWe offer sending newsletters of Your commercial offers via follow-up forms to the sites ofcompanies via all countries of the world in all languages.  \r\n \r\nhttp://xn----7sbb1bbndheurc1a.xn--p1ai \r\n \r\nYour commercial offer is sent to email address of organization hundred % will get to incoming! \r\n \r\nTest: \r\n10000 messages on foreign zones to your email - 20 dollars. \r\nWe need from You only email address, title and text of the letter. \r\n \r\nIn our price list there are more 800 databases for all countries of the world. \r\nCommon databases: \r\nAll Europe 44 countries 60726150 of domain names - 1100$ \r\nAll European Union 28 countries 56752547 of domains- 1000$ \r\nAll Asia 48 countries 14662004 of domains - 300$ \r\nAll Africa 50 countries 1594390 of domains - 200$ \r\nAll North and Central America in 35 countries 7441637 of domains - 300$ \r\nAll South America 14 countries 5826884 of domain names - 200$ \r\nNew domain names from around the world registered 24-48 hours ago. (A cycle of 15 mailings during the month) - 500$ \r\nCompanies and Enterprises of RF 3012045 - 300$ \r\nUkraine 605745 of domains - 100$ \r\nAll Russian-speaking countries minus Russia are 15 countries and there are 1526797 of domains - 200$ \r\nNew domain names of the Russian Federation, registered 24-48 hours ago (A cycle of 15 mailings during the month) - 250$ \r\n \r\nOur databases: \r\nWhois-service databases of domain names for all countries of the world. \r\nYou can purchase our databases separately from newsletter\'s service at the request. \r\n \r\nP.S. \r\nPls., do not respond to this letter from your mailbox, as it has been generated in automatic mode and will not reach us! \r\nUse the contact form from the site http://xn----7sbb1bbndheurc1a.xn--p1ai \r\n \r\n \r\nPRICE LIST: \r\n \r\nTest mailing: $20 – 10000 contact forms websites \r\n \r\nAll Europe 44 countries there are 60726150 websites – $1100 \r\n \r\nAll EU 28 countries there are 56752547 websites – $1000 \r\n \r\nAll Asia 48 countries there are 14662004 websites – $500 \r\n \r\nAll Africa 50 countries there are 1594390 websites – $200 \r\n \r\nAll North and Central America is 35 countries there are 7441637 websites – $300 \r\n \r\nAll South America 14 countries there are 5826884 websites – $200 \r\n \r\nTop 1 Million World’s Best websites – $100 \r\n \r\nTop 16821856 the most visited websites in the world – $200 \r\n \r\nBusinesses and organizations of the Russian Federation – there are 3012045 websites – $300 \r\n \r\nUkraine 605745 websites – $100 \r\n \r\nAll Russian-speaking countries minus Russia – there are 15 countries and 1526797 websites – $200 \r\n \r\n1499203 of hosting websites around the world (there are selections for all countries, are excluded from databases for mailings) – $200 \r\n \r\n35439 websites of public authorities of all countries of the world (selections for all countries, are excluded from databases for mailings) – $100 \r\n \r\nCMS mailings: \r\nAmiro 2294 websites $50 \r\nBitrix 175513 websites $80 \r\nConcrete5 49721 websites $50 \r\nCONTENIDO 7769 websites $50 \r\nCubeCart 1562 websites $50 \r\nDatalife Engine 29220 websites $50 \r\nDiscuz 70252 websites $50 \r\nDotnetnuke 31114 websites $50 \r\nDrupal 802121 websites $100 \r\nHostCMS 6342 websites $50 \r\nInstantCMS 4936 websites $50 \r\nInvision Power Board 510 websites $50 \r\nJoomla 1906994 websites $200 \r\nLiferay 5937 websites $50 \r\nMagento 269488 websites $80 \r\nMODx 67023 websites $50 \r\nMovable Type 13523 websites $50 \r\nNetCat 6936 websites $50 \r\nNopCommerce 5313 websites $50 \r\nOpenCart 321057 websites $80 \r\nosCommerce 65468 websites $50 \r\nphpBB 3582 websites $50 \r\nPrestashop 92949 websites $50 \r\nShopify 365755 websites $80 \r\nSimpla 8963 websites $50 \r\nSitefinity 4883 websites $50 \r\nTYPO3 227167 websites $80 \r\nUMI.CMS 15943 websites $50 \r\nvBulletin 154677 websites $80 \r\nWix 2305768 websites $230 \r\nWordPress 14467405 websites $450 \r\nWooCommerce 2097367 websites $210 \r\n \r\n.com 133766112 websites commercial – $1950 \r\n.biz 2361884 websites business – $150 \r\n.info 6216929 websites information – $250 \r\n.net 15689222 websites network – $450 \r\n.org 10922428 websites organization – $350 \r\n \r\n.abogado 279 websites – $50 \r\n.ac 16799 websites – $50 \r\n.academy 27306 websites – $50 \r\n.accountant 96542 websites – $50 \r\n.actor 1928 websites – $50 \r\n.ad 414 websites – $50 \r\n.adult 10540 websites- $50 \r\n.ae 1821 websites International zone UAE:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ae 199533 websites UAE – $50 \r\n.aero 18325 websites- $50 \r\n.af 3315 websites – $50 \r\n.africa 15056 websites- $50 \r\n.ag 10339 websites – $50 \r\n.agency 47508 websites – $50 \r\n.ai 17199 websites – $50 \r\n.airforce 560 websites – $50 \r\n.al 6078 websites – $50 \r\n.alsace 1982 websites – $50 \r\n.am 17987 websites Armenia – $50 \r\n.am 1684 websites International zone Armenia:.com.net.biz.info.org.name.tel.mobi.asia \r\n.amsterdam 28141 websites Amsterdam, Kingdom of the Netherlands – $50 \r\n.ao 518 websites – $50 \r\n.apartments 3758 websites – $50 \r\n.ar 551804 websites Argentina – $80 \r\n.ar 64008 websites International zone Argentina:.com .net .biz .info .name .tel .mobi .asia – $50 \r\n.archi 2084 websites – $50 \r\n.army 1842 websites – $50 \r\n.art 26402 websites – $50 \r\n.as 10025 websites – $50 \r\n.asia 228418 websites – $80 \r\n.associates 3340 websites – $50 \r\n.at 1356722 websites Austria – $100 \r\n.at 181907 websites International zone Austria :.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.attorney 8224 websites- $50 \r\n.attorney 7204 websites – $50 \r\n.au 2243263 websites Australia – $150 \r\n.au 461279 websites International zone Australia:.com.net.biz.info.org.name.tel.mobi.asia-$80 \r\n.auction 3625 websites- $50 \r\n.audio 23052 websites- $50 \r\n.auto 400 websites- $50 \r\n.aw 235 websites- $50 \r\n.az 11104 websites Azerbaijan – $50 \r\n.az 2036 websites International zone Azerbaijan:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ba 7012 websites – $50 \r\n.ba 2291 websites International zone Bosnia and Herzegovina:.com.net.biz.info.org.name.tel.mobi.asia \r\n.band 11515 websites – $50 \r\n.bank 1621 websites- $50 \r\n.bar 5506 websites – $50 \r\n.barcelona 7919 websites – $50 \r\n.bargains 2997 websites- $50 \r\n.bayern 32565 websites – $50 \r\n.bb 2277 websites – $50 \r\n.be 1349658 websites Belgium – $100 \r\n.be 184810 websites International zone Belgium:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.beer 11834 websites- $50 \r\n.berlin 58088 websites Berlin – $50 \r\n.best 2912 websites – $50 \r\n.bet 17637 websites – $50 \r\n.bf 238 websites – $50 \r\n.bg 33252 websites Bulgaria – $50 \r\n.bg 50685 websites International zone Bulgaria:.com.net.biz.info.org.name.tel.mobi.asia \r\n.bh 453 websites – $50 \r\n.bi 2328 websites Burundi- $50 \r\n.bible 1160 websites – $50 \r\n.bid 474509 websites – $80 \r\n.bike 15729 websites – $50 \r\n.bingo 1332 websites – $50 \r\n.bio 15531 websites- $50 \r\n.bj 147 websites- $50 \r\n.black 6582 websites – $50 \r\n.blackfriday 12106 websites – $50 \r\n.blog 145463 websites – $50 \r\n.blue 16852 websites – $50 \r\n.bm 8089 websites Bermuda – $50 \r\n.bo 2302 websites- $50 \r\n.boats 266 websites- $50 \r\n.boston 21762 websites- $50 \r\n.boutique 8834 websites – $50 \r\n.br 2367290 websites Brazil – $150 \r\n.br 933750 websites International zone Brazil:.com.net.biz.info.org.name.tel.mobi.asia-$100 \r\n.bradesco 129 websites- $50 \r\n.broadway 261 websites- $50 \r\n.broker 660 websites- $50 \r\n.brussels 7181 websites – $50 \r\n.bs 330 websites- $50 \r\n.bt 284 websites- $50 \r\n.build 3857 websites- $50 \r\n.builders 3906 websites- $50 \r\n.business 35168 websites – $50 \r\n.buzz 11257 websites – $50 \r\n.bw 656 websites – $50 \r\n.by 1574 websites International zone Belarus:.com.net.biz.info.org.name.tel.mobi.asia \r\n.by 92679 websites Belarus – $50 \r\n.bz 7751 websites – $50 \r\n.bzh 5403 websites – $50 \r\n.ca 2587463 websites Canada – $150 \r\n.ca 288395 websites International zone Canada:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.cab 3223 websites – $50 \r\n.cafe 13606 websites – $50 \r\n.cam 5156 websites – $50 \r\n.camera 5236 websites – $50 \r\n.camp 6315 websites – $50 \r\n.capetown 4750 websites – $50 \r\n.capital 11387 websites – $50 \r\n.car 342 websites – $50 \r\n.cards 5992 websites – $50 \r\n.care 18204 websites – $50 \r\n.career 1217 websites – $50 \r\n.careers 7055 websites – $50 \r\n.cars 309 websites – $50 \r\n.casa 18918 websites – $50 \r\n.cash 13193 websites – $50 \r\n.casino 4354 websites – $50 \r\n.cat 108569 websites – $50 \r\n.catering 3482 websites – $50 \r\n.cc 1920589 websites Cocos Keeling Islands- $150 \r\n.cd 5365 websites – $50 \r\n.center 35353 websites – $50 \r\n.ceo 2458 websites – $50 \r\n.cf 476142 websites Central African Republic – $50 \r\n.cg 166 – $50 \r\n.ch 1471685 websites Switzerland – $100 \r\n.ch 205292 websites International zone Switzerland:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.chat 11126 websites – $50 \r\n.cheap 3267 websites – $50 \r\n.christmas 15255 websites – $50 \r\n.church 21104 websites – $50 \r\n.ci 112 websites International zone Cote d’Ivoire:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ci 5663 websites Cote d’Ivoire- $50 \r\n.city 46171 websites – $50 \r\n.cl 498401 websites Chile – $80 \r\n.claims 2374 websites – $50 \r\n.cleaning 2385 websites – $50 \r\n.click 181015 websites – $50 \r\n.clinic 7006 websites – $50 \r\n.clothing 13639 websites – $50 \r\n.cloud 134113 websites – $50 \r\n.club 1045323 websites – $100 \r\n.cm 12001 websites Cameroon- $50 \r\n.cn 1372416 websites International zone China:.com.net.biz.info.org.name.tel.mobi.asia-$100 \r\n.cn 7264587 websites China – $300 \r\n.co 1778923 websites Colombia – $150 \r\n.coach 12002 websites- $50 \r\n.codes 6844 websites – $50 \r\n.coffee 17257 websites – $50 \r\n.cologne 5137 websites – $50 \r\n.cologne 5198 websites – $50 \r\n.com.ar 657716 websites Argentina – $80 \r\n.com.br 942898 websites Brazil – $100 \r\n.com.cy 11153 websites Cyprus – $50 \r\n.com.ni 23747 websites – $50 \r\n.com.np 38828 websites – $50 \r\n.com.ru, .net.ru, .org.ru, .spb.ru, .msk.ru 79058 websites Russia – $50 \r\n.community 13013 websites – $50 \r\n.company 61217 websites – $50 \r\n.computer 5039 websites – $50 \r\n.condos 2192 websites – $50 \r\n.construction 6804 websites – $50 \r\n.consulting 22128 websites – $50 \r\n.contractors 3982 websites – $50 \r\n.cooking 1476 websites – $50 \r\n.cool 16008 websites – $50 \r\n.coop 7879 websites – $50 \r\n.corsica 1042 websites – $50 \r\n.country 7144 websites – $50 \r\n.cr 7934 websites – $50 \r\n.credit 4020 websites – $50 \r\n.creditcard 825 websites – $50 \r\n.creditunion 511 websites – $50 \r\n.cricket 33413 websites – $50 \r\n.cruises 2234 websites – $50 \r\n.cu 137 websites – $50 \r\n.cv 1879 websites – $50 \r\n.cx 15753 websites – $50 \r\n.cy 11092 websites Cyprus – $50 \r\n.cy 710 websites International zone Cyprus:.com.net.biz.info.org.name.tel.mobi.asia \r\n.cymru 7114 websites – $50 \r\n.cz 193400 websites International zone Czech Republic:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.cz 930208 websites Czech Republic – $80 \r\n.dance 6290 websites – $50 \r\n.date 123037 websites – $50 \r\n.dating 2892 websites – $50 \r\n.de 15078512 websites Germany – $450 \r\n.de 3894156 websites International zone Germany:.com.net.biz.info.org.name.tel.mobi.asia-$200 \r\n.deals 8132 websites – $50 \r\n.degree 2178 websites – $50 \r\n.delivery 4782 websites – $50 \r\n.democrat 1072 websites – $50 \r\n.dental 7541 websites – $50 \r\n.dentist 3046 websites – $50 \r\n.desi 2647 websites – $50 \r\n.design 71711 websites – $50 \r\n.diamonds 2730 websites – $50 \r\n.diet 18291 websites – $50 \r\n.digital 31449 websites – $50 \r\n.direct 10629 websites – $50 \r\n.directory 18157 websites – $50 \r\n.discount 3898 websites – $50 \r\n.dj 7280 websites – $50 \r\n.dk 1320155 websites Denmark – $100 \r\n.dk 148164 websites International zone Denmark:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.dm 23318 websites – $50 \r\n.do 5255 websites Dominican Republic- $50 \r\n.dog 10030 websites – $50 \r\n.domains 6553 websites – $50 \r\n.download 129223 websites – $50 \r\n.durban 2247 websites – $50 \r\n.dz 982 websites – $50 \r\n.earth 8139 websites – $50 \r\n.ec 11731 websites – $50 \r\n.edu 4445 websites – $50 \r\n.edu.np 4883 websites- $50 \r\n.education 22003 websites – $50 \r\n.ee 10490 websites International zone Estonia:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ee 119701 websites Estonia- $50 \r\n.eg 1699 websites – $50 \r\n.email 77321 websites – $50 \r\n.energy 9769 websites – $50 \r\n.engineer 2785 websites – $50 \r\n.engineering 5533 websites – $50 \r\n.enterprises 6153 websites – $50 \r\n.equipment 5760 websites – $50 \r\n.es 1685048 websites Spain – $100 \r\n.es 541916 websites International zone Spain:.com.net.biz.info.org.name.tel.mobi.asia-$80 \r\n.estate 9185 websites – $50 \r\n.et 124 websites – $50 \r\n.eu 3321576 websites Europe – $150 \r\n.eu 633384 websites International zone Europe:.com.net.biz.info.org.name.tel.mobi.asia-$80 \r\n.eus 8116 websites – $50 \r\n.events 22115 websites – $50 \r\n.exchange 9432 websites – $50 \r\n.expert 31240 websites – $50 \r\n.exposed 3147 websites – $50 \r\n.express 6919 websites – $50 \r\n.fail 3322 websites – $50 \r\n.faith 54195 websites – $50 \r\n.family 15577 websites – $50 \r\n.fans 1388 websites – $50 \r\n.farm 13499 websites – $50 \r\n.fashion 12475 websites – $50 \r\n.feedback 2301 websites – $50 \r\n.fi 178337 websites Finland – $50 \r\n.fi 69631 websites International zone Finland:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.film 3601 websites – $50 \r\n.finance 7982 websites – $50 \r\n.financial 4086 websites – $50 \r\n.fish 4162 websites – $50 \r\n.fishing 1423 websites – $50 \r\n.fit 17007 websites – $50 \r\n.fitness 9689 websites – $50 \r\n.flights 2119 websites – $50 \r\n.florist 2286 websites – $50 \r\n.flowers 25590 websites – $50 \r\n.fm 5407 websites – $50 \r\n.fo 3098 websites- $50 \r\n.football 4877 websites – $50 \r\n.forex 212 websites – $50 \r\n.forsale 7118 websites – $50 \r\n.foundation 10118 websites – $50 \r\n.fr 2391045 websites France – $150 \r\n.fr 639546 websites International zone France:.com.net.biz.info.org.name.tel.mobi.asia-$80 \r\n.frl 14028 websites – $50 \r\n.fun 86419 websites – $50 \r\n.fund 11205 websites – $50 \r\n.furniture 2246 websites – $50 \r\n.futbol 2783 websites – $50 \r\n.fyi 9772 websites – $50 \r\n.ga 12048 websites Gabon – $50 \r\n.gal 4606 websites – $50 \r\n.gallery 17263 websites – $50 \r\n.game 1996 websites – $50 \r\n.games 13234 websites – $50 \r\n.garden 914 websites – $50 \r\n.gd 4238 websites – $50 \r\n.ge 1676 websites International zone Georgia:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ge 17361 websites Georgia – $50 \r\n.gent 3389 websites – $50 \r\n.gf 121 websites – $50 \r\n.gg 9443 websites – $50 \r\n.gh 693 websites – $50 \r\n.gi 1063 websites – $50 \r\n.gift 6281 websites – $50 \r\n.gifts 3757 websites – $50 \r\n.gives 1563 websites – $50 \r\n.gl 3575 websites – $50 \r\n.glass 3539 websites – $50 \r\n.global 38972 websites – $50 \r\n.gm 468 websites – $50 \r\n.gmbh 19186 websites – $50 \r\n.gold 9081 websites – $50 \r\n.golf 8319 websites – $50 \r\n.gop 1341 websites – $50 \r\n.gov 4525 websites – $50 \r\n.gov.np 1937 websites- $50 \r\n.gp 416 websites – $50 \r\n.gq 23306 websites – $50 \r\n.gr 356168 websites Greece – $80 \r\n.gr 57984 websites International zone Greece:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.graphics 7155 websites – $50 \r\n.gratis 4283 websites – $50 \r\n.green 3661 websites – $50 \r\n.gripe 1075 websites – $50 \r\n.group 54983 websites – $50 \r\n.gs 5108 websites – $50 \r\n.gt 15351 websites – $50 \r\n.guide 16044 websites – $50 \r\n.guitars 1278 websites – $50 \r\n.guru 60588 websites – $50 \r\n.gy 2447 websites – $50 \r\n.hamburg 23885 websites – $50 \r\n.haus 5186 websites – $50 \r\n.health 6211 websites – $50 \r\n.healthcare 8051 websites – $50 \r\n.help 13500 websites – $50 \r\n.hiphop 1064 websites – $50 \r\n.hiv 331 websites – $50 \r\n.hk 116093 websites – $50 \r\n.hm 249 websites – $50 \r\n.hn 4732 websites – $50 \r\n.hockey 1102 websites – $50 \r\n.holdings 5412 websites – $50 \r\n.holiday 5017 websites – $50 \r\n.homes 432 websites – $50 \r\n.horse 2116 websites – $50 \r\n.host 31309 websites – $50 \r\n.hosting 4132 websites – $50 \r\n.house 18096 websites – $50 \r\n.how 1957 websites – $50 \r\n.hr 16592 websites International zone Croatia:.com.net.biz.info.org.name.tel.mobi.asia \r\n.hr 43565 websites Croatia – $50 \r\n.ht 2559 websites – $50 \r\n.hu 53940 websites International zone Hungary:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.hu 618532 websites Hungary – $80 \r\n.id 37212 websites – $50 \r\n.ie 195987 websites Ireland – $50 \r\n.ie 49861 websites International zone Ireland:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.il 224167 websites Israel – $80 \r\n.il 38537 websites International zone Israel:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.im 20701 websites – $50 \r\n.immo 16009 websites – $50 \r\n.immobilien 7094 websites – $50 \r\n.in 1143482 websites India – $100 \r\n.in 266179 websites International zone India:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.industries 3749 websites – $50 \r\n.ink 27117 websites – $50 \r\n.institute 10134 websites – $50 \r\n.insure 4615 websites – $50 \r\n.int 191 websites – $50 \r\n.international 23930 websites – $50 \r\n.investments 4113 websites – $50 \r\n.io 314287 websites British Indian Ocean – $50 \r\n.iq 1118 websites – $50 \r\n.ir 15487 websites International zone Iran:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ir 427735 websites Iran- $80 \r\n.irish 3326 websites – $50 \r\n.is 31176 websites Iceland – $50 \r\n.ist 10060 websites – $50 \r\n.istanbul 13139 websites – $50 \r\n.it 2258105 websites Italy – $200 \r\n.it 954040 websites International zone Italy:.com.net.biz.info.org.name.tel.mobi.asia-$100 \r\n.je 2716 websites – $50 \r\n.jetzt 11118 websites – $50 \r\n.jetzt 11704 websites – $50 \r\n.jewelry 3350 websites – $50 \r\n.jo 555 websites – $50 \r\n.jobs 46350 websites- $50 \r\n.joburg 3139 websites – $50 \r\n.jp 1146243 websites Japan – $100 \r\n.juegos 844 websites – $50 \r\n.kaufen 7134 websites – $50 \r\n.kg 664 websites International zone Kyrgyzstan:.com.net.biz.info.org.name.tel.mobi.asia \r\n.kg 8919 websites Kyrgyzstan – $50 \r\n.ki 1146 websites – $50 \r\n.kim 16637 websites- $50 \r\n.kitchen 6581 websites – $50 \r\n.kiwi 19426 websites – $50 \r\n.kn 1271 websites – $50 \r\n.koeln 23489 websites – $50 \r\n.kr 254447 websites Korea- $50 \r\n.krd 375 websites – $50 \r\n.kred 6120 websites – $50 \r\n.kw 423 websites – $50 \r\n.ky 1201 websites – $50 \r\n.kyoto 659 websites – $50 \r\n.kz 112459 websites Kazakhstan – $50 \r\n.kz 5876 websites International zone Kazakhstan:.com.net.biz.info.org.name.tel.mobi.asia \r\n.la 32189 websites Laos – $50 \r\n.land 14474 websites- $50 \r\n.lat 2971 websites – $50 \r\n.law 11842 websites – $50 \r\n.lawyer 11600 websites- $50 \r\n.lc 651 websites- $50 \r\n.lease 1855 websites- $50 \r\n.leclerc 127 websites- $50 \r\n.legal 11047 websites- $50 \r\n.lgbt 2249 websites- $50 \r\n.li 12044 websites – $50 \r\n.life 170053 websites – $50 \r\n.lighting 6096 websites – $50 \r\n.limited 5365 websites – $50 \r\n.limo 2409 websites- $50 \r\n.link 133123 websites – $50 \r\n.live 160896 websites – $50 \r\n.lk 6601 websites – $50 \r\n.loan 1932173 websites- $200 \r\n.loans 3914 websites – $50 \r\n.lol 7470 websites- $50 \r\n.london 82443 websites London, United Kingdom- $50 \r\n.love 22287 websites- $50 \r\n.lt 27710 websites International zone Lithuania:.com.net.biz.info.org.name.tel.mobi.asia \r\n.lt 89073 websites Lithuania- $50 \r\n.ltd 329225 websites – $50 \r\n.lu 43052 websites Luxembourg – $50 \r\n.lu 4125 websites International zone Luxembourg:.com.net.biz.info.org.name.tel.mobi.asia \r\n.luxury 905 websites – $50 \r\n.lv 61886 websites Latvia- $50 \r\n.lv 8887 websites International zone Latvia:.com.net.biz.info.org.name.tel.mobi.asia \r\n.ly 8013 websites – $50 \r\n.ma 51862 websites Morocco – $50 \r\n.maison 1123 websites – $50 \r\n.management 10088 websites- $50 \r\n.market 22167 websites- $50 \r\n.marketing 18262 websites- $50 \r\n.markets 816 websites- $50 \r\n.mba 3023 websites- $50 \r\n.mc 3036 websites Monaco – $50 \r\n.md 15435 websites Moldova – $50 \r\n.md 1293 websites International zone Moldova:.com.net.biz.info.org.name.tel.mobi.asia \r\n.me 761596 websites Montenegro – $80 \r\n.me 86897 websites International zone Montenegro:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.media 40573 websites – $50 \r\n.melbourne 10041 websites – $50 \r\n.memorial 512 websites – $50 \r\n.men 470140 websites – $80 \r\n.menu 5512 websites restaurants- $50 \r\n.mg 3380 websites Madagascar- $50 \r\n.miami 14431 websites Miami, USA – $50 \r\n.mk 12704 websites – $50 \r\n.ml 70170 websites – $50 \r\n.mma 1706 websites – $50 \r\n.mn 16710 websites – $50 \r\n.mo 573 websites – $50 \r\n.mobi 462419 websites- $80 \r\n.moda 3015 websites – $50 \r\n.moe 7709 websites – $50 \r\n.mom 3145 websites – $50 \r\n.money 9731 websites – $50 \r\n.mortgage 3126 websites – $50 \r\n.moscow 22097 websites Moscow Russian Federation- $50 \r\n.movie 2575 websites – $50 \r\n.mr 1725 websites – $50 \r\n.ms 7565 websites – $50 \r\n.mt 1623 websites Malta – $50 \r\n.mu 6175 websites – $50 \r\n.museum 34464 websites – $50 \r\n.mv 1907 websites – $50 \r\n.mw 8579 websites Malawi – $50 \r\n.mx 609278 websites Mexico- $80 \r\n.mx 86593 websites International zone Mexico:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.my 283349 websites Malaysia- $80 \r\n.mz 263 websites – $50 \r\n.na 781 websites – $50 \r\n.nagoya 7807 websites – $50 \r\n.name 135818 websites- $50 \r\n.navy 698 websites – $50 \r\n.nc 1240 websites – $50 \r\n.network 40018 websites – $50 \r\n.news 65546 websites – $50 \r\n.ng 16608 websites – $50 \r\n.ngo 3422 websites – $50 \r\n.ninja 49007 websites – $50 \r\n.nl 1019697 websites International zone Netherlands:.com.net.biz.info.org.name.tel.mobi.asia-$100 \r\n.nl 3566172 websites Netherlands – $200 \r\n.no 579185 websites Norway – $80 \r\n.no 74318 websites International zone Norway:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.nra 144 websites – $50 \r\n.nrw 18487 websites – $50 \r\n.nu 489605 websites Niue- $50 \r\n.nyc 67153 websites – $50 \r\n.nz 576127 websites New Zealand – $80 \r\n.om 1603 websites – $50 \r\n.one 63063 websites – $50 \r\n.ong 3422 websites – $50 \r\n.onl 3790 websites – $50 \r\n.online 695007 websites – $50 \r\n.ooo 6400 websites – $50 \r\n.org.np 7082 websites – $50 \r\n.org.ua 41362 websites – $50 \r\n.organic 1633 websites – $50 \r\n.osaka 628 websites – $50 \r\n.ovh 50056 websites – $50 \r\n.pa 1558 websites – $50 \r\n.paris 19283 websites – $50 \r\n.partners 6576 websites – $50 \r\n.parts 5514 websites – $50 \r\n.party 115578 websites- $50 \r\n.pe 59157 websites International zone Peru:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.pe 69367 websites Peru – $50 \r\n.pet 8487 websites – $50 \r\n.pf 349 websites – $50 \r\n.pg 1979 websites Papua – $50 \r\n.ph 17940 websites Philippines – $50 \r\n.photo 17165 websites- $50 \r\n.photography 50434 websites- $50 \r\n.photos 19107 websites- $50 \r\n.physio 1160 websites- $50 \r\n.pics 7659 websites- $50 \r\n.pictures 7807 websites- $50 \r\n.pink 6373 websites- $50 \r\n.pizza 5949 websites – $50 \r\n.pk 44464 websites Pakistan – $50 \r\n.pl 1675325 websites Poland – $100 \r\n.pl 327587 websites International zone Poland:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.place 7002 websites – $50 \r\n.plumbing 3005 websites – $50 \r\n.plus 9892 websites – $50 \r\n.pm 4401 websites – $50 \r\n.poker 3209 websites – $50 \r\n.porn 10023 websites- $50 \r\n.post 3481 websites – $50 \r\n.pr 18419 websites – $50 \r\n.press 35032 websites – $50 \r\n.pro 280776 websites – $50 \r\n.productions 6144 websites – $50 \r\n.promo 5020 websites – $50 \r\n.properties 14144 websites – $50 \r\n.property 4366 websites – $50 \r\n.ps 2050 websites – $50 \r\n.pt 17691 websites International zone Portugal:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.pt 225136 websites Portugal – $80 \r\n.pub 16703 websites – $50 \r\n.pw 16206 websites – $50 \r\n.py 4635 websites – $50 \r\n.qa 8503 websites – $50 \r\n.quebec 8042 websites – $50 \r\n.racing 55001 websites – $50 \r\n.re 11082 websites – $50 \r\n.realtor 39465 websites – $50 \r\n.realty 55291 websites – $50 \r\n.recipes 3251 websites – $50 \r\n.red 25701 websites – $50 \r\n.rehab 1816 websites – $50 \r\n.reise 4146 websites – $50 \r\n.reisen 9228 websites – $50 \r\n.reit 126 websites – $50 \r\n.ren 108303 websites – $50 \r\n.rent 3788 websites – $50 \r\n.rentals 11823 websites- $50 \r\n.repair 6628 websites- $50 \r\n.report 5869 websites – $50 \r\n.republican 952 websites – $50 \r\n.rest 1894 websites – $50 \r\n.restaurant 7703 websites – $50 \r\n.review 229514 websites – $80 \r\n.reviews 16132 websites- $50 \r\n.rio 1062 websites- $50 \r\n.rip 3199 websites- $50 \r\n.ro 42046 websites International zone Romania:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.ro 483266 websites Romania – $80 \r\n.rocks 81108 websites – $50 \r\n.rs 75503 websites Serbia – $50 \r\n.ru 5292104 websites Russian- $250 \r\n.ru 514668 websites International zone Russian:.com.net.biz.info.org.name.tel.mobi.asia -$80 \r\n.ru.com 6499 websites Russia – $50 \r\n.ruhr 9887 websites – $50 \r\n.run 10622 websites – $50 \r\n.rw 244 websites – $50 \r\n.sa 5064 websites International zone Saudi Arabia:.com.net.biz.info.org.name.tel.mobi.asia \r\n.sa 11604 websites Saudi Arabia- $50 \r\n.saarland 3825 websites – $50 \r\n.sale 35407 websites – $50 \r\n.salon 1782 websites – $50 \r\n.sarl 939 websites – $50 \r\n.sc 4942 websites Seychelles- $50 \r\n.school 11672 websites – $50 \r\n.schule 4678 websites – $50 \r\n.science 74115 websites – $80 \r\n.scot 11175 websites – $50 \r\n.sd 619 websites – $50 \r\n.se 293316 websites International zone Sweden:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.se 1799365 websites Sweden – $150 \r\n.seat 618 websites – $50 \r\n.security 255 websites – $50 \r\n.services 52098 websites – $50 \r\n.sex 7655 websites – $50 \r\n.sexy 18260 websites – $50 \r\n.sg 164351 websites Republic Of Singapore – $50 \r\n.sh 9408 websites – $50 \r\n.shiksha 1626 websites – $50 \r\n.shoes 5007 websites – $50 \r\n.shop 402139 websites – $80 \r\n.shopping 6297 websites – $50 \r\n.show 6946 websites – $50 \r\n.si 12879 websites International zone Slovenia:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.si 39749 websites Slovenia- $50 \r\n.singles 3559 websites – $50 \r\n.site 384414 websites – $80 \r\n.sk 31572 websites International zone Slovakia:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.sk 347101 websites Slovakia- $80 \r\n.ski 5071 websites – $50 \r\n.sl 418 websites – $50 \r\n.sm 2009 websites – $50 \r\n.sn 344 websites International zone Senegal:.com.net.biz.info.org.name.tel.mobi.asia \r\n.sn 4954 websites Senegal – $50 \r\n.so 9003 websites – $50 \r\n.soccer 2833 websites – $50 \r\n.social 19134 websites – $50 \r\n.software 13001 websites – $50 \r\n.solar 7095 websites – $50 \r\n.solutions 81282 websites – $50 \r\n.soy 1200 websites – $50 \r\n.space 220771 websites – $80 \r\n.sr 638 – $50 \r\n.srl 4391 – $50 \r\n.st 7683 websites – $50 \r\n.storage 623 – $50 \r\n.store 167141 websites – $50 \r\n.stream 239795 websites – $80 \r\n.studio 39132 websites – $50 \r\n.study 5132 websites – $50 \r\n.style 9248 websites – $50 \r\n.su 125358 websites Russian- $50 \r\n.sucks 7629 websites – $50 \r\n.supplies 3082 websites – $50 \r\n.supply 4580 websites – $50 \r\n.support 20377 websites – $50 \r\n.surf 2573 websites – $50 \r\n.surgery 1778 websites – $50 \r\n.sv 8132 websites Salvador- $50 \r\n.swiss 17323 websites – $50 \r\n.sx 3240 websites – $50 \r\n.sy 2063 websites – $50 \r\n.sydney 10073 websites – $50 \r\n.systems 26094 websites – $50 \r\n.sz 194 websites – $50 \r\n.taipei 5664 websites – $50 \r\n.tattoo 2004 websites- $50 \r\n.tax 5788 websites – $50 \r\n.taxi 5784 websites – $50 \r\n.tc 16384 websites Turks and Caicos Islands- $50 \r\n.team 18421 websites- $50 \r\n.tech 196321 websites – $50 \r\n.technology 40181 websites- $50 \r\n.tel 80752 websites- $50 \r\n.tennis 1494 websites – $50 \r\n.tf 2049 websites – $50 \r\n.tg 521 websites – $50 \r\n.th 23968 websites Kingdom Of Thailand- $50 \r\n.theater 1053 websites – $50 \r\n.tickets 1141 websites – $50 \r\n.tienda 2951 websites – $50 \r\n.tips 31287 websites- $50 \r\n.tires 960 websites – $50 \r\n.tirol 5412 websites – $50 \r\n.tj 34 websites International zone Tajikistan:.com.net.biz.info.org.name.tel.mobi.asia \r\n.tj 6804 websites Tajikistan- $50 \r\n.tk 12799253 websites Tokelau – $450 \r\n.tl 2728 websites – $50 \r\n.tm 6056 websites Turkmenistan- $50 \r\n.tm 44 websites International zone Turkmenistan:.com.net.biz.info.org.name.tel.mobi.asia \r\n.tn 27383 websites – $50 \r\n.to 16987 websites Tonga- $50 \r\n.today 98034 websites – $50 \r\n.tokyo 90132 websites – $50 \r\n.tools 10439 websites – $50 \r\n.top 2140480 websites – $200 \r\n.tours 9151 websites – $50 \r\n.town 3328 websites – $50 \r\n.toys 4391 websites – $50 \r\n.tr 138818 International zone Turkey:.com.net.biz.info.org.name.tel.mobi.asia -$50 \r\n.tr 317690 websites Turkey – $80 \r\n.trade 151130 websites – $50 \r\n.trading 896 websites – $50 \r\n.training 18192 websites – $50 \r\n.travel 18054 websites – $50 \r\n.tt 516 websites – $50 \r\n.tube 2104 websites – $50 \r\n.tv 559502 websites Tuvalu – $80 \r\n.tw 243062 websites Taiwan – $50 \r\n.tz 1874 websites – $50 \r\n.ua 117701 websites International zone Ukraine:.com.net.biz.info.org.name.tel.mobi.asia-$50 \r\n.ua 553216 websites Ukraina – $80 \r\n.ug 2331 websites Ukraina \r\n.uk 3304606 websites International zone United Kingdom:.com.net.biz.info.org.name.tel.mobi.asia-$150 \r\n.uk 5496382 websites United Kingdom – $250 \r\n.university 5799 websites – $50 \r\n.uno 16394 websites – $50 \r\n.us 3139563 websites USA – $200 \r\n.us 578927 websites International zone USA:.com.net.biz.info.org.name.tel.mobi.asia-$80 \r\n.uy 14683 websites Uruguay – $50 \r\n.uz 365 websites International zone Uzbekistan:.com.net.biz.info.org.name.tel.mobi.asia \r\n.uz 14689 websites Uzbekistan – $50 \r\n.vacations 3926 websites – $50 \r\n.vc 16606 websites – $50 \r\n.ve 14015 websites Venezuela – $50 \r\n.vegas 18008 websites Las Vegas NV United States of America – $50 \r\n.ventures 10066 websites – $50 \r\n.versicherung 2009 websites – $50 \r\n.vet 5760 websites – $50 \r\n.vg 8389 site – $50 \r\n.viajes 2512 site – $50 \r\n.video 16204 websites- $50 \r\n.villas 1940 site – $50 \r\n.vin 5094 websites – $50 \r\n.vip 755289 websites – $80 \r\n.vision 6420 websites – $50 \r\n.vlaanderen 6114 websites – $50 \r\n.vn 161855 websites International zone Vietnam:.com.net.biz.info.org.name.tel.mobi.asia – $50 \r\n.vn 436005 websites Vietnam – $80 \r\n.vodka 1420 websites – $50 \r\n.vote 2316 websites – $50 \r\n.voto 269 websites – $50 \r\n.voyage 2773 websites – $50 \r\n.vu 1201 websites – $50 \r\n.wales 13063 websites – $50 \r\n.wang 604718 websites – $80 \r\n.watch 6120 websites – $50 \r\n.webcam 60142 websites – $50 \r\n.website 207002 websites -$50 \r\n.wedding 22162 websites – $50 \r\n.wf 1188 websites – $50 \r\n.wien 14464 websites – $50 \r\n.wien 14913 websites – $50 \r\n.wiki 14129 websites wikis – $50 \r\n.win 655735 websites – $80 \r\n.wine 13095 websites – $50 \r\n.work 256086 websites – $80 \r\n.works 15112 websites – $50 \r\n.world 86012 websites – $50 \r\n.ws 97008 websites Samoa- $80 \r\n.wtf 10038 websites – $50 \r\n.xin 178450 websites – $50 \r\n.xn--3ds443g 44019 websites – $50 \r\n.xn--55qx5d 47456 websites – $50 \r\n.xn--6qq986b3xl 18188 websites – $50 \r\n.xn--czr694b 21109 websites – $50 \r\n.xn--czru2d 9020 websites – $50 \r\n.xn--fiq228c5hs 12145 websites – $50 \r\n.xn--io0a7i 30199 websites – $50 \r\n.xn--j6w193g 31764 websites – $50 \r\n.xn--kput3i 31856 websites – $50 \r\n.xn--mgbaam7a8h 2038 websites – $50 \r\n.xn--mgberp4a5d4ar 2534 websites – $50 \r\n.xn--mk1bu44c 6001 websites – $50 \r\n.xn--rhqv96g 7723 websites – $50 \r\n.xn--ses554g 198539 websites – $80 \r\n.xn--tckwe 6197 websites – $50 \r\n.xn--vuq861b 19706 websites – $50 \r\n.xxx 119879 websites- $50 \r\n.xyz 1888763 websites – $150 \r\n.yachts 154 websites – $50 \r\n.yoga 7963 websites – $50 \r\n.yokohama 8140 websites – $50 \r\n.yt 2004 websites – $50 \r\n.za 837189 websites South Africa – $100 \r\n.zm 224 websites – $50 \r\n.zone 25798 websites – $50 \r\n.бг (.xn--90ae) 2470 websites – $50 \r\n.дети 169 websites – $50 \r\n.москва (.xn--80adxhks) 19582 websites Moscow – $50 \r\n.онлайн 3403 websites – $50 \r\n.орг 1160 websites – $50 \r\n.рус (.xn--p1acf) 110789 websites – $50 \r\n.рф (.xn--p1ai) 869759 websites Russia – $80 \r\n.сайт 1146 websites – $50 \r\n.укр (.xn--j1amh) 10563 websites- $50 \r\n.संगठन 105  sites – $50 \r\n>.みんな 166  sites – $50 \r\n.コム    6532  sites – $50 \r\n.世界    4171  sites – $50 \r\n.公司    46161  sites – $50 \r\n.商城    6 907  sites – $50 \r\n.商标    9865  sites – $50 \r\n.我爱你 15465  sites – $50 \r\n.手机    31543  sites – $50 \r\n.机构    243  sites – $50 \r\n.游戏    187  sites – $50 \r\n.移动    3277  sites – $50 \r\n.网店    3711  sites – $50 \r\n.网络    30808  sites – $50 \r\n.닷컴    5937  sites – $50 \r\n.بازار  sites 648 – $50 \r\n.شبكة   sites 833 – $50 \r\n.موقع   sites 478 – $50", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("794", "2", "169", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1097", "2", "231", "2", "Teresa", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1098", "2", "231", "8", "(832) 628-9006", "");
INSERT INTO `wp_gf_entry_meta` VALUES("797", "2", "169", "5", "linda_ledesma@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("798", "2", "169", "6", "iPhone X Giveaway 2019 - Participate to Win an iPhone X: http://www.abcagency.se/winiphone16786", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("799", "2", "170", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("802", "2", "170", "5", "melvinjs@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("803", "2", "170", "6", "Win an iPhone X | Free Competitions: http://jnl.io/winiphone42596", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("804", "2", "171", "2", "Ross Taylor", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("807", "2", "171", "5", "ANY", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("808", "2", "171", "6", "Hey,\r\n\r\nJust a quick note to say how much I enjoyed your website. I thought the layout and information was very informative.\r\n\r\nI’m writing to you because I noticed a technical issue that I wanted you to be aware of, it relates to how your search engine optimization is implemented. If you fix this issue it could have a really positive impact on performance. Do you want me to send you the issue or would you like me to jump on call so I can walk you through what I saw?\r\n\r\nRegards\r\n\r\nRoss Taylor\r\nDigital Marketing Manager\r\n888-417-4867\r\nSmarter Tactics\r\nDigital Marketing | AdWords Management | Content & Social | Influencer Marketing", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("809", "2", "172", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("812", "2", "172", "5", "kimloan094@yahoo.com.vn", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("813", "2", "172", "6", "Find yourself a girl for the night in your city: http://jnl.io/bestadultdating10754", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("814", "2", "173", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("817", "2", "173", "5", "cal_murph@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("818", "2", "173", "6", "Beautiful women for sex in your town: http://www.vkvi.net/bestadultdating58166", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("819", "2", "174", "2", "Keldaxy", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("822", "2", "174", "5", "kelSymn@emaill.host", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("823", "2", "174", "6", "Shipped Ups Stendra Medicine Comprar Viagra  <a href=http://sildenaf50.com>viagra</a> Tetracylin Kaufen Levitra Efectos En Jovenes", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("824", "2", "175", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("827", "2", "175", "5", "kritssriram@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("828", "2", "175", "6", "Beautiful women for sex in your town: http://www.abcagency.se/bestadultdating31035", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("829", "2", "176", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("832", "2", "176", "5", "nuyts.bram@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("833", "2", "176", "6", "Meet sexy girls in your city: http://www.vkvi.net/bestadultdating98052", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("834", "2", "177", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("837", "2", "177", "5", "belli081@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("838", "2", "177", "6", "Find yourself a girl for the night in your city: http://rih.co/bestadultdating91941", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("839", "2", "178", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1095", "2", "230", "5", "immediately", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1096", "2", "230", "6", "I called again tonight and left voicemail. The chairlift just does not work again. I called yesterday evening and spoke with John, then again I called and was instructed to try the lift and sitting in it and using the control on the lift it went up. We did not use it all day but kept an eye on the battery light. It stayed green all day. Then just about an hour ago we(his aide and I) tried to bring him up to bed and it inches along but stops after about 6 inches. It does not go up with the transmitter or on the seat controls. Suddenly the light turns yellow. My husband is 92 years old and disabled. We slept downstairs, I on a couch, he luckily has a 2nd bed. Please help.", "");
INSERT INTO `wp_gf_entry_meta` VALUES("842", "2", "178", "5", "alt659@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("843", "2", "178", "6", "Find yourself a girl for the night in your city: http://www.lookweb.it/bestadultdating24975", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("844", "2", "179", "2", "Tasha Miller", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1094", "2", "230", "9", "umcos@optonline.net", "");
INSERT INTO `wp_gf_entry_meta` VALUES("847", "2", "179", "5", "9am- 2pm", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("848", "2", "179", "6", "Looking to upgrade our wheelchair accessibility in an elementary school. Located in Springfield Gardens, Queens, NY.  Looking to set a site appointment.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("849", "2", "180", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1092", "2", "230", "2", "Ursula Cosentino", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1093", "2", "230", "8", "(203) 273-8821", "");
INSERT INTO `wp_gf_entry_meta` VALUES("852", "2", "180", "5", "helen463@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("853", "2", "180", "6", "Beautiful women for sex in your town: http://ttree.co/bestadultdating62157", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("854", "2", "181", "2", "Oknajax", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("857", "2", "181", "5", "stas.shapalovskiy@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("858", "2", "181", "6", "Мы одни из ведущих производителей изделий и светопрозрачных конструкций из алюминия и пластика в Нижнем Новгороде – рада приветствовать вас на своем сайте! Если вы ищите производство окон из пвх и алюминия по низким ценам, но с гарантией качества и в кратчайшие сроки, то обратились по адресу. Мы осуществляем продажу алюминиевых и пластиковых конструкций, а также их сборку и монтаж в Нижнем Новгороде. \r\n \r\nhttps://fabrika-komforta.ru/okna/plastikovye-okna/rehau/ - пластиковые окна rehau в нижнем новгороде  - подробнее на сайте Фабрики Комфорта https://fabrika-komforta.ru - fabrika-komforta.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("859", "2", "182", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("862", "2", "182", "5", "cdlaji@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("863", "2", "182", "6", "Beautiful women for sex in your town: http://corta.co/bestadultdating79698", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("864", "2", "183", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("867", "2", "183", "5", "cjd113@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("868", "2", "183", "6", "Invest $ 5,000 in Bitcoin mining once and get $ 7,000 passive income per month: https://lil.ink/investminingcrypto25067", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("869", "2", "184", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("872", "2", "184", "5", "rudolphcr@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("873", "2", "184", "6", "UPDATE: Cryptocurrency Investing Strategy - Q2 2019. Receive passive income of $ 7,000 per month: http://rih.co/investminingcrypto54127", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("874", "2", "185", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("877", "2", "185", "5", "braffo@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("878", "2", "185", "6", "How to invest in bitcoins in 2019 and receive passive income of $ 7,000 per month: http://rih.co/investminingcrypto77900", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("879", "2", "186", "2", "Linda Bailey", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("882", "2", "186", "5", "10:00", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("883", "2", "186", "6", "Hi\r\n\r\nWe did check your website and it is not on the first page of Google.\r\n\r\nWe are hereby offering our services to get you on the first page of Google so you can get more inquiries, leads, and sales from your website.\r\n\r\nPlease email us back for the full proposal.\r\n\r\nBest Regards\r\n\r\nLinda", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("884", "2", "187", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1091", "1", "229", "2", "I had  goten a chair lift from my friend and wanted it in stalled they came over to look at it and told me it didn\'t work they could not fix it they would recommend putting it in and they wanted to sell me a chair lift nevertheless  I refuse to purchase a chair lift from them I wanted to see if I could fix it a friend of mine came over and the fuse was blown we replace the fuse and the chairlift works it is now presently in my home and I am using it !  INot a good thing to do to a senior and i would not recommend this company they are not truthful !  Rip off didn\'t work !!!!", "");
INSERT INTO `wp_gf_entry_meta` VALUES("887", "2", "187", "5", "honeylicia@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("888", "2", "187", "6", "How to invest in bitcoins in 2019 and receive passive income of $ 7,000 per month: http://swish.st/investmining15694", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("889", "2", "188", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1090", "1", "229", "4", "Not  truthful try to rip me off !!!", "");
INSERT INTO `wp_gf_entry_meta` VALUES("892", "2", "188", "5", "gruia.codrut@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("893", "2", "188", "6", "Cryptocurrency Trading & Investing Strategy for 2019. Receive passive income of $ 7,000 per month: http://ttree.co/investminingcrypto37473", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("894", "2", "189", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1088", "1", "229", "1", "Vinnie", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1089", "1", "229", "6", "grating6c73f2247", "");
INSERT INTO `wp_gf_entry_meta` VALUES("897", "2", "189", "5", "adokusug@dsfgdsgmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("898", "2", "189", "6", "Invest in mining cryptocurrency $ 5000 once and get passive income of $ 7000 per month: http://ttree.co/investminingcrypto48232", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("899", "2", "190", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1086", "2", "228", "5", "test", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1087", "2", "228", "6", "test", "");
INSERT INTO `wp_gf_entry_meta` VALUES("902", "2", "190", "5", "su.s.ha.n.wu96@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("903", "2", "190", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://www.lookweb.it/investmining72852", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("904", "2", "191", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1085", "2", "228", "9", "bhills_0882@mailinator.com", "");
INSERT INTO `wp_gf_entry_meta` VALUES("907", "2", "191", "5", "blueyes495@aol.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("908", "2", "191", "6", "If you invested $1,000 in bitcoin in 2011, now you have $4 million: http://ttree.co/investminingcrypto90720", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("909", "2", "192", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1083", "2", "228", "2", "Beverly Hills", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1084", "2", "228", "8", "(310) 555-0882", "");
INSERT INTO `wp_gf_entry_meta` VALUES("912", "2", "192", "5", "alphabits@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("913", "2", "192", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://corta.co/investmining54803", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("914", "2", "193", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("917", "2", "193", "5", "cfangmann@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("918", "2", "193", "6", "How to invest in bitcoins in 2019 and receive passive income of $ 7,000 per month: http://rih.co/investminingcrypto34446", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("919", "2", "194", "2", "ChrisFeade", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("922", "2", "194", "5", "chrissf@yandex.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("923", "2", "194", "6", "Chris Stapleton is my favourite US singer. His strong voice takes me away from all problems of this world so I start enjoy my life and listen songs created by his voice. Now the singer is on a All-American Road Show Tour started in May of 2019. The concerts scheduled for this year, up to the November 2. Ticket prices are moderate and available for all men and women with different income. If you love country music as mush as I, then you must visit at least one of his concert. All tour dates are available at the <a href=https://christapletontour.com>Chris Stapleton tour Spokane</a>. Visit the website and make yourself familiar with all powerful Chris Stapleton concerts in 2019!", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("924", "2", "195", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1082", "2", "227", "6", "Hi there, We are interested to increase traffic to your website, please get back to us in order to discuss the possibility in further detail. Please mention your phone number and suitable time to talk Thanks.", "");
INSERT INTO `wp_gf_entry_meta` VALUES("927", "2", "195", "5", "dwight.west@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("928", "2", "195", "6", "Invest $ 5,000 in Bitcoin mining once and get $ 7,000 passive income per month: http://rih.co/investminingcrypto49655", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("929", "2", "196", "2", "Keldaxy", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1081", "2", "227", "5", "Anytime", "");
INSERT INTO `wp_gf_entry_meta` VALUES("932", "2", "196", "5", "kelSymn@emaill.host", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("933", "2", "196", "6", "Priligy Dernieres Nouvelles Purchase Generic Bentyl Dicyclomine Muscle Spasms Medication Tablet  <a href=http://cialiorder.com>cheapest cialis</a> Hydrochlorothiazide Drugs No Prescription Cialis Uberdosiert Your Online Pharmacy Se", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("934", "2", "197", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1079", "2", "227", "8", "(120) 120-1200", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1080", "2", "227", "9", "jessicarobertweb@gmail.com", "");
INSERT INTO `wp_gf_entry_meta` VALUES("937", "2", "197", "5", "colinbatko@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("938", "2", "197", "6", "Invest $ 5,000 in Bitcoin once and get $ 7,000 passive income per month: http://www.vkvi.net/investminingcrypto34095", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("939", "2", "198", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1078", "2", "227", "2", "Jessica Robert", "");
INSERT INTO `wp_gf_entry_meta` VALUES("942", "2", "198", "5", "eleonore-quetier11@hotmail.fr", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("943", "2", "198", "6", "Invest in mining cryptocurrency $ 5000 once and get passive income of $ 7000 per month: http://rih.co/investminingcrypto14912", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("944", "2", "199", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("947", "2", "199", "5", "annamariabonesse@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("948", "2", "199", "6", "Invest in mining cryptocurrency $ 5000 once and get passive income of $ 7000 per month: http://www.lookweb.it/investmining20466", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("949", "2", "200", "2", "PAUL FRANK/JP&C Construction, Inc.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("952", "2", "200", "6", "wheelchair lift", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("953", "2", "201", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("956", "2", "201", "5", "dizzycyandxt@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("957", "2", "201", "6", "UPDATE: Cryptocurrency Investing Strategy - Q2 2019. Receive passive income of $ 7,000 per month: http://corta.co/investminingcrypto67739", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("958", "2", "202", "2", "Seowot", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("961", "2", "202", "5", "dima.stoldusenko@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("962", "2", "202", "6", "Продвижение сайта Нижний Новгород      -  \r\n<a href=http://spclab.ru>Раскрутка сайтов</a>", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("963", "2", "203", "2", "Gerard Snover", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("966", "2", "203", "5", "9-5 M-F", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("967", "2", "203", "6", "Comerica bank is managing a residential property in Manhattan(Brownstone type home) and we are in need of installing chair lift for the elderly client that live there.  Please call me at 212-590-9992 at your earliest convenience.  I left a VM at your number today.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("968", "2", "204", "2", "Christina Miskiewicz", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("971", "2", "204", "6", "Do you need to run a freebie that generates a profit for you? \r\n\r\nHello there, \r\n\r\nDo you wish to run a giveaway that generates a profit for you?\r\n\r\nOur brushes generally sell for $24.00. However right now we’re going to give it to you and your visitors  free.\r\nDo not miss out on the opportunity to get this $24 brush.  \r\n \r\nWhy would we do that?\r\nTo promote our fabulous new American Beauty Association. \r\nSupplies are very limited. All brushes will be given out on a first come first serve basis.\r\nYou can read the details or try out it yourself here:  https://www.centtip.xyz\r\n\r\nThanks,\r\nMiskiewicz", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("972", "2", "205", "2", "Seowot", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1077", "2", "226", "6", "I bought a stairlift @ 2yrs ago from your company and to date we have been happy.   We really use the stairlift as it was brought for a sister who needs it during holiday visits @ 4 time a year.  Other times it is unused. \r\nYesterday, she was visiting and the chair continued to beep and started going up the stairs very slowly then just stopped.  However, when it was empty it moved well.  We tried with another person of @ same weight 200lbs chair would not move, then another person of less weight,again chair would not move.  We need this repaired urgently.  \r\nEugenia Beldo/ 93-228 215th Street, Queens Village, NY 11428.", "");
INSERT INTO `wp_gf_entry_meta` VALUES("975", "2", "205", "5", "mitya.perekrestenko@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("976", "2", "205", "6", "Раскрутка сайта по Нижнем Новгороде       -  \r\nhttp://nngid.ru - Раскрутка сайта", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("977", "2", "206", "2", "skyreveryheern", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1076", "2", "226", "5", "mid-day (or after 7pm)", "");
INSERT INTO `wp_gf_entry_meta` VALUES("980", "2", "206", "5", "malinoleg91@mail.ru", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("981", "2", "206", "6", "https://skyrevery.ru/airports/domodedovo-avkom/ - Домодедово-Авком        -  подробнее на нашем сайте https://skyrevery.ru - skyrevery.ru \r\nhttps://skyrevery.ru/ - Аренда частного самолета с экипажем в компании SkyRevery – это выбор тех, кто ценит свое время и живет по своему расписанию! \r\nАренда частного самолета помогает экономить самый важный ресурс – время. Арендовав частный самолет, именно Вы решаете, когда и куда полетите. Для выполнения чартерных рейсов мы предлагаем частные самолеты иностранного производства, гарантирующие высокий уровень комфорта и безопасности полета. Внимательные бортпроводники и высокопрофессиональные пилоты сделают Ваш полет максимально приятным и удобным. \r\nКогда Вам нужна https://skyrevery.ru/ - аренда самолета срочно, мы можем организовать для Вас вылет по готовности от 3 часов с момента подтверждения.", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("982", "2", "207", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1075", "2", "226", "9", "beldo@un.org", "");
INSERT INTO `wp_gf_entry_meta` VALUES("985", "2", "207", "5", "yeled@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("986", "2", "207", "6", "If you invested $1,000 in bitcoin in 2011, now you have $4 million: http://www.lookweb.it/investminingcrypto25559", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("987", "2", "208", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1073", "2", "226", "2", "Eugenia Beldo", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1074", "2", "226", "8", "(646) 238-5697", "");
INSERT INTO `wp_gf_entry_meta` VALUES("990", "2", "208", "5", "coger13@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("991", "2", "208", "6", "Invest $ 5,000 in Bitcoin mining once and get $ 7,000 passive income per month: http://www.abcagency.se/investminingcrypto65298", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("992", "2", "209", "2", "Jameskix", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("995", "2", "209", "5", "rutters6@yahoo.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("996", "2", "209", "6", "Invest $ 5,000 in Bitcoin mining once and get $ 7,000 passive income per month: http://webhop.se/investminingcrypto22049", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("997", "2", "210", "2", "ClarkOvant", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1071", "2", "225", "9", "kbcardi@charter.net", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1072", "2", "225", "6", "do all the chair lift chairs come with a foot rest.?", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1000", "2", "210", "5", "mobhome@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1001", "2", "210", "6", "Invest $ 5,000 in cryptocurrency once and get $ 7,000 passive income per month: http://rih.co/investminingcrypto10489", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1002", "2", "211", "2", "Bayer", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1069", "2", "225", "2", "karen cardi", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1070", "2", "225", "8", "(203) 521-4453", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1005", "2", "211", "6", "Hochwertige Waren vom Produzent. Fabrikverkauf.\r\nVersand am gleichen Tag aus Frankfurt. Bis 95 % günstiger als auf dem Markt.\r\n\r\nReifentüten mit und ohne Logo.\r\nStretch Folie. Alle Größen / Sorten.\r\nKartons.\r\nKlebebänder.\r\nMalerkrepp. Malerfolie. Werkzeug.\r\nSpänesäcke.\r\n\r\nAlles für Umreifung. Umreifungsband, Verpackungsband, Klemmen, Hülsen, Spanner…….\r\n\r\nGewebesäcke. Kartoffelsäcke. Laubsäcke.\r\nRaschelsäcke. Zwiebelsäcke.\r\nLuftpolsterfolie.\r\nBaufolie. Estrichfolie. Gartenfolie. Teichfolie. Abdeckfolie. Schutzfolie.\r\nPanzerband. Doppelklebeband. Teppichband.\r\nHandschuhe.\r\nMüllsäcke und Vieles mehr.\r\n\r\nInfo auf: folmax.pw\r\n\r\nMit freundlichen Grüßen", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1006", "2", "212", "2", "arthur mitchell", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1067", "2", "224", "5", "anytime", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1068", "2", "224", "6", "test 5", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1009", "2", "212", "5", "noon", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1010", "2", "212", "6", "looking for a quote", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1011", "2", "213", "2", "Franktek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1066", "2", "224", "8", "(914) 632-8798", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1014", "2", "213", "5", "kamenna@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1015", "2", "213", "6", "Hey. I will sell a profitable database of email addresses (19 000 000 emails) only to 3 people. \r\nAs seen on the screenshot below, from May 1 to May 16, I earned $ 13,000 on just one affiliate program. \r\nThis is a very good result. You will be able to promote your proposals on this database and be in a huge plus. \r\nI do not provide email distribution services, I send only my offers. \r\nI sell the base because it is a good way to earn extra money + my earnings in affiliate programs, the relevance of the base will not suffer from this. \r\nGEO base as you see mainly the United States and other developed solvent countries. \r\nI collected the base myself + bought from private sellers which you will not find anywhere else. \r\n \r\nBase format: \r\nmail1@gmail.com \r\nmail@mail.com \r\nMail3@hotmail.com \r\nThat is, only email addresses in a column. \r\nThe base price is $ 15,000 only in bitcoins at the current rate. \r\nIf you know why you need this database, you know how to make mass email mailings and are ready to buy an email sheet from me then write to me on the contacts below. \r\nI do not answer stupid questions, I just ignore them. \r\n \r\n \r\nProof-1: \r\nhttps://imgur.com/EtxAk8B \r\n \r\nThe total earned amount from email mailings from May 1 to 16: \r\nhttps://imgur.com/mmshjVH \r\n \r\n \r\nContact Telegram: \r\nhttps://t.me/maribright \r\n@maribright", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1016", "2", "214", "2", "LonnieDug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1064", "2", "224", "2", "martin friedrichs", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1065", "2", "224", "9", "marty.friedrichs@gmail.com", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1019", "2", "214", "5", "pitbullcasi@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1020", "2", "214", "6", "Hey. I will sell a profitable database of email addresses (19 000 000 emails) only to 3 people. \r\nAs seen on the screenshot below, from May 1 to May 16, I earned $ 13,000 on just one affiliate program. \r\nThis is a very good result. You will be able to promote your proposals on this database and be in a huge plus. \r\nI do not provide email distribution services, I send only my offers. \r\nI sell the base because it is a good way to earn extra money + my earnings in affiliate programs, the relevance of the base will not suffer from this. \r\nGEO base as you see mainly the United States and other developed solvent countries. \r\nI collected the base myself + bought from private sellers which you will not find anywhere else. \r\n \r\nBase format: \r\nmail1@gmail.com \r\nmail@mail.com \r\nMail3@hotmail.com \r\nThat is, only email addresses in a column. \r\nThe base price is $ 15,000 only in bitcoins at the current rate. \r\nIf you know why you need this database, you know how to make mass email mailings and are ready to buy an email sheet from me then write to me on the contacts below. \r\nI do not answer stupid questions, I just ignore them. \r\n \r\n \r\nProof-1: \r\nhttps://imgur.com/EtxAk8B \r\n \r\nThe total earned amount from email mailings from May 1 to 16: \r\nhttps://imgur.com/mmshjVH \r\n \r\n \r\nContact Telegram: \r\nhttps://t.me/maribright \r\n@maribright", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1021", "2", "215", "2", "RichardTug", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1063", "2", "223", "6", "test 4", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1024", "2", "215", "5", "sharonhv@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1025", "2", "215", "6", "Hey. I will sell a profitable database of email addresses (19 000 000 emails) only to 3 people. \r\nAs seen on the screenshot below, from May 1 to May 16, I earned $ 13,000 on just one affiliate program. \r\nThis is a very good result. You will be able to promote your proposals on this database and be in a huge plus. \r\nI do not provide email distribution services, I send only my offers. \r\nI sell the base because it is a good way to earn extra money + my earnings in affiliate programs, the relevance of the base will not suffer from this. \r\nGEO base as you see mainly the United States and other developed solvent countries. \r\nI collected the base myself + bought from private sellers which you will not find anywhere else. \r\n \r\nBase format: \r\nmail1@gmail.com \r\nmail@mail.com \r\nMail3@hotmail.com \r\nThat is, only email addresses in a column. \r\nThe base price is $ 15,000 only in bitcoins at the current rate. \r\nIf you know why you need this database, you know how to make mass email mailings and are ready to buy an email sheet from me then write to me on the contacts below. \r\nI do not answer stupid questions, I just ignore them. \r\n \r\n \r\nProof-1: \r\nhttps://imgur.com/EtxAk8B \r\n \r\nThe total earned amount from email mailings from May 1 to 16: \r\nhttps://imgur.com/mmshjVH \r\n \r\n \r\nContact Telegram: \r\nhttps://t.me/maribright \r\n@maribright", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1026", "2", "216", "2", "Martin Friedrichs", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1028", "2", "216", "5", "test 1", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1029", "2", "216", "6", "this is just a test", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1030", "2", "217", "2", "Martin Friedrichs", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1061", "2", "223", "8", "(914) 632-8798", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1062", "2", "223", "5", "anytime", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1033", "2", "217", "5", "test 2 from contact page", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1034", "2", "217", "6", "has phone number not email but failed with no email", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1035", "2", "218", "2", "WilliamTek", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1060", "2", "223", "9", "marty.friedrichs@gmail.com", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1038", "2", "218", "5", "olindagonzalesyocya@hotmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1039", "2", "218", "6", "Sexy girls for the night in your town: https://aaa.moda/bestadultdating34635", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1040", "2", "219", "2", "Javiermox", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1058", "2", "222", "6", "this is test 3", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1059", "2", "223", "2", "martin f", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1043", "2", "219", "5", "Joe33.leong.facebook@gmail.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1044", "2", "219", "6", "The best girls for sex in your town: http://www.abcagency.se/bestadultdating48861", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1045", "2", "220", "2", "Miguelmub", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1057", "2", "222", "8", "(914) 632-8798", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1048", "2", "220", "5", "jacobjudson@live.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1049", "2", "220", "6", "Find yourself a girl for the night in your city Canada: http://www.vkvi.net/bestadultdating67841", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1050", "2", "221", "2", "Robertbep", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1055", "2", "222", "2", "martin f", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1056", "2", "222", "9", "martin@gmail.com", "");
INSERT INTO `wp_gf_entry_meta` VALUES("1053", "2", "221", "5", "mankak717@msn.com", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("1054", "2", "221", "6", "The best women for sex in your town AU: http://jnl.io/bestadultdating41091", NULL);

/* INSERT TABLE DATA: wp_gf_form */
INSERT INTO `wp_gf_form` VALUES("1", "Submit Review", "2019-01-02 05:39:13", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("2", "Contact Us", "2019-02-01 11:24:06", NULL, "1", "0");

/* INSERT TABLE DATA: wp_gf_form_meta */
INSERT INTO `wp_gf_form_meta` VALUES("1", "{\"title\":\"Submit Review\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit Review\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"post_title\",\"id\":1,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"formId\":1,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"visibility\":\"visible\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"displayOnly\":\"\",\"saveAsCPT\":\"review\",\"fields\":\"\",\"maxLength\":\"\",\"pageNumber\":1,\"inputMaskIsCustom\":false},{\"type\":\"survey\",\"id\":6,\"label\":\"Rating\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"enableChoiceValue\":true,\"enablePrice\":false,\"gsurveyLikertEnableMultipleRows\":false,\"gsurveyLikertEnableScoring\":false,\"choices\":[{\"text\":\"1\",\"value\":\"grating6c43de000\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"2\",\"value\":\"grating69485f234\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"3\",\"value\":\"grating6107a7d25\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"4\",\"value\":\"grating617fed236\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"5\",\"value\":\"grating6c73f2247\",\"isSelected\":false,\"price\":\"\"}],\"gsurveyLikertRows\":[{\"text\":\"First row\",\"value\":\"glikertrowfae4c04f\"},{\"text\":\"Second row\",\"value\":\"glikertrowd04e9eb9\"},{\"text\":\"Third row\",\"value\":\"glikertrow48b52e48\"},{\"text\":\"Fourth row\",\"value\":\"glikertrowffee06e5\"},{\"text\":\"Fifth row\",\"value\":\"glikertrowfadf233e\"}],\"inputType\":\"rating\",\"formId\":1,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"reversed\":true,\"pageNumber\":1,\"displayOnly\":\"\",\"fields\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\"},{\"type\":\"post_custom_field\",\"id\":4,\"label\":\"Review Title\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"inputType\":\"text\",\"formId\":1,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePasswordInput\":\"\",\"maxLength\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"displayOnly\":\"\",\"postCustomFieldName\":\"ss_review_title\",\"fields\":\"\",\"inputMaskIsCustom\":\"\"},{\"type\":\"post_content\",\"id\":2,\"label\":\"Review\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"inputs\":null,\"formId\":1,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"visibility\":\"visible\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"displayOnly\":\"\",\"fields\":\"\",\"maxLength\":\"\",\"pageNumber\":1,\"inputMaskIsCustom\":\"\"},{\"type\":\"captcha\",\"id\":7,\"label\":\"CAPTCHA\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"formId\":1,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":\"\",\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"captchaType\":\"\",\"captchaTheme\":\"\",\"pageNumber\":1,\"fields\":\"\"}],\"version\":\"2.4.9\",\"id\":1,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"postAuthor\":\"4\",\"postCategory\":\"1\",\"postFormat\":\"0\",\"postStatus\":\"draft\",\"subLabelPlacement\":\"below\",\"cssClass\":\"ss-review-form-custom\",\"enableHoneypot\":false,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"nextFieldId\":8}", NULL, "{\"58526de90a003\":{\"id\":\"58526de90a003\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thank You for Your Review.\\r\\n\\r\\nWe pride ourselves on World Class Service.\\r\\n\\r\\nAnd look forward to your feedback with your experience. \\u00a0We will be in contact with you soon.\",\"url\":\"\",\"pageId\":0,\"queryString\":\"\",\"disableAutoformat\":false,\"conditionalLogic\":[]}}", "{\"58526de909cd8\":{\"isActive\":true,\"id\":\"58526de909cd8\",\"name\":\"Admin Notification\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"westchesterstairlift@gmail.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"New submission from Review Form\",\"message\":\"{all_fields}\\r\\n-------------------------------------------\\r\\nThis message is sent from http:\\/\\/surfct.com\\/ {form_title} Form.\",\"from\":\"{admin_email}\",\"fromName\":\"{Name:1}\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("2", "{\"title\":\"Contact Us\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":2,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Name*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePasswordInput\":\"\",\"maxLength\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"displayOnly\":\"\",\"fields\":\"\",\"inputMaskIsCustom\":false},{\"type\":\"phone\",\"id\":8,\"label\":\"Phone\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"standard\",\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Phone number*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"form_id\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"email\",\"id\":9,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Email address\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"emailConfirmEnabled\":false,\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"type\":\"text\",\"id\":5,\"label\":\"Time\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Best time to contact\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePasswordInput\":\"\",\"maxLength\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"displayOnly\":\"\",\"fields\":\"\",\"inputMaskIsCustom\":false},{\"type\":\"textarea\",\"id\":6,\"label\":\"Textarea\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Specific information you need or issues you want to discuss\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"form_id\":\"\",\"useRichTextEditor\":false,\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"pageNumber\":1,\"displayOnly\":\"\",\"fields\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\"},{\"type\":\"captcha\",\"id\":7,\"label\":\"CAPTCHA\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"captchaType\":\"\",\"captchaTheme\":\"\",\"pageNumber\":1,\"fields\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false}],\"version\":\"2.4.9\",\"id\":2,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":10}", NULL, "{\"5c542c56775b6\":{\"id\":\"5c542c56775b6\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"5c542c5677364\":{\"isActive\":true,\"id\":\"5c542c5677364\",\"name\":\"Admin Notification\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"westchesterstairlift@gmail.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"from\":\"{admin_email}\",\"fromName\":\"{Name:2}\",\"replyTo\":\"westchesterstairlift@gmail.com\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false}}");

/* INSERT TABLE DATA: wp_gf_form_view */
INSERT INTO `wp_gf_form_view` VALUES("1", "1", "2019-01-02 11:13:16", "", "20");
INSERT INTO `wp_gf_form_view` VALUES("2", "1", "2019-01-03 14:34:58", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("3", "1", "2019-01-04 15:51:00", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("4", "1", "2019-01-06 05:31:01", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("5", "1", "2019-01-07 20:27:40", "", "15");
INSERT INTO `wp_gf_form_view` VALUES("6", "1", "2019-01-09 19:05:43", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("7", "1", "2019-01-14 10:27:10", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("8", "1", "2019-01-20 03:16:40", "", "16");
INSERT INTO `wp_gf_form_view` VALUES("9", "1", "2019-01-23 15:02:52", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("10", "1", "2019-01-25 05:33:49", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("11", "1", "2019-01-27 16:23:38", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("12", "1", "2019-01-29 15:58:37", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("13", "1", "2019-01-31 17:01:21", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("14", "1", "2019-02-05 03:59:36", "", "11");
INSERT INTO `wp_gf_form_view` VALUES("15", "2", "2019-02-05 08:48:15", "", "11");
INSERT INTO `wp_gf_form_view` VALUES("16", "1", "2019-02-06 16:21:55", "", "20");
INSERT INTO `wp_gf_form_view` VALUES("17", "2", "2019-02-06 16:34:33", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("18", "2", "2019-02-07 20:19:41", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("19", "1", "2019-02-07 20:19:49", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("20", "2", "2019-02-10 06:03:05", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("21", "1", "2019-02-10 06:05:23", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("22", "1", "2019-02-12 12:11:04", "", "14");
INSERT INTO `wp_gf_form_view` VALUES("23", "2", "2019-02-13 07:57:40", "", "22");
INSERT INTO `wp_gf_form_view` VALUES("24", "1", "2019-02-13 12:16:10", "", "15");
INSERT INTO `wp_gf_form_view` VALUES("25", "1", "2019-02-14 15:17:08", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("26", "2", "2019-02-14 20:15:03", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("27", "1", "2019-02-22 21:42:30", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("28", "1", "2019-02-24 03:45:51", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("29", "2", "2019-02-24 03:46:41", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("30", "2", "2019-02-25 04:57:58", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("31", "1", "2019-02-25 20:20:32", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("32", "2", "2019-02-26 05:58:15", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("33", "2", "2019-03-04 18:48:25", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("34", "1", "2019-03-04 19:04:32", "", "30");
INSERT INTO `wp_gf_form_view` VALUES("35", "1", "2019-03-05 19:12:27", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("36", "2", "2019-03-06 09:55:54", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("37", "1", "2019-03-06 19:58:27", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("38", "2", "2019-03-07 11:28:09", "", "22");
INSERT INTO `wp_gf_form_view` VALUES("39", "1", "2019-03-08 02:19:24", "", "13");
INSERT INTO `wp_gf_form_view` VALUES("40", "2", "2019-03-08 13:36:55", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("41", "2", "2019-03-09 20:39:14", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("42", "1", "2019-03-10 10:56:04", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("43", "2", "2019-03-11 01:04:39", "", "18");
INSERT INTO `wp_gf_form_view` VALUES("44", "1", "2019-03-12 12:59:44", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("45", "2", "2019-03-12 14:48:04", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("46", "1", "2019-03-13 16:03:25", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("47", "2", "2019-03-13 16:49:21", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("48", "1", "2019-03-14 18:39:28", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("49", "2", "2019-03-14 19:46:08", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("50", "1", "2019-03-15 19:12:21", "", "11");
INSERT INTO `wp_gf_form_view` VALUES("51", "2", "2019-03-15 21:17:32", "", "25");
INSERT INTO `wp_gf_form_view` VALUES("52", "1", "2019-03-16 23:52:17", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("53", "2", "2019-03-17 09:22:42", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("54", "1", "2019-03-17 23:53:09", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("55", "2", "2019-03-18 13:26:10", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("56", "1", "2019-03-19 04:18:04", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("57", "2", "2019-03-19 13:42:18", "", "52");
INSERT INTO `wp_gf_form_view` VALUES("58", "2", "2019-03-20 14:13:07", "", "391");
INSERT INTO `wp_gf_form_view` VALUES("59", "1", "2019-03-20 15:12:35", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("60", "2", "2019-03-21 14:15:43", "", "253");
INSERT INTO `wp_gf_form_view` VALUES("61", "1", "2019-03-21 16:43:12", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("62", "2", "2019-03-22 14:20:39", "", "342");
INSERT INTO `wp_gf_form_view` VALUES("63", "1", "2019-03-22 17:24:09", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("64", "2", "2019-03-23 14:34:56", "", "202");
INSERT INTO `wp_gf_form_view` VALUES("65", "1", "2019-03-23 18:10:06", "", "13");
INSERT INTO `wp_gf_form_view` VALUES("66", "2", "2019-03-24 14:41:11", "", "171");
INSERT INTO `wp_gf_form_view` VALUES("67", "1", "2019-03-25 00:41:35", "", "14");
INSERT INTO `wp_gf_form_view` VALUES("68", "2", "2019-03-25 14:50:51", "", "240");
INSERT INTO `wp_gf_form_view` VALUES("69", "1", "2019-03-26 02:23:45", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("70", "2", "2019-03-26 15:32:19", "", "231");
INSERT INTO `wp_gf_form_view` VALUES("71", "1", "2019-03-27 08:38:29", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("72", "2", "2019-03-27 15:33:14", "", "228");
INSERT INTO `wp_gf_form_view` VALUES("73", "1", "2019-03-28 14:02:12", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("74", "2", "2019-03-28 15:41:19", "", "234");
INSERT INTO `wp_gf_form_view` VALUES("75", "2", "2019-03-29 15:41:44", "", "61");
INSERT INTO `wp_gf_form_view` VALUES("76", "1", "2019-03-29 19:05:00", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("77", "2", "2019-03-30 17:22:58", "", "127");
INSERT INTO `wp_gf_form_view` VALUES("78", "1", "2019-03-30 23:37:20", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("79", "2", "2019-03-31 17:25:39", "", "170");
INSERT INTO `wp_gf_form_view` VALUES("80", "1", "2019-04-01 02:05:40", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("81", "2", "2019-04-01 17:26:24", "", "140");
INSERT INTO `wp_gf_form_view` VALUES("82", "1", "2019-04-02 03:29:26", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("83", "2", "2019-04-02 17:27:26", "", "147");
INSERT INTO `wp_gf_form_view` VALUES("84", "1", "2019-04-03 05:27:08", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("85", "2", "2019-04-03 17:29:49", "", "197");
INSERT INTO `wp_gf_form_view` VALUES("86", "1", "2019-04-04 08:34:34", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("87", "2", "2019-04-04 17:39:24", "", "120");
INSERT INTO `wp_gf_form_view` VALUES("88", "1", "2019-04-05 17:00:42", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("89", "2", "2019-04-05 17:49:42", "", "182");
INSERT INTO `wp_gf_form_view` VALUES("90", "1", "2019-04-06 18:36:27", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("91", "2", "2019-04-06 18:40:04", "", "120");
INSERT INTO `wp_gf_form_view` VALUES("92", "2", "2019-04-07 18:57:45", "", "116");
INSERT INTO `wp_gf_form_view` VALUES("93", "2", "2019-04-07 18:57:45", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("94", "1", "2019-04-07 23:27:27", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("95", "2", "2019-04-08 19:12:27", "", "168");
INSERT INTO `wp_gf_form_view` VALUES("96", "1", "2019-04-09 02:53:33", "", "14");
INSERT INTO `wp_gf_form_view` VALUES("97", "2", "2019-04-09 19:18:21", "", "199");
INSERT INTO `wp_gf_form_view` VALUES("98", "1", "2019-04-10 07:32:06", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("99", "2", "2019-04-10 19:36:15", "", "130");
INSERT INTO `wp_gf_form_view` VALUES("100", "1", "2019-04-11 07:35:29", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("101", "2", "2019-04-11 20:34:56", "", "143");
INSERT INTO `wp_gf_form_view` VALUES("102", "1", "2019-04-12 14:51:30", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("103", "2", "2019-04-12 20:50:20", "", "109");
INSERT INTO `wp_gf_form_view` VALUES("104", "1", "2019-04-13 17:25:08", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("105", "2", "2019-04-13 20:59:42", "", "148");
INSERT INTO `wp_gf_form_view` VALUES("106", "2", "2019-04-14 21:22:23", "", "141");
INSERT INTO `wp_gf_form_view` VALUES("107", "1", "2019-04-14 21:23:45", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("108", "2", "2019-04-15 21:29:59", "", "143");
INSERT INTO `wp_gf_form_view` VALUES("109", "1", "2019-04-15 22:31:49", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("110", "2", "2019-04-16 21:31:24", "", "231");
INSERT INTO `wp_gf_form_view` VALUES("111", "1", "2019-04-17 04:45:06", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("112", "2", "2019-04-17 21:49:02", "", "122");
INSERT INTO `wp_gf_form_view` VALUES("113", "2", "2019-04-18 21:49:59", "", "186");
INSERT INTO `wp_gf_form_view` VALUES("114", "1", "2019-04-19 03:18:11", "", "14");
INSERT INTO `wp_gf_form_view` VALUES("115", "2", "2019-04-19 21:54:03", "", "120");
INSERT INTO `wp_gf_form_view` VALUES("116", "1", "2019-04-20 04:14:40", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("117", "2", "2019-04-20 22:10:05", "", "140");
INSERT INTO `wp_gf_form_view` VALUES("118", "1", "2019-04-21 04:25:13", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("119", "2", "2019-04-21 22:28:05", "", "175");
INSERT INTO `wp_gf_form_view` VALUES("120", "1", "2019-04-22 15:20:37", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("121", "2", "2019-04-22 22:28:06", "", "167");
INSERT INTO `wp_gf_form_view` VALUES("122", "1", "2019-04-23 16:57:01", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("123", "2", "2019-04-23 22:32:50", "", "134");
INSERT INTO `wp_gf_form_view` VALUES("124", "2", "2019-04-24 22:57:24", "", "164");
INSERT INTO `wp_gf_form_view` VALUES("125", "1", "2019-04-25 04:34:06", "", "15");
INSERT INTO `wp_gf_form_view` VALUES("126", "2", "2019-04-25 23:45:22", "", "177");
INSERT INTO `wp_gf_form_view` VALUES("127", "1", "2019-04-26 15:47:07", "", "16");
INSERT INTO `wp_gf_form_view` VALUES("128", "2", "2019-04-26 23:46:36", "", "147");
INSERT INTO `wp_gf_form_view` VALUES("129", "1", "2019-04-27 23:37:50", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("130", "2", "2019-04-28 00:20:37", "", "94");
INSERT INTO `wp_gf_form_view` VALUES("131", "2", "2019-04-29 00:36:47", "", "116");
INSERT INTO `wp_gf_form_view` VALUES("132", "1", "2019-04-29 02:53:52", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("133", "2", "2019-04-30 00:38:53", "", "101");
INSERT INTO `wp_gf_form_view` VALUES("134", "1", "2019-04-30 08:53:31", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("135", "2", "2019-05-01 00:42:27", "", "111");
INSERT INTO `wp_gf_form_view` VALUES("136", "1", "2019-05-01 16:18:57", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("137", "2", "2019-05-02 01:04:31", "", "131");
INSERT INTO `wp_gf_form_view` VALUES("138", "1", "2019-05-02 19:37:01", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("139", "2", "2019-05-03 01:48:04", "", "139");
INSERT INTO `wp_gf_form_view` VALUES("140", "1", "2019-05-03 20:13:41", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("141", "2", "2019-05-04 02:17:56", "", "84");
INSERT INTO `wp_gf_form_view` VALUES("142", "1", "2019-05-04 22:01:37", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("143", "2", "2019-05-05 07:00:45", "", "106");
INSERT INTO `wp_gf_form_view` VALUES("144", "1", "2019-05-05 22:02:56", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("145", "2", "2019-05-06 07:45:28", "", "117");
INSERT INTO `wp_gf_form_view` VALUES("146", "1", "2019-05-07 02:58:25", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("147", "2", "2019-05-07 08:03:04", "", "90");
INSERT INTO `wp_gf_form_view` VALUES("148", "2", "2019-05-08 08:03:39", "", "146");
INSERT INTO `wp_gf_form_view` VALUES("149", "1", "2019-05-08 09:06:24", "", "16");
INSERT INTO `wp_gf_form_view` VALUES("150", "2", "2019-05-09 08:27:59", "", "82");
INSERT INTO `wp_gf_form_view` VALUES("151", "1", "2019-05-09 10:16:42", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("152", "2", "2019-05-10 08:40:20", "", "138");
INSERT INTO `wp_gf_form_view` VALUES("153", "1", "2019-05-10 11:25:41", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("154", "2", "2019-05-11 09:13:07", "", "130");
INSERT INTO `wp_gf_form_view` VALUES("155", "1", "2019-05-11 17:01:31", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("156", "2", "2019-05-12 09:17:10", "", "204");
INSERT INTO `wp_gf_form_view` VALUES("157", "1", "2019-05-12 20:48:26", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("158", "2", "2019-05-13 10:10:45", "", "155");
INSERT INTO `wp_gf_form_view` VALUES("159", "1", "2019-05-13 22:04:33", "", "14");
INSERT INTO `wp_gf_form_view` VALUES("160", "2", "2019-05-14 10:13:05", "", "156");
INSERT INTO `wp_gf_form_view` VALUES("161", "1", "2019-05-15 08:26:19", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("162", "2", "2019-05-15 10:14:11", "", "200");
INSERT INTO `wp_gf_form_view` VALUES("163", "1", "2019-05-16 10:05:43", "", "11");
INSERT INTO `wp_gf_form_view` VALUES("164", "2", "2019-05-16 10:49:37", "", "208");
INSERT INTO `wp_gf_form_view` VALUES("165", "1", "2019-05-17 10:23:26", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("166", "2", "2019-05-17 10:57:51", "", "142");
INSERT INTO `wp_gf_form_view` VALUES("167", "2", "2019-05-18 10:58:32", "", "149");
INSERT INTO `wp_gf_form_view` VALUES("168", "1", "2019-05-19 07:34:21", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("169", "2", "2019-05-19 11:00:55", "", "203");
INSERT INTO `wp_gf_form_view` VALUES("170", "2", "2019-05-20 11:02:04", "", "141");
INSERT INTO `wp_gf_form_view` VALUES("171", "1", "2019-05-20 12:37:18", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("172", "2", "2019-05-21 11:08:14", "", "201");
INSERT INTO `wp_gf_form_view` VALUES("173", "1", "2019-05-21 17:04:18", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("174", "2", "2019-05-22 11:09:00", "", "190");
INSERT INTO `wp_gf_form_view` VALUES("175", "1", "2019-05-22 20:34:36", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("176", "2", "2019-05-23 11:16:53", "", "214");
INSERT INTO `wp_gf_form_view` VALUES("177", "1", "2019-05-24 01:17:16", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("178", "2", "2019-05-24 11:27:14", "", "287");
INSERT INTO `wp_gf_form_view` VALUES("179", "1", "2019-05-25 09:29:35", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("180", "2", "2019-05-25 11:31:08", "", "124");
INSERT INTO `wp_gf_form_view` VALUES("181", "1", "2019-05-26 09:34:14", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("182", "2", "2019-05-26 11:38:32", "", "185");
INSERT INTO `wp_gf_form_view` VALUES("183", "1", "2019-05-27 11:06:58", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("184", "2", "2019-05-27 11:46:38", "", "166");
INSERT INTO `wp_gf_form_view` VALUES("185", "2", "2019-05-28 12:12:32", "", "182");
INSERT INTO `wp_gf_form_view` VALUES("186", "1", "2019-05-28 15:54:27", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("187", "2", "2019-05-29 13:01:59", "", "95");
INSERT INTO `wp_gf_form_view` VALUES("188", "1", "2019-05-30 02:05:26", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("189", "2", "2019-05-30 13:06:07", "", "95");
INSERT INTO `wp_gf_form_view` VALUES("190", "1", "2019-05-31 06:49:20", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("191", "2", "2019-05-31 13:16:12", "", "75");
INSERT INTO `wp_gf_form_view` VALUES("192", "2", "2019-06-01 13:53:11", "", "80");
INSERT INTO `wp_gf_form_view` VALUES("193", "1", "2019-06-02 00:10:07", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("194", "2", "2019-06-02 13:54:32", "", "60");
INSERT INTO `wp_gf_form_view` VALUES("195", "1", "2019-06-03 10:11:20", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("196", "2", "2019-06-03 14:00:04", "", "130");
INSERT INTO `wp_gf_form_view` VALUES("197", "1", "2019-06-04 13:07:58", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("198", "2", "2019-06-04 14:07:35", "", "110");
INSERT INTO `wp_gf_form_view` VALUES("199", "2", "2019-06-05 14:09:04", "", "134");
INSERT INTO `wp_gf_form_view` VALUES("200", "1", "2019-06-05 14:19:25", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("201", "2", "2019-06-06 14:18:10", "", "127");
INSERT INTO `wp_gf_form_view` VALUES("202", "1", "2019-06-06 20:50:12", "", "13");
INSERT INTO `wp_gf_form_view` VALUES("203", "2", "2019-06-07 15:07:36", "", "108");
INSERT INTO `wp_gf_form_view` VALUES("204", "2", "2019-06-08 15:17:45", "", "105");
INSERT INTO `wp_gf_form_view` VALUES("205", "1", "2019-06-09 11:00:17", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("206", "2", "2019-06-09 15:33:05", "", "135");
INSERT INTO `wp_gf_form_view` VALUES("207", "1", "2019-06-10 11:03:23", "", "9");
INSERT INTO `wp_gf_form_view` VALUES("208", "2", "2019-06-10 15:36:16", "", "115");
INSERT INTO `wp_gf_form_view` VALUES("209", "2", "2019-06-11 15:44:45", "", "185");
INSERT INTO `wp_gf_form_view` VALUES("210", "1", "2019-06-12 03:11:32", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("211", "2", "2019-06-12 16:12:36", "", "157");
INSERT INTO `wp_gf_form_view` VALUES("212", "1", "2019-06-13 07:52:45", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("213", "2", "2019-06-13 16:48:40", "", "184");
INSERT INTO `wp_gf_form_view` VALUES("214", "1", "2019-06-14 08:01:41", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("215", "2", "2019-06-14 17:32:47", "", "174");
INSERT INTO `wp_gf_form_view` VALUES("216", "2", "2019-06-15 17:41:09", "", "105");
INSERT INTO `wp_gf_form_view` VALUES("217", "1", "2019-06-15 18:56:01", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("218", "2", "2019-06-16 17:43:07", "", "141");
INSERT INTO `wp_gf_form_view` VALUES("219", "1", "2019-06-16 20:28:20", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("220", "2", "2019-06-17 17:48:20", "", "178");
INSERT INTO `wp_gf_form_view` VALUES("221", "1", "2019-06-18 08:30:04", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("222", "2", "2019-06-18 17:54:13", "", "243");
INSERT INTO `wp_gf_form_view` VALUES("223", "1", "2019-06-19 11:59:15", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("224", "2", "2019-06-19 18:03:33", "", "203");
INSERT INTO `wp_gf_form_view` VALUES("225", "1", "2019-06-20 13:57:19", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("226", "2", "2019-06-20 18:13:28", "", "163");
INSERT INTO `wp_gf_form_view` VALUES("227", "2", "2019-06-21 18:20:54", "", "144");
INSERT INTO `wp_gf_form_view` VALUES("228", "1", "2019-06-22 04:29:40", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("229", "2", "2019-06-22 18:21:24", "", "120");
INSERT INTO `wp_gf_form_view` VALUES("230", "1", "2019-06-23 15:44:07", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("231", "2", "2019-06-23 18:45:17", "", "205");
INSERT INTO `wp_gf_form_view` VALUES("232", "1", "2019-06-24 15:49:36", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("233", "2", "2019-06-24 18:50:03", "", "173");
INSERT INTO `wp_gf_form_view` VALUES("234", "2", "2019-06-25 19:01:22", "", "166");
INSERT INTO `wp_gf_form_view` VALUES("235", "2", "2019-06-26 19:02:43", "", "198");
INSERT INTO `wp_gf_form_view` VALUES("236", "1", "2019-06-26 20:26:47", "", "13");
INSERT INTO `wp_gf_form_view` VALUES("237", "2", "2019-06-27 19:04:01", "", "175");
INSERT INTO `wp_gf_form_view` VALUES("238", "1", "2019-06-28 00:56:02", "", "11");
INSERT INTO `wp_gf_form_view` VALUES("239", "2", "2019-06-28 19:05:49", "", "97");
INSERT INTO `wp_gf_form_view` VALUES("240", "1", "2019-06-29 16:30:13", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("241", "2", "2019-06-29 20:45:51", "", "77");
INSERT INTO `wp_gf_form_view` VALUES("242", "1", "2019-06-30 16:31:31", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("243", "2", "2019-06-30 21:24:54", "", "96");
INSERT INTO `wp_gf_form_view` VALUES("244", "1", "2019-07-01 19:46:41", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("245", "2", "2019-07-01 23:16:54", "", "97");
INSERT INTO `wp_gf_form_view` VALUES("246", "2", "2019-07-02 23:22:46", "", "137");
INSERT INTO `wp_gf_form_view` VALUES("247", "1", "2019-07-03 00:41:33", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("248", "2", "2019-07-03 23:24:47", "", "91");
INSERT INTO `wp_gf_form_view` VALUES("249", "1", "2019-07-05 00:25:36", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("250", "2", "2019-07-05 01:07:07", "", "113");
INSERT INTO `wp_gf_form_view` VALUES("251", "2", "2019-07-06 01:21:30", "", "121");
INSERT INTO `wp_gf_form_view` VALUES("252", "1", "2019-07-06 03:32:45", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("253", "2", "2019-07-07 01:24:32", "", "93");
INSERT INTO `wp_gf_form_view` VALUES("254", "1", "2019-07-07 08:58:42", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("255", "2", "2019-07-08 02:24:32", "", "122");
INSERT INTO `wp_gf_form_view` VALUES("256", "1", "2019-07-08 13:08:49", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("257", "2", "2019-07-09 02:33:20", "", "119");
INSERT INTO `wp_gf_form_view` VALUES("258", "2", "2019-07-10 02:35:37", "", "145");
INSERT INTO `wp_gf_form_view` VALUES("259", "1", "2019-07-10 07:26:14", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("260", "2", "2019-07-11 02:37:13", "", "103");
INSERT INTO `wp_gf_form_view` VALUES("261", "1", "2019-07-11 10:02:23", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("262", "2", "2019-07-12 04:39:15", "", "210");
INSERT INTO `wp_gf_form_view` VALUES("263", "1", "2019-07-13 04:06:45", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("264", "2", "2019-07-13 04:45:41", "", "189");
INSERT INTO `wp_gf_form_view` VALUES("265", "2", "2019-07-14 04:54:52", "", "145");
INSERT INTO `wp_gf_form_view` VALUES("266", "1", "2019-07-14 06:17:13", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("267", "2", "2019-07-15 05:08:08", "", "32");
INSERT INTO `wp_gf_form_view` VALUES("268", "1", "2019-07-15 09:48:18", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("269", "2", "2019-07-25 14:32:04", "", "11");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://westchesterstairlift.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://westchesterstairlift.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Westchester Stairlift LLC", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Selling and servicing stairlifts in the Greater New York Area", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "westchesterstairlift@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("17283", "_transient_timeout_wpseo_link_table_inaccessible", "1587139288", "no");
INSERT INTO `wp_options` VALUES("17284", "_transient_wpseo_link_table_inaccessible", "0", "no");
INSERT INTO `wp_options` VALUES("17285", "_transient_timeout_wpseo_meta_table_inaccessible", "1587139288", "no");
INSERT INTO `wp_options` VALUES("17286", "_transient_wpseo_meta_table_inaccessible", "0", "no");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:10:{i:0;s:29:\"gravityforms/gravityforms.php\";i:1;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:46:\"gravity-forms-custom-post-types/gfcptaddon.php\";i:4;s:29:\"gravityformssurvey/survey.php\";i:5;s:33:\"tm-content-builder/tm-builder.php\";i:6;s:31:\"tracking-code-manager/index.php\";i:7;s:45:\"upload-max-file-size/upload_max_file_size.php\";i:8;s:41:\"wordpress-importer/wordpress-importer.php\";i:9;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:72:\"/home/westches/public_html/wp-content/themes/healthrehub-child/style.css\";i:2;s:104:\"/home/westches/public_html/wp-content/themes/healthrehub-child/template-parts/footer/layout-centered.php\";i:3;s:88:\"/home/westches/public_html/wp-content/themes/healthrehub-child/assets/js/theme-script.js\";i:4;s:80:\"/home/westches/public_html/wp-content/plugins/advanced-custom-fields-pro/acf.php\";i:5;s:82:\"/home/westches/public_html/wp-content/themes/healthrehub/assets/js/theme-script.js\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "healthrehub", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "healthrehub-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:5:{s:29:\"mp-timetable/mp-timetable.php\";a:2:{i:0;s:13:\"Mp_Time_Table\";i:1;s:12:\"on_uninstall\";}s:31:\"tm-photo-gallery/tm-gallery.php\";a:2:{i:0;s:16:\"TM_Photo_Gallery\";i:1;s:12:\"on_uninstall\";}s:53:\"child-theme-configurator/child-theme-configurator.php\";s:22:\"chld_thm_cfg_uninstall\";s:39:\"bj-lazy-load/inc/class-bjll-options.php\";s:14:\"__return_false\";s:31:\"tracking-code-manager/index.php\";s:14:\"tcmp_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "America/New_York", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "39", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "1961", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `wp_options` VALUES("93", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("94", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:24:\"edit_booked_appointments\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:20:\"booked_booking_agent\";a:2:{s:4:\"name\";s:13:\"Booking Agent\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:24:\"edit_booked_appointments\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:29:\"after-content-full-width-area\";a:0:{}s:11:\"footer-area\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("142", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("143", "current_theme", "HealthRehub Child", "yes");
INSERT INTO `wp_options` VALUES("144", "theme_mods_healthrehub", "a:202:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:3:\"top\";i:61;s:4:\"main\";i:53;s:6:\"footer\";i:52;s:6:\"social\";i:54;}s:12:\"show_tagline\";b:0;s:16:\"totop_visibility\";b:1;s:14:\"page_preloader\";b:1;s:16:\"header_logo_type\";s:5:\"image\";s:15:\"header_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:22:\"retina_header_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:23:\"header_logo_font_family\";s:19:\"Poppins, sans-serif\";s:22:\"header_logo_font_style\";s:6:\"normal\";s:23:\"header_logo_font_weight\";s:3:\"700\";s:21:\"header_logo_font_size\";s:2:\"50\";s:25:\"header_logo_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_visibillity\";b:1;s:29:\"breadcrumbs_front_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:0;s:21:\"breadcrumbs_path_type\";s:4:\"full\";s:19:\"header_social_links\";b:1;s:19:\"footer_social_links\";b:1;s:23:\"blog_post_share_buttons\";b:0;s:25:\"single_post_share_buttons\";b:1;s:21:\"header_container_type\";s:9:\"fullwidth\";s:22:\"content_container_type\";s:5:\"boxed\";s:21:\"footer_container_type\";s:9:\"fullwidth\";s:15:\"container_width\";i:1788;s:13:\"sidebar_width\";s:3:\"1/3\";s:22:\"regular_accent_color_1\";s:7:\"#4c5461\";s:22:\"regular_accent_color_2\";s:7:\"#4c5461\";s:22:\"regular_accent_color_3\";s:7:\"#9fbedd\";s:22:\"regular_accent_color_4\";s:7:\"#9fbedd\";s:22:\"regular_accent_color_5\";s:7:\"#4c5461\";s:22:\"regular_accent_color_6\";s:7:\"#232c3a\";s:19:\"regular_input_color\";s:7:\"#f5f5f5\";s:18:\"regular_text_color\";s:7:\"#959595\";s:17:\"footer_text_color\";s:7:\"#ffffff\";s:18:\"regular_link_color\";s:7:\"#4c5461\";s:24:\"regular_link_hover_color\";s:7:\"#9fbedd\";s:16:\"regular_h1_color\";s:7:\"#4c5461\";s:16:\"regular_h2_color\";s:7:\"#4c5461\";s:16:\"regular_h3_color\";s:7:\"#4c5461\";s:16:\"regular_h4_color\";s:7:\"#4c5461\";s:16:\"regular_h5_color\";s:7:\"#9fbedd\";s:16:\"regular_h6_color\";s:7:\"#4c5461\";s:21:\"invert_accent_color_1\";s:4:\"#fff\";s:21:\"invert_accent_color_2\";s:7:\"#fdfdfd\";s:21:\"invert_accent_color_3\";s:7:\"#fefefe\";s:17:\"invert_text_color\";s:4:\"#fff\";s:17:\"invert_link_color\";s:4:\"#fff\";s:23:\"invert_link_hover_color\";s:7:\"#4c5461\";s:15:\"invert_h1_color\";s:4:\"#fff\";s:15:\"invert_h2_color\";s:4:\"#fff\";s:15:\"invert_h3_color\";s:4:\"#fff\";s:15:\"invert_h4_color\";s:4:\"#fff\";s:15:\"invert_h5_color\";s:4:\"#fff\";s:15:\"invert_h6_color\";s:4:\"#fff\";s:16:\"gradient_color_1\";s:7:\"#4c5461\";s:16:\"gradient_color_2\";s:7:\"#9fbedd\";s:16:\"body_font_family\";s:19:\"Poppins, sans-serif\";s:15:\"body_font_style\";s:6:\"normal\";s:16:\"body_font_weight\";s:3:\"400\";s:14:\"body_font_size\";s:2:\"18\";s:16:\"body_line_height\";s:5:\"1.667\";s:19:\"body_letter_spacing\";s:1:\"0\";s:18:\"body_character_set\";s:5:\"latin\";s:15:\"body_text_align\";s:4:\"left\";s:14:\"h1_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h1_font_style\";s:6:\"normal\";s:14:\"h1_font_weight\";s:3:\"100\";s:12:\"h1_font_size\";s:2:\"44\";s:14:\"h1_line_height\";s:3:\"1.1\";s:17:\"h1_letter_spacing\";s:1:\"0\";s:16:\"h1_character_set\";s:5:\"latin\";s:13:\"h1_text_align\";s:7:\"inherit\";s:14:\"h2_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h2_font_style\";s:6:\"normal\";s:14:\"h2_font_weight\";s:3:\"100\";s:12:\"h2_font_size\";s:2:\"30\";s:14:\"h2_line_height\";s:3:\"1.1\";s:17:\"h2_letter_spacing\";s:1:\"0\";s:16:\"h2_character_set\";s:5:\"latin\";s:13:\"h2_text_align\";s:7:\"inherit\";s:14:\"h3_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h3_font_style\";s:6:\"normal\";s:14:\"h3_font_weight\";s:3:\"500\";s:12:\"h3_font_size\";s:2:\"30\";s:14:\"h3_line_height\";s:3:\"1.2\";s:17:\"h3_letter_spacing\";s:1:\"0\";s:16:\"h3_character_set\";s:5:\"latin\";s:13:\"h3_text_align\";s:7:\"inherit\";s:14:\"h4_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h4_font_style\";s:6:\"normal\";s:14:\"h4_font_weight\";s:3:\"500\";s:12:\"h4_font_size\";s:2:\"26\";s:14:\"h4_line_height\";s:3:\"1.3\";s:17:\"h4_letter_spacing\";s:1:\"0\";s:16:\"h4_character_set\";s:5:\"latin\";s:13:\"h4_text_align\";s:7:\"inherit\";s:14:\"h5_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h5_font_style\";s:6:\"normal\";s:14:\"h5_font_weight\";s:3:\"500\";s:12:\"h5_font_size\";s:2:\"20\";s:14:\"h5_line_height\";s:3:\"1.4\";s:17:\"h5_letter_spacing\";s:1:\"0\";s:16:\"h5_character_set\";s:5:\"latin\";s:13:\"h5_text_align\";s:7:\"inherit\";s:14:\"h6_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h6_font_style\";s:6:\"normal\";s:14:\"h6_font_weight\";s:3:\"300\";s:12:\"h6_font_size\";s:2:\"18\";s:14:\"h6_line_height\";s:3:\"1.4\";s:17:\"h6_letter_spacing\";s:1:\"0\";s:16:\"h6_character_set\";s:5:\"latin\";s:13:\"h6_text_align\";s:7:\"inherit\";s:21:\"main_menu_font_family\";s:19:\"Poppins, sans-serif\";s:20:\"main_menu_font_style\";s:6:\"normal\";s:21:\"main_menu_font_weight\";s:3:\"500\";s:19:\"main_menu_font_size\";s:2:\"16\";s:21:\"main_menu_line_height\";s:3:\"1.4\";s:24:\"main_menu_letter_spacing\";s:1:\"0\";s:23:\"main_menu_character_set\";s:5:\"latin\";s:18:\"button_font_family\";s:19:\"Poppins, sans-serif\";s:18:\"button_font_weight\";s:3:\"500\";s:20:\"button_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_font_family\";s:19:\"Poppins, sans-serif\";s:22:\"breadcrumbs_font_style\";s:6:\"normal\";s:23:\"breadcrumbs_font_weight\";s:3:\"600\";s:21:\"breadcrumbs_font_size\";s:2:\"14\";s:23:\"breadcrumbs_line_height\";s:3:\"1.5\";s:26:\"breadcrumbs_letter_spacing\";s:1:\"0\";s:25:\"breadcrumbs_character_set\";s:5:\"latin\";s:21:\"top_header_right_text\";s:87:\"<a href=\\\"tel:9147095438\\\" class=\\\"btn btn-secondary booking\\\"> 914 709 5438 (lift)</a>\";s:18:\"header_layout_type\";s:7:\"minimal\";s:29:\"header_invert_textcolorscheme\";b:0;s:15:\"header_bg_color\";s:7:\"#ffffff\";s:15:\"header_bg_image\";N;s:16:\"header_bg_repeat\";s:6:\"repeat\";s:20:\"header_bg_position_x\";s:6:\"center\";s:20:\"header_bg_attachment\";s:6:\"scroll\";s:14:\"top_panel_text\";s:281:\"<div class=\\\"info-block\\\"><a class=\\\"top-panel-a\\\" href=\\\"mailto:westchesterstairlift@gmail.com\\\"> westchesterstairlift@gmail.com</a></div><div class=\\\"info-block\\\"><i class=\\\"material-icons\\\">call</i> <a class=\\\"top-panel-a\\\" href=\\\"tel:9147095438\\\">914 709 5438 (lift)</a> </div>\";s:16:\"top_panel_search\";b:0;s:12:\"top_panel_bg\";s:7:\"#4c5461\";s:18:\"header_menu_sticky\";b:1;s:22:\"header_menu_attributes\";b:1;s:22:\"title_attributes_color\";s:7:\"#8f9399\";s:16:\"more_button_type\";s:4:\"text\";s:16:\"more_button_text\";s:4:\"more\";s:16:\"more_button_icon\";N;s:21:\"more_button_image_url\";s:0:\"\";s:28:\"retina_more_button_image_url\";N;s:16:\"sidebar_position\";s:17:\"one-right-sidebar\";s:17:\"mailchimp_api_key\";N;s:17:\"mailchimp_list_id\";N;s:10:\"ads_header\";s:0:\"\";s:20:\"ads_home_before_loop\";s:0:\"\";s:23:\"ads_post_before_content\";s:0:\"\";s:24:\"ads_post_before_comments\";s:0:\"\";s:15:\"footer_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:16:\"footer_copyright\";s:55:\"%%year%% © Westchester StairLift. All rights reserved.\";s:29:\"footer_widget_area_visibility\";b:0;s:21:\"footer_widget_columns\";s:1:\"4\";s:18:\"footer_layout_type\";s:8:\"centered\";s:17:\"footer_widgets_bg\";s:7:\"#4c5461\";s:9:\"footer_bg\";s:7:\"#4c5461\";s:16:\"blog_layout_type\";s:7:\"default\";s:16:\"blog_sticky_type\";s:4:\"icon\";s:16:\"blog_sticky_icon\";s:9:\"fa-star-o\";s:17:\"blog_sticky_label\";s:8:\"Featured\";s:18:\"blog_posts_content\";s:7:\"excerpt\";s:19:\"blog_featured_image\";s:9:\"fullwidth\";s:19:\"blog_read_more_text\";s:9:\"Read more\";s:16:\"blog_post_author\";b:1;s:22:\"blog_post_publish_date\";b:1;s:20:\"blog_post_categories\";b:1;s:14:\"blog_post_tags\";b:1;s:18:\"blog_post_comments\";b:1;s:18:\"single_post_author\";b:1;s:24:\"single_post_publish_date\";b:1;s:22:\"single_post_categories\";b:1;s:16:\"single_post_tags\";b:1;s:20:\"single_post_comments\";b:1;s:19:\"single_author_block\";b:1;s:21:\"related_posts_visible\";b:0;s:25:\"related_posts_block_title\";s:13:\"Related Posts\";s:19:\"related_posts_count\";s:1:\"4\";s:18:\"related_posts_grid\";s:1:\"4\";s:19:\"related_posts_title\";b:1;s:26:\"related_posts_title_length\";s:1:\"5\";s:19:\"related_posts_image\";b:1;s:21:\"related_posts_content\";s:12:\"post_excerpt\";s:28:\"related_posts_content_length\";s:2:\"10\";s:24:\"related_posts_categories\";b:1;s:18:\"related_posts_tags\";b:1;s:20:\"related_posts_author\";b:1;s:26:\"related_posts_publish_date\";b:1;s:27:\"related_posts_comment_count\";b:1;s:21:\"tm_pb_layouts_updated\";s:3:\"yes\";s:39:\"tm_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"tm_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"tm_pb_predefined_layouts_version_2\";s:2:\"on\";s:18:\"custom_css_post_id\";i:1958;s:21:\"tm_pb_replace_content\";s:2:\"on\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1540974090;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:29:\"after-content-full-width-area\";a:0:{}s:11:\"footer-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("145", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("146", "widget_healthrehub_widget_about", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("147", "widget_healthrehub_widget_about_author", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("148", "widget_healthrehub_widget_banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "cron", "a:9:{i:1564067592;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1564070488;a:2:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1564078392;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1564119472;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1564120437;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1564121605;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1564147767;a:1:{s:27:\"tcmp_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1564406967;a:1:{s:28:\"tcmp_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("112", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1540361636;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("371", "revslider_servers", "a:10:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:22:\"themepunch-ext-a.tools\";i:5;s:16:\"themepunch.tools\";i:6;s:22:\"themepunch-ext-a.tools\";i:7;s:22:\"themepunch-ext-a.tools\";i:8;s:22:\"themepunch-ext-a.tools\";i:9;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("379", "revslider-library-check", "1552591802", "yes");
INSERT INTO `wp_options` VALUES("380", "rs-library", "a:2:{s:7:\"objects\";a:169:{i:198;a:11:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:11:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:11:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:11:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:11:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:11:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:11:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:11:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:11:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:11:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:11:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:11:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:11:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:11:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:11:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:11:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:11:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:11:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:11:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:11:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:11:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:11:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:11:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:11:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:11:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:11:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:11:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:11:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:11:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:11:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:11:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:11:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:11:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole-punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:11:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:11:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:11:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:11:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:11:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:11:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:11:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:11:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:11:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:11:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:11:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:11:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:11:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:11:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:11:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:11:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:11:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:11:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:11:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:11:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:11:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:11:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:11:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:11:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:11:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:11:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:11:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:11:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:11:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:11:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:11:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:11:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:11:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:11:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:11:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:11:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:11:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:11:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:11:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:11:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:11:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:11:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:11:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:11:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:11:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:11:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:11:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:11:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:11:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:11:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:11:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:11:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:11:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:11:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:11:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:11:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:11:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:11:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:11:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:11:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:11:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:11:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:11:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:11:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:11:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:11:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:11:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:11:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:11:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:11:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:11:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:11:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:11:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:11:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:11:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:11:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:11:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:11:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:11:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:11:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:11:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:11:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:11:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:11:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:11:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:11:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:11:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:11:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:11:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:11:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:11:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:11:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:11:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:11:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:11:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:11:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:11:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:11:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:11:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:11:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:11:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:11:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:11:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:11:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:11:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:11:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:11:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:11:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:11:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:11:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:11:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:11:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:11:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:11:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:11:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:11:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:11:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:11:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:11:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:11:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:11:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:11:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:11:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:11:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:11:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:11:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:11:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:11:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:11:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:11:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:11:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:11:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:11:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:11:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:11:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:11:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:13:{i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}}", "no");
INSERT INTO `wp_options` VALUES("372", "revslider_server_refresh", "1553105937", "yes");
INSERT INTO `wp_options` VALUES("373", "revslider-update-check-short", "1553083020", "yes");
INSERT INTO `wp_options` VALUES("374", "revslider-templates-check", "1552973448", "yes");
INSERT INTO `wp_options` VALUES("212", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("483", "chld_thm_cfg_options_dict_query", "a:23:{i:1;s:25:\"@media (min-width: 768px)\";i:2;s:25:\"@media (min-width: 992px)\";i:3;s:26:\"@media (min-width: 1200px)\";i:4;s:25:\"@media (min-width: 544px)\";i:5;s:25:\"@media (max-width: 543px)\";i:6;s:25:\"@media (max-width: 767px)\";i:7;s:25:\"@media (max-width: 991px)\";i:8;s:26:\"@media (max-width: 1680px)\";i:9;s:48:\"@media (min-width: 768px) and (min-width: 992px)\";i:10;s:48:\"@media (min-width: 768px) and (max-width: 991px)\";i:11;s:26:\"@media (max-width: 1199px)\";i:12;s:26:\"@media (min-width: 1500px)\";i:13;s:25:\"@media (max-width: 768px)\";i:14;s:26:\"@media (max-width: 1350px)\";i:15;s:26:\"@media (min-width: 1450px)\";i:16;s:26:\"@media (max-width: 1200px)\";i:17;s:26:\"@media (max-width: 1550px)\";i:18;s:26:\"@media (max-width: 1400px)\";i:19;s:26:\"@media (max-width: 1150px)\";i:20;s:25:\"@media (max-width: 992px)\";i:21;s:4:\"base\";i:22;s:96:\"@media screen and (max-width: 800px) and (orientation: landscape),screen and (max-height: 300px)\";i:23;s:33:\"@media all and (max-width: 900px)\";}", "no");
INSERT INTO `wp_options` VALUES("484", "chld_thm_cfg_options_dict_rule", "a:162:{i:1;s:9:\"max-width\";i:2;s:10:\"margin-top\";i:3;s:12:\"margin-right\";i:4;s:13:\"margin-bottom\";i:5;s:11:\"margin-left\";i:6;s:11:\"padding-top\";i:7;s:13:\"padding-right\";i:8;s:14:\"padding-bottom\";i:9;s:12:\"padding-left\";i:10;s:10:\"min-height\";i:11;s:13:\"-webkit-order\";i:12;s:14:\"-ms-flex-order\";i:13;s:5:\"order\";i:14;s:12:\"-webkit-flex\";i:15;s:8:\"-ms-flex\";i:16;s:4:\"flex\";i:17;s:19:\"-ms-flex-item-align\";i:18;s:18:\"-webkit-align-self\";i:19;s:10:\"align-self\";i:20;s:10:\"text-align\";i:21;s:7:\"display\";i:22;s:22:\"-webkit-flex-direction\";i:23;s:18:\"-ms-flex-direction\";i:24;s:14:\"flex-direction\";i:25;s:17:\"-webkit-flex-wrap\";i:26;s:13:\"-ms-flex-wrap\";i:27;s:9:\"flex-wrap\";i:28;s:23:\"-webkit-justify-content\";i:29;s:13:\"-ms-flex-pack\";i:30;s:15:\"justify-content\";i:31;s:21:\"-webkit-align-content\";i:32;s:18:\"-ms-flex-line-pack\";i:33;s:13:\"align-content\";i:34;s:19:\"-webkit-align-items\";i:35;s:14:\"-ms-flex-align\";i:36;s:11:\"align-items\";i:37;s:9:\"font-size\";i:38;s:6:\"height\";i:39;s:5:\"right\";i:40;s:4:\"left\";i:41;s:8:\"position\";i:42;s:11:\"line-height\";i:43;s:6:\"bottom\";i:44;s:5:\"width\";i:45;s:3:\"top\";i:46;s:10:\"border-top\";i:47;s:6:\"border\";i:48;s:5:\"float\";i:49;s:7:\"z-index\";i:50;s:17:\"-webkit-flex-flow\";i:51;s:13:\"-ms-flex-flow\";i:52;s:9:\"flex-flow\";i:53;s:10:\"column-gap\";i:54;s:12:\"column-count\";i:55;s:15:\"-webkit-display\";i:56;s:9:\"min-width\";i:57;s:13:\"border-bottom\";i:58;s:7:\"content\";i:59;s:7:\"opacity\";i:60;s:16:\"background-color\";i:61;s:9:\"transform\";i:62;s:26:\"transition-timing-function\";i:63;s:19:\"transition-property\";i:64;s:19:\"transition-duration\";i:65;s:14:\"border-spacing\";i:66;s:11:\"text-indent\";i:67;s:21:\"-webkit-box-direction\";i:68;s:18:\"-webkit-box-orient\";i:69;s:16:\"background-image\";i:70;s:5:\"color\";i:71;s:11:\"font-family\";i:72;s:24:\"-webkit-text-size-adjust\";i:73;s:20:\"-ms-text-size-adjust\";i:74;s:14:\"vertical-align\";i:75;s:15:\"text-decoration\";i:76;s:7:\"outline\";i:77;s:11:\"font-weight\";i:78;s:10:\"font-style\";i:79;s:8:\"overflow\";i:80;s:10:\"box-sizing\";i:81;s:14:\"text-transform\";i:82;s:18:\"-webkit-appearance\";i:83;s:6:\"cursor\";i:84;s:15:\"border-collapse\";i:85;s:11:\"white-space\";i:86;s:9:\"word-wrap\";i:87;s:6:\"quotes\";i:88;s:14:\"text-rendering\";i:89;s:14:\"font-smoothing\";i:90;s:23:\"-moz-osx-font-smoothing\";i:91;s:10:\"list-style\";i:92;s:19:\"list-style-position\";i:93;s:16:\"transform-origin\";i:94;s:17:\"-webkit-animation\";i:95;s:9:\"animation\";i:96;s:23:\"-webkit-animation-delay\";i:97;s:15:\"animation-delay\";i:98;s:13:\"border-radius\";i:99;s:14:\"letter-spacing\";i:100;s:9:\"direction\";i:101;s:29:\"-webkit-font-feature-settings\";i:102;s:21:\"font-feature-settings\";i:103;s:13:\"text-overflow\";i:104;s:10:\"box-shadow\";i:105;s:10:\"transition\";i:106;s:6:\"resize\";i:107;s:5:\"clear\";i:108;s:12:\"border-right\";i:109;s:4:\"clip\";i:110;s:12:\"table-layout\";i:111;s:13:\"overflow-wrap\";i:112;s:14:\"-ms-word-break\";i:113;s:10:\"word-break\";i:114;s:7:\"hyphens\";i:115;s:16:\"border-top-color\";i:116;s:23:\"border-top-right-radius\";i:117;s:26:\"border-bottom-right-radius\";i:118;s:12:\"border-color\";i:119;s:10:\"visibility\";i:120;s:15:\"background-size\";i:121;s:19:\"background-position\";i:122;s:13:\"counter-reset\";i:123;s:17:\"counter-increment\";i:124;s:17:\"background-repeat\";i:125;s:15:\"list-style-type\";i:126;s:10:\"-ms-filter\";i:127;s:6:\"filter\";i:128;s:5:\"speak\";i:129;s:12:\"font-variant\";i:130;s:27:\"-webkit-backface-visibility\";i:131;s:19:\"-webkit-user-select\";i:132;s:16:\"-moz-user-select\";i:133;s:11:\"user-select\";i:134;s:27:\"-webkit-tap-highlight-color\";i:135;s:16:\"border-top-width\";i:136;s:19:\"border-bottom-width\";i:137;s:11:\"border-left\";i:138;s:15:\"-moz-box-orient\";i:139;s:17:\"-webkit-box-lines\";i:140;s:14:\"-moz-box-lines\";i:141;s:19:\"-webkit-flex-shrink\";i:142;s:11:\"flex-shrink\";i:143;s:17:\"-webkit-box-align\";i:144;s:14:\"pointer-events\";i:145;s:16:\"-ms-touch-action\";i:146;s:12:\"touch-action\";i:147;s:20:\"-moz-background-size\";i:148;s:23:\"-webkit-background-size\";i:149;s:15:\"-moz-appearance\";i:150;s:14:\"-ms-appearance\";i:151;s:10:\"appearance\";i:152;s:19:\"-webkit-perspective\";i:153;s:16:\"-moz-perspective\";i:154;s:14:\"-o-perspective\";i:155;s:11:\"perspective\";i:156;s:15:\"transform-style\";i:157;s:15:\"-ms-perspective\";i:158;s:24:\"-moz-backface-visibility\";i:159;s:23:\"-ms-backface-visibility\";i:160;s:19:\"backface-visibility\";i:161;s:14:\"-webkit-filter\";i:162;s:14:\"-moz-animation\";}", "no");
INSERT INTO `wp_options` VALUES("485", "chld_thm_cfg_options_dict_val", "a:1736:{i:1;s:5:\"537px\";i:2;s:1:\"0\";i:3;s:4:\"auto\";i:4;s:3:\"5px\";i:5;s:4:\"30px\";i:6;s:4:\"10px\";i:7;s:4:\"60px\";i:8;s:8:\"0 1 auto\";i:9;s:3:\"end\";i:10;s:8:\"flex-end\";i:11;s:6:\"center\";i:12;s:12:\"-webkit-flex\";i:13;s:11:\"-ms-flexbox\";i:14;s:4:\"flex\";i:15;s:3:\"row\";i:16;s:6:\"nowrap\";i:17;s:7:\"stretch\";i:18;s:10:\"flex-start\";i:19;s:5:\"start\";i:20;s:4:\"20px\";i:21;s:4:\"41px\";i:22;s:2:\"5%\";i:23;s:3:\"18%\";i:24;s:4:\"35px\";i:25;s:4:\"50px\";i:26;s:4:\"12px\";i:27;s:3:\"2px\";i:28;s:3:\"8px\";i:29;s:4:\"24px\";i:30;s:4:\"22px\";i:31;s:5:\"582px\";i:32;s:5:\"722px\";i:33;s:4:\"52px\";i:34;s:4:\"19px\";i:35;s:8:\"1.875rem\";i:36;s:5:\"460px\";i:37;s:4:\"40px\";i:38;s:4:\"29px\";i:39;s:4:\"26px\";i:40;s:4:\"28px\";i:41;s:4:\"55px\";i:42;s:4:\"25px\";i:43;s:4:\"58px\";i:44;s:4:\"18px\";i:45;s:5:\"right\";i:46;s:4:\"15px\";i:47;s:1:\"1\";i:48;s:5:\"119px\";i:49;s:4:\"100%\";i:50;s:8:\"relative\";i:51;s:5:\"block\";i:52;s:4:\"36px\";i:53;s:6:\"2.5rem\";i:54;s:4:\"64px\";i:55;s:3:\"50%\";i:56;s:12:\"inline-block\";i:57;s:4:\"90px\";i:58;s:4:\"48px\";i:59;s:5:\"14.4%\";i:60;s:5:\"20.4%\";i:61;s:5:\"710px\";i:62;s:3:\"2em\";i:63;s:3:\"3em\";i:64;s:3:\"1em\";i:65;s:7:\"3.222em\";i:66;s:1:\"2\";i:67;s:15:\"10px solid #fff\";i:68;s:9:\"0.9375rem\";i:69;s:5:\"-32px\";i:70;s:3:\"3px\";i:71;s:3:\"9px\";i:72;s:8:\"1.125rem\";i:73;s:5:\"240px\";i:74;s:4:\"0.85\";i:75;s:4:\"14px\";i:76;s:4:\"none\";i:77;s:4:\"39px\";i:78;s:4:\"13px\";i:79;s:4:\"left\";i:80;s:4:\"wrap\";i:81;s:13:\"space-between\";i:82;s:7:\"justify\";i:83;s:7:\"0 1 70%\";i:84;s:4:\"11px\";i:85;s:8:\"0 0 auto\";i:86;s:4:\"31px\";i:87;s:5:\"fixed\";i:88;s:4:\"1000\";i:89;s:9:\"-1.875rem\";i:90;s:8:\"row wrap\";i:91;s:26:\"1 0 calc(100%/3 - 3.75rem)\";i:92;s:22:\"calc(100%/3 - 3.75rem)\";i:93;s:28:\"1 0 calc(100%/1.5 - 3.75rem)\";i:94;s:24:\"calc(100%/1.5 - 3.75rem)\";i:95;s:7:\"3.75rem\";i:96;s:1:\"3\";i:97;s:5:\"1 0 0\";i:98;s:6:\"column\";i:99;s:20:\"calc(100% - 3.75rem)\";i:100;s:22:\"calc(100%/2 - 3.75rem)\";i:101;s:26:\"1 0 calc(100%/2 - 3.75rem)\";i:102;s:4:\"85px\";i:103;s:5:\"48.5%\";i:104;s:8:\"absolute\";i:105;s:6:\"1.25em\";i:106;s:4:\"14em\";i:107;s:4:\"32px\";i:108;s:5:\"-45px\";i:109;s:4:\"45px\";i:110;s:2:\"\"\"\";i:111;s:11:\"transparent\";i:112;s:13:\"translateY(0)\";i:113;s:4:\"ease\";i:114;s:5:\"-23px\";i:115;s:5:\"-30px\";i:116;s:5:\"-35px\";i:117;s:3:\"999\";i:118;s:3:\"70%\";i:119;s:6:\"-999em\";i:120;s:4:\"38px\";i:121;s:16:\"translateY(-7px)\";i:122;s:31:\"top, opacity, -webkit-transform\";i:123;s:23:\"top, opacity, transform\";i:124;s:42:\"top, opacity, transform, -webkit-transform\";i:125;s:5:\"250ms\";i:126;s:4:\"80px\";i:127;s:4:\"74px\";i:128;s:8:\"1.625rem\";i:129;s:3:\"6px\";i:130;s:4:\"72px\";i:131;s:2:\"-1\";i:132;s:12:\"0 0 8.33333%\";i:133;s:8:\"8.33333%\";i:134;s:13:\"0 0 16.66667%\";i:135;s:9:\"16.66667%\";i:136;s:7:\"0 0 25%\";i:137;s:3:\"25%\";i:138;s:13:\"0 0 33.33333%\";i:139;s:9:\"33.33333%\";i:140;s:13:\"0 0 41.66667%\";i:141;s:9:\"41.66667%\";i:142;s:7:\"0 0 50%\";i:143;s:13:\"0 0 58.33333%\";i:144;s:9:\"58.33333%\";i:145;s:13:\"0 0 66.66667%\";i:146;s:9:\"66.66667%\";i:147;s:7:\"0 0 75%\";i:148;s:3:\"75%\";i:149;s:13:\"0 0 83.33333%\";i:150;s:9:\"83.33333%\";i:151;s:13:\"0 0 91.66667%\";i:152;s:9:\"91.66667%\";i:153;s:8:\"0 0 100%\";i:154;s:2:\"0%\";i:155;s:10:\"-0.9375rem\";i:156;s:5:\"720px\";i:157;s:7:\"3.25rem\";i:158;s:21:\"translate(-50%, -80%)\";i:159;s:6:\"10px 0\";i:160;s:4:\"-1px\";i:161;s:4:\"16px\";i:162;s:2:\"1%\";i:163;s:4:\"70px\";i:164;s:4:\"65px\";i:165;s:5:\"-14px\";i:166;s:3:\"65%\";i:167;s:4:\"3rem\";i:168;s:3:\"7px\";i:169;s:4:\"49px\";i:170;s:4:\"34px\";i:171;s:4:\"89px\";i:172;s:6:\"1.5rem\";i:173;s:4:\"1rem\";i:174;s:5:\"-10px\";i:175;s:6:\"17.6px\";i:176;s:6:\"1.1rem\";i:177;s:5:\"140px\";i:178;s:5:\"485px\";i:179;s:4:\"44px\";i:180;s:7:\"2.75rem\";i:181;s:7:\"2.25rem\";i:182;s:5:\"740px\";i:183;s:4:\"86px\";i:184;s:4:\"88px\";i:185;s:5:\"166px\";i:186;s:5:\"780px\";i:187;s:4:\"62px\";i:188;s:8:\"3.875rem\";i:189;s:5:\"1.9em\";i:190;s:3:\"1.4\";i:191;s:4:\"42px\";i:192;s:4:\"23px\";i:193;s:4:\"53px\";i:194;s:5:\".25em\";i:195;s:7:\"1.25rem\";i:196;s:8:\"-1.25rem\";i:197;s:5:\"940px\";i:198;s:4:\"84px\";i:199;s:21:\"translate(-50%, -85%)\";i:200;s:4:\"-5px\";i:201;s:5:\"147px\";i:202;s:4:\"76px\";i:203;s:4:\"5rem\";i:204;s:5:\"123px\";i:205;s:4:\"46px\";i:206;s:5:\"-31px\";i:207;s:5:\"523px\";i:208;s:8:\"0.875rem\";i:209;s:5:\"-60px\";i:210;s:5:\"113px\";i:211;s:5:\"191px\";i:212;s:10:\"table-cell\";i:213;s:4:\"75px\";i:214;s:3:\"76%\";i:215;s:3:\"1px\";i:216;s:5:\"3.6em\";i:217;s:5:\"1.5em\";i:218;s:5:\"-68px\";i:219;s:5:\"4.3em\";i:220;s:5:\"2.9em\";i:221;s:6:\"1140px\";i:222;s:5:\"576px\";i:223;s:8:\"1 1 100%\";i:224;s:6:\"normal\";i:225;s:8:\"vertical\";i:226;s:4:\"2rem\";i:227;s:4:\"4rem\";i:228;s:3:\"60%\";i:229;s:8:\"0 1 100%\";i:230;s:7:\"inherit\";i:231;s:5:\"149px\";i:232;s:5:\"275px\";i:233;s:6:\"static\";i:234;s:3:\"46%\";i:235;s:6:\"12.8px\";i:236;s:6:\"0.8rem\";i:237;s:10:\"sans-serif\";i:238;s:8:\"baseline\";i:239;s:10:\"1px dotted\";i:240;s:4:\"bold\";i:241;s:6:\"italic\";i:242;s:6:\"0.67em\";i:243;s:4:\"#ff0\";i:244;s:4:\"#000\";i:245;s:3:\"80%\";i:246;s:6:\"-0.5em\";i:247;s:7:\"-0.25em\";i:248;s:6:\"hidden\";i:249;s:11:\"content-box\";i:250;s:20:\"monospace, monospace\";i:251;s:7:\"visible\";i:252;s:6:\"button\";i:253;s:7:\"pointer\";i:254;s:7:\"default\";i:255;s:10:\"border-box\";i:256;s:9:\"textfield\";i:257;s:17:\"1px solid #c0c0c0\";i:258;s:6:\"0.35em\";i:259;s:7:\"0.625em\";i:260;s:6:\"0.75em\";i:261;s:8:\"collapse\";i:262;s:3:\"600\";i:263;s:4:\"33px\";i:264;s:9:\"uppercase\";i:265;s:6:\"1.67em\";i:266;s:38:\"\"Courier 10 Pitch\", Courier, monospace\";i:267;s:3:\"1.6\";i:268;s:4:\"#eee\";i:269;s:17:\"1px solid #d4d4d4\";i:270;s:3:\"pre\";i:271;s:8:\"pre-wrap\";i:272;s:10:\"break-word\";i:273;s:62:\"Monaco, Consolas, \"Andale Mono\", \"DejaVu Sans Mono\", monospace\";i:274;s:4:\"help\";i:275;s:15:\"1px dotted #666\";i:276;s:9:\"1px solid\";i:277;s:4:\"125%\";i:278;s:2:\"\'\'\";i:279;s:4:\"37px\";i:280;s:16:\"translateY(-5px)\";i:281;s:25:\"normal 14px/1 FontAwesome\";i:282;s:11:\"antialiased\";i:283;s:9:\"grayscale\";i:284;s:7:\"\"\\f10d\"\";i:285;s:8:\"1.375rem\";i:286;s:7:\"2.778em\";i:287;s:5:\"2.4em\";i:288;s:20:\"decimal-leading-zero\";i:289;s:6:\"inside\";i:290;s:3:\"top\";i:291;s:17:\"1px solid #4c5461\";i:292;s:6:\"bottom\";i:293;s:14:\"rotateZ(45deg)\";i:294;s:13:\"rotate(45deg)\";i:295;s:4:\"#fff\";i:296;s:10:\"scale(1.1)\";i:297;s:9:\"100% 100%\";i:298;s:41:\"tmFoldCubeAngle 2.4s infinite linear both\";i:299;s:7:\"#9fbedd\";i:300;s:25:\"scale(1.1) rotateZ(90deg)\";i:301;s:24:\"scale(1.1) rotate(90deg)\";i:302;s:4:\"0.3s\";i:303;s:26:\"scale(1.1) rotateZ(180deg)\";i:304;s:25:\"scale(1.1) rotate(180deg)\";i:305;s:4:\"0.6s\";i:306;s:26:\"scale(1.1) rotateZ(270deg)\";i:307;s:25:\"scale(1.1) rotate(270deg)\";i:308;s:4:\"0.9s\";i:309;s:16:\"\'Material Icons\'\";i:310;s:3:\"ltr\";i:311;s:18:\"optimizeLegibility\";i:312;s:6:\"\'liga\'\";i:313;s:13:\"\"expand_less\"\";i:314;s:8:\"ellipsis\";i:315;s:8:\"0 0 10px\";i:316;s:14:\"all 0.32s ease\";i:317;s:14:\"all 0.27s ease\";i:318;s:5:\"150px\";i:319;s:4:\"both\";i:320;s:17:\"calc(100% - 50px)\";i:321;s:5:\"-25px\";i:322;s:13:\"all 0.4s ease\";i:323;s:6:\"19.2px\";i:324;s:6:\"1.2rem\";i:325;s:13:\"all 0.3s ease\";i:326;s:7:\"0.75rem\";i:327;s:14:\"all 0.35s ease\";i:328;s:11:\"thin dotted\";i:329;s:9:\"underline\";i:330;s:21:\"1px solid transparent\";i:331;s:5:\"1.6em\";i:332;s:17:\"translateY(0.4em)\";i:333;s:5:\"-100%\";i:334;s:2:\"99\";i:335;s:5:\"-11px\";i:336;s:15:\"translate(-50%)\";i:337;s:7:\"\'\\f107\'\";i:338;s:13:\"\'FontAwesome\'\";i:339;s:12:\".3s all ease\";i:340;s:31:\"translate(-50%) rotateX(180deg)\";i:341;s:3:\"1.7\";i:342;s:4:\".5em\";i:343;s:17:\"all 0.3s ease-out\";i:344;s:7:\"\'\\e5cd\'\";i:345;s:7:\"\'\\e3c7\'\";i:346;s:3:\"400\";i:347;s:7:\"#a6a6a6\";i:348;s:3:\"4px\";i:349;s:7:\"1.385em\";i:350;s:4:\"27px\";i:351;s:5:\"-22px\";i:352;s:7:\"\'\\E408\'\";i:353;s:7:\"\'\\E409\'\";i:354;s:6:\"middle\";i:355;s:6:\"2.25em\";i:356;s:5:\"2.2em\";i:357;s:17:\"1px solid #e0e0e8\";i:358;s:7:\"\'\\f1cb\'\";i:359;s:7:\"\'\\f1a6\'\";i:360;s:7:\"\'\\f16b\'\";i:361;s:7:\"\'\\f16e\'\";i:362;s:7:\"\'\\f09b\'\";i:363;s:7:\"\'\\f0d2\'\";i:364;s:7:\"\'\\f265\'\";i:365;s:7:\"\'\\f1a1\'\";i:366;s:7:\"\'\\f17e\'\";i:367;s:7:\"\'\\f1a4\'\";i:368;s:7:\"\'\\f27d\'\";i:369;s:7:\"\'\\f19a\'\";i:370;s:7:\"\'\\f167\'\";i:371;s:7:\"\'\\f270\'\";i:372;s:7:\"\'\\f262\'\";i:373;s:7:\"\'\\f23b\'\";i:374;s:7:\"\'\\f168\'\";i:375;s:7:\"\'\\f19e\'\";i:376;s:7:\"\'\\f1ca\'\";i:377;s:7:\"\'\\f18a\'\";i:378;s:7:\"\'\\f181\'\";i:379;s:7:\"\'\\f1b6\'\";i:380;s:7:\"\'\\f1be\'\";i:381;s:7:\"\'\\f1bc\'\";i:382;s:7:\"\'\\f18d\'\";i:383;s:7:\"\'\\f16c\'\";i:384;s:7:\"\'\\f1e7\'\";i:385;s:7:\"\'\\f198\'\";i:386;s:7:\"\'\\f216\'\";i:387;s:7:\"\'\\f202\'\";i:388;s:7:\"\'\\f1cc\'\";i:389;s:7:\"\'\\f171\'\";i:390;s:7:\"\'\\f284\'\";i:391;s:7:\"\'\\f20e\'\";i:392;s:7:\"\'\\f210\'\";i:393;s:7:\"\'\\f26d\'\";i:394;s:7:\"\'\\f1a5\'\";i:395;s:7:\"\'\\f1bd\'\";i:396;s:7:\"\'\\f189\'\";i:397;s:7:\"\'\\e010\'\";i:398;s:7:\"\'\\e012\'\";i:399;s:7:\"\'\\e017\'\";i:400;s:7:\"\'\\e01e\'\";i:401;s:7:\"\'\\e024\'\";i:402;s:7:\"\'\\e03b\'\";i:403;s:7:\"\'\\e03a\'\";i:404;s:7:\"\'\\e001\'\";i:405;s:23:\"normal 14px/1 fl-glypho\";i:406;s:24:\"rect(1px, 1px, 1px, 1px)\";i:407;s:7:\"#f1f1f1\";i:408;s:30:\"0 0 2px 2px rgba(0, 0, 0, 0.6)\";i:409;s:7:\"#21759b\";i:410;s:6:\"100000\";i:411;s:4:\"51px\";i:412;s:5:\"table\";i:413;s:5:\"1.4em\";i:414;s:1:\"9\";i:415;s:14:\"all 0.25s ease\";i:416;s:9:\"break-all\";i:417;s:36:\"0 5px 32px rgba(103, 122, 141, 0.17)\";i:418;s:9:\"2px solid\";i:419;s:3:\"1.5\";i:420;s:14:\"2px solid #eee\";i:421;s:5:\"1.2em\";i:422;s:1:\"5\";i:423;s:9:\"lowercase\";i:424;s:5:\"0.7em\";i:425;s:4:\"21px\";i:426;s:16:\"calc(2em - 20px)\";i:427;s:5:\"400px\";i:428;s:7:\"1.300em\";i:429;s:5:\"-15px\";i:430;s:18:\"rgba(0, 0, 0, 0.5)\";i:431;s:13:\"\'insert_link\'\";i:432;s:5:\"-20px\";i:433;s:3:\"1.2\";i:434;s:5:\"1.1em\";i:435;s:7:\"0.667em\";i:436;s:17:\"1px solid #e7e7e7\";i:437;s:4:\".7em\";i:438;s:4:\".6em\";i:439;s:13:\"all 0.5s ease\";i:440;s:4:\"-3px\";i:441;s:4:\"-4px\";i:442;s:5:\"-16px\";i:443;s:4:\".4em\";i:444;s:9:\"0.8125rem\";i:445;s:5:\"3.5em\";i:446;s:24:\"rgba(255, 255, 255, 0.2)\";i:447;s:3:\".75\";i:448;s:17:\"all .25s ease-out\";i:449;s:7:\"\'\\E8F4\'\";i:450;s:21:\"translate(-50%, -50%)\";i:451;s:8:\"2.125rem\";i:452;s:24:\"inset 0 -5px 0 0 #fe5c7a\";i:453;s:7:\"#fe5c7a\";i:454;s:17:\"translateY(0.2em)\";i:455;s:23:\"rgba(254, 92, 122, 0.1)\";i:456;s:7:\"#00da4c\";i:457;s:2:\"4%\";i:458;s:8:\"0.8075em\";i:459;s:6:\"33.33%\";i:460;s:3:\"20%\";i:461;s:6:\"16.66%\";i:462;s:6:\"14.28%\";i:463;s:5:\"12.5%\";i:464;s:6:\"11.11%\";i:465;s:6:\"62.33%\";i:466;s:4:\"-2px\";i:467;s:7:\"1.75rem\";i:468;s:6:\"1440px\";i:469;s:6:\"28.8px\";i:470;s:6:\"1.8rem\";i:471;s:7:\"\'\\E314\'\";i:472;s:7:\"\'\\E315\'\";i:473;s:39:\"0 0 70px 200px rgba(255, 255, 255, 0.4)\";i:474;s:10:\"scale(0.8)\";i:475;s:8:\"scale(1)\";i:476;s:5:\"cover\";i:477;s:11:\"scale(1.05)\";i:478;s:14:\"all 0.37s ease\";i:479;s:2:\".7\";i:480;s:3:\"100\";i:481;s:4:\"list\";i:482;s:17:\"all 0.4s ease-out\";i:483;s:21:\"\"0\" counter(list) \"/\"\";i:484;s:5:\"1.7em\";i:485;s:5:\"1.3em\";i:486;s:3:\"52%\";i:487;s:3:\"48%\";i:488;s:4:\"17px\";i:489;s:9:\"1.0625rem\";i:490;s:5:\"387px\";i:491;s:12:\"\"play_arrow\"\";i:492;s:4:\"92px\";i:493;s:7:\"1.337em\";i:494;s:5:\"182px\";i:495;s:37:\"url(./assets/images/select_arrow.png)\";i:496;s:9:\"no-repeat\";i:497;s:7:\"97% 50%\";i:498;s:6:\"inline\";i:499;s:10:\".3s linear\";i:500;s:7:\"\"\\E5CC\"\";i:501;s:15:\".3s ease-in-out\";i:502;s:13:\"rotate(90deg)\";i:503;s:7:\"\"\\E148\"\";i:504;s:7:\"\"\\E15D\"\";i:505;s:9:\"rotate(0)\";i:506;s:4:\"0.65\";i:507;s:5:\"135px\";i:508;s:6:\"10.4px\";i:509;s:7:\"0.65rem\";i:510;s:3:\"500\";i:511;s:16:\"counter(list) \"\"\";i:512;s:8:\"3.125rem\";i:513;s:5:\"100px\";i:514;s:7:\"lighter\";i:515;s:5:\"300px\";i:516;s:10:\"capitalize\";i:517;s:5:\"250px\";i:518;s:7:\"decimal\";i:519;s:6:\"1.35em\";i:520;s:6:\"0.85em\";i:521;s:2:\".5\";i:522;s:2:\"2%\";i:523;s:14:\"all 0.28s ease\";i:524;s:2:\"10\";i:525;s:10:\"10px solid\";i:526;s:43:\"url(./assets/images/select_arrow_white.png)\";i:527;s:8:\"separate\";i:528;s:3:\"13%\";i:529;s:6:\"1.55em\";i:530;s:6:\"0.25em\";i:531;s:6:\"1.37em\";i:532;s:7:\"\'\\e192\'\";i:533;s:13:\"all 0.2s ease\";i:534;s:6:\"1.15em\";i:535;s:7:\"\'\\f100\'\";i:536;s:10:\"\"Flaticon\"\";i:537;s:7:\"1.625em\";i:538;s:17:\"2px solid #4c5461\";i:539;s:4:\"56px\";i:540;s:7:\"\'\\e616\'\";i:541;s:4:\"54px\";i:542;s:7:\"\"\\e557\"\";i:543;s:4:\"68px\";i:544;s:20:\"\'vertical_align_top\'\";i:545;s:8:\"\'cancel\'\";i:546;s:20:\"\'play_circle_filled\'\";i:547;s:25:\"\'photo_size_select_small\'\";i:548;s:23:\"\'vertical_align_bottom\'\";i:549;s:21:\"\'pause_circle_filled\'\";i:550;s:25:\"\'photo_size_select_large\'\";i:551;s:5:\"-40px\";i:552;s:30:\"0 0 11px 0 rgba(0, 0, 0, 0.15)\";i:553;s:15:\"1px solid black\";i:554;s:12:\"1.33333333em\";i:555;s:5:\".75em\";i:556;s:4:\"-15%\";i:557;s:3:\"4em\";i:558;s:3:\"5em\";i:559;s:12:\"1.28571429em\";i:560;s:12:\"2.14285714em\";i:561;s:13:\"-2.14285714em\";i:562;s:11:\".14285714em\";i:563;s:13:\"-1.85714286em\";i:564;s:4:\".2em\";i:565;s:5:\".15em\";i:566;s:16:\"solid .08em #eee\";i:567;s:4:\".1em\";i:568;s:4:\".3em\";i:569;s:26:\"fa-spin 2s infinite linear\";i:570;s:28:\"fa-spin 1s infinite steps(8)\";i:571;s:58:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\"\";i:572;s:58:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)\"\";i:573;s:14:\"rotate(180deg)\";i:574;s:58:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\"\";i:575;s:14:\"rotate(270deg)\";i:576;s:68:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)\"\";i:577;s:12:\"scale(-1, 1)\";i:578;s:68:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\"\";i:579;s:12:\"scale(1, -1)\";i:580;s:7:\"\"\\f000\"\";i:581;s:7:\"\"\\f001\"\";i:582;s:7:\"\"\\f002\"\";i:583;s:7:\"\"\\f003\"\";i:584;s:7:\"\"\\f004\"\";i:585;s:7:\"\"\\f005\"\";i:586;s:7:\"\"\\f006\"\";i:587;s:7:\"\"\\f007\"\";i:588;s:7:\"\"\\f008\"\";i:589;s:7:\"\"\\f009\"\";i:590;s:7:\"\"\\f00a\"\";i:591;s:7:\"\"\\f00b\"\";i:592;s:7:\"\"\\f00c\"\";i:593;s:7:\"\"\\f00d\"\";i:594;s:7:\"\"\\f00e\"\";i:595;s:7:\"\"\\f010\"\";i:596;s:7:\"\"\\f011\"\";i:597;s:7:\"\"\\f012\"\";i:598;s:7:\"\"\\f013\"\";i:599;s:7:\"\"\\f014\"\";i:600;s:7:\"\"\\f015\"\";i:601;s:7:\"\"\\f016\"\";i:602;s:7:\"\"\\f017\"\";i:603;s:7:\"\"\\f018\"\";i:604;s:7:\"\"\\f019\"\";i:605;s:7:\"\"\\f01a\"\";i:606;s:7:\"\"\\f01b\"\";i:607;s:7:\"\"\\f01c\"\";i:608;s:7:\"\"\\f01d\"\";i:609;s:7:\"\"\\f01e\"\";i:610;s:7:\"\"\\f021\"\";i:611;s:7:\"\"\\f022\"\";i:612;s:7:\"\"\\f023\"\";i:613;s:7:\"\"\\f024\"\";i:614;s:7:\"\"\\f025\"\";i:615;s:7:\"\"\\f026\"\";i:616;s:7:\"\"\\f027\"\";i:617;s:7:\"\"\\f028\"\";i:618;s:7:\"\"\\f029\"\";i:619;s:7:\"\"\\f02a\"\";i:620;s:7:\"\"\\f02b\"\";i:621;s:7:\"\"\\f02c\"\";i:622;s:7:\"\"\\f02d\"\";i:623;s:7:\"\"\\f02e\"\";i:624;s:7:\"\"\\f02f\"\";i:625;s:7:\"\"\\f030\"\";i:626;s:7:\"\"\\f031\"\";i:627;s:7:\"\"\\f032\"\";i:628;s:7:\"\"\\f033\"\";i:629;s:7:\"\"\\f034\"\";i:630;s:7:\"\"\\f035\"\";i:631;s:7:\"\"\\f036\"\";i:632;s:7:\"\"\\f037\"\";i:633;s:7:\"\"\\f038\"\";i:634;s:7:\"\"\\f039\"\";i:635;s:7:\"\"\\f03a\"\";i:636;s:7:\"\"\\f03b\"\";i:637;s:7:\"\"\\f03c\"\";i:638;s:7:\"\"\\f03d\"\";i:639;s:7:\"\"\\f03e\"\";i:640;s:7:\"\"\\f040\"\";i:641;s:7:\"\"\\f041\"\";i:642;s:7:\"\"\\f042\"\";i:643;s:7:\"\"\\f043\"\";i:644;s:7:\"\"\\f044\"\";i:645;s:7:\"\"\\f045\"\";i:646;s:7:\"\"\\f046\"\";i:647;s:7:\"\"\\f047\"\";i:648;s:7:\"\"\\f048\"\";i:649;s:7:\"\"\\f049\"\";i:650;s:7:\"\"\\f04a\"\";i:651;s:7:\"\"\\f04b\"\";i:652;s:7:\"\"\\f04c\"\";i:653;s:7:\"\"\\f04d\"\";i:654;s:7:\"\"\\f04e\"\";i:655;s:7:\"\"\\f050\"\";i:656;s:7:\"\"\\f051\"\";i:657;s:7:\"\"\\f052\"\";i:658;s:7:\"\"\\f053\"\";i:659;s:7:\"\"\\f054\"\";i:660;s:7:\"\"\\f055\"\";i:661;s:7:\"\"\\f056\"\";i:662;s:7:\"\"\\f057\"\";i:663;s:7:\"\"\\f058\"\";i:664;s:7:\"\"\\f059\"\";i:665;s:7:\"\"\\f05a\"\";i:666;s:7:\"\"\\f05b\"\";i:667;s:7:\"\"\\f05c\"\";i:668;s:7:\"\"\\f05d\"\";i:669;s:7:\"\"\\f05e\"\";i:670;s:7:\"\"\\f060\"\";i:671;s:7:\"\"\\f061\"\";i:672;s:7:\"\"\\f062\"\";i:673;s:7:\"\"\\f063\"\";i:674;s:7:\"\"\\f064\"\";i:675;s:7:\"\"\\f065\"\";i:676;s:7:\"\"\\f066\"\";i:677;s:7:\"\"\\f067\"\";i:678;s:7:\"\"\\f068\"\";i:679;s:7:\"\"\\f069\"\";i:680;s:7:\"\"\\f06a\"\";i:681;s:7:\"\"\\f06b\"\";i:682;s:7:\"\"\\f06c\"\";i:683;s:7:\"\"\\f06d\"\";i:684;s:7:\"\"\\f06e\"\";i:685;s:7:\"\"\\f070\"\";i:686;s:7:\"\"\\f071\"\";i:687;s:7:\"\"\\f072\"\";i:688;s:7:\"\"\\f073\"\";i:689;s:7:\"\"\\f074\"\";i:690;s:7:\"\"\\f075\"\";i:691;s:7:\"\"\\f076\"\";i:692;s:7:\"\"\\f077\"\";i:693;s:7:\"\"\\f078\"\";i:694;s:7:\"\"\\f079\"\";i:695;s:7:\"\"\\f07a\"\";i:696;s:7:\"\"\\f07b\"\";i:697;s:7:\"\"\\f07c\"\";i:698;s:7:\"\"\\f07d\"\";i:699;s:7:\"\"\\f07e\"\";i:700;s:7:\"\"\\f080\"\";i:701;s:7:\"\"\\f081\"\";i:702;s:7:\"\"\\f082\"\";i:703;s:7:\"\"\\f083\"\";i:704;s:7:\"\"\\f084\"\";i:705;s:7:\"\"\\f085\"\";i:706;s:7:\"\"\\f086\"\";i:707;s:7:\"\"\\f087\"\";i:708;s:7:\"\"\\f088\"\";i:709;s:7:\"\"\\f089\"\";i:710;s:7:\"\"\\f08a\"\";i:711;s:7:\"\"\\f08b\"\";i:712;s:7:\"\"\\f08c\"\";i:713;s:7:\"\"\\f08d\"\";i:714;s:7:\"\"\\f08e\"\";i:715;s:7:\"\"\\f090\"\";i:716;s:7:\"\"\\f091\"\";i:717;s:7:\"\"\\f092\"\";i:718;s:7:\"\"\\f093\"\";i:719;s:7:\"\"\\f094\"\";i:720;s:7:\"\"\\f095\"\";i:721;s:7:\"\"\\f096\"\";i:722;s:7:\"\"\\f097\"\";i:723;s:7:\"\"\\f098\"\";i:724;s:7:\"\"\\f099\"\";i:725;s:7:\"\"\\f09a\"\";i:726;s:7:\"\"\\f09b\"\";i:727;s:7:\"\"\\f09c\"\";i:728;s:7:\"\"\\f09d\"\";i:729;s:7:\"\"\\f09e\"\";i:730;s:7:\"\"\\f0a0\"\";i:731;s:7:\"\"\\f0a1\"\";i:732;s:7:\"\"\\f0f3\"\";i:733;s:7:\"\"\\f0a3\"\";i:734;s:7:\"\"\\f0a4\"\";i:735;s:7:\"\"\\f0a5\"\";i:736;s:7:\"\"\\f0a6\"\";i:737;s:7:\"\"\\f0a7\"\";i:738;s:7:\"\"\\f0a8\"\";i:739;s:7:\"\"\\f0a9\"\";i:740;s:7:\"\"\\f0aa\"\";i:741;s:7:\"\"\\f0ab\"\";i:742;s:7:\"\"\\f0ac\"\";i:743;s:7:\"\"\\f0ad\"\";i:744;s:7:\"\"\\f0ae\"\";i:745;s:7:\"\"\\f0b0\"\";i:746;s:7:\"\"\\f0b1\"\";i:747;s:7:\"\"\\f0b2\"\";i:748;s:7:\"\"\\f0c0\"\";i:749;s:7:\"\"\\f0c1\"\";i:750;s:7:\"\"\\f0c2\"\";i:751;s:7:\"\"\\f0c3\"\";i:752;s:7:\"\"\\f0c4\"\";i:753;s:7:\"\"\\f0c5\"\";i:754;s:7:\"\"\\f0c6\"\";i:755;s:7:\"\"\\f0c7\"\";i:756;s:7:\"\"\\f0c8\"\";i:757;s:7:\"\"\\f0c9\"\";i:758;s:7:\"\"\\f0ca\"\";i:759;s:7:\"\"\\f0cb\"\";i:760;s:7:\"\"\\f0cc\"\";i:761;s:7:\"\"\\f0cd\"\";i:762;s:7:\"\"\\f0ce\"\";i:763;s:7:\"\"\\f0d0\"\";i:764;s:7:\"\"\\f0d1\"\";i:765;s:7:\"\"\\f0d2\"\";i:766;s:7:\"\"\\f0d3\"\";i:767;s:7:\"\"\\f0d4\"\";i:768;s:7:\"\"\\f0d5\"\";i:769;s:7:\"\"\\f0d6\"\";i:770;s:7:\"\"\\f0d7\"\";i:771;s:7:\"\"\\f0d8\"\";i:772;s:7:\"\"\\f0d9\"\";i:773;s:7:\"\"\\f0da\"\";i:774;s:7:\"\"\\f0db\"\";i:775;s:7:\"\"\\f0dc\"\";i:776;s:7:\"\"\\f0dd\"\";i:777;s:7:\"\"\\f0de\"\";i:778;s:7:\"\"\\f0e0\"\";i:779;s:7:\"\"\\f0e1\"\";i:780;s:7:\"\"\\f0e2\"\";i:781;s:7:\"\"\\f0e3\"\";i:782;s:7:\"\"\\f0e4\"\";i:783;s:7:\"\"\\f0e5\"\";i:784;s:7:\"\"\\f0e6\"\";i:785;s:7:\"\"\\f0e7\"\";i:786;s:7:\"\"\\f0e8\"\";i:787;s:7:\"\"\\f0e9\"\";i:788;s:7:\"\"\\f0ea\"\";i:789;s:7:\"\"\\f0eb\"\";i:790;s:7:\"\"\\f0ec\"\";i:791;s:7:\"\"\\f0ed\"\";i:792;s:7:\"\"\\f0ee\"\";i:793;s:7:\"\"\\f0f0\"\";i:794;s:7:\"\"\\f0f1\"\";i:795;s:7:\"\"\\f0f2\"\";i:796;s:7:\"\"\\f0a2\"\";i:797;s:7:\"\"\\f0f4\"\";i:798;s:7:\"\"\\f0f5\"\";i:799;s:7:\"\"\\f0f6\"\";i:800;s:7:\"\"\\f0f7\"\";i:801;s:7:\"\"\\f0f8\"\";i:802;s:7:\"\"\\f0f9\"\";i:803;s:7:\"\"\\f0fa\"\";i:804;s:7:\"\"\\f0fb\"\";i:805;s:7:\"\"\\f0fc\"\";i:806;s:7:\"\"\\f0fd\"\";i:807;s:7:\"\"\\f0fe\"\";i:808;s:7:\"\"\\f100\"\";i:809;s:7:\"\"\\f101\"\";i:810;s:7:\"\"\\f102\"\";i:811;s:7:\"\"\\f103\"\";i:812;s:7:\"\"\\f104\"\";i:813;s:7:\"\"\\f105\"\";i:814;s:7:\"\"\\f106\"\";i:815;s:7:\"\"\\f107\"\";i:816;s:7:\"\"\\f108\"\";i:817;s:7:\"\"\\f109\"\";i:818;s:7:\"\"\\f10a\"\";i:819;s:7:\"\"\\f10b\"\";i:820;s:7:\"\"\\f10c\"\";i:821;s:7:\"\"\\f10e\"\";i:822;s:7:\"\"\\f110\"\";i:823;s:7:\"\"\\f111\"\";i:824;s:7:\"\"\\f112\"\";i:825;s:7:\"\"\\f113\"\";i:826;s:7:\"\"\\f114\"\";i:827;s:7:\"\"\\f115\"\";i:828;s:7:\"\"\\f118\"\";i:829;s:7:\"\"\\f119\"\";i:830;s:7:\"\"\\f11a\"\";i:831;s:7:\"\"\\f11b\"\";i:832;s:7:\"\"\\f11c\"\";i:833;s:7:\"\"\\f11d\"\";i:834;s:7:\"\"\\f11e\"\";i:835;s:7:\"\"\\f120\"\";i:836;s:7:\"\"\\f121\"\";i:837;s:7:\"\"\\f122\"\";i:838;s:7:\"\"\\f123\"\";i:839;s:7:\"\"\\f124\"\";i:840;s:7:\"\"\\f125\"\";i:841;s:7:\"\"\\f126\"\";i:842;s:7:\"\"\\f127\"\";i:843;s:7:\"\"\\f128\"\";i:844;s:7:\"\"\\f129\"\";i:845;s:7:\"\"\\f12a\"\";i:846;s:7:\"\"\\f12b\"\";i:847;s:7:\"\"\\f12c\"\";i:848;s:7:\"\"\\f12d\"\";i:849;s:7:\"\"\\f12e\"\";i:850;s:7:\"\"\\f130\"\";i:851;s:7:\"\"\\f131\"\";i:852;s:7:\"\"\\f132\"\";i:853;s:7:\"\"\\f133\"\";i:854;s:7:\"\"\\f134\"\";i:855;s:7:\"\"\\f135\"\";i:856;s:7:\"\"\\f136\"\";i:857;s:7:\"\"\\f137\"\";i:858;s:7:\"\"\\f138\"\";i:859;s:7:\"\"\\f139\"\";i:860;s:7:\"\"\\f13a\"\";i:861;s:7:\"\"\\f13b\"\";i:862;s:7:\"\"\\f13c\"\";i:863;s:7:\"\"\\f13d\"\";i:864;s:7:\"\"\\f13e\"\";i:865;s:7:\"\"\\f140\"\";i:866;s:7:\"\"\\f141\"\";i:867;s:7:\"\"\\f142\"\";i:868;s:7:\"\"\\f143\"\";i:869;s:7:\"\"\\f144\"\";i:870;s:7:\"\"\\f145\"\";i:871;s:7:\"\"\\f146\"\";i:872;s:7:\"\"\\f147\"\";i:873;s:7:\"\"\\f148\"\";i:874;s:7:\"\"\\f149\"\";i:875;s:7:\"\"\\f14a\"\";i:876;s:7:\"\"\\f14b\"\";i:877;s:7:\"\"\\f14c\"\";i:878;s:7:\"\"\\f14d\"\";i:879;s:7:\"\"\\f14e\"\";i:880;s:7:\"\"\\f150\"\";i:881;s:7:\"\"\\f151\"\";i:882;s:7:\"\"\\f152\"\";i:883;s:7:\"\"\\f153\"\";i:884;s:7:\"\"\\f154\"\";i:885;s:7:\"\"\\f155\"\";i:886;s:7:\"\"\\f156\"\";i:887;s:7:\"\"\\f157\"\";i:888;s:7:\"\"\\f158\"\";i:889;s:7:\"\"\\f159\"\";i:890;s:7:\"\"\\f15a\"\";i:891;s:7:\"\"\\f15b\"\";i:892;s:7:\"\"\\f15c\"\";i:893;s:7:\"\"\\f15d\"\";i:894;s:7:\"\"\\f15e\"\";i:895;s:7:\"\"\\f160\"\";i:896;s:7:\"\"\\f161\"\";i:897;s:7:\"\"\\f162\"\";i:898;s:7:\"\"\\f163\"\";i:899;s:7:\"\"\\f164\"\";i:900;s:7:\"\"\\f165\"\";i:901;s:7:\"\"\\f166\"\";i:902;s:7:\"\"\\f167\"\";i:903;s:7:\"\"\\f168\"\";i:904;s:7:\"\"\\f169\"\";i:905;s:7:\"\"\\f16a\"\";i:906;s:7:\"\"\\f16b\"\";i:907;s:7:\"\"\\f16c\"\";i:908;s:7:\"\"\\f16d\"\";i:909;s:7:\"\"\\f16e\"\";i:910;s:7:\"\"\\f170\"\";i:911;s:7:\"\"\\f171\"\";i:912;s:7:\"\"\\f172\"\";i:913;s:7:\"\"\\f173\"\";i:914;s:7:\"\"\\f174\"\";i:915;s:7:\"\"\\f175\"\";i:916;s:7:\"\"\\f176\"\";i:917;s:7:\"\"\\f177\"\";i:918;s:7:\"\"\\f178\"\";i:919;s:7:\"\"\\f179\"\";i:920;s:7:\"\"\\f17a\"\";i:921;s:7:\"\"\\f17b\"\";i:922;s:7:\"\"\\f17c\"\";i:923;s:7:\"\"\\f17d\"\";i:924;s:7:\"\"\\f17e\"\";i:925;s:7:\"\"\\f180\"\";i:926;s:7:\"\"\\f181\"\";i:927;s:7:\"\"\\f182\"\";i:928;s:7:\"\"\\f183\"\";i:929;s:7:\"\"\\f184\"\";i:930;s:7:\"\"\\f185\"\";i:931;s:7:\"\"\\f186\"\";i:932;s:7:\"\"\\f187\"\";i:933;s:7:\"\"\\f188\"\";i:934;s:7:\"\"\\f189\"\";i:935;s:7:\"\"\\f18a\"\";i:936;s:7:\"\"\\f18b\"\";i:937;s:7:\"\"\\f18c\"\";i:938;s:7:\"\"\\f18d\"\";i:939;s:7:\"\"\\f18e\"\";i:940;s:7:\"\"\\f190\"\";i:941;s:7:\"\"\\f191\"\";i:942;s:7:\"\"\\f192\"\";i:943;s:7:\"\"\\f193\"\";i:944;s:7:\"\"\\f194\"\";i:945;s:7:\"\"\\f195\"\";i:946;s:7:\"\"\\f196\"\";i:947;s:7:\"\"\\f197\"\";i:948;s:7:\"\"\\f198\"\";i:949;s:7:\"\"\\f199\"\";i:950;s:7:\"\"\\f19a\"\";i:951;s:7:\"\"\\f19b\"\";i:952;s:7:\"\"\\f19c\"\";i:953;s:7:\"\"\\f19d\"\";i:954;s:7:\"\"\\f19e\"\";i:955;s:7:\"\"\\f1a0\"\";i:956;s:7:\"\"\\f1a1\"\";i:957;s:7:\"\"\\f1a2\"\";i:958;s:7:\"\"\\f1a3\"\";i:959;s:7:\"\"\\f1a4\"\";i:960;s:7:\"\"\\f1a5\"\";i:961;s:7:\"\"\\f1a6\"\";i:962;s:7:\"\"\\f1a7\"\";i:963;s:7:\"\"\\f1a8\"\";i:964;s:7:\"\"\\f1a9\"\";i:965;s:7:\"\"\\f1aa\"\";i:966;s:7:\"\"\\f1ab\"\";i:967;s:7:\"\"\\f1ac\"\";i:968;s:7:\"\"\\f1ad\"\";i:969;s:7:\"\"\\f1ae\"\";i:970;s:7:\"\"\\f1b0\"\";i:971;s:7:\"\"\\f1b1\"\";i:972;s:7:\"\"\\f1b2\"\";i:973;s:7:\"\"\\f1b3\"\";i:974;s:7:\"\"\\f1b4\"\";i:975;s:7:\"\"\\f1b5\"\";i:976;s:7:\"\"\\f1b6\"\";i:977;s:7:\"\"\\f1b7\"\";i:978;s:7:\"\"\\f1b8\"\";i:979;s:7:\"\"\\f1b9\"\";i:980;s:7:\"\"\\f1ba\"\";i:981;s:7:\"\"\\f1bb\"\";i:982;s:7:\"\"\\f1bc\"\";i:983;s:7:\"\"\\f1bd\"\";i:984;s:7:\"\"\\f1be\"\";i:985;s:7:\"\"\\f1c0\"\";i:986;s:7:\"\"\\f1c1\"\";i:987;s:7:\"\"\\f1c2\"\";i:988;s:7:\"\"\\f1c3\"\";i:989;s:7:\"\"\\f1c4\"\";i:990;s:7:\"\"\\f1c5\"\";i:991;s:7:\"\"\\f1c6\"\";i:992;s:7:\"\"\\f1c7\"\";i:993;s:7:\"\"\\f1c8\"\";i:994;s:7:\"\"\\f1c9\"\";i:995;s:7:\"\"\\f1ca\"\";i:996;s:7:\"\"\\f1cb\"\";i:997;s:7:\"\"\\f1cc\"\";i:998;s:7:\"\"\\f1cd\"\";i:999;s:7:\"\"\\f1ce\"\";i:1000;s:7:\"\"\\f1d0\"\";i:1001;s:7:\"\"\\f1d1\"\";i:1002;s:7:\"\"\\f1d2\"\";i:1003;s:7:\"\"\\f1d3\"\";i:1004;s:7:\"\"\\f1d4\"\";i:1005;s:7:\"\"\\f1d5\"\";i:1006;s:7:\"\"\\f1d6\"\";i:1007;s:7:\"\"\\f1d7\"\";i:1008;s:7:\"\"\\f1d8\"\";i:1009;s:7:\"\"\\f1d9\"\";i:1010;s:7:\"\"\\f1da\"\";i:1011;s:7:\"\"\\f1db\"\";i:1012;s:7:\"\"\\f1dc\"\";i:1013;s:7:\"\"\\f1dd\"\";i:1014;s:7:\"\"\\f1de\"\";i:1015;s:7:\"\"\\f1e0\"\";i:1016;s:7:\"\"\\f1e1\"\";i:1017;s:7:\"\"\\f1e2\"\";i:1018;s:7:\"\"\\f1e3\"\";i:1019;s:7:\"\"\\f1e4\"\";i:1020;s:7:\"\"\\f1e5\"\";i:1021;s:7:\"\"\\f1e6\"\";i:1022;s:7:\"\"\\f1e7\"\";i:1023;s:7:\"\"\\f1e8\"\";i:1024;s:7:\"\"\\f1e9\"\";i:1025;s:7:\"\"\\f1ea\"\";i:1026;s:7:\"\"\\f1eb\"\";i:1027;s:7:\"\"\\f1ec\"\";i:1028;s:7:\"\"\\f1ed\"\";i:1029;s:7:\"\"\\f1ee\"\";i:1030;s:7:\"\"\\f1f0\"\";i:1031;s:7:\"\"\\f1f1\"\";i:1032;s:7:\"\"\\f1f2\"\";i:1033;s:7:\"\"\\f1f3\"\";i:1034;s:7:\"\"\\f1f4\"\";i:1035;s:7:\"\"\\f1f5\"\";i:1036;s:7:\"\"\\f1f6\"\";i:1037;s:7:\"\"\\f1f7\"\";i:1038;s:7:\"\"\\f1f8\"\";i:1039;s:7:\"\"\\f1f9\"\";i:1040;s:7:\"\"\\f1fa\"\";i:1041;s:7:\"\"\\f1fb\"\";i:1042;s:7:\"\"\\f1fc\"\";i:1043;s:7:\"\"\\f1fd\"\";i:1044;s:7:\"\"\\f1fe\"\";i:1045;s:7:\"\"\\f200\"\";i:1046;s:7:\"\"\\f201\"\";i:1047;s:7:\"\"\\f202\"\";i:1048;s:7:\"\"\\f203\"\";i:1049;s:7:\"\"\\f204\"\";i:1050;s:7:\"\"\\f205\"\";i:1051;s:7:\"\"\\f206\"\";i:1052;s:7:\"\"\\f207\"\";i:1053;s:7:\"\"\\f208\"\";i:1054;s:7:\"\"\\f209\"\";i:1055;s:7:\"\"\\f20a\"\";i:1056;s:7:\"\"\\f20b\"\";i:1057;s:7:\"\"\\f20c\"\";i:1058;s:7:\"\"\\f20d\"\";i:1059;s:7:\"\"\\f20e\"\";i:1060;s:7:\"\"\\f210\"\";i:1061;s:7:\"\"\\f211\"\";i:1062;s:7:\"\"\\f212\"\";i:1063;s:7:\"\"\\f213\"\";i:1064;s:7:\"\"\\f214\"\";i:1065;s:7:\"\"\\f215\"\";i:1066;s:7:\"\"\\f216\"\";i:1067;s:7:\"\"\\f217\"\";i:1068;s:7:\"\"\\f218\"\";i:1069;s:7:\"\"\\f219\"\";i:1070;s:7:\"\"\\f21a\"\";i:1071;s:7:\"\"\\f21b\"\";i:1072;s:7:\"\"\\f21c\"\";i:1073;s:7:\"\"\\f21d\"\";i:1074;s:7:\"\"\\f21e\"\";i:1075;s:7:\"\"\\f221\"\";i:1076;s:7:\"\"\\f222\"\";i:1077;s:7:\"\"\\f223\"\";i:1078;s:7:\"\"\\f224\"\";i:1079;s:7:\"\"\\f225\"\";i:1080;s:7:\"\"\\f226\"\";i:1081;s:7:\"\"\\f227\"\";i:1082;s:7:\"\"\\f228\"\";i:1083;s:7:\"\"\\f229\"\";i:1084;s:7:\"\"\\f22a\"\";i:1085;s:7:\"\"\\f22b\"\";i:1086;s:7:\"\"\\f22c\"\";i:1087;s:7:\"\"\\f22d\"\";i:1088;s:7:\"\"\\f230\"\";i:1089;s:7:\"\"\\f231\"\";i:1090;s:7:\"\"\\f232\"\";i:1091;s:7:\"\"\\f233\"\";i:1092;s:7:\"\"\\f234\"\";i:1093;s:7:\"\"\\f235\"\";i:1094;s:7:\"\"\\f236\"\";i:1095;s:7:\"\"\\f237\"\";i:1096;s:7:\"\"\\f238\"\";i:1097;s:7:\"\"\\f239\"\";i:1098;s:7:\"\"\\f23a\"\";i:1099;s:7:\"\"\\f23b\"\";i:1100;s:7:\"\"\\f23c\"\";i:1101;s:7:\"\"\\f23d\"\";i:1102;s:7:\"\"\\f23e\"\";i:1103;s:7:\"\"\\f240\"\";i:1104;s:7:\"\"\\f241\"\";i:1105;s:7:\"\"\\f242\"\";i:1106;s:7:\"\"\\f243\"\";i:1107;s:7:\"\"\\f244\"\";i:1108;s:7:\"\"\\f245\"\";i:1109;s:7:\"\"\\f246\"\";i:1110;s:7:\"\"\\f247\"\";i:1111;s:7:\"\"\\f248\"\";i:1112;s:7:\"\"\\f249\"\";i:1113;s:7:\"\"\\f24a\"\";i:1114;s:7:\"\"\\f24b\"\";i:1115;s:7:\"\"\\f24c\"\";i:1116;s:7:\"\"\\f24d\"\";i:1117;s:7:\"\"\\f24e\"\";i:1118;s:7:\"\"\\f250\"\";i:1119;s:7:\"\"\\f251\"\";i:1120;s:7:\"\"\\f252\"\";i:1121;s:7:\"\"\\f253\"\";i:1122;s:7:\"\"\\f254\"\";i:1123;s:7:\"\"\\f255\"\";i:1124;s:7:\"\"\\f256\"\";i:1125;s:7:\"\"\\f257\"\";i:1126;s:7:\"\"\\f258\"\";i:1127;s:7:\"\"\\f259\"\";i:1128;s:7:\"\"\\f25a\"\";i:1129;s:7:\"\"\\f25b\"\";i:1130;s:7:\"\"\\f25c\"\";i:1131;s:7:\"\"\\f25d\"\";i:1132;s:7:\"\"\\f25e\"\";i:1133;s:7:\"\"\\f260\"\";i:1134;s:7:\"\"\\f261\"\";i:1135;s:7:\"\"\\f262\"\";i:1136;s:7:\"\"\\f263\"\";i:1137;s:7:\"\"\\f264\"\";i:1138;s:7:\"\"\\f265\"\";i:1139;s:7:\"\"\\f266\"\";i:1140;s:7:\"\"\\f267\"\";i:1141;s:7:\"\"\\f268\"\";i:1142;s:7:\"\"\\f269\"\";i:1143;s:7:\"\"\\f26a\"\";i:1144;s:7:\"\"\\f26b\"\";i:1145;s:7:\"\"\\f26c\"\";i:1146;s:7:\"\"\\f26d\"\";i:1147;s:7:\"\"\\f26e\"\";i:1148;s:7:\"\"\\f270\"\";i:1149;s:7:\"\"\\f271\"\";i:1150;s:7:\"\"\\f272\"\";i:1151;s:7:\"\"\\f273\"\";i:1152;s:7:\"\"\\f274\"\";i:1153;s:7:\"\"\\f275\"\";i:1154;s:7:\"\"\\f276\"\";i:1155;s:7:\"\"\\f277\"\";i:1156;s:7:\"\"\\f278\"\";i:1157;s:7:\"\"\\f279\"\";i:1158;s:7:\"\"\\f27a\"\";i:1159;s:7:\"\"\\f27b\"\";i:1160;s:7:\"\"\\f27c\"\";i:1161;s:7:\"\"\\f27d\"\";i:1162;s:7:\"\"\\f27e\"\";i:1163;s:7:\"\"\\f280\"\";i:1164;s:7:\"\"\\f281\"\";i:1165;s:7:\"\"\\f282\"\";i:1166;s:7:\"\"\\f283\"\";i:1167;s:7:\"\"\\f284\"\";i:1168;s:7:\"\"\\f285\"\";i:1169;s:7:\"\"\\f286\"\";i:1170;s:7:\"\"\\f287\"\";i:1171;s:7:\"\"\\f288\"\";i:1172;s:7:\"\"\\f289\"\";i:1173;s:7:\"\"\\f28a\"\";i:1174;s:7:\"\"\\f28b\"\";i:1175;s:7:\"\"\\f28c\"\";i:1176;s:7:\"\"\\f28d\"\";i:1177;s:7:\"\"\\f28e\"\";i:1178;s:7:\"\"\\f290\"\";i:1179;s:7:\"\"\\f291\"\";i:1180;s:7:\"\"\\f292\"\";i:1181;s:7:\"\"\\f293\"\";i:1182;s:7:\"\"\\f294\"\";i:1183;s:7:\"\"\\f295\"\";i:1184;s:7:\"\"\\f296\"\";i:1185;s:7:\"\"\\f297\"\";i:1186;s:7:\"\"\\f298\"\";i:1187;s:7:\"\"\\f299\"\";i:1188;s:7:\"\"\\f29a\"\";i:1189;s:7:\"\"\\f29b\"\";i:1190;s:7:\"\"\\f29c\"\";i:1191;s:7:\"\"\\f29d\"\";i:1192;s:7:\"\"\\f29e\"\";i:1193;s:7:\"\"\\f2a0\"\";i:1194;s:7:\"\"\\f2a1\"\";i:1195;s:7:\"\"\\f2a2\"\";i:1196;s:7:\"\"\\f2a3\"\";i:1197;s:7:\"\"\\f2a4\"\";i:1198;s:7:\"\"\\f2a5\"\";i:1199;s:7:\"\"\\f2a6\"\";i:1200;s:7:\"\"\\f2a7\"\";i:1201;s:7:\"\"\\f2a8\"\";i:1202;s:7:\"\"\\f2a9\"\";i:1203;s:7:\"\"\\f2aa\"\";i:1204;s:7:\"\"\\f2ab\"\";i:1205;s:7:\"\"\\f2ac\"\";i:1206;s:7:\"\"\\f2ad\"\";i:1207;s:7:\"\"\\f2ae\"\";i:1208;s:7:\"\"\\f2b0\"\";i:1209;s:7:\"\"\\f2b1\"\";i:1210;s:7:\"\"\\f2b2\"\";i:1211;s:7:\"\"\\f2b3\"\";i:1212;s:7:\"\"\\f2b4\"\";i:1213;s:16:\"rect(0, 0, 0, 0)\";i:1214;s:17:\"\"material-design\"\";i:1215;s:7:\"\"\\e000\"\";i:1216;s:7:\"\"\\e001\"\";i:1217;s:7:\"\"\\e002\"\";i:1218;s:7:\"\"\\e003\"\";i:1219;s:7:\"\"\\e004\"\";i:1220;s:7:\"\"\\e005\"\";i:1221;s:7:\"\"\\e006\"\";i:1222;s:7:\"\"\\e007\"\";i:1223;s:7:\"\"\\e008\"\";i:1224;s:7:\"\"\\e009\"\";i:1225;s:7:\"\"\\e00a\"\";i:1226;s:7:\"\"\\e00b\"\";i:1227;s:7:\"\"\\e00c\"\";i:1228;s:7:\"\"\\e00d\"\";i:1229;s:7:\"\"\\e00e\"\";i:1230;s:7:\"\"\\e00f\"\";i:1231;s:7:\"\"\\e010\"\";i:1232;s:7:\"\"\\e011\"\";i:1233;s:7:\"\"\\e012\"\";i:1234;s:7:\"\"\\e013\"\";i:1235;s:7:\"\"\\e014\"\";i:1236;s:7:\"\"\\e015\"\";i:1237;s:7:\"\"\\e016\"\";i:1238;s:7:\"\"\\e017\"\";i:1239;s:7:\"\"\\e018\"\";i:1240;s:7:\"\"\\e019\"\";i:1241;s:7:\"\"\\e01a\"\";i:1242;s:7:\"\"\\e01b\"\";i:1243;s:7:\"\"\\e01c\"\";i:1244;s:7:\"\"\\e01d\"\";i:1245;s:7:\"\"\\e01e\"\";i:1246;s:7:\"\"\\e01f\"\";i:1247;s:7:\"\"\\e020\"\";i:1248;s:7:\"\"\\e021\"\";i:1249;s:7:\"\"\\e022\"\";i:1250;s:7:\"\"\\e023\"\";i:1251;s:7:\"\"\\e024\"\";i:1252;s:7:\"\"\\e025\"\";i:1253;s:7:\"\"\\e026\"\";i:1254;s:7:\"\"\\e027\"\";i:1255;s:7:\"\"\\e028\"\";i:1256;s:7:\"\"\\e029\"\";i:1257;s:7:\"\"\\e02a\"\";i:1258;s:7:\"\"\\e02b\"\";i:1259;s:7:\"\"\\e02c\"\";i:1260;s:7:\"\"\\e02d\"\";i:1261;s:7:\"\"\\e02e\"\";i:1262;s:7:\"\"\\e02f\"\";i:1263;s:7:\"\"\\e030\"\";i:1264;s:7:\"\"\\e031\"\";i:1265;s:7:\"\"\\e032\"\";i:1266;s:7:\"\"\\e033\"\";i:1267;s:7:\"\"\\e034\"\";i:1268;s:7:\"\"\\e035\"\";i:1269;s:7:\"\"\\e036\"\";i:1270;s:7:\"\"\\e037\"\";i:1271;s:7:\"\"\\e038\"\";i:1272;s:7:\"\"\\e039\"\";i:1273;s:7:\"\"\\e03a\"\";i:1274;s:7:\"\"\\e03b\"\";i:1275;s:7:\"\"\\e03c\"\";i:1276;s:7:\"\"\\e03d\"\";i:1277;s:7:\"\"\\e03e\"\";i:1278;s:7:\"\"\\e03f\"\";i:1279;s:7:\"\"\\e040\"\";i:1280;s:7:\"\"\\e041\"\";i:1281;s:7:\"\"\\e042\"\";i:1282;s:7:\"\"\\e043\"\";i:1283;s:7:\"\"\\e044\"\";i:1284;s:7:\"\"\\e045\"\";i:1285;s:7:\"\"\\e046\"\";i:1286;s:7:\"\"\\e047\"\";i:1287;s:7:\"\"\\e048\"\";i:1288;s:7:\"\"\\e049\"\";i:1289;s:7:\"\"\\e04a\"\";i:1290;s:7:\"\"\\e04b\"\";i:1291;s:7:\"\"\\e04c\"\";i:1292;s:7:\"\"\\e04d\"\";i:1293;s:7:\"\"\\e04e\"\";i:1294;s:7:\"\"\\e04f\"\";i:1295;s:7:\"\"\\e050\"\";i:1296;s:7:\"\"\\e051\"\";i:1297;s:7:\"\"\\e052\"\";i:1298;s:7:\"\"\\e053\"\";i:1299;s:7:\"\"\\e054\"\";i:1300;s:7:\"\"\\e055\"\";i:1301;s:7:\"\"\\e056\"\";i:1302;s:7:\"\"\\e057\"\";i:1303;s:7:\"\"\\e058\"\";i:1304;s:7:\"\"\\e059\"\";i:1305;s:7:\"\"\\e05a\"\";i:1306;s:7:\"\"\\e05b\"\";i:1307;s:7:\"\"\\e05c\"\";i:1308;s:7:\"\"\\e05d\"\";i:1309;s:7:\"\"\\e05e\"\";i:1310;s:7:\"\"\\e05f\"\";i:1311;s:7:\"\"\\e060\"\";i:1312;s:7:\"\"\\e061\"\";i:1313;s:7:\"\"\\e062\"\";i:1314;s:7:\"\"\\e063\"\";i:1315;s:7:\"\"\\e064\"\";i:1316;s:7:\"\"\\e065\"\";i:1317;s:7:\"\"\\e066\"\";i:1318;s:7:\"\"\\e067\"\";i:1319;s:7:\"\"\\e068\"\";i:1320;s:7:\"\"\\e069\"\";i:1321;s:7:\"\"\\e06a\"\";i:1322;s:7:\"\"\\e06b\"\";i:1323;s:7:\"\"\\e06c\"\";i:1324;s:7:\"\"\\e06d\"\";i:1325;s:7:\"\"\\e06e\"\";i:1326;s:7:\"\"\\e06f\"\";i:1327;s:7:\"\"\\e070\"\";i:1328;s:7:\"\"\\e071\"\";i:1329;s:7:\"\"\\e072\"\";i:1330;s:7:\"\"\\e073\"\";i:1331;s:7:\"\"\\e074\"\";i:1332;s:7:\"\"\\e075\"\";i:1333;s:7:\"\"\\e076\"\";i:1334;s:7:\"\"\\e077\"\";i:1335;s:7:\"\"\\e078\"\";i:1336;s:7:\"\"\\e079\"\";i:1337;s:7:\"\"\\e07a\"\";i:1338;s:7:\"\"\\e07b\"\";i:1339;s:7:\"\"\\e07c\"\";i:1340;s:7:\"\"\\e07d\"\";i:1341;s:7:\"\"\\e07e\"\";i:1342;s:7:\"\"\\e07f\"\";i:1343;s:7:\"\"\\e080\"\";i:1344;s:7:\"\"\\e081\"\";i:1345;s:7:\"\"\\e082\"\";i:1346;s:7:\"\"\\e083\"\";i:1347;s:7:\"\"\\e084\"\";i:1348;s:7:\"\"\\e085\"\";i:1349;s:7:\"\"\\e086\"\";i:1350;s:7:\"\"\\e087\"\";i:1351;s:7:\"\"\\e088\"\";i:1352;s:7:\"\"\\e089\"\";i:1353;s:7:\"\"\\e08a\"\";i:1354;s:7:\"\"\\e08b\"\";i:1355;s:7:\"\"\\e08c\"\";i:1356;s:7:\"\"\\e08d\"\";i:1357;s:7:\"\"\\e08e\"\";i:1358;s:7:\"\"\\e08f\"\";i:1359;s:7:\"\"\\e090\"\";i:1360;s:7:\"\"\\e091\"\";i:1361;s:7:\"\"\\e092\"\";i:1362;s:7:\"\"\\e093\"\";i:1363;s:7:\"\"\\e094\"\";i:1364;s:7:\"\"\\e095\"\";i:1365;s:7:\"\"\\e096\"\";i:1366;s:7:\"\"\\e097\"\";i:1367;s:7:\"\"\\e098\"\";i:1368;s:7:\"\"\\e099\"\";i:1369;s:7:\"\"\\e09a\"\";i:1370;s:7:\"\"\\e09b\"\";i:1371;s:7:\"\"\\e09c\"\";i:1372;s:7:\"\"\\e09d\"\";i:1373;s:7:\"\"\\e09e\"\";i:1374;s:7:\"\"\\e09f\"\";i:1375;s:7:\"\"\\e0a0\"\";i:1376;s:7:\"\"\\e0a1\"\";i:1377;s:7:\"\"\\e0a2\"\";i:1378;s:7:\"\"\\e0a3\"\";i:1379;s:7:\"\"\\e0a4\"\";i:1380;s:7:\"\"\\e0a5\"\";i:1381;s:7:\"\"\\e0a6\"\";i:1382;s:7:\"\"\\e0a7\"\";i:1383;s:7:\"\"\\e0a8\"\";i:1384;s:7:\"\"\\e0a9\"\";i:1385;s:7:\"\"\\e0aa\"\";i:1386;s:7:\"\"\\e0ab\"\";i:1387;s:7:\"\"\\e0ac\"\";i:1388;s:7:\"\"\\e0ad\"\";i:1389;s:7:\"\"\\e0ae\"\";i:1390;s:7:\"\"\\e0af\"\";i:1391;s:7:\"\"\\e0b0\"\";i:1392;s:7:\"\"\\e0b1\"\";i:1393;s:7:\"\"\\e0b2\"\";i:1394;s:7:\"\"\\e0b3\"\";i:1395;s:7:\"\"\\e0b4\"\";i:1396;s:7:\"\"\\e0b5\"\";i:1397;s:7:\"\"\\e0b6\"\";i:1398;s:7:\"\"\\e0b7\"\";i:1399;s:7:\"\"\\e0b8\"\";i:1400;s:7:\"\"\\e0b9\"\";i:1401;s:7:\"\"\\e0ba\"\";i:1402;s:7:\"\"\\e0bb\"\";i:1403;s:7:\"\"\\e0bc\"\";i:1404;s:7:\"\"\\e0bd\"\";i:1405;s:7:\"\"\\e0be\"\";i:1406;s:7:\"\"\\e0bf\"\";i:1407;s:7:\"\"\\e0c0\"\";i:1408;s:7:\"\"\\e0c1\"\";i:1409;s:7:\"\"\\e0c2\"\";i:1410;s:7:\"\"\\e0c3\"\";i:1411;s:7:\"\"\\e0c4\"\";i:1412;s:7:\"\"\\e0c5\"\";i:1413;s:7:\"\"\\e0c6\"\";i:1414;s:7:\"\"\\e0c7\"\";i:1415;s:7:\"\"\\e0c8\"\";i:1416;s:7:\"\"\\e0c9\"\";i:1417;s:7:\"\"\\e0ca\"\";i:1418;s:7:\"\"\\e0cb\"\";i:1419;s:7:\"\"\\e0cc\"\";i:1420;s:7:\"\"\\e0cd\"\";i:1421;s:7:\"\"\\e0ce\"\";i:1422;s:7:\"\"\\e0cf\"\";i:1423;s:7:\"\"\\e0d0\"\";i:1424;s:7:\"\"\\e0d1\"\";i:1425;s:7:\"\"\\e0d2\"\";i:1426;s:7:\"\"\\e0d3\"\";i:1427;s:7:\"\"\\e0d4\"\";i:1428;s:7:\"\"\\e0d5\"\";i:1429;s:7:\"\"\\e0d6\"\";i:1430;s:7:\"\"\\e0d7\"\";i:1431;s:7:\"\"\\e0d8\"\";i:1432;s:7:\"\"\\e0d9\"\";i:1433;s:7:\"\"\\e0da\"\";i:1434;s:7:\"\"\\e0db\"\";i:1435;s:7:\"\"\\e0dc\"\";i:1436;s:7:\"\"\\e0dd\"\";i:1437;s:7:\"\"\\e0de\"\";i:1438;s:7:\"\"\\e0df\"\";i:1439;s:7:\"\"\\e0e0\"\";i:1440;s:7:\"\"\\e0e1\"\";i:1441;s:7:\"\"\\e0e2\"\";i:1442;s:7:\"\"\\e0e3\"\";i:1443;s:7:\"\"\\e0e4\"\";i:1444;s:7:\"\"\\e0e5\"\";i:1445;s:7:\"\"\\e0e6\"\";i:1446;s:7:\"\"\\e0e7\"\";i:1447;s:7:\"\"\\e0e8\"\";i:1448;s:7:\"\"\\e0e9\"\";i:1449;s:7:\"\"\\e0ea\"\";i:1450;s:7:\"\"\\e0eb\"\";i:1451;s:7:\"\"\\e0ec\"\";i:1452;s:7:\"\"\\e0ed\"\";i:1453;s:7:\"\"\\e0ee\"\";i:1454;s:7:\"\"\\e0ef\"\";i:1455;s:7:\"\"\\e0f0\"\";i:1456;s:7:\"\"\\e0f1\"\";i:1457;s:7:\"\"\\e0f2\"\";i:1458;s:7:\"\"\\e0f3\"\";i:1459;s:7:\"\"\\e0f4\"\";i:1460;s:7:\"\"\\e0f5\"\";i:1461;s:7:\"\"\\e0f6\"\";i:1462;s:7:\"\"\\e0f7\"\";i:1463;s:7:\"\"\\e0f8\"\";i:1464;s:7:\"\"\\e0f9\"\";i:1465;s:7:\"\"\\e0fa\"\";i:1466;s:7:\"\"\\e0fb\"\";i:1467;s:7:\"\"\\e0fc\"\";i:1468;s:7:\"\"\\e0fd\"\";i:1469;s:7:\"\"\\e0fe\"\";i:1470;s:7:\"\"\\e0ff\"\";i:1471;s:7:\"\"\\e100\"\";i:1472;s:7:\"\"\\e101\"\";i:1473;s:7:\"\"\\e102\"\";i:1474;s:7:\"\"\\e103\"\";i:1475;s:7:\"\"\\e104\"\";i:1476;s:7:\"\"\\e105\"\";i:1477;s:7:\"\"\\e106\"\";i:1478;s:7:\"\"\\e107\"\";i:1479;s:7:\"\"\\e108\"\";i:1480;s:7:\"\"\\e109\"\";i:1481;s:7:\"\"\\e10a\"\";i:1482;s:7:\"\"\\e10b\"\";i:1483;s:7:\"\"\\e10c\"\";i:1484;s:7:\"\"\\e10d\"\";i:1485;s:7:\"\"\\e10e\"\";i:1486;s:7:\"\"\\e10f\"\";i:1487;s:7:\"\"\\e110\"\";i:1488;s:7:\"\"\\e111\"\";i:1489;s:7:\"\"\\e112\"\";i:1490;s:7:\"\"\\e113\"\";i:1491;s:7:\"\"\\e114\"\";i:1492;s:7:\"\"\\e115\"\";i:1493;s:7:\"\"\\e116\"\";i:1494;s:7:\"\"\\e117\"\";i:1495;s:7:\"\"\\e118\"\";i:1496;s:7:\"\"\\e119\"\";i:1497;s:7:\"\"\\e11a\"\";i:1498;s:7:\"\"\\e11b\"\";i:1499;s:7:\"\"\\e11c\"\";i:1500;s:7:\"\"\\e11d\"\";i:1501;s:7:\"\"\\e11e\"\";i:1502;s:7:\"\"\\e11f\"\";i:1503;s:7:\"\"\\e120\"\";i:1504;s:7:\"\"\\e121\"\";i:1505;s:7:\"\"\\e122\"\";i:1506;s:7:\"\"\\e123\"\";i:1507;s:7:\"\"\\e124\"\";i:1508;s:7:\"\"\\e125\"\";i:1509;s:7:\"\"\\e126\"\";i:1510;s:7:\"\"\\e127\"\";i:1511;s:7:\"\"\\e128\"\";i:1512;s:7:\"\"\\e129\"\";i:1513;s:7:\"\"\\e12a\"\";i:1514;s:7:\"\"\\e12b\"\";i:1515;s:7:\"\"\\e12c\"\";i:1516;s:7:\"\"\\e12d\"\";i:1517;s:7:\"\"\\e12e\"\";i:1518;s:7:\"\"\\e12f\"\";i:1519;s:7:\"\"\\e130\"\";i:1520;s:7:\"\"\\e131\"\";i:1521;s:7:\"\"\\e132\"\";i:1522;s:7:\"\"\\e133\"\";i:1523;s:7:\"\"\\e134\"\";i:1524;s:7:\"\"\\e135\"\";i:1525;s:7:\"\"\\e136\"\";i:1526;s:7:\"\"\\e137\"\";i:1527;s:7:\"\"\\e138\"\";i:1528;s:7:\"\"\\e139\"\";i:1529;s:7:\"\"\\e13a\"\";i:1530;s:7:\"\"\\e13b\"\";i:1531;s:7:\"\"\\e13c\"\";i:1532;s:7:\"\"\\e13d\"\";i:1533;s:7:\"\"\\e13e\"\";i:1534;s:7:\"\"\\e13f\"\";i:1535;s:7:\"\"\\e140\"\";i:1536;s:7:\"\"\\e141\"\";i:1537;s:7:\"\"\\e142\"\";i:1538;s:7:\"\"\\e143\"\";i:1539;s:7:\"\"\\e144\"\";i:1540;s:7:\"\"\\e145\"\";i:1541;s:7:\"\"\\e146\"\";i:1542;s:7:\"\"\\e147\"\";i:1543;s:7:\"\"\\e148\"\";i:1544;s:7:\"\"\\e149\"\";i:1545;s:7:\"\"\\e14a\"\";i:1546;s:7:\"\"\\e14b\"\";i:1547;s:7:\"\"\\e14c\"\";i:1548;s:7:\"\"\\e14d\"\";i:1549;s:7:\"\"\\e14e\"\";i:1550;s:7:\"\"\\e14f\"\";i:1551;s:7:\"\"\\e150\"\";i:1552;s:7:\"\"\\e151\"\";i:1553;s:7:\"\"\\e152\"\";i:1554;s:7:\"\"\\e153\"\";i:1555;s:7:\"\"\\e154\"\";i:1556;s:7:\"\"\\e155\"\";i:1557;s:7:\"\"\\e156\"\";i:1558;s:7:\"\"\\e157\"\";i:1559;s:7:\"\"\\e158\"\";i:1560;s:7:\"\"\\e159\"\";i:1561;s:7:\"\"\\e15a\"\";i:1562;s:7:\"\"\\e15b\"\";i:1563;s:7:\"\"\\e15c\"\";i:1564;s:7:\"\"\\e15d\"\";i:1565;s:7:\"\"\\e15e\"\";i:1566;s:7:\"\"\\e15f\"\";i:1567;s:7:\"\"\\e160\"\";i:1568;s:7:\"\"\\e161\"\";i:1569;s:7:\"\"\\e162\"\";i:1570;s:7:\"\"\\e163\"\";i:1571;s:7:\"\"\\e164\"\";i:1572;s:7:\"\"\\e165\"\";i:1573;s:7:\"\"\\e166\"\";i:1574;s:7:\"\"\\e167\"\";i:1575;s:7:\"\"\\e168\"\";i:1576;s:7:\"\"\\e169\"\";i:1577;s:7:\"\"\\e16a\"\";i:1578;s:7:\"\"\\e16b\"\";i:1579;s:7:\"\"\\e16c\"\";i:1580;s:7:\"\"\\e16d\"\";i:1581;s:7:\"\"\\e16e\"\";i:1582;s:7:\"\"\\e16f\"\";i:1583;s:7:\"\"\\e170\"\";i:1584;s:7:\"\"\\e171\"\";i:1585;s:7:\"\"\\e172\"\";i:1586;s:7:\"\"\\e173\"\";i:1587;s:7:\"\"\\e174\"\";i:1588;s:7:\"\"\\e175\"\";i:1589;s:7:\"\"\\e176\"\";i:1590;s:7:\"\"\\e177\"\";i:1591;s:7:\"\"\\e178\"\";i:1592;s:7:\"\"\\e179\"\";i:1593;s:7:\"\"\\e17a\"\";i:1594;s:7:\"\"\\e17b\"\";i:1595;s:7:\"\"\\e17c\"\";i:1596;s:7:\"\"\\e17d\"\";i:1597;s:7:\"\"\\e17e\"\";i:1598;s:7:\"\"\\e17f\"\";i:1599;s:7:\"\"\\e180\"\";i:1600;s:7:\"\"\\e181\"\";i:1601;s:7:\"\"\\e182\"\";i:1602;s:7:\"\"\\e183\"\";i:1603;s:7:\"\"\\e184\"\";i:1604;s:7:\"\"\\e185\"\";i:1605;s:7:\"\"\\e186\"\";i:1606;s:7:\"\"\\e187\"\";i:1607;s:7:\"\"\\e188\"\";i:1608;s:7:\"\"\\e189\"\";i:1609;s:7:\"\"\\e18a\"\";i:1610;s:7:\"\"\\e18b\"\";i:1611;s:7:\"\"\\e18c\"\";i:1612;s:7:\"\"\\e18d\"\";i:1613;s:7:\"\"\\e18e\"\";i:1614;s:7:\"\"\\e18f\"\";i:1615;s:7:\"\"\\e190\"\";i:1616;s:7:\"\"\\e191\"\";i:1617;s:7:\"\"\\e192\"\";i:1618;s:7:\"\"\\e193\"\";i:1619;s:7:\"\"\\e194\"\";i:1620;s:7:\"\"\\e195\"\";i:1621;s:7:\"\"\\e196\"\";i:1622;s:7:\"\"\\e197\"\";i:1623;s:7:\"\"\\e198\"\";i:1624;s:7:\"\"\\e199\"\";i:1625;s:7:\"\"\\e19a\"\";i:1626;s:7:\"\"\\e19b\"\";i:1627;s:7:\"\"\\e19c\"\";i:1628;s:7:\"\"\\e19d\"\";i:1629;s:7:\"\"\\e19e\"\";i:1630;s:7:\"\"\\e19f\"\";i:1631;s:7:\"\"\\e1a0\"\";i:1632;s:7:\"\"\\e1a1\"\";i:1633;s:7:\"\"\\e1a2\"\";i:1634;s:7:\"\"\\e1a3\"\";i:1635;s:7:\"\"\\e1a4\"\";i:1636;s:7:\"\"\\e1a5\"\";i:1637;s:7:\"\"\\e1a6\"\";i:1638;s:11:\"\"fl-glypho\"\";i:1639;s:11:\"\'fl-glypho\'\";i:1640;s:10:\"\"fontello\"\";i:1641;s:7:\"\'\\f800\'\";i:1642;s:7:\"\'\\f801\'\";i:1643;s:7:\"\'\\f802\'\";i:1644;s:14:\"rgba(0,0,0,.6)\";i:1645;s:11:\"scale(0.75)\";i:1646;s:4:\"1042\";i:1647;s:7:\"#0b0b0b\";i:1648;s:2:\".8\";i:1649;s:17:\"alpha(opacity=80)\";i:1650;s:4:\"1043\";i:1651;s:4:\"1045\";i:1652;s:8:\"progress\";i:1653;s:13:\"-moz-zoom-out\";i:1654;s:16:\"-webkit-zoom-out\";i:1655;s:8:\"zoom-out\";i:1656;s:15:\"-webkit-zoom-in\";i:1657;s:12:\"-moz-zoom-in\";i:1658;s:7:\"zoom-in\";i:1659;s:4:\"#ccc\";i:1660;s:5:\"-.8em\";i:1661;s:4:\"1044\";i:1662;s:3:\"0 0\";i:1663;s:4:\"1046\";i:1664;s:17:\"alpha(opacity=65)\";i:1665;s:27:\"Arial,Baskerville,monospace\";i:1666;s:18:\"alpha(opacity=100)\";i:1667;s:4:\"#333\";i:1668;s:4:\"-6px\";i:1669;s:5:\"-55px\";i:1670;s:5:\"110px\";i:1671;s:5:\"-54px\";i:1672;s:24:\"medium inset transparent\";i:1673;s:15:\"17px solid #fff\";i:1674;s:18:\"27px solid #3f3f3f\";i:1675;s:5:\"900px\";i:1676;s:6:\"56.25%\";i:1677;s:22:\"0 0 8px rgba(0,0,0,.6)\";i:1678;s:4:\"#444\";i:1679;s:7:\"#bdbdbd\";i:1680;s:5:\"-36px\";i:1681;s:7:\"#f3f3f3\";i:1682;s:5:\"600px\";i:1683;s:6:\"-300px\";i:1684;s:11:\"-webkit-box\";i:1685;s:8:\"-moz-box\";i:1686;s:17:\"-webkit-transform\";i:1687;s:14:\"-moz-transform\";i:1688;s:12:\"-o-transform\";i:1689;s:13:\"-ms-transform\";i:1690;s:9:\"transform\";i:1691;s:18:\"translate3d(0,0,0)\";i:1692;s:14:\"translate(0,0)\";i:1693;s:8:\"multiple\";i:1694;s:8:\"ease-out\";i:1695;s:24:\"-webkit-transform,height\";i:1696;s:16:\"transform,height\";i:1697;s:5:\"-1000\";i:1698;s:5:\"pan-y\";i:1699;s:5:\"pan-x\";i:1700;s:9:\"27px 44px\";i:1701;s:3:\".35\";i:1702;s:258:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20viewBox%3D\'0%200%2027%2044\'%3E%3Cpath%20d%3D\'M0%2C22L22%2C0l2.1%2C2.1L4.2%2C22l19.9%2C19.9L22%2C44L0%2C22L0%2C22L0%2C22z\'%20fill%3D\'%23007aff\'%2F%3E%3C%2Fsvg%3E\")\";i:1703;s:258:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20viewBox%3D\'0%200%2027%2044\'%3E%3Cpath%20d%3D\'M0%2C22L22%2C0l2.1%2C2.1L4.2%2C22l19.9%2C19.9L22%2C44L0%2C22L0%2C22L0%2C22z\'%20fill%3D\'%23000000\'%2F%3E%3C%2Fsvg%3E\")\";i:1704;s:258:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20viewBox%3D\'0%200%2027%2044\'%3E%3Cpath%20d%3D\'M0%2C22L22%2C0l2.1%2C2.1L4.2%2C22l19.9%2C19.9L22%2C44L0%2C22L0%2C22L0%2C22z\'%20fill%3D\'%23ffffff\'%2F%3E%3C%2Fsvg%3E\")\";i:1705;s:258:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20viewBox%3D\'0%200%2027%2044\'%3E%3Cpath%20d%3D\'M27%2C22L27%2C22L5%2C44l-2.1-2.1L22.8%2C22L2.9%2C2.1L5%2C0L27%2C22L27%2C22z\'%20fill%3D\'%23007aff\'%2F%3E%3C%2Fsvg%3E\")\";i:1706;s:258:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20viewBox%3D\'0%200%2027%2044\'%3E%3Cpath%20d%3D\'M27%2C22L27%2C22L5%2C44l-2.1-2.1L22.8%2C22L2.9%2C2.1L5%2C0L27%2C22L27%2C22z\'%20fill%3D\'%23000000\'%2F%3E%3C%2Fsvg%3E\")\";i:1707;s:258:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20viewBox%3D\'0%200%2027%2044\'%3E%3Cpath%20d%3D\'M27%2C22L27%2C22L5%2C44l-2.1-2.1L22.8%2C22L2.9%2C2.1L5%2C0L27%2C22L27%2C22z\'%20fill%3D\'%23ffffff\'%2F%3E%3C%2Fsvg%3E\")\";i:1708;s:5:\"300ms\";i:1709;s:2:\".2\";i:1710;s:7:\"#007aff\";i:1711;s:21:\"translate3d(0,-50%,0)\";i:1712;s:17:\"translate(0,-50%)\";i:1713;s:15:\"rgba(0,0,0,.25)\";i:1714;s:8:\"scale(0)\";i:1715;s:8:\"left top\";i:1716;s:9:\"right top\";i:1717;s:20:\"rgba(255,255,255,.5)\";i:1718;s:6:\"1200px\";i:1719;s:11:\"preserve-3d\";i:1720;s:42:\"right:rgba(0,0,0,.5):0%:rgba(0,0,0,0):100%\";i:1721;s:41:\"left:rgba(0,0,0,.5):0%:rgba(0,0,0,0):100%\";i:1722;s:43:\"bottom:rgba(0,0,0,.5):0%:rgba(0,0,0,0):100%\";i:1723;s:40:\"top:rgba(0,0,0,.5):0%:rgba(0,0,0,0):100%\";i:1724;s:6:\"100% 0\";i:1725;s:2:\".6\";i:1726;s:10:\"blur(50px)\";i:1727;s:7:\"opacity\";i:1728;s:14:\"rgba(0,0,0,.1)\";i:1729;s:2:\"50\";i:1730;s:3:\"98%\";i:1731;s:14:\"rgba(0,0,0,.5)\";i:1732;s:4:\"move\";i:1733;s:5:\"-21px\";i:1734;s:47:\"swiper-preloader-spin 1s steps(12,end) infinite\";i:1735;s:1447:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20viewBox%3D\'0%200%20120%20120\'%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20xmlns%3Axlink%3D\'http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink\'%3E%3Cdefs%3E%3Cline%20id%3D\'l\'%20x1%3D\'60\'%20x2%3D\'60\'%20y1%3D\'7\'%20y2%3D\'27\'%20stroke%3D\'%236c6c6c\'%20stroke-width%3D\'11\'%20stroke-linecap%3D\'round\'%2F%3E%3C%2Fdefs%3E%3Cg%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(30%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(60%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(90%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(120%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(150%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.37\'%20transform%3D\'rotate(180%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.46\'%20transform%3D\'rotate(210%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.56\'%20transform%3D\'rotate(240%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.66\'%20transform%3D\'rotate(270%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.75\'%20transform%3D\'rotate(300%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.85\'%20transform%3D\'rotate(330%2060%2C60)\'%2F%3E%3C%2Fg%3E%3C%2Fsvg%3E\")\";i:1736;s:1444:\"url(\"data:image/svg+xml;charset=utf-8,%3Csvg%20viewBox%3D\'0%200%20120%20120\'%20xmlns%3D\'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg\'%20xmlns%3Axlink%3D\'http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink\'%3E%3Cdefs%3E%3Cline%20id%3D\'l\'%20x1%3D\'60\'%20x2%3D\'60\'%20y1%3D\'7\'%20y2%3D\'27\'%20stroke%3D\'%23fff\'%20stroke-width%3D\'11\'%20stroke-linecap%3D\'round\'%2F%3E%3C%2Fdefs%3E%3Cg%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(30%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(60%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(90%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(120%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.27\'%20transform%3D\'rotate(150%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.37\'%20transform%3D\'rotate(180%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.46\'%20transform%3D\'rotate(210%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.56\'%20transform%3D\'rotate(240%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.66\'%20transform%3D\'rotate(270%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.75\'%20transform%3D\'rotate(300%2060%2C60)\'%2F%3E%3Cuse%20xlink%3Ahref%3D\'%23l\'%20opacity%3D\'.85\'%20transform%3D\'rotate(330%2060%2C60)\'%2F%3E%3C%2Fg%3E%3C%2Fsvg%3E\")\";}", "no");
INSERT INTO `wp_options` VALUES("479", "theme_mods_healthrehub-child", "a:202:{i:0;b:0;s:18:\"nav_menu_locations\";a:5:{s:4:\"main\";i:53;s:6:\"footer\";i:52;s:6:\"social\";i:54;s:3:\"top\";i:61;s:14:\"primary-mobile\";i:65;}s:12:\"show_tagline\";b:0;s:16:\"totop_visibility\";b:1;s:14:\"page_preloader\";b:1;s:16:\"header_logo_type\";s:5:\"image\";s:15:\"header_logo_url\";s:72:\"https://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:22:\"retina_header_logo_url\";s:72:\"https://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:23:\"header_logo_font_family\";s:19:\"Poppins, sans-serif\";s:22:\"header_logo_font_style\";s:6:\"normal\";s:23:\"header_logo_font_weight\";s:3:\"700\";s:21:\"header_logo_font_size\";s:2:\"50\";s:25:\"header_logo_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_visibillity\";b:1;s:29:\"breadcrumbs_front_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:0;s:21:\"breadcrumbs_path_type\";s:4:\"full\";s:19:\"header_social_links\";b:0;s:19:\"footer_social_links\";b:0;s:23:\"blog_post_share_buttons\";b:0;s:25:\"single_post_share_buttons\";b:1;s:21:\"header_container_type\";s:9:\"fullwidth\";s:22:\"content_container_type\";s:5:\"boxed\";s:21:\"footer_container_type\";s:9:\"fullwidth\";s:15:\"container_width\";i:1788;s:13:\"sidebar_width\";s:3:\"1/3\";s:22:\"regular_accent_color_1\";s:7:\"#4c5461\";s:22:\"regular_accent_color_2\";s:7:\"#4c5461\";s:22:\"regular_accent_color_3\";s:7:\"#9fbedd\";s:22:\"regular_accent_color_4\";s:7:\"#9fbedd\";s:22:\"regular_accent_color_5\";s:7:\"#4c5461\";s:22:\"regular_accent_color_6\";s:7:\"#232c3a\";s:19:\"regular_input_color\";s:7:\"#f5f5f5\";s:18:\"regular_text_color\";s:7:\"#959595\";s:17:\"footer_text_color\";s:7:\"#ffffff\";s:18:\"regular_link_color\";s:7:\"#4c5461\";s:24:\"regular_link_hover_color\";s:7:\"#9fbedd\";s:16:\"regular_h1_color\";s:7:\"#4c5461\";s:16:\"regular_h2_color\";s:7:\"#4c5461\";s:16:\"regular_h3_color\";s:7:\"#4c5461\";s:16:\"regular_h4_color\";s:7:\"#4c5461\";s:16:\"regular_h5_color\";s:7:\"#9fbedd\";s:16:\"regular_h6_color\";s:7:\"#4c5461\";s:21:\"invert_accent_color_1\";s:4:\"#fff\";s:21:\"invert_accent_color_2\";s:7:\"#fdfdfd\";s:21:\"invert_accent_color_3\";s:7:\"#fefefe\";s:17:\"invert_text_color\";s:4:\"#fff\";s:17:\"invert_link_color\";s:4:\"#fff\";s:23:\"invert_link_hover_color\";s:7:\"#4c5461\";s:15:\"invert_h1_color\";s:4:\"#fff\";s:15:\"invert_h2_color\";s:4:\"#fff\";s:15:\"invert_h3_color\";s:4:\"#fff\";s:15:\"invert_h4_color\";s:4:\"#fff\";s:15:\"invert_h5_color\";s:4:\"#fff\";s:15:\"invert_h6_color\";s:4:\"#fff\";s:16:\"gradient_color_1\";s:7:\"#4c5461\";s:16:\"gradient_color_2\";s:7:\"#9fbedd\";s:16:\"body_font_family\";s:19:\"Poppins, sans-serif\";s:15:\"body_font_style\";s:6:\"normal\";s:16:\"body_font_weight\";s:3:\"400\";s:14:\"body_font_size\";s:2:\"18\";s:16:\"body_line_height\";s:5:\"1.667\";s:19:\"body_letter_spacing\";s:1:\"0\";s:18:\"body_character_set\";s:5:\"latin\";s:15:\"body_text_align\";s:4:\"left\";s:14:\"h1_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h1_font_style\";s:6:\"normal\";s:14:\"h1_font_weight\";s:3:\"100\";s:12:\"h1_font_size\";s:2:\"44\";s:14:\"h1_line_height\";s:3:\"1.1\";s:17:\"h1_letter_spacing\";s:1:\"0\";s:16:\"h1_character_set\";s:5:\"latin\";s:13:\"h1_text_align\";s:7:\"inherit\";s:14:\"h2_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h2_font_style\";s:6:\"normal\";s:14:\"h2_font_weight\";s:3:\"100\";s:12:\"h2_font_size\";s:2:\"30\";s:14:\"h2_line_height\";s:3:\"1.1\";s:17:\"h2_letter_spacing\";s:1:\"0\";s:16:\"h2_character_set\";s:5:\"latin\";s:13:\"h2_text_align\";s:7:\"inherit\";s:14:\"h3_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h3_font_style\";s:6:\"normal\";s:14:\"h3_font_weight\";s:3:\"500\";s:12:\"h3_font_size\";s:2:\"30\";s:14:\"h3_line_height\";s:3:\"1.2\";s:17:\"h3_letter_spacing\";s:1:\"0\";s:16:\"h3_character_set\";s:5:\"latin\";s:13:\"h3_text_align\";s:7:\"inherit\";s:14:\"h4_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h4_font_style\";s:6:\"normal\";s:14:\"h4_font_weight\";s:3:\"500\";s:12:\"h4_font_size\";s:2:\"26\";s:14:\"h4_line_height\";s:3:\"1.3\";s:17:\"h4_letter_spacing\";s:1:\"0\";s:16:\"h4_character_set\";s:5:\"latin\";s:13:\"h4_text_align\";s:7:\"inherit\";s:14:\"h5_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h5_font_style\";s:6:\"normal\";s:14:\"h5_font_weight\";s:3:\"500\";s:12:\"h5_font_size\";s:2:\"20\";s:14:\"h5_line_height\";s:3:\"1.4\";s:17:\"h5_letter_spacing\";s:1:\"0\";s:16:\"h5_character_set\";s:5:\"latin\";s:13:\"h5_text_align\";s:7:\"inherit\";s:14:\"h6_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h6_font_style\";s:6:\"normal\";s:14:\"h6_font_weight\";s:3:\"300\";s:12:\"h6_font_size\";s:2:\"18\";s:14:\"h6_line_height\";s:3:\"1.4\";s:17:\"h6_letter_spacing\";s:1:\"0\";s:16:\"h6_character_set\";s:5:\"latin\";s:13:\"h6_text_align\";s:7:\"inherit\";s:21:\"main_menu_font_family\";s:19:\"Poppins, sans-serif\";s:20:\"main_menu_font_style\";s:6:\"normal\";s:21:\"main_menu_font_weight\";s:3:\"500\";s:19:\"main_menu_font_size\";s:2:\"16\";s:21:\"main_menu_line_height\";s:3:\"1.4\";s:24:\"main_menu_letter_spacing\";s:1:\"0\";s:23:\"main_menu_character_set\";s:5:\"latin\";s:18:\"button_font_family\";s:19:\"Poppins, sans-serif\";s:18:\"button_font_weight\";s:3:\"500\";s:20:\"button_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_font_family\";s:19:\"Poppins, sans-serif\";s:22:\"breadcrumbs_font_style\";s:6:\"normal\";s:23:\"breadcrumbs_font_weight\";s:3:\"600\";s:21:\"breadcrumbs_font_size\";s:2:\"14\";s:23:\"breadcrumbs_line_height\";s:3:\"1.5\";s:26:\"breadcrumbs_letter_spacing\";s:1:\"0\";s:25:\"breadcrumbs_character_set\";s:5:\"latin\";s:21:\"top_header_right_text\";s:0:\"\";s:18:\"header_layout_type\";s:7:\"minimal\";s:29:\"header_invert_textcolorscheme\";b:0;s:15:\"header_bg_color\";s:7:\"#ffffff\";s:15:\"header_bg_image\";N;s:16:\"header_bg_repeat\";s:6:\"repeat\";s:20:\"header_bg_position_x\";s:6:\"center\";s:20:\"header_bg_attachment\";s:6:\"scroll\";s:14:\"top_panel_text\";s:614:\"<div class=\\\"info-block\\\"><a class=\\\"top-panel-a\\\" href=\\\"mailto:WestchesterStairlift@gmail.com\\\"> <i class=\\\"material-icons\\\">email</i> WestchesterStairlift@gmail.com</a></div><div class=\\\"info-block\\\"><a class=\\\"top-panel-a\\\" href=\\\"tel:9147095438\\\"><i class=\\\"material-icons\\\">call</i>914-709-5438 (LIFT)</a></div>\n<div class=\\\"info-block-mobile\\\"><a class=\\\"top-panel-a\\\" href=\\\"mailto:WestchesterStairlift@gmail.com\\\"> <i class=\\\"material-icons\\\">email</i>Email Us</a></div><div class=\\\"info-block-mobile\\\"><a class=\\\"top-panel-a\\\" href=\\\"tel:9147095438\\\"><i class=\\\"material-icons\\\">call</i>Call Us</a></div>\";s:16:\"top_panel_search\";b:0;s:12:\"top_panel_bg\";s:7:\"#4c5461\";s:18:\"header_menu_sticky\";b:1;s:22:\"header_menu_attributes\";b:1;s:22:\"title_attributes_color\";s:7:\"#8f9399\";s:16:\"more_button_type\";s:4:\"text\";s:16:\"more_button_text\";s:4:\"more\";s:16:\"more_button_icon\";N;s:21:\"more_button_image_url\";s:0:\"\";s:28:\"retina_more_button_image_url\";N;s:16:\"sidebar_position\";s:17:\"one-right-sidebar\";s:17:\"mailchimp_api_key\";N;s:17:\"mailchimp_list_id\";N;s:10:\"ads_header\";s:0:\"\";s:20:\"ads_home_before_loop\";s:0:\"\";s:23:\"ads_post_before_content\";s:0:\"\";s:24:\"ads_post_before_comments\";s:0:\"\";s:15:\"footer_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:16:\"footer_copyright\";s:55:\"%%year%% © Westchester StairLift. All rights reserved.\";s:29:\"footer_widget_area_visibility\";b:0;s:21:\"footer_widget_columns\";s:1:\"4\";s:18:\"footer_layout_type\";s:8:\"centered\";s:17:\"footer_widgets_bg\";s:7:\"#4c5461\";s:9:\"footer_bg\";s:7:\"#4c5461\";s:16:\"blog_layout_type\";s:7:\"default\";s:16:\"blog_sticky_type\";s:4:\"icon\";s:16:\"blog_sticky_icon\";s:9:\"fa-star-o\";s:17:\"blog_sticky_label\";s:8:\"Featured\";s:18:\"blog_posts_content\";s:7:\"excerpt\";s:19:\"blog_featured_image\";s:9:\"fullwidth\";s:19:\"blog_read_more_text\";s:9:\"Read more\";s:16:\"blog_post_author\";b:1;s:22:\"blog_post_publish_date\";b:1;s:20:\"blog_post_categories\";b:1;s:14:\"blog_post_tags\";b:1;s:18:\"blog_post_comments\";b:1;s:18:\"single_post_author\";b:1;s:24:\"single_post_publish_date\";b:1;s:22:\"single_post_categories\";b:1;s:16:\"single_post_tags\";b:1;s:20:\"single_post_comments\";b:1;s:19:\"single_author_block\";b:1;s:21:\"related_posts_visible\";b:0;s:25:\"related_posts_block_title\";s:13:\"Related Posts\";s:19:\"related_posts_count\";s:1:\"4\";s:18:\"related_posts_grid\";s:1:\"4\";s:19:\"related_posts_title\";b:1;s:26:\"related_posts_title_length\";s:1:\"5\";s:19:\"related_posts_image\";b:1;s:21:\"related_posts_content\";s:12:\"post_excerpt\";s:28:\"related_posts_content_length\";s:2:\"10\";s:24:\"related_posts_categories\";b:1;s:18:\"related_posts_tags\";b:1;s:20:\"related_posts_author\";b:1;s:26:\"related_posts_publish_date\";b:1;s:27:\"related_posts_comment_count\";b:1;s:21:\"tm_pb_layouts_updated\";s:3:\"yes\";s:39:\"tm_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"tm_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"tm_pb_predefined_layouts_version_2\";s:2:\"on\";s:18:\"custom_css_post_id\";i:1958;s:21:\"tm_pb_replace_content\";s:2:\"on\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1540970890;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:29:\"after-content-full-width-area\";a:0:{}s:11:\"footer-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("480", "chld_thm_cfg_options_configvars", "a:38:{s:8:\"addl_css\";a:7:{i:0;s:31:\"assets/css/font-awesome.min.css\";i:1;s:30:\"assets/css/material-design.css\";i:2;s:24:\"assets/css/fl-glypho.css\";i:3;s:23:\"assets/css/fontello.css\";i:4;s:33:\"assets/css/magnific-popup.min.css\";i:5;s:33:\"assets/css/material-icons.min.css\";i:6;s:25:\"assets/css/swiper.min.css\";}s:8:\"forcedep\";a:1:{s:9:\"fl-glypho\";i:1;}s:8:\"cssunreg\";N;s:9:\"csswphead\";N;s:10:\"cssnotheme\";N;s:7:\"reorder\";N;s:10:\"parnt_deps\";a:7:{i:0;s:12:\"font-awesome\";i:1;s:15:\"material-design\";i:2;s:9:\"fl-glypho\";i:3;s:8:\"fontello\";i:4;s:14:\"magnific-popup\";i:5;s:14:\"material-icons\";i:6;s:13:\"jquery-swiper\";}s:10:\"child_deps\";a:1:{i:0;s:23:\"healthrehub-theme-style\";}s:9:\"hasstyles\";i:1;s:11:\"parntloaded\";N;s:11:\"childloaded\";N;s:11:\"ignoreparnt\";N;s:9:\"qpriority\";s:2:\"15\";s:7:\"enqueue\";s:7:\"enqueue\";s:8:\"handling\";s:7:\"primary\";s:9:\"templates\";a:87:{i:0;s:10:\"header.php\";i:1;s:11:\"sidebar.php\";i:2;s:25:\"base-single-tm_pg_set.php\";i:3;s:10:\"footer.php\";i:4;s:8:\"page.php\";i:5;s:8:\"base.php\";i:6;s:27:\"base-single-tm_pg_album.php\";i:7;s:20:\"single-tm_pg_set.php\";i:8;s:7:\"404.php\";i:9;s:9:\"index.php\";i:10;s:22:\"single-tm_pg_album.php\";i:11;s:11:\"archive.php\";i:12;s:10:\"single.php\";i:13;s:14:\"searchform.php\";i:14;s:12:\"base-404.php\";i:15;s:10:\"search.php\";i:16;s:12:\"comments.php\";i:17;s:37:\"template-parts/content-pagination.php\";i:18;s:33:\"template-parts/content-status.php\";i:19;s:31:\"template-parts/content-page.php\";i:20;s:40:\"template-parts/content-related-posts.php\";i:21;s:32:\"template-parts/content-image.php\";i:22;s:32:\"template-parts/content-video.php\";i:23;s:31:\"template-parts/content-none.php\";i:24;s:38:\"template-parts/content-single-link.php\";i:25;s:37:\"template-parts/content-author-bio.php\";i:26;s:26:\"template-parts/comment.php\";i:27;s:26:\"template-parts/content.php\";i:28;s:33:\"template-parts/content-single.php\";i:29;s:32:\"template-parts/content-audio.php\";i:30;s:32:\"template-parts/content-quote.php\";i:31;s:34:\"template-parts/content-gallery.php\";i:32;s:31:\"template-parts/content-link.php\";i:33;s:33:\"template-parts/content-search.php\";i:34;s:41:\"template-parts/header/layout-centered.php\";i:35;s:44:\"template-parts/header/layout-transparent.php\";i:36;s:35:\"template-parts/header/top-panel.php\";i:37;s:32:\"template-parts/header/layout.php\";i:38;s:40:\"template-parts/header/layout-minimal.php\";i:39;s:41:\"template-parts/footer/layout-centered.php\";i:40;s:32:\"template-parts/footer/layout.php\";i:41;s:40:\"template-parts/footer/layout-minimal.php\";i:42;s:26:\"builder/templates/meta.php\";i:43;s:33:\"builder/templates/testimonial.php\";i:44;s:27:\"builder/templates/blurb.php\";i:45;s:30:\"builder/templates/link_box.php\";i:46;s:31:\"builder/templates/blog/more.php\";i:47;s:31:\"builder/templates/blog/meta.php\";i:48;s:43:\"builder/templates/blog/formats/standard.php\";i:49;s:35:\"inc/widgets/banner/views/banner.php\";i:50;s:46:\"inc/widgets/about-author/view/about-author.php\";i:51;s:33:\"inc/widgets/about/views/about.php\";i:52;s:51:\"inc/widgets/subscribe-follow/view/subcribe-view.php\";i:53;s:49:\"inc/widgets/subscribe-follow/view/follow-view.php\";i:54;s:60:\"inc/widgets/subscribe-follow/view/background-styles-view.php\";i:55;s:31:\"tm_pg_frontend/grid/filters.php\";i:56;s:33:\"tm_pg_frontend/grid/preloader.php\";i:57;s:34:\"tm_pg_frontend/grid/pagination.php\";i:58;s:47:\"tm_pg_frontend/grid/content/justify-content.php\";i:59;s:47:\"tm_pg_frontend/grid/content/masonry-content.php\";i:60;s:44:\"tm_pg_frontend/grid/content/grid-content.php\";i:61;s:47:\"tm_pg_frontend/grid/items/masonry/more-item.php\";i:62;s:44:\"tm_pg_frontend/grid/items/grid/more-item.php\";i:63;s:47:\"tm_pg_frontend/grid/items/justify/more-item.php\";i:64;s:26:\"cherry-framework/setup.php\";i:65;s:90:\"cherry-framework/modules/cherry-ui-elements/inc/ui-elements/ui-button/view/button-view.php\";i:66;s:71:\"cherry-framework/modules/cherry-interface-builder/inc/views/section.php\";i:67;s:88:\"cherry-framework/modules/cherry-interface-builder/inc/views/component-tab-horizontal.php\";i:68;s:71:\"cherry-framework/modules/cherry-interface-builder/inc/views/control.php\";i:69;s:82:\"cherry-framework/modules/cherry-interface-builder/inc/views/component-repeater.php\";i:70;s:72:\"cherry-framework/modules/cherry-interface-builder/inc/views/settings.php\";i:71;s:68:\"cherry-framework/modules/cherry-interface-builder/inc/views/form.php\";i:72;s:85:\"cherry-framework/modules/cherry-interface-builder/inc/views/toggle-children-title.php\";i:73;s:86:\"cherry-framework/modules/cherry-interface-builder/inc/views/component-tab-vertical.php\";i:74;s:80:\"cherry-framework/modules/cherry-interface-builder/inc/views/component-toggle.php\";i:75;s:82:\"cherry-framework/modules/cherry-interface-builder/inc/views/tab-children-title.php\";i:76;s:68:\"cherry-framework/modules/cherry-interface-builder/inc/views/html.php\";i:77;s:83:\"cherry-framework/modules/cherry-interface-builder/inc/views/component-accordion.php\";i:78;s:87:\"cherry-framework/modules/cherry-interface-builder/inc/views/settings-children-title.php\";i:79;s:81:\"cherry-framework/modules/cherry5-insert-shortcode/inc/views/shortcode-options.php\";i:80;s:88:\"cherry-framework/modules/cherry5-insert-shortcode/inc/views/shortcode-has-not-option.php\";i:81;s:86:\"cherry-framework/modules/cherry5-insert-shortcode/inc/views/shortcode-content-area.php\";i:82;s:87:\"cherry-framework/modules/cherry5-insert-shortcode/inc/views/insert-shortcode-pop-up.php\";i:83;s:35:\"cherry-services/single-services.php\";i:84;s:36:\"cherry-services/archive-services.php\";i:85;s:36:\"cherry-team-members/archive-team.php\";i:86;s:35:\"cherry-team-members/single-team.php\";}s:7:\"max_sel\";N;s:7:\"imports\";a:2:{s:5:\"child\";a:0:{}s:5:\"parnt\";a:0:{}}s:13:\"child_version\";s:5:\"1.0.0\";s:12:\"child_author\";s:16:\"Template Monster\";s:10:\"child_name\";s:20:\"HealthRehub Child 02\";s:14:\"child_themeuri\";s:51:\"http://www.templatemonster.com/wordpress-themes.php\";s:15:\"child_authoruri\";s:31:\"http://www.templatemonster.com/\";s:11:\"child_descr\";s:23:\"Private Medical clinic.\";s:10:\"child_tags\";s:230:\"grid-layout,one-column,two-columns,three-columns,left-sidebar,right-sidebar,footer-widgets,custom-background,custom-colors,custom-menu,featured-images,post-formats,sticky-post,theme-options,threaded-comments,translation-ready,blog\";s:5:\"parnt\";s:11:\"healthrehub\";s:5:\"child\";s:19:\"healthrehub-child02\";s:10:\"configtype\";s:5:\"theme\";s:6:\"valkey\";i:1736;s:7:\"rulekey\";i:162;s:5:\"qskey\";i:3045;s:6:\"selkey\";i:2736;s:8:\"querykey\";i:23;s:8:\"tokenkey\";N;s:6:\"recent\";N;s:9:\"converted\";i:1;s:5:\"fsize\";i:524;s:7:\"version\";s:7:\"2.3.0.4\";}", "no");
INSERT INTO `wp_options` VALUES("481", "chld_thm_cfg_options_dict_qs", "a:3045:{i:1;s:3:\"1:1\";i:2;s:3:\"1:2\";i:3;s:3:\"1:3\";i:4;s:3:\"1:4\";i:5;s:3:\"1:5\";i:6;s:3:\"1:6\";i:7;s:3:\"1:7\";i:8;s:3:\"1:8\";i:9;s:3:\"1:9\";i:10;s:4:\"1:10\";i:11;s:4:\"1:11\";i:12;s:4:\"1:12\";i:13;s:4:\"1:13\";i:14;s:4:\"1:14\";i:15;s:4:\"1:15\";i:16;s:4:\"1:16\";i:17;s:4:\"1:17\";i:18;s:4:\"1:18\";i:19;s:4:\"1:19\";i:20;s:4:\"1:20\";i:21;s:4:\"1:21\";i:22;s:4:\"1:22\";i:23;s:4:\"1:23\";i:24;s:4:\"1:24\";i:25;s:4:\"1:25\";i:26;s:4:\"1:26\";i:27;s:4:\"1:27\";i:28;s:4:\"1:28\";i:29;s:4:\"1:29\";i:30;s:4:\"1:30\";i:31;s:4:\"1:31\";i:32;s:4:\"1:32\";i:33;s:4:\"1:33\";i:34;s:4:\"1:34\";i:35;s:4:\"1:35\";i:36;s:4:\"1:36\";i:37;s:4:\"1:37\";i:38;s:4:\"1:38\";i:39;s:4:\"1:39\";i:40;s:4:\"1:40\";i:41;s:4:\"1:41\";i:42;s:4:\"1:42\";i:43;s:4:\"1:43\";i:44;s:4:\"1:44\";i:45;s:4:\"1:45\";i:46;s:4:\"1:46\";i:47;s:4:\"1:47\";i:48;s:4:\"1:48\";i:49;s:4:\"1:49\";i:50;s:4:\"1:50\";i:51;s:4:\"1:51\";i:52;s:4:\"1:52\";i:53;s:4:\"1:53\";i:54;s:4:\"1:54\";i:55;s:4:\"1:55\";i:56;s:4:\"1:56\";i:57;s:4:\"1:57\";i:58;s:4:\"1:58\";i:59;s:4:\"1:59\";i:60;s:4:\"1:60\";i:61;s:4:\"1:61\";i:62;s:4:\"1:62\";i:63;s:4:\"1:63\";i:64;s:4:\"1:64\";i:65;s:4:\"1:65\";i:66;s:4:\"1:66\";i:67;s:4:\"1:67\";i:68;s:4:\"1:68\";i:69;s:4:\"1:69\";i:70;s:4:\"1:70\";i:71;s:4:\"1:71\";i:72;s:4:\"1:72\";i:73;s:4:\"1:73\";i:74;s:4:\"1:74\";i:75;s:4:\"1:75\";i:76;s:4:\"1:76\";i:77;s:4:\"1:77\";i:78;s:4:\"1:78\";i:79;s:4:\"1:79\";i:80;s:4:\"1:80\";i:81;s:4:\"1:81\";i:82;s:4:\"1:82\";i:83;s:4:\"1:83\";i:84;s:4:\"1:84\";i:85;s:4:\"1:85\";i:86;s:4:\"1:86\";i:87;s:4:\"1:87\";i:88;s:4:\"1:88\";i:89;s:4:\"1:89\";i:90;s:4:\"1:90\";i:91;s:4:\"1:91\";i:92;s:4:\"1:92\";i:93;s:4:\"1:93\";i:94;s:4:\"1:94\";i:95;s:4:\"1:95\";i:96;s:4:\"1:96\";i:97;s:4:\"1:97\";i:98;s:4:\"1:98\";i:99;s:4:\"1:99\";i:100;s:5:\"1:100\";i:101;s:5:\"1:101\";i:102;s:5:\"1:102\";i:103;s:5:\"1:103\";i:104;s:5:\"1:104\";i:105;s:5:\"1:105\";i:106;s:5:\"1:106\";i:107;s:5:\"1:107\";i:108;s:5:\"1:108\";i:109;s:5:\"1:109\";i:110;s:5:\"1:110\";i:111;s:5:\"1:111\";i:112;s:5:\"1:112\";i:113;s:5:\"1:113\";i:114;s:5:\"1:114\";i:115;s:5:\"1:115\";i:116;s:5:\"1:116\";i:117;s:5:\"1:117\";i:118;s:5:\"1:118\";i:119;s:5:\"1:119\";i:120;s:5:\"1:120\";i:121;s:5:\"1:121\";i:122;s:5:\"1:122\";i:123;s:5:\"1:123\";i:124;s:5:\"1:124\";i:125;s:5:\"1:125\";i:126;s:5:\"1:126\";i:127;s:5:\"1:127\";i:128;s:5:\"1:128\";i:129;s:5:\"1:129\";i:130;s:5:\"1:130\";i:131;s:5:\"1:131\";i:132;s:5:\"1:132\";i:133;s:5:\"1:133\";i:134;s:5:\"1:134\";i:135;s:5:\"1:135\";i:136;s:5:\"1:136\";i:137;s:5:\"1:137\";i:138;s:5:\"1:138\";i:139;s:5:\"1:139\";i:140;s:5:\"1:140\";i:141;s:5:\"1:141\";i:142;s:5:\"1:142\";i:143;s:5:\"1:143\";i:144;s:5:\"1:144\";i:145;s:5:\"1:145\";i:146;s:5:\"1:146\";i:147;s:5:\"1:147\";i:148;s:5:\"1:148\";i:149;s:5:\"1:149\";i:150;s:5:\"1:150\";i:151;s:5:\"1:151\";i:152;s:5:\"1:152\";i:153;s:5:\"1:153\";i:154;s:5:\"1:154\";i:155;s:5:\"1:155\";i:156;s:5:\"1:156\";i:157;s:5:\"1:157\";i:158;s:5:\"1:158\";i:159;s:5:\"1:159\";i:160;s:5:\"1:160\";i:161;s:5:\"1:161\";i:162;s:5:\"1:162\";i:163;s:5:\"1:163\";i:164;s:5:\"1:164\";i:165;s:5:\"1:165\";i:166;s:5:\"1:166\";i:167;s:5:\"1:167\";i:168;s:5:\"1:168\";i:169;s:5:\"1:169\";i:170;s:5:\"1:170\";i:171;s:5:\"1:171\";i:172;s:5:\"1:172\";i:173;s:5:\"1:173\";i:174;s:5:\"1:174\";i:175;s:5:\"1:175\";i:176;s:5:\"1:176\";i:177;s:5:\"1:177\";i:178;s:5:\"1:178\";i:179;s:5:\"1:179\";i:180;s:5:\"1:180\";i:181;s:5:\"1:181\";i:182;s:5:\"1:182\";i:183;s:5:\"1:183\";i:184;s:5:\"1:184\";i:185;s:5:\"1:185\";i:186;s:5:\"1:186\";i:187;s:5:\"1:187\";i:188;s:5:\"1:188\";i:189;s:5:\"1:189\";i:190;s:5:\"1:190\";i:191;s:5:\"1:191\";i:192;s:5:\"1:192\";i:193;s:5:\"1:193\";i:194;s:5:\"1:194\";i:195;s:5:\"1:195\";i:196;s:5:\"1:196\";i:197;s:5:\"1:197\";i:198;s:5:\"1:198\";i:199;s:5:\"1:199\";i:200;s:5:\"1:200\";i:201;s:5:\"1:201\";i:202;s:5:\"1:202\";i:203;s:5:\"1:203\";i:204;s:5:\"1:204\";i:205;s:5:\"1:205\";i:206;s:5:\"1:206\";i:207;s:5:\"1:207\";i:208;s:5:\"1:208\";i:209;s:5:\"2:209\";i:210;s:5:\"2:210\";i:211;s:5:\"2:211\";i:212;s:5:\"2:212\";i:213;s:5:\"2:213\";i:214;s:5:\"2:214\";i:215;s:5:\"2:215\";i:216;s:5:\"2:216\";i:217;s:3:\"2:9\";i:218;s:5:\"2:217\";i:219;s:4:\"2:10\";i:220;s:4:\"2:12\";i:221;s:5:\"2:218\";i:222;s:4:\"2:13\";i:223;s:5:\"2:219\";i:224;s:5:\"2:220\";i:225;s:5:\"2:221\";i:226;s:5:\"2:222\";i:227;s:5:\"2:223\";i:228;s:5:\"2:224\";i:229;s:5:\"2:225\";i:230;s:5:\"2:226\";i:231;s:5:\"2:227\";i:232;s:5:\"2:228\";i:233;s:5:\"2:229\";i:234;s:5:\"2:230\";i:235;s:5:\"2:231\";i:236;s:5:\"2:232\";i:237;s:5:\"2:233\";i:238;s:5:\"2:234\";i:239;s:4:\"2:31\";i:240;s:5:\"2:235\";i:241;s:4:\"2:32\";i:242;s:4:\"2:33\";i:243;s:5:\"2:236\";i:244;s:5:\"2:237\";i:245;s:5:\"2:238\";i:246;s:4:\"2:34\";i:247;s:5:\"2:239\";i:248;s:5:\"2:240\";i:249;s:4:\"2:43\";i:250;s:5:\"2:241\";i:251;s:5:\"2:242\";i:252;s:5:\"2:243\";i:253;s:5:\"2:244\";i:254;s:5:\"2:245\";i:255;s:5:\"2:246\";i:256;s:5:\"2:247\";i:257;s:5:\"2:248\";i:258;s:5:\"2:249\";i:259;s:5:\"2:250\";i:260;s:5:\"2:251\";i:261;s:5:\"2:252\";i:262;s:5:\"2:253\";i:263;s:5:\"2:254\";i:264;s:5:\"2:255\";i:265;s:5:\"2:256\";i:266;s:5:\"2:257\";i:267;s:5:\"2:258\";i:268;s:5:\"2:259\";i:269;s:5:\"2:260\";i:270;s:5:\"2:261\";i:271;s:5:\"2:262\";i:272;s:5:\"2:263\";i:273;s:5:\"2:264\";i:274;s:5:\"2:265\";i:275;s:5:\"2:266\";i:276;s:5:\"2:267\";i:277;s:5:\"2:268\";i:278;s:5:\"2:269\";i:279;s:5:\"2:270\";i:280;s:5:\"2:271\";i:281;s:5:\"2:272\";i:282;s:5:\"2:273\";i:283;s:5:\"2:274\";i:284;s:5:\"2:275\";i:285;s:5:\"2:276\";i:286;s:5:\"2:277\";i:287;s:5:\"2:278\";i:288;s:5:\"2:279\";i:289;s:5:\"2:280\";i:290;s:5:\"2:281\";i:291;s:5:\"2:282\";i:292;s:5:\"2:283\";i:293;s:5:\"2:284\";i:294;s:5:\"2:285\";i:295;s:5:\"2:286\";i:296;s:4:\"2:68\";i:297;s:5:\"2:287\";i:298;s:4:\"2:71\";i:299;s:5:\"2:288\";i:300;s:4:\"2:74\";i:301;s:5:\"2:289\";i:302;s:5:\"2:290\";i:303;s:5:\"2:291\";i:304;s:5:\"2:292\";i:305;s:5:\"2:293\";i:306;s:5:\"2:294\";i:307;s:5:\"2:295\";i:308;s:5:\"2:296\";i:309;s:5:\"2:297\";i:310;s:5:\"2:298\";i:311;s:5:\"2:299\";i:312;s:5:\"2:300\";i:313;s:5:\"2:301\";i:314;s:5:\"2:302\";i:315;s:5:\"2:303\";i:316;s:5:\"2:304\";i:317;s:5:\"2:305\";i:318;s:5:\"2:306\";i:319;s:5:\"2:307\";i:320;s:5:\"2:308\";i:321;s:5:\"2:309\";i:322;s:5:\"2:310\";i:323;s:5:\"2:311\";i:324;s:5:\"2:312\";i:325;s:5:\"2:313\";i:326;s:5:\"2:314\";i:327;s:5:\"2:315\";i:328;s:5:\"2:316\";i:329;s:5:\"2:317\";i:330;s:5:\"2:318\";i:331;s:5:\"2:319\";i:332;s:5:\"2:320\";i:333;s:5:\"2:321\";i:334;s:5:\"2:322\";i:335;s:5:\"2:323\";i:336;s:5:\"2:324\";i:337;s:5:\"2:325\";i:338;s:5:\"2:326\";i:339;s:5:\"2:327\";i:340;s:5:\"2:328\";i:341;s:5:\"2:329\";i:342;s:5:\"2:330\";i:343;s:5:\"2:331\";i:344;s:5:\"2:332\";i:345;s:5:\"2:333\";i:346;s:5:\"2:334\";i:347;s:5:\"2:335\";i:348;s:5:\"2:336\";i:349;s:5:\"2:337\";i:350;s:5:\"2:338\";i:351;s:5:\"2:339\";i:352;s:5:\"2:340\";i:353;s:5:\"2:341\";i:354;s:5:\"2:342\";i:355;s:5:\"2:343\";i:356;s:5:\"2:344\";i:357;s:5:\"2:345\";i:358;s:5:\"2:346\";i:359;s:5:\"2:347\";i:360;s:5:\"2:348\";i:361;s:5:\"2:349\";i:362;s:5:\"2:350\";i:363;s:5:\"2:351\";i:364;s:5:\"2:352\";i:365;s:5:\"2:353\";i:366;s:5:\"2:354\";i:367;s:5:\"2:355\";i:368;s:5:\"2:356\";i:369;s:5:\"2:357\";i:370;s:5:\"2:205\";i:371;s:5:\"2:206\";i:372;s:5:\"2:207\";i:373;s:5:\"2:208\";i:374;s:3:\"3:2\";i:375;s:5:\"3:358\";i:376;s:5:\"3:359\";i:377;s:5:\"3:360\";i:378;s:5:\"3:212\";i:379;s:5:\"3:213\";i:380;s:3:\"3:9\";i:381;s:5:\"3:217\";i:382;s:5:\"3:361\";i:383;s:4:\"3:10\";i:384;s:5:\"3:362\";i:385;s:4:\"3:12\";i:386;s:5:\"3:218\";i:387;s:5:\"3:363\";i:388;s:4:\"3:13\";i:389;s:5:\"3:364\";i:390;s:5:\"3:365\";i:391;s:5:\"3:366\";i:392;s:5:\"3:367\";i:393;s:4:\"3:20\";i:394;s:5:\"3:368\";i:395;s:5:\"3:230\";i:396;s:5:\"3:369\";i:397;s:5:\"3:370\";i:398;s:4:\"3:31\";i:399;s:5:\"3:371\";i:400;s:5:\"3:372\";i:401;s:5:\"3:236\";i:402;s:5:\"3:237\";i:403;s:4:\"3:34\";i:404;s:5:\"3:373\";i:405;s:5:\"3:374\";i:406;s:5:\"3:375\";i:407;s:5:\"3:376\";i:408;s:5:\"3:377\";i:409;s:5:\"3:378\";i:410;s:5:\"3:379\";i:411;s:5:\"3:380\";i:412;s:5:\"3:381\";i:413;s:5:\"3:382\";i:414;s:5:\"3:383\";i:415;s:5:\"3:384\";i:416;s:5:\"3:385\";i:417;s:5:\"3:386\";i:418;s:5:\"3:387\";i:419;s:5:\"3:388\";i:420;s:4:\"3:76\";i:421;s:5:\"3:389\";i:422;s:5:\"3:390\";i:423;s:5:\"3:391\";i:424;s:5:\"3:392\";i:425;s:5:\"3:294\";i:426;s:5:\"3:135\";i:427;s:5:\"3:393\";i:428;s:5:\"3:394\";i:429;s:5:\"3:395\";i:430;s:5:\"3:396\";i:431;s:5:\"3:397\";i:432;s:5:\"3:398\";i:433;s:5:\"3:399\";i:434;s:5:\"3:400\";i:435;s:5:\"3:401\";i:436;s:5:\"3:402\";i:437;s:5:\"3:403\";i:438;s:5:\"3:404\";i:439;s:5:\"3:405\";i:440;s:5:\"3:406\";i:441;s:5:\"3:407\";i:442;s:5:\"3:408\";i:443;s:5:\"3:409\";i:444;s:5:\"3:410\";i:445;s:5:\"3:411\";i:446;s:5:\"3:412\";i:447;s:5:\"3:413\";i:448;s:5:\"3:414\";i:449;s:5:\"3:415\";i:450;s:5:\"3:416\";i:451;s:5:\"3:417\";i:452;s:5:\"3:418\";i:453;s:5:\"3:419\";i:454;s:5:\"3:420\";i:455;s:5:\"3:421\";i:456;s:5:\"3:422\";i:457;s:5:\"3:423\";i:458;s:5:\"3:424\";i:459;s:5:\"3:425\";i:460;s:5:\"3:426\";i:461;s:5:\"3:427\";i:462;s:5:\"3:428\";i:463;s:5:\"3:429\";i:464;s:5:\"3:430\";i:465;s:5:\"3:431\";i:466;s:5:\"3:432\";i:467;s:5:\"3:433\";i:468;s:5:\"3:434\";i:469;s:5:\"3:435\";i:470;s:5:\"3:436\";i:471;s:5:\"3:437\";i:472;s:5:\"3:438\";i:473;s:5:\"3:439\";i:474;s:5:\"3:440\";i:475;s:5:\"3:441\";i:476;s:5:\"3:442\";i:477;s:5:\"3:443\";i:478;s:5:\"3:444\";i:479;s:5:\"3:445\";i:480;s:5:\"3:446\";i:481;s:5:\"3:447\";i:482;s:5:\"3:448\";i:483;s:5:\"3:449\";i:484;s:5:\"3:450\";i:485;s:5:\"3:451\";i:486;s:5:\"3:205\";i:487;s:5:\"3:206\";i:488;s:5:\"3:207\";i:489;s:5:\"3:208\";i:490;s:3:\"4:9\";i:491;s:4:\"4:10\";i:492;s:4:\"4:12\";i:493;s:4:\"4:13\";i:494;s:5:\"4:452\";i:495;s:5:\"4:453\";i:496;s:5:\"4:454\";i:497;s:5:\"4:455\";i:498;s:4:\"4:31\";i:499;s:4:\"4:41\";i:500;s:5:\"4:456\";i:501;s:5:\"4:457\";i:502;s:4:\"4:68\";i:503;s:5:\"4:458\";i:504;s:4:\"4:66\";i:505;s:5:\"4:142\";i:506;s:5:\"4:459\";i:507;s:5:\"4:460\";i:508;s:5:\"4:461\";i:509;s:5:\"4:462\";i:510;s:5:\"4:463\";i:511;s:5:\"4:464\";i:512;s:5:\"4:465\";i:513;s:5:\"4:466\";i:514;s:5:\"4:467\";i:515;s:5:\"4:468\";i:516;s:5:\"4:469\";i:517;s:5:\"4:470\";i:518;s:5:\"4:471\";i:519;s:5:\"4:472\";i:520;s:5:\"4:473\";i:521;s:5:\"4:474\";i:522;s:5:\"4:475\";i:523;s:5:\"4:476\";i:524;s:5:\"4:477\";i:525;s:5:\"4:478\";i:526;s:5:\"4:479\";i:527;s:5:\"4:480\";i:528;s:5:\"4:481\";i:529;s:5:\"4:482\";i:530;s:5:\"4:483\";i:531;s:5:\"4:484\";i:532;s:5:\"4:485\";i:533;s:5:\"4:486\";i:534;s:5:\"4:487\";i:535;s:5:\"4:488\";i:536;s:5:\"4:489\";i:537;s:5:\"4:490\";i:538;s:5:\"4:491\";i:539;s:5:\"4:492\";i:540;s:5:\"4:493\";i:541;s:5:\"4:494\";i:542;s:5:\"4:495\";i:543;s:5:\"4:496\";i:544;s:5:\"4:497\";i:545;s:5:\"4:498\";i:546;s:5:\"4:499\";i:547;s:5:\"4:500\";i:548;s:5:\"4:501\";i:549;s:5:\"4:502\";i:550;s:5:\"4:503\";i:551;s:5:\"4:504\";i:552;s:5:\"4:505\";i:553;s:5:\"4:506\";i:554;s:5:\"4:507\";i:555;s:5:\"4:508\";i:556;s:5:\"4:509\";i:557;s:5:\"4:510\";i:558;s:5:\"4:511\";i:559;s:5:\"4:512\";i:560;s:5:\"4:513\";i:561;s:5:\"4:514\";i:562;s:5:\"4:515\";i:563;s:5:\"4:516\";i:564;s:5:\"4:517\";i:565;s:5:\"4:208\";i:566;s:5:\"5:518\";i:567;s:5:\"5:519\";i:568;s:5:\"5:520\";i:569;s:5:\"5:521\";i:570;s:5:\"5:522\";i:571;s:5:\"5:523\";i:572;s:5:\"6:524\";i:573;s:4:\"6:20\";i:574;s:5:\"6:525\";i:575;s:5:\"6:526\";i:576;s:5:\"6:527\";i:577;s:5:\"6:528\";i:578;s:5:\"6:529\";i:579;s:5:\"6:530\";i:580;s:5:\"6:531\";i:581;s:5:\"6:532\";i:582;s:5:\"6:533\";i:583;s:3:\"7:5\";i:584;s:5:\"7:534\";i:585;s:5:\"7:535\";i:586;s:5:\"7:536\";i:587;s:5:\"7:537\";i:588;s:5:\"7:538\";i:589;s:4:\"7:22\";i:590;s:5:\"7:539\";i:591;s:5:\"7:540\";i:592;s:5:\"7:140\";i:593;s:5:\"8:541\";i:594;s:5:\"9:123\";i:595;s:5:\"9:124\";i:596;s:5:\"9:127\";i:597;s:5:\"9:128\";i:598;s:5:\"9:138\";i:599;s:5:\"10:70\";i:600;s:5:\"10:71\";i:601;s:5:\"10:73\";i:602;s:5:\"10:74\";i:603;s:6:\"10:542\";i:604;s:5:\"10:96\";i:605;s:6:\"10:543\";i:606;s:6:\"10:544\";i:607;s:5:\"11:29\";i:608;s:6:\"11:545\";i:609;s:6:\"11:546\";i:610;s:6:\"11:547\";i:611;s:6:\"11:277\";i:612;s:6:\"11:548\";i:613;s:6:\"11:549\";i:614;s:6:\"12:550\";i:615;s:6:\"12:551\";i:616;s:6:\"13:552\";i:617;s:6:\"13:553\";i:618;s:6:\"13:554\";i:619;s:6:\"14:552\";i:620;s:6:\"14:553\";i:621;s:6:\"15:555\";i:622;s:6:\"16:556\";i:623;s:6:\"16:557\";i:624;s:6:\"16:558\";i:625;s:5:\"16:31\";i:626;s:6:\"17:559\";i:627;s:6:\"17:545\";i:628;s:6:\"18:556\";i:629;s:6:\"18:560\";i:630;s:6:\"19:560\";i:631;s:6:\"20:556\";i:632;s:6:\"21:561\";i:633;s:6:\"21:562\";i:634;s:6:\"21:563\";i:635;s:6:\"21:564\";i:636;s:6:\"21:565\";i:637;s:6:\"21:566\";i:638;s:6:\"21:567\";i:639;s:6:\"21:568\";i:640;s:6:\"21:569\";i:641;s:6:\"21:570\";i:642;s:6:\"21:571\";i:643;s:6:\"21:572\";i:644;s:6:\"21:573\";i:645;s:6:\"21:574\";i:646;s:6:\"21:575\";i:647;s:6:\"21:576\";i:648;s:6:\"21:577\";i:649;s:6:\"21:578\";i:650;s:6:\"21:579\";i:651;s:6:\"21:580\";i:652;s:6:\"21:581\";i:653;s:6:\"21:582\";i:654;s:6:\"21:583\";i:655;s:6:\"21:584\";i:656;s:6:\"21:585\";i:657;s:6:\"21:586\";i:658;s:6:\"21:587\";i:659;s:6:\"21:588\";i:660;s:6:\"21:589\";i:661;s:6:\"21:590\";i:662;s:6:\"21:591\";i:663;s:6:\"21:592\";i:664;s:6:\"21:593\";i:665;s:6:\"21:594\";i:666;s:6:\"21:595\";i:667;s:6:\"21:596\";i:668;s:6:\"21:597\";i:669;s:6:\"21:598\";i:670;s:6:\"21:599\";i:671;s:6:\"21:600\";i:672;s:6:\"21:601\";i:673;s:6:\"21:602\";i:674;s:6:\"21:603\";i:675;s:6:\"21:604\";i:676;s:6:\"21:605\";i:677;s:6:\"21:606\";i:678;s:6:\"21:607\";i:679;s:6:\"21:608\";i:680;s:6:\"21:609\";i:681;s:6:\"21:610\";i:682;s:6:\"21:611\";i:683;s:6:\"21:612\";i:684;s:6:\"21:613\";i:685;s:6:\"21:614\";i:686;s:6:\"21:145\";i:687;s:6:\"21:615\";i:688;s:6:\"21:616\";i:689;s:6:\"21:617\";i:690;s:6:\"21:618\";i:691;s:6:\"21:619\";i:692;s:6:\"21:620\";i:693;s:6:\"21:621\";i:694;s:6:\"21:208\";i:695;s:6:\"21:207\";i:696;s:6:\"21:206\";i:697;s:6:\"21:622\";i:698;s:6:\"21:623\";i:699;s:6:\"21:205\";i:700;s:6:\"21:624\";i:701;s:6:\"21:625\";i:702;s:6:\"21:626\";i:703;s:6:\"21:627\";i:704;s:6:\"21:628\";i:705;s:6:\"21:629\";i:706;s:6:\"21:630\";i:707;s:6:\"21:631\";i:708;s:6:\"21:632\";i:709;s:6:\"21:633\";i:710;s:6:\"21:634\";i:711;s:6:\"21:635\";i:712;s:6:\"21:636\";i:713;s:6:\"21:637\";i:714;s:6:\"21:638\";i:715;s:6:\"21:639\";i:716;s:6:\"21:640\";i:717;s:6:\"21:641\";i:718;s:6:\"21:642\";i:719;s:6:\"21:643\";i:720;s:6:\"21:644\";i:721;s:6:\"21:645\";i:722;s:6:\"21:646\";i:723;s:6:\"21:647\";i:724;s:6:\"21:648\";i:725;s:6:\"21:649\";i:726;s:6:\"21:650\";i:727;s:6:\"21:651\";i:728;s:6:\"21:652\";i:729;s:6:\"21:653\";i:730;s:6:\"21:654\";i:731;s:6:\"21:655\";i:732;s:6:\"21:656\";i:733;s:6:\"21:657\";i:734;s:6:\"21:658\";i:735;s:6:\"21:659\";i:736;s:6:\"21:660\";i:737;s:6:\"21:661\";i:738;s:6:\"21:662\";i:739;s:6:\"21:663\";i:740;s:6:\"21:664\";i:741;s:6:\"21:665\";i:742;s:6:\"21:666\";i:743;s:6:\"21:667\";i:744;s:6:\"21:668\";i:745;s:6:\"21:669\";i:746;s:6:\"21:670\";i:747;s:6:\"21:671\";i:748;s:6:\"21:672\";i:749;s:6:\"21:673\";i:750;s:6:\"21:674\";i:751;s:6:\"21:675\";i:752;s:6:\"21:676\";i:753;s:6:\"21:677\";i:754;s:6:\"21:678\";i:755;s:6:\"21:679\";i:756;s:6:\"21:680\";i:757;s:6:\"21:681\";i:758;s:6:\"21:682\";i:759;s:6:\"21:683\";i:760;s:6:\"21:684\";i:761;s:6:\"21:144\";i:762;s:6:\"21:685\";i:763;s:6:\"21:686\";i:764;s:6:\"21:687\";i:765;s:6:\"21:143\";i:766;s:6:\"21:688\";i:767;s:6:\"21:689\";i:768;s:6:\"21:690\";i:769;s:6:\"21:691\";i:770;s:6:\"21:298\";i:771;s:6:\"21:692\";i:772;s:6:\"21:693\";i:773;s:6:\"21:694\";i:774;s:6:\"21:695\";i:775;s:6:\"21:696\";i:776;s:6:\"21:697\";i:777;s:6:\"21:698\";i:778;s:6:\"21:699\";i:779;s:6:\"21:700\";i:780;s:6:\"21:701\";i:781;s:6:\"21:702\";i:782;s:6:\"21:703\";i:783;s:6:\"21:704\";i:784;s:6:\"21:705\";i:785;s:6:\"21:706\";i:786;s:6:\"21:707\";i:787;s:6:\"21:708\";i:788;s:6:\"21:709\";i:789;s:6:\"21:710\";i:790;s:6:\"21:711\";i:791;s:6:\"21:712\";i:792;s:6:\"21:713\";i:793;s:6:\"21:714\";i:794;s:6:\"21:715\";i:795;s:6:\"21:142\";i:796;s:6:\"21:716\";i:797;s:6:\"21:717\";i:798;s:6:\"21:141\";i:799;s:6:\"21:140\";i:800;s:6:\"21:718\";i:801;s:6:\"21:719\";i:802;s:6:\"21:720\";i:803;s:6:\"21:541\";i:804;s:6:\"21:721\";i:805;s:6:\"21:722\";i:806;s:6:\"21:723\";i:807;s:6:\"21:724\";i:808;s:6:\"21:725\";i:809;s:6:\"21:726\";i:810;s:6:\"21:727\";i:811;s:6:\"21:139\";i:812;s:6:\"21:728\";i:813;s:6:\"21:729\";i:814;s:6:\"21:730\";i:815;s:6:\"21:731\";i:816;s:6:\"21:732\";i:817;s:6:\"21:733\";i:818;s:6:\"21:734\";i:819;s:6:\"21:735\";i:820;s:6:\"21:736\";i:821;s:6:\"21:737\";i:822;s:6:\"21:738\";i:823;s:6:\"21:739\";i:824;s:6:\"21:740\";i:825;s:6:\"21:741\";i:826;s:6:\"21:742\";i:827;s:6:\"21:743\";i:828;s:6:\"21:744\";i:829;s:6:\"21:745\";i:830;s:6:\"21:746\";i:831;s:6:\"21:747\";i:832;s:6:\"21:748\";i:833;s:6:\"21:749\";i:834;s:6:\"21:750\";i:835;s:5:\"21:66\";i:836;s:6:\"21:751\";i:837;s:6:\"21:752\";i:838;s:6:\"21:753\";i:839;s:6:\"21:754\";i:840;s:6:\"21:755\";i:841;s:6:\"21:756\";i:842;s:6:\"21:129\";i:843;s:6:\"21:757\";i:844;s:6:\"21:758\";i:845;s:6:\"21:759\";i:846;s:6:\"21:135\";i:847;s:6:\"21:760\";i:848;s:6:\"21:761\";i:849;s:6:\"21:762\";i:850;s:6:\"21:763\";i:851;s:6:\"21:764\";i:852;s:6:\"21:765\";i:853;s:6:\"21:526\";i:854;s:6:\"21:766\";i:855;s:6:\"21:767\";i:856;s:6:\"21:768\";i:857;s:6:\"21:137\";i:858;s:6:\"21:769\";i:859;s:6:\"21:770\";i:860;s:6:\"21:771\";i:861;s:6:\"21:114\";i:862;s:6:\"21:772\";i:863;s:6:\"21:773\";i:864;s:6:\"21:774\";i:865;s:6:\"21:775\";i:866;s:6:\"21:776\";i:867;s:6:\"21:777\";i:868;s:6:\"21:778\";i:869;s:6:\"21:779\";i:870;s:6:\"21:780\";i:871;s:6:\"21:781\";i:872;s:6:\"21:458\";i:873;s:6:\"21:782\";i:874;s:6:\"21:783\";i:875;s:6:\"21:784\";i:876;s:6:\"21:785\";i:877;s:6:\"21:108\";i:878;s:6:\"21:786\";i:879;s:6:\"21:107\";i:880;s:6:\"21:787\";i:881;s:6:\"21:106\";i:882;s:6:\"21:788\";i:883;s:6:\"21:789\";i:884;s:6:\"21:105\";i:885;s:6:\"21:790\";i:886;s:6:\"21:791\";i:887;s:6:\"21:792\";i:888;s:6:\"21:104\";i:889;s:6:\"21:793\";i:890;s:6:\"21:794\";i:891;s:6:\"21:103\";i:892;s:6:\"21:102\";i:893;s:6:\"21:101\";i:894;s:6:\"21:795\";i:895;s:6:\"21:796\";i:896;s:6:\"21:100\";i:897;s:6:\"21:797\";i:898;s:6:\"21:798\";i:899;s:6:\"21:799\";i:900;s:6:\"21:800\";i:901;s:6:\"21:801\";i:902;s:6:\"21:802\";i:903;s:6:\"21:296\";i:904;s:6:\"21:803\";i:905;s:6:\"21:804\";i:906;s:6:\"21:805\";i:907;s:5:\"21:99\";i:908;s:6:\"21:806\";i:909;s:6:\"21:807\";i:910;s:6:\"21:808\";i:911;s:6:\"21:809\";i:912;s:6:\"21:810\";i:913;s:6:\"21:811\";i:914;s:6:\"21:812\";i:915;s:6:\"21:813\";i:916;s:6:\"21:814\";i:917;s:6:\"21:815\";i:918;s:6:\"21:816\";i:919;s:6:\"21:817\";i:920;s:6:\"21:818\";i:921;s:6:\"21:819\";i:922;s:6:\"21:820\";i:923;s:6:\"21:821\";i:924;s:6:\"21:822\";i:925;s:6:\"21:823\";i:926;s:6:\"21:824\";i:927;s:6:\"21:825\";i:928;s:6:\"21:826\";i:929;s:6:\"21:827\";i:930;s:6:\"21:828\";i:931;s:6:\"21:829\";i:932;s:6:\"21:830\";i:933;s:6:\"21:831\";i:934;s:6:\"21:832\";i:935;s:6:\"21:833\";i:936;s:6:\"21:834\";i:937;s:6:\"21:835\";i:938;s:6:\"21:836\";i:939;s:6:\"21:837\";i:940;s:6:\"21:838\";i:941;s:6:\"21:839\";i:942;s:6:\"21:840\";i:943;s:6:\"21:841\";i:944;s:6:\"21:842\";i:945;s:6:\"21:843\";i:946;s:6:\"21:844\";i:947;s:6:\"21:845\";i:948;s:6:\"21:846\";i:949;s:6:\"21:847\";i:950;s:6:\"21:848\";i:951;s:6:\"21:849\";i:952;s:6:\"21:850\";i:953;s:6:\"21:851\";i:954;s:6:\"21:852\";i:955;s:6:\"21:853\";i:956;s:6:\"21:854\";i:957;s:6:\"21:855\";i:958;s:6:\"21:856\";i:959;s:6:\"21:857\";i:960;s:6:\"21:858\";i:961;s:6:\"21:859\";i:962;s:6:\"21:860\";i:963;s:6:\"21:861\";i:964;s:6:\"21:862\";i:965;s:6:\"21:863\";i:966;s:6:\"21:864\";i:967;s:6:\"21:865\";i:968;s:6:\"21:866\";i:969;s:6:\"21:867\";i:970;s:6:\"21:868\";i:971;s:6:\"21:869\";i:972;s:6:\"21:870\";i:973;s:6:\"21:871\";i:974;s:6:\"21:872\";i:975;s:6:\"21:873\";i:976;s:6:\"21:874\";i:977;s:6:\"21:875\";i:978;s:6:\"21:295\";i:979;s:6:\"21:876\";i:980;s:6:\"21:877\";i:981;s:6:\"21:294\";i:982;s:6:\"21:293\";i:983;s:6:\"21:878\";i:984;s:6:\"21:292\";i:985;s:6:\"21:879\";i:986;s:6:\"21:291\";i:987;s:6:\"21:290\";i:988;s:6:\"21:880\";i:989;s:6:\"21:881\";i:990;s:6:\"21:882\";i:991;s:6:\"21:883\";i:992;s:6:\"21:884\";i:993;s:6:\"21:885\";i:994;s:6:\"21:886\";i:995;s:6:\"21:887\";i:996;s:6:\"21:392\";i:997;s:6:\"21:391\";i:998;s:6:\"21:390\";i:999;s:6:\"21:888\";i:1000;s:5:\"21:98\";i:1001;s:6:\"21:889\";i:1002;s:6:\"21:890\";i:1003;s:6:\"21:891\";i:1004;s:5:\"21:97\";i:1005;s:6:\"21:892\";i:1006;s:6:\"21:893\";i:1007;s:6:\"21:894\";i:1008;s:6:\"21:895\";i:1009;s:6:\"21:896\";i:1010;s:6:\"21:897\";i:1011;s:6:\"21:898\";i:1012;s:6:\"21:899\";i:1013;s:5:\"21:83\";i:1014;s:6:\"21:900\";i:1015;s:5:\"21:82\";i:1016;s:6:\"21:901\";i:1017;s:5:\"21:80\";i:1018;s:5:\"21:79\";i:1019;s:5:\"21:78\";i:1020;s:6:\"21:902\";i:1021;s:5:\"21:77\";i:1022;s:5:\"21:76\";i:1023;s:6:\"21:388\";i:1024;s:5:\"21:75\";i:1025;s:5:\"21:74\";i:1026;s:5:\"21:73\";i:1027;s:6:\"21:288\";i:1028;s:6:\"21:387\";i:1029;s:5:\"21:72\";i:1030;s:5:\"21:71\";i:1031;s:5:\"21:70\";i:1032;s:6:\"21:287\";i:1033;s:6:\"21:903\";i:1034;s:6:\"21:904\";i:1035;s:6:\"21:905\";i:1036;s:6:\"21:906\";i:1037;s:6:\"21:907\";i:1038;s:5:\"21:69\";i:1039;s:6:\"21:908\";i:1040;s:5:\"21:68\";i:1041;s:6:\"21:909\";i:1042;s:6:\"21:910\";i:1043;s:5:\"21:67\";i:1044;s:5:\"21:65\";i:1045;s:6:\"21:911\";i:1046;s:6:\"21:912\";i:1047;s:6:\"21:913\";i:1048;s:6:\"21:914\";i:1049;s:6:\"21:915\";i:1050;s:6:\"21:916\";i:1051;s:5:\"21:88\";i:1052;s:6:\"21:917\";i:1053;s:5:\"21:64\";i:1054;s:6:\"21:918\";i:1055;s:6:\"21:919\";i:1056;s:6:\"21:920\";i:1057;s:6:\"21:921\";i:1058;s:6:\"21:922\";i:1059;s:6:\"21:923\";i:1060;s:6:\"21:924\";i:1061;s:6:\"21:925\";i:1062;s:6:\"21:926\";i:1063;s:6:\"21:927\";i:1064;s:5:\"21:61\";i:1065;s:5:\"21:60\";i:1066;s:6:\"21:928\";i:1067;s:6:\"21:929\";i:1068;s:6:\"21:930\";i:1069;s:6:\"21:931\";i:1070;s:6:\"21:932\";i:1071;s:6:\"21:933\";i:1072;s:6:\"21:934\";i:1073;s:6:\"21:935\";i:1074;s:6:\"21:282\";i:1075;s:6:\"21:936\";i:1076;s:6:\"21:937\";i:1077;s:6:\"21:281\";i:1078;s:6:\"21:938\";i:1079;s:6:\"21:939\";i:1080;s:5:\"21:59\";i:1081;s:6:\"21:386\";i:1082;s:6:\"21:279\";i:1083;s:6:\"21:278\";i:1084;s:6:\"21:940\";i:1085;s:6:\"21:941\";i:1086;s:6:\"21:942\";i:1087;s:6:\"21:943\";i:1088;s:6:\"21:944\";i:1089;s:6:\"21:945\";i:1090;s:6:\"21:946\";i:1091;s:6:\"21:947\";i:1092;s:6:\"21:948\";i:1093;s:6:\"21:949\";i:1094;s:6:\"21:950\";i:1095;s:6:\"21:951\";i:1096;s:6:\"21:952\";i:1097;s:6:\"21:953\";i:1098;s:6:\"21:954\";i:1099;s:6:\"21:955\";i:1100;s:6:\"21:956\";i:1101;s:6:\"21:957\";i:1102;s:6:\"21:457\";i:1103;s:6:\"21:958\";i:1104;s:6:\"21:959\";i:1105;s:6:\"21:960\";i:1106;s:6:\"21:961\";i:1107;s:6:\"21:962\";i:1108;s:6:\"21:963\";i:1109;s:6:\"21:964\";i:1110;s:6:\"21:965\";i:1111;s:6:\"21:966\";i:1112;s:6:\"21:273\";i:1113;s:6:\"21:967\";i:1114;s:6:\"21:968\";i:1115;s:6:\"21:969\";i:1116;s:6:\"21:970\";i:1117;s:6:\"21:971\";i:1118;s:6:\"21:972\";i:1119;s:6:\"21:265\";i:1120;s:6:\"21:973\";i:1121;s:6:\"21:974\";i:1122;s:6:\"21:975\";i:1123;s:6:\"21:264\";i:1124;s:6:\"21:976\";i:1125;s:6:\"21:977\";i:1126;s:5:\"21:58\";i:1127;s:6:\"21:263\";i:1128;s:6:\"21:262\";i:1129;s:5:\"21:57\";i:1130;s:6:\"21:978\";i:1131;s:6:\"21:979\";i:1132;s:6:\"21:980\";i:1133;s:6:\"21:981\";i:1134;s:6:\"21:384\";i:1135;s:6:\"21:385\";i:1136;s:6:\"21:982\";i:1137;s:6:\"21:983\";i:1138;s:6:\"21:984\";i:1139;s:6:\"21:985\";i:1140;s:6:\"21:986\";i:1141;s:6:\"21:987\";i:1142;s:6:\"21:988\";i:1143;s:6:\"21:989\";i:1144;s:6:\"21:990\";i:1145;s:6:\"21:991\";i:1146;s:6:\"21:261\";i:1147;s:6:\"21:992\";i:1148;s:6:\"21:993\";i:1149;s:6:\"21:994\";i:1150;s:5:\"21:56\";i:1151;s:6:\"21:995\";i:1152;s:5:\"21:55\";i:1153;s:6:\"21:996\";i:1154;s:6:\"21:997\";i:1155;s:6:\"21:998\";i:1156;s:5:\"21:54\";i:1157;s:6:\"21:999\";i:1158;s:5:\"21:53\";i:1159;s:5:\"21:52\";i:1160;s:7:\"21:1000\";i:1161;s:6:\"21:383\";i:1162;s:5:\"21:51\";i:1163;s:7:\"21:1001\";i:1164;s:7:\"21:1002\";i:1165;s:7:\"21:1003\";i:1166;s:7:\"21:1004\";i:1167;s:7:\"21:1005\";i:1168;s:7:\"21:1006\";i:1169;s:6:\"21:382\";i:1170;s:7:\"21:1007\";i:1171;s:6:\"21:381\";i:1172;s:5:\"21:50\";i:1173;s:6:\"21:260\";i:1174;s:6:\"21:259\";i:1175;s:7:\"21:1008\";i:1176;s:7:\"21:1009\";i:1177;s:6:\"21:258\";i:1178;s:7:\"21:1010\";i:1179;s:6:\"21:257\";i:1180;s:6:\"21:256\";i:1181;s:7:\"21:1011\";i:1182;s:5:\"21:49\";i:1183;s:5:\"21:48\";i:1184;s:7:\"21:1012\";i:1185;s:7:\"21:1013\";i:1186;s:5:\"21:47\";i:1187;s:7:\"21:1014\";i:1188;s:7:\"21:1015\";i:1189;s:7:\"21:1016\";i:1190;s:7:\"21:1017\";i:1191;s:7:\"21:1018\";i:1192;s:7:\"21:1019\";i:1193;s:7:\"21:1020\";i:1194;s:7:\"21:1021\";i:1195;s:6:\"21:380\";i:1196;s:7:\"21:1022\";i:1197;s:6:\"21:379\";i:1198;s:7:\"21:1023\";i:1199;s:7:\"21:1024\";i:1200;s:7:\"21:1025\";i:1201;s:7:\"21:1026\";i:1202;s:7:\"21:1027\";i:1203;s:7:\"21:1028\";i:1204;s:7:\"21:1029\";i:1205;s:7:\"21:1030\";i:1206;s:7:\"21:1031\";i:1207;s:7:\"21:1032\";i:1208;s:7:\"21:1033\";i:1209;s:7:\"21:1034\";i:1210;s:7:\"21:1035\";i:1211;s:7:\"21:1036\";i:1212;s:7:\"21:1037\";i:1213;s:7:\"21:1038\";i:1214;s:7:\"21:1039\";i:1215;s:7:\"21:1040\";i:1216;s:7:\"21:1041\";i:1217;s:7:\"21:1042\";i:1218;s:6:\"21:378\";i:1219;s:7:\"21:1043\";i:1220;s:7:\"21:1044\";i:1221;s:6:\"21:377\";i:1222;s:7:\"21:1045\";i:1223;s:7:\"21:1046\";i:1224;s:7:\"21:1047\";i:1225;s:7:\"21:1048\";i:1226;s:7:\"21:1049\";i:1227;s:6:\"21:255\";i:1228;s:7:\"21:1050\";i:1229;s:7:\"21:1051\";i:1230;s:7:\"21:1052\";i:1231;s:6:\"21:456\";i:1232;s:7:\"21:1053\";i:1233;s:7:\"21:1054\";i:1234;s:7:\"21:1055\";i:1235;s:7:\"21:1056\";i:1236;s:6:\"21:254\";i:1237;s:7:\"21:1057\";i:1238;s:7:\"21:1058\";i:1239;s:7:\"21:1059\";i:1240;s:7:\"21:1060\";i:1241;s:7:\"21:1061\";i:1242;s:7:\"21:1062\";i:1243;s:7:\"21:1063\";i:1244;s:7:\"21:1064\";i:1245;s:7:\"21:1065\";i:1246;s:7:\"21:1066\";i:1247;s:7:\"21:1067\";i:1248;s:7:\"21:1068\";i:1249;s:6:\"21:253\";i:1250;s:7:\"21:1069\";i:1251;s:7:\"21:1070\";i:1252;s:6:\"21:252\";i:1253;s:7:\"21:1071\";i:1254;s:7:\"21:1072\";i:1255;s:7:\"21:1073\";i:1256;s:7:\"21:1074\";i:1257;s:6:\"21:251\";i:1258;s:6:\"21:249\";i:1259;s:6:\"21:250\";i:1260;s:7:\"21:1075\";i:1261;s:6:\"21:248\";i:1262;s:7:\"21:1076\";i:1263;s:7:\"21:1077\";i:1264;s:6:\"21:247\";i:1265;s:7:\"21:1078\";i:1266;s:7:\"21:1079\";i:1267;s:7:\"21:1080\";i:1268;s:6:\"21:376\";i:1269;s:7:\"21:1081\";i:1270;s:7:\"21:1082\";i:1271;s:7:\"21:1083\";i:1272;s:7:\"21:1084\";i:1273;s:7:\"21:1085\";i:1274;s:7:\"21:1086\";i:1275;s:7:\"21:1087\";i:1276;s:7:\"21:1088\";i:1277;s:7:\"21:1089\";i:1278;s:7:\"21:1090\";i:1279;s:7:\"21:1091\";i:1280;s:7:\"21:1092\";i:1281;s:7:\"21:1093\";i:1282;s:7:\"21:1094\";i:1283;s:7:\"21:1095\";i:1284;s:7:\"21:1096\";i:1285;s:7:\"21:1097\";i:1286;s:7:\"21:1098\";i:1287;s:7:\"21:1099\";i:1288;s:7:\"21:1100\";i:1289;s:7:\"21:1101\";i:1290;s:7:\"21:1102\";i:1291;s:7:\"21:1103\";i:1292;s:7:\"21:1104\";i:1293;s:7:\"21:1105\";i:1294;s:7:\"21:1106\";i:1295;s:7:\"21:1107\";i:1296;s:7:\"21:1108\";i:1297;s:7:\"21:1109\";i:1298;s:7:\"21:1110\";i:1299;s:7:\"21:1111\";i:1300;s:7:\"21:1112\";i:1301;s:7:\"21:1113\";i:1302;s:7:\"21:1114\";i:1303;s:7:\"21:1115\";i:1304;s:7:\"21:1116\";i:1305;s:7:\"21:1117\";i:1306;s:7:\"21:1118\";i:1307;s:7:\"21:1119\";i:1308;s:7:\"21:1120\";i:1309;s:7:\"21:1121\";i:1310;s:7:\"21:1122\";i:1311;s:7:\"21:1123\";i:1312;s:7:\"21:1124\";i:1313;s:7:\"21:1125\";i:1314;s:7:\"21:1126\";i:1315;s:7:\"21:1127\";i:1316;s:7:\"21:1128\";i:1317;s:6:\"21:246\";i:1318;s:6:\"21:245\";i:1319;s:7:\"21:1129\";i:1320;s:7:\"21:1130\";i:1321;s:7:\"21:1131\";i:1322;s:7:\"21:1132\";i:1323;s:5:\"21:46\";i:1324;s:7:\"21:1133\";i:1325;s:5:\"21:45\";i:1326;s:5:\"21:44\";i:1327;s:6:\"21:243\";i:1328;s:6:\"21:241\";i:1329;s:7:\"21:1134\";i:1330;s:5:\"21:43\";i:1331;s:7:\"21:1135\";i:1332;s:5:\"21:42\";i:1333;s:5:\"21:41\";i:1334;s:5:\"21:40\";i:1335;s:7:\"21:1136\";i:1336;s:7:\"21:1137\";i:1337;s:5:\"21:39\";i:1338;s:7:\"21:1138\";i:1339;s:7:\"21:1139\";i:1340;s:7:\"21:1140\";i:1341;s:7:\"21:1141\";i:1342;s:7:\"21:1142\";i:1343;s:7:\"21:1143\";i:1344;s:5:\"21:38\";i:1345;s:7:\"21:1144\";i:1346;s:7:\"21:1145\";i:1347;s:7:\"21:1146\";i:1348;s:7:\"21:1147\";i:1349;s:7:\"21:1148\";i:1350;s:6:\"21:375\";i:1351;s:7:\"21:1149\";i:1352;s:7:\"21:1150\";i:1353;s:7:\"21:1151\";i:1354;s:6:\"21:240\";i:1355;s:7:\"21:1152\";i:1356;s:6:\"21:239\";i:1357;s:6:\"21:373\";i:1358;s:7:\"21:1153\";i:1359;s:5:\"21:36\";i:1360;s:5:\"21:37\";i:1361;s:7:\"21:1154\";i:1362;s:5:\"21:34\";i:1363;s:5:\"21:35\";i:1364;s:7:\"21:1155\";i:1365;s:7:\"21:1156\";i:1366;s:6:\"21:236\";i:1367;s:6:\"21:238\";i:1368;s:6:\"21:237\";i:1369;s:7:\"21:1157\";i:1370;s:5:\"21:32\";i:1371;s:6:\"21:551\";i:1372;s:6:\"21:550\";i:1373;s:7:\"21:1158\";i:1374;s:7:\"21:1159\";i:1375;s:6:\"21:553\";i:1376;s:7:\"21:1160\";i:1377;s:6:\"21:552\";i:1378;s:7:\"21:1161\";i:1379;s:7:\"21:1162\";i:1380;s:7:\"21:1163\";i:1381;s:7:\"21:1164\";i:1382;s:6:\"21:235\";i:1383;s:6:\"21:372\";i:1384;s:7:\"21:1165\";i:1385;s:7:\"21:1166\";i:1386;s:7:\"21:1167\";i:1387;s:7:\"21:1168\";i:1388;s:6:\"21:371\";i:1389;s:7:\"21:1169\";i:1390;s:7:\"21:1170\";i:1391;s:7:\"21:1171\";i:1392;s:6:\"21:558\";i:1393;s:7:\"21:1172\";i:1394;s:5:\"21:31\";i:1395;s:6:\"21:370\";i:1396;s:7:\"21:1173\";i:1397;s:7:\"21:1174\";i:1398;s:7:\"21:1175\";i:1399;s:7:\"21:1176\";i:1400;s:7:\"21:1177\";i:1401;s:7:\"21:1178\";i:1402;s:7:\"21:1179\";i:1403;s:7:\"21:1180\";i:1404;s:7:\"21:1181\";i:1405;s:7:\"21:1182\";i:1406;s:6:\"21:545\";i:1407;s:6:\"21:559\";i:1408;s:7:\"21:1183\";i:1409;s:7:\"21:1184\";i:1410;s:7:\"21:1185\";i:1411;s:7:\"21:1186\";i:1412;s:7:\"21:1187\";i:1413;s:7:\"21:1188\";i:1414;s:7:\"21:1189\";i:1415;s:7:\"21:1190\";i:1416;s:7:\"21:1191\";i:1417;s:7:\"21:1192\";i:1418;s:7:\"21:1193\";i:1419;s:7:\"21:1194\";i:1420;s:7:\"21:1195\";i:1421;s:7:\"21:1196\";i:1422;s:7:\"21:1197\";i:1423;s:7:\"21:1198\";i:1424;s:7:\"21:1199\";i:1425;s:7:\"21:1200\";i:1426;s:7:\"21:1201\";i:1427;s:7:\"21:1202\";i:1428;s:7:\"21:1203\";i:1429;s:7:\"21:1204\";i:1430;s:5:\"21:30\";i:1431;s:7:\"21:1205\";i:1432;s:7:\"21:1206\";i:1433;s:7:\"21:1207\";i:1434;s:7:\"21:1208\";i:1435;s:7:\"21:1209\";i:1436;s:7:\"21:1210\";i:1437;s:7:\"21:1211\";i:1438;s:7:\"21:1212\";i:1439;s:7:\"21:1213\";i:1440;s:5:\"21:28\";i:1441;s:5:\"21:29\";i:1442;s:7:\"21:1214\";i:1443;s:5:\"21:27\";i:1444;s:7:\"21:1215\";i:1445;s:7:\"21:1216\";i:1446;s:7:\"21:1217\";i:1447;s:5:\"21:25\";i:1448;s:5:\"21:26\";i:1449;s:7:\"21:1218\";i:1450;s:7:\"21:1219\";i:1451;s:7:\"21:1220\";i:1452;s:7:\"21:1221\";i:1453;s:7:\"21:1222\";i:1454;s:7:\"21:1223\";i:1455;s:7:\"21:1224\";i:1456;s:6:\"21:369\";i:1457;s:7:\"21:1225\";i:1458;s:7:\"21:1226\";i:1459;s:7:\"21:1227\";i:1460;s:7:\"21:1228\";i:1461;s:5:\"21:24\";i:1462;s:5:\"21:23\";i:1463;s:7:\"21:1229\";i:1464;s:6:\"21:234\";i:1465;s:7:\"21:1230\";i:1466;s:7:\"21:1231\";i:1467;s:7:\"21:1232\";i:1468;s:7:\"21:1233\";i:1469;s:6:\"21:233\";i:1470;s:7:\"21:1234\";i:1471;s:6:\"21:232\";i:1472;s:6:\"21:231\";i:1473;s:6:\"21:230\";i:1474;s:7:\"21:1235\";i:1475;s:6:\"21:368\";i:1476;s:6:\"21:229\";i:1477;s:5:\"21:22\";i:1478;s:5:\"21:21\";i:1479;s:7:\"21:1236\";i:1480;s:7:\"21:1237\";i:1481;s:5:\"21:20\";i:1482;s:7:\"21:1238\";i:1483;s:7:\"21:1239\";i:1484;s:7:\"21:1240\";i:1485;s:7:\"21:1241\";i:1486;s:5:\"21:19\";i:1487;s:6:\"21:524\";i:1488;s:7:\"21:1242\";i:1489;s:7:\"21:1243\";i:1490;s:7:\"21:1244\";i:1491;s:7:\"21:1245\";i:1492;s:7:\"21:1246\";i:1493;s:7:\"21:1247\";i:1494;s:7:\"21:1248\";i:1495;s:7:\"21:1249\";i:1496;s:7:\"21:1250\";i:1497;s:7:\"21:1251\";i:1498;s:7:\"21:1252\";i:1499;s:5:\"21:18\";i:1500;s:6:\"21:538\";i:1501;s:7:\"21:1253\";i:1502;s:6:\"21:367\";i:1503;s:6:\"21:366\";i:1504;s:7:\"21:1254\";i:1505;s:7:\"21:1255\";i:1506;s:7:\"21:1256\";i:1507;s:7:\"21:1257\";i:1508;s:7:\"21:1258\";i:1509;s:7:\"21:1259\";i:1510;s:5:\"21:17\";i:1511;s:6:\"21:228\";i:1512;s:7:\"21:1260\";i:1513;s:7:\"21:1261\";i:1514;s:7:\"21:1262\";i:1515;s:7:\"21:1263\";i:1516;s:6:\"21:365\";i:1517;s:7:\"21:1264\";i:1518;s:6:\"21:227\";i:1519;s:6:\"21:226\";i:1520;s:6:\"21:225\";i:1521;s:6:\"21:224\";i:1522;s:6:\"21:223\";i:1523;s:6:\"21:222\";i:1524;s:6:\"21:221\";i:1525;s:7:\"21:1265\";i:1526;s:7:\"21:1266\";i:1527;s:7:\"21:1267\";i:1528;s:7:\"21:1268\";i:1529;s:7:\"21:1269\";i:1530;s:7:\"21:1270\";i:1531;s:7:\"21:1271\";i:1532;s:7:\"21:1272\";i:1533;s:7:\"21:1273\";i:1534;s:7:\"21:1274\";i:1535;s:5:\"21:16\";i:1536;s:7:\"21:1275\";i:1537;s:7:\"21:1276\";i:1538;s:7:\"21:1277\";i:1539;s:7:\"21:1278\";i:1540;s:7:\"21:1279\";i:1541;s:7:\"21:1280\";i:1542;s:7:\"21:1281\";i:1543;s:7:\"21:1282\";i:1544;s:7:\"21:1283\";i:1545;s:7:\"21:1284\";i:1546;s:7:\"21:1285\";i:1547;s:7:\"21:1286\";i:1548;s:7:\"21:1287\";i:1549;s:7:\"21:1288\";i:1550;s:7:\"21:1289\";i:1551;s:7:\"21:1290\";i:1552;s:7:\"21:1291\";i:1553;s:6:\"21:455\";i:1554;s:7:\"21:1292\";i:1555;s:7:\"21:1293\";i:1556;s:7:\"21:1294\";i:1557;s:7:\"21:1295\";i:1558;s:7:\"21:1296\";i:1559;s:7:\"21:1297\";i:1560;s:7:\"21:1298\";i:1561;s:7:\"21:1299\";i:1562;s:6:\"21:454\";i:1563;s:7:\"21:1300\";i:1564;s:6:\"21:453\";i:1565;s:6:\"21:452\";i:1566;s:7:\"21:1301\";i:1567;s:7:\"21:1302\";i:1568;s:7:\"21:1303\";i:1569;s:7:\"21:1304\";i:1570;s:7:\"21:1305\";i:1571;s:7:\"21:1306\";i:1572;s:7:\"21:1307\";i:1573;s:7:\"21:1308\";i:1574;s:5:\"21:15\";i:1575;s:5:\"21:14\";i:1576;s:7:\"21:1309\";i:1577;s:7:\"21:1310\";i:1578;s:7:\"21:1311\";i:1579;s:7:\"21:1312\";i:1580;s:7:\"21:1313\";i:1581;s:7:\"21:1314\";i:1582;s:6:\"21:537\";i:1583;s:7:\"21:1315\";i:1584;s:7:\"21:1316\";i:1585;s:6:\"21:220\";i:1586;s:6:\"21:536\";i:1587;s:7:\"21:1317\";i:1588;s:7:\"21:1318\";i:1589;s:6:\"21:535\";i:1590;s:7:\"21:1319\";i:1591;s:6:\"21:557\";i:1592;s:7:\"21:1320\";i:1593;s:7:\"21:1321\";i:1594;s:7:\"21:1322\";i:1595;s:7:\"21:1323\";i:1596;s:7:\"21:1324\";i:1597;s:6:\"21:219\";i:1598;s:6:\"21:364\";i:1599;s:5:\"21:13\";i:1600;s:7:\"21:1325\";i:1601;s:7:\"21:1326\";i:1602;s:7:\"21:1327\";i:1603;s:6:\"21:363\";i:1604;s:7:\"21:1328\";i:1605;s:6:\"21:218\";i:1606;s:7:\"21:1329\";i:1607;s:5:\"21:12\";i:1608;s:7:\"21:1330\";i:1609;s:7:\"21:1331\";i:1610;s:7:\"21:1332\";i:1611;s:7:\"21:1333\";i:1612;s:7:\"21:1334\";i:1613;s:7:\"21:1335\";i:1614;s:7:\"21:1336\";i:1615;s:7:\"21:1337\";i:1616;s:7:\"21:1338\";i:1617;s:7:\"21:1339\";i:1618;s:7:\"21:1340\";i:1619;s:7:\"21:1341\";i:1620;s:7:\"21:1342\";i:1621;s:7:\"21:1343\";i:1622;s:5:\"21:11\";i:1623;s:6:\"21:362\";i:1624;s:5:\"21:10\";i:1625;s:7:\"21:1344\";i:1626;s:7:\"21:1345\";i:1627;s:7:\"21:1346\";i:1628;s:6:\"21:361\";i:1629;s:7:\"21:1347\";i:1630;s:6:\"21:217\";i:1631;s:7:\"21:1348\";i:1632;s:4:\"21:9\";i:1633;s:7:\"21:1349\";i:1634;s:6:\"21:216\";i:1635;s:7:\"21:1350\";i:1636;s:7:\"21:1351\";i:1637;s:7:\"21:1352\";i:1638;s:7:\"21:1353\";i:1639;s:7:\"21:1354\";i:1640;s:7:\"21:1355\";i:1641;s:7:\"21:1356\";i:1642;s:7:\"21:1357\";i:1643;s:7:\"21:1358\";i:1644;s:7:\"21:1359\";i:1645;s:7:\"21:1360\";i:1646;s:7:\"21:1361\";i:1647;s:6:\"21:215\";i:1648;s:6:\"21:214\";i:1649;s:7:\"21:1362\";i:1650;s:6:\"21:213\";i:1651;s:7:\"21:1363\";i:1652;s:6:\"21:212\";i:1653;s:7:\"21:1364\";i:1654;s:7:\"21:1365\";i:1655;s:7:\"21:1366\";i:1656;s:7:\"21:1367\";i:1657;s:6:\"21:560\";i:1658;s:6:\"21:556\";i:1659;s:7:\"21:1368\";i:1660;s:7:\"21:1369\";i:1661;s:7:\"21:1370\";i:1662;s:7:\"21:1371\";i:1663;s:7:\"21:1372\";i:1664;s:7:\"21:1373\";i:1665;s:7:\"21:1374\";i:1666;s:7:\"21:1375\";i:1667;s:7:\"21:1376\";i:1668;s:7:\"21:1377\";i:1669;s:7:\"21:1378\";i:1670;s:7:\"21:1379\";i:1671;s:7:\"21:1380\";i:1672;s:7:\"21:1381\";i:1673;s:7:\"21:1382\";i:1674;s:7:\"21:1383\";i:1675;s:6:\"21:210\";i:1676;s:6:\"21:211\";i:1677;s:7:\"21:1384\";i:1678;s:4:\"21:8\";i:1679;s:7:\"21:1385\";i:1680;s:7:\"21:1386\";i:1681;s:7:\"21:1387\";i:1682;s:7:\"21:1388\";i:1683;s:4:\"21:7\";i:1684;s:6:\"21:360\";i:1685;s:4:\"21:6\";i:1686;s:7:\"21:1389\";i:1687;s:7:\"21:1390\";i:1688;s:7:\"21:1391\";i:1689;s:6:\"21:359\";i:1690;s:6:\"21:358\";i:1691;s:7:\"21:1392\";i:1692;s:4:\"21:5\";i:1693;s:7:\"21:1393\";i:1694;s:7:\"21:1394\";i:1695;s:7:\"21:1395\";i:1696;s:4:\"21:4\";i:1697;s:7:\"21:1396\";i:1698;s:7:\"21:1397\";i:1699;s:4:\"21:3\";i:1700;s:4:\"21:2\";i:1701;s:7:\"21:1398\";i:1702;s:7:\"21:1399\";i:1703;s:7:\"21:1400\";i:1704;s:7:\"21:1401\";i:1705;s:7:\"21:1402\";i:1706;s:7:\"21:1403\";i:1707;s:7:\"21:1404\";i:1708;s:7:\"21:1405\";i:1709;s:7:\"21:1406\";i:1710;s:7:\"21:1407\";i:1711;s:7:\"21:1408\";i:1712;s:7:\"21:1409\";i:1713;s:7:\"21:1410\";i:1714;s:7:\"21:1411\";i:1715;s:7:\"21:1412\";i:1716;s:7:\"21:1413\";i:1717;s:7:\"21:1414\";i:1718;s:7:\"21:1415\";i:1719;s:4:\"21:1\";i:1720;s:7:\"21:1416\";i:1721;s:7:\"21:1417\";i:1722;s:7:\"21:1418\";i:1723;s:7:\"21:1419\";i:1724;s:7:\"21:1420\";i:1725;s:6:\"21:209\";i:1726;s:7:\"21:1421\";i:1727;s:7:\"21:1422\";i:1728;s:7:\"21:1423\";i:1729;s:7:\"21:1424\";i:1730;s:7:\"21:1425\";i:1731;s:7:\"21:1426\";i:1732;s:7:\"21:1427\";i:1733;s:7:\"21:1428\";i:1734;s:7:\"21:1429\";i:1735;s:7:\"21:1430\";i:1736;s:7:\"21:1431\";i:1737;s:7:\"21:1432\";i:1738;s:7:\"21:1433\";i:1739;s:7:\"21:1434\";i:1740;s:7:\"21:1435\";i:1741;s:7:\"21:1436\";i:1742;s:7:\"21:1437\";i:1743;s:7:\"21:1438\";i:1744;s:7:\"21:1439\";i:1745;s:7:\"21:1440\";i:1746;s:7:\"21:1441\";i:1747;s:7:\"21:1442\";i:1748;s:7:\"21:1443\";i:1749;s:7:\"21:1444\";i:1750;s:7:\"21:1445\";i:1751;s:7:\"21:1446\";i:1752;s:7:\"21:1447\";i:1753;s:7:\"21:1448\";i:1754;s:7:\"21:1449\";i:1755;s:7:\"21:1450\";i:1756;s:7:\"21:1451\";i:1757;s:7:\"21:1452\";i:1758;s:7:\"21:1453\";i:1759;s:7:\"21:1454\";i:1760;s:7:\"21:1455\";i:1761;s:7:\"21:1456\";i:1762;s:7:\"21:1457\";i:1763;s:7:\"21:1458\";i:1764;s:7:\"21:1459\";i:1765;s:7:\"21:1460\";i:1766;s:7:\"21:1461\";i:1767;s:7:\"21:1462\";i:1768;s:7:\"21:1463\";i:1769;s:7:\"21:1464\";i:1770;s:7:\"21:1465\";i:1771;s:7:\"21:1466\";i:1772;s:7:\"21:1467\";i:1773;s:7:\"21:1468\";i:1774;s:7:\"21:1469\";i:1775;s:7:\"21:1470\";i:1776;s:7:\"21:1471\";i:1777;s:7:\"21:1472\";i:1778;s:7:\"21:1473\";i:1779;s:7:\"21:1474\";i:1780;s:7:\"21:1475\";i:1781;s:7:\"21:1476\";i:1782;s:7:\"21:1477\";i:1783;s:7:\"21:1478\";i:1784;s:7:\"21:1479\";i:1785;s:7:\"21:1480\";i:1786;s:7:\"21:1481\";i:1787;s:7:\"21:1482\";i:1788;s:7:\"21:1483\";i:1789;s:7:\"21:1484\";i:1790;s:7:\"21:1485\";i:1791;s:7:\"21:1486\";i:1792;s:7:\"21:1487\";i:1793;s:7:\"21:1488\";i:1794;s:7:\"21:1489\";i:1795;s:7:\"21:1490\";i:1796;s:7:\"21:1491\";i:1797;s:7:\"21:1492\";i:1798;s:7:\"21:1493\";i:1799;s:7:\"21:1494\";i:1800;s:7:\"21:1495\";i:1801;s:7:\"21:1496\";i:1802;s:7:\"21:1497\";i:1803;s:7:\"21:1498\";i:1804;s:7:\"21:1499\";i:1805;s:7:\"21:1500\";i:1806;s:7:\"21:1501\";i:1807;s:7:\"21:1502\";i:1808;s:7:\"21:1503\";i:1809;s:7:\"21:1504\";i:1810;s:7:\"21:1505\";i:1811;s:7:\"21:1506\";i:1812;s:7:\"21:1507\";i:1813;s:7:\"21:1508\";i:1814;s:7:\"21:1509\";i:1815;s:7:\"21:1510\";i:1816;s:7:\"21:1511\";i:1817;s:7:\"21:1512\";i:1818;s:7:\"21:1513\";i:1819;s:7:\"21:1514\";i:1820;s:7:\"21:1515\";i:1821;s:7:\"21:1516\";i:1822;s:7:\"21:1517\";i:1823;s:7:\"21:1518\";i:1824;s:7:\"21:1519\";i:1825;s:7:\"21:1520\";i:1826;s:7:\"21:1521\";i:1827;s:7:\"21:1522\";i:1828;s:7:\"21:1523\";i:1829;s:7:\"21:1524\";i:1830;s:7:\"21:1525\";i:1831;s:7:\"21:1526\";i:1832;s:7:\"21:1527\";i:1833;s:7:\"21:1528\";i:1834;s:7:\"21:1529\";i:1835;s:7:\"21:1530\";i:1836;s:7:\"21:1531\";i:1837;s:7:\"21:1532\";i:1838;s:7:\"21:1533\";i:1839;s:7:\"21:1534\";i:1840;s:7:\"21:1535\";i:1841;s:7:\"21:1536\";i:1842;s:7:\"21:1537\";i:1843;s:7:\"21:1538\";i:1844;s:7:\"21:1539\";i:1845;s:7:\"21:1540\";i:1846;s:7:\"21:1541\";i:1847;s:7:\"21:1542\";i:1848;s:7:\"21:1543\";i:1849;s:7:\"21:1544\";i:1850;s:7:\"21:1545\";i:1851;s:7:\"21:1546\";i:1852;s:7:\"21:1547\";i:1853;s:7:\"21:1548\";i:1854;s:7:\"21:1549\";i:1855;s:7:\"21:1550\";i:1856;s:7:\"21:1551\";i:1857;s:7:\"21:1552\";i:1858;s:7:\"21:1553\";i:1859;s:7:\"21:1554\";i:1860;s:7:\"21:1555\";i:1861;s:7:\"21:1556\";i:1862;s:7:\"21:1557\";i:1863;s:7:\"21:1558\";i:1864;s:7:\"21:1559\";i:1865;s:7:\"21:1560\";i:1866;s:7:\"21:1561\";i:1867;s:7:\"21:1562\";i:1868;s:7:\"21:1563\";i:1869;s:7:\"21:1564\";i:1870;s:7:\"21:1565\";i:1871;s:7:\"21:1566\";i:1872;s:7:\"21:1567\";i:1873;s:7:\"21:1568\";i:1874;s:7:\"21:1569\";i:1875;s:7:\"21:1570\";i:1876;s:7:\"21:1571\";i:1877;s:7:\"21:1572\";i:1878;s:7:\"21:1573\";i:1879;s:7:\"21:1574\";i:1880;s:7:\"21:1575\";i:1881;s:7:\"21:1576\";i:1882;s:7:\"21:1577\";i:1883;s:7:\"21:1578\";i:1884;s:7:\"21:1579\";i:1885;s:7:\"21:1580\";i:1886;s:7:\"21:1581\";i:1887;s:7:\"21:1582\";i:1888;s:7:\"21:1583\";i:1889;s:7:\"21:1584\";i:1890;s:7:\"21:1585\";i:1891;s:7:\"21:1586\";i:1892;s:7:\"21:1587\";i:1893;s:7:\"21:1588\";i:1894;s:7:\"21:1589\";i:1895;s:7:\"21:1590\";i:1896;s:7:\"21:1591\";i:1897;s:7:\"21:1592\";i:1898;s:7:\"21:1593\";i:1899;s:7:\"21:1594\";i:1900;s:7:\"21:1595\";i:1901;s:7:\"21:1596\";i:1902;s:7:\"21:1597\";i:1903;s:7:\"21:1598\";i:1904;s:7:\"21:1599\";i:1905;s:7:\"21:1600\";i:1906;s:7:\"21:1601\";i:1907;s:7:\"21:1602\";i:1908;s:7:\"21:1603\";i:1909;s:7:\"21:1604\";i:1910;s:7:\"21:1605\";i:1911;s:7:\"21:1606\";i:1912;s:7:\"21:1607\";i:1913;s:7:\"21:1608\";i:1914;s:7:\"21:1609\";i:1915;s:7:\"21:1610\";i:1916;s:7:\"21:1611\";i:1917;s:7:\"21:1612\";i:1918;s:7:\"21:1613\";i:1919;s:7:\"21:1614\";i:1920;s:7:\"21:1615\";i:1921;s:7:\"21:1616\";i:1922;s:7:\"21:1617\";i:1923;s:7:\"21:1618\";i:1924;s:7:\"21:1619\";i:1925;s:7:\"21:1620\";i:1926;s:7:\"21:1621\";i:1927;s:7:\"21:1622\";i:1928;s:7:\"21:1623\";i:1929;s:7:\"21:1624\";i:1930;s:7:\"21:1625\";i:1931;s:7:\"21:1626\";i:1932;s:7:\"21:1627\";i:1933;s:7:\"21:1628\";i:1934;s:7:\"21:1629\";i:1935;s:7:\"21:1630\";i:1936;s:7:\"21:1631\";i:1937;s:7:\"21:1632\";i:1938;s:7:\"21:1633\";i:1939;s:7:\"21:1634\";i:1940;s:7:\"21:1635\";i:1941;s:7:\"21:1636\";i:1942;s:7:\"21:1637\";i:1943;s:7:\"21:1638\";i:1944;s:7:\"21:1639\";i:1945;s:7:\"21:1640\";i:1946;s:7:\"21:1641\";i:1947;s:7:\"21:1642\";i:1948;s:7:\"21:1643\";i:1949;s:7:\"21:1644\";i:1950;s:7:\"21:1645\";i:1951;s:7:\"21:1646\";i:1952;s:7:\"21:1647\";i:1953;s:7:\"21:1648\";i:1954;s:7:\"21:1649\";i:1955;s:7:\"21:1650\";i:1956;s:7:\"21:1651\";i:1957;s:7:\"21:1652\";i:1958;s:7:\"21:1653\";i:1959;s:7:\"21:1654\";i:1960;s:7:\"21:1655\";i:1961;s:7:\"21:1656\";i:1962;s:7:\"21:1657\";i:1963;s:7:\"21:1658\";i:1964;s:7:\"21:1659\";i:1965;s:7:\"21:1660\";i:1966;s:7:\"21:1661\";i:1967;s:7:\"21:1662\";i:1968;s:7:\"21:1663\";i:1969;s:7:\"21:1664\";i:1970;s:7:\"21:1665\";i:1971;s:7:\"21:1666\";i:1972;s:7:\"21:1667\";i:1973;s:7:\"21:1668\";i:1974;s:7:\"21:1669\";i:1975;s:7:\"21:1670\";i:1976;s:7:\"21:1671\";i:1977;s:7:\"21:1672\";i:1978;s:7:\"21:1673\";i:1979;s:7:\"21:1674\";i:1980;s:7:\"21:1675\";i:1981;s:7:\"21:1676\";i:1982;s:7:\"21:1677\";i:1983;s:7:\"21:1678\";i:1984;s:7:\"21:1679\";i:1985;s:7:\"21:1680\";i:1986;s:7:\"21:1681\";i:1987;s:7:\"21:1682\";i:1988;s:7:\"21:1683\";i:1989;s:7:\"21:1684\";i:1990;s:7:\"21:1685\";i:1991;s:7:\"21:1686\";i:1992;s:7:\"21:1687\";i:1993;s:7:\"21:1688\";i:1994;s:7:\"21:1689\";i:1995;s:7:\"21:1690\";i:1996;s:7:\"21:1691\";i:1997;s:7:\"21:1692\";i:1998;s:7:\"21:1693\";i:1999;s:7:\"21:1694\";i:2000;s:7:\"21:1695\";i:2001;s:7:\"21:1696\";i:2002;s:7:\"21:1697\";i:2003;s:7:\"21:1698\";i:2004;s:7:\"21:1699\";i:2005;s:7:\"21:1700\";i:2006;s:7:\"21:1701\";i:2007;s:7:\"21:1702\";i:2008;s:7:\"21:1703\";i:2009;s:7:\"21:1704\";i:2010;s:7:\"21:1705\";i:2011;s:7:\"21:1706\";i:2012;s:7:\"21:1707\";i:2013;s:7:\"21:1708\";i:2014;s:7:\"21:1709\";i:2015;s:7:\"21:1710\";i:2016;s:7:\"21:1711\";i:2017;s:7:\"21:1712\";i:2018;s:7:\"21:1713\";i:2019;s:7:\"21:1714\";i:2020;s:7:\"21:1715\";i:2021;s:7:\"21:1716\";i:2022;s:7:\"21:1717\";i:2023;s:7:\"21:1718\";i:2024;s:7:\"21:1719\";i:2025;s:7:\"21:1720\";i:2026;s:7:\"21:1721\";i:2027;s:7:\"21:1722\";i:2028;s:7:\"21:1723\";i:2029;s:7:\"21:1724\";i:2030;s:7:\"21:1725\";i:2031;s:7:\"21:1726\";i:2032;s:7:\"21:1727\";i:2033;s:7:\"21:1728\";i:2034;s:7:\"21:1729\";i:2035;s:7:\"21:1730\";i:2036;s:7:\"21:1731\";i:2037;s:7:\"21:1732\";i:2038;s:7:\"21:1733\";i:2039;s:7:\"21:1734\";i:2040;s:7:\"21:1735\";i:2041;s:7:\"21:1736\";i:2042;s:7:\"21:1737\";i:2043;s:7:\"21:1738\";i:2044;s:7:\"21:1739\";i:2045;s:7:\"21:1740\";i:2046;s:7:\"21:1741\";i:2047;s:7:\"21:1742\";i:2048;s:7:\"21:1743\";i:2049;s:7:\"21:1744\";i:2050;s:7:\"21:1745\";i:2051;s:7:\"21:1746\";i:2052;s:7:\"21:1747\";i:2053;s:7:\"21:1748\";i:2054;s:7:\"21:1749\";i:2055;s:7:\"21:1750\";i:2056;s:7:\"21:1751\";i:2057;s:7:\"21:1752\";i:2058;s:7:\"21:1753\";i:2059;s:7:\"21:1754\";i:2060;s:7:\"21:1755\";i:2061;s:7:\"21:1756\";i:2062;s:7:\"21:1757\";i:2063;s:7:\"21:1758\";i:2064;s:7:\"21:1759\";i:2065;s:7:\"21:1760\";i:2066;s:7:\"21:1761\";i:2067;s:7:\"21:1762\";i:2068;s:7:\"21:1763\";i:2069;s:7:\"21:1764\";i:2070;s:7:\"21:1765\";i:2071;s:7:\"21:1766\";i:2072;s:7:\"21:1767\";i:2073;s:7:\"21:1768\";i:2074;s:7:\"21:1769\";i:2075;s:7:\"21:1770\";i:2076;s:7:\"21:1771\";i:2077;s:7:\"21:1772\";i:2078;s:7:\"21:1773\";i:2079;s:7:\"21:1774\";i:2080;s:7:\"21:1775\";i:2081;s:7:\"21:1776\";i:2082;s:7:\"21:1777\";i:2083;s:7:\"21:1778\";i:2084;s:7:\"21:1779\";i:2085;s:7:\"21:1780\";i:2086;s:7:\"21:1781\";i:2087;s:7:\"21:1782\";i:2088;s:7:\"21:1783\";i:2089;s:7:\"21:1784\";i:2090;s:7:\"21:1785\";i:2091;s:7:\"21:1786\";i:2092;s:7:\"21:1787\";i:2093;s:7:\"21:1788\";i:2094;s:7:\"21:1789\";i:2095;s:7:\"21:1790\";i:2096;s:7:\"21:1791\";i:2097;s:7:\"21:1792\";i:2098;s:7:\"21:1793\";i:2099;s:7:\"21:1794\";i:2100;s:7:\"21:1795\";i:2101;s:7:\"21:1796\";i:2102;s:7:\"21:1797\";i:2103;s:7:\"21:1798\";i:2104;s:7:\"21:1799\";i:2105;s:7:\"21:1800\";i:2106;s:7:\"21:1801\";i:2107;s:7:\"21:1802\";i:2108;s:7:\"21:1803\";i:2109;s:7:\"21:1804\";i:2110;s:7:\"21:1805\";i:2111;s:7:\"21:1806\";i:2112;s:7:\"21:1807\";i:2113;s:7:\"21:1808\";i:2114;s:7:\"21:1809\";i:2115;s:7:\"21:1810\";i:2116;s:7:\"21:1811\";i:2117;s:7:\"21:1812\";i:2118;s:7:\"21:1813\";i:2119;s:7:\"21:1814\";i:2120;s:7:\"21:1815\";i:2121;s:7:\"21:1816\";i:2122;s:7:\"21:1817\";i:2123;s:7:\"21:1818\";i:2124;s:7:\"21:1819\";i:2125;s:7:\"21:1820\";i:2126;s:7:\"21:1821\";i:2127;s:7:\"21:1822\";i:2128;s:7:\"21:1823\";i:2129;s:7:\"21:1824\";i:2130;s:7:\"21:1825\";i:2131;s:7:\"21:1826\";i:2132;s:7:\"21:1827\";i:2133;s:7:\"21:1828\";i:2134;s:7:\"21:1829\";i:2135;s:7:\"21:1830\";i:2136;s:7:\"21:1831\";i:2137;s:7:\"21:1832\";i:2138;s:7:\"21:1833\";i:2139;s:7:\"21:1834\";i:2140;s:7:\"21:1835\";i:2141;s:7:\"21:1836\";i:2142;s:7:\"21:1837\";i:2143;s:7:\"21:1838\";i:2144;s:7:\"21:1839\";i:2145;s:7:\"21:1840\";i:2146;s:7:\"21:1841\";i:2147;s:7:\"21:1842\";i:2148;s:7:\"21:1843\";i:2149;s:7:\"21:1844\";i:2150;s:7:\"21:1845\";i:2151;s:7:\"21:1846\";i:2152;s:7:\"21:1847\";i:2153;s:7:\"21:1848\";i:2154;s:7:\"21:1849\";i:2155;s:7:\"21:1850\";i:2156;s:7:\"21:1851\";i:2157;s:7:\"21:1852\";i:2158;s:7:\"21:1853\";i:2159;s:7:\"21:1854\";i:2160;s:7:\"21:1855\";i:2161;s:7:\"21:1856\";i:2162;s:7:\"21:1857\";i:2163;s:7:\"21:1858\";i:2164;s:7:\"21:1859\";i:2165;s:7:\"21:1860\";i:2166;s:7:\"21:1861\";i:2167;s:7:\"21:1862\";i:2168;s:7:\"21:1863\";i:2169;s:7:\"21:1864\";i:2170;s:7:\"21:1865\";i:2171;s:7:\"21:1866\";i:2172;s:7:\"21:1867\";i:2173;s:7:\"21:1868\";i:2174;s:7:\"21:1869\";i:2175;s:7:\"21:1870\";i:2176;s:7:\"21:1871\";i:2177;s:7:\"21:1872\";i:2178;s:7:\"21:1873\";i:2179;s:7:\"21:1874\";i:2180;s:7:\"21:1875\";i:2181;s:7:\"21:1876\";i:2182;s:7:\"21:1877\";i:2183;s:7:\"21:1878\";i:2184;s:7:\"21:1879\";i:2185;s:7:\"21:1880\";i:2186;s:7:\"21:1881\";i:2187;s:7:\"21:1882\";i:2188;s:7:\"21:1883\";i:2189;s:7:\"21:1884\";i:2190;s:7:\"21:1885\";i:2191;s:7:\"21:1886\";i:2192;s:7:\"21:1887\";i:2193;s:7:\"21:1888\";i:2194;s:7:\"21:1889\";i:2195;s:7:\"21:1890\";i:2196;s:7:\"21:1891\";i:2197;s:7:\"21:1892\";i:2198;s:7:\"21:1893\";i:2199;s:7:\"21:1894\";i:2200;s:7:\"21:1895\";i:2201;s:7:\"21:1896\";i:2202;s:7:\"21:1897\";i:2203;s:7:\"21:1898\";i:2204;s:7:\"21:1899\";i:2205;s:7:\"21:1900\";i:2206;s:7:\"21:1901\";i:2207;s:7:\"21:1902\";i:2208;s:7:\"21:1903\";i:2209;s:7:\"21:1904\";i:2210;s:7:\"21:1905\";i:2211;s:7:\"21:1906\";i:2212;s:7:\"21:1907\";i:2213;s:7:\"21:1908\";i:2214;s:7:\"21:1909\";i:2215;s:7:\"21:1910\";i:2216;s:7:\"21:1911\";i:2217;s:7:\"21:1912\";i:2218;s:7:\"21:1913\";i:2219;s:7:\"21:1914\";i:2220;s:7:\"21:1915\";i:2221;s:7:\"21:1916\";i:2222;s:7:\"21:1917\";i:2223;s:7:\"21:1918\";i:2224;s:7:\"21:1919\";i:2225;s:7:\"21:1920\";i:2226;s:7:\"21:1921\";i:2227;s:7:\"21:1922\";i:2228;s:7:\"21:1923\";i:2229;s:7:\"21:1924\";i:2230;s:7:\"21:1925\";i:2231;s:7:\"21:1926\";i:2232;s:7:\"21:1927\";i:2233;s:7:\"21:1928\";i:2234;s:7:\"21:1929\";i:2235;s:7:\"21:1930\";i:2236;s:7:\"21:1931\";i:2237;s:7:\"21:1932\";i:2238;s:7:\"21:1933\";i:2239;s:7:\"21:1934\";i:2240;s:7:\"21:1935\";i:2241;s:7:\"21:1936\";i:2242;s:7:\"21:1937\";i:2243;s:7:\"21:1938\";i:2244;s:7:\"21:1939\";i:2245;s:7:\"21:1940\";i:2246;s:7:\"21:1941\";i:2247;s:7:\"21:1942\";i:2248;s:7:\"21:1943\";i:2249;s:7:\"21:1944\";i:2250;s:7:\"21:1945\";i:2251;s:7:\"21:1946\";i:2252;s:7:\"21:1947\";i:2253;s:7:\"21:1948\";i:2254;s:7:\"21:1949\";i:2255;s:7:\"21:1950\";i:2256;s:7:\"21:1951\";i:2257;s:7:\"21:1952\";i:2258;s:7:\"21:1953\";i:2259;s:7:\"21:1954\";i:2260;s:7:\"21:1955\";i:2261;s:7:\"21:1956\";i:2262;s:7:\"21:1957\";i:2263;s:7:\"21:1958\";i:2264;s:7:\"21:1959\";i:2265;s:7:\"21:1960\";i:2266;s:7:\"21:1961\";i:2267;s:7:\"21:1962\";i:2268;s:7:\"21:1963\";i:2269;s:7:\"21:1964\";i:2270;s:7:\"21:1965\";i:2271;s:7:\"21:1966\";i:2272;s:7:\"21:1967\";i:2273;s:7:\"21:1968\";i:2274;s:7:\"21:1969\";i:2275;s:7:\"21:1970\";i:2276;s:7:\"21:1971\";i:2277;s:7:\"21:1972\";i:2278;s:7:\"21:1973\";i:2279;s:7:\"21:1974\";i:2280;s:7:\"21:1975\";i:2281;s:7:\"21:1976\";i:2282;s:7:\"21:1977\";i:2283;s:7:\"21:1978\";i:2284;s:7:\"21:1979\";i:2285;s:7:\"21:1980\";i:2286;s:7:\"21:1981\";i:2287;s:7:\"21:1982\";i:2288;s:7:\"21:1983\";i:2289;s:7:\"21:1984\";i:2290;s:7:\"21:1985\";i:2291;s:7:\"21:1986\";i:2292;s:7:\"21:1987\";i:2293;s:7:\"21:1988\";i:2294;s:7:\"21:1989\";i:2295;s:7:\"21:1990\";i:2296;s:7:\"21:1991\";i:2297;s:7:\"21:1992\";i:2298;s:7:\"21:1993\";i:2299;s:7:\"21:1994\";i:2300;s:7:\"21:1995\";i:2301;s:7:\"21:1996\";i:2302;s:7:\"21:1997\";i:2303;s:7:\"21:1998\";i:2304;s:7:\"21:1999\";i:2305;s:7:\"21:2000\";i:2306;s:7:\"21:2001\";i:2307;s:7:\"21:2002\";i:2308;s:7:\"21:2003\";i:2309;s:7:\"21:2004\";i:2310;s:7:\"21:2005\";i:2311;s:7:\"21:2006\";i:2312;s:7:\"21:2007\";i:2313;s:7:\"21:2008\";i:2314;s:7:\"21:2009\";i:2315;s:7:\"21:2010\";i:2316;s:7:\"21:2011\";i:2317;s:7:\"21:2012\";i:2318;s:7:\"21:2013\";i:2319;s:7:\"21:2014\";i:2320;s:7:\"21:2015\";i:2321;s:7:\"21:2016\";i:2322;s:7:\"21:2017\";i:2323;s:7:\"21:2018\";i:2324;s:7:\"21:2019\";i:2325;s:7:\"21:2020\";i:2326;s:7:\"21:2021\";i:2327;s:7:\"21:2022\";i:2328;s:7:\"21:2023\";i:2329;s:7:\"21:2024\";i:2330;s:7:\"21:2025\";i:2331;s:7:\"21:2026\";i:2332;s:7:\"21:2027\";i:2333;s:7:\"21:2028\";i:2334;s:7:\"21:2029\";i:2335;s:7:\"21:2030\";i:2336;s:7:\"21:2031\";i:2337;s:7:\"21:2032\";i:2338;s:7:\"21:2033\";i:2339;s:7:\"21:2034\";i:2340;s:7:\"21:2035\";i:2341;s:7:\"21:2036\";i:2342;s:7:\"21:2037\";i:2343;s:7:\"21:2038\";i:2344;s:7:\"21:2039\";i:2345;s:7:\"21:2040\";i:2346;s:7:\"21:2041\";i:2347;s:7:\"21:2042\";i:2348;s:7:\"21:2043\";i:2349;s:7:\"21:2044\";i:2350;s:7:\"21:2045\";i:2351;s:7:\"21:2046\";i:2352;s:7:\"21:2047\";i:2353;s:7:\"21:2048\";i:2354;s:7:\"21:2049\";i:2355;s:7:\"21:2050\";i:2356;s:7:\"21:2051\";i:2357;s:7:\"21:2052\";i:2358;s:7:\"21:2053\";i:2359;s:7:\"21:2054\";i:2360;s:7:\"21:2055\";i:2361;s:7:\"21:2056\";i:2362;s:7:\"21:2057\";i:2363;s:7:\"21:2058\";i:2364;s:7:\"21:2059\";i:2365;s:7:\"21:2060\";i:2366;s:7:\"21:2061\";i:2367;s:7:\"21:2062\";i:2368;s:7:\"21:2063\";i:2369;s:7:\"21:2064\";i:2370;s:7:\"21:2065\";i:2371;s:7:\"21:2066\";i:2372;s:7:\"21:2067\";i:2373;s:7:\"21:2068\";i:2374;s:7:\"21:2069\";i:2375;s:7:\"21:2070\";i:2376;s:7:\"21:2071\";i:2377;s:7:\"21:2072\";i:2378;s:7:\"21:2073\";i:2379;s:7:\"21:2074\";i:2380;s:7:\"21:2075\";i:2381;s:7:\"21:2076\";i:2382;s:7:\"21:2077\";i:2383;s:7:\"21:2078\";i:2384;s:7:\"21:2079\";i:2385;s:7:\"21:2080\";i:2386;s:7:\"21:2081\";i:2387;s:7:\"21:2082\";i:2388;s:7:\"21:2083\";i:2389;s:7:\"21:2084\";i:2390;s:7:\"21:2085\";i:2391;s:7:\"21:2086\";i:2392;s:7:\"21:2087\";i:2393;s:7:\"21:2088\";i:2394;s:7:\"21:2089\";i:2395;s:7:\"21:2090\";i:2396;s:7:\"21:2091\";i:2397;s:7:\"21:2092\";i:2398;s:7:\"21:2093\";i:2399;s:7:\"21:2094\";i:2400;s:7:\"21:2095\";i:2401;s:7:\"21:2096\";i:2402;s:7:\"21:2097\";i:2403;s:7:\"21:2098\";i:2404;s:7:\"21:2099\";i:2405;s:7:\"21:2100\";i:2406;s:7:\"21:2101\";i:2407;s:7:\"21:2102\";i:2408;s:7:\"21:2103\";i:2409;s:7:\"21:2104\";i:2410;s:7:\"21:2105\";i:2411;s:7:\"21:2106\";i:2412;s:7:\"21:2107\";i:2413;s:7:\"21:2108\";i:2414;s:7:\"21:2109\";i:2415;s:7:\"21:2110\";i:2416;s:7:\"21:2111\";i:2417;s:7:\"21:2112\";i:2418;s:7:\"21:2113\";i:2419;s:7:\"21:2114\";i:2420;s:7:\"21:2115\";i:2421;s:7:\"21:2116\";i:2422;s:7:\"21:2117\";i:2423;s:7:\"21:2118\";i:2424;s:7:\"21:2119\";i:2425;s:7:\"21:2120\";i:2426;s:7:\"21:2121\";i:2427;s:7:\"21:2122\";i:2428;s:7:\"21:2123\";i:2429;s:7:\"21:2124\";i:2430;s:7:\"21:2125\";i:2431;s:7:\"21:2126\";i:2432;s:7:\"21:2127\";i:2433;s:7:\"21:2128\";i:2434;s:7:\"21:2129\";i:2435;s:7:\"21:2130\";i:2436;s:7:\"21:2131\";i:2437;s:7:\"21:2132\";i:2438;s:7:\"21:2133\";i:2439;s:7:\"21:2134\";i:2440;s:7:\"21:2135\";i:2441;s:7:\"21:2136\";i:2442;s:7:\"21:2137\";i:2443;s:7:\"21:2138\";i:2444;s:7:\"21:2139\";i:2445;s:7:\"21:2140\";i:2446;s:7:\"21:2141\";i:2447;s:7:\"21:2142\";i:2448;s:7:\"21:2143\";i:2449;s:7:\"21:2144\";i:2450;s:7:\"21:2145\";i:2451;s:7:\"21:2146\";i:2452;s:7:\"21:2147\";i:2453;s:7:\"21:2148\";i:2454;s:7:\"21:2149\";i:2455;s:7:\"21:2150\";i:2456;s:7:\"21:2151\";i:2457;s:7:\"21:2152\";i:2458;s:7:\"21:2153\";i:2459;s:7:\"21:2154\";i:2460;s:7:\"21:2155\";i:2461;s:7:\"21:2156\";i:2462;s:7:\"21:2157\";i:2463;s:7:\"21:2158\";i:2464;s:7:\"21:2159\";i:2465;s:7:\"21:2160\";i:2466;s:7:\"21:2161\";i:2467;s:7:\"21:2162\";i:2468;s:7:\"21:2163\";i:2469;s:7:\"21:2164\";i:2470;s:7:\"21:2165\";i:2471;s:7:\"21:2166\";i:2472;s:7:\"21:2167\";i:2473;s:7:\"21:2168\";i:2474;s:7:\"21:2169\";i:2475;s:7:\"21:2170\";i:2476;s:7:\"21:2171\";i:2477;s:7:\"21:2172\";i:2478;s:7:\"21:2173\";i:2479;s:7:\"21:2174\";i:2480;s:7:\"21:2175\";i:2481;s:7:\"21:2176\";i:2482;s:7:\"21:2177\";i:2483;s:7:\"21:2178\";i:2484;s:7:\"21:2179\";i:2485;s:7:\"21:2180\";i:2486;s:7:\"21:2181\";i:2487;s:7:\"21:2182\";i:2488;s:7:\"21:2183\";i:2489;s:7:\"21:2184\";i:2490;s:7:\"21:2185\";i:2491;s:7:\"21:2186\";i:2492;s:7:\"21:2187\";i:2493;s:7:\"21:2188\";i:2494;s:7:\"21:2189\";i:2495;s:7:\"21:2190\";i:2496;s:7:\"21:2191\";i:2497;s:7:\"21:2192\";i:2498;s:7:\"21:2193\";i:2499;s:7:\"21:2194\";i:2500;s:7:\"21:2195\";i:2501;s:7:\"21:2196\";i:2502;s:7:\"21:2197\";i:2503;s:7:\"21:2198\";i:2504;s:7:\"21:2199\";i:2505;s:7:\"21:2200\";i:2506;s:7:\"21:2201\";i:2507;s:7:\"21:2202\";i:2508;s:7:\"21:2203\";i:2509;s:7:\"21:2204\";i:2510;s:7:\"21:2205\";i:2511;s:7:\"21:2206\";i:2512;s:7:\"21:2207\";i:2513;s:7:\"21:2208\";i:2514;s:7:\"21:2209\";i:2515;s:7:\"21:2210\";i:2516;s:7:\"21:2211\";i:2517;s:7:\"21:2212\";i:2518;s:7:\"21:2213\";i:2519;s:7:\"21:2214\";i:2520;s:7:\"21:2215\";i:2521;s:7:\"21:2216\";i:2522;s:7:\"21:2217\";i:2523;s:7:\"21:2218\";i:2524;s:7:\"21:2219\";i:2525;s:7:\"21:2220\";i:2526;s:7:\"21:2221\";i:2527;s:7:\"21:2222\";i:2528;s:7:\"21:2223\";i:2529;s:7:\"21:2224\";i:2530;s:7:\"21:2225\";i:2531;s:7:\"21:2226\";i:2532;s:7:\"21:2227\";i:2533;s:7:\"21:2228\";i:2534;s:7:\"21:2229\";i:2535;s:7:\"21:2230\";i:2536;s:7:\"21:2231\";i:2537;s:7:\"21:2232\";i:2538;s:7:\"21:2233\";i:2539;s:7:\"21:2234\";i:2540;s:7:\"21:2235\";i:2541;s:7:\"21:2236\";i:2542;s:7:\"21:2237\";i:2543;s:7:\"21:2238\";i:2544;s:7:\"21:2239\";i:2545;s:7:\"21:2240\";i:2546;s:7:\"21:2241\";i:2547;s:7:\"21:2242\";i:2548;s:7:\"21:2243\";i:2549;s:7:\"21:2244\";i:2550;s:7:\"21:2245\";i:2551;s:7:\"21:2246\";i:2552;s:7:\"21:2247\";i:2553;s:7:\"21:2248\";i:2554;s:7:\"21:2249\";i:2555;s:7:\"21:2250\";i:2556;s:7:\"21:2251\";i:2557;s:7:\"21:2252\";i:2558;s:7:\"21:2253\";i:2559;s:7:\"21:2254\";i:2560;s:7:\"21:2255\";i:2561;s:7:\"21:2256\";i:2562;s:7:\"21:2257\";i:2563;s:7:\"21:2258\";i:2564;s:7:\"21:2259\";i:2565;s:7:\"21:2260\";i:2566;s:7:\"21:2261\";i:2567;s:7:\"21:2262\";i:2568;s:7:\"21:2263\";i:2569;s:7:\"21:2264\";i:2570;s:7:\"21:2265\";i:2571;s:7:\"21:2266\";i:2572;s:7:\"21:2267\";i:2573;s:7:\"21:2268\";i:2574;s:7:\"21:2269\";i:2575;s:7:\"21:2270\";i:2576;s:7:\"21:2271\";i:2577;s:7:\"21:2272\";i:2578;s:7:\"21:2273\";i:2579;s:7:\"21:2274\";i:2580;s:7:\"21:2275\";i:2581;s:7:\"21:2276\";i:2582;s:7:\"21:2277\";i:2583;s:7:\"21:2278\";i:2584;s:7:\"21:2279\";i:2585;s:7:\"21:2280\";i:2586;s:7:\"21:2281\";i:2587;s:7:\"21:2282\";i:2588;s:7:\"21:2283\";i:2589;s:7:\"21:2284\";i:2590;s:7:\"21:2285\";i:2591;s:7:\"21:2286\";i:2592;s:7:\"21:2287\";i:2593;s:7:\"21:2288\";i:2594;s:7:\"21:2289\";i:2595;s:7:\"21:2290\";i:2596;s:7:\"21:2291\";i:2597;s:7:\"21:2292\";i:2598;s:7:\"21:2293\";i:2599;s:7:\"21:2294\";i:2600;s:7:\"21:2295\";i:2601;s:7:\"21:2296\";i:2602;s:7:\"21:2297\";i:2603;s:7:\"21:2298\";i:2604;s:7:\"21:2299\";i:2605;s:7:\"21:2300\";i:2606;s:7:\"21:2301\";i:2607;s:7:\"21:2302\";i:2608;s:7:\"21:2303\";i:2609;s:7:\"21:2304\";i:2610;s:7:\"21:2305\";i:2611;s:7:\"21:2306\";i:2612;s:7:\"21:2307\";i:2613;s:7:\"21:2308\";i:2614;s:7:\"21:2309\";i:2615;s:7:\"21:2310\";i:2616;s:7:\"21:2311\";i:2617;s:7:\"21:2312\";i:2618;s:7:\"21:2313\";i:2619;s:7:\"21:2314\";i:2620;s:7:\"21:2315\";i:2621;s:7:\"21:2316\";i:2622;s:7:\"21:2317\";i:2623;s:7:\"21:2318\";i:2624;s:7:\"21:2319\";i:2625;s:7:\"21:2320\";i:2626;s:7:\"21:2321\";i:2627;s:7:\"21:2322\";i:2628;s:7:\"21:2323\";i:2629;s:7:\"21:2324\";i:2630;s:7:\"21:2325\";i:2631;s:7:\"21:2326\";i:2632;s:7:\"21:2327\";i:2633;s:7:\"21:2328\";i:2634;s:7:\"21:2329\";i:2635;s:7:\"21:2330\";i:2636;s:7:\"21:2331\";i:2637;s:7:\"21:2332\";i:2638;s:7:\"21:2333\";i:2639;s:7:\"21:2334\";i:2640;s:7:\"21:2335\";i:2641;s:7:\"21:2336\";i:2642;s:7:\"21:2337\";i:2643;s:7:\"21:2338\";i:2644;s:7:\"21:2339\";i:2645;s:7:\"21:2340\";i:2646;s:7:\"21:2341\";i:2647;s:7:\"21:2342\";i:2648;s:7:\"21:2343\";i:2649;s:7:\"21:2344\";i:2650;s:7:\"21:2345\";i:2651;s:7:\"21:2346\";i:2652;s:7:\"21:2347\";i:2653;s:7:\"21:2348\";i:2654;s:7:\"21:2349\";i:2655;s:7:\"21:2350\";i:2656;s:7:\"21:2351\";i:2657;s:7:\"21:2352\";i:2658;s:7:\"21:2353\";i:2659;s:7:\"21:2354\";i:2660;s:7:\"21:2355\";i:2661;s:7:\"21:2356\";i:2662;s:7:\"21:2357\";i:2663;s:7:\"21:2358\";i:2664;s:7:\"21:2359\";i:2665;s:7:\"21:2360\";i:2666;s:7:\"21:2361\";i:2667;s:7:\"21:2362\";i:2668;s:7:\"21:2363\";i:2669;s:7:\"21:2364\";i:2670;s:7:\"21:2365\";i:2671;s:7:\"21:2366\";i:2672;s:7:\"21:2367\";i:2673;s:7:\"21:2368\";i:2674;s:7:\"21:2369\";i:2675;s:7:\"21:2370\";i:2676;s:7:\"21:2371\";i:2677;s:7:\"21:2372\";i:2678;s:7:\"21:2373\";i:2679;s:7:\"21:2374\";i:2680;s:7:\"21:2375\";i:2681;s:7:\"21:2376\";i:2682;s:7:\"21:2377\";i:2683;s:7:\"21:2378\";i:2684;s:7:\"21:2379\";i:2685;s:7:\"21:2380\";i:2686;s:7:\"21:2381\";i:2687;s:7:\"21:2382\";i:2688;s:7:\"21:2383\";i:2689;s:7:\"21:2384\";i:2690;s:7:\"21:2385\";i:2691;s:7:\"21:2386\";i:2692;s:7:\"21:2387\";i:2693;s:7:\"21:2388\";i:2694;s:7:\"21:2389\";i:2695;s:7:\"21:2390\";i:2696;s:7:\"21:2391\";i:2697;s:7:\"21:2392\";i:2698;s:7:\"21:2393\";i:2699;s:7:\"21:2394\";i:2700;s:7:\"21:2395\";i:2701;s:7:\"21:2396\";i:2702;s:7:\"21:2397\";i:2703;s:7:\"21:2398\";i:2704;s:7:\"21:2399\";i:2705;s:7:\"21:2400\";i:2706;s:7:\"21:2401\";i:2707;s:7:\"21:2402\";i:2708;s:7:\"21:2403\";i:2709;s:7:\"21:2404\";i:2710;s:7:\"21:2405\";i:2711;s:7:\"21:2406\";i:2712;s:7:\"21:2407\";i:2713;s:7:\"21:2408\";i:2714;s:7:\"21:2409\";i:2715;s:7:\"21:2410\";i:2716;s:7:\"21:2411\";i:2717;s:7:\"21:2412\";i:2718;s:7:\"21:2413\";i:2719;s:7:\"21:2414\";i:2720;s:7:\"21:2415\";i:2721;s:7:\"21:2416\";i:2722;s:7:\"21:2417\";i:2723;s:7:\"21:2418\";i:2724;s:7:\"21:2419\";i:2725;s:7:\"21:2420\";i:2726;s:7:\"21:2421\";i:2727;s:7:\"21:2422\";i:2728;s:7:\"21:2423\";i:2729;s:7:\"21:2424\";i:2730;s:7:\"21:2425\";i:2731;s:7:\"21:2426\";i:2732;s:7:\"21:2427\";i:2733;s:7:\"21:2428\";i:2734;s:7:\"21:2429\";i:2735;s:7:\"21:2430\";i:2736;s:7:\"21:2431\";i:2737;s:7:\"21:2432\";i:2738;s:7:\"21:2433\";i:2739;s:7:\"21:2434\";i:2740;s:7:\"21:2435\";i:2741;s:7:\"21:2436\";i:2742;s:7:\"21:2437\";i:2743;s:7:\"21:2438\";i:2744;s:7:\"21:2439\";i:2745;s:7:\"21:2440\";i:2746;s:7:\"21:2441\";i:2747;s:7:\"21:2442\";i:2748;s:7:\"21:2443\";i:2749;s:7:\"21:2444\";i:2750;s:7:\"21:2445\";i:2751;s:7:\"21:2446\";i:2752;s:7:\"21:2447\";i:2753;s:7:\"21:2448\";i:2754;s:7:\"21:2449\";i:2755;s:7:\"21:2450\";i:2756;s:7:\"21:2451\";i:2757;s:7:\"21:2452\";i:2758;s:7:\"21:2453\";i:2759;s:7:\"21:2454\";i:2760;s:7:\"21:2455\";i:2761;s:7:\"21:2456\";i:2762;s:7:\"21:2457\";i:2763;s:7:\"21:2458\";i:2764;s:7:\"21:2459\";i:2765;s:7:\"21:2460\";i:2766;s:7:\"21:2461\";i:2767;s:7:\"21:2462\";i:2768;s:7:\"21:2463\";i:2769;s:7:\"21:2464\";i:2770;s:7:\"21:2465\";i:2771;s:7:\"21:2466\";i:2772;s:7:\"21:2467\";i:2773;s:7:\"21:2468\";i:2774;s:7:\"21:2469\";i:2775;s:7:\"21:2470\";i:2776;s:7:\"21:2471\";i:2777;s:7:\"21:2472\";i:2778;s:7:\"21:2473\";i:2779;s:7:\"21:2474\";i:2780;s:7:\"21:2475\";i:2781;s:7:\"21:2476\";i:2782;s:7:\"21:2477\";i:2783;s:7:\"21:2478\";i:2784;s:7:\"21:2479\";i:2785;s:7:\"21:2480\";i:2786;s:7:\"21:2481\";i:2787;s:7:\"21:2482\";i:2788;s:7:\"21:2483\";i:2789;s:7:\"21:2484\";i:2790;s:7:\"21:2485\";i:2791;s:7:\"21:2486\";i:2792;s:7:\"21:2487\";i:2793;s:7:\"21:2488\";i:2794;s:7:\"21:2489\";i:2795;s:7:\"21:2490\";i:2796;s:7:\"21:2491\";i:2797;s:7:\"21:2492\";i:2798;s:7:\"21:2493\";i:2799;s:7:\"21:2494\";i:2800;s:7:\"21:2495\";i:2801;s:7:\"21:2496\";i:2802;s:7:\"21:2497\";i:2803;s:7:\"21:2498\";i:2804;s:7:\"21:2499\";i:2805;s:7:\"21:2500\";i:2806;s:7:\"21:2501\";i:2807;s:7:\"21:2502\";i:2808;s:7:\"21:2503\";i:2809;s:7:\"21:2504\";i:2810;s:7:\"21:2505\";i:2811;s:7:\"21:2506\";i:2812;s:7:\"21:2507\";i:2813;s:7:\"21:2508\";i:2814;s:7:\"21:2509\";i:2815;s:7:\"21:2510\";i:2816;s:7:\"21:2511\";i:2817;s:7:\"21:2512\";i:2818;s:7:\"21:2513\";i:2819;s:7:\"21:2514\";i:2820;s:7:\"21:2515\";i:2821;s:7:\"21:2516\";i:2822;s:7:\"21:2517\";i:2823;s:7:\"21:2518\";i:2824;s:7:\"21:2519\";i:2825;s:7:\"21:2520\";i:2826;s:7:\"21:2521\";i:2827;s:7:\"21:2522\";i:2828;s:7:\"21:2523\";i:2829;s:7:\"21:2524\";i:2830;s:7:\"21:2525\";i:2831;s:7:\"21:2526\";i:2832;s:7:\"21:2527\";i:2833;s:7:\"21:2528\";i:2834;s:7:\"21:2529\";i:2835;s:7:\"21:2530\";i:2836;s:7:\"21:2531\";i:2837;s:7:\"21:2532\";i:2838;s:7:\"21:2533\";i:2839;s:7:\"21:2534\";i:2840;s:7:\"21:2535\";i:2841;s:7:\"21:2536\";i:2842;s:7:\"21:2537\";i:2843;s:7:\"21:2538\";i:2844;s:7:\"21:2539\";i:2845;s:7:\"21:2540\";i:2846;s:7:\"21:2541\";i:2847;s:7:\"21:2542\";i:2848;s:7:\"21:2543\";i:2849;s:7:\"21:2544\";i:2850;s:7:\"21:2545\";i:2851;s:7:\"21:2546\";i:2852;s:7:\"21:2547\";i:2853;s:7:\"21:2548\";i:2854;s:7:\"21:2549\";i:2855;s:7:\"21:2550\";i:2856;s:7:\"21:2551\";i:2857;s:7:\"21:2552\";i:2858;s:7:\"21:2553\";i:2859;s:7:\"21:2554\";i:2860;s:7:\"21:2555\";i:2861;s:7:\"21:2556\";i:2862;s:7:\"21:2557\";i:2863;s:7:\"21:2558\";i:2864;s:7:\"21:2559\";i:2865;s:7:\"21:2560\";i:2866;s:7:\"21:2561\";i:2867;s:7:\"21:2562\";i:2868;s:7:\"21:2563\";i:2869;s:7:\"21:2564\";i:2870;s:7:\"21:2565\";i:2871;s:7:\"21:2566\";i:2872;s:7:\"21:2567\";i:2873;s:7:\"21:2568\";i:2874;s:7:\"21:2569\";i:2875;s:7:\"21:2570\";i:2876;s:7:\"21:2571\";i:2877;s:7:\"21:2572\";i:2878;s:7:\"21:2573\";i:2879;s:7:\"21:2574\";i:2880;s:7:\"21:2575\";i:2881;s:7:\"21:2576\";i:2882;s:7:\"21:2577\";i:2883;s:7:\"21:2578\";i:2884;s:7:\"21:2579\";i:2885;s:7:\"21:2580\";i:2886;s:7:\"21:2581\";i:2887;s:7:\"21:2582\";i:2888;s:7:\"21:2583\";i:2889;s:7:\"21:2584\";i:2890;s:7:\"21:2585\";i:2891;s:7:\"21:2586\";i:2892;s:7:\"21:2587\";i:2893;s:7:\"21:2588\";i:2894;s:7:\"21:2589\";i:2895;s:7:\"21:2590\";i:2896;s:7:\"21:2591\";i:2897;s:7:\"21:2592\";i:2898;s:7:\"21:2593\";i:2899;s:7:\"21:2594\";i:2900;s:7:\"21:2595\";i:2901;s:7:\"21:2596\";i:2902;s:7:\"21:2597\";i:2903;s:7:\"21:2598\";i:2904;s:7:\"21:2599\";i:2905;s:7:\"22:2600\";i:2906;s:7:\"22:2601\";i:2907;s:7:\"22:2602\";i:2908;s:7:\"22:2603\";i:2909;s:7:\"22:2604\";i:2910;s:7:\"22:2605\";i:2911;s:7:\"22:2606\";i:2912;s:7:\"22:2607\";i:2913;s:7:\"23:2608\";i:2914;s:7:\"23:2609\";i:2915;s:7:\"23:2610\";i:2916;s:7:\"23:2611\";i:2917;s:7:\"21:2612\";i:2918;s:7:\"21:2613\";i:2919;s:7:\"21:2611\";i:2920;s:7:\"21:2614\";i:2921;s:7:\"21:2615\";i:2922;s:7:\"21:2616\";i:2923;s:7:\"21:2617\";i:2924;s:7:\"21:2618\";i:2925;s:7:\"21:2619\";i:2926;s:7:\"21:2620\";i:2927;s:7:\"21:2621\";i:2928;s:7:\"21:2622\";i:2929;s:7:\"21:2623\";i:2930;s:7:\"21:2624\";i:2931;s:7:\"21:2625\";i:2932;s:7:\"21:2626\";i:2933;s:7:\"21:2627\";i:2934;s:7:\"21:2628\";i:2935;s:7:\"21:2629\";i:2936;s:7:\"21:2630\";i:2937;s:7:\"21:2631\";i:2938;s:7:\"21:2632\";i:2939;s:7:\"21:2633\";i:2940;s:7:\"21:2634\";i:2941;s:7:\"21:2635\";i:2942;s:7:\"21:2636\";i:2943;s:7:\"21:2608\";i:2944;s:7:\"21:2637\";i:2945;s:7:\"21:2638\";i:2946;s:7:\"21:2639\";i:2947;s:7:\"21:2640\";i:2948;s:7:\"21:2641\";i:2949;s:7:\"21:2609\";i:2950;s:7:\"21:2642\";i:2951;s:7:\"21:2643\";i:2952;s:7:\"21:2610\";i:2953;s:7:\"21:2644\";i:2954;s:7:\"21:2645\";i:2955;s:7:\"21:2646\";i:2956;s:7:\"21:2647\";i:2957;s:7:\"21:2648\";i:2958;s:7:\"21:2649\";i:2959;s:7:\"21:2650\";i:2960;s:7:\"21:2651\";i:2961;s:7:\"21:2652\";i:2962;s:7:\"21:2653\";i:2963;s:7:\"21:2654\";i:2964;s:7:\"21:2655\";i:2965;s:7:\"21:2656\";i:2966;s:7:\"21:2657\";i:2967;s:7:\"21:2658\";i:2968;s:7:\"21:2659\";i:2969;s:7:\"21:2660\";i:2970;s:7:\"21:2661\";i:2971;s:7:\"21:2662\";i:2972;s:7:\"21:2663\";i:2973;s:7:\"21:2664\";i:2974;s:7:\"21:2665\";i:2975;s:7:\"21:2666\";i:2976;s:7:\"21:2667\";i:2977;s:7:\"21:2668\";i:2978;s:7:\"21:2669\";i:2979;s:7:\"21:2670\";i:2980;s:7:\"21:2671\";i:2981;s:7:\"21:2672\";i:2982;s:7:\"21:2673\";i:2983;s:7:\"21:2674\";i:2984;s:7:\"21:2675\";i:2985;s:7:\"21:2676\";i:2986;s:7:\"21:2677\";i:2987;s:7:\"21:2678\";i:2988;s:7:\"21:2679\";i:2989;s:7:\"21:2680\";i:2990;s:7:\"21:2681\";i:2991;s:7:\"21:2682\";i:2992;s:7:\"21:2683\";i:2993;s:7:\"21:2684\";i:2994;s:7:\"21:2685\";i:2995;s:7:\"21:2686\";i:2996;s:7:\"21:2687\";i:2997;s:7:\"21:2688\";i:2998;s:7:\"21:2689\";i:2999;s:7:\"21:2690\";i:3000;s:7:\"21:2691\";i:3001;s:7:\"21:2692\";i:3002;s:7:\"21:2693\";i:3003;s:7:\"21:2694\";i:3004;s:7:\"21:2695\";i:3005;s:7:\"21:2696\";i:3006;s:7:\"21:2697\";i:3007;s:7:\"21:2698\";i:3008;s:7:\"21:2699\";i:3009;s:7:\"21:2700\";i:3010;s:7:\"21:2701\";i:3011;s:7:\"21:2702\";i:3012;s:7:\"21:2703\";i:3013;s:7:\"21:2704\";i:3014;s:7:\"21:2705\";i:3015;s:7:\"21:2706\";i:3016;s:7:\"21:2707\";i:3017;s:7:\"21:2708\";i:3018;s:7:\"21:2709\";i:3019;s:7:\"21:2710\";i:3020;s:7:\"21:2711\";i:3021;s:7:\"21:2712\";i:3022;s:7:\"21:2713\";i:3023;s:7:\"21:2714\";i:3024;s:7:\"21:2715\";i:3025;s:7:\"21:2716\";i:3026;s:7:\"21:2717\";i:3027;s:7:\"21:2718\";i:3028;s:7:\"21:2719\";i:3029;s:7:\"21:2720\";i:3030;s:7:\"21:2721\";i:3031;s:7:\"21:2722\";i:3032;s:7:\"21:2723\";i:3033;s:7:\"21:2724\";i:3034;s:7:\"21:2725\";i:3035;s:7:\"21:2726\";i:3036;s:7:\"21:2727\";i:3037;s:7:\"21:2728\";i:3038;s:7:\"21:2729\";i:3039;s:7:\"21:2730\";i:3040;s:7:\"21:2731\";i:3041;s:7:\"21:2732\";i:3042;s:7:\"21:2733\";i:3043;s:7:\"21:2734\";i:3044;s:7:\"21:2735\";i:3045;s:7:\"21:2736\";}", "no");
INSERT INTO `wp_options` VALUES("482", "chld_thm_cfg_options_dict_sel", "a:2736:{i:1;s:24:\".error404 .cherry-search\";i:2;s:30:\".tm-pg_front_gallery-tabs li a\";i:3;s:28:\".tm-pg_front_gallery-tabs li\";i:4;s:25:\".tm-pg_front_gallery-tabs\";i:5;s:44:\".tm-pg_front_gallery .load-more-button a.btn\";i:6;s:160:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_meta, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_meta, .tm-pg_front_gallery-justify .tm_pg_gallery-item_meta\";i:7;s:211:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_icon.tm_pg_image-icon, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_icon.tm_pg_image-icon, .tm-pg_front_gallery-justify .tm_pg_gallery-item_icon.tm_pg_image-icon\";i:8;s:20:\".tm-pg_front_gallery\";i:9;s:63:\".booked-calendar-wrap .booked-calendar tbody tr.week td .number\";i:10;s:55:\".booked-calendar-wrap .booked-calendar thead tr.days th\";i:11;s:50:\".booked-calendar-wrap .booked-calendar thead tr th\";i:12;s:87:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td .number\";i:13;s:79:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead tr.days th\";i:14;s:36:\"#tm_builder_outer_content .tm_pb_map\";i:15;s:42:\".home #tm_builder_outer_content .tm_pb_map\";i:16;s:73:\"#tm_builder_outer_content .tm_pb_cherry_team .template-default .team-item\";i:17;s:109:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .title_wrap\";i:18;s:94:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services .services-item .title_wrap a\";i:19;s:69:\"#tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm_pb_button\";i:20;s:55:\"#tm_builder_outer_content .tm_pb_link_box .desc_linkbox\";i:21;s:45:\"#tm_builder_outer_content .tm_pb_button:hover\";i:22;s:39:\"#tm_builder_outer_content .tm_pb_button\";i:23;s:85:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module .tm_pb_testimonial_portrait\";i:24;s:65:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module::before\";i:25;s:217:\"#tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_close .tm_pb_toggle_title, #tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_title\";i:26;s:233:\"#tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_close .tm_pb_toggle_title::before, #tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_title::before\";i:27;s:74:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle .tm_pb_toggle_content\";i:28;s:183:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_close .tm_pb_toggle_title, #tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_title\";i:29;s:199:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_close .tm_pb_toggle_title::before, #tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_title::before\";i:30;s:48:\"#tm_builder_outer_content .tm-pb-contact-message\";i:31;s:73:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content\";i:32;s:66:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs\";i:33;s:94:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs\";i:34;s:74:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li\";i:35;s:102:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li\";i:36;s:71:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls\";i:37;s:157:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls:before, #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls:after\";i:38;s:63:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .entry-title\";i:39;s:58:\"#tm_builder_outer_content .tm_pb_slider .tm-pb-controllers\";i:40;s:130:\"#tm_builder_outer_content .tm_pb_slider .tm-pb-arrow-prev:before, #tm_builder_outer_content .tm_pb_slider .tm-pb-arrow-next:before\";i:41;s:116:\"#tm_builder_outer_content .tm_pb_slider .tm-pb-arrow-prev, #tm_builder_outer_content .tm_pb_slider .tm-pb-arrow-next\";i:42;s:54:\"#tm_builder_outer_content .tm_pb_slider .button_invert\";i:43;s:109:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_button, #tm_builder_outer_content .tm_pb_slider .button_invert\";i:44;s:67:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_description h1\";i:45;s:67:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_description h2\";i:46;s:64:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_description\";i:47;s:31:\".widget-area .widget:last-child\";i:48;s:20:\".footer-area .widget\";i:49;s:17:\".widget + .widget\";i:50;s:33:\".site-footer.minimal .social-list\";i:51;s:33:\".site-footer.default .social-list\";i:52;s:36:\".site-info__flex .site-info__mid-box\";i:53;s:29:\".site-info__flex .social-list\";i:54;s:16:\".site-info__flex\";i:55;s:17:\".footer-area-wrap\";i:56;s:17:\".footer-container\";i:57;s:48:\".post-gallery .material-icons, .post-gallery .fa\";i:58;s:54:\".post-gallery__button-next, .post-gallery__button-prev\";i:59;s:13:\".post__cats a\";i:60;s:54:\".posts-list .entry-summary, .posts-list .entry-content\";i:61;s:62:\".entry-summary p strong > span, .entry-content p strong > span\";i:62;s:50:\".posts-list--vertical-justify .hentry:nth-child(2)\";i:63;s:45:\".posts-list--grid-2-cols .hentry:nth-child(2)\";i:64;s:37:\".posts-list .hentry:not(:first-child)\";i:65;s:23:\".top-panel .social-list\";i:66;s:16:\".top-panel__menu\";i:67;s:18:\".top-panel__search\";i:68;s:19:\".top-panel__message\";i:69;s:56:\".top-panel .top_panel_head, .top-panel .top_panel_bottom\";i:70;s:37:\".site-header.transparent .btn.booking\";i:71;s:41:\".site-header.transparent .main-navigation\";i:72;s:39:\".site-header.transparent .site-branding\";i:73;s:33:\".site-header.minimal .btn.booking\";i:74;s:37:\".site-header.minimal .main-navigation\";i:75;s:35:\".site-header.minimal .site-branding\";i:76;s:38:\".site-header.centered .main-navigation\";i:77;s:36:\".site-header.centered .site-branding\";i:78;s:33:\".site-header.default .btn.booking\";i:79;s:37:\".site-header.default .main-navigation\";i:80;s:35:\".site-header.default .site-branding\";i:81;s:38:\".site-header.default .header-container\";i:82;s:18:\".pseudoStickyBlock\";i:83;s:17:\".header-container\";i:84;s:25:\".header-container.isStuck\";i:85;s:29:\".posts-list--vertical-justify\";i:86;s:35:\".posts-list--vertical-justify .card\";i:87;s:108:\".posts-list--vertical-justify .card:nth-child(7n + 1), .posts-list--vertical-justify .card:nth-child(7n + 4)\";i:88;s:13:\".card-columns\";i:89;s:19:\".card-columns .card\";i:90;s:27:\".posts-list--masonry-2-cols\";i:91;s:27:\".posts-list--masonry-3-cols\";i:92;s:10:\".card-deck\";i:93;s:16:\".card-deck .card\";i:94;s:29:\".home .card-deck .card.sticky\";i:95;s:30:\".posts-list--grid-2-cols .card\";i:96;s:30:\".posts-list--grid-3-cols .card\";i:97;s:23:\".blog .share-btns__item\";i:98;s:25:\".hentry .share-btns__list\";i:99;s:23:\".social-list .menu-item\";i:100;s:118:\".pagination .page-links a, .pagination .page-links > .page-links__item, .page-links a, .page-links > .page-links__item\";i:101;s:30:\".pagination .page-numbers.next\";i:102;s:66:\".pagination .page-numbers.next i, .pagination .page-numbers.prev i\";i:103;s:62:\".pagination .page-numbers.next, .pagination .page-numbers.prev\";i:104;s:25:\".pagination .page-numbers\";i:105;s:98:\".comment-navigation .nav-next > a, .posts-navigation .nav-next > a, .post-navigation .nav-next > a\";i:106;s:110:\".comment-navigation .nav-previous > a, .posts-navigation .nav-previous > a, .post-navigation .nav-previous > a\";i:107;s:240:\".comment-navigation .nav-previous a:before, .comment-navigation .nav-next a:before, .posts-navigation .nav-previous a:before, .posts-navigation .nav-next a:before, .post-navigation .nav-previous a:before, .post-navigation .nav-next a:before\";i:108;s:186:\".comment-navigation .nav-previous, .comment-navigation .nav-next, .posts-navigation .nav-previous, .posts-navigation .nav-next, .post-navigation .nav-previous, .post-navigation .nav-next\";i:109;s:89:\".comment-navigation .nav-links, .posts-navigation .nav-links, .post-navigation .nav-links\";i:110;s:24:\".main-navigation.isStuck\";i:111;s:64:\".main-navigation.isStuck li.menu-item-has-children > ul.sub-menu\";i:112;s:33:\".menu > li > a > .menu-item__desc\";i:113;s:34:\".main-navigation .menu > li::after\";i:114;s:56:\".main-navigation li.menu-item-has-children > ul.sub-menu\";i:115;s:28:\".main-navigation .sub-menu a\";i:116;s:46:\".main-navigation .sub-menu li:last-of-type > a\";i:117;s:31:\".main-navigation .menu > li > a\";i:118;s:33:\".main-navigation .sub-menu:before\";i:119;s:36:\".main-navigation .sub-menu .sub-menu\";i:120;s:29:\".main-navigation .sub-menu ul\";i:121;s:34:\".main-navigation .sub-menu.animate\";i:122;s:29:\".main-navigation .menu-toggle\";i:123;s:49:\".header-layout-minimal .main-navigation .sub-menu\";i:124;s:56:\".header-layout-minimal .main-navigation .sub-menu:before\";i:125;s:49:\".header-layout-default .main-navigation .sub-menu\";i:126;s:56:\".header-layout-default .main-navigation .sub-menu:before\";i:127;s:50:\".header-layout-centered .main-navigation .sub-menu\";i:128;s:57:\".header-layout-centered .main-navigation .sub-menu:before\";i:129;s:19:\".main-navigation ul\";i:130;s:35:\".main-navigation li.menu-hover > ul\";i:131;s:38:\".main-navigation li li.menu-hover > ul\";i:132;s:48:\".main-navigation li li.menu-hover > ul.left-side\";i:133;s:22:\".main-navigation .menu\";i:134;s:31:\".default .main-navigation .menu\";i:135;s:27:\".main-navigation .menu > li\";i:136;s:36:\".default .main-navigation .menu > li\";i:137;s:26:\".main-navigation .sub-menu\";i:138;s:53:\".header-layout-transparent .main-navigation .sub-menu\";i:139;s:23:\".top-panel .search-form\";i:140;s:4:\".btn\";i:141;s:71:\"button, input[type=\'button\'], input[type=\'reset\'], input[type=\'submit\']\";i:142;s:6:\"#toTop\";i:143;s:41:\".post_format-post-format-quote blockquote\";i:144;s:23:\".single-post blockquote\";i:145;s:10:\"blockquote\";i:146;s:11:\".col-md-top\";i:147;s:14:\".col-md-center\";i:148;s:14:\".col-md-bottom\";i:149;s:11:\".row-md-top\";i:150;s:14:\".row-md-center\";i:151;s:14:\".row-md-bottom\";i:152;s:13:\".col-md-first\";i:153;s:12:\".col-md-last\";i:154;s:9:\".col-md-1\";i:155;s:9:\".col-md-2\";i:156;s:9:\".col-md-3\";i:157;s:9:\".col-md-4\";i:158;s:9:\".col-md-5\";i:159;s:9:\".col-md-6\";i:160;s:9:\".col-md-7\";i:161;s:9:\".col-md-8\";i:162;s:9:\".col-md-9\";i:163;s:10:\".col-md-10\";i:164;s:10:\".col-md-11\";i:165;s:10:\".col-md-12\";i:166;s:14:\".col-md-pull-0\";i:167;s:14:\".col-md-pull-1\";i:168;s:14:\".col-md-pull-2\";i:169;s:14:\".col-md-pull-3\";i:170;s:14:\".col-md-pull-4\";i:171;s:14:\".col-md-pull-5\";i:172;s:14:\".col-md-pull-6\";i:173;s:14:\".col-md-pull-7\";i:174;s:14:\".col-md-pull-8\";i:175;s:14:\".col-md-pull-9\";i:176;s:15:\".col-md-pull-10\";i:177;s:15:\".col-md-pull-11\";i:178;s:15:\".col-md-pull-12\";i:179;s:14:\".col-md-push-0\";i:180;s:14:\".col-md-push-1\";i:181;s:14:\".col-md-push-2\";i:182;s:14:\".col-md-push-3\";i:183;s:14:\".col-md-push-4\";i:184;s:14:\".col-md-push-5\";i:185;s:14:\".col-md-push-6\";i:186;s:14:\".col-md-push-7\";i:187;s:14:\".col-md-push-8\";i:188;s:14:\".col-md-push-9\";i:189;s:15:\".col-md-push-10\";i:190;s:15:\".col-md-push-11\";i:191;s:15:\".col-md-push-12\";i:192;s:16:\".col-md-offset-0\";i:193;s:16:\".col-md-offset-1\";i:194;s:16:\".col-md-offset-2\";i:195;s:16:\".col-md-offset-3\";i:196;s:16:\".col-md-offset-4\";i:197;s:16:\".col-md-offset-5\";i:198;s:16:\".col-md-offset-6\";i:199;s:16:\".col-md-offset-7\";i:200;s:16:\".col-md-offset-8\";i:201;s:16:\".col-md-offset-9\";i:202;s:17:\".col-md-offset-10\";i:203;s:17:\".col-md-offset-11\";i:204;s:17:\".col-md-offset-12\";i:205;s:673:\".col-xs-1, .col-xs-2, .col-xs-3, .col-xs-4, .col-xs-5, .col-xs-6, .col-xs-7, .col-xs-8, .col-xs-9, .col-xs-10, .col-xs-11, .col-xs-12, .col-sm-1, .col-sm-2, .col-sm-3, .col-sm-4, .col-sm-5, .col-sm-6, .col-sm-7, .col-sm-8, .col-sm-9, .col-sm-10, .col-sm-11, .col-sm-12, .col-md-1, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9, .col-md-10, .col-md-11, .col-md-12, .col-lg-1, .col-lg-2, .col-lg-3, .col-lg-4, .col-lg-5, .col-lg-6, .col-lg-7, .col-lg-8, .col-lg-9, .col-lg-10, .col-lg-11, .col-lg-12, .col-xl-1, .col-xl-2, .col-xl-3, .col-xl-4, .col-xl-5, .col-xl-6, .col-xl-7, .col-xl-8, .col-xl-9, .col-xl-10, .col-xl-11, .col-xl-12\";i:206;s:4:\".row\";i:207;s:16:\".container-fluid\";i:208;s:10:\".container\";i:209;s:145:\".widget-area .cherry-search form.cherry-search__form button.search-submit, .error404 .cherry-search form.cherry-search__form button.search-submit\";i:210;s:104:\".sidebar.widget-area .widget_recent_entries ul li.event, .footer-area .widget_recent_entries ul li.event\";i:211;s:118:\".sidebar.widget-area .widget_recent_entries ul li.event:before, .footer-area .widget_recent_entries ul li.event:before\";i:212;s:100:\".mptt-shortcode-wrapper table.mptt-shortcode-table thead tr.mptt-shortcode-row th:first-child:before\";i:213;s:81:\".mptt-shortcode-wrapper table.mptt-shortcode-table thead tr.mptt-shortcode-row th\";i:214;s:50:\".mptt-shortcode-wrapper table.mptt-shortcode-table\";i:215;s:47:\".mptt-shortcode-wrapper .mptt-navigation-select\";i:216;s:62:\".booked-calendar-wrap .booked-calendar tbody tr.week td.active\";i:217;s:55:\".booked-calendar-wrap .booked-calendar tbody tr.week td\";i:218;s:79:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td\";i:219;s:74:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead tr th\";i:220;s:36:\"#tm_builder_outer_content .tm_pb_cta\";i:221;s:56:\".cherry-services .template-single .cta_wrap .service-cta\";i:222;s:95:\".cherry-services .template-single .features_wrap .service-features .service-features_row:before\";i:223;s:112:\".cherry-services .template-single .features_wrap .service-features .service-features_row .service-features_label\";i:224;s:88:\".cherry-services .template-single .features_wrap .service-features .service-features_row\";i:225;s:66:\".cherry-services .template-single .features_wrap .service-features\";i:226;s:48:\".cherry-services .template-single .service-descr\";i:227;s:49:\".cherry-services .template-single .service-slogan\";i:228;s:111:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .content_wrap\";i:229;s:107:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module .tm_pb_countdown_timer_container .section.sep\";i:230;s:117:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module .tm_pb_countdown_timer_container .section.values .value\";i:231;s:102:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module.tm_pb_countdown_timer_circle_layout .sep\";i:232;s:112:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module.tm_pb_countdown_timer_circle_layout .values .value\";i:233;s:61:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module\";i:234;s:94:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module .tm_pb_testimonial_description_inner\";i:235;s:63:\"#tm_builder_outer_content .tm_pb_number_counter.tm_pb_module h3\";i:236;s:76:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li a\";i:237;s:104:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li a\";i:238;s:83:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li a:before\";i:239;s:100:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module.tm_pb_blurb_position_top .tm_pb_main_blurb_image\";i:240;s:77:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module .tm_pb_blurb_container h4\";i:241;s:79:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_1 .tm_pb_slide_description\";i:242;s:85:\".home #tm_builder_outer_content .tm_pb_slider .tm_pb_slide_1 .tm_pb_slide_description\";i:243;s:79:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_0 .tm_pb_slide_description\";i:244;s:85:\".home #tm_builder_outer_content .tm_pb_slider .tm_pb_slide_0 .tm_pb_slide_description\";i:245;s:38:\"#tm_builder_outer_content blockquote p\";i:246;s:43:\"#tm_builder_outer_content blockquote:before\";i:247;s:47:\".after-content-full-width-area .subscribe-block\";i:248;s:56:\".sidebar .subscribe-block, .footer-area .subscribe-block\";i:249;s:63:\".after-content-full-width-area .follow-block + .subscribe-block\";i:250;s:32:\".follow-block + .subscribe-block\";i:251;s:44:\".after-content-full-width-area .follow-block\";i:252;s:50:\".sidebar .follow-block, .footer-area .follow-block\";i:253;s:69:\".after-content-full-width-area .widget.widget-subscribe .widget-title\";i:254;s:21:\".about-author_btn_box\";i:255;s:97:\".full-width-header-area .widget-about-author, .after-content-full-width-area .widget-about-author\";i:256;s:13:\".widget-title\";i:257;s:39:\".error404 #primary .error-404.not-found\";i:258;s:26:\".not-found .page-content p\";i:259;s:22:\".not-found .page-title\";i:260;s:10:\".not-found\";i:261;s:48:\".format-video .post-featured-content .post__cats\";i:262;s:26:\".post-gallery__button-next\";i:263;s:26:\".post-gallery__button-prev\";i:264;s:13:\".post-gallery\";i:265;s:37:\".post.format-audio .post-format-audio\";i:266;s:92:\".posts-list--grid-2-cols .sticky .entry-title, .posts-list--grid-3-cols .sticky .entry-title\";i:267;s:117:\".sticky.posts-list__item .btn__icon, .sticky.posts-list__item .btn .material-icons, .sticky.posts-list__item .btn .fa\";i:268;s:412:\".posts-list--masonry-2-cols .sticky.posts-list__item .btn__icon, .posts-list--masonry-3-cols .sticky.posts-list__item .btn__icon, .posts-list--masonry-2-cols\n  .sticky.posts-list__item .btn .material-icons, .posts-list--masonry-3-cols\n  .sticky.posts-list__item .btn .material-icons, .posts-list--masonry-2-cols\n  .sticky.posts-list__item .btn .fa, .posts-list--masonry-3-cols\n  .sticky.posts-list__item .btn .fa\";i:269;s:35:\".sticky.posts-list__item .btn__text\";i:270;s:128:\".posts-list--masonry-2-cols .sticky.posts-list__item .btn__text, .posts-list--masonry-3-cols .sticky.posts-list__item .btn__text\";i:271;s:110:\".posts-list--grid-2-cols .sticky.posts-list__item .btn, .posts-list--grid-3-cols .sticky.posts-list__item .btn\";i:272;s:43:\".two-sidebars .sticky.posts-list__item .btn\";i:273;s:34:\".has-post-thumbnail .sticky__label\";i:274;s:216:\".posts-list--default:not(.two-sidebars) .posts-list__item .btn__icon, .posts-list--default:not(.two-sidebars) .posts-list__item .btn .material-icons, .posts-list--default:not(.two-sidebars) .posts-list__item .btn .fa\";i:275;s:68:\".posts-list--default:not(.two-sidebars) .posts-list__item .btn__text\";i:276;s:62:\".posts-list--default:not(.two-sidebars) .posts-list__item .btn\";i:277;s:96:\".posts-list__item .btn__icon, .posts-list__item .btn .material-icons, .posts-list__item .btn .fa\";i:278;s:29:\".post-format-wrap .post__cats\";i:279;s:60:\".has-post-thumbnail .post-thumbnail--fullwidth + .post__cats\";i:280;s:352:\".posts-list--grid-3-cols .has-post-thumbnail .post-thumbnail--fullwidth + .post__cats, .posts-list--grid-2-cols .has-post-thumbnail .post-thumbnail--fullwidth + .post__cats, .posts-list--masonry-2-cols .has-post-thumbnail .post-thumbnail--fullwidth + .post__cats, .posts-list--masonry-3-cols .has-post-thumbnail .post-thumbnail--fullwidth + .post__cats\";i:281;s:38:\".posts-list .post-thumbnail--fullwidth\";i:282;s:43:\".post-thumbnail__link.post-thumbnail--small\";i:283;s:33:\".posts-list--default .entry-title\";i:284;s:15:\".single .hentry\";i:285;s:92:\".posts-list--grid-3-cols .hentry:nth-child(2), .posts-list--grid-3-cols .hentry:nth-child(3)\";i:286;s:31:\".top-panel__message .info-block\";i:287;s:48:\".site-header.transparent .header-container__flex\";i:288;s:23:\".header-container__flex\";i:289;s:19:\".post-author__title\";i:290;s:17:\".comment-body .fn\";i:291;s:21:\".comment-body .avatar\";i:292;s:13:\".comment-body\";i:293;s:13:\".comment-wrap\";i:294;s:23:\".comment-list .children\";i:295;s:14:\".comments-area\";i:296;s:18:\".breadcrumbs__wrap\";i:297;s:20:\".comment-reply-title\";i:298;s:17:\"blockquote:before\";i:299;s:11:\".col-lg-top\";i:300;s:14:\".col-lg-center\";i:301;s:14:\".col-lg-bottom\";i:302;s:11:\".row-lg-top\";i:303;s:14:\".row-lg-center\";i:304;s:14:\".row-lg-bottom\";i:305;s:13:\".col-lg-first\";i:306;s:12:\".col-lg-last\";i:307;s:9:\".col-lg-1\";i:308;s:9:\".col-lg-2\";i:309;s:9:\".col-lg-3\";i:310;s:9:\".col-lg-4\";i:311;s:9:\".col-lg-5\";i:312;s:9:\".col-lg-6\";i:313;s:9:\".col-lg-7\";i:314;s:9:\".col-lg-8\";i:315;s:9:\".col-lg-9\";i:316;s:10:\".col-lg-10\";i:317;s:10:\".col-lg-11\";i:318;s:10:\".col-lg-12\";i:319;s:14:\".col-lg-pull-0\";i:320;s:14:\".col-lg-pull-1\";i:321;s:14:\".col-lg-pull-2\";i:322;s:14:\".col-lg-pull-3\";i:323;s:14:\".col-lg-pull-4\";i:324;s:14:\".col-lg-pull-5\";i:325;s:14:\".col-lg-pull-6\";i:326;s:14:\".col-lg-pull-7\";i:327;s:14:\".col-lg-pull-8\";i:328;s:14:\".col-lg-pull-9\";i:329;s:15:\".col-lg-pull-10\";i:330;s:15:\".col-lg-pull-11\";i:331;s:15:\".col-lg-pull-12\";i:332;s:14:\".col-lg-push-0\";i:333;s:14:\".col-lg-push-1\";i:334;s:14:\".col-lg-push-2\";i:335;s:14:\".col-lg-push-3\";i:336;s:14:\".col-lg-push-4\";i:337;s:14:\".col-lg-push-5\";i:338;s:14:\".col-lg-push-6\";i:339;s:14:\".col-lg-push-7\";i:340;s:14:\".col-lg-push-8\";i:341;s:14:\".col-lg-push-9\";i:342;s:15:\".col-lg-push-10\";i:343;s:15:\".col-lg-push-11\";i:344;s:15:\".col-lg-push-12\";i:345;s:16:\".col-lg-offset-0\";i:346;s:16:\".col-lg-offset-1\";i:347;s:16:\".col-lg-offset-2\";i:348;s:16:\".col-lg-offset-3\";i:349;s:16:\".col-lg-offset-4\";i:350;s:16:\".col-lg-offset-5\";i:351;s:16:\".col-lg-offset-6\";i:352;s:16:\".col-lg-offset-7\";i:353;s:16:\".col-lg-offset-8\";i:354;s:16:\".col-lg-offset-9\";i:355;s:17:\".col-lg-offset-10\";i:356;s:17:\".col-lg-offset-11\";i:357;s:17:\".col-lg-offset-12\";i:358;s:181:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_description, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_description, .tm-pg_front_gallery-justify .tm_pg_gallery-item_description\";i:359;s:163:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_title, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_title, .tm-pg_front_gallery-justify .tm_pg_gallery-item_title\";i:360;s:232:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_icon.tm_pg_image-icon:before, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_icon.tm_pg_image-icon:before, .tm-pg_front_gallery-justify .tm_pg_gallery-item_icon.tm_pg_image-icon:before\";i:361;s:44:\".booked-calendar-wrap .booked-calendar tbody\";i:362;s:52:\".booked-calendar-wrap .booked-calendar thead tr.days\";i:363;s:68:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody\";i:364;s:76:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead tr.days\";i:365;s:54:\".cherry-services .template-single .single_content_wrap\";i:366;s:102:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-listed-services .inner_wrap\";i:367;s:112:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-listed-services .services-item:before\";i:368;s:117:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module .tm_pb_countdown_timer_container .section.values .label\";i:369;s:81:\"#tm_builder_outer_content .tm_pb_team_member.tm_pb_module .tm_pb_team_member_name\";i:370;s:76:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content h2\";i:371;s:50:\"#tm_builder_outer_content .tm_pb_circle_counter h3\";i:372;s:69:\"#tm_builder_outer_content .tm_pb_number_counter.tm_pb_module .percent\";i:373;s:100:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module.tm_pb_blurb_position_left .tm_pb_blurb_container\";i:374;s:101:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module.tm_pb_blurb_position_left .tm_pb_main_blurb_image\";i:375;s:51:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module\";i:376;s:37:\".subscribe-block__input[type=\'email\']\";i:377;s:45:\".sidebar .widget-about .widget-about__content\";i:378;s:31:\".widget_recent_comments li + li\";i:379;s:24:\".widget_calendar caption\";i:380;s:31:\".widget_calendar .calendar_wrap\";i:381;s:33:\".site-footer.minimal .footer-menu\";i:382;s:34:\".site-footer.centered .footer-menu\";i:383;s:33:\".site-footer.default .footer-menu\";i:384;s:180:\".posts-list--grid-3-cols .post-format-link, .posts-list--grid-2-cols .post-format-link, .posts-list--masonry-2-cols .post-format-link, .posts-list--masonry-3-cols .post-format-link\";i:385;s:208:\".posts-list--grid-3-cols .post-format-link:before, .posts-list--grid-2-cols .post-format-link:before, .posts-list--masonry-2-cols .post-format-link:before, .posts-list--masonry-3-cols .post-format-link:before\";i:386;s:164:\".posts-list--grid-3-cols .post__cats a, .posts-list--grid-2-cols .post__cats a, .posts-list--masonry-2-cols .post__cats a, .posts-list--masonry-3-cols .post__cats a\";i:387;s:24:\".site-header.transparent\";i:388;s:34:\".site-header.centered .btn.booking\";i:389;s:39:\".site-header.centered .header-container\";i:390;s:28:\".post-author__avatar .avatar\";i:391;s:20:\".post-author__avatar\";i:392;s:20:\".post-author__holder\";i:393;s:11:\".col-xl-top\";i:394;s:14:\".col-xl-center\";i:395;s:14:\".col-xl-bottom\";i:396;s:11:\".row-xl-top\";i:397;s:14:\".row-xl-center\";i:398;s:14:\".row-xl-bottom\";i:399;s:13:\".col-xl-first\";i:400;s:12:\".col-xl-last\";i:401;s:9:\".col-xl-1\";i:402;s:9:\".col-xl-2\";i:403;s:9:\".col-xl-3\";i:404;s:9:\".col-xl-4\";i:405;s:9:\".col-xl-5\";i:406;s:9:\".col-xl-6\";i:407;s:9:\".col-xl-7\";i:408;s:9:\".col-xl-8\";i:409;s:9:\".col-xl-9\";i:410;s:10:\".col-xl-10\";i:411;s:10:\".col-xl-11\";i:412;s:10:\".col-xl-12\";i:413;s:14:\".col-xl-pull-0\";i:414;s:14:\".col-xl-pull-1\";i:415;s:14:\".col-xl-pull-2\";i:416;s:14:\".col-xl-pull-3\";i:417;s:14:\".col-xl-pull-4\";i:418;s:14:\".col-xl-pull-5\";i:419;s:14:\".col-xl-pull-6\";i:420;s:14:\".col-xl-pull-7\";i:421;s:14:\".col-xl-pull-8\";i:422;s:14:\".col-xl-pull-9\";i:423;s:15:\".col-xl-pull-10\";i:424;s:15:\".col-xl-pull-11\";i:425;s:15:\".col-xl-pull-12\";i:426;s:14:\".col-xl-push-0\";i:427;s:14:\".col-xl-push-1\";i:428;s:14:\".col-xl-push-2\";i:429;s:14:\".col-xl-push-3\";i:430;s:14:\".col-xl-push-4\";i:431;s:14:\".col-xl-push-5\";i:432;s:14:\".col-xl-push-6\";i:433;s:14:\".col-xl-push-7\";i:434;s:14:\".col-xl-push-8\";i:435;s:14:\".col-xl-push-9\";i:436;s:15:\".col-xl-push-10\";i:437;s:15:\".col-xl-push-11\";i:438;s:15:\".col-xl-push-12\";i:439;s:16:\".col-xl-offset-0\";i:440;s:16:\".col-xl-offset-1\";i:441;s:16:\".col-xl-offset-2\";i:442;s:16:\".col-xl-offset-3\";i:443;s:16:\".col-xl-offset-4\";i:444;s:16:\".col-xl-offset-5\";i:445;s:16:\".col-xl-offset-6\";i:446;s:16:\".col-xl-offset-7\";i:447;s:16:\".col-xl-offset-8\";i:448;s:16:\".col-xl-offset-9\";i:449;s:17:\".col-xl-offset-10\";i:450;s:17:\".col-xl-offset-11\";i:451;s:17:\".col-xl-offset-12\";i:452;s:85:\".single-team .team-single-item .team-meta .team-contact-info .team-macros span:before\";i:453;s:78:\".single-team .team-single-item .team-meta .team-contact-info .team-macros span\";i:454;s:73:\".single-team .team-single-item .team-meta .team-contact-info .team-macros\";i:455;s:30:\".single-team .team-single-item\";i:456;s:261:\".full-width-header-area .about-author_avatar, .after-content-full-width-area .about-author_avatar, .before-content-area .about-author_avatar, .before-loop-area .about-author_avatar, .after-content-area .about-author_avatar, .after-loop-area .about-author_avatar\";i:457;s:43:\".single .related-posts .post-thumbnail__img\";i:458;s:37:\".footer-menu__items .menu-item:before\";i:459;s:11:\".col-sm-top\";i:460;s:14:\".col-sm-center\";i:461;s:14:\".col-sm-bottom\";i:462;s:11:\".row-sm-top\";i:463;s:14:\".row-sm-center\";i:464;s:14:\".row-sm-bottom\";i:465;s:13:\".col-sm-first\";i:466;s:12:\".col-sm-last\";i:467;s:9:\".col-sm-1\";i:468;s:9:\".col-sm-2\";i:469;s:9:\".col-sm-3\";i:470;s:9:\".col-sm-4\";i:471;s:9:\".col-sm-5\";i:472;s:9:\".col-sm-6\";i:473;s:9:\".col-sm-7\";i:474;s:9:\".col-sm-8\";i:475;s:9:\".col-sm-9\";i:476;s:10:\".col-sm-10\";i:477;s:10:\".col-sm-11\";i:478;s:10:\".col-sm-12\";i:479;s:14:\".col-sm-pull-0\";i:480;s:14:\".col-sm-pull-1\";i:481;s:14:\".col-sm-pull-2\";i:482;s:14:\".col-sm-pull-3\";i:483;s:14:\".col-sm-pull-4\";i:484;s:14:\".col-sm-pull-5\";i:485;s:14:\".col-sm-pull-6\";i:486;s:14:\".col-sm-pull-7\";i:487;s:14:\".col-sm-pull-8\";i:488;s:14:\".col-sm-pull-9\";i:489;s:15:\".col-sm-pull-10\";i:490;s:15:\".col-sm-pull-11\";i:491;s:15:\".col-sm-pull-12\";i:492;s:14:\".col-sm-push-0\";i:493;s:14:\".col-sm-push-1\";i:494;s:14:\".col-sm-push-2\";i:495;s:14:\".col-sm-push-3\";i:496;s:14:\".col-sm-push-4\";i:497;s:14:\".col-sm-push-5\";i:498;s:14:\".col-sm-push-6\";i:499;s:14:\".col-sm-push-7\";i:500;s:14:\".col-sm-push-8\";i:501;s:14:\".col-sm-push-9\";i:502;s:15:\".col-sm-push-10\";i:503;s:15:\".col-sm-push-11\";i:504;s:15:\".col-sm-push-12\";i:505;s:16:\".col-sm-offset-0\";i:506;s:16:\".col-sm-offset-1\";i:507;s:16:\".col-sm-offset-2\";i:508;s:16:\".col-sm-offset-3\";i:509;s:16:\".col-sm-offset-4\";i:510;s:16:\".col-sm-offset-5\";i:511;s:16:\".col-sm-offset-6\";i:512;s:16:\".col-sm-offset-7\";i:513;s:16:\".col-sm-offset-8\";i:514;s:16:\".col-sm-offset-9\";i:515;s:17:\".col-sm-offset-10\";i:516;s:17:\".col-sm-offset-11\";i:517;s:17:\".col-sm-offset-12\";i:518;s:274:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_name, #tm_builder_outer_content .tm_pb_cherry_team .team-listing_position, #tm_builder_outer_content .tm_pb_cherry_team .team-listing_desc, #tm_builder_outer_content .tm_pb_cherry_team .team-listing .btn.btn-primary\";i:519;s:55:\"#tm_builder_outer_content .tm_pb_cherry_team .team-item\";i:520;s:64:\".content-layout-fullwidth #tm_builder_outer_content .tm_pb_video\";i:521;s:107:\".content-layout-fullwidth #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_blog_grid_wrapper > div\";i:522;s:357:\".content-layout-fullwidth #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_blog_grid_wrapper .tm_pb_post_content, .content-layout-fullwidth #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_blog_grid_wrapper .entry-title, .content-layout-fullwidth #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_blog_grid_wrapper .tm_pb_post_meta\";i:523;s:15:\".on-mobile-hide\";i:524;s:65:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image\";i:525;s:65:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_link_box_content\";i:526;s:44:\".main-navigation .menu > li .sub-menu-toggle\";i:527;s:24:\".main-navigation ul ul a\";i:528;s:27:\".main-navigation ul ul ul a\";i:529;s:30:\".main-navigation ul ul ul ul a\";i:530;s:33:\".main-navigation ul ul ul ul ul a\";i:531;s:36:\".main-navigation ul ul ul ul ul ul a\";i:532;s:27:\".main-navigation.toggled ul\";i:533;s:9:\".clear_bg\";i:534;s:36:\"body .booked-calendarSwitcher p i.fa\";i:535;s:38:\"#tm_builder_outer_content .info-box h2\";i:536;s:38:\"#tm_builder_outer_content .tm_pb_promo\";i:537;s:59:\".home #tm_builder_outer_content .tm_pb_promo_description h2\";i:538;s:94:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services .services-item .content_wrap\";i:539;s:81:\"#tm_builder_outer_content .tm_pb_audio_module.tm_pb_module .tm_pb_audio_cover_art\";i:540;s:86:\"#tm_builder_outer_content .tm_pb_audio_module.tm_pb_module .tm_pb_audio_module_content\";i:541;s:12:\".btn.booking\";i:542;s:24:\".posts-list--grid-3-cols\";i:543;s:91:\".posts-list--masonry-3-cols.one-left-sidebar, .posts-list--masonry-3-cols.one-right-sidebar\";i:544;s:103:\".posts-list--masonry-3-cols.one-left-sidebar .card, .posts-list--masonry-3-cols.one-right-sidebar .card\";i:545;s:77:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_table\";i:546;s:92:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_column_4_4 .tm_pb_pricing_table\";i:547;s:213:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls:before, .position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls:after\";i:548;s:28:\".posts-list__item .btn__text\";i:549;s:22:\".posts-list__item .btn\";i:550;s:108:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab h2\";i:551;s:80:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab h1\";i:552;s:89:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab .alignright\";i:553;s:88:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab .alignleft\";i:554;s:91:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab p:first-child\";i:555;s:20:\".cutom_width_circles\";i:556;s:88:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody .mptt-event-container .timeslot\";i:557;s:23:\".widget_booked_calendar\";i:558;s:68:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_cover_art\";i:559;s:98:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_table.tm_pb_featured_table\";i:560;s:91:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody .mptt-event-container .event-title\";i:561;s:4:\"html\";i:562;s:4:\"body\";i:563;s:94:\"article, aside, details, figcaption, figure, footer, header, main, menu, nav, section, summary\";i:564;s:30:\"audio, canvas, progress, video\";i:565;s:21:\"audio:not([controls])\";i:566;s:18:\"[hidden], template\";i:567;s:1:\"a\";i:568;s:17:\"a:active, a:hover\";i:569;s:11:\"abbr[title]\";i:570;s:9:\"b, strong\";i:571;s:3:\"dfn\";i:572;s:2:\"h1\";i:573;s:4:\"mark\";i:574;s:5:\"small\";i:575;s:8:\"sub, sup\";i:576;s:3:\"sup\";i:577;s:3:\"sub\";i:578;s:3:\"img\";i:579;s:14:\"svg:not(:root)\";i:580;s:6:\"figure\";i:581;s:2:\"hr\";i:582;s:3:\"pre\";i:583;s:20:\"code, kbd, pre, samp\";i:584;s:41:\"button, input, optgroup, select, textarea\";i:585;s:6:\"button\";i:586;s:14:\"button, select\";i:587;s:76:\"button, html input[type=\"button\"], input[type=\"reset\"], input[type=\"submit\"]\";i:588;s:38:\"button[disabled], html input[disabled]\";i:589;s:49:\"button::-moz-focus-inner, input::-moz-focus-inner\";i:590;s:5:\"input\";i:591;s:43:\"input[type=\"checkbox\"], input[type=\"radio\"]\";i:592;s:96:\"input[type=\"number\"]::-webkit-inner-spin-button, input[type=\"number\"]::-webkit-outer-spin-button\";i:593;s:20:\"input[type=\"search\"]\";i:594;s:99:\"input[type=\"search\"]::-webkit-search-cancel-button, input[type=\"search\"]::-webkit-search-decoration\";i:595;s:8:\"fieldset\";i:596;s:6:\"legend\";i:597;s:8:\"textarea\";i:598;s:8:\"optgroup\";i:599;s:5:\"table\";i:600;s:6:\"td, th\";i:601;s:57:\"#tm_builder_outer_content .tm_pb_text_align_left p strong\";i:602;s:2:\"h2\";i:603;s:6:\"h2 + p\";i:604;s:2:\"h3\";i:605;s:6:\"h3 + p\";i:606;s:2:\"h4\";i:607;s:6:\"h4 + p\";i:608;s:2:\"h5\";i:609;s:6:\"h5 + p\";i:610;s:2:\"h6\";i:611;s:6:\"h6 + p\";i:612;s:28:\"#tm_builder_outer_content h1\";i:613;s:1:\"p\";i:614;s:16:\"dfn, cite, em, i\";i:615;s:15:\"blockquote cite\";i:616;s:7:\"address\";i:617;s:18:\"code, kbd, tt, var\";i:618;s:4:\"code\";i:619;s:13:\"abbr, acronym\";i:620;s:9:\"mark, ins\";i:621;s:3:\"big\";i:622;s:28:\".row.tm_pb_col_padding_reset\";i:623;s:44:\".row.tm_pb_col_padding_reset > .tm_pb_column\";i:624;s:9:\".col-xs-1\";i:625;s:9:\".col-xs-2\";i:626;s:9:\".col-xs-3\";i:627;s:9:\".col-xs-4\";i:628;s:9:\".col-xs-5\";i:629;s:9:\".col-xs-6\";i:630;s:9:\".col-xs-7\";i:631;s:9:\".col-xs-8\";i:632;s:9:\".col-xs-9\";i:633;s:10:\".col-xs-10\";i:634;s:10:\".col-xs-11\";i:635;s:10:\".col-xs-12\";i:636;s:14:\".col-xs-pull-0\";i:637;s:14:\".col-xs-pull-1\";i:638;s:14:\".col-xs-pull-2\";i:639;s:14:\".col-xs-pull-3\";i:640;s:14:\".col-xs-pull-4\";i:641;s:14:\".col-xs-pull-5\";i:642;s:14:\".col-xs-pull-6\";i:643;s:14:\".col-xs-pull-7\";i:644;s:14:\".col-xs-pull-8\";i:645;s:14:\".col-xs-pull-9\";i:646;s:15:\".col-xs-pull-10\";i:647;s:15:\".col-xs-pull-11\";i:648;s:15:\".col-xs-pull-12\";i:649;s:14:\".col-xs-push-0\";i:650;s:14:\".col-xs-push-1\";i:651;s:14:\".col-xs-push-2\";i:652;s:14:\".col-xs-push-3\";i:653;s:14:\".col-xs-push-4\";i:654;s:14:\".col-xs-push-5\";i:655;s:14:\".col-xs-push-6\";i:656;s:14:\".col-xs-push-7\";i:657;s:14:\".col-xs-push-8\";i:658;s:14:\".col-xs-push-9\";i:659;s:15:\".col-xs-push-10\";i:660;s:15:\".col-xs-push-11\";i:661;s:15:\".col-xs-push-12\";i:662;s:16:\".col-xs-offset-0\";i:663;s:16:\".col-xs-offset-1\";i:664;s:16:\".col-xs-offset-2\";i:665;s:16:\".col-xs-offset-3\";i:666;s:16:\".col-xs-offset-4\";i:667;s:16:\".col-xs-offset-5\";i:668;s:16:\".col-xs-offset-6\";i:669;s:16:\".col-xs-offset-7\";i:670;s:16:\".col-xs-offset-8\";i:671;s:16:\".col-xs-offset-9\";i:672;s:17:\".col-xs-offset-10\";i:673;s:17:\".col-xs-offset-11\";i:674;s:17:\".col-xs-offset-12\";i:675;s:13:\".col-xs-first\";i:676;s:12:\".col-xs-last\";i:677;s:11:\".row-xs-top\";i:678;s:14:\".row-xs-center\";i:679;s:14:\".row-xs-bottom\";i:680;s:11:\".col-xs-top\";i:681;s:14:\".col-xs-center\";i:682;s:14:\".col-xs-bottom\";i:683;s:13:\"blockquote, q\";i:684;s:54:\"blockquote:before, blockquote:after, q:before, q:after\";i:685;s:23:\".widget-area blockquote\";i:686;s:28:\".widget-area blockquote cite\";i:687;s:30:\".widget-area blockquote:before\";i:688;s:29:\".blog blockquote .entry-title\";i:689;s:12:\"blockquote p\";i:690;s:16:\"blockquote p + p\";i:691;s:22:\"blockquote cite:before\";i:692;s:12:\"ul li, ol li\";i:693;s:36:\"ul li:first-child, ol li:first-child\";i:694;s:36:\".price-list ul li, .price-list ol li\";i:695;s:2:\"ol\";i:696;s:2:\"ul\";i:697;s:16:\"li > ul, li > ol\";i:698;s:2:\"dt\";i:699;s:2:\"dd\";i:700;s:12:\".inline-list\";i:701;s:15:\".inline-list li\";i:702;s:20:\".entry-content table\";i:703;s:48:\".entry-content table th, .entry-content table td\";i:704;s:29:\".entry-content table thead th\";i:705;s:34:\".entry-content table tbody + tbody\";i:706;s:15:\".page-preloader\";i:707;s:21:\".page-preloader-cover\";i:708;s:21:\".page-preloader__cube\";i:709;s:29:\".page-preloader__cube::before\";i:710;s:22:\".page-preloader--cube2\";i:711;s:30:\".page-preloader--cube2::before\";i:712;s:22:\".page-preloader--cube3\";i:713;s:30:\".page-preloader--cube3::before\";i:714;s:22:\".page-preloader--cube4\";i:715;s:30:\".page-preloader--cube4::before\";i:716;s:13:\"#toTop:before\";i:717;s:12:\"#toTop:focus\";i:718;s:10:\".btn:hover\";i:719;s:10:\".btn:focus\";i:720;s:14:\".btn-fullwidth\";i:721;s:340:\"input[type=\'text\'], input[type=\'email\'], input[type=\'url\'], input[type=\'password\'], input[type=\'search\'], input[type=\'number\'], input[type=\'tel\'], input[type=\'range\'], input[type=\'date\'], input[type=\'month\'], input[type=\'week\'], input[type=\'time\'], input[type=\'datetime\'], input[type=\'datetime-local\'], input[type=\'color\'], select, textarea\";i:722;s:442:\"input[type=\'text\']:focus, input[type=\'email\']:focus, input[type=\'url\']:focus, input[type=\'password\']:focus, input[type=\'search\']:focus, input[type=\'number\']:focus, input[type=\'tel\']:focus, input[type=\'range\']:focus, input[type=\'date\']:focus, input[type=\'month\']:focus, input[type=\'week\']:focus, input[type=\'time\']:focus, input[type=\'datetime\']:focus, input[type=\'datetime-local\']:focus, input[type=\'color\']:focus, select:focus, textarea:focus\";i:723;s:67:\"button:focus, input[type=\'submit\']:focus, input[type=\'reset\']:focus\";i:724;s:6:\"select\";i:725;s:18:\"::-moz-placeholder\";i:726;s:17:\":-moz-placeholder\";i:727;s:12:\".search-form\";i:728;s:18:\".search-form:after\";i:729;s:34:\".search-form__field[type=\'search\']\";i:730;s:45:\".top-panel .search-form__field[type=\'search\']\";i:731;s:51:\".top-panel .search-form__field[type=\'search\']:focus\";i:732;s:20:\".search-form__submit\";i:733;s:31:\".top-panel .search-form__submit\";i:734;s:37:\".search-form__submit i.material-icons\";i:735;s:48:\".top-panel .search-form__submit i.material-icons\";i:736;s:37:\".top-panel .search-form__submit:hover\";i:737;s:116:\".top-panel .search-form__submit:active, .top-panel .search-form__submit:focus, .top-panel .search-form__submit:hover\";i:738;s:83:\".comment-form-comment, .comment-form-author, .comment-form-email, .comment-form-url\";i:739;s:26:\".comment-form .form-submit\";i:740;s:20:\".comment-form__field\";i:741;s:34:\".comment-list .comment-form__field\";i:742;s:57:\".comment-form .logged-in-as, .comment-form .comment-notes\";i:743;s:27:\".comment-list .comment-form\";i:744;s:34:\".comment-form input[type=\'submit\']\";i:745;s:26:\"#cancel-comment-reply-link\";i:746;s:25:\".post-password-form label\";i:747;s:40:\".post-password-form input[type=\'submit\']\";i:748;s:7:\"a:focus\";i:749;s:17:\"a:hover, a:active\";i:750;s:34:\"h1 a, h2 a, h3 a, h4 a, h5 a, h6 a\";i:751;s:21:\".top-panel__menu-list\";i:752;s:32:\".top-panel__menu-list .menu-item\";i:753;s:34:\".top-panel__menu-list .menu-item a\";i:754;s:40:\".top-panel__menu-list .menu-item a:focus\";i:755;s:106:\".top-panel__menu-list .menu-item.current-menu-item a, .top-panel__menu-list .menu-item.current_page_item a\";i:756;s:16:\".main-navigation\";i:757;s:19:\".main-navigation li\";i:758;s:18:\".main-navigation a\";i:759;s:24:\".main-navigation a:focus\";i:760;s:134:\".main-navigation .menu > li.menu-item-has-children:not(.super-guacamole__menu-with-image):not(.super-guacamole__menu-with-icon)::after\";i:761;s:128:\".main-navigation .menu > li.super-guacamole__menu-with-image a, .main-navigation .menu > li.super-guacamole__menu-with-image img\";i:762;s:64:\".main-navigation .menu > li.super-guacamole__menu-with-image img\";i:763;s:42:\".main-navigation .menu > li:last-child > a\";i:764;s:254:\".main-navigation .menu > li.menu-hover > a, .main-navigation .menu > li.current_page_item > a, .main-navigation .menu > li.current_page_ancestor > a, .main-navigation .menu > li.current-menu-item > a, .main-navigation .menu > li.current-menu-ancestor > a\";i:765;s:35:\".main-navigation .menu > li[hidden]\";i:766;s:52:\".main-navigation .menu > li .sub-menu-toggle::before\";i:767;s:59:\".main-navigation .menu > li .sub-menu-toggle.active::before\";i:768;s:59:\".main-navigation > .menu > .menu-item > .sub-menu.left-side\";i:769;s:36:\".main-navigation .sub-menu.left-side\";i:770;s:59:\".main-navigation .sub-menu li.menu-item-has-children::after\";i:771;s:264:\".main-navigation .sub-menu li.menu-hover > a, .main-navigation .sub-menu li.current_page_item > a, .main-navigation .sub-menu li.current_page_ancestor > a, .main-navigation .sub-menu li.current-menu-item > a, .main-navigation .sub-menu li.current-menu-ancestor > a\";i:772;s:70:\".main-navigation li.menu-item-has-children.sub-menu-open > ul.sub-menu\";i:773;s:26:\".main-navigation li::after\";i:774;s:16:\".menu-item__desc\";i:775;s:12:\".menu-toggle\";i:776;s:34:\".toggled .menu-toggle__icon:before\";i:777;s:18:\".menu-toggle__icon\";i:778;s:25:\".menu-toggle__icon:before\";i:779;s:12:\".footer-menu\";i:780;s:19:\".footer-menu__items\";i:781;s:30:\".footer-menu__items .menu-item\";i:782;s:32:\".footer-menu__items .menu-item a\";i:783;s:56:\".comment-navigation, .posts-navigation, .post-navigation\";i:784;s:119:\".comment-navigation .nav-links .meta-nav, .posts-navigation .nav-links .meta-nav, .post-navigation .nav-links .meta-nav\";i:785;s:125:\".comment-navigation .nav-links .post-title, .posts-navigation .nav-links .post-title, .post-navigation .nav-links .post-title\";i:786;s:198:\".comment-navigation .nav-previous a, .comment-navigation .nav-next a, .posts-navigation .nav-previous a, .posts-navigation .nav-next a, .post-navigation .nav-previous a, .post-navigation .nav-next a\";i:787;s:98:\".comment-navigation .nav-previous, .posts-navigation .nav-previous, .post-navigation .nav-previous\";i:788;s:131:\".comment-navigation .nav-previous > a:before, .posts-navigation .nav-previous > a:before, .post-navigation .nav-previous > a:before\";i:789;s:86:\".comment-navigation .nav-next, .posts-navigation .nav-next, .post-navigation .nav-next\";i:790;s:119:\".comment-navigation .nav-next > a:before, .posts-navigation .nav-next > a:before, .post-navigation .nav-next > a:before\";i:791;s:11:\".pagination\";i:792;s:27:\".card-columns + .pagination\";i:793;s:31:\".pagination .page-numbers:focus\";i:794;s:30:\".pagination .page-numbers.dots\";i:795;s:36:\".pagination .page-links, .page-links\";i:796;s:50:\".pagination .page-links__title, .page-links__title\";i:797;s:40:\".pagination .page-links a, .page-links a\";i:798;s:12:\".breadcrumbs\";i:799;s:19:\".breadcrumbs__title\";i:800;s:31:\".breadcrumbs__title .page-title\";i:801;s:19:\".breadcrumbs__items\";i:802;s:20:\".breadcrumbs__browse\";i:803;s:18:\".breadcrumbs__item\";i:804;s:22:\".breadcrumbs__item-sep\";i:805;s:23:\".breadcrumbs__item-link\";i:806;s:35:\".social-list .menu-item:first-child\";i:807;s:31:\".social-list .menu-item::before\";i:808;s:27:\".social-list .menu-item > a\";i:809;s:33:\".social-list .menu-item > a:hover\";i:810;s:33:\".social-list .menu-item > a:focus\";i:811;s:55:\".social-list .menu-item > a[href*=\"codepen.io\"]::before\";i:812;s:53:\".social-list .menu-item > a[href*=\"digg.com\"]::before\";i:813;s:56:\".social-list .menu-item > a[href*=\"dropbox.com\"]::before\";i:814;s:55:\".social-list .menu-item > a[href*=\"flickr.com\"]::before\";i:815;s:55:\".social-list .menu-item > a[href*=\"github.com\"]::before\";i:816;s:58:\".social-list .menu-item > a[href*=\"pinterest.com\"]::before\";i:817;s:58:\".social-list .menu-item > a[href*=\"getpocket.com\"]::before\";i:818;s:55:\".social-list .menu-item > a[href*=\"reddit.com\"]::before\";i:819;s:107:\".social-list .menu-item > a[href*=\"skype.com\"]::before, .social-list .menu-item > a[href*=\"skype:\"]::before\";i:820;s:60:\".social-list .menu-item > a[href*=\"stumbleupon.com\"]::before\";i:821;s:54:\".social-list .menu-item > a[href*=\"vimeo.com\"]::before\";i:822;s:118:\".social-list .menu-item > a[href*=\"wordpress.org\"]::before, .social-list .menu-item > a[href*=\"wordpress.com\"]::before\";i:823;s:56:\".social-list .menu-item > a[href*=\"youtube.com\"]::before\";i:824;s:55:\".social-list .menu-item > a[href*=\"amazon.com\"]::before\";i:825;s:56:\".social-list .menu-item > a[href*=\"tripadvisor\"]::before\";i:826;s:60:\".social-list .menu-item > a[href*=\"ycombinator.com\"]::before\";i:827;s:53:\".social-list .menu-item > a[href*=\"xing.com\"]::before\";i:828;s:51:\".social-list .menu-item > a[href*=\"yahoo.\"]::before\";i:829;s:52:\".social-list .menu-item > a[href*=\"vine.co\"]::before\";i:830;s:54:\".social-list .menu-item > a[href*=\"weibo.com\"]::before\";i:831;s:55:\".social-list .menu-item > a[href*=\"trello.com\"]::before\";i:832;s:61:\".social-list .menu-item > a[href*=\"steampowered.com\"]::before\";i:833;s:59:\".social-list .menu-item > a[href*=\"soundcloud.com\"]::before\";i:834;s:56:\".social-list .menu-item > a[href*=\"spotify.com\"]::before\";i:835;s:62:\".social-list .menu-item > a[href*=\"stackexchange.com\"]::before\";i:836;s:62:\".social-list .menu-item > a[href*=\"stackoverflow.com\"]::before\";i:837;s:59:\".social-list .menu-item > a[href*=\"slideshare.net\"]::before\";i:838;s:54:\".social-list .menu-item > a[href*=\"slack.com\"]::before\";i:839;s:57:\".social-list .menu-item > a[href*=\"skyatlas.com\"]::before\";i:840;s:52:\".social-list .menu-item > a[href*=\"last.fm\"]::before\";i:841;s:57:\".social-list .menu-item > a[href*=\"jsfiddle.net\"]::before\";i:842;s:58:\".social-list .menu-item > a[href*=\"bitbucket.org\"]::before\";i:843;s:57:\".social-list .menu-item > a[href*=\"codiepie.com\"]::before\";i:844;s:63:\".social-list .menu-item > a[href*=\"connectdevelop.com\"]::before\";i:845;s:57:\".social-list .menu-item > a[href*=\"dashcube.com\"]::before\";i:846;s:55:\".social-list .menu-item > a[href*=\"contao.org\"]::before\";i:847;s:58:\".social-list .menu-item > a[href*=\"delicious.com\"]::before\";i:848;s:59:\".social-list .menu-item > a[href*=\"deviantart.com\"]::before\";i:849;s:51:\".social-list .menu-item > a[href*=\"vk.com\"]::before\";i:850;s:57:\".social-list .menu-item > a[href*=\"dribbble.com\"]::before\";i:851;s:57:\".social-list .menu-item > a[href*=\"facebook.com\"]::before\";i:852;s:60:\".social-list .menu-item > a[href*=\"plus.google.com\"]::before\";i:853;s:58:\".social-list .menu-item > a[href*=\"instagram.com\"]::before\";i:854;s:57:\".social-list .menu-item > a[href*=\"linkedin.com\"]::before\";i:855;s:56:\".social-list .menu-item > a[href*=\"twitter.com\"]::before\";i:856;s:55:\".social-list .menu-item > a[href*=\"tumblr.com\"]::before\";i:857;s:56:\".social-list .menu-item > a[href*=\"behance.net\"]::before\";i:858;s:35:\".social-list .menu-item > a::before\";i:859;s:41:\".social-list--text .menu-item > a::before\";i:860;s:22:\".social-list--widget a\";i:861;s:30:\".invert .social-list--widget a\";i:862;s:484:\".glypho_icon, .social-list .menu-item > a[href*=\"dribbble.com\"]::before, .social-list .menu-item > a[href*=\"facebook.com\"]::before, .social-list .menu-item > a[href*=\"plus.google.com\"]::before, .social-list .menu-item > a[href*=\"instagram.com\"]::before, .social-list .menu-item > a[href*=\"linkedin.com\"]::before, .social-list .menu-item > a[href*=\"twitter.com\"]::before, .social-list .menu-item > a[href*=\"tumblr.com\"]::before, .social-list .menu-item > a[href*=\"behance.net\"]::before\";i:863;s:1279:\".social-list--text .glypho_icon, .social-list--text .social-list .menu-item > a[href*=\"dribbble.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"dribbble.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"facebook.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"facebook.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"plus.google.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"plus.google.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"instagram.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"instagram.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"linkedin.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"linkedin.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"twitter.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"twitter.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"tumblr.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"tumblr.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"behance.net\"]::before, .social-list .social-list--text .menu-item > a[href*=\"behance.net\"]::before\";i:864;s:2408:\".fontawesome_icon, .social-list .menu-item > a[href*=\"digg.com\"]::before, .social-list .menu-item > a[href*=\"dropbox.com\"]::before, .social-list .menu-item > a[href*=\"flickr.com\"]::before, .social-list .menu-item > a[href*=\"github.com\"]::before, .social-list .menu-item > a[href*=\"pinterest.com\"]::before, .social-list .menu-item > a[href*=\"getpocket.com\"]::before, .social-list .menu-item > a[href*=\"reddit.com\"]::before, .social-list .menu-item > a[href*=\"skype.com\"]::before, .social-list .menu-item > a[href*=\"skype:\"]::before, .social-list .menu-item > a[href*=\"stumbleupon.com\"]::before, .social-list .menu-item > a[href*=\"vimeo.com\"]::before, .social-list .menu-item > a[href*=\"wordpress.org\"]::before, .social-list .menu-item > a[href*=\"wordpress.com\"]::before, .social-list .menu-item > a[href*=\"youtube.com\"]::before, .social-list .menu-item > a[href*=\"amazon.com\"]::before, .social-list .menu-item > a[href*=\"tripadvisor\"]::before, .social-list .menu-item > a[href*=\"ycombinator.com\"]::before, .social-list .menu-item > a[href*=\"xing.com\"]::before, .social-list .menu-item > a[href*=\"yahoo.\"]::before, .social-list .menu-item > a[href*=\"vine.co\"]::before, .social-list .menu-item > a[href*=\"weibo.com\"]::before, .social-list .menu-item > a[href*=\"trello.com\"]::before, .social-list .menu-item > a[href*=\"steampowered.com\"]::before, .social-list .menu-item > a[href*=\"soundcloud.com\"]::before, .social-list .menu-item > a[href*=\"spotify.com\"]::before, .social-list .menu-item > a[href*=\"stackexchange.com\"]::before, .social-list .menu-item > a[href*=\"stackoverflow.com\"]::before, .social-list .menu-item > a[href*=\"slideshare.net\"]::before, .social-list .menu-item > a[href*=\"slack.com\"]::before, .social-list .menu-item > a[href*=\"skyatlas.com\"]::before, .social-list .menu-item > a[href*=\"last.fm\"]::before, .social-list .menu-item > a[href*=\"jsfiddle.net\"]::before, .social-list .menu-item > a[href*=\"bitbucket.org\"]::before, .social-list .menu-item > a[href*=\"codepen.io\"]::before, .social-list .menu-item > a[href*=\"codiepie.com\"]::before, .social-list .menu-item > a[href*=\"connectdevelop.com\"]::before, .social-list .menu-item > a[href*=\"dashcube.com\"]::before, .social-list .menu-item > a[href*=\"contao.org\"]::before, .social-list .menu-item > a[href*=\"delicious.com\"]::before, .social-list .menu-item > a[href*=\"deviantart.com\"]::before, .social-list .menu-item > a[href*=\"vk.com\"]::before\";i:865;s:6376:\".social-list--text .fontawesome_icon, .social-list--text .social-list .menu-item > a[href*=\"digg.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"digg.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"dropbox.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"dropbox.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"flickr.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"flickr.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"github.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"github.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"pinterest.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"pinterest.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"getpocket.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"getpocket.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"reddit.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"reddit.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"skype.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"skype.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"skype:\"]::before, .social-list .social-list--text .menu-item > a[href*=\"skype:\"]::before, .social-list--text .social-list .menu-item > a[href*=\"stumbleupon.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"stumbleupon.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"vimeo.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"vimeo.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"wordpress.org\"]::before, .social-list .social-list--text .menu-item > a[href*=\"wordpress.org\"]::before, .social-list--text .social-list .menu-item > a[href*=\"wordpress.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"wordpress.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"youtube.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"youtube.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"amazon.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"amazon.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"tripadvisor\"]::before, .social-list .social-list--text .menu-item > a[href*=\"tripadvisor\"]::before, .social-list--text .social-list .menu-item > a[href*=\"ycombinator.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"ycombinator.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"xing.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"xing.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"yahoo.\"]::before, .social-list .social-list--text .menu-item > a[href*=\"yahoo.\"]::before, .social-list--text .social-list .menu-item > a[href*=\"vine.co\"]::before, .social-list .social-list--text .menu-item > a[href*=\"vine.co\"]::before, .social-list--text .social-list .menu-item > a[href*=\"weibo.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"weibo.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"trello.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"trello.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"steampowered.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"steampowered.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"soundcloud.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"soundcloud.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"spotify.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"spotify.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"stackexchange.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"stackexchange.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"stackoverflow.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"stackoverflow.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"slideshare.net\"]::before, .social-list .social-list--text .menu-item > a[href*=\"slideshare.net\"]::before, .social-list--text .social-list .menu-item > a[href*=\"slack.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"slack.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"skyatlas.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"skyatlas.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"last.fm\"]::before, .social-list .social-list--text .menu-item > a[href*=\"last.fm\"]::before, .social-list--text .social-list .menu-item > a[href*=\"jsfiddle.net\"]::before, .social-list .social-list--text .menu-item > a[href*=\"jsfiddle.net\"]::before, .social-list--text .social-list .menu-item > a[href*=\"bitbucket.org\"]::before, .social-list .social-list--text .menu-item > a[href*=\"bitbucket.org\"]::before, .social-list--text .social-list .menu-item > a[href*=\"codepen.io\"]::before, .social-list .social-list--text .menu-item > a[href*=\"codepen.io\"]::before, .social-list--text .social-list .menu-item > a[href*=\"codiepie.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"codiepie.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"connectdevelop.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"connectdevelop.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"dashcube.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"dashcube.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"contao.org\"]::before, .social-list .social-list--text .menu-item > a[href*=\"contao.org\"]::before, .social-list--text .social-list .menu-item > a[href*=\"delicious.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"delicious.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"deviantart.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"deviantart.com\"]::before, .social-list--text .social-list .menu-item > a[href*=\"vk.com\"]::before, .social-list .social-list--text .menu-item > a[href*=\"vk.com\"]::before\";i:866;s:19:\".screen-reader-text\";i:867;s:25:\".screen-reader-text:focus\";i:868;s:29:\"#content[tabindex=\"-1\"]:focus\";i:869;s:10:\".alignleft\";i:870;s:11:\".alignright\";i:871;s:12:\".aligncenter\";i:872;s:10:\".alignnone\";i:873;s:332:\".clear:before, .clear:after, .comment-body:before, .comment-body:after, .entry-content:before, .entry-content:after, .entry-footer:before, .entry-footer:after, .comment-content:before, .comment-content:after, .site-header:before, .site-header:after, .site-content:before, .site-content:after, .site-footer:before, .site-footer:after\";i:874;s:161:\".clear:after, .comment-body:after, .entry-content:after, .entry-footer:after, .comment-content:after, .site-header:after, .site-content:after, .site-footer:after\";i:875;s:7:\".hidden\";i:876;s:30:\".comments-area .comments-title\";i:877;s:13:\".comment-list\";i:878;s:18:\".comment-content a\";i:879;s:21:\".comment-body__holder\";i:880;s:20:\".comment-body .reply\";i:881;s:19:\".comment-reply-link\";i:882;s:35:\".comment-reply-link .material-icons\";i:883;s:13:\".comment-date\";i:884;s:19:\".comment-date__time\";i:885;s:19:\".comment-date:after\";i:886;s:13:\".bypostauthor\";i:887;s:16:\".post-author-bio\";i:888;s:21:\".post-author__content\";i:889;s:30:\".single-post .share-btns__list\";i:890;s:17:\".share-btns__item\";i:891;s:30:\".single-post .share-btns__item\";i:892;s:17:\".share-btns__link\";i:893;s:5:\".card\";i:894;s:5:\".site\";i:895;s:46:\".container.site-header, .container.site-footer\";i:896;s:90:\".content-layout-boxed .container.site-header, .content-layout-boxed .container.site-footer\";i:897;s:21:\".container .container\";i:898;s:12:\".site-header\";i:899;s:18:\".home .site-header\";i:900;s:28:\".container .header-container\";i:901;s:20:\".site-header.default\";i:902;s:21:\".site-header.centered\";i:903;s:26:\".header-layout-transparent\";i:904;s:143:\".header-layout-transparent.top-panel-invisible .hentry:first-child, .header-layout-transparent.top-panel-invisible .sidebar .widget:first-child\";i:905;s:60:\".header-layout-transparent.top-panel-invisible .card-columns\";i:906;s:10:\".top-panel\";i:907;s:21:\".container .top-panel\";i:908;s:22:\".top-panel__wrap:after\";i:909;s:43:\".top-panel__message .info-block:first-child\";i:910;s:35:\".top-panel__message .material-icons\";i:911;s:10:\".site-logo\";i:912;s:16:\".site-logo__link\";i:913;s:22:\".site-logo__link:focus\";i:914;s:29:\".page-content, .entry-summary\";i:915;s:14:\".entry-content\";i:916;s:32:\".single .no-thumb .entry-content\";i:917;s:7:\".hentry\";i:918;s:72:\".posts-list--masonry-2-cols .hentry, .posts-list--masonry-3-cols .hentry\";i:919;s:108:\".posts-list--masonry-2-cols .hentry:not(:first-child), .posts-list--masonry-3-cols .hentry:not(:first-child)\";i:920;s:30:\".posts-list .hentry:last-child\";i:921;s:21:\".card-columns .hentry\";i:922;s:12:\".hentry.page\";i:923;s:18:\".blog .entry-title\";i:924;s:49:\".blog .post_format-post-format-quote .entry-title\";i:925;s:20:\".single .entry-title\";i:926;s:38:\".entry-header .entry-title:first-child\";i:927;s:58:\".entry-summary + .entry-meta, .entry-content + .entry-meta\";i:928;s:64:\".post-list__item .entry-summary, .post-list__item .entry-content\";i:929;s:68:\".post-list__item .entry-summary p, .post-list__item .entry-content p\";i:930;s:13:\".entry-footer\";i:931;s:18:\".entry-footer .btn\";i:932;s:21:\".single .entry-footer\";i:933;s:21:\".post-thumbnail__link\";i:934;s:28:\".post-thumbnail__link:before\";i:935;s:34:\".post-thumbnail__link:hover:before\";i:936;s:20:\".post-thumbnail__img\";i:937;s:54:\".entry-header + .post-thumbnail > .post-thumbnail__img\";i:938;s:11:\".post__cats\";i:939;s:52:\".format-audio .post__cats, .format-quote .post__cats\";i:940;s:144:\".post__date .material-icons, .post__date .fa, .post__comments .material-icons, .post__comments .fa, .post__tags .material-icons, .post__tags .fa\";i:941;s:192:\".invert .post__date .material-icons, .invert\n.post__date .fa, .invert .post__comments .material-icons, .invert\n.post__comments .fa, .invert .post__tags .material-icons, .invert\n.post__tags .fa\";i:942;s:47:\".post__date a, .post__comments a, .post__tags a\";i:943;s:59:\".blog .post__date, .blog .post__comments, .blog .post__tags\";i:944;s:80:\".blog .post__date:before, .blog .post__comments:before, .blog .post__tags:before\";i:945;s:28:\".post__date, .post__comments\";i:946;s:44:\".single .post__date, .single .post__comments\";i:947;s:58:\".single .post__date:before, .single .post__comments:before\";i:948;s:11:\".post__tags\";i:949;s:24:\".single-post .post__tags\";i:950;s:17:\".blog .post__tags\";i:951;s:84:\".single .post .entry-meta span:first-child, .blog .post .entry-meta span:first-child\";i:952;s:98:\".single .post .entry-meta span:first-child:before, .blog .post .entry-meta span:first-child:before\";i:953;s:24:\".posted-by__author:hover\";i:954;s:74:\".single .related-posts .post__date, .single .related-posts .post__comments\";i:955;s:115:\".single .related-post .post-thumbnail__img + .post__cats, .single .related-post .post-thumbnail__link + .post__cats\";i:956;s:22:\".single .related-posts\";i:957;s:35:\".single .related-posts .entry-title\";i:958;s:41:\".single .related-posts .entry-header span\";i:959;s:34:\".single .related-posts .entry-meta\";i:960;s:39:\".single .related-posts .entry-content p\";i:961;s:88:\".single .related-posts .post__date:before, .single .related-posts .post__comments:before\";i:962;s:21:\".taxonomy-description\";i:963;s:7:\".sticky\";i:964;s:14:\".sticky__label\";i:965;s:50:\".sticky__label .material-icons, .sticky__label .fa\";i:966;s:74:\".posts-list .sticky__label .material-icons, .posts-list\n.sticky__label .fa\";i:967;s:70:\".sticky__label.type-both .material-icons, .sticky__label.type-both .fa\";i:968;s:49:\".two-sidebars .sticky.posts-list__item .btn__text\";i:969;s:159:\".two-sidebars .sticky.posts-list__item .btn__icon, .two-sidebars\n.sticky.posts-list__item .btn .material-icons, .two-sidebars\n.sticky.posts-list__item .btn .fa\";i:970;s:28:\".sticky .post-thumbnail__img\";i:971;s:5:\".post\";i:972;s:46:\".single .post.format-audio .wp-audio-shortcode\";i:973;s:68:\".post.format-audio .post-format-audio .post-format-audio-description\";i:974;s:71:\".post.format-audio .post-format-audio .post-format-audio-description h5\";i:975;s:64:\".post.format-audio .post-format-audio .post-format-audio-caption\";i:976;s:28:\".entry-content .post-gallery\";i:977;s:20:\".post-gallery__image\";i:978;s:45:\".post-gallery__slide.swiper-slide:hover:hover\";i:979;s:22:\".post-gallery__caption\";i:980;s:19:\".post-gallery__link\";i:981;s:17:\".post-format-link\";i:982;s:24:\".post-format-link:before\";i:983;s:26:\".has-thumb .post-thumbnail\";i:984;s:39:\".has-thumb .post-thumbnail__format-link\";i:985;s:57:\".has-thumb .post-thumbnail__format-link .post-format-link\";i:986;s:48:\".post_format-post-format-image .post-format-wrap\";i:987;s:18:\".post-format-quote\";i:988;s:33:\".single-format-video .post iframe\";i:989;s:44:\".post_format-post-format-video .entry-header\";i:990;s:36:\".format-video .post-featured-content\";i:991;s:34:\".post-featured-content .post__cats\";i:992;s:60:\".format-video .post-featured-content .post__cats:first-child\";i:993;s:31:\".post.format-status .post__cats\";i:994;s:69:\".blog .format-aside .entry-title, .archive .format-aside .entry-title\";i:995;s:28:\".container .footer-container\";i:996;s:23:\".site-info .footer-logo\";i:997;s:23:\".site-info .social-list\";i:998;s:42:\".footer-layout-boxed .site-info .container\";i:999;s:29:\".site-info__flex .footer-logo\";i:1000;s:38:\".site-footer.default .footer-copyright\";i:1001;s:21:\".site-footer.centered\";i:1002;s:45:\".site-footer.centered .site-info .footer-logo\";i:1003;s:41:\".site-footer.centered .site-info__mid-box\";i:1004;s:34:\".site-footer.centered .social-list\";i:1005;s:34:\".site-footer.centered .footer-area\";i:1006;s:39:\".site-footer.centered .footer-copyright\";i:1007;s:38:\".site-footer.minimal .footer-copyright\";i:1008;s:24:\".not-found .page-content\";i:1009;s:27:\".not-found .page-content h1\";i:1010;s:18:\".error404 #primary\";i:1011;s:26:\".footer-area .widget-title\";i:1012;s:16:\".sidebar .widget\";i:1013;s:22:\".footer-area .widget p\";i:1014;s:14:\".widget select\";i:1015;s:10:\".widget ul\";i:1016;s:16:\".widget ul li ul\";i:1017;s:29:\".widget > ul > li:first-child\";i:1018;s:10:\".widget li\";i:1019;s:15:\".widget li > ul\";i:1020;s:113:\".widget_archive li, .widget_categories li, .widget_pages li, .widget_meta li, .widget_rss li, .widget_nav_menu li\";i:1021;s:22:\".widget_calendar table\";i:1022;s:44:\".footer-area .widget_calendar .calendar_wrap\";i:1023;s:22:\".widget_calendar tfoot\";i:1024;s:25:\".widget_calendar tfoot td\";i:1025;s:25:\".widget_calendar tbody td\";i:1026;s:27:\".widget_calendar tbody td a\";i:1027;s:35:\".widget_calendar tbody td a::before\";i:1028;s:38:\".widget_calendar tbody td#today::after\";i:1029;s:46:\".widget_calendar th, .widget_calendar tbody td\";i:1030;s:22:\".widget_calendar #next\";i:1031;s:11:\".tagcloud a\";i:1032;s:20:\".sidebar .tagcloud a\";i:1033;s:17:\".tagcloud a:focus\";i:1034;s:25:\".widget_recent_entries li\";i:1035;s:33:\".widget_recent_entries li::before\";i:1036;s:30:\".widget_recent_entries li + li\";i:1037;s:27:\".widget_recent_entries li a\";i:1038;s:36:\".widget_recent_entries li .post-date\";i:1039;s:26:\".widget_recent_comments li\";i:1040;s:28:\".widget_recent_comments li a\";i:1041;s:35:\".widget_recent_comments li a:before\";i:1042;s:34:\".widget_recent_comments li::before\";i:1043;s:13:\".textwidget a\";i:1044;s:22:\".sidebar .widget-about\";i:1045;s:48:\".sidebar .widget-about .widget-about__content h4\";i:1046;s:19:\".widget-about__logo\";i:1047;s:23:\".widget-about__logo-img\";i:1048;s:41:\".widget-about .tm_builder_inner_content p\";i:1049;s:20:\".widget-about-author\";i:1050;s:162:\".before-content-area .widget-about-author, .before-loop-area .widget-about-author, .after-content-area .widget-about-author, .after-loop-area .widget-about-author\";i:1051;s:19:\".about-author:after\";i:1052;s:20:\".about-author_avatar\";i:1053;s:17:\".about-author_img\";i:1054;s:267:\".full-width-header-area .about-author_content, .after-content-full-width-area .about-author_content, .before-content-area .about-author_content, .before-loop-area .about-author_content, .after-content-area .about-author_content, .after-loop-area .about-author_content\";i:1055;s:18:\".about-author_name\";i:1056;s:25:\".about-author_description\";i:1057;s:34:\".footer-area .about-author_btn_box\";i:1058;s:19:\".widget-banner__img\";i:1059;s:17:\".instagram__items\";i:1060;s:16:\".instagram__item\";i:1061;s:25:\".sidebar .instagram__item\";i:1062;s:16:\".instagram__link\";i:1063;s:40:\".instagram__link:hover .instagram__cover\";i:1064;s:15:\".instagram__img\";i:1065;s:17:\".instagram__cover\";i:1066;s:24:\".instagram__cover:before\";i:1067;s:91:\".full-width-header-area .widget-instagram, .after-content-full-width-area .widget-instagram\";i:1068;s:55:\".after-content-full-width-area .widget.widget-subscribe\";i:1069;s:33:\".sidebar .widget.widget-subscribe\";i:1070;s:13:\".follow-block\";i:1071;s:78:\".sidebar .follow-block .widget-title, .footer-area .follow-block .widget-title\";i:1072;s:37:\".follow-block .social-list .menu-item\";i:1073;s:48:\".follow-block .social-list .menu-item > a:before\";i:1074;s:96:\".sidebar .follow-block, .footer-area .follow-block, .after-content-full-width-area .follow-block\";i:1075;s:16:\".subscribe-block\";i:1076;s:84:\".sidebar .subscribe-block .widget-title, .footer-area .subscribe-block .widget-title\";i:1077;s:74:\".sidebar .subscribe-block__message, .footer-area .subscribe-block__message\";i:1078;s:105:\".sidebar .subscribe-block, .footer-area .subscribe-block, .after-content-full-width-area .subscribe-block\";i:1079;s:29:\".subscribe-block__input-group\";i:1080;s:144:\".sidebar .subscribe-block__input-group, .footer-area .subscribe-block__input-group, .after-content-full-width-area .subscribe-block__input-group\";i:1081;s:68:\".after-content-full-width-area .subscribe-block__input[type=\'email\']\";i:1082;s:43:\".subscribe-block__input[type=\'email\'].error\";i:1083;s:56:\".footer-area .subscribe-block__input[type=\'email\']:focus\";i:1084;s:50:\".sidebar-1-4 .subscribe-block__input[type=\'email\']\";i:1085;s:24:\".subscribe-block__submit\";i:1086;s:25:\".subscribe-block__message\";i:1087;s:56:\".after-content-full-width-area .subscribe-block__message\";i:1088;s:38:\".footer-area .subscribe-block__message\";i:1089;s:26:\".subscribe-block__messages\";i:1090;s:50:\".subscribe-block__messages .subscribe-block__error\";i:1091;s:41:\".custom-posts__item + .custom-posts__item\";i:1092;s:95:\".full-width-header-area .custom-posts__item, .after-content-full-width-area .custom-posts__item\";i:1093;s:25:\".custom-posts .post__cats\";i:1094;s:83:\".full-width-header-area .custom-posts, .after-content-full-width-area .custom-posts\";i:1095;s:37:\".contact-information-widget__inner li\";i:1096;s:43:\".contact-information-widget__inner li .icon\";i:1097;s:37:\".wpcf7 .wpcf7-form-control-wrap input\";i:1098;s:23:\".wpcf7 .wpcf7-not-valid\";i:1099;s:27:\".wpcf7 .wpcf7-not-valid-tip\";i:1100;s:87:\".wpcf7 .wpcf7-validation-errors, .wpcf7 .wpcf7-mail-sent-ng, .wpcf7 .wpcf7-mail-sent-ok\";i:1101;s:59:\".wpcf7 .wpcf7-validation-errors, .wpcf7 .wpcf7-mail-sent-ng\";i:1102;s:26:\".wpcf7 .wpcf7-mail-sent-ok\";i:1103;s:80:\".page-content .wp-smiley, .entry-content .wp-smiley, .comment-content .wp-smiley\";i:1104;s:21:\"embed, iframe, object\";i:1105;s:14:\".img-pull-left\";i:1106;s:15:\".img-pull-right\";i:1107;s:11:\".wp-caption\";i:1108;s:35:\".wp-caption img[class*=\"wp-image-\"]\";i:1109;s:28:\".wp-caption .wp-caption-text\";i:1110;s:16:\".wp-caption-text\";i:1111;s:8:\".gallery\";i:1112;s:13:\".gallery-item\";i:1113;s:32:\".gallery-columns-2 .gallery-item\";i:1114;s:32:\".gallery-columns-3 .gallery-item\";i:1115;s:32:\".gallery-columns-4 .gallery-item\";i:1116;s:32:\".gallery-columns-5 .gallery-item\";i:1117;s:32:\".gallery-columns-6 .gallery-item\";i:1118;s:32:\".gallery-columns-7 .gallery-item\";i:1119;s:32:\".gallery-columns-8 .gallery-item\";i:1120;s:32:\".gallery-columns-9 .gallery-item\";i:1121;s:16:\".gallery-caption\";i:1122;s:17:\".embed-responsive\";i:1123;s:117:\".embed-responsive .embed-responsive-item, .embed-responsive iframe, .embed-responsive embed, .embed-responsive object\";i:1124;s:40:\".embed-responsive.embed-responsive-16by9\";i:1125;s:39:\".embed-responsive.embed-responsive-4by3\";i:1126;s:17:\".fb_iframe_widget\";i:1127;s:24:\".fb_iframe_widget > span\";i:1128;s:36:\"#tm_builder_outer_content blockquote\";i:1129;s:42:\"#tm_builder_outer_content blockquote p + p\";i:1130;s:41:\"#tm_builder_outer_content blockquote cite\";i:1131;s:48:\"#tm_builder_outer_content blockquote cite:before\";i:1132;s:56:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_container\";i:1133;s:66:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_description p\";i:1134;s:79:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_slide_2 .tm_pb_slide_description\";i:1135;s:65:\"#tm_builder_outer_content .tm_pb_slider .tm_pb_more_button_invert\";i:1136;s:64:\"#tm_builder_outer_content .tm_pb_slider .tm-pb-arrow-prev:before\";i:1137;s:64:\"#tm_builder_outer_content .tm_pb_slider .tm-pb-arrow-next:before\";i:1138;s:60:\"#tm_builder_outer_content .tm_pb_slider .tm-pb-controllers a\";i:1139;s:99:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_image_container .entry-featured-image-url\";i:1140;s:106:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_image_container .entry-featured-image-url:before\";i:1141;s:103:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_image_container .entry-featured-image-url img\";i:1142;s:112:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_image_container .entry-featured-image-url:hover:before\";i:1143;s:109:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_image_container .entry-featured-image-url:hover img\";i:1144;s:325:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_post_meta .author_meta, #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_post_meta .published, #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_post_meta .categories_meta, #tm_builder_outer_content .tm_pb_blog.tm_pb_module .tm_pb_post_meta .comments\";i:1145;s:61:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .more-link\";i:1146;s:62:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .pagination\";i:1147;s:185:\"#tm_builder_outer_content .tm_pb_blog.tm_pb_module .pagination .nav-links a.page-numbers, #tm_builder_outer_content .tm_pb_blog.tm_pb_module .pagination .nav-links .page-numbers.current\";i:1148;s:37:\"#tm_builder_outer_content .tm_pb_post\";i:1149;s:57:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module:after\";i:1150;s:63:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module:hover:after\";i:1151;s:63:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module .tm-pb-icon\";i:1152;s:85:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module .tm_pb_blurb_container h4 a:hover\";i:1153;s:54:\"#tm_builder_outer_content .tm_pb_blurb.tm_pb_module h4\";i:1154;s:77:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls:after\";i:1155;s:80:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li:after\";i:1156;s:185:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li:hover:after, #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li.tm_pb_tab_active:after\";i:1157;s:91:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_tabs_controls li.tm_pb_tab_active\";i:1158;s:79:\"#tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab p\";i:1159;s:107:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab p\";i:1160;s:116:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab .alignleft\";i:1161;s:117:\".position-one-right-sidebar #tm_builder_outer_content .tm_pb_tabs.tm_pb_module .tm_pb_all_tabs .tm_pb_tab .alignright\";i:1162;s:76:\"#tm_builder_outer_content .tm_pb_counters.tm_pb_module .tm_pb_counter_amount\";i:1163;s:75:\"#tm_builder_outer_content .tm_pb_counters.tm_pb_module .tm_pb_counter_title\";i:1164;s:79:\"#tm_builder_outer_content .tm_pb_counters.tm_pb_module .tm_pb_counter_container\";i:1165;s:47:\"#tm_builder_outer_content .tm_pb_circle_counter\";i:1166;s:73:\"#tm_builder_outer_content .tm_pb_circle_counter .tm_pb_circle_counter_bar\";i:1167;s:84:\"#tm_builder_outer_content .tm_pb_circle_counter .tm_pb_circle_counter_bar .percent p\";i:1168;s:80:\"#tm_builder_outer_content .tm_pb_circle_counter .tm_pb_circle_counter_bar canvas\";i:1169;s:105:\"#tm_builder_outer_content .tm_pb_audio_module.tm_pb_module .tm_audio_container .mejs-volume-button button\";i:1170;s:100:\"#tm_builder_outer_content .tm_pb_audio_module.tm_pb_module .tm_audio_container span.mejs-currenttime\";i:1171;s:45:\"#tm_builder_outer_content .tm_pb_audio_module\";i:1172;s:94:\"#tm_builder_outer_content .tm_pb_audio_module.tm_pb_audio_no_image .tm_pb_audio_module_content\";i:1173;s:95:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content .tm_audio_module_meta\";i:1174;s:89:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content .mejs-container\";i:1175;s:135:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content .mejs-container .mejs-controls .mejs-horizontal-volume-handle\";i:1176;s:141:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content .mejs-container .mejs-controls .mejs-playpause-button button:before\";i:1177;s:150:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content .mejs-container .mejs-controls .mejs-currenttime-container .mejs-currenttime\";i:1178;s:135:\"#tm_builder_outer_content .tm_pb_audio_module .tm_pb_audio_module_content .mejs-container .mejs-controls .mejs-horizontal-volume-slider\";i:1179;s:958:\"#tm_builder_outer_content .col-xl-6 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-xl-4 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-xl-3 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-lg-6 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-lg-4 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-lg-3 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-md-6 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-md-4 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-md-3 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-sm-6 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-sm-4 .tm_pb_audio_module .tm_pb_audio_cover_art, #tm_builder_outer_content .col-sm-3 .tm_pb_audio_module .tm_pb_audio_cover_art\";i:1180;s:1018:\"#tm_builder_outer_content .col-xl-6 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-xl-4 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-xl-3 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-lg-6 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-lg-4 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-lg-3 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-md-6 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-md-4 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-md-3 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-sm-6 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-sm-4 .tm_pb_audio_module .tm_pb_audio_module_content, #tm_builder_outer_content .col-sm-3 .tm_pb_audio_module .tm_pb_audio_module_content\";i:1181;s:92:\"#tm_builder_outer_content .tm_pb_video_overlay .tm_pb_video_overlay_hover a.tm_pb_video_play\";i:1182;s:100:\"#tm_builder_outer_content .tm_pb_video_overlay .tm_pb_video_overlay_hover a.tm_pb_video_play::before\";i:1183;s:79:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_heading\";i:1184;s:100:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_heading .tm_pb_pricing_title\";i:1185;s:79:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content\";i:1186;s:97:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content .tm_pb_pricing li\";i:1187;s:108:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content .tm_pb_pricing li:last-child\";i:1188;s:104:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content .tm_pb_pricing li:before\";i:1189;s:83:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content_top\";i:1190;s:99:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content_top .tm_pb_tm_price\";i:1191;s:116:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content_top .tm_pb_tm_price .tm_pb_frequency\";i:1192;s:230:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content_top .tm_pb_tm_price .tm_pb_sum, #tm_builder_outer_content .tm_pb_pricing.tm_pb_module div.tm_pb_pricing_content_top .tm_pb_tm_price .tm_pb_dollar_sign\";i:1193;s:71:\"#tm_builder_outer_content .tm_pb_pricing.tm_pb_module .tm_pb_best_value\";i:1194;s:45:\"#tm_builder_outer_content .tm_pb_contact_form\";i:1195;s:74:\"#tm_builder_outer_content .tm_pb_contact_form .tm_contact_bottom_container\";i:1196;s:49:\"#tm_builder_outer_content div.tm_pb_contact_right\";i:1197;s:51:\"#tm_builder_outer_content .tm_pb_contact_main_title\";i:1198;s:47:\"#tm_builder_outer_content .tm_pb_contact_submit\";i:1199;s:46:\"#tm_builder_outer_content .tm_pb_contact_field\";i:1200;s:72:\"#tm_builder_outer_content .tm_pb_contact_field .tm_pb_contact_form_label\";i:1201;s:53:\"#tm_builder_outer_content .tm_pb_contact_field select\";i:1202;s:72:\"#tm_builder_outer_content .tm_pb_contact_field .tm_pb_contact_form_input\";i:1203;s:43:\"#tm_builder_outer_content .tm_contact_error\";i:1204;s:45:\"#tm_builder_outer_content .cf-success-message\";i:1205;s:103:\"#tm_builder_outer_content .tm-pb-contact-message li, #tm_builder_outer_content .tm-pb-contact-message p\";i:1206;s:50:\"#tm_builder_outer_content .tm-pb-contact-message p\";i:1207;s:103:\"#tm_builder_outer_content .tm-pb-contact-message p, #tm_builder_outer_content .tm-pb-contact-message ul\";i:1208;s:63:\"#tm_builder_outer_content .tm-pb-contact-message ul + p::before\";i:1209;s:54:\"#tm_builder_outer_content .tm-pb-contact-message ul li\";i:1210;s:61:\"#tm_builder_outer_content .tm-pb-contact-message ul li::after\";i:1211;s:72:\"#tm_builder_outer_content .tm-pb-contact-message ul li:last-child::after\";i:1212;s:52:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle\";i:1213;s:143:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_close, #tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_open\";i:1214;s:98:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_title::before\";i:1215;s:76:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle .tm_pb_toggle_content p\";i:1216;s:88:\"#tm_builder_outer_content .tm_pb_module.tm_pb_toggle .tm_pb_toggle_content p strong span\";i:1217;s:69:\"#tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle\";i:1218;s:221:\"#tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_close .tm_pb_toggle_content, #tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_content\";i:1219;s:116:\"#tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_close .tm_pb_toggle_title::before\";i:1220;s:115:\"#tm_builder_outer_content .tm_pb_module.tm_pb_accordion .tm_pb_toggle.tm_pb_toggle_open .tm_pb_toggle_title::before\";i:1221;s:68:\"#tm_builder_outer_content .tm_pb_social_media_follow.tm_pb_module li\";i:1222;s:75:\"#tm_builder_outer_content .tm_pb_social_media_follow.tm_pb_module li a.icon\";i:1223;s:93:\"#tm_builder_outer_content .tm_pb_social_media_follow.tm_pb_module li a.icon.rounded_rectangle\";i:1224;s:86:\"#tm_builder_outer_content .tm_pb_team_member.tm_pb_module .tm_pb_team_member_image img\";i:1225;s:89:\"#tm_builder_outer_content .tm_pb_team_member.tm_pb_module .tm_pb_team_member_name a:hover\";i:1226;s:88:\"#tm_builder_outer_content .tm_pb_team_member.tm_pb_module .tm_pb_team_member_description\";i:1227;s:80:\"#tm_builder_outer_content .tm_pb_team_member.tm_pb_module .tm_pb_member_position\";i:1228;s:57:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module\";i:1229;s:88:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module .tm_pb_testimonial_description\";i:1230;s:90:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module .tm_pb_testimonial_description p\";i:1231;s:83:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module .tm_pb_testimonial_author\";i:1232;s:86:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module .tm_pb_testimonial_job_title\";i:1233;s:81:\"#tm_builder_outer_content .tm_pb_testimonial.tm_pb_module.tm_pb_testimonial_no_bg\";i:1234;s:105:\"#tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module.tm_pb_countdown_timer_circle_layout .values\";i:1235;s:154:\".tm_pb_countdown_timer_circle_layout #tm_builder_outer_content .tm_pb_countdown_timer.tm_pb_module .tm_pb_countdown_timer_container .section.values .value\";i:1236;s:45:\"#tm_builder_outer_content .tm_pb_button:focus\";i:1237;s:49:\"#tm_builder_outer_content .tm_pb_button-fullwidth\";i:1238;s:295:\"#tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm_pb_link_box_title, #tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm_pb_blurb_content, #tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm_pb_button, #tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm-pb-icon\";i:1239;s:67:\"#tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm-pb-icon\";i:1240;s:77:\"#tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm_pb_link_box_title\";i:1241;s:78:\"#tm_builder_outer_content .tm_pb_link_box .desc_linkbox .tm_pb_blurb_content p\";i:1242;s:69:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image img\";i:1243;s:67:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image a\";i:1244;s:74:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image a:before\";i:1245;s:71:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image a img\";i:1246;s:80:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image a:hover:before\";i:1247;s:77:\"#tm_builder_outer_content .tm_pb_link_box .tm_pb_main_blurb_image a:hover img\";i:1248;s:53:\"#tm_builder_outer_content .tm_pb_link_box .tm-pb-icon\";i:1249;s:33:\".cherry-services .container-fluid\";i:1250;s:60:\".cherry-services .row, .cherry-services .cherry-services-row\";i:1251;s:1693:\".cherry-services .col-xs-1, .cherry-services .col-xs-2, .cherry-services .col-xs-3, .cherry-services .col-xs-4, .cherry-services .col-xs-5, .cherry-services .col-xs-6, .cherry-services .col-xs-7, .cherry-services .col-xs-8, .cherry-services .col-xs-9, .cherry-services .col-xs-10, .cherry-services .col-xs-11, .cherry-services .col-xs-12, .cherry-services .col-sm-1, .cherry-services .col-sm-2, .cherry-services .col-sm-3, .cherry-services .col-sm-4, .cherry-services .col-sm-5, .cherry-services .col-sm-6, .cherry-services .col-sm-7, .cherry-services .col-sm-8, .cherry-services .col-sm-9, .cherry-services .col-sm-10, .cherry-services .col-sm-11, .cherry-services .col-sm-12, .cherry-services .col-md-1, .cherry-services .col-md-2, .cherry-services .col-md-3, .cherry-services .col-md-4, .cherry-services .col-md-5, .cherry-services .col-md-6, .cherry-services .col-md-7, .cherry-services .col-md-8, .cherry-services .col-md-9, .cherry-services .col-md-10, .cherry-services .col-md-11, .cherry-services .col-md-12, .cherry-services .col-lg-1, .cherry-services .col-lg-2, .cherry-services .col-lg-3, .cherry-services .col-lg-4, .cherry-services .col-lg-5, .cherry-services .col-lg-6, .cherry-services .col-lg-7, .cherry-services .col-lg-8, .cherry-services .col-lg-9, .cherry-services .col-lg-10, .cherry-services .col-lg-11, .cherry-services .col-lg-12, .cherry-services .col-xl-1, .cherry-services .col-xl-2, .cherry-services .col-xl-3, .cherry-services .col-xl-4, .cherry-services .col-xl-5, .cherry-services .col-xl-6, .cherry-services .col-xl-7, .cherry-services .col-xl-8, .cherry-services .col-xl-9, .cherry-services .col-xl-10, .cherry-services .col-xl-11, .cherry-services .col-xl-12\";i:1252;s:92:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services .services-item .title_wrap\";i:1253;s:90:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-listed-services\";i:1254;s:97:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item\";i:1255;s:111:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .image_wrap a\";i:1256;s:118:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .image_wrap a:before\";i:1257;s:115:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .image_wrap a img\";i:1258;s:124:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .image_wrap a:hover:before\";i:1259;s:121:\"#tm_builder_outer_content .tm_pb_cherry_services .cherry-services.template-default .services-item .image_wrap a:hover img\";i:1260;s:62:\"#tm_builder_outer_content .tm_pb_cherry_services .service-icon\";i:1261;s:74:\"#tm_builder_outer_content .tm_pb_cherry_services .nav-links a.page-numbers\";i:1262;s:48:\".cherry-services .template-single .bg_image_wrap\";i:1263;s:45:\".cherry-services .template-single .title_wrap\";i:1264;s:93:\".cherry-services .template-single .slogan_wrap, .cherry-services .template-single .descr_wrap\";i:1265;s:64:\".cherry-services .template-single .cta_wrap .cta-form_submit.btn\";i:1266;s:70:\".cherry-services .template-single .cta_wrap .cta-form_submit.btn:hover\";i:1267;s:61:\".post-type-archive-cherry-services .services-item .image_wrap\";i:1268;s:63:\".post-type-archive-cherry-services .services-item .image_wrap a\";i:1269;s:70:\".post-type-archive-cherry-services .services-item .image_wrap a:before\";i:1270;s:67:\".post-type-archive-cherry-services .services-item .image_wrap a img\";i:1271;s:76:\".post-type-archive-cherry-services .services-item .image_wrap a:hover:before\";i:1272;s:73:\".post-type-archive-cherry-services .services-item .image_wrap a:hover img\";i:1273;s:81:\"#tm_builder_outer_content .tm_pb_cherry_team .template-default .team-listing_desc\";i:1274;s:98:\"#tm_builder_outer_content .tm_pb_cherry_team .template-default .team-listing_socials .team-socials\";i:1275;s:58:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing\";i:1276;s:66:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_photo a\";i:1277;s:73:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_photo a:before\";i:1278;s:70:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_photo a img\";i:1279;s:79:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_photo a:hover:before\";i:1280;s:76:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_photo a:hover img\";i:1281;s:63:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_name\";i:1282;s:67:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_position\";i:1283;s:63:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing_desc\";i:1284;s:77:\"#tm_builder_outer_content .tm_pb_cherry_team .team-listing .team-socials_item\";i:1285;s:58:\"#tm_builder_outer_content .tm_pb_cherry_team .team-socials\";i:1286;s:85:\"#tm_builder_outer_content .tm_pb_cherry_team .team-socials .team-socials_item a:hover\";i:1287;s:63:\"#tm_builder_outer_content .tm_pb_cherry_team .team-socials_icon\";i:1288;s:70:\"#tm_builder_outer_content .tm_pb_cherry_team .nav-links a.page-numbers\";i:1289;s:104:\"#tm_builder_outer_content .tm_pb_cherry_team .cherry-team-filter .cherry-team-filter_item.active a:hover\";i:1290;s:97:\"#tm_builder_outer_content .tm_pb_cherry_team .cherry-team-filter .cherry-team-filter_item a:hover\";i:1291;s:61:\"#tm_builder_outer_content .tm_pb_cherry_team .team-ajax-pager\";i:1292;s:42:\".single-team .team-single-item .team-photo\";i:1293;s:47:\".single-team .team-single-item .position:before\";i:1294;s:48:\".single-team .team-single-item .team-member-name\";i:1295;s:44:\".single-team .team-single-item .team-socials\";i:1296;s:49:\".single-team .team-single-item .team-socials_link\";i:1297;s:46:\".single-team .team-single-item .team-socials i\";i:1298;s:52:\".single-team .team-single-item .team-socials a:hover\";i:1299;s:41:\".single-team .team-single-item .team-meta\";i:1300;s:85:\".single-team .team-single-item .team-meta .team-contact-info .team-macros:first-child\";i:1301;s:61:\".post-type-archive-team .team-listing_item .team-listing_name\";i:1302;s:61:\".post-type-archive-team .team-listing_item .team-socials_icon\";i:1303;s:62:\".post-type-archive-team .team-listing_item .team-listing_photo\";i:1304;s:64:\".post-type-archive-team .team-listing_item .team-listing_photo a\";i:1305;s:71:\".post-type-archive-team .team-listing_item .team-listing_photo a:before\";i:1306;s:68:\".post-type-archive-team .team-listing_item .team-listing_photo a img\";i:1307;s:77:\".post-type-archive-team .team-listing_item .team-listing_photo a:hover:before\";i:1308;s:74:\".post-type-archive-team .team-listing_item .team-listing_photo a:hover img\";i:1309;s:49:\"#tm_builder_outer_content .tm_pb_map .gm-style-iw\";i:1310;s:52:\"#tm_builder_outer_content .tm_pb_map .gm-style-iw h3\";i:1311;s:50:\"#tm_builder_outer_content .tm_pb_map .infowindow p\";i:1312;s:28:\"#tm_builder_outer_content ol\";i:1313;s:31:\"#tm_builder_outer_content ol li\";i:1314;s:53:\"#tm_builder_outer_content .tm_pb_promo_description h2\";i:1315;s:59:\".home #tm_builder_outer_content .tm_pb_promo_description h1\";i:1316;s:53:\"#tm_builder_outer_content .tm_pb_promo_description h1\";i:1317;s:58:\"#tm_builder_outer_content .tm_pb_promo .tm_pb_promo_button\";i:1318;s:52:\"#tm_builder_outer_content .info-box .tm_pb_image img\";i:1319;s:46:\"#tm_builder_outer_content .info-box h2 a:hover\";i:1320;s:45:\".widget_booked_calendar .booked-calendar-wrap\";i:1321;s:62:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar\";i:1322;s:71:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar h2:after\";i:1323;s:68:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead\";i:1324;s:71:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead tr\";i:1325;s:79:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead .monthName\";i:1326;s:81:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead .monthName a\";i:1327;s:88:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar thead .monthName a:before\";i:1328;s:76:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week\";i:1329;s:92:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td .tooltipster\";i:1330;s:91:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td:hover .date\";i:1331;s:86:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td.active\";i:1332;s:99:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td.active .tooltipster\";i:1333;s:92:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.week td.active .date\";i:1334;s:82:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.entryBlock\";i:1335;s:85:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar tbody tr.entryBlock td\";i:1336;s:97:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot button\";i:1337;s:103:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot button:hover\";i:1338;s:111:\".widget_booked_calendar .booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot.bookedClearFix:after\";i:1339;s:21:\".booked-calendar-wrap\";i:1340;s:38:\".booked-calendar-wrap .booked-calendar\";i:1341;s:47:\".booked-calendar-wrap .booked-calendar h2:after\";i:1342;s:44:\".booked-calendar-wrap .booked-calendar thead\";i:1343;s:47:\".booked-calendar-wrap .booked-calendar thead tr\";i:1344;s:55:\".booked-calendar-wrap .booked-calendar thead .monthName\";i:1345;s:57:\".booked-calendar-wrap .booked-calendar thead .monthName a\";i:1346;s:64:\".booked-calendar-wrap .booked-calendar thead .monthName a:before\";i:1347;s:52:\".booked-calendar-wrap .booked-calendar tbody tr.week\";i:1348;s:68:\".booked-calendar-wrap .booked-calendar tbody tr.week td .tooltipster\";i:1349;s:67:\".booked-calendar-wrap .booked-calendar tbody tr.week td:hover .date\";i:1350;s:75:\".booked-calendar-wrap .booked-calendar tbody tr.week td.active .tooltipster\";i:1351;s:68:\".booked-calendar-wrap .booked-calendar tbody tr.week td.active .date\";i:1352;s:58:\".booked-calendar-wrap .booked-calendar tbody tr.entryBlock\";i:1353;s:61:\".booked-calendar-wrap .booked-calendar tbody tr.entryBlock td\";i:1354;s:73:\".booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot button\";i:1355;s:79:\".booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot button:hover\";i:1356;s:87:\".booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot.bookedClearFix:after\";i:1357;s:29:\"body .booked-modal .bm-window\";i:1358;s:112:\"body .booked-modal input[type=submit].button-primary:hover, body .booked-modal input[type=submit].button-primary\";i:1359;s:37:\"body table.booked-calendar tr.days th\";i:1360;s:29:\"body .booked-calendarSwitcher\";i:1361;s:36:\"body .booked-calendarSwitcher select\";i:1362;s:78:\".mptt-shortcode-wrapper table.mptt-shortcode-table thead tr.mptt-shortcode-row\";i:1363;s:93:\".mptt-shortcode-wrapper table.mptt-shortcode-table thead tr.mptt-shortcode-row th:first-child\";i:1364;s:73:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody tr:nth-child(1n)\";i:1365;s:62:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody tr td\";i:1366;s:83:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody tr td.mptt-shortcode-hours\";i:1367;s:78:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody .mptt-event-container\";i:1368;s:84:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody .mptt-event-container:hover\";i:1369;s:97:\".mptt-shortcode-wrapper table.mptt-shortcode-table tbody .mptt-event-container:hover .event-title\";i:1370;s:63:\".mptt-shortcode-wrapper .mptt-shortcode-list li.mptt-list-event\";i:1371;s:26:\".single .mptt-main-wrapper\";i:1372;s:40:\".single .mptt-main-wrapper .mptt-content\";i:1373;s:55:\".single .mptt-main-wrapper .mptt-content .event-content\";i:1374;s:53:\".single .mptt-main-wrapper .mptt-content .events-list\";i:1375;s:55:\".single .mptt-main-wrapper .mptt-content .comments-area\";i:1376;s:72:\".single .mptt-main-wrapper .mptt-content .comments-area .comment-respond\";i:1377;s:198:\".single.single-mp-column .mptt-event.events-list, .single.single-mp-column .mptt-column.events-list, .single.single-mp-event .mptt-event.events-list, .single.single-mp-event .mptt-column.events-list\";i:1378;s:226:\".single.single-mp-column .mptt-event.events-list .event, .single.single-mp-column .mptt-column.events-list .event, .single.single-mp-event .mptt-event.events-list .event, .single.single-mp-event .mptt-column.events-list .event\";i:1379;s:254:\".single.single-mp-column .mptt-event.events-list .event:before, .single.single-mp-column .mptt-column.events-list .event:before, .single.single-mp-event .mptt-event.events-list .event:before, .single.single-mp-event .mptt-column.events-list .event:before\";i:1380;s:294:\".single.single-mp-column .mptt-event.events-list .event .event-thumbnail, .single.single-mp-column .mptt-column.events-list .event .event-thumbnail, .single.single-mp-event .mptt-event.events-list .event .event-thumbnail, .single.single-mp-event .mptt-column.events-list .event .event-thumbnail\";i:1381;s:28:\".mptt-container .widgettitle\";i:1382;s:35:\".mptt-container .widgettitle:before\";i:1383;s:34:\".mptt-container .widgettitle:after\";i:1384;s:128:\".sidebar.widget-area .widget_recent_entries ul li.event .event-link, .footer-area .widget_recent_entries ul li.event .event-link\";i:1385;s:31:\".tm-pg_front_gallery-navigation\";i:1386;s:69:\".tm-pg_front_gallery-navigation .tm_pg_nav-links a.tm_pg_page-numbers\";i:1387;s:150:\".tm-pg_front_gallery-navigation .tm_pg_nav-links a.tm_pg_page-numbers.next, .tm-pg_front_gallery-navigation .tm_pg_nav-links a.tm_pg_page-numbers.prev\";i:1388;s:154:\".tm-pg_front_gallery-navigation .tm_pg_nav-links a.tm_pg_page-numbers.next i, .tm-pg_front_gallery-navigation .tm_pg_nav-links a.tm_pg_page-numbers.prev i\";i:1389;s:163:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_label, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_label, .tm-pg_front_gallery-justify .tm_pg_gallery-item_label\";i:1390;s:181:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_show-more a, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_show-more a, .tm-pg_front_gallery-justify .tm_pg_gallery-item_show-more a\";i:1391;s:196:\".tm-pg_front_gallery-grid .tm_pg_gallery-item_show-more a span, .tm-pg_front_gallery-masonry .tm_pg_gallery-item_show-more a span, .tm-pg_front_gallery-justify .tm_pg_gallery-item_show-more a span\";i:1392;s:80:\".tm-pg_front_gallery .tm-pg_frontend, .tm-pg_front_gallery .dropdown_filter_wrap\";i:1393;s:50:\".tm-pg_front_gallery .load-more-button a.btn:hover\";i:1394;s:50:\".tm-pg_front_gallery .load-more-button a.btn:focus\";i:1395;s:57:\".tm-pg_front_gallery .tm_pg_gallery-item_link_show-more i\";i:1396;s:31:\".tm-pg_front_gallery-tabs:after\";i:1397;s:67:\".tm-pg_front_gallery-tabs .tm-pg_front_gallery-preloader .preloader\";i:1398;s:36:\".tm-pg_front_gallery-tabs li a:after\";i:1399;s:45:\".tm-pg_front_gallery-tabs li.tm_pb_tab_active\";i:1400;s:34:\".type-tm_pg_album, .type-tm_pg_set\";i:1401;s:60:\".type-tm_pg_album .entry-title, .type-tm_pg_set .entry-title\";i:1402;s:76:\".type-tm_pg_album .tm-pg_front_gallery, .type-tm_pg_set .tm-pg_front_gallery\";i:1403;s:54:\".lg-outer .lg-icon.lg-next, .lg-outer .lg-icon.lg-prev\";i:1404;s:136:\".lg-outer .lg-icon.lg-next:after, .lg-outer .lg-icon.lg-next:before, .lg-outer .lg-icon.lg-prev:after, .lg-outer .lg-icon.lg-prev:before\";i:1405;s:90:\".lg-outer .lg-toolbar .lg-icon:hover:after, .lg-outer .lg-thumb-outer .lg-icon:hover:after\";i:1406;s:356:\".lg-outer .lg-icon.lg-toogle-thumb:after, .lg-outer .lg-icon.lg-close:after, .lg-outer .lg-icon.lg-autoplay-button:after, .lg-outer .lg-icon.lg-download:after, .lg-outer .lg-icon.lg-fullscreen:after, .lg-outer .lg-icon.lg-close:after, .lg-outer .lg-icon.lg-autoplay-button:after, .lg-outer .lg-icon.lg-download:after, .lg-outer .lg-icon.lg-fullscreen:after\";i:1407;s:41:\".lg-outer .lg-icon.lg-toogle-thumb:before\";i:1408;s:40:\".lg-outer .lg-icon.lg-toogle-thumb:after\";i:1409;s:33:\".lg-outer .lg-icon.lg-close:after\";i:1410;s:43:\".lg-outer .lg-icon.lg-autoplay-button:after\";i:1411;s:38:\".lg-outer .lg-icon.lg-fullscreen:after\";i:1412;s:55:\".lg-outer.lg-thumb-open .lg-icon.lg-toogle-thumb:before\";i:1413;s:60:\".lg-outer.lg-show-autoplay .lg-icon.lg-autoplay-button:after\";i:1414;s:55:\".lg-outer.lg-fullscreen-on .lg-icon.lg-fullscreen:after\";i:1415;s:14:\".cherry-search\";i:1416;s:27:\".widget-area .cherry-search\";i:1417;s:39:\".cherry-search form.cherry-search__form\";i:1418;s:45:\".cherry-search form.cherry-search__form:after\";i:1419;s:71:\".top-panel .cherry-search form.cherry-search__form input[type=\'search\']\";i:1420;s:60:\".cherry-search form.cherry-search__form button.search-submit\";i:1421;s:71:\".top-panel .cherry-search form.cherry-search__form button.search-submit\";i:1422;s:67:\".cherry-search form.cherry-search__form button.search-submit:before\";i:1423;s:25:\".cherry-search__item-attr\";i:1424;s:52:\".cherry-search__item-attr .cherry-search__item-title\";i:1425;s:59:\".cherry-search__item-attr .cherry-search__item-title strong\";i:1426;s:53:\".cherry-search__item-attr .cherry-search__item-author\";i:1427;s:56:\".cherry-search__item-attr .cherry-search__item-author em\";i:1428;s:28:\".cherry-search__results-list\";i:1429;s:243:\".error404 .cherry-search__more-button, .top-panel .cherry-search__more-button, .widget-area .cherry-search__more-button, .error404 .cherry-search__results-item, .top-panel .cherry-search__results-item, .widget-area .cherry-search__results-item\";i:1430;s:119:\".error404 .cherry-search__more-button, .top-panel .cherry-search__more-button, .widget-area .cherry-search__more-button\";i:1431;s:45:\".cherry-search .cherry-search__results-item a\";i:1432;s:57:\".cherry-search .cherry-search__results-item:first-child a\";i:1433;s:42:\".cherry-search .cherry-search__more-button\";i:1434;s:99:\".cherry-search .cherry-search__results-item:hover, .cherry-search .cherry-search__more-button:hover\";i:1435;s:3:\".fa\";i:1436;s:6:\".fa-lg\";i:1437;s:6:\".fa-2x\";i:1438;s:6:\".fa-3x\";i:1439;s:6:\".fa-4x\";i:1440;s:6:\".fa-5x\";i:1441;s:6:\".fa-fw\";i:1442;s:6:\".fa-ul\";i:1443;s:9:\".fa-ul>li\";i:1444;s:6:\".fa-li\";i:1445;s:12:\".fa-li.fa-lg\";i:1446;s:10:\".fa-border\";i:1447;s:13:\".fa-pull-left\";i:1448;s:14:\".fa-pull-right\";i:1449;s:16:\".fa.fa-pull-left\";i:1450;s:17:\".fa.fa-pull-right\";i:1451;s:11:\".pull-right\";i:1452;s:10:\".pull-left\";i:1453;s:13:\".fa.pull-left\";i:1454;s:14:\".fa.pull-right\";i:1455;s:8:\".fa-spin\";i:1456;s:9:\".fa-pulse\";i:1457;s:13:\".fa-rotate-90\";i:1458;s:14:\".fa-rotate-180\";i:1459;s:14:\".fa-rotate-270\";i:1460;s:19:\".fa-flip-horizontal\";i:1461;s:17:\".fa-flip-vertical\";i:1462;s:115:\":root .fa-rotate-90, :root .fa-rotate-180, :root .fa-rotate-270, :root .fa-flip-horizontal, :root .fa-flip-vertical\";i:1463;s:9:\".fa-stack\";i:1464;s:26:\".fa-stack-1x, .fa-stack-2x\";i:1465;s:12:\".fa-stack-1x\";i:1466;s:12:\".fa-stack-2x\";i:1467;s:11:\".fa-inverse\";i:1468;s:16:\".fa-glass:before\";i:1469;s:16:\".fa-music:before\";i:1470;s:17:\".fa-search:before\";i:1471;s:21:\".fa-envelope-o:before\";i:1472;s:16:\".fa-heart:before\";i:1473;s:15:\".fa-star:before\";i:1474;s:17:\".fa-star-o:before\";i:1475;s:15:\".fa-user:before\";i:1476;s:15:\".fa-film:before\";i:1477;s:19:\".fa-th-large:before\";i:1478;s:13:\".fa-th:before\";i:1479;s:18:\".fa-th-list:before\";i:1480;s:16:\".fa-check:before\";i:1481;s:53:\".fa-remove:before, .fa-close:before, .fa-times:before\";i:1482;s:22:\".fa-search-plus:before\";i:1483;s:23:\".fa-search-minus:before\";i:1484;s:20:\".fa-power-off:before\";i:1485;s:17:\".fa-signal:before\";i:1486;s:31:\".fa-gear:before, .fa-cog:before\";i:1487;s:18:\".fa-trash-o:before\";i:1488;s:15:\".fa-home:before\";i:1489;s:17:\".fa-file-o:before\";i:1490;s:18:\".fa-clock-o:before\";i:1491;s:15:\".fa-road:before\";i:1492;s:19:\".fa-download:before\";i:1493;s:30:\".fa-arrow-circle-o-down:before\";i:1494;s:28:\".fa-arrow-circle-o-up:before\";i:1495;s:16:\".fa-inbox:before\";i:1496;s:24:\".fa-play-circle-o:before\";i:1497;s:42:\".fa-rotate-right:before, .fa-repeat:before\";i:1498;s:18:\".fa-refresh:before\";i:1499;s:19:\".fa-list-alt:before\";i:1500;s:15:\".fa-lock:before\";i:1501;s:15:\".fa-flag:before\";i:1502;s:21:\".fa-headphones:before\";i:1503;s:21:\".fa-volume-off:before\";i:1504;s:22:\".fa-volume-down:before\";i:1505;s:20:\".fa-volume-up:before\";i:1506;s:17:\".fa-qrcode:before\";i:1507;s:18:\".fa-barcode:before\";i:1508;s:14:\".fa-tag:before\";i:1509;s:15:\".fa-tags:before\";i:1510;s:15:\".fa-book:before\";i:1511;s:19:\".fa-bookmark:before\";i:1512;s:16:\".fa-print:before\";i:1513;s:17:\".fa-camera:before\";i:1514;s:15:\".fa-font:before\";i:1515;s:15:\".fa-bold:before\";i:1516;s:17:\".fa-italic:before\";i:1517;s:22:\".fa-text-height:before\";i:1518;s:21:\".fa-text-width:before\";i:1519;s:21:\".fa-align-left:before\";i:1520;s:23:\".fa-align-center:before\";i:1521;s:22:\".fa-align-right:before\";i:1522;s:24:\".fa-align-justify:before\";i:1523;s:15:\".fa-list:before\";i:1524;s:37:\".fa-dedent:before, .fa-outdent:before\";i:1525;s:17:\".fa-indent:before\";i:1526;s:23:\".fa-video-camera:before\";i:1527;s:56:\".fa-photo:before, .fa-image:before, .fa-picture-o:before\";i:1528;s:17:\".fa-pencil:before\";i:1529;s:21:\".fa-map-marker:before\";i:1530;s:17:\".fa-adjust:before\";i:1531;s:15:\".fa-tint:before\";i:1532;s:43:\".fa-edit:before, .fa-pencil-square-o:before\";i:1533;s:25:\".fa-share-square-o:before\";i:1534;s:25:\".fa-check-square-o:before\";i:1535;s:17:\".fa-arrows:before\";i:1536;s:24:\".fa-step-backward:before\";i:1537;s:24:\".fa-fast-backward:before\";i:1538;s:19:\".fa-backward:before\";i:1539;s:15:\".fa-play:before\";i:1540;s:16:\".fa-pause:before\";i:1541;s:15:\".fa-stop:before\";i:1542;s:18:\".fa-forward:before\";i:1543;s:23:\".fa-fast-forward:before\";i:1544;s:23:\".fa-step-forward:before\";i:1545;s:16:\".fa-eject:before\";i:1546;s:23:\".fa-chevron-left:before\";i:1547;s:24:\".fa-chevron-right:before\";i:1548;s:22:\".fa-plus-circle:before\";i:1549;s:23:\".fa-minus-circle:before\";i:1550;s:23:\".fa-times-circle:before\";i:1551;s:23:\".fa-check-circle:before\";i:1552;s:26:\".fa-question-circle:before\";i:1553;s:22:\".fa-info-circle:before\";i:1554;s:21:\".fa-crosshairs:before\";i:1555;s:25:\".fa-times-circle-o:before\";i:1556;s:25:\".fa-check-circle-o:before\";i:1557;s:14:\".fa-ban:before\";i:1558;s:21:\".fa-arrow-left:before\";i:1559;s:22:\".fa-arrow-right:before\";i:1560;s:19:\".fa-arrow-up:before\";i:1561;s:21:\".fa-arrow-down:before\";i:1562;s:41:\".fa-mail-forward:before, .fa-share:before\";i:1563;s:17:\".fa-expand:before\";i:1564;s:19:\".fa-compress:before\";i:1565;s:15:\".fa-plus:before\";i:1566;s:16:\".fa-minus:before\";i:1567;s:19:\".fa-asterisk:before\";i:1568;s:29:\".fa-exclamation-circle:before\";i:1569;s:15:\".fa-gift:before\";i:1570;s:15:\".fa-leaf:before\";i:1571;s:15:\".fa-fire:before\";i:1572;s:14:\".fa-eye:before\";i:1573;s:20:\".fa-eye-slash:before\";i:1574;s:51:\".fa-warning:before, .fa-exclamation-triangle:before\";i:1575;s:16:\".fa-plane:before\";i:1576;s:19:\".fa-calendar:before\";i:1577;s:17:\".fa-random:before\";i:1578;s:18:\".fa-comment:before\";i:1579;s:17:\".fa-magnet:before\";i:1580;s:21:\".fa-chevron-up:before\";i:1581;s:23:\".fa-chevron-down:before\";i:1582;s:18:\".fa-retweet:before\";i:1583;s:24:\".fa-shopping-cart:before\";i:1584;s:17:\".fa-folder:before\";i:1585;s:22:\".fa-folder-open:before\";i:1586;s:19:\".fa-arrows-v:before\";i:1587;s:19:\".fa-arrows-h:before\";i:1588;s:44:\".fa-bar-chart-o:before, .fa-bar-chart:before\";i:1589;s:25:\".fa-twitter-square:before\";i:1590;s:26:\".fa-facebook-square:before\";i:1591;s:23:\".fa-camera-retro:before\";i:1592;s:14:\".fa-key:before\";i:1593;s:33:\".fa-gears:before, .fa-cogs:before\";i:1594;s:19:\".fa-comments:before\";i:1595;s:22:\".fa-thumbs-o-up:before\";i:1596;s:24:\".fa-thumbs-o-down:before\";i:1597;s:20:\".fa-star-half:before\";i:1598;s:18:\".fa-heart-o:before\";i:1599;s:19:\".fa-sign-out:before\";i:1600;s:26:\".fa-linkedin-square:before\";i:1601;s:21:\".fa-thumb-tack:before\";i:1602;s:24:\".fa-external-link:before\";i:1603;s:18:\".fa-sign-in:before\";i:1604;s:17:\".fa-trophy:before\";i:1605;s:24:\".fa-github-square:before\";i:1606;s:17:\".fa-upload:before\";i:1607;s:18:\".fa-lemon-o:before\";i:1608;s:16:\".fa-phone:before\";i:1609;s:19:\".fa-square-o:before\";i:1610;s:21:\".fa-bookmark-o:before\";i:1611;s:23:\".fa-phone-square:before\";i:1612;s:18:\".fa-twitter:before\";i:1613;s:42:\".fa-facebook-f:before, .fa-facebook:before\";i:1614;s:17:\".fa-github:before\";i:1615;s:17:\".fa-unlock:before\";i:1616;s:22:\".fa-credit-card:before\";i:1617;s:31:\".fa-feed:before, .fa-rss:before\";i:1618;s:16:\".fa-hdd-o:before\";i:1619;s:19:\".fa-bullhorn:before\";i:1620;s:15:\".fa-bell:before\";i:1621;s:22:\".fa-certificate:before\";i:1622;s:23:\".fa-hand-o-right:before\";i:1623;s:22:\".fa-hand-o-left:before\";i:1624;s:20:\".fa-hand-o-up:before\";i:1625;s:22:\".fa-hand-o-down:before\";i:1626;s:28:\".fa-arrow-circle-left:before\";i:1627;s:29:\".fa-arrow-circle-right:before\";i:1628;s:26:\".fa-arrow-circle-up:before\";i:1629;s:28:\".fa-arrow-circle-down:before\";i:1630;s:16:\".fa-globe:before\";i:1631;s:17:\".fa-wrench:before\";i:1632;s:16:\".fa-tasks:before\";i:1633;s:17:\".fa-filter:before\";i:1634;s:20:\".fa-briefcase:before\";i:1635;s:21:\".fa-arrows-alt:before\";i:1636;s:34:\".fa-group:before, .fa-users:before\";i:1637;s:33:\".fa-chain:before, .fa-link:before\";i:1638;s:16:\".fa-cloud:before\";i:1639;s:16:\".fa-flask:before\";i:1640;s:35:\".fa-cut:before, .fa-scissors:before\";i:1641;s:35:\".fa-copy:before, .fa-files-o:before\";i:1642;s:20:\".fa-paperclip:before\";i:1643;s:36:\".fa-save:before, .fa-floppy-o:before\";i:1644;s:17:\".fa-square:before\";i:1645;s:55:\".fa-navicon:before, .fa-reorder:before, .fa-bars:before\";i:1646;s:18:\".fa-list-ul:before\";i:1647;s:18:\".fa-list-ol:before\";i:1648;s:24:\".fa-strikethrough:before\";i:1649;s:20:\".fa-underline:before\";i:1650;s:16:\".fa-table:before\";i:1651;s:16:\".fa-magic:before\";i:1652;s:16:\".fa-truck:before\";i:1653;s:20:\".fa-pinterest:before\";i:1654;s:27:\".fa-pinterest-square:before\";i:1655;s:29:\".fa-google-plus-square:before\";i:1656;s:22:\".fa-google-plus:before\";i:1657;s:16:\".fa-money:before\";i:1658;s:21:\".fa-caret-down:before\";i:1659;s:19:\".fa-caret-up:before\";i:1660;s:21:\".fa-caret-left:before\";i:1661;s:22:\".fa-caret-right:before\";i:1662;s:18:\".fa-columns:before\";i:1663;s:36:\".fa-unsorted:before, .fa-sort:before\";i:1664;s:42:\".fa-sort-down:before, .fa-sort-desc:before\";i:1665;s:39:\".fa-sort-up:before, .fa-sort-asc:before\";i:1666;s:19:\".fa-envelope:before\";i:1667;s:19:\".fa-linkedin:before\";i:1668;s:39:\".fa-rotate-left:before, .fa-undo:before\";i:1669;s:34:\".fa-legal:before, .fa-gavel:before\";i:1670;s:43:\".fa-dashboard:before, .fa-tachometer:before\";i:1671;s:20:\".fa-comment-o:before\";i:1672;s:21:\".fa-comments-o:before\";i:1673;s:33:\".fa-flash:before, .fa-bolt:before\";i:1674;s:18:\".fa-sitemap:before\";i:1675;s:19:\".fa-umbrella:before\";i:1676;s:38:\".fa-paste:before, .fa-clipboard:before\";i:1677;s:22:\".fa-lightbulb-o:before\";i:1678;s:19:\".fa-exchange:before\";i:1679;s:25:\".fa-cloud-download:before\";i:1680;s:23:\".fa-cloud-upload:before\";i:1681;s:18:\".fa-user-md:before\";i:1682;s:22:\".fa-stethoscope:before\";i:1683;s:19:\".fa-suitcase:before\";i:1684;s:17:\".fa-bell-o:before\";i:1685;s:17:\".fa-coffee:before\";i:1686;s:18:\".fa-cutlery:before\";i:1687;s:22:\".fa-file-text-o:before\";i:1688;s:21:\".fa-building-o:before\";i:1689;s:21:\".fa-hospital-o:before\";i:1690;s:20:\".fa-ambulance:before\";i:1691;s:17:\".fa-medkit:before\";i:1692;s:22:\".fa-fighter-jet:before\";i:1693;s:15:\".fa-beer:before\";i:1694;s:19:\".fa-h-square:before\";i:1695;s:22:\".fa-plus-square:before\";i:1696;s:28:\".fa-angle-double-left:before\";i:1697;s:29:\".fa-angle-double-right:before\";i:1698;s:26:\".fa-angle-double-up:before\";i:1699;s:28:\".fa-angle-double-down:before\";i:1700;s:21:\".fa-angle-left:before\";i:1701;s:22:\".fa-angle-right:before\";i:1702;s:19:\".fa-angle-up:before\";i:1703;s:21:\".fa-angle-down:before\";i:1704;s:18:\".fa-desktop:before\";i:1705;s:17:\".fa-laptop:before\";i:1706;s:17:\".fa-tablet:before\";i:1707;s:42:\".fa-mobile-phone:before, .fa-mobile:before\";i:1708;s:19:\".fa-circle-o:before\";i:1709;s:21:\".fa-quote-left:before\";i:1710;s:22:\".fa-quote-right:before\";i:1711;s:18:\".fa-spinner:before\";i:1712;s:17:\".fa-circle:before\";i:1713;s:39:\".fa-mail-reply:before, .fa-reply:before\";i:1714;s:21:\".fa-github-alt:before\";i:1715;s:19:\".fa-folder-o:before\";i:1716;s:24:\".fa-folder-open-o:before\";i:1717;s:18:\".fa-smile-o:before\";i:1718;s:18:\".fa-frown-o:before\";i:1719;s:16:\".fa-meh-o:before\";i:1720;s:18:\".fa-gamepad:before\";i:1721;s:21:\".fa-keyboard-o:before\";i:1722;s:17:\".fa-flag-o:before\";i:1723;s:25:\".fa-flag-checkered:before\";i:1724;s:19:\".fa-terminal:before\";i:1725;s:15:\".fa-code:before\";i:1726;s:47:\".fa-mail-reply-all:before, .fa-reply-all:before\";i:1727;s:77:\".fa-star-half-empty:before, .fa-star-half-full:before, .fa-star-half-o:before\";i:1728;s:25:\".fa-location-arrow:before\";i:1729;s:15:\".fa-crop:before\";i:1730;s:20:\".fa-code-fork:before\";i:1731;s:42:\".fa-unlink:before, .fa-chain-broken:before\";i:1732;s:19:\".fa-question:before\";i:1733;s:15:\".fa-info:before\";i:1734;s:22:\".fa-exclamation:before\";i:1735;s:22:\".fa-superscript:before\";i:1736;s:20:\".fa-subscript:before\";i:1737;s:17:\".fa-eraser:before\";i:1738;s:23:\".fa-puzzle-piece:before\";i:1739;s:21:\".fa-microphone:before\";i:1740;s:27:\".fa-microphone-slash:before\";i:1741;s:17:\".fa-shield:before\";i:1742;s:21:\".fa-calendar-o:before\";i:1743;s:28:\".fa-fire-extinguisher:before\";i:1744;s:17:\".fa-rocket:before\";i:1745;s:17:\".fa-maxcdn:before\";i:1746;s:30:\".fa-chevron-circle-left:before\";i:1747;s:31:\".fa-chevron-circle-right:before\";i:1748;s:28:\".fa-chevron-circle-up:before\";i:1749;s:30:\".fa-chevron-circle-down:before\";i:1750;s:16:\".fa-html5:before\";i:1751;s:15:\".fa-css3:before\";i:1752;s:17:\".fa-anchor:before\";i:1753;s:21:\".fa-unlock-alt:before\";i:1754;s:19:\".fa-bullseye:before\";i:1755;s:21:\".fa-ellipsis-h:before\";i:1756;s:21:\".fa-ellipsis-v:before\";i:1757;s:21:\".fa-rss-square:before\";i:1758;s:22:\".fa-play-circle:before\";i:1759;s:17:\".fa-ticket:before\";i:1760;s:23:\".fa-minus-square:before\";i:1761;s:25:\".fa-minus-square-o:before\";i:1762;s:19:\".fa-level-up:before\";i:1763;s:21:\".fa-level-down:before\";i:1764;s:23:\".fa-check-square:before\";i:1765;s:24:\".fa-pencil-square:before\";i:1766;s:31:\".fa-external-link-square:before\";i:1767;s:23:\".fa-share-square:before\";i:1768;s:18:\".fa-compass:before\";i:1769;s:54:\".fa-toggle-down:before, .fa-caret-square-o-down:before\";i:1770;s:50:\".fa-toggle-up:before, .fa-caret-square-o-up:before\";i:1771;s:56:\".fa-toggle-right:before, .fa-caret-square-o-right:before\";i:1772;s:31:\".fa-euro:before, .fa-eur:before\";i:1773;s:14:\".fa-gbp:before\";i:1774;s:33:\".fa-dollar:before, .fa-usd:before\";i:1775;s:32:\".fa-rupee:before, .fa-inr:before\";i:1776;s:62:\".fa-cny:before, .fa-rmb:before, .fa-yen:before, .fa-jpy:before\";i:1777;s:51:\".fa-ruble:before, .fa-rouble:before, .fa-rub:before\";i:1778;s:30:\".fa-won:before, .fa-krw:before\";i:1779;s:34:\".fa-bitcoin:before, .fa-btc:before\";i:1780;s:15:\".fa-file:before\";i:1781;s:20:\".fa-file-text:before\";i:1782;s:25:\".fa-sort-alpha-asc:before\";i:1783;s:26:\".fa-sort-alpha-desc:before\";i:1784;s:26:\".fa-sort-amount-asc:before\";i:1785;s:27:\".fa-sort-amount-desc:before\";i:1786;s:27:\".fa-sort-numeric-asc:before\";i:1787;s:28:\".fa-sort-numeric-desc:before\";i:1788;s:20:\".fa-thumbs-up:before\";i:1789;s:22:\".fa-thumbs-down:before\";i:1790;s:25:\".fa-youtube-square:before\";i:1791;s:18:\".fa-youtube:before\";i:1792;s:15:\".fa-xing:before\";i:1793;s:22:\".fa-xing-square:before\";i:1794;s:23:\".fa-youtube-play:before\";i:1795;s:18:\".fa-dropbox:before\";i:1796;s:25:\".fa-stack-overflow:before\";i:1797;s:20:\".fa-instagram:before\";i:1798;s:17:\".fa-flickr:before\";i:1799;s:14:\".fa-adn:before\";i:1800;s:20:\".fa-bitbucket:before\";i:1801;s:27:\".fa-bitbucket-square:before\";i:1802;s:17:\".fa-tumblr:before\";i:1803;s:24:\".fa-tumblr-square:before\";i:1804;s:26:\".fa-long-arrow-down:before\";i:1805;s:24:\".fa-long-arrow-up:before\";i:1806;s:26:\".fa-long-arrow-left:before\";i:1807;s:27:\".fa-long-arrow-right:before\";i:1808;s:16:\".fa-apple:before\";i:1809;s:18:\".fa-windows:before\";i:1810;s:18:\".fa-android:before\";i:1811;s:16:\".fa-linux:before\";i:1812;s:19:\".fa-dribbble:before\";i:1813;s:16:\".fa-skype:before\";i:1814;s:21:\".fa-foursquare:before\";i:1815;s:17:\".fa-trello:before\";i:1816;s:17:\".fa-female:before\";i:1817;s:15:\".fa-male:before\";i:1818;s:38:\".fa-gittip:before, .fa-gratipay:before\";i:1819;s:16:\".fa-sun-o:before\";i:1820;s:17:\".fa-moon-o:before\";i:1821;s:18:\".fa-archive:before\";i:1822;s:14:\".fa-bug:before\";i:1823;s:13:\".fa-vk:before\";i:1824;s:16:\".fa-weibo:before\";i:1825;s:17:\".fa-renren:before\";i:1826;s:20:\".fa-pagelines:before\";i:1827;s:25:\".fa-stack-exchange:before\";i:1828;s:31:\".fa-arrow-circle-o-right:before\";i:1829;s:30:\".fa-arrow-circle-o-left:before\";i:1830;s:54:\".fa-toggle-left:before, .fa-caret-square-o-left:before\";i:1831;s:23:\".fa-dot-circle-o:before\";i:1832;s:21:\".fa-wheelchair:before\";i:1833;s:23:\".fa-vimeo-square:before\";i:1834;s:39:\".fa-turkish-lira:before, .fa-try:before\";i:1835;s:24:\".fa-plus-square-o:before\";i:1836;s:24:\".fa-space-shuttle:before\";i:1837;s:16:\".fa-slack:before\";i:1838;s:26:\".fa-envelope-square:before\";i:1839;s:20:\".fa-wordpress:before\";i:1840;s:17:\".fa-openid:before\";i:1841;s:62:\".fa-institution:before, .fa-bank:before, .fa-university:before\";i:1842;s:50:\".fa-mortar-board:before, .fa-graduation-cap:before\";i:1843;s:16:\".fa-yahoo:before\";i:1844;s:17:\".fa-google:before\";i:1845;s:17:\".fa-reddit:before\";i:1846;s:24:\".fa-reddit-square:before\";i:1847;s:29:\".fa-stumbleupon-circle:before\";i:1848;s:22:\".fa-stumbleupon:before\";i:1849;s:20:\".fa-delicious:before\";i:1850;s:15:\".fa-digg:before\";i:1851;s:24:\".fa-pied-piper-pp:before\";i:1852;s:25:\".fa-pied-piper-alt:before\";i:1853;s:17:\".fa-drupal:before\";i:1854;s:17:\".fa-joomla:before\";i:1855;s:19:\".fa-language:before\";i:1856;s:14:\".fa-fax:before\";i:1857;s:19:\".fa-building:before\";i:1858;s:16:\".fa-child:before\";i:1859;s:14:\".fa-paw:before\";i:1860;s:16:\".fa-spoon:before\";i:1861;s:15:\".fa-cube:before\";i:1862;s:16:\".fa-cubes:before\";i:1863;s:18:\".fa-behance:before\";i:1864;s:25:\".fa-behance-square:before\";i:1865;s:16:\".fa-steam:before\";i:1866;s:23:\".fa-steam-square:before\";i:1867;s:18:\".fa-recycle:before\";i:1868;s:37:\".fa-automobile:before, .fa-car:before\";i:1869;s:31:\".fa-cab:before, .fa-taxi:before\";i:1870;s:15:\".fa-tree:before\";i:1871;s:18:\".fa-spotify:before\";i:1872;s:21:\".fa-deviantart:before\";i:1873;s:21:\".fa-soundcloud:before\";i:1874;s:19:\".fa-database:before\";i:1875;s:21:\".fa-file-pdf-o:before\";i:1876;s:22:\".fa-file-word-o:before\";i:1877;s:23:\".fa-file-excel-o:before\";i:1878;s:28:\".fa-file-powerpoint-o:before\";i:1879;s:75:\".fa-file-photo-o:before, .fa-file-picture-o:before, .fa-file-image-o:before\";i:1880;s:48:\".fa-file-zip-o:before, .fa-file-archive-o:before\";i:1881;s:48:\".fa-file-sound-o:before, .fa-file-audio-o:before\";i:1882;s:48:\".fa-file-movie-o:before, .fa-file-video-o:before\";i:1883;s:22:\".fa-file-code-o:before\";i:1884;s:15:\".fa-vine:before\";i:1885;s:18:\".fa-codepen:before\";i:1886;s:19:\".fa-jsfiddle:before\";i:1887;s:107:\".fa-life-bouy:before, .fa-life-buoy:before, .fa-life-saver:before, .fa-support:before, .fa-life-ring:before\";i:1888;s:25:\".fa-circle-o-notch:before\";i:1889;s:54:\".fa-ra:before, .fa-resistance:before, .fa-rebel:before\";i:1890;s:32:\".fa-ge:before, .fa-empire:before\";i:1891;s:21:\".fa-git-square:before\";i:1892;s:14:\".fa-git:before\";i:1893;s:76:\".fa-y-combinator-square:before, .fa-yc-square:before, .fa-hacker-news:before\";i:1894;s:24:\".fa-tencent-weibo:before\";i:1895;s:13:\".fa-qq:before\";i:1896;s:36:\".fa-wechat:before, .fa-weixin:before\";i:1897;s:39:\".fa-send:before, .fa-paper-plane:before\";i:1898;s:43:\".fa-send-o:before, .fa-paper-plane-o:before\";i:1899;s:18:\".fa-history:before\";i:1900;s:22:\".fa-circle-thin:before\";i:1901;s:17:\".fa-header:before\";i:1902;s:20:\".fa-paragraph:before\";i:1903;s:18:\".fa-sliders:before\";i:1904;s:20:\".fa-share-alt:before\";i:1905;s:27:\".fa-share-alt-square:before\";i:1906;s:15:\".fa-bomb:before\";i:1907;s:45:\".fa-soccer-ball-o:before, .fa-futbol-o:before\";i:1908;s:14:\".fa-tty:before\";i:1909;s:21:\".fa-binoculars:before\";i:1910;s:15:\".fa-plug:before\";i:1911;s:21:\".fa-slideshare:before\";i:1912;s:17:\".fa-twitch:before\";i:1913;s:15:\".fa-yelp:before\";i:1914;s:22:\".fa-newspaper-o:before\";i:1915;s:15:\".fa-wifi:before\";i:1916;s:21:\".fa-calculator:before\";i:1917;s:17:\".fa-paypal:before\";i:1918;s:24:\".fa-google-wallet:before\";i:1919;s:18:\".fa-cc-visa:before\";i:1920;s:24:\".fa-cc-mastercard:before\";i:1921;s:22:\".fa-cc-discover:before\";i:1922;s:18:\".fa-cc-amex:before\";i:1923;s:20:\".fa-cc-paypal:before\";i:1924;s:20:\".fa-cc-stripe:before\";i:1925;s:21:\".fa-bell-slash:before\";i:1926;s:23:\".fa-bell-slash-o:before\";i:1927;s:16:\".fa-trash:before\";i:1928;s:20:\".fa-copyright:before\";i:1929;s:13:\".fa-at:before\";i:1930;s:21:\".fa-eyedropper:before\";i:1931;s:22:\".fa-paint-brush:before\";i:1932;s:24:\".fa-birthday-cake:before\";i:1933;s:21:\".fa-area-chart:before\";i:1934;s:20:\".fa-pie-chart:before\";i:1935;s:21:\".fa-line-chart:before\";i:1936;s:17:\".fa-lastfm:before\";i:1937;s:24:\".fa-lastfm-square:before\";i:1938;s:21:\".fa-toggle-off:before\";i:1939;s:20:\".fa-toggle-on:before\";i:1940;s:18:\".fa-bicycle:before\";i:1941;s:14:\".fa-bus:before\";i:1942;s:18:\".fa-ioxhost:before\";i:1943;s:20:\".fa-angellist:before\";i:1944;s:13:\".fa-cc:before\";i:1945;s:52:\".fa-shekel:before, .fa-sheqel:before, .fa-ils:before\";i:1946;s:19:\".fa-meanpath:before\";i:1947;s:21:\".fa-buysellads:before\";i:1948;s:25:\".fa-connectdevelop:before\";i:1949;s:19:\".fa-dashcube:before\";i:1950;s:19:\".fa-forumbee:before\";i:1951;s:18:\".fa-leanpub:before\";i:1952;s:17:\".fa-sellsy:before\";i:1953;s:23:\".fa-shirtsinbulk:before\";i:1954;s:22:\".fa-simplybuilt:before\";i:1955;s:19:\".fa-skyatlas:before\";i:1956;s:20:\".fa-cart-plus:before\";i:1957;s:26:\".fa-cart-arrow-down:before\";i:1958;s:18:\".fa-diamond:before\";i:1959;s:15:\".fa-ship:before\";i:1960;s:22:\".fa-user-secret:before\";i:1961;s:21:\".fa-motorcycle:before\";i:1962;s:22:\".fa-street-view:before\";i:1963;s:20:\".fa-heartbeat:before\";i:1964;s:16:\".fa-venus:before\";i:1965;s:15:\".fa-mars:before\";i:1966;s:18:\".fa-mercury:before\";i:1967;s:43:\".fa-intersex:before, .fa-transgender:before\";i:1968;s:26:\".fa-transgender-alt:before\";i:1969;s:23:\".fa-venus-double:before\";i:1970;s:22:\".fa-mars-double:before\";i:1971;s:21:\".fa-venus-mars:before\";i:1972;s:22:\".fa-mars-stroke:before\";i:1973;s:24:\".fa-mars-stroke-v:before\";i:1974;s:24:\".fa-mars-stroke-h:before\";i:1975;s:17:\".fa-neuter:before\";i:1976;s:21:\".fa-genderless:before\";i:1977;s:28:\".fa-facebook-official:before\";i:1978;s:22:\".fa-pinterest-p:before\";i:1979;s:19:\".fa-whatsapp:before\";i:1980;s:17:\".fa-server:before\";i:1981;s:20:\".fa-user-plus:before\";i:1982;s:21:\".fa-user-times:before\";i:1983;s:32:\".fa-hotel:before, .fa-bed:before\";i:1984;s:18:\".fa-viacoin:before\";i:1985;s:16:\".fa-train:before\";i:1986;s:17:\".fa-subway:before\";i:1987;s:17:\".fa-medium:before\";i:1988;s:38:\".fa-yc:before, .fa-y-combinator:before\";i:1989;s:24:\".fa-optin-monster:before\";i:1990;s:19:\".fa-opencart:before\";i:1991;s:23:\".fa-expeditedssl:before\";i:1992;s:45:\".fa-battery-4:before, .fa-battery-full:before\";i:1993;s:55:\".fa-battery-3:before, .fa-battery-three-quarters:before\";i:1994;s:45:\".fa-battery-2:before, .fa-battery-half:before\";i:1995;s:48:\".fa-battery-1:before, .fa-battery-quarter:before\";i:1996;s:46:\".fa-battery-0:before, .fa-battery-empty:before\";i:1997;s:24:\".fa-mouse-pointer:before\";i:1998;s:19:\".fa-i-cursor:before\";i:1999;s:23:\".fa-object-group:before\";i:2000;s:25:\".fa-object-ungroup:before\";i:2001;s:22:\".fa-sticky-note:before\";i:2002;s:24:\".fa-sticky-note-o:before\";i:2003;s:17:\".fa-cc-jcb:before\";i:2004;s:25:\".fa-cc-diners-club:before\";i:2005;s:16:\".fa-clone:before\";i:2006;s:24:\".fa-balance-scale:before\";i:2007;s:22:\".fa-hourglass-o:before\";i:2008;s:50:\".fa-hourglass-1:before, .fa-hourglass-start:before\";i:2009;s:49:\".fa-hourglass-2:before, .fa-hourglass-half:before\";i:2010;s:48:\".fa-hourglass-3:before, .fa-hourglass-end:before\";i:2011;s:20:\".fa-hourglass:before\";i:2012;s:46:\".fa-hand-grab-o:before, .fa-hand-rock-o:before\";i:2013;s:47:\".fa-hand-stop-o:before, .fa-hand-paper-o:before\";i:2014;s:26:\".fa-hand-scissors-o:before\";i:2015;s:24:\".fa-hand-lizard-o:before\";i:2016;s:23:\".fa-hand-spock-o:before\";i:2017;s:25:\".fa-hand-pointer-o:before\";i:2018;s:23:\".fa-hand-peace-o:before\";i:2019;s:20:\".fa-trademark:before\";i:2020;s:21:\".fa-registered:before\";i:2021;s:27:\".fa-creative-commons:before\";i:2022;s:13:\".fa-gg:before\";i:2023;s:20:\".fa-gg-circle:before\";i:2024;s:22:\".fa-tripadvisor:before\";i:2025;s:24:\".fa-odnoklassniki:before\";i:2026;s:31:\".fa-odnoklassniki-square:before\";i:2027;s:21:\".fa-get-pocket:before\";i:2028;s:22:\".fa-wikipedia-w:before\";i:2029;s:17:\".fa-safari:before\";i:2030;s:17:\".fa-chrome:before\";i:2031;s:18:\".fa-firefox:before\";i:2032;s:16:\".fa-opera:before\";i:2033;s:28:\".fa-internet-explorer:before\";i:2034;s:36:\".fa-tv:before, .fa-television:before\";i:2035;s:17:\".fa-contao:before\";i:2036;s:16:\".fa-500px:before\";i:2037;s:17:\".fa-amazon:before\";i:2038;s:26:\".fa-calendar-plus-o:before\";i:2039;s:27:\".fa-calendar-minus-o:before\";i:2040;s:27:\".fa-calendar-times-o:before\";i:2041;s:27:\".fa-calendar-check-o:before\";i:2042;s:19:\".fa-industry:before\";i:2043;s:18:\".fa-map-pin:before\";i:2044;s:20:\".fa-map-signs:before\";i:2045;s:16:\".fa-map-o:before\";i:2046;s:14:\".fa-map:before\";i:2047;s:21:\".fa-commenting:before\";i:2048;s:23:\".fa-commenting-o:before\";i:2049;s:16:\".fa-houzz:before\";i:2050;s:16:\".fa-vimeo:before\";i:2051;s:20:\".fa-black-tie:before\";i:2052;s:20:\".fa-fonticons:before\";i:2053;s:23:\".fa-reddit-alien:before\";i:2054;s:15:\".fa-edge:before\";i:2055;s:26:\".fa-credit-card-alt:before\";i:2056;s:19:\".fa-codiepie:before\";i:2057;s:15:\".fa-modx:before\";i:2058;s:23:\".fa-fort-awesome:before\";i:2059;s:14:\".fa-usb:before\";i:2060;s:23:\".fa-product-hunt:before\";i:2061;s:19:\".fa-mixcloud:before\";i:2062;s:17:\".fa-scribd:before\";i:2063;s:23:\".fa-pause-circle:before\";i:2064;s:25:\".fa-pause-circle-o:before\";i:2065;s:22:\".fa-stop-circle:before\";i:2066;s:24:\".fa-stop-circle-o:before\";i:2067;s:23:\".fa-shopping-bag:before\";i:2068;s:26:\".fa-shopping-basket:before\";i:2069;s:18:\".fa-hashtag:before\";i:2070;s:20:\".fa-bluetooth:before\";i:2071;s:22:\".fa-bluetooth-b:before\";i:2072;s:18:\".fa-percent:before\";i:2073;s:17:\".fa-gitlab:before\";i:2074;s:21:\".fa-wpbeginner:before\";i:2075;s:18:\".fa-wpforms:before\";i:2076;s:17:\".fa-envira:before\";i:2077;s:27:\".fa-universal-access:before\";i:2078;s:25:\".fa-wheelchair-alt:before\";i:2079;s:28:\".fa-question-circle-o:before\";i:2080;s:16:\".fa-blind:before\";i:2081;s:28:\".fa-audio-description:before\";i:2082;s:31:\".fa-volume-control-phone:before\";i:2083;s:18:\".fa-braille:before\";i:2084;s:38:\".fa-assistive-listening-systems:before\";i:2085;s:75:\".fa-asl-interpreting:before, .fa-american-sign-language-interpreting:before\";i:2086;s:64:\".fa-deafness:before, .fa-hard-of-hearing:before, .fa-deaf:before\";i:2087;s:16:\".fa-glide:before\";i:2088;s:18:\".fa-glide-g:before\";i:2089;s:44:\".fa-signing:before, .fa-sign-language:before\";i:2090;s:21:\".fa-low-vision:before\";i:2091;s:17:\".fa-viadeo:before\";i:2092;s:24:\".fa-viadeo-square:before\";i:2093;s:19:\".fa-snapchat:before\";i:2094;s:25:\".fa-snapchat-ghost:before\";i:2095;s:26:\".fa-snapchat-square:before\";i:2096;s:21:\".fa-pied-piper:before\";i:2097;s:22:\".fa-first-order:before\";i:2098;s:16:\".fa-yoast:before\";i:2099;s:20:\".fa-themeisle:before\";i:2100;s:62:\".fa-google-plus-circle:before, .fa-google-plus-official:before\";i:2101;s:38:\".fa-fa:before, .fa-font-awesome:before\";i:2102;s:8:\".sr-only\";i:2103;s:51:\".sr-only-focusable:active, .sr-only-focusable:focus\";i:2104;s:37:\".tm_font_icon .material-design:before\";i:2105;s:164:\".material-design-ico, [class^=\"material-design-\"]:before, [class*=\" material-design-\"]:before, [class^=\"material-design-\"]:after, [class*=\" material-design-\"]:after\";i:2106;s:32:\".material-design-account4:before\";i:2107;s:30:\".material-design-add179:before\";i:2108;s:30:\".material-design-add180:before\";i:2109;s:30:\".material-design-add181:before\";i:2110;s:30:\".material-design-add182:before\";i:2111;s:30:\".material-design-add183:before\";i:2112;s:30:\".material-design-add184:before\";i:2113;s:30:\".material-design-add186:before\";i:2114;s:31:\".material-design-adjust6:before\";i:2115;s:35:\".material-design-airplane106:before\";i:2116;s:33:\".material-design-android11:before\";i:2117;s:33:\".material-design-android12:before\";i:2118;s:31:\".material-design-apple70:before\";i:2119;s:36:\".material-design-attachment19:before\";i:2120;s:29:\".material-design-auto1:before\";i:2121;s:34:\".material-design-automatic2:before\";i:2122;s:34:\".material-design-automatic3:before\";i:2123;s:30:\".material-design-back57:before\";i:2124;s:34:\".material-design-backspace1:before\";i:2125;s:29:\".material-design-bed24:before\";i:2126;s:28:\".material-design-been:before\";i:2127;s:34:\".material-design-birthday20:before\";i:2128;s:32:\".material-design-black394:before\";i:2129;s:32:\".material-design-black395:before\";i:2130;s:32:\".material-design-black396:before\";i:2131;s:32:\".material-design-black397:before\";i:2132;s:32:\".material-design-black398:before\";i:2133;s:32:\".material-design-black399:before\";i:2134;s:32:\".material-design-black400:before\";i:2135;s:32:\".material-design-black401:before\";i:2136;s:32:\".material-design-black402:before\";i:2137;s:31:\".material-design-blank30:before\";i:2138;s:31:\".material-design-blank31:before\";i:2139;s:31:\".material-design-blank32:before\";i:2140;s:31:\".material-design-blank33:before\";i:2141;s:33:\".material-design-blogger12:before\";i:2142;s:34:\".material-design-blueetooth:before\";i:2143;s:35:\".material-design-bluetooth21:before\";i:2144;s:35:\".material-design-bluetooth22:before\";i:2145;s:35:\".material-design-bluetooth23:before\";i:2146;s:35:\".material-design-bluetooth24:before\";i:2147;s:35:\".material-design-bluetooth25:before\";i:2148;s:34:\".material-design-bookmark45:before\";i:2149;s:34:\".material-design-bookmark46:before\";i:2150;s:34:\".material-design-bookmark47:before\";i:2151;s:34:\".material-design-bookmark48:before\";i:2152;s:35:\".material-design-briefcase49:before\";i:2153;s:35:\".material-design-briefcase50:before\";i:2154;s:36:\".material-design-brightness10:before\";i:2155;s:33:\".material-design-brochure6:before\";i:2156;s:31:\".material-design-bubble8:before\";i:2157;s:29:\".material-design-bug18:before\";i:2158;s:29:\".material-design-burn9:before\";i:2159;s:32:\".material-design-button11:before\";i:2160;s:30:\".material-design-call47:before\";i:2161;s:30:\".material-design-call48:before\";i:2162;s:30:\".material-design-call49:before\";i:2163;s:32:\".material-design-camera59:before\";i:2164;s:32:\".material-design-camera60:before\";i:2165;s:32:\".material-design-cancel19:before\";i:2166;s:29:\".material-design-caps1:before\";i:2167;s:28:\".material-design-caps:before\";i:2168;s:30:\".material-design-car145:before\";i:2169;s:30:\".material-design-car146:before\";i:2170;s:30:\".material-design-car147:before\";i:2171;s:30:\".material-design-cell10:before\";i:2172;s:30:\".material-design-cell11:before\";i:2173;s:30:\".material-design-cell12:before\";i:2174;s:31:\".material-design-change3:before\";i:2175;s:30:\".material-design-chat75:before\";i:2176;s:30:\".material-design-chat76:before\";i:2177;s:31:\".material-design-check51:before\";i:2178;s:31:\".material-design-check52:before\";i:2179;s:35:\".material-design-chemistry17:before\";i:2180;s:33:\".material-design-circle107:before\";i:2181;s:33:\".material-design-circle108:before\";i:2182;s:33:\".material-design-circles23:before\";i:2183;s:37:\".material-design-circumference:before\";i:2184;s:30:\".material-design-city24:before\";i:2185;s:37:\".material-design-clapperboard4:before\";i:2186;s:37:\".material-design-clapperboard5:before\";i:2187;s:30:\".material-design-clear5:before\";i:2188;s:35:\".material-design-clipboard99:before\";i:2189;s:32:\".material-design-clock100:before\";i:2190;s:31:\".material-design-close47:before\";i:2191;s:32:\".material-design-closed64:before\";i:2192;s:32:\".material-design-cloud302:before\";i:2193;s:32:\".material-design-cloud303:before\";i:2194;s:32:\".material-design-cloud304:before\";i:2195;s:32:\".material-design-cloud305:before\";i:2196;s:32:\".material-design-cloud306:before\";i:2197;s:32:\".material-design-cloud307:before\";i:2198;s:34:\".material-design-compass106:before\";i:2199;s:36:\".material-design-connection21:before\";i:2200;s:30:\".material-design-copy31:before\";i:2201;s:31:\".material-design-create2:before\";i:2202;s:31:\".material-design-create3:before\";i:2203;s:32:\".material-design-credit98:before\";i:2204;s:30:\".material-design-crop13:before\";i:2205;s:30:\".material-design-crop14:before\";i:2206;s:29:\".material-design-cut23:before\";i:2207;s:30:\".material-design-dark55:before\";i:2208;s:34:\".material-design-developer2:before\";i:2209;s:31:\".material-design-device4:before\";i:2210;s:31:\".material-design-device5:before\";i:2211;s:30:\".material-design-disc30:before\";i:2212;s:28:\".material-design-do10:before\";i:2213;s:33:\".material-design-double126:before\";i:2214;s:35:\".material-design-download162:before\";i:2215;s:35:\".material-design-download164:before\";i:2216;s:35:\".material-design-download166:before\";i:2217;s:33:\".material-design-downwards:before\";i:2218;s:30:\".material-design-drafts:before\";i:2219;s:30:\".material-design-drop25:before\";i:2220;s:30:\".material-design-drop26:before\";i:2221;s:30:\".material-design-drop27:before\";i:2222;s:32:\".material-design-earth205:before\";i:2223;s:33:\".material-design-ellipsis1:before\";i:2224;s:32:\".material-design-email107:before\";i:2225;s:35:\".material-design-emoticon117:before\";i:2226;s:28:\".material-design-end3:before\";i:2227;s:30:\".material-design-enter5:before\";i:2228;s:30:\".material-design-exit13:before\";i:2229;s:32:\".material-design-expand38:before\";i:2230;s:32:\".material-design-expand39:before\";i:2231;s:34:\".material-design-facebook56:before\";i:2232;s:30:\".material-design-fast46:before\";i:2233;s:34:\".material-design-favorite21:before\";i:2234;s:34:\".material-design-favorite22:before\";i:2235;s:32:\".material-design-filled13:before\";i:2236;s:30:\".material-design-film61:before\";i:2237;s:32:\".material-design-filter20:before\";i:2238;s:31:\".material-design-flash25:before\";i:2239;s:31:\".material-design-flash26:before\";i:2240;s:33:\".material-design-folder215:before\";i:2241;s:33:\".material-design-forward18:before\";i:2242;s:33:\".material-design-forward19:before\";i:2243;s:31:\".material-design-framed1:before\";i:2244;s:31:\".material-design-front15:before\";i:2245;s:31:\".material-design-front16:before\";i:2246;s:31:\".material-design-front17:before\";i:2247;s:30:\".material-design-full46:before\";i:2248;s:32:\".material-design-gamepad3:before\";i:2249;s:32:\".material-design-gamepad4:before\";i:2250;s:27:\".material-design-get:before\";i:2251;s:30:\".material-design-gmail3:before\";i:2252;s:28:\".material-design-go10:before\";i:2253;s:29:\".material-design-good4:before\";i:2254;s:29:\".material-design-good5:before\";i:2255;s:33:\".material-design-google117:before\";i:2256;s:33:\".material-design-google118:before\";i:2257;s:33:\".material-design-google119:before\";i:2258;s:33:\".material-design-google120:before\";i:2259;s:33:\".material-design-google121:before\";i:2260;s:33:\".material-design-google122:before\";i:2261;s:33:\".material-design-google123:before\";i:2262;s:33:\".material-design-google124:before\";i:2263;s:33:\".material-design-google125:before\";i:2264;s:33:\".material-design-google126:before\";i:2265;s:33:\".material-design-google127:before\";i:2266;s:33:\".material-design-google128:before\";i:2267;s:33:\".material-design-google129:before\";i:2268;s:33:\".material-design-google130:before\";i:2269;s:33:\".material-design-google131:before\";i:2270;s:33:\".material-design-google132:before\";i:2271;s:33:\".material-design-google133:before\";i:2272;s:33:\".material-design-google134:before\";i:2273;s:33:\".material-design-google135:before\";i:2274;s:33:\".material-design-google136:before\";i:2275;s:33:\".material-design-google137:before\";i:2276;s:29:\".material-design-gps25:before\";i:2277;s:29:\".material-design-gps26:before\";i:2278;s:29:\".material-design-gps27:before\";i:2279;s:29:\".material-design-gps28:before\";i:2280;s:34:\".material-design-graduate32:before\";i:2281;s:35:\".material-design-halffilled1:before\";i:2282;s:32:\".material-design-hangouts:before\";i:2283;s:33:\".material-design-headset11:before\";i:2284;s:33:\".material-design-headset12:before\";i:2285;s:30:\".material-design-help18:before\";i:2286;s:30:\".material-design-help19:before\";i:2287;s:29:\".material-design-hide3:before\";i:2288;s:30:\".material-design-high20:before\";i:2289;s:30:\".material-design-high21:before\";i:2290;s:30:\".material-design-high22:before\";i:2291;s:32:\".material-design-history6:before\";i:2292;s:31:\".material-design-home149:before\";i:2293;s:36:\".material-design-horizontal39:before\";i:2294;s:31:\".material-design-hotel68:before\";i:2295;s:29:\".material-design-https:before\";i:2296;s:30:\".material-design-import:before\";i:2297;s:31:\".material-design-insert4:before\";i:2298;s:35:\".material-design-instagram16:before\";i:2299;s:31:\".material-design-invert1:before\";i:2300;s:34:\".material-design-keyboard53:before\";i:2301;s:34:\".material-design-keyboard54:before\";i:2302;s:31:\".material-design-label31:before\";i:2303;s:35:\".material-design-landscape10:before\";i:2304;s:33:\".material-design-laptop117:before\";i:2305;s:31:\".material-design-left216:before\";i:2306;s:31:\".material-design-left217:before\";i:2307;s:31:\".material-design-left218:before\";i:2308;s:31:\".material-design-light88:before\";i:2309;s:30:\".material-design-link60:before\";i:2310;s:34:\".material-design-linkedin24:before\";i:2311;s:30:\".material-design-list88:before\";i:2312;s:30:\".material-design-list89:before\";i:2313;s:34:\".material-design-location41:before\";i:2314;s:32:\".material-design-locked57:before\";i:2315;s:32:\".material-design-locked58:before\";i:2316;s:29:\".material-design-low34:before\";i:2317;s:31:\".material-design-magic20:before\";i:2318;s:30:\".material-design-man459:before\";i:2319;s:30:\".material-design-man460:before\";i:2320;s:30:\".material-design-map102:before\";i:2321;s:30:\".material-design-map103:before\";i:2322;s:29:\".material-design-mark1:before\";i:2323;s:29:\".material-design-mark2:before\";i:2324;s:31:\".material-design-medium5:before\";i:2325;s:31:\".material-design-medium6:before\";i:2326;s:31:\".material-design-medium7:before\";i:2327;s:31:\".material-design-memory1:before\";i:2328;s:30:\".material-design-menu55:before\";i:2329;s:29:\".material-design-merge:before\";i:2330;s:36:\".material-design-microphone84:before\";i:2331;s:36:\".material-design-microphone85:before\";i:2332;s:34:\".material-design-microsoft7:before\";i:2333;s:34:\".material-design-microsoft8:before\";i:2334;s:30:\".material-design-missed:before\";i:2335;s:34:\".material-design-mountain31:before\";i:2336;s:34:\".material-design-mountain32:before\";i:2337;s:35:\".material-design-mountains14:before\";i:2338;s:30:\".material-design-move26:before\";i:2339;s:30:\".material-design-new102:before\";i:2340;s:30:\".material-design-new103:before\";i:2341;s:28:\".material-design-nfc1:before\";i:2342;s:38:\".material-design-notifications1:before\";i:2343;s:38:\".material-design-notifications2:before\";i:2344;s:37:\".material-design-notifications:before\";i:2345;s:33:\".material-design-painter14:before\";i:2346;s:34:\".material-design-panoramic1:before\";i:2347;s:33:\".material-design-parking14:before\";i:2348;s:31:\".material-design-pause44:before\";i:2349;s:33:\".material-design-person325:before\";i:2350;s:32:\".material-design-phone370:before\";i:2351;s:32:\".material-design-phone371:before\";i:2352;s:32:\".material-design-phone372:before\";i:2353;s:32:\".material-design-phone373:before\";i:2354;s:32:\".material-design-phone374:before\";i:2355;s:32:\".material-design-phone375:before\";i:2356;s:32:\".material-design-photo210:before\";i:2357;s:32:\".material-design-photo211:before\";i:2358;s:32:\".material-design-photo212:before\";i:2359;s:37:\".material-design-photographic1:before\";i:2360;s:35:\".material-design-pinterest33:before\";i:2361;s:32:\".material-design-planet29:before\";i:2362;s:31:\".material-design-play105:before\";i:2363;s:31:\".material-design-play106:before\";i:2364;s:31:\".material-design-play107:before\";i:2365;s:31:\".material-design-play108:before\";i:2366;s:31:\".material-design-play109:before\";i:2367;s:30:\".material-design-plus80:before\";i:2368;s:28:\".material-design-poll:before\";i:2369;s:32:\".material-design-power106:before\";i:2370;s:34:\".material-design-previous14:before\";i:2371;s:33:\".material-design-printer88:before\";i:2372;s:32:\".material-design-problems:before\";i:2373;s:34:\".material-design-progress10:before\";i:2374;s:32:\".material-design-public10:before\";i:2375;s:32:\".material-design-public11:before\";i:2376;s:31:\".material-design-public9:before\";i:2377;s:32:\".material-design-puzzle37:before\";i:2378;s:31:\".material-design-radio51:before\";i:2379;s:31:\".material-design-random5:before\";i:2380;s:28:\".material-design-rate:before\";i:2381;s:29:\".material-design-read5:before\";i:2382;s:32:\".material-design-receipt9:before\";i:2383;s:31:\".material-design-record9:before\";i:2384;s:33:\".material-design-refresh55:before\";i:2385;s:33:\".material-design-refresh56:before\";i:2386;s:33:\".material-design-reminder6:before\";i:2387;s:31:\".material-design-replay4:before\";i:2388;s:31:\".material-design-reply18:before\";i:2389;s:30:\".material-design-report:before\";i:2390;s:32:\".material-design-rewind45:before\";i:2391;s:32:\".material-design-right237:before\";i:2392;s:32:\".material-design-right244:before\";i:2393;s:30:\".material-design-ring24:before\";i:2394;s:32:\".material-design-rotate11:before\";i:2395;s:32:\".material-design-rotate12:before\";i:2396;s:31:\".material-design-round50:before\";i:2397;s:31:\".material-design-round51:before\";i:2398;s:31:\".material-design-round52:before\";i:2399;s:31:\".material-design-round53:before\";i:2400;s:31:\".material-design-round54:before\";i:2401;s:31:\".material-design-round55:before\";i:2402;s:31:\".material-design-round56:before\";i:2403;s:31:\".material-design-round57:before\";i:2404;s:31:\".material-design-round58:before\";i:2405;s:33:\".material-design-rounded54:before\";i:2406;s:33:\".material-design-rounded55:before\";i:2407;s:33:\".material-design-rounded56:before\";i:2408;s:33:\".material-design-rounded57:before\";i:2409;s:33:\".material-design-rounded58:before\";i:2410;s:33:\".material-design-rounded59:before\";i:2411;s:33:\".material-design-rounded60:before\";i:2412;s:31:\".material-design-rubbish:before\";i:2413;s:30:\".material-design-save20:before\";i:2414;s:33:\".material-design-schedule2:before\";i:2415;s:32:\".material-design-screen44:before\";i:2416;s:32:\".material-design-screen45:before\";i:2417;s:32:\".material-design-screen46:before\";i:2418;s:32:\".material-design-screen47:before\";i:2419;s:32:\".material-design-screen48:before\";i:2420;s:32:\".material-design-screen49:before\";i:2421;s:27:\".material-design-sd7:before\";i:2422;s:27:\".material-design-sd8:before\";i:2423;s:33:\".material-design-search100:before\";i:2424;s:35:\".material-design-searching41:before\";i:2425;s:31:\".material-design-select3:before\";i:2426;s:31:\".material-design-select4:before\";i:2427;s:30:\".material-design-send12:before\";i:2428;s:30:\".material-design-send13:before\";i:2429;s:30:\".material-design-send14:before\";i:2430;s:32:\".material-design-server40:before\";i:2431;s:28:\".material-design-set5:before\";i:2432;s:28:\".material-design-set6:before\";i:2433;s:34:\".material-design-settings49:before\";i:2434;s:34:\".material-design-settings50:before\";i:2435;s:31:\".material-design-share39:before\";i:2436;s:31:\".material-design-shared1:before\";i:2437;s:32:\".material-design-shining2:before\";i:2438;s:32:\".material-design-shining3:before\";i:2439;s:35:\".material-design-shopping231:before\";i:2440;s:35:\".material-design-shopping232:before\";i:2441;s:29:\".material-design-show4:before\";i:2442;s:29:\".material-design-show5:before\";i:2443;s:29:\".material-design-show6:before\";i:2444;s:29:\".material-design-show7:before\";i:2445;s:29:\".material-design-show8:before\";i:2446;s:33:\".material-design-shuffle24:before\";i:2447;s:28:\".material-design-sim2:before\";i:2448;s:36:\".material-design-smartphone19:before\";i:2449;s:36:\".material-design-smartphone20:before\";i:2450;s:28:\".material-design-sms5:before\";i:2451;s:28:\".material-design-sms6:before\";i:2452;s:28:\".material-design-sms7:before\";i:2453;s:30:\".material-design-snake4:before\";i:2454;s:30:\".material-design-sort52:before\";i:2455;s:33:\".material-design-speech108:before\";i:2456;s:30:\".material-design-split4:before\";i:2457;s:33:\".material-design-square181:before\";i:2458;s:30:\".material-design-stop46:before\";i:2459;s:29:\".material-design-swap2:before\";i:2460;s:29:\".material-design-swap3:before\";i:2461;s:32:\".material-design-switch27:before\";i:2462;s:32:\".material-design-switch28:before\";i:2463;s:32:\".material-design-switch29:before\";i:2464;s:32:\".material-design-switch30:before\";i:2465;s:40:\".material-design-synchronization3:before\";i:2466;s:40:\".material-design-synchronization4:before\";i:2467;s:40:\".material-design-synchronization5:before\";i:2468;s:28:\".material-design-tab3:before\";i:2469;s:32:\".material-design-tablet95:before\";i:2470;s:28:\".material-design-tack:before\";i:2471;s:29:\".material-design-tag71:before\";i:2472;s:36:\".material-design-telephone105:before\";i:2473;s:35:\".material-design-thermostat1:before\";i:2474;s:32:\".material-design-three168:before\";i:2475;s:32:\".material-design-three170:before\";i:2476;s:31:\".material-design-thumb53:before\";i:2477;s:31:\".material-design-thumb54:before\";i:2478;s:29:\".material-design-tick7:before\";i:2479;s:33:\".material-design-timelapse:before\";i:2480;s:33:\".material-design-traffic21:before\";i:2481;s:32:\".material-design-tumblr22:before\";i:2482;s:30:\".material-design-turn17:before\";i:2483;s:30:\".material-design-turn18:before\";i:2484;s:30:\".material-design-turn19:before\";i:2485;s:30:\".material-design-turn20:before\";i:2486;s:30:\".material-design-turn21:before\";i:2487;s:30:\".material-design-turn22:before\";i:2488;s:30:\".material-design-turn23:before\";i:2489;s:33:\".material-design-twitter47:before\";i:2490;s:30:\".material-design-two375:before\";i:2491;s:30:\".material-design-two385:before\";i:2492;s:30:\".material-design-two393:before\";i:2493;s:34:\".material-design-underline6:before\";i:2494;s:34:\".material-design-underline7:before\";i:2495;s:30:\".material-design-undo19:before\";i:2496;s:34:\".material-design-unlocked43:before\";i:2497;s:29:\".material-design-up176:before\";i:2498;s:33:\".material-design-upload119:before\";i:2499;s:33:\".material-design-upload120:before\";i:2500;s:29:\".material-design-usb33:before\";i:2501;s:31:\".material-design-user157:before\";i:2502;s:31:\".material-design-user158:before\";i:2503;s:31:\".material-design-users25:before\";i:2504;s:38:\".material-design-verification24:before\";i:2505;s:33:\".material-design-videocall:before\";i:2506;s:30:\".material-design-view12:before\";i:2507;s:32:\".material-design-virtual2:before\";i:2508;s:35:\".material-design-visibility1:before\";i:2509;s:31:\".material-design-voice32:before\";i:2510;s:34:\".material-design-voicemail1:before\";i:2511;s:32:\".material-design-volume47:before\";i:2512;s:32:\".material-design-volume49:before\";i:2513;s:32:\".material-design-volume50:before\";i:2514;s:32:\".material-design-volume51:before\";i:2515;s:33:\".material-design-warning37:before\";i:2516;s:31:\".material-design-watch16:before\";i:2517;s:30:\".material-design-waving:before\";i:2518;s:29:\".material-design-web37:before\";i:2519;s:33:\".material-design-website12:before\";i:2520;s:30:\".material-design-wifi81:before\";i:2521;s:30:\".material-design-wifi82:before\";i:2522;s:30:\".material-design-wifi83:before\";i:2523;s:32:\".material-design-window57:before\";i:2524;s:29:\".material-design-work3:before\";i:2525;s:33:\".material-design-workspace:before\";i:2526;s:31:\".material-design-world96:before\";i:2527;s:31:\".material-design-write20:before\";i:2528;s:33:\".material-design-youtube35:before\";i:2529;s:31:\".tm_font_icon .fl-glypho:before\";i:2530;s:134:\".fl-glypho-ico, [class^=\"fl-glypho-\"]:before, [class*=\" fl-glypho-\"]:before, [class^=\"fl-glypho-\"]:after, [class*=\" fl-glypho-\"]:after\";i:2531;s:27:\".fl-glypho-armchair4:before\";i:2532;s:27:\".fl-glypho-behance13:before\";i:2533;s:24:\".fl-glypho-bell70:before\";i:2534;s:29:\".fl-glypho-briefcase69:before\";i:2535;s:27:\".fl-glypho-camera119:before\";i:2536;s:27:\".fl-glypho-camera120:before\";i:2537;s:25:\".fl-glypho-chart55:before\";i:2538;s:25:\".fl-glypho-chat118:before\";i:2539;s:27:\".fl-glypho-checkbox6:before\";i:2540;s:29:\".fl-glypho-chronometer:before\";i:2541;s:27:\".fl-glypho-clipboard:before\";i:2542;s:27:\".fl-glypho-coffee128:before\";i:2543;s:31:\".fl-glypho-compact disc5:before\";i:2544;s:36:\".fl-glypho-directional-sign10:before\";i:2545;s:27:\".fl-glypho-document6:before\";i:2546;s:29:\".fl-glypho-downloading:before\";i:2547;s:26:\".fl-glypho-dribbble:before\";i:2548;s:24:\".fl-glypho-eye127:before\";i:2549;s:27:\".fl-glypho-facebook2:before\";i:2550;s:24:\".fl-glypho-flag97:before\";i:2551;s:23:\".fl-glypho-flask:before\";i:2552;s:28:\".fl-glypho-folded-map:before\";i:2553;s:25:\".fl-glypho-globe35:before\";i:2554;s:29:\".fl-glypho-google-plus:before\";i:2555;s:27:\".fl-glypho-happy-mac:before\";i:2556;s:28:\".fl-glypho-heart-rate:before\";i:2557;s:26:\".fl-glypho-hearts34:before\";i:2558;s:26:\".fl-glypho-house180:before\";i:2559;s:25:\".fl-glypho-inbox39:before\";i:2560;s:25:\".fl-glypho-inbox40:before\";i:2561;s:29:\".fl-glypho-instagram19:before\";i:2562;s:23:\".fl-glypho-jar21:before\";i:2563;s:27:\".fl-glypho-laptop130:before\";i:2564;s:24:\".fl-glypho-layers:before\";i:2565;s:29:\".fl-glypho-light-bulb4:before\";i:2566;s:29:\".fl-glypho-lightning31:before\";i:2567;s:26:\".fl-glypho-linkedin:before\";i:2568;s:29:\".fl-glypho-microphone3:before\";i:2569;s:28:\".fl-glypho-notebook91:before\";i:2570;s:22:\".fl-glypho-nut4:before\";i:2571;s:23:\".fl-glypho-pin66:before\";i:2572;s:22:\".fl-glypho-plug:before\";i:2573;s:24:\".fl-glypho-power5:before\";i:2574;s:27:\".fl-glypho-present33:before\";i:2575;s:32:\".fl-glypho-presentation22:before\";i:2576;s:25:\".fl-glypho-purse10:before\";i:2577;s:22:\".fl-glypho-pyre:before\";i:2578;s:25:\".fl-glypho-quaver3:before\";i:2579;s:26:\".fl-glypho-rocket77:before\";i:2580;s:26:\".fl-glypho-screen84:before\";i:2581;s:25:\".fl-glypho-share46:before\";i:2582;s:32:\".fl-glypho-shopping-cart7:before\";i:2583;s:33:\".fl-glypho-speech-bubble20:before\";i:2584;s:25:\".fl-glypho-star207:before\";i:2585;s:26:\".fl-glypho-switch33:before\";i:2586;s:30:\".fl-glypho-telephone120:before\";i:2587;s:25:\".fl-glypho-timer42:before\";i:2588;s:25:\".fl-glypho-truck69:before\";i:2589;s:25:\".fl-glypho-tumblr1:before\";i:2590;s:25:\".fl-glypho-twitter:before\";i:2591;s:27:\".fl-glypho-umbrella1:before\";i:2592;s:28:\".fl-glypho-uploading2:before\";i:2593;s:23:\".fl-glypho-user7:before\";i:2594;s:30:\".fl-glypho-video-player:before\";i:2595;s:30:\".tm_font_icon .fontello:before\";i:2596;s:57:\"[class^=\"fontello-\"]:before, [class*=\" fontello-\"]:before\";i:2597;s:23:\".icon-fontello-0:before\";i:2598;s:23:\".icon-fontello-1:before\";i:2599;s:23:\".icon-fontello-2:before\";i:2600;s:33:\".mfp-img-mobile .mfp-image-holder\";i:2601;s:27:\".mfp-img-mobile img.mfp-img\";i:2602;s:33:\".mfp-img-mobile .mfp-figure:after\";i:2603;s:33:\".mfp-img-mobile .mfp-figure small\";i:2604;s:31:\".mfp-img-mobile .mfp-bottom-bar\";i:2605;s:37:\".mfp-img-mobile .mfp-bottom-bar:empty\";i:2606;s:28:\".mfp-img-mobile .mfp-counter\";i:2607;s:26:\".mfp-img-mobile .mfp-close\";i:2608;s:10:\".mfp-arrow\";i:2609;s:15:\".mfp-arrow-left\";i:2610;s:16:\".mfp-arrow-right\";i:2611;s:14:\".mfp-container\";i:2612;s:7:\".mfp-bg\";i:2613;s:9:\".mfp-wrap\";i:2614;s:21:\".mfp-container:before\";i:2615;s:36:\".mfp-align-top .mfp-container:before\";i:2616;s:12:\".mfp-content\";i:2617;s:62:\".mfp-ajax-holder .mfp-content, .mfp-inline-holder .mfp-content\";i:2618;s:13:\".mfp-ajax-cur\";i:2619;s:65:\".mfp-zoom-out-cur, .mfp-zoom-out-cur .mfp-image-holder .mfp-close\";i:2620;s:9:\".mfp-zoom\";i:2621;s:29:\".mfp-auto-cursor .mfp-content\";i:2622;s:52:\".mfp-arrow, .mfp-close, .mfp-counter, .mfp-preloader\";i:2623;s:23:\".mfp-loading.mfp-figure\";i:2624;s:9:\".mfp-hide\";i:2625;s:14:\".mfp-preloader\";i:2626;s:16:\".mfp-preloader a\";i:2627;s:22:\".mfp-preloader a:hover\";i:2628;s:54:\".mfp-s-error .mfp-content, .mfp-s-ready .mfp-preloader\";i:2629;s:34:\"button.mfp-arrow, button.mfp-close\";i:2630;s:24:\"button::-moz-focus-inner\";i:2631;s:10:\".mfp-close\";i:2632;s:34:\".mfp-close:focus, .mfp-close:hover\";i:2633;s:17:\".mfp-close:active\";i:2634;s:28:\".mfp-close-btn-in .mfp-close\";i:2635;s:59:\".mfp-iframe-holder .mfp-close, .mfp-image-holder .mfp-close\";i:2636;s:12:\".mfp-counter\";i:2637;s:17:\".mfp-arrow:active\";i:2638;s:34:\".mfp-arrow:focus, .mfp-arrow:hover\";i:2639;s:73:\".mfp-arrow .mfp-a, .mfp-arrow .mfp-b, .mfp-arrow:after, .mfp-arrow:before\";i:2640;s:35:\".mfp-arrow .mfp-a, .mfp-arrow:after\";i:2641;s:36:\".mfp-arrow .mfp-b, .mfp-arrow:before\";i:2642;s:45:\".mfp-arrow-left .mfp-a, .mfp-arrow-left:after\";i:2643;s:46:\".mfp-arrow-left .mfp-b, .mfp-arrow-left:before\";i:2644;s:47:\".mfp-arrow-right .mfp-a, .mfp-arrow-right:after\";i:2645;s:48:\".mfp-arrow-right .mfp-b, .mfp-arrow-right:before\";i:2646;s:18:\".mfp-iframe-holder\";i:2647;s:31:\".mfp-iframe-holder .mfp-content\";i:2648;s:29:\".mfp-iframe-holder .mfp-close\";i:2649;s:18:\".mfp-iframe-scaler\";i:2650;s:25:\".mfp-iframe-scaler iframe\";i:2651;s:11:\"img.mfp-img\";i:2652;s:11:\".mfp-figure\";i:2653;s:17:\".mfp-figure:after\";i:2654;s:17:\".mfp-figure small\";i:2655;s:18:\".mfp-figure figure\";i:2656;s:15:\".mfp-bottom-bar\";i:2657;s:10:\".mfp-title\";i:2658;s:30:\".mfp-image-holder .mfp-content\";i:2659;s:42:\".mfp-gallery .mfp-image-holder .mfp-figure\";i:2660;s:17:\".mfp-ie7 .mfp-img\";i:2661;s:24:\".mfp-ie7 .mfp-bottom-bar\";i:2662;s:23:\".mfp-ie7 .mfp-container\";i:2663;s:21:\".mfp-ie7 .mfp-content\";i:2664;s:19:\".mfp-ie7 .mfp-close\";i:2665;s:15:\".material-icons\";i:2666;s:17:\".swiper-container\";i:2667;s:42:\".swiper-container-no-flexbox .swiper-slide\";i:2668;s:42:\".swiper-container-vertical>.swiper-wrapper\";i:2669;s:15:\".swiper-wrapper\";i:2670;s:56:\".swiper-container-android .swiper-slide, .swiper-wrapper\";i:2671;s:42:\".swiper-container-multirow>.swiper-wrapper\";i:2672;s:43:\".swiper-container-free-mode>.swiper-wrapper\";i:2673;s:13:\".swiper-slide\";i:2674;s:72:\".swiper-container-autoheight, .swiper-container-autoheight .swiper-slide\";i:2675;s:44:\".swiper-container-autoheight .swiper-wrapper\";i:2676;s:38:\".swiper-container .swiper-notification\";i:2677;s:22:\".swiper-wp8-horizontal\";i:2678;s:20:\".swiper-wp8-vertical\";i:2679;s:40:\".swiper-button-next, .swiper-button-prev\";i:2680;s:86:\".swiper-button-next.swiper-button-disabled, .swiper-button-prev.swiper-button-disabled\";i:2681;s:62:\".swiper-button-prev, .swiper-container-rtl .swiper-button-next\";i:2682;s:102:\".swiper-button-prev.swiper-button-black, .swiper-container-rtl .swiper-button-next.swiper-button-black\";i:2683;s:102:\".swiper-button-prev.swiper-button-white, .swiper-container-rtl .swiper-button-next.swiper-button-white\";i:2684;s:62:\".swiper-button-next, .swiper-container-rtl .swiper-button-prev\";i:2685;s:102:\".swiper-button-next.swiper-button-black, .swiper-container-rtl .swiper-button-prev.swiper-button-black\";i:2686;s:102:\".swiper-button-next.swiper-button-white, .swiper-container-rtl .swiper-button-prev.swiper-button-white\";i:2687;s:18:\".swiper-pagination\";i:2688;s:43:\".swiper-pagination.swiper-pagination-hidden\";i:2689;s:111:\".swiper-container-horizontal>.swiper-pagination-bullets, .swiper-pagination-custom, .swiper-pagination-fraction\";i:2690;s:25:\".swiper-pagination-bullet\";i:2691;s:31:\"button.swiper-pagination-bullet\";i:2692;s:54:\".swiper-pagination-clickable .swiper-pagination-bullet\";i:2693;s:50:\".swiper-pagination-white .swiper-pagination-bullet\";i:2694;s:32:\".swiper-pagination-bullet-active\";i:2695;s:57:\".swiper-pagination-white .swiper-pagination-bullet-active\";i:2696;s:57:\".swiper-pagination-black .swiper-pagination-bullet-active\";i:2697;s:53:\".swiper-container-vertical>.swiper-pagination-bullets\";i:2698;s:79:\".swiper-container-vertical>.swiper-pagination-bullets .swiper-pagination-bullet\";i:2699;s:81:\".swiper-container-horizontal>.swiper-pagination-bullets .swiper-pagination-bullet\";i:2700;s:27:\".swiper-pagination-progress\";i:2701;s:58:\".swiper-pagination-progress .swiper-pagination-progressbar\";i:2702;s:80:\".swiper-container-rtl .swiper-pagination-progress .swiper-pagination-progressbar\";i:2703;s:56:\".swiper-container-horizontal>.swiper-pagination-progress\";i:2704;s:54:\".swiper-container-vertical>.swiper-pagination-progress\";i:2705;s:51:\".swiper-pagination-progress.swiper-pagination-white\";i:2706;s:82:\".swiper-pagination-progress.swiper-pagination-white .swiper-pagination-progressbar\";i:2707;s:82:\".swiper-pagination-progress.swiper-pagination-black .swiper-pagination-progressbar\";i:2708;s:20:\".swiper-container-3d\";i:2709;s:308:\".swiper-container-3d .swiper-cube-shadow, .swiper-container-3d .swiper-slide, .swiper-container-3d .swiper-slide-shadow-bottom, .swiper-container-3d .swiper-slide-shadow-left, .swiper-container-3d .swiper-slide-shadow-right, .swiper-container-3d .swiper-slide-shadow-top, .swiper-container-3d .swiper-wrapper\";i:2710;s:192:\".swiper-container-3d .swiper-slide-shadow-bottom, .swiper-container-3d .swiper-slide-shadow-left, .swiper-container-3d .swiper-slide-shadow-right, .swiper-container-3d .swiper-slide-shadow-top\";i:2711;s:46:\".swiper-container-3d .swiper-slide-shadow-left\";i:2712;s:47:\".swiper-container-3d .swiper-slide-shadow-right\";i:2713;s:45:\".swiper-container-3d .swiper-slide-shadow-top\";i:2714;s:48:\".swiper-container-3d .swiper-slide-shadow-bottom\";i:2715;s:83:\".swiper-container-coverflow .swiper-wrapper, .swiper-container-flip .swiper-wrapper\";i:2716;s:46:\".swiper-container-cube, .swiper-container-flip\";i:2717;s:74:\".swiper-container-cube .swiper-slide, .swiper-container-flip .swiper-slide\";i:2718;s:102:\".swiper-container-cube .swiper-slide .swiper-slide, .swiper-container-flip .swiper-slide .swiper-slide\";i:2719;s:220:\".swiper-container-cube .swiper-slide-active, .swiper-container-cube .swiper-slide-active .swiper-slide-active, .swiper-container-flip .swiper-slide-active, .swiper-container-flip .swiper-slide-active .swiper-slide-active\";i:2720;s:402:\".swiper-container-cube .swiper-slide-shadow-bottom, .swiper-container-cube .swiper-slide-shadow-left, .swiper-container-cube .swiper-slide-shadow-right, .swiper-container-cube .swiper-slide-shadow-top, .swiper-container-flip .swiper-slide-shadow-bottom, .swiper-container-flip .swiper-slide-shadow-left, .swiper-container-flip .swiper-slide-shadow-right, .swiper-container-flip .swiper-slide-shadow-top\";i:2721;s:36:\".swiper-container-cube .swiper-slide\";i:2722;s:57:\".swiper-container-cube.swiper-container-rtl .swiper-slide\";i:2723;s:186:\".swiper-container-cube .swiper-slide-active, .swiper-container-cube .swiper-slide-next, .swiper-container-cube .swiper-slide-next+.swiper-slide, .swiper-container-cube .swiper-slide-prev\";i:2724;s:42:\".swiper-container-cube .swiper-cube-shadow\";i:2725;s:63:\".swiper-container-fade.swiper-container-free-mode .swiper-slide\";i:2726;s:36:\".swiper-container-fade .swiper-slide\";i:2727;s:50:\".swiper-container-fade .swiper-slide .swiper-slide\";i:2728;s:109:\".swiper-container-fade .swiper-slide-active, .swiper-container-fade .swiper-slide-active .swiper-slide-active\";i:2729;s:17:\".swiper-scrollbar\";i:2730;s:46:\".swiper-container-horizontal>.swiper-scrollbar\";i:2731;s:44:\".swiper-container-vertical>.swiper-scrollbar\";i:2732;s:22:\".swiper-scrollbar-drag\";i:2733;s:29:\".swiper-scrollbar-cursor-drag\";i:2734;s:22:\".swiper-lazy-preloader\";i:2735;s:28:\".swiper-lazy-preloader:after\";i:2736;s:34:\".swiper-lazy-preloader-white:after\";}", "no");
INSERT INTO `wp_options` VALUES("137", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("149", "widget_widget-custom-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("150", "widget_healthrehub_widget_instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("151", "widget_healthrehub_widget_subscribe_follow", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("152", "widget_healthrehub_contact_information_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("512", "theme_mods_healthrehub-child02", "a:202:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:3:\"top\";i:61;s:4:\"main\";i:53;s:6:\"footer\";i:52;s:6:\"social\";i:54;}s:12:\"show_tagline\";b:0;s:16:\"totop_visibility\";b:1;s:14:\"page_preloader\";b:1;s:16:\"header_logo_type\";s:5:\"image\";s:15:\"header_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:22:\"retina_header_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:23:\"header_logo_font_family\";s:19:\"Poppins, sans-serif\";s:22:\"header_logo_font_style\";s:6:\"normal\";s:23:\"header_logo_font_weight\";s:3:\"700\";s:21:\"header_logo_font_size\";s:2:\"50\";s:25:\"header_logo_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_visibillity\";b:1;s:29:\"breadcrumbs_front_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:0;s:21:\"breadcrumbs_path_type\";s:4:\"full\";s:19:\"header_social_links\";b:1;s:19:\"footer_social_links\";b:1;s:23:\"blog_post_share_buttons\";b:0;s:25:\"single_post_share_buttons\";b:1;s:21:\"header_container_type\";s:9:\"fullwidth\";s:22:\"content_container_type\";s:5:\"boxed\";s:21:\"footer_container_type\";s:9:\"fullwidth\";s:15:\"container_width\";i:1788;s:13:\"sidebar_width\";s:3:\"1/3\";s:22:\"regular_accent_color_1\";s:7:\"#4c5461\";s:22:\"regular_accent_color_2\";s:7:\"#4c5461\";s:22:\"regular_accent_color_3\";s:7:\"#9fbedd\";s:22:\"regular_accent_color_4\";s:7:\"#9fbedd\";s:22:\"regular_accent_color_5\";s:7:\"#4c5461\";s:22:\"regular_accent_color_6\";s:7:\"#232c3a\";s:19:\"regular_input_color\";s:7:\"#f5f5f5\";s:18:\"regular_text_color\";s:7:\"#959595\";s:17:\"footer_text_color\";s:7:\"#ffffff\";s:18:\"regular_link_color\";s:7:\"#4c5461\";s:24:\"regular_link_hover_color\";s:7:\"#9fbedd\";s:16:\"regular_h1_color\";s:7:\"#4c5461\";s:16:\"regular_h2_color\";s:7:\"#4c5461\";s:16:\"regular_h3_color\";s:7:\"#4c5461\";s:16:\"regular_h4_color\";s:7:\"#4c5461\";s:16:\"regular_h5_color\";s:7:\"#9fbedd\";s:16:\"regular_h6_color\";s:7:\"#4c5461\";s:21:\"invert_accent_color_1\";s:4:\"#fff\";s:21:\"invert_accent_color_2\";s:7:\"#fdfdfd\";s:21:\"invert_accent_color_3\";s:7:\"#fefefe\";s:17:\"invert_text_color\";s:4:\"#fff\";s:17:\"invert_link_color\";s:4:\"#fff\";s:23:\"invert_link_hover_color\";s:7:\"#4c5461\";s:15:\"invert_h1_color\";s:4:\"#fff\";s:15:\"invert_h2_color\";s:4:\"#fff\";s:15:\"invert_h3_color\";s:4:\"#fff\";s:15:\"invert_h4_color\";s:4:\"#fff\";s:15:\"invert_h5_color\";s:4:\"#fff\";s:15:\"invert_h6_color\";s:4:\"#fff\";s:16:\"gradient_color_1\";s:7:\"#4c5461\";s:16:\"gradient_color_2\";s:7:\"#9fbedd\";s:16:\"body_font_family\";s:19:\"Poppins, sans-serif\";s:15:\"body_font_style\";s:6:\"normal\";s:16:\"body_font_weight\";s:3:\"400\";s:14:\"body_font_size\";s:2:\"18\";s:16:\"body_line_height\";s:5:\"1.667\";s:19:\"body_letter_spacing\";s:1:\"0\";s:18:\"body_character_set\";s:5:\"latin\";s:15:\"body_text_align\";s:4:\"left\";s:14:\"h1_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h1_font_style\";s:6:\"normal\";s:14:\"h1_font_weight\";s:3:\"100\";s:12:\"h1_font_size\";s:2:\"44\";s:14:\"h1_line_height\";s:3:\"1.1\";s:17:\"h1_letter_spacing\";s:1:\"0\";s:16:\"h1_character_set\";s:5:\"latin\";s:13:\"h1_text_align\";s:7:\"inherit\";s:14:\"h2_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h2_font_style\";s:6:\"normal\";s:14:\"h2_font_weight\";s:3:\"100\";s:12:\"h2_font_size\";s:2:\"30\";s:14:\"h2_line_height\";s:3:\"1.1\";s:17:\"h2_letter_spacing\";s:1:\"0\";s:16:\"h2_character_set\";s:5:\"latin\";s:13:\"h2_text_align\";s:7:\"inherit\";s:14:\"h3_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h3_font_style\";s:6:\"normal\";s:14:\"h3_font_weight\";s:3:\"500\";s:12:\"h3_font_size\";s:2:\"30\";s:14:\"h3_line_height\";s:3:\"1.2\";s:17:\"h3_letter_spacing\";s:1:\"0\";s:16:\"h3_character_set\";s:5:\"latin\";s:13:\"h3_text_align\";s:7:\"inherit\";s:14:\"h4_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h4_font_style\";s:6:\"normal\";s:14:\"h4_font_weight\";s:3:\"500\";s:12:\"h4_font_size\";s:2:\"26\";s:14:\"h4_line_height\";s:3:\"1.3\";s:17:\"h4_letter_spacing\";s:1:\"0\";s:16:\"h4_character_set\";s:5:\"latin\";s:13:\"h4_text_align\";s:7:\"inherit\";s:14:\"h5_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h5_font_style\";s:6:\"normal\";s:14:\"h5_font_weight\";s:3:\"500\";s:12:\"h5_font_size\";s:2:\"20\";s:14:\"h5_line_height\";s:3:\"1.4\";s:17:\"h5_letter_spacing\";s:1:\"0\";s:16:\"h5_character_set\";s:5:\"latin\";s:13:\"h5_text_align\";s:7:\"inherit\";s:14:\"h6_font_family\";s:19:\"Poppins, sans-serif\";s:13:\"h6_font_style\";s:6:\"normal\";s:14:\"h6_font_weight\";s:3:\"300\";s:12:\"h6_font_size\";s:2:\"18\";s:14:\"h6_line_height\";s:3:\"1.4\";s:17:\"h6_letter_spacing\";s:1:\"0\";s:16:\"h6_character_set\";s:5:\"latin\";s:13:\"h6_text_align\";s:7:\"inherit\";s:21:\"main_menu_font_family\";s:19:\"Poppins, sans-serif\";s:20:\"main_menu_font_style\";s:6:\"normal\";s:21:\"main_menu_font_weight\";s:3:\"500\";s:19:\"main_menu_font_size\";s:2:\"16\";s:21:\"main_menu_line_height\";s:3:\"1.4\";s:24:\"main_menu_letter_spacing\";s:1:\"0\";s:23:\"main_menu_character_set\";s:5:\"latin\";s:18:\"button_font_family\";s:19:\"Poppins, sans-serif\";s:18:\"button_font_weight\";s:3:\"500\";s:20:\"button_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_font_family\";s:19:\"Poppins, sans-serif\";s:22:\"breadcrumbs_font_style\";s:6:\"normal\";s:23:\"breadcrumbs_font_weight\";s:3:\"600\";s:21:\"breadcrumbs_font_size\";s:2:\"14\";s:23:\"breadcrumbs_line_height\";s:3:\"1.5\";s:26:\"breadcrumbs_letter_spacing\";s:1:\"0\";s:25:\"breadcrumbs_character_set\";s:5:\"latin\";s:21:\"top_header_right_text\";s:87:\"<a href=\\\"tel:9147095438\\\" class=\\\"btn btn-secondary booking\\\"> 914 709 5438 (lift)</a>\";s:18:\"header_layout_type\";s:7:\"minimal\";s:29:\"header_invert_textcolorscheme\";b:0;s:15:\"header_bg_color\";s:7:\"#ffffff\";s:15:\"header_bg_image\";N;s:16:\"header_bg_repeat\";s:6:\"repeat\";s:20:\"header_bg_position_x\";s:6:\"center\";s:20:\"header_bg_attachment\";s:6:\"scroll\";s:14:\"top_panel_text\";s:281:\"<div class=\\\"info-block\\\"><a class=\\\"top-panel-a\\\" href=\\\"mailto:westchesterstairlift@gmail.com\\\"> westchesterstairlift@gmail.com</a></div><div class=\\\"info-block\\\"><i class=\\\"material-icons\\\">call</i> <a class=\\\"top-panel-a\\\" href=\\\"tel:9147095438\\\">914 709 5438 (lift)</a> </div>\";s:16:\"top_panel_search\";b:0;s:12:\"top_panel_bg\";s:7:\"#4c5461\";s:18:\"header_menu_sticky\";b:1;s:22:\"header_menu_attributes\";b:1;s:22:\"title_attributes_color\";s:7:\"#8f9399\";s:16:\"more_button_type\";s:4:\"text\";s:16:\"more_button_text\";s:4:\"more\";s:16:\"more_button_icon\";N;s:21:\"more_button_image_url\";s:0:\"\";s:28:\"retina_more_button_image_url\";N;s:16:\"sidebar_position\";s:17:\"one-right-sidebar\";s:17:\"mailchimp_api_key\";N;s:17:\"mailchimp_list_id\";N;s:10:\"ads_header\";s:0:\"\";s:20:\"ads_home_before_loop\";s:0:\"\";s:23:\"ads_post_before_content\";s:0:\"\";s:24:\"ads_post_before_comments\";s:0:\"\";s:15:\"footer_logo_url\";s:71:\"http://westchesterstairlift.com/wp-content/uploads/2018/10/new-logo.png\";s:16:\"footer_copyright\";s:55:\"%%year%% © Westchester StairLift. All rights reserved.\";s:29:\"footer_widget_area_visibility\";b:0;s:21:\"footer_widget_columns\";s:1:\"4\";s:18:\"footer_layout_type\";s:8:\"centered\";s:17:\"footer_widgets_bg\";s:7:\"#4c5461\";s:9:\"footer_bg\";s:7:\"#4c5461\";s:16:\"blog_layout_type\";s:7:\"default\";s:16:\"blog_sticky_type\";s:4:\"icon\";s:16:\"blog_sticky_icon\";s:9:\"fa-star-o\";s:17:\"blog_sticky_label\";s:8:\"Featured\";s:18:\"blog_posts_content\";s:7:\"excerpt\";s:19:\"blog_featured_image\";s:9:\"fullwidth\";s:19:\"blog_read_more_text\";s:9:\"Read more\";s:16:\"blog_post_author\";b:1;s:22:\"blog_post_publish_date\";b:1;s:20:\"blog_post_categories\";b:1;s:14:\"blog_post_tags\";b:1;s:18:\"blog_post_comments\";b:1;s:18:\"single_post_author\";b:1;s:24:\"single_post_publish_date\";b:1;s:22:\"single_post_categories\";b:1;s:16:\"single_post_tags\";b:1;s:20:\"single_post_comments\";b:1;s:19:\"single_author_block\";b:1;s:21:\"related_posts_visible\";b:0;s:25:\"related_posts_block_title\";s:13:\"Related Posts\";s:19:\"related_posts_count\";s:1:\"4\";s:18:\"related_posts_grid\";s:1:\"4\";s:19:\"related_posts_title\";b:1;s:26:\"related_posts_title_length\";s:1:\"5\";s:19:\"related_posts_image\";b:1;s:21:\"related_posts_content\";s:12:\"post_excerpt\";s:28:\"related_posts_content_length\";s:2:\"10\";s:24:\"related_posts_categories\";b:1;s:18:\"related_posts_tags\";b:1;s:20:\"related_posts_author\";b:1;s:26:\"related_posts_publish_date\";b:1;s:27:\"related_posts_comment_count\";b:1;s:21:\"tm_pb_layouts_updated\";s:3:\"yes\";s:39:\"tm_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"tm_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"tm_pb_predefined_layouts_version_2\";s:2:\"on\";s:18:\"custom_css_post_id\";i:1958;s:21:\"tm_pb_replace_content\";s:2:\"on\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1540970907;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:29:\"after-content-full-width-area\";a:0:{}s:11:\"footer-area\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("155", "booked_plugin_version_number", "1.6.11", "yes");
INSERT INTO `wp_options` VALUES("192", "tm_builder_fonts", "a:809:{s:7:\"ABeeZee\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Abel\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Abhaya Libre\";a:3:{s:6:\"styles\";s:19:\"400,500,600,700,800\";s:13:\"character_set\";s:23:\"sinhala,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Abril Fatface\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Aclonica\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Acme\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Actor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Adamina\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Advent Pro\";a:3:{s:6:\"styles\";s:27:\"100,200,300,400,500,600,700\";s:13:\"character_set\";s:21:\"latin-ext,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Aguafina Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Akronim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Aladin\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Aldrich\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Alef\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:12:\"hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Alegreya\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Alegreya SC\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Alegreya Sans\";a:3:{s:6:\"styles\";s:94:\"100,100italic,300,300italic,400,italic,500,500italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Alegreya Sans SC\";a:3:{s:6:\"styles\";s:94:\"100,100italic,300,300italic,400,italic,500,500italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Alex Brush\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Alfa Slab One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Alice\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Alike\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Alike Angular\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Allan\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Allerta\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Allerta Stencil\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Allura\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Almendra\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Almendra Display\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Almendra SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Amarante\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Amaranth\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Amatic SC\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Amatica SC\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Amethysta\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Amiko\";a:3:{s:6:\"styles\";s:11:\"400,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Amiri\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Amita\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Anaheim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Andada\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Andika\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:48:\"cyrillic-ext,latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Angkor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:24:\"Annie Use Your Telescope\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Anonymous Pro\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:30:\"latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Antic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Antic Didone\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Antic Slab\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Anton\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Arapey\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Arbutus\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Arbutus Slab\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Architects Daughter\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Archivo Black\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Archivo Narrow\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Aref Ruqaa\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Arima Madurai\";a:3:{s:6:\"styles\";s:31:\"100,200,300,400,500,700,800,900\";s:13:\"character_set\";s:32:\"latin-ext,tamil,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Arimo\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:71:\"cyrillic-ext,latin-ext,hebrew,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Arizonia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Armata\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Artifika\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Arvo\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Arya\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Asap\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Asar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Asset\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Assistant\";a:3:{s:6:\"styles\";s:23:\"200,300,400,600,700,800\";s:13:\"character_set\";s:12:\"hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Astloch\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Asul\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Athiti\";a:3:{s:6:\"styles\";s:23:\"200,300,400,500,600,700\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Atma\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:23:\"latin-ext,bengali,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Atomic Age\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Aubrey\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Audiowide\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Autour One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Average\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Average Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Averia Gruesa Libre\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Averia Libre\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Averia Sans Libre\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Averia Serif Libre\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Bad Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:14:\"cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Baloo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:37:\"latin-ext,devanagari,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Baloo Bhai\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"gujarati,latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Baloo Bhaina\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:32:\"latin-ext,oriya,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Baloo Chettan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:36:\"latin-ext,malayalam,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Baloo Da\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:34:\"latin-ext,bengali,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Baloo Paaji\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"latin-ext,latin,vietnamese,gurmukhi\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Baloo Tamma\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:34:\"latin-ext,latin,vietnamese,kannada\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Baloo Thambi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:32:\"latin-ext,tamil,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Balthazar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Bangers\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Basic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Battambang\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Baumans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bayon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Belgrano\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Belleza\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"BenchNine\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Bentham\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Berkshire Swash\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bevan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Bigelow Rules\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Bigshot One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bilbo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Bilbo Swash Caps\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"BioRhyme\";a:3:{s:6:\"styles\";s:19:\"200,300,400,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"BioRhyme Expanded\";a:3:{s:6:\"styles\";s:19:\"200,300,400,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Biryani\";a:3:{s:6:\"styles\";s:27:\"200,300,400,600,700,800,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Bitter\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Black Ops One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bokor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Bonbon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Boogaloo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Bowlby One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Bowlby One SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Brawler\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Bree Serif\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Bubblegum Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Bubbler One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Buda\";a:3:{s:6:\"styles\";s:3:\"300\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Buenard\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Bungee\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Bungee Hairline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Bungee Inline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Bungee Outline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Bungee Shade\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Butcherman\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Butterfly Kids\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cabin\";a:3:{s:6:\"styles\";s:52:\"400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Cabin Condensed\";a:3:{s:6:\"styles\";s:15:\"400,500,600,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Cabin Sketch\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Caesar Dressing\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Cagliostro\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cairo\";a:3:{s:6:\"styles\";s:23:\"200,300,400,600,700,900\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Calligraffitti\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cambay\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cambo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Candal\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Cantarell\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Cantata One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Cantora One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Capriola\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cardo\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:31:\"latin-ext,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Carme\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Carrois Gothic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Carrois Gothic SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Carter One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Catamaran\";a:3:{s:6:\"styles\";s:35:\"100,200,300,400,500,600,700,800,900\";s:13:\"character_set\";s:21:\"latin-ext,tamil,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Caudex\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:31:\"latin-ext,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Caveat\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Caveat Brush\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Cedarville Cursive\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Ceviche One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Changa\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Changa One\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Chango\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Chathura\";a:3:{s:6:\"styles\";s:19:\"100,300,400,700,800\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Chau Philomene One\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Chela One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Chelsea Market\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Chenla\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cherry Cream Soda\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Cherry Swash\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Chewy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Chicle\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Chivo\";a:3:{s:6:\"styles\";s:24:\"400,italic,900,900italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Chonburi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cinzel\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cinzel Decorative\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Clicker Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Coda\";a:3:{s:6:\"styles\";s:7:\"400,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Coda Caption\";a:3:{s:6:\"styles\";s:3:\"800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Codystar\";a:3:{s:6:\"styles\";s:7:\"300,400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Coiny\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:32:\"latin-ext,tamil,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Combo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Comfortaa\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Coming Soon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Concert One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Condiment\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Content\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Contrail One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Convergence\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cookie\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Copse\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Corben\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Cormorant\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Cormorant Garamond\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Cormorant Infant\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Cormorant SC\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cormorant Unicase\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cormorant Upright\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Courgette\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Cousine\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:71:\"cyrillic-ext,latin-ext,hebrew,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Coustard\";a:3:{s:6:\"styles\";s:7:\"400,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:21:\"Covered By Your Grace\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Crafty Girls\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Creepster\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Crete Round\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Crimson Text\";a:3:{s:6:\"styles\";s:38:\"400,italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Croissant One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Crushed\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cuprum\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cutive\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Cutive Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Damion\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Dancing Script\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Dangrek\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"David Libre\";a:3:{s:6:\"styles\";s:11:\"400,500,700\";s:13:\"character_set\";s:33:\"latin-ext,hebrew,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Dawning of a New Day\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Days One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Dekko\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Delius\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Delius Swash Caps\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Delius Unicase\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Della Respira\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Denk One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Devonshire\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Dhurjati\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Didact Gothic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:53:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Diplomata\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Diplomata SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Domine\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Donegal One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Doppio One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Dorsa\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Dosis\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Dr Sugiyama\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Droid Sans\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Droid Sans Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Droid Serif\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Duru Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Dynalight\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"EB Garamond\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:48:\"cyrillic-ext,latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Eagle Lake\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Eater\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Economica\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Eczar\";a:3:{s:6:\"styles\";s:19:\"400,500,600,700,800\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Ek Mukta\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"El Messiri\";a:3:{s:6:\"styles\";s:15:\"400,500,600,700\";s:13:\"character_set\";s:21:\"arabic,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Electrolize\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Elsie\";a:3:{s:6:\"styles\";s:7:\"400,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Elsie Swash Caps\";a:3:{s:6:\"styles\";s:7:\"400,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Emblema One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Emilys Candy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Engagement\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Englebert\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Enriqueta\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Erica One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Esteban\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Euphoria Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Ewert\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:3:\"Exo\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Exo 2\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Expletus Sans\";a:3:{s:6:\"styles\";s:52:\"400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Fanwood Text\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Farsan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"gujarati,latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fascinate\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Fascinate Inline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Faster One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Fasthand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fauna One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Federant\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Federo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Felipa\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Fenix\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Finger Paint\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fira Mono\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fira Sans\";a:3:{s:6:\"styles\";s:52:\"300,300italic,400,italic,500,500italic,700,700italic\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Fjalla One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fjord One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Flamenco\";a:3:{s:6:\"styles\";s:7:\"300,400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Flavors\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Fondamento\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Fontdiner Swanky\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Forum\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Francois One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Frank Ruhl Libre\";a:3:{s:6:\"styles\";s:19:\"300,400,500,700,900\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Freckle Face\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Fredericka the Great\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Fredoka One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Freehand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Fresca\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Frijole\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Fruktur\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fugaz One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"GFS Didot\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"greek\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"GFS Neohellenic\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"greek\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Gabriela\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Gafata\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Galada\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:13:\"bengali,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Galdeano\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Galindo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Gentium Basic\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Gentium Book Basic\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:3:\"Geo\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Geostar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Geostar Fill\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Germania One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Gidugu\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Gilda Display\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Give You Glory\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Glass Antiqua\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Glegoo\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Gloria Hallelujah\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Goblin One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Gochi Hand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Gorditas\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:21:\"Goudy Bookletter 1911\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Graduate\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Grand Hotel\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Gravitas One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Great Vibes\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Griffy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Gruppo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Gudea\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Gurajada\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Habibi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Halant\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Hammersmith One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Hanalei\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Hanalei Fill\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Handlee\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Hanuman\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Happy Monkey\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Harmattan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Headland One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Heebo\";a:3:{s:6:\"styles\";s:27:\"100,300,400,500,700,800,900\";s:13:\"character_set\";s:12:\"hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Henny Penny\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Herr Von Muellerhoff\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Hind\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Hind Guntur\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:22:\"latin-ext,latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Hind Madurai\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:21:\"latin-ext,tamil,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Hind Siliguri\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:23:\"latin-ext,bengali,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Hind Vadodara\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Holtwood One SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Homemade Apple\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Homenaje\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"IM Fell DW Pica\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"IM Fell DW Pica SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"IM Fell Double Pica\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:22:\"IM Fell Double Pica SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"IM Fell English\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"IM Fell English SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"IM Fell French Canon\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:23:\"IM Fell French Canon SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"IM Fell Great Primer\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:23:\"IM Fell Great Primer SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Iceberg\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Iceland\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Imprima\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Inconsolata\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Inder\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Indie Flower\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Inika\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Inknut Antiqua\";a:3:{s:6:\"styles\";s:27:\"300,400,500,600,700,800,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Irish Grover\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Istok Web\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Italiana\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Italianno\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Itim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Jacques Francois\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:23:\"Jacques Francois Shadow\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Jaldi\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Jim Nightshade\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Jockey One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Jolly Lodger\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Jomhuria\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Josefin Sans\";a:3:{s:6:\"styles\";s:66:\"100,100italic,300,300italic,400,italic,600,600italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Josefin Slab\";a:3:{s:6:\"styles\";s:66:\"100,100italic,300,300italic,400,italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Joti One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Judson\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Julee\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Julius Sans One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Junge\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Jura\";a:3:{s:6:\"styles\";s:15:\"300,400,500,600\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Just Another Hand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:23:\"Just Me Again Down Here\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Kadwa\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:16:\"devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Kalam\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Kameron\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Kanit\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Kantumruy\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Karla\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Karma\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Katibeh\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Kaushan Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Kavivanar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:21:\"latin-ext,tamil,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Kavoon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Kdam Thmor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Keania One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Kelly Slab\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Kenia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Khand\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Khmer\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Khula\";a:3:{s:6:\"styles\";s:19:\"300,400,600,700,800\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Kite One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Knewave\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Kotta One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Koulen\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Kranky\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Kreon\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Kristi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Krona One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Kumar One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Kumar One Outline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Kurale\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"latin-ext,devanagari,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"La Belle Aurore\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Laila\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Lakki Reddy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Lalezar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:33:\"latin-ext,arabic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Lancelot\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Lateef\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Lato\";a:3:{s:6:\"styles\";s:66:\"100,100italic,300,300italic,400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"League Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Leckerli One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Ledger\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Lekton\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Lemon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Lemonada\";a:3:{s:6:\"styles\";s:15:\"300,400,600,700\";s:13:\"character_set\";s:33:\"latin-ext,arabic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Libre Baskerville\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Libre Franklin\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Life Savers\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Lilita One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Lily Script One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Limelight\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Linden Hill\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Lobster\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Lobster Two\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Londrina Outline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Londrina Shadow\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Londrina Sketch\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Londrina Solid\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Lora\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:21:\"Love Ya Like A Sister\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Loved by the King\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Lovers Quarrel\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Luckiest Guy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Lusitana\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Lustria\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Macondo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Macondo Swash Caps\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Mada\";a:3:{s:6:\"styles\";s:15:\"300,400,500,900\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Magra\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Maiden Orange\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Maitree\";a:3:{s:6:\"styles\";s:23:\"200,300,400,500,600,700\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Mako\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Mallanna\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Mandali\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Marcellus\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Marcellus SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Marck Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Margarine\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Marko One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Marmelad\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Martel\";a:3:{s:6:\"styles\";s:27:\"200,300,400,600,700,800,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Martel Sans\";a:3:{s:6:\"styles\";s:27:\"200,300,400,600,700,800,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Marvel\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Mate\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Mate SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Maven Pro\";a:3:{s:6:\"styles\";s:15:\"400,500,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"McLaren\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Meddon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"MedievalSharp\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Medula One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Meera Inimai\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:11:\"tamil,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Megrim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Meie Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Merienda\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Merienda One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Merriweather\";a:3:{s:6:\"styles\";s:52:\"300,300italic,400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Merriweather Sans\";a:3:{s:6:\"styles\";s:52:\"300,300italic,400,italic,700,700italic,800,800italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Metal\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Metal Mania\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Metamorphous\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Metrophobic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Michroma\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Milonga\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Miltonian\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Miltonian Tattoo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Miniver\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Miriam Libre\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Mirza\";a:3:{s:6:\"styles\";s:15:\"400,500,600,700\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Miss Fajardose\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Mitr\";a:3:{s:6:\"styles\";s:23:\"200,300,400,500,600,700\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Modak\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Modern Antiqua\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Mogra\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Molengo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Molle\";a:3:{s:6:\"styles\";s:6:\"italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Monda\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Monofett\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Monoton\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Monsieur La Doulaise\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Montaga\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Montez\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Montserrat\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:21:\"Montserrat Alternates\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Montserrat Subrayada\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Moul\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Moulpali\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:22:\"Mountains of Christmas\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Mouse Memoirs\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Mr Bedfort\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Mr Dafoe\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Mr De Haviland\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Mrs Saint Delafield\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Mrs Sheppards\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Mukta Vaani\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Muli\";a:3:{s:6:\"styles\";s:24:\"300,300italic,400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Mystery Quest\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:3:\"NTR\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Neucha\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:14:\"cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Neuton\";a:3:{s:6:\"styles\";s:26:\"200,300,400,italic,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"New Rocker\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"News Cycle\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Niconne\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Nixie One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Nobile\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Nokora\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Norican\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Nosifer\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Nothing You Could Do\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Noticia Text\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Noto Sans\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:75:\"cyrillic-ext,latin-ext,devanagari,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Noto Serif\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Nova Cut\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Nova Flat\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Nova Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:11:\"greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Nova Oval\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Nova Round\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Nova Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Nova Slim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Nova Square\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Numans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Nunito\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Odor Mean Chey\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Offside\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Old Standard TT\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Oldenburg\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Oleo Script\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:22:\"Oleo Script Swash Caps\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Open Sans\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,600,600italic,700,700italic,800,800italic\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Open Sans Condensed\";a:3:{s:6:\"styles\";s:17:\"300,300italic,700\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Oranienbaum\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Orbitron\";a:3:{s:6:\"styles\";s:15:\"400,500,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Oregano\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Orienta\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Original Surfer\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Oswald\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Over the Rainbow\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Overlock\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Overlock SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:3:\"Ovo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Oxygen\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Oxygen Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"PT Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"PT Sans\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"PT Sans Caption\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"PT Sans Narrow\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"PT Serif\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"PT Serif Caption\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Pacifico\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Palanquin\";a:3:{s:6:\"styles\";s:27:\"100,200,300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Palanquin Dark\";a:3:{s:6:\"styles\";s:15:\"400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Paprika\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Parisienne\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Passero One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Passion One\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Pathway Gothic One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Patrick Hand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Patrick Hand SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Pattaya\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:40:\"latin-ext,thai,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Patua One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Pavanam\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:21:\"latin-ext,tamil,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Paytone One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Peddana\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Peralta\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Permanent Marker\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Petit Formal Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Petrona\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Philosopher\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:14:\"cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Piedra\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Pinyon Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Pirata One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Plaster\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Play\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Playball\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Playfair Display\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Playfair Display SC\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Podkova\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Poiret One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Poller One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Poly\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Pompiere\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Pontano Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Poppins\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Port Lligat Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Port Lligat Slab\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Pragati Narrow\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Prata\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Preahvihear\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Press Start 2P\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:30:\"latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Pridi\";a:3:{s:6:\"styles\";s:23:\"200,300,400,500,600,700\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Princess Sofia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Prociono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Prompt\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Prosto One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Proza Libre\";a:3:{s:6:\"styles\";s:66:\"400,italic,500,500italic,600,600italic,700,700italic,800,800italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Puritan\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Purple Purse\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Quando\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Quantico\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Quattrocento\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Quattrocento Sans\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Questrial\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Quicksand\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Quintessential\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Qwigley\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Racing Sans One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Radley\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Rajdhani\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Rakkas\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Raleway\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Raleway Dots\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Ramabhadra\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Ramaraja\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Rambla\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Rammetto One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Ranchers\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Rancho\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Ranga\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Rasa\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Rationale\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Ravi Prakash\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Redressed\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Reem Kufi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Reenie Beanie\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Revalia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Rhodium Libre\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Ribeye\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Ribeye Marrow\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Righteous\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Risque\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Roboto\";a:3:{s:6:\"styles\";s:80:\"100,100italic,300,300italic,400,italic,500,500italic,700,700italic,900,900italic\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Roboto Condensed\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Roboto Mono\";a:3:{s:6:\"styles\";s:66:\"100,100italic,300,300italic,400,italic,500,500italic,700,700italic\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Roboto Slab\";a:3:{s:6:\"styles\";s:15:\"100,300,400,700\";s:13:\"character_set\";s:64:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Rochester\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Rock Salt\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Rokkitt\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Romanesco\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Ropa Sans\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Rosario\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Rosarivo\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Rouge Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Rozha One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Rubik\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,700,700italic,900,900italic\";s:13:\"character_set\";s:31:\"latin-ext,hebrew,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Rubik Mono One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Rubik One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Ruda\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Rufina\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Ruge Boogie\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Ruluko\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Rum Raisin\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Ruslan Display\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Russo One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Ruthie\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:3:\"Rye\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Sacramento\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Sahitya\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:16:\"devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Sail\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Salsa\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Sanchez\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Sancreek\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Sansita One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Sarala\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Sarina\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Sarpanch\";a:3:{s:6:\"styles\";s:23:\"400,500,600,700,800,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Satisfy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Scada\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Scheherazade\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Schoolbell\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Scope One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Seaweed Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Secular One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Sevillana\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Seymour One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Shadows Into Light\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:22:\"Shadows Into Light Two\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Shanti\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Share\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Share Tech\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Share Tech Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Shojumaru\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Short Stack\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Shrikhand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"gujarati,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Siemreap\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Sigmar One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Signika\";a:3:{s:6:\"styles\";s:15:\"300,400,600,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Signika Negative\";a:3:{s:6:\"styles\";s:15:\"300,400,600,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Simonetta\";a:3:{s:6:\"styles\";s:24:\"400,italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Sintony\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Sirin Stencil\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Six Caps\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Skranji\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Slabo 13px\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Slabo 27px\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Slackey\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Smokum\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Smythe\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Sniglet\";a:3:{s:6:\"styles\";s:7:\"400,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Snippet\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Snowburst One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Sofadi One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Sofia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Sonsie One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Sorts Mill Goudy\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Source Code Pro\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Source Sans Pro\";a:3:{s:6:\"styles\";s:80:\"200,200italic,300,300italic,400,italic,600,600italic,700,700italic,900,900italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Source Serif Pro\";a:3:{s:6:\"styles\";s:11:\"400,600,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Space Mono\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Special Elite\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Spicy Rice\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Spinnaker\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Spirax\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Squada One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Sree Krushnadevaraya\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Sriracha\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Stalemate\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Stalinist One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Stardos Stencil\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:21:\"Stint Ultra Condensed\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Stint Ultra Expanded\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Stoke\";a:3:{s:6:\"styles\";s:7:\"300,400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Strait\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Sue Ellen Francisco\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Suez One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Sumana\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Sunshiney\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Supermercado One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Sura\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Suranna\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Suravaram\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Suwannaphum\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Swanky and Moo Moo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Syncopate\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Tangerine\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Taprom\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Tauri\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Taviraj\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Teko\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Telex\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Tenali Ramakrishna\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Tenor Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Text Me One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"The Girl Next Door\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Tienne\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Tillana\";a:3:{s:6:\"styles\";s:19:\"400,500,600,700,800\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Timmana\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Tinos\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:71:\"cyrillic-ext,latin-ext,hebrew,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Titan One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Titillium Web\";a:3:{s:6:\"styles\";s:70:\"200,200italic,300,300italic,400,italic,600,600italic,700,700italic,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Trade Winds\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Trirong\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Trocchi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Trochut\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Trykker\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Tulpen One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Ubuntu\";a:3:{s:6:\"styles\";s:52:\"300,300italic,400,italic,500,500italic,700,700italic\";s:13:\"character_set\";s:53:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Ubuntu Condensed\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:53:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Ubuntu Mono\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:53:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Ultra\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Uncial Antiqua\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Underdog\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Unica One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"UnifrakturCook\";a:3:{s:6:\"styles\";s:3:\"700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"UnifrakturMaguntia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Unkempt\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Unlock\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Unna\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"VT323\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Vampiro One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Varela\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Varela Round\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Vast Shadow\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Vesper Libre\";a:3:{s:6:\"styles\";s:15:\"400,500,700,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Vibur\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Vidaloka\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Viga\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Voces\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Volkhov\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Vollkorn\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Voltaire\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:23:\"Waiting for the Sunrise\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Wallpoet\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Walter Turncoat\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Warnes\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Wellfleet\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Wendy One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Wire One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Work Sans\";a:3:{s:6:\"styles\";s:35:\"100,200,300,400,500,600,700,800,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Yanone Kaffeesatz\";a:3:{s:6:\"styles\";s:15:\"200,300,400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Yantramanav\";a:3:{s:6:\"styles\";s:23:\"100,300,400,500,700,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Yatra One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Yellowtail\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Yeseva One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Yesteryear\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Yrsa\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Zeyada\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}}", "no");
INSERT INTO `wp_options` VALUES("156", "cherry-services", "a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}", "no");
INSERT INTO `wp_options` VALUES("157", "cherry-services_default", "a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}", "no");
INSERT INTO `wp_options` VALUES("158", "cherry-team", "a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}", "yes");
INSERT INTO `wp_options` VALUES("159", "cherry-team_default", "a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}", "yes");
INSERT INTO `wp_options` VALUES("160", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.0.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1540361649;s:7:\"version\";s:5:\"5.0.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("161", "mp_timetable_permalinks", "a:4:{s:11:\"column_base\";s:16:\"timetable/column\";s:10:\"event_base\";s:15:\"timetable/event\";s:19:\"event_category_base\";s:18:\"timetable/category\";s:14:\"event_tag_base\";s:13:\"timetable/tag\";}", "yes");
INSERT INTO `wp_options` VALUES("162", "tm_pg_first_activated", "0", "yes");
INSERT INTO `wp_options` VALUES("163", "widget_booked_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("164", "widget_mp-timetable", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("486", "chld_thm_cfg_options_dict_seq", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("487", "chld_thm_cfg_options_dict_token", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("488", "chld_thm_cfg_options_val_ndx", "a:3040:{i:1;s:56:\"ZE=hT?GUZA$A<CSOYMtOBtUE_Q3nE3cAgAnBJHNzWHuWvDqI:$vbOAQA\";i:2;s:56:\"fS=hT?GU/A$A[CSOYMifBtXL_Q3nE30Ai\"pBJHNz!PuWDHqI:$vbeAQA\";i:3;s:111:\"qg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzLYuWyKqI:$vbiAQA+\",ub@CG5FAwLvSQ[zJAyWjt,ub@nH5FgwLvSQ[zKAFtjt,ub@MI5FA\";i:4;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GU^ClBkM.4Fx}MEA};=hT?GU^ClBsM.4Fxs@CA2[=hT?GUDClB0M.4Fxs@CAU|=hT?GUIDlB8M.4FxrjEA;C>hT?GUIDlB)M.4Fx~5EApI>hT?GUoDlB<M.4Fx~5EABA\";i:5;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:6;s:46:\"eS=hT?GU}DlBzL.4Fxs@FAvW=hT?GU}DlB7L.4Fxs@FABA\";i:7;s:13:\"9M=hT?GU4DlBA\";i:8;s:46:\"eS=hT?GUdElBzL.4Fx~5AAvW=hT?GUtElB7L.4Fx~5AABA\";i:9;s:13:\"sP>hT?GU!xlBA\";i:10;s:56:\"IH=hT?GUpA$A=CSOYMM%Ct5F_Q3nE3UAi\"nBJHNz0=uWCaqI:$vbuMgA\";i:11;s:46:\"eS=hT?GUTylBzL.4Fx~5$AvW=hT?GUjylB7L.4Fx~5$ABA\";i:12;s:13:\"sP>hT?GU!xlBA\";i:13;s:56:\"IH=hT?GUpA$A=CSOYMM%Ct5F_Q3nE3UAi\"nBJHNz0=uWCaqI:$vbuMgA\";i:14;s:13:\"bS>hT?GUyFlBA\";i:15;s:13:\"bS>hT?GU&FlBA\";i:16;s:13:\"_X=hT?GU]FlBA\";i:17;s:46:\"HH=hT?GU.DlBjL.4Fx~5AAYL=hT?GUHGlBrL.4Fx~5AABA\";i:18;s:17:\"sP>hT?IU~AlBUoEAB\";i:19;s:13:\"EH=hT?GU~AlBA\";i:20;s:57:\"fS=hT?GU~AlBzL.4Fx}MFAvW=hT?GU~AlB7L.4Fx}MFANc=hT?GUnGlBA\";i:21;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:22;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:23;s:45:\"HH=hT?GUpA$A=CSOYMLUBt5F_Q3nE3bD$A?CSOYMLUBtA\";i:24;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3jD$A?CSOYMtOBtA\";i:25;s:46:\"eS=hT?GU|GlBzL.4Fxs@BAvW=hT?GU|GlB7L.4Fx~5JABA\";i:26;s:29:\"LV>hT?GUMHlB@M.4?zrjBAq1LDlBA\";i:27;s:46:\"eS=hT?GUHGlBzL.4FxrjKAvW=hT?GUHGlB7L.4FxrjKABA\";i:28;s:46:\"eS=hT?GUsHlBzL.4Fxs@KAvW=hT?GU|GlB7L.4Fxs@KABA\";i:29;s:13:\"_X>hT?GU<HlBA\";i:30;s:13:\"!5=hT?GUBIlBA\";i:31;s:46:\"eS=hT?GU~AlBzL.4FxrjBAvW=hT?GU~AlB7L.4FxrjBABA\";i:32;s:46:\"eS=hT?GU~AlBzL.4Fx~5LAvW=hT?GU~AlB7L.4Fx~5LABA\";i:33;s:46:\"eS=hT?GUOBlBzL.4Fx~5BAvW=hT?GUOBlB7L.4Fx~5BABA\";i:34;s:111:\"qg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA7y=hT?GU5A$AADSOYMLUBt&a_Q3nE3cAgAqBJHNzFKuWA\";i:35;s:13:\"yd=hT?GUxIlBA\";i:36;s:223:\"oCQY,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GU^ClBkM.4Fx}MEA};=hT?GU^ClBsM.4Fxs@CA2[=hT?GUDClB0M.4Fxs@CAU|=hT?GUDClB8M.4Fxs@CA;C>hT?GUDClB)M.4Fxs@CApI>hT?GUDClB<M.4Fxs@CAZ4=hT?GUDClB_M.4FxrjMAeZ>hT?GU[IlBA\";i:37;s:13:\"t8=hT?GUGJlBA\";i:38;s:28:\"tP>hT?IU~AlBUoEAI7_Q3nE34E$A\";i:39;s:13:\"hg>hT?GU4DlBA\";i:40;s:28:\"tP>hT?IU3GlB&!GAI7_Q3nE3.E$A\";i:41;s:35:\"Sj>hT?GU2JlB_M.4Fx~5NA1k>hT?GU+JlBA\";i:42;s:24:\"tP=hT?GUOBlBQM.4Fx}MOABA\";i:43;s:45:\"HH=hT?GU~AlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:44;s:13:\"sP>hT?GULKlBA\";i:45;s:56:\"wP>hT?GUbKlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMtOBt8M_Q3nE3UAgA\";i:46;s:100:\"jS=hT?GUrKlBzL.4Fx~5AAvW=hT?GU7KlB7L.4Fx~5AA;C=hT?GU;KlBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAgA\";i:47;s:13:\"9M=hT?GUALlBA\";i:48;s:46:\"HH=hT?GUQLlBjL.4Fx~5AAYL=hT?GUgLlBrL.4Fx~5AABA\";i:49;s:13:\"EH=hT?GUwLlBA\";i:50;s:23:\"!M=hT?GUpA$A<CSOYMtOBtA\";i:51;s:23:\"!M=hT?GUpA$A<CSOYMtOBtA\";i:52;s:35:\"jg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlBA\";i:53;s:35:\"jg=hT?GU$LlB,L.4Fx~5QA1k=hT?GU$LlBA\";i:54;s:35:\"e#=hT?GU(ClBYM.4Fxs@DAw(=hT?GU(ClBA\";i:55;s:34:\"dS=hT?GUpA$A]CSOYMtOBt$$_Q3nE3`F$A\";i:56;s:17:\"sP>hT?IURIlBrzIAB\";i:57;s:29:\"zd>hT?GU2JlB@M.4?zrjJAq1$ElBA\";i:58;s:35:\"Sj>hT?GU2JlB_M.4Fx~5NA6F=hT?GUVMlBA\";i:59;s:61:\"fS=hT?GUlMlBzL.4Fxs@RAvW=hT?GUlMlB7L.4Fxs@RAHO>hT?IU<HlBqGJAB\";i:60;s:13:\"t8=hT?GUGJlBA\";i:61;s:35:\"uP>hT?GU`MlBJN.4Fx~5SApI=hT?GUaNlBA\";i:62;s:34:\"6r>hT?GUqNlBfL.4Fx~5AA[Q=hT?GUpA$A\";i:63;s:34:\"6r>hT?GUqNlBfL.4Fx~5AA[Q=hT?GUpA$A\";i:64;s:24:\"FH=hT?GUeBlBvL.4FxrjTABA\";i:65;s:155:\"oS=hT?GU:NlBzL.4Fx~5AAvW=hT?GU:NlB7L.4Fx~5AA|e=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzLYuWyKqI:$vbiAQA+\",ub@CG5FQwLvSQ[zDAbLjt,ub@uC5FgwLvSQ[zDAFtjt,ub@|35FA\";i:66;s:100:\"pg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzLYuWyKqI:$vbiAQA+\",ub@CG5FQwLvSQ[zDAbLjt,ub@uC5FgwLvSQ[zDAEA\";i:67;s:116:\",5=hT?IUBIlBV`JAsP_Q3nE3UAgArBJHNzWHuWNJqI:$vbKAS\"*\",ub@CG5F7vLvSQ[zIAEA$(k)NoBD:CIYzXJI|+BA7F$(k)NoXB:CQYzXJI|+BACA\";i:68;s:13:\"!5=hT?GU\"NlBA\";i:69;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GUPOlBkM.4Fx}MUA};=hT?GUPOlBsM.4FxrjUA2[=hT?GUvOlB0M.4FxrjUAU|=hT?GUYDlB8M.4Fxs@EA;C>hT?GUYDlB)M.4Fx~5EApI>hT?GUoDlB<M.4Fx~5EABA\";i:70;s:111:\"qg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA6F=hT?GUOBlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:71;s:100:\"jS=hT?GUpA$A<CSOYMtOBtrP_Q3nE3QE$A{CSOYM6|DtaS_Q3nE3QE$A}CSOYMLUGtJV_Q3nE3fH$A\"CSOYMLUGt$$_Q3nE3&G$A\";i:72;s:122:\"lS=hT?GURIlBzL.4Fx~5AAvW=hT?GU?OlB7L.4Fx~5AA|e=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNz#8wWyKqI:$vb*DgAtBJHNz#8wWGOqI:$vbtDgA\";i:73;s:111:\"qg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA6F=hT?GUOBlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:74;s:100:\"jS=hT?GUpA$A<CSOYMtOBtrP_Q3nE3QE$A{CSOYM6|DtaS_Q3nE3QE$A}CSOYMLUGtJV_Q3nE3fH$A\"CSOYMLUGt$$_Q3nE3&G$A\";i:75;s:122:\"lS=hT?GUHGlBzL.4Fx~5AAvW=hT?GUCFlB7L.4Fx~5AA|e=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNz#8wWyKqI:$vb*DgAtBJHNz#8wWGOqI:$vbtDgA\";i:76;s:23:\"cS=hT?GUpA$AdDSOYM*+FtA\";i:77;s:46:\"eS=hT?GURIlBzL.4Fx~5AAvW=hT?GU?OlB7L.4Fx~5AABA\";i:78;s:24:\"ou>hT?GUBIlBfL.4Fxs@RABA\";i:79;s:24:\":o>hT?GUqNlBfL.4Fx~5AABA\";i:80;s:79:\"hS=hT?GURIlBzL.4Fx~5AAvW=hT?GU?OlB7L.4Fx~5AACt>hT?GU\"NlBMM.4Fxs@TAHO=hT?GUUPlBA\";i:81;s:13:\"_X=hT?GU,GlBA\";i:82;s:13:\"t8=hT?GUGJlBA\";i:83;s:46:\"eS=hT?GUiFlBzL.4Fxs@IAvW=hT?GUiFlB7L.4Fxs@IABA\";i:84;s:45:\"+a>hT?GUkPlBlN.4Fx}MWA$T>hT?GUpA$AXDSOYMtOBtA\";i:85;s:77:\"y8=hT?KUTClB&!BA(a6AxtmBJHNz{,wWvDqI:$vb`DgA!BJHNz*:wW?jqI:$vb~DgA#BJHNz*:wWA\";i:86;s:68:\">o=hT?GUJQlB^L.4Fxs@WACt=hT?GUJQlBbL.4Fx}MXApI=hT?GUXGlBrL.4Fxs@IABA\";i:87;s:46:\"<o=hT?GUpQlB^L.4FxrjXACt=hT?GUpQlBbL.4Fx~5XABA\";i:88;s:13:\"t8>hT?GU/QlBA\";i:89;s:24:\"u8=hT?GU{JlBRN.4FxrjMABA\";i:90;s:13:\"c#>hT?GU$LlBA\";i:91;s:13:\"c#>hT?GU~QlBA\";i:92;s:77:\"y8=hT?KUTClB&!BA(a6AxtmBJHNz{,wWvDqI:$vb`DgA!BJHNz*:wW?jqI:$vb~DgA#BJHNz*:wWA\";i:93;s:149:\"\"J=hT?GUXGlBrL.4Fxs@IAkn=hT?GUORlB^L.4FxrjYACt=hT?GUORlBQM.4?zrjDAq1ZBlBKGkcwY\"cO\"gg_Q3nE38I$AHDSOYMtOHth=_Q3nE3JB$ALDSOYM?IGt.o_Q3nE3XH$ANDSOYM?IGtA\";i:94;s:57:\"x8=hT?GUGJlBbL.4Fxs@YAkn=hT?GUqNlB^L.4Fx}MTACt=hT?GUqNlBA\";i:95;s:57:\"ZE=hT?GU!RlBRN.4Fx}MZAkn=hT?GU>RlB^L.4FxrjZACt=hT?GU>RlBA\";i:96;s:57:\"ZE=hT?GUZQlBRN.4Fx}MXAkn=hT?GUJQlB^L.4Fxs@WACt=hT?GUJQlBA\";i:97;s:23:\"?J=hT?GUpA$A?CSOYMtODtA\";i:98;s:24:\"ou>hT?GUBIlBvL.4Fx~5LABA\";i:99;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzApvWA\";i:100;s:35:\"|)>hT?GU2JlB_M.4Fx~5NANc>hT?GU2JlBA\";i:101;s:13:\"sP=hT?GUSFlBA\";i:102;s:13:\"sP>hT?GU3GlBA\";i:103;s:46:\"})>hT?GU2JlB_M.4Fx~5NANc>hT?GU2JlBjL.4Fx~5HABA\";i:104;s:13:\"yd>hT?GU2JlBA\";i:105;s:13:\"KV=hT?GUDSlBA\";i:106;s:13:\"(a=hT?GUDSlBA\";i:107;s:46:\"Tj>hT?GU2JlB_M.4Fx~5NAHO>hT?GU3GlBJN.4Fx~5NABA\";i:108;s:77:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuW{eqI:$vbyEi\"vBJH=zijuWhNbA#(WK@QA\";i:109;s:55:\"w8=hT?KUTClB&!BA(a6AwA/\",ub@h55FKyLvSQ[z]Az(kt,ub@h55FA\";i:110;s:89:\":a>hT?GUkPlBlN.4Fx}MWA$T>hT?GUpA$AXDSOYMtOBtoI_Q3nE3/B$A[CSOYM)ZCtXL_Q3nE3/B$A^CSOYM)ZCtA\";i:111;s:13:\"EH=hT?GU4DlBA\";i:112;s:13:\"(a>hT?GUjSlBA\";i:113;s:24:\"Am>hT?GUzSlB}M.4Fx~5AABA\";i:114;s:13:\"t8=hT?GUGJlBA\";i:115;s:57:\"Uj>hT?GU(SlBvL.4Fxs@SA$T=hT?GU4DlB3L.4Fxs@SAeZ=hT?GU^SlBA\";i:116;s:13:\"),>hT?GUqNlBA\";i:117;s:13:\"),>hT?GUqNlBA\";i:118;s:89:\":a>hT?GUjSlBVN.4Fx}MbA[Q>hT?GUYTlBRN.4FxrjMAO/>hT?GUoTlBQM.4Fxs@MA};>hT?GUpA$ArDSOYM6|HtA\";i:119;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:120;s:56:\"Dm>hT?GUpA$A<CSOYMtOBtUE_Q3nE3UAgAnBJHNzWHuWvDqI:$vbKAQA\";i:121;s:24:\"B^>hT?GU.TlB~N.4FxrjcABA\";i:122;s:13:\"t8=hT?GUqNlBA\";i:123;s:45:\"HH=hT?GUiFlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOItA\";i:124;s:24:\"Am>hT?GUdUlB_M.4FxrjBABA\";i:125;s:45:\"HH=hT?GU,GlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOItA\";i:126;s:24:\"Am>hT?GUtUlB_M.4Fx}MGABA\";i:127;s:45:\"HH=hT?GUiFlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOItA\";i:128;s:24:\"Am>hT?GUdUlB_M.4FxrjBABA\";i:129;s:13:\"t8=hT?GUGJlBA\";i:130;s:56:\"Dm>hT?GU%IlBBN.4Fx~5AA$T>hT?GU5A$AqDSOYM6|Dtxd_Q3nE3wE$A\";i:131;s:34:\"Bm>hT?GUpA$AXDSOYM?IEtxd_Q3nE3wE$A\";i:132;s:23:\"`X>hT?GU5A$AWDSOYM?IEtA\";i:133;s:88:\"z8=hT?KUTClB&!BA(a6AxtxBJHNz5uwWaSqI:$vbxDi\"yBJHNz5uwW#TqI:$vbuARtzBJHNzzguWJVqI:$vbuAQA\";i:134;s:13:\"t8=hT?GUGJlBA\";i:135;s:55:\"w8=hT?KUTClB&!BA(a6Ay\":\",ub@FN5FPzLvSQ[zTAFtlt,ub@FN5FA\";i:136;s:13:\"t8=hT?GU{JlBA\";i:137;s:154:\"?a>hT?GUjSlBlN.4FxrjdA1k>hT?GU=UlBBN.4Fxs@dA6F=hT?GUSVlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOIt\"]_Q3nE3UAi\"(BJHNz{,xWcsqI:$wbjFi\".^vW#zhBYApt,ub@c}5F^3LvSQ[zWBIA\";i:138;s:45:\"HH=hT?GUiFlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOItA\";i:139;s:13:\"t8=hT?GUGJlBA\";i:140;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:141;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:142;s:13:\"hg>hT?GUXWlBA\";i:143;s:46:\"eS=hT?GURIlBzL.4Fx~5AAvW=hT?GU:NlB7L.4Fxs@fABA\";i:144;s:63:\"fS=hT?GU:NlBzL.4Fx~5AAvW=hT?GU:NlB7L.4FxrjGAHO>hT?IU|GlBrzat5FA\";i:145;s:48:\"eS=hT?GU~@$Aln#(k)No]AlB3L.4Fx~5TAeZ=hT?GU}j%ACA\";i:146;s:35:\"H0=hT?GUYDlBAM.4Fxs@EAq1=hT?GUYDlBA\";i:147;s:35:\"H0=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBA\";i:148;s:35:\"H0=hT?GU>BlBAM.4FxrjCAq1=hT?GU>BlBA\";i:149;s:35:\"GH>hT?GUYDlB.M.4Fxs@EAYL>hT?GUYDlBA\";i:150;s:35:\"GH>hT?GUDClB.M.4Fxs@CAYL>hT?GUDClBA\";i:151;s:35:\"GH>hT?GU>BlB.M.4FxrjCAYL>hT?GU>BlBA\";i:152;s:38:\"jg=hT?GU~@%Ax(#(k)No`,oB2W*\",ub@=1[CQA\";i:153;s:35:\"jg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlBA\";i:154;s:50:\"<o=hT?GU}j&Am_#(k)No`,pBIAjt,ub@=1^CRtlBJHNzij*L$A\";i:155;s:50:\"<o=hT?GU}j(Am_#(k)No`,rBIAjt,ub@=1|CRtlBJHNzij`L$A\";i:156;s:50:\"<o=hT?GU}j)Am_#(k)No`,tBIAjt,ub@=1ADRtlBJHNzijKM$A\";i:157;s:50:\"<o=hT?GU}j*Am_#(k)No`,vBIAjt,ub@=1EDRtlBJHNzijaM$A\";i:158;s:50:\"<o=hT?GU}j+Am_#(k)No`,xBIAjt,ub@=1IDRtlBJHNzijqM$A\";i:159;s:49:\"<o=hT?GU}j,Am_#(k)No`,zBIAjt,ub@=1MDRtlBJHNzd&vWA\";i:160;s:50:\"<o=hT?GU~@,Am_#(k)No`,0BIAjt,ub@=1ODRtlBJHNzij&M$A\";i:161;s:50:\"<o=hT?GU~@.Am_#(k)No`,2BIAjt,ub@=1SDRtlBJHNzij]M$A\";i:162;s:50:\"<o=hT?GU~@/Am_#(k)No`,4BIAjt,ub@=1WDRtlBJHNzijHN$A\";i:163;s:50:\"<o=hT?GU~@:Am_#(k)No`,6BIAjt,ub@=1aDRtlBJHNzijXN$A\";i:164;s:50:\"<o=hT?GU~@;Am_#(k)No`,8BIAjt,ub@=1eDRtlBJHNzijnN$A\";i:165;s:49:\"<o=hT?GU~@<Am_#(k)No`,!BIAjt,ub@=1iDRtlBJHNzoxvWA\";i:166;s:12:\"KV>hT?GU5A$A\";i:167;s:14:\"KV>hT?GU~@&ACA\";i:168;s:14:\"KV>hT?GU~@(ACA\";i:169;s:14:\"KV>hT?GU~@)ACA\";i:170;s:14:\"KV>hT?GU~@*ACA\";i:171;s:14:\"KV>hT?GU~@+ACA\";i:172;s:13:\"KV>hT?GU+JlBA\";i:173;s:14:\"KV>hT?GU}j.ACA\";i:174;s:14:\"KV>hT?GU}j/ACA\";i:175;s:14:\"KV>hT?GU}j:ACA\";i:176;s:14:\"KV>hT?GU}j;ACA\";i:177;s:14:\"KV>hT?GU}j<ACA\";i:178;s:13:\"KV>hT?GU%IlBA\";i:179;s:12:\"_X>hT?GU5A$A\";i:180;s:14:\"_X>hT?GU~@&ACA\";i:181;s:14:\"_X>hT?GU~@(ACA\";i:182;s:14:\"_X>hT?GU~@)ACA\";i:183;s:14:\"_X>hT?GU~@*ACA\";i:184;s:14:\"_X>hT?GU~@+ACA\";i:185;s:13:\"_X>hT?GU+JlBA\";i:186;s:14:\"_X>hT?GU}j.ACA\";i:187;s:14:\"_X>hT?GU}j/ACA\";i:188;s:14:\"_X>hT?GU}j:ACA\";i:189;s:14:\"_X>hT?GU}j;ACA\";i:190;s:14:\"_X>hT?GU}j<ACA\";i:191;s:13:\"_X>hT?GU%IlBA\";i:192;s:14:\"sP=hT?GU}j=ACA\";i:193;s:14:\"sP=hT?GU~@&ACA\";i:194;s:14:\"sP=hT?GU~@(ACA\";i:195;s:14:\"sP=hT?GU~@)ACA\";i:196;s:14:\"sP=hT?GU~@*ACA\";i:197;s:14:\"sP=hT?GU~@+ACA\";i:198;s:13:\"sP=hT?GU+JlBA\";i:199;s:14:\"sP=hT?GU}j.ACA\";i:200;s:14:\"sP=hT?GU}j/ACA\";i:201;s:14:\"sP=hT?GU}j:ACA\";i:202;s:14:\"sP=hT?GU}j;ACA\";i:203;s:14:\"sP=hT?GU}j<ACA\";i:204;s:13:\"sP=hT?GU%IlBA\";i:205;s:24:\")a=hT?GUFMlBzL.4Fx}MRABA\";i:206;s:26:\"tP=hT?GU~@=A]Q#(k)No`,$BIA\";i:207;s:24:\")a=hT?GUFMlBzL.4Fx}MRABA\";i:208;s:36:\"XE=hT?GU}j>A8y#(k)NoKY:CLXzXJI{ZiACA\";i:209;s:45:\"eS=hT?GU/A$A[CSOYMifDtXL_Q3nE3kAi\"pBJHNz!PvWA\";i:210;s:46:\"eS=hT?GU|GlBzL.4Fx}MFAvW=hT?GU~AlB7L.4Fx~5fABA\";i:211;s:41:\"uP>hT?IU]FlBrzs35FCazXJI{ZXAP/%(k)NoYO:CA\";i:212;s:30:\"tP>hT?IU3GlB&!GA:`_Q3nE3\"!nABA\";i:213;s:13:\"sP>hT?GU<HlBA\";i:214;s:14:\"VE?hT?GU~@?ACA\";i:215;s:13:\"sP=hT?GUOBlBA\";i:216;s:46:\"HH=hT?GU/A$A=CSOYM)ZBt5F_Q3nE3~RoAHO=hT?GU/A$A\";i:217;s:14:\"sP>hT?GU~@aCEA\";i:218;s:13:\"sP>hT?GU4DlBA\";i:219;s:56:\"IH=hT?GUpA$A=CSOYMM%Ct5F_Q3nE3UAi\"nBJHNz0=uWCaqI:$vbxLgA\";i:220;s:14:\"sP>hT?GU~@aCEA\";i:221;s:13:\"sP>hT?GU4DlBA\";i:222;s:59:\"IH=hT?GUpA$A=CSOYM*+4clBnL.4Fx~5AAHO=hT?GU}j[AOc%(k)NocC;CA\";i:223;s:46:\"eS=hT?GU;6lBzL.4Fx~5$AvW=hT?GU@7lB7L.4Fx~5$ABA\";i:224;s:49:\"eS=hT?GUtElBzL.4Fx}MQZ6FmuLvSQ[z!KzWeGqI:$vb)qW\"A\";i:225;s:47:\"eS=hT?GU3GlBzL.4Fx~5AAvW=hT?GU}j]A8y#(k)No]AlBA\";i:226;s:63:\"wP>hT?IUeBlBV`LA!5_Q3nE3RJ$AEDSOYMLUEtp1_Q3nE3FF$AcDSOYM*+NdlBA\";i:227;s:17:\"sP>hT?IU~AlBUoEAB\";i:228;s:90:\"LH=hT?GU3GlBjL.4Fx~5AAYL=hT?GU3GlBrL.4Fx~5AA[Q=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzijkO$A\";i:229;s:46:\"eS=hT?GU3GlBzL.4Fx~5AAvW=hT?GU3GlB7L.4Fx~5AABA\";i:230;s:58:\"ZE=hT?GU}j^AZL#(k)NoTN:C+WzXJI|+BAwW#(k)No8C:C{WzXJI|+BACA\";i:231;s:46:\"HH=hT?GUeBlBjL.4Fx~5AAYL=hT?GU~AlBrL.4Fx~5AABA\";i:232;s:45:\"HH=hT?GUpA$A=CSOYM5qBt5F_Q3nE3UAi\"nBJHNzcVuWA\";i:233;s:19:\"sP>hT?IUbKlBrzA75FA\";i:234;s:17:\"sP>hT?IU3GlB&!GAB\";i:235;s:59:\"x8=hT?GU{JlBfL.4Fx~5AApI=hT?GU}j_AwW#(k)No]AlBrL.4Fx}M#c6FA\";i:236;s:17:\"sP>hT?IU3GlB&!GAB\";i:237;s:50:\"eS=hT?GU~@_Aln#(k)No`,,BIAit,ub@=1)DRtpBJHNzijcO$A\";i:238;s:48:\"eS=hT?GUpA$A[CSOYM*+.clB3L.4Fx~5AAeZ=hT?GU~@[ACA\";i:239;s:46:\"eS=hT?GU3GlBzL.4FxrjJAvW=hT?GUtElB7L.4FxrjJABA\";i:240;s:61:\"wP>hT?IU~AlBUoEApI_Q3nE3/B$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:241;s:48:\"eS=hT?GUeBlBzL.4Fx}M/e6FmuLvSQ[zHAbLit,ub@=1+DQA\";i:242;s:46:\"eS=hT?GU1MlBzL.4FxrjFAvW=hT?GU1MlB7L.4FxrjFABA\";i:243;s:19:\"sP>hT?IUSFlBrz*85FA\";i:244;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:245;s:32:\"Am>hT?GU}j|AOc%(k)Ro`,_B3(=1@DgA\";i:246;s:59:\"fS=hT?GU~@[Aln#(k)No}O:CTXzXJI{ZBA8y#(k)No}O:CjXzXJI{ZE+ZLA\";i:247;s:46:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GUUPlBrL.4Fx~5AABA\";i:248;s:17:\"sP>hT?IU~AlBUoEAB\";i:249;s:45:\"HH=hT?GUXWlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:250;s:69:\"aE=hT?GU}j~AFtjt,ub@|35FhtLvSQ[zCA/hht,ub@uC5F%tLvSQ[zCAc4ht,ub@/B5FA\";i:251;s:13:\"VE=hT?GU;KlBA\";i:252;s:69:\"aE=hT?GU}j~AFtjt,ub@|35FhtLvSQ[zCA/hht,ub@/B5F%tLvSQ[zCAc4ht,ub@uC5FA\";i:253;s:13:\"VE=hT?GU;KlBA\";i:254;s:20:\"sP>hT?IU~@~A/h`,~BQA\";i:255;s:19:\"sP>hT?IUWJlBrz_#5FA\";i:256;s:104:\"dE=hT?GU}jAByWht,ub@/B5FxtLvSQ[zDAFtht,ub@/B5F[tLvSQ[zDAz(ht,ub@=1DERtoBJHNzWHuW5FqI:$vb\"IZ\"8M_Q3nE3UAgA\";i:257;s:46:\"eS=hT?GU3GlBzL.4FxrjBAvW=hT?GU3GlB7L.4FxrjBABA\";i:258;s:46:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3t`tAeZ=hT?GUpA$A\";i:259;s:46:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3t`tAeZ=hT?GUpA$A\";i:260;s:104:\"dE=hT?GU}jAByWht,ub@/B5FxtLvSQ[zDAFtht,ub@/B5F[tLvSQ[zDAz(ht,ub@=14DRtoBJHNzWHuW5FqI:$vbA2W\"8M_Q3nE3UAgA\";i:261;s:46:\"eS=hT?GU.DlBzL.4FxrjbAvW=hT?GU]FlB7L.4FxrjbABA\";i:262;s:20:\"sP>hT?IU~@~A/h`,~BQA\";i:263;s:13:\"bS=hT?GUALlBA\";i:264;s:46:\"eS=hT?GUALlBzL.4Fx~5PAvW=hT?GUALlB7L.4Fx~5PABA\";i:265;s:17:\"sP>hT?IU~AlBUoEAB\";i:266;s:60:\"fS=hT?GU~@BB:>ht,ub@^D5FmuLvSQ[z0.zWeGqI:$vbWARtlBJHNzijmQ$A\";i:267;s:19:\"sP>hT?IUSFlBrz*85FA\";i:268;s:20:\"sP>hT?IU~@CB/h`,GCQA\";i:269;s:13:\"9M=hT?GUALlBA\";i:270;s:46:\"HH=hT?GU~AlBjL.4FxrjBAYL=hT?GU~AlBrL.4FxrjBABA\";i:271;s:13:\"KV>hT?GU3GlBA\";i:272;s:13:\"_X>hT?GU3GlBA\";i:273;s:13:\"9M=hT?GUALlBA\";i:274;s:46:\"eS=hT?GU,GlBzL.4FxrjGAvW=hT?GU8HlB7L.4FxrjGABA\";i:275;s:13:\"sP>hT?GU~AlBA\";i:276;s:13:\"t8=hT?GUqNlBA\";i:277;s:13:\"t8=hT?GU{JlBA\";i:278;s:13:\"t8=hT?GU{JlBA\";i:279;s:13:\"t8=hT?GUqNlBA\";i:280;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:281;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:282;s:13:\"\"l>hT?GU~AlBA\";i:283;s:13:\"t8=hT?GUqNlBA\";i:284;s:13:\"t8=hT?GU{JlBA\";i:285;s:46:\"eS=hT?GU4DlBzL.4FxrjFAvW=hT?GU4DlB7L.4FxrjFABA\";i:286;s:13:\"t8=hT?GUqNlBA\";i:287;s:24:\"Am>hT?GU~AlBBN.4FxrjBABA\";i:288;s:24:\"Am>hT?GU~AlBBN.4FxrjBABA\";i:289;s:24:\"Am>hT?GUOBlBBN.4Fx~5BABA\";i:290;s:13:\"9M=hT?GU4DlBA\";i:291;s:35:\"pu>hT?GU\"NlBjL.4FxrjBAZ4=hT?GU\"NlBA\";i:292;s:13:\"sP>hT?GU~AlBA\";i:293;s:12:\"9M=hT?GUpA$A\";i:294;s:34:\"6r>hT?GUqNlBfL.4Fx~5AA[Q=hT?GUpA$A\";i:295;s:25:\"ou>hT?GU\"NlBjL.4Fx}Mqr6FA\";i:296;s:100:\"pg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzLYuWyKqI:$vbiAQA+\",ub@CG5FQwLvSQ[zDAbLjt,ub@uC5FgwLvSQ[zDAEA\";i:297;s:35:\"+,=hT?GU^ClBkM.4Fx}MEA};=hT?GU^ClBA\";i:298;s:13:\"bS=hT?GU<HlBA\";i:299;s:35:\"+,=hT?GU^ClBkM.4Fx}MEA};=hT?GU^ClBA\";i:300;s:13:\"bS=hT?GU<HlBA\";i:301;s:58:\"2d>hT?GU}jEByWht,ub@qO5FxtLvSQ[zCAFtht,ub@qO5F[tLvSQ[zCAEA\";i:302;s:13:\">J=hT?GUsHlBA\";i:303;s:67:\"su>hT?GU\"NlBRN.4Fxs@AA6F=hT?GUpA$A=CSOYMu7Et5F_Q3nE3IE$A?CSOYMtOBtA\";i:304;s:49:\"eS=hT?GU~@EB:>ht,ub@PP5FmuLvSQ[zWC0WeGqI:$vbWUa\"A\";i:305;s:14:\"bS=hT?GU}j`ACA\";i:306;s:13:\"(a=hT?GU~AlBA\";i:307;s:13:\"9M=hT?GUALlBA\";i:308;s:48:\"HH=hT?GU}jGB/hht,ub@/B5F%tLvSQ[z?H0WvDqI:$vbKAQA\";i:309;s:25:\"zd>hT?GU}jEBFtht,ub@)g5FA\";i:310;s:30:\"tP>hT?IUWJlBrz_#5FCazXJI{ZBACA\";i:311;s:35:\"H0=hT?GUYDlBAM.4Fxs@EAq1=hT?GUYDlBA\";i:312;s:35:\"H0=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBA\";i:313;s:35:\"H0=hT?GU>BlBAM.4FxrjCAq1=hT?GU>BlBA\";i:314;s:35:\"GH>hT?GUYDlB.M.4Fxs@EAYL>hT?GUYDlBA\";i:315;s:35:\"GH>hT?GUDClB.M.4Fxs@CAYL>hT?GUDClBA\";i:316;s:35:\"GH>hT?GU>BlB.M.4FxrjCAYL>hT?GU>BlBA\";i:317;s:38:\"jg=hT?GU~@%Ax(#(k)No`,oB2W*\",ub@=1[CQA\";i:318;s:35:\"jg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlBA\";i:319;s:50:\"<o=hT?GU}j&Am_#(k)No`,pBIAjt,ub@=1^CRtlBJHNzij*L$A\";i:320;s:50:\"<o=hT?GU}j(Am_#(k)No`,rBIAjt,ub@=1|CRtlBJHNzij`L$A\";i:321;s:50:\"<o=hT?GU}j)Am_#(k)No`,tBIAjt,ub@=1ADRtlBJHNzijKM$A\";i:322;s:50:\"<o=hT?GU}j*Am_#(k)No`,vBIAjt,ub@=1EDRtlBJHNzijaM$A\";i:323;s:50:\"<o=hT?GU}j+Am_#(k)No`,xBIAjt,ub@=1IDRtlBJHNzijqM$A\";i:324;s:49:\"<o=hT?GU}j,Am_#(k)No`,zBIAjt,ub@=1MDRtlBJHNzd&vWA\";i:325;s:50:\"<o=hT?GU~@,Am_#(k)No`,0BIAjt,ub@=1ODRtlBJHNzij&M$A\";i:326;s:50:\"<o=hT?GU~@.Am_#(k)No`,2BIAjt,ub@=1SDRtlBJHNzij]M$A\";i:327;s:50:\"<o=hT?GU~@/Am_#(k)No`,4BIAjt,ub@=1WDRtlBJHNzijHN$A\";i:328;s:50:\"<o=hT?GU~@:Am_#(k)No`,6BIAjt,ub@=1aDRtlBJHNzijXN$A\";i:329;s:50:\"<o=hT?GU~@;Am_#(k)No`,8BIAjt,ub@=1eDRtlBJHNzijnN$A\";i:330;s:49:\"<o=hT?GU~@<Am_#(k)No`,!BIAjt,ub@=1iDRtlBJHNzoxvWA\";i:331;s:12:\"KV>hT?GU5A$A\";i:332;s:14:\"KV>hT?GU~@&ACA\";i:333;s:14:\"KV>hT?GU~@(ACA\";i:334;s:14:\"KV>hT?GU~@)ACA\";i:335;s:14:\"KV>hT?GU~@*ACA\";i:336;s:14:\"KV>hT?GU~@+ACA\";i:337;s:13:\"KV>hT?GU+JlBA\";i:338;s:14:\"KV>hT?GU}j.ACA\";i:339;s:14:\"KV>hT?GU}j/ACA\";i:340;s:14:\"KV>hT?GU}j:ACA\";i:341;s:14:\"KV>hT?GU}j;ACA\";i:342;s:14:\"KV>hT?GU}j<ACA\";i:343;s:13:\"KV>hT?GU%IlBA\";i:344;s:12:\"_X>hT?GU5A$A\";i:345;s:14:\"_X>hT?GU~@&ACA\";i:346;s:14:\"_X>hT?GU~@(ACA\";i:347;s:14:\"_X>hT?GU~@)ACA\";i:348;s:14:\"_X>hT?GU~@*ACA\";i:349;s:14:\"_X>hT?GU~@+ACA\";i:350;s:13:\"_X>hT?GU+JlBA\";i:351;s:14:\"_X>hT?GU}j.ACA\";i:352;s:14:\"_X>hT?GU}j/ACA\";i:353;s:14:\"_X>hT?GU}j:ACA\";i:354;s:14:\"_X>hT?GU}j;ACA\";i:355;s:14:\"_X>hT?GU}j<ACA\";i:356;s:13:\"_X>hT?GU%IlBA\";i:357;s:14:\"sP=hT?GU}j=ACA\";i:358;s:14:\"sP=hT?GU~@&ACA\";i:359;s:14:\"sP=hT?GU~@(ACA\";i:360;s:14:\"sP=hT?GU~@)ACA\";i:361;s:14:\"sP=hT?GU~@*ACA\";i:362;s:14:\"sP=hT?GU~@+ACA\";i:363;s:13:\"sP=hT?GU+JlBA\";i:364;s:14:\"sP=hT?GU}j.ACA\";i:365;s:14:\"sP=hT?GU}j/ACA\";i:366;s:14:\"sP=hT?GU}j:ACA\";i:367;s:14:\"sP=hT?GU}j;ACA\";i:368;s:14:\"sP=hT?GU}j<ACA\";i:369;s:13:\"sP=hT?GU%IlBA\";i:370;s:26:\")a=hT?GU~@GB:>ht,ub@=1bEQA\";i:371;s:26:\"tP=hT?GU}jHB/hht,ub@=1dEQA\";i:372;s:26:\")a=hT?GU~@GB:>ht,ub@=1bEQA\";i:373;s:38:\"XE=hT?GU~@HBbLit,ub@=1bERtoBJHNzijTR$A\";i:374;s:73:\"xP>hT?IU~AlBUoEApI_Q3nE3kAi\"oBJHNz!PvW5FqI:$vbaARtpBJHNz!PvWDHqI:$vbu<a\"A\";i:375;s:17:\"sP>hT?IU<HlBqGJAB\";i:376;s:17:\"sP>hT?IU~AlBUoEAB\";i:377;s:20:\"sP>hT?IU~@~A/h`,~BQA\";i:378;s:30:\"tP>hT?IU3GlB&!GA:`_Q3nE3t`xABA\";i:379;s:13:\"sP>hT?GUSFlBA\";i:380;s:13:\"sP>hT?GU5wlBA\";i:381;s:45:\"HH=hT?GU/A$A=CSOYM)ZBt5F_Q3nE3kAi\"nBJHNz?MuWA\";i:382;s:48:\"HH=hT?GUpA$A=CSOYM*+bjlBnL.4Fx~5AAHO=hT?GU}jJBEA\";i:383;s:57:\"IH=hT?GUpA$A=CSOYM)ZBt5F_Q3nE3UAi\"nBJHNz?MuWCaqI:$vbWU2\"A\";i:384;s:48:\"HH=hT?GUpA$A=CSOYM*+bjlBnL.4Fx~5AAHO=hT?GU}jJBEA\";i:385;s:13:\"sP>hT?GU5wlBA\";i:386;s:45:\"HH=hT?GU/A$A=CSOYM)ZBt5F_Q3nE3kAi\"nBJHNz?MuWA\";i:387;s:48:\"HH=hT?GUpA$A=CSOYM*+bjlBnL.4Fx~5AAHO=hT?GU}jJBEA\";i:388;s:60:\"IH=hT?GUpA$A=CSOYM*+4clBnL.4Fx~5AAHO=hT?GU}j[AOc%(k)No`,1EIA\";i:389;s:48:\"HH=hT?GUpA$A=CSOYM*+bjlBnL.4Fx~5AAHO=hT?GU}jJBEA\";i:390;s:26:\"cS=hT?GU~@JBG\"#(k)No`,UCIA\";i:391;s:45:\"eS=hT?GUpA$A[CSOYMifDtXL_Q3nE3UAi\"pBJHNzB{xWA\";i:392;s:90:\"yP>hT?IUXWlBrz8,5FKazXJI{Z0AOc$(k)NoMS:C=ZzXJI{ZASaL#TVElg*N6=Ntb#_Q3nE3\"!zA6F?hT?GU}jJBEA\";i:393;s:58:\"fS=hT?GUXWlBzL.4Fx~5fAvW=hT?GUXWlB7L.4Fx~5fANc=hT?GU~@MBEA\";i:394;s:19:\"sP>hT?IUaNlBrzm/5FA\";i:395;s:17:\"sP>hT?IUeBlBV`LAB\";i:396;s:17:\"sP>hT?IU~AlBUoEAB\";i:397;s:45:\"eS=hT?GUpA$A[CSOYMB]ItXL_Q3nE3UAi\"pBJHNzB{xWA\";i:398;s:47:\"eS=hT?GU~@EB:>ht,ub@dF5FmuLvSQ[zHAbLit,ub@dF5FA\";i:399;s:48:\"HH=hT?GUpA$A=CSOYM*+@klBnL.4Fx~5AAHO=hT?GU~@NBEA\";i:400;s:20:\"sP>hT?IU~@~A/h`,~BQA\";i:401;s:17:\"sP>hT?IU~AlBUoEAB\";i:402;s:19:\"sP>hT?IU4DlBrz=)5FA\";i:403;s:61:\"fS=hT?GU}jOB:>ht,ub@=1XEQA)\",ub@/B5F2uLvSQ[zFF0WDHqI:$vb)qc\"A\";i:404;s:25:\")a=hT?GU~AlBQM.4Fx}M676FA\";i:405;s:14:\"t8=hT?GU}jPBEA\";i:406;s:47:\"eS=hT?GU~@PB:>ht,ub@ZR5FmuLvSQ[z5AbLit,ub@ZR5FA\";i:407;s:14:\"VE=hT?GU}jQBEA\";i:408;s:49:\"eS=hT?GU~@QB:>ht,ub@=12DQA)\",ub@ma5F2uLvSQ[z!KzWA\";i:409;s:14:\"EH=hT?GU}jRBEA\";i:410;s:47:\"HH=hT?GUpA$A=CSOYMLUIt5F_Q3nE3so2AHO=hT?GUdUlBA\";i:411;s:45:\"eS=hT?GUpA$A[CSOYMifBtXL_Q3nE3/B$A^CSOYMifBtA\";i:412;s:23:\"FH=hT?GUpA$A>CSOYMtOBtA\";i:413;s:23:\"FH=hT?GUpA$A>CSOYMtOBtA\";i:414;s:23:\"FH=hT?GUpA$A>CSOYMtOBtA\";i:415;s:61:\"fS=hT?GUOBlBzL.4Fx}MNAvW=hT?GUOBlB7L.4Fx~5JAHO>hT?IU<HlBqGJAB\";i:416;s:13:\"t8=hT?GU{JlBA\";i:417;s:61:\"fS=hT?GUlMlBzL.4Fxs@RAvW=hT?GUlMlB7L.4Fxs@RAHO>hT?IU<HlBqGJAB\";i:418;s:13:\"(a>hT?GUjSlBA\";i:419;s:25:\"ou>hT?GUBIlBfL.4Fx}M>#6FA\";i:420;s:34:\"dS=hT?GUpA$A<CSOYM)ZBt$$_Q3nE3&G$A\";i:421;s:14:\"_X=hT?GU~@LBEA\";i:422;s:12:\"Qj>hT?GU5A$A\";i:423;s:46:\"HH=hT?GUpA$A=CSOYM*+6mlBnL.4Fx}MQAHO=hT?GUpA$A\";i:424;s:47:\"eS=hT?GU}jTB:>ht,ub@As5FmuLvSQ[zCAbLit,ub@As5FA\";i:425;s:13:\"(a=hT?GULKlBA\";i:426;s:48:\"HH=hT?GUpA$A=CSOYM*+[hlBnL.4Fx~5AAHO=hT?GU}jFBEA\";i:427;s:35:\"H0=hT?GUYDlBAM.4Fxs@EAq1=hT?GUYDlBA\";i:428;s:35:\"H0=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBA\";i:429;s:35:\"H0=hT?GU>BlBAM.4FxrjCAq1=hT?GU>BlBA\";i:430;s:35:\"GH>hT?GUYDlB.M.4Fxs@EAYL>hT?GUYDlBA\";i:431;s:35:\"GH>hT?GUDClB.M.4Fxs@CAYL>hT?GUDClBA\";i:432;s:35:\"GH>hT?GU>BlB.M.4FxrjCAYL>hT?GU>BlBA\";i:433;s:38:\"jg=hT?GU~@%Ax(#(k)No`,oB2W*\",ub@=1[CQA\";i:434;s:35:\"jg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlBA\";i:435;s:50:\"<o=hT?GU}j&Am_#(k)No`,pBIAjt,ub@=1^CRtlBJHNzij*L$A\";i:436;s:50:\"<o=hT?GU}j(Am_#(k)No`,rBIAjt,ub@=1|CRtlBJHNzij`L$A\";i:437;s:50:\"<o=hT?GU}j)Am_#(k)No`,tBIAjt,ub@=1ADRtlBJHNzijKM$A\";i:438;s:50:\"<o=hT?GU}j*Am_#(k)No`,vBIAjt,ub@=1EDRtlBJHNzijaM$A\";i:439;s:50:\"<o=hT?GU}j+Am_#(k)No`,xBIAjt,ub@=1IDRtlBJHNzijqM$A\";i:440;s:49:\"<o=hT?GU}j,Am_#(k)No`,zBIAjt,ub@=1MDRtlBJHNzd&vWA\";i:441;s:50:\"<o=hT?GU~@,Am_#(k)No`,0BIAjt,ub@=1ODRtlBJHNzij&M$A\";i:442;s:50:\"<o=hT?GU~@.Am_#(k)No`,2BIAjt,ub@=1SDRtlBJHNzij]M$A\";i:443;s:50:\"<o=hT?GU~@/Am_#(k)No`,4BIAjt,ub@=1WDRtlBJHNzijHN$A\";i:444;s:50:\"<o=hT?GU~@:Am_#(k)No`,6BIAjt,ub@=1aDRtlBJHNzijXN$A\";i:445;s:50:\"<o=hT?GU~@;Am_#(k)No`,8BIAjt,ub@=1eDRtlBJHNzijnN$A\";i:446;s:49:\"<o=hT?GU~@<Am_#(k)No`,!BIAjt,ub@=1iDRtlBJHNzoxvWA\";i:447;s:12:\"KV>hT?GU5A$A\";i:448;s:14:\"KV>hT?GU~@&ACA\";i:449;s:14:\"KV>hT?GU~@(ACA\";i:450;s:14:\"KV>hT?GU~@)ACA\";i:451;s:14:\"KV>hT?GU~@*ACA\";i:452;s:14:\"KV>hT?GU~@+ACA\";i:453;s:13:\"KV>hT?GU+JlBA\";i:454;s:14:\"KV>hT?GU}j.ACA\";i:455;s:14:\"KV>hT?GU}j/ACA\";i:456;s:14:\"KV>hT?GU}j:ACA\";i:457;s:14:\"KV>hT?GU}j;ACA\";i:458;s:14:\"KV>hT?GU}j<ACA\";i:459;s:13:\"KV>hT?GU%IlBA\";i:460;s:12:\"_X>hT?GU5A$A\";i:461;s:14:\"_X>hT?GU~@&ACA\";i:462;s:14:\"_X>hT?GU~@(ACA\";i:463;s:14:\"_X>hT?GU~@)ACA\";i:464;s:14:\"_X>hT?GU~@*ACA\";i:465;s:14:\"_X>hT?GU~@+ACA\";i:466;s:13:\"_X>hT?GU+JlBA\";i:467;s:14:\"_X>hT?GU}j.ACA\";i:468;s:14:\"_X>hT?GU}j/ACA\";i:469;s:14:\"_X>hT?GU}j:ACA\";i:470;s:14:\"_X>hT?GU}j;ACA\";i:471;s:14:\"_X>hT?GU}j<ACA\";i:472;s:13:\"_X>hT?GU%IlBA\";i:473;s:14:\"sP=hT?GU}j=ACA\";i:474;s:14:\"sP=hT?GU~@&ACA\";i:475;s:14:\"sP=hT?GU~@(ACA\";i:476;s:14:\"sP=hT?GU~@)ACA\";i:477;s:14:\"sP=hT?GU~@*ACA\";i:478;s:14:\"sP=hT?GU~@+ACA\";i:479;s:13:\"sP=hT?GU+JlBA\";i:480;s:14:\"sP=hT?GU}j.ACA\";i:481;s:14:\"sP=hT?GU}j/ACA\";i:482;s:14:\"sP=hT?GU}j:ACA\";i:483;s:14:\"sP=hT?GU}j;ACA\";i:484;s:14:\"sP=hT?GU}j<ACA\";i:485;s:13:\"sP=hT?GU%IlBA\";i:486;s:24:\")a=hT?GUXGlBzL.4Fxs@IABA\";i:487;s:24:\"tP=hT?GU)PlBjL.4FxrjWABA\";i:488;s:24:\")a=hT?GUXGlBzL.4Fxs@IABA\";i:489;s:36:\"XE=hT?GU~@TBbLit,ub@BZ5FWuLvSQ[zjAEA\";i:490;s:13:\"sP>hT?GU!xlBA\";i:491;s:13:\"sP>hT?GUDylBA\";i:492;s:13:\"sP>hT?GU=0lBA\";i:493;s:13:\"sP>hT?GU!xlBA\";i:494;s:52:\"Cm>hT?GUOBlBBN.4Fx}MFAI7=hT?GUGJlB@M.4?z}MNAq1sotACA\";i:495;s:13:\"(a=hT?GUeBlBA\";i:496;s:46:\"eS=hT?GUsHlBzL.4Fx~5KAvW=hT?GUsHlB7L.4Fx~5KABA\";i:497;s:46:\"eS=hT?GUtElBzL.4FxrjGAvW=hT?GUtElB7L.4FxrjGABA\";i:498;s:46:\"eS=hT?GU4DlBzL.4Fx}MFAvW=hT?GU4DlB7L.4Fx}MFABA\";i:499;s:13:\"\"l>hT?GU+JlBA\";i:500;s:68:\"su>hT?GU\"NlBbL.4Fxs@NA6F=hT?GUpA$A=CSOYM*+amlBnL.4Fx~5AAHO=hT?GUpA$A\";i:501;s:23:\"Rj>hT?GU5A$AVDSOYMLUBtA\";i:502;s:13:\"t8=hT?GUGJlBA\";i:503;s:13:\"t8=hT?GU{JlBA\";i:504;s:13:\"t8=hT?GUGJlBA\";i:505;s:13:\"KV>hT?GU4DlBA\";i:506;s:35:\"H0=hT?GUYDlBAM.4Fxs@EAq1=hT?GUYDlBA\";i:507;s:35:\"H0=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBA\";i:508;s:35:\"H0=hT?GU>BlBAM.4FxrjCAq1=hT?GU>BlBA\";i:509;s:35:\"GH>hT?GUYDlB.M.4Fxs@EAYL>hT?GUYDlBA\";i:510;s:35:\"GH>hT?GUDClB.M.4Fxs@CAYL>hT?GUDClBA\";i:511;s:35:\"GH>hT?GU>BlB.M.4FxrjCAYL>hT?GU>BlBA\";i:512;s:38:\"jg=hT?GU~@%Ax(#(k)No`,oB2W*\",ub@=1[CQA\";i:513;s:35:\"jg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlBA\";i:514;s:50:\"<o=hT?GU}j&Am_#(k)No`,pBIAjt,ub@=1^CRtlBJHNzij*L$A\";i:515;s:50:\"<o=hT?GU}j(Am_#(k)No`,rBIAjt,ub@=1|CRtlBJHNzij`L$A\";i:516;s:50:\"<o=hT?GU}j)Am_#(k)No`,tBIAjt,ub@=1ADRtlBJHNzijKM$A\";i:517;s:50:\"<o=hT?GU}j*Am_#(k)No`,vBIAjt,ub@=1EDRtlBJHNzijaM$A\";i:518;s:50:\"<o=hT?GU}j+Am_#(k)No`,xBIAjt,ub@=1IDRtlBJHNzijqM$A\";i:519;s:49:\"<o=hT?GU}j,Am_#(k)No`,zBIAjt,ub@=1MDRtlBJHNzd&vWA\";i:520;s:50:\"<o=hT?GU~@,Am_#(k)No`,0BIAjt,ub@=1ODRtlBJHNzij&M$A\";i:521;s:50:\"<o=hT?GU~@.Am_#(k)No`,2BIAjt,ub@=1SDRtlBJHNzij]M$A\";i:522;s:50:\"<o=hT?GU~@/Am_#(k)No`,4BIAjt,ub@=1WDRtlBJHNzijHN$A\";i:523;s:50:\"<o=hT?GU~@:Am_#(k)No`,6BIAjt,ub@=1aDRtlBJHNzijXN$A\";i:524;s:50:\"<o=hT?GU~@;Am_#(k)No`,8BIAjt,ub@=1eDRtlBJHNzijnN$A\";i:525;s:49:\"<o=hT?GU~@<Am_#(k)No`,!BIAjt,ub@=1iDRtlBJHNzoxvWA\";i:526;s:12:\"KV>hT?GU5A$A\";i:527;s:14:\"KV>hT?GU~@&ACA\";i:528;s:14:\"KV>hT?GU~@(ACA\";i:529;s:14:\"KV>hT?GU~@)ACA\";i:530;s:14:\"KV>hT?GU~@*ACA\";i:531;s:14:\"KV>hT?GU~@+ACA\";i:532;s:13:\"KV>hT?GU+JlBA\";i:533;s:14:\"KV>hT?GU}j.ACA\";i:534;s:14:\"KV>hT?GU}j/ACA\";i:535;s:14:\"KV>hT?GU}j:ACA\";i:536;s:14:\"KV>hT?GU}j;ACA\";i:537;s:14:\"KV>hT?GU}j<ACA\";i:538;s:13:\"KV>hT?GU%IlBA\";i:539;s:12:\"_X>hT?GU5A$A\";i:540;s:14:\"_X>hT?GU~@&ACA\";i:541;s:14:\"_X>hT?GU~@(ACA\";i:542;s:14:\"_X>hT?GU~@)ACA\";i:543;s:14:\"_X>hT?GU~@*ACA\";i:544;s:14:\"_X>hT?GU~@+ACA\";i:545;s:13:\"_X>hT?GU+JlBA\";i:546;s:14:\"_X>hT?GU}j.ACA\";i:547;s:14:\"_X>hT?GU}j/ACA\";i:548;s:14:\"_X>hT?GU}j:ACA\";i:549;s:14:\"_X>hT?GU}j;ACA\";i:550;s:14:\"_X>hT?GU}j<ACA\";i:551;s:13:\"_X>hT?GU%IlBA\";i:552;s:14:\"sP=hT?GU}j=ACA\";i:553;s:14:\"sP=hT?GU~@&ACA\";i:554;s:14:\"sP=hT?GU~@(ACA\";i:555;s:14:\"sP=hT?GU~@)ACA\";i:556;s:14:\"sP=hT?GU~@*ACA\";i:557;s:14:\"sP=hT?GU~@+ACA\";i:558;s:13:\"sP=hT?GU+JlBA\";i:559;s:14:\"sP=hT?GU}j.ACA\";i:560;s:14:\"sP=hT?GU}j/ACA\";i:561;s:14:\"sP=hT?GU}j:ACA\";i:562;s:14:\"sP=hT?GU}j;ACA\";i:563;s:14:\"sP=hT?GU}j<ACA\";i:564;s:13:\"sP=hT?GU%IlBA\";i:565;s:14:\"VE=hT?GU}jUBEA\";i:566;s:24:\"tP=hT?GU3GlBjL.4FxrjJABA\";i:567;s:23:\")a=hT?GUpA$A[CSOYMtOBtA\";i:568;s:45:\"HH=hT?GUpA$A=CSOYMLUIt5F_Q3nE3UAi\"nBJHNzG3xWA\";i:569;s:23:\")a=hT?GUpA$A[CSOYMtOBtA\";i:570;s:24:\")a=hT?GU~AlBzL.4FxrjBABA\";i:571;s:13:\"t8=hT?GUqNlBA\";i:572;s:115:\"Zj>hT?GU%IlB(L.4Fx~5AA+h=hT?GUpA$A|CSOYMtOBt#T_Q3nE3t`3ATq=hT?GU~@UBEA$(k)No`,pCJt+\",ub@MI5FAwLvSQ[zLA/hjt,ub@MI5FA\";i:573;s:104:\"pg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}Mi(6F7vLvSQ[zp~0WXLqI:$vb*|d\"dZ_Q3nE3BB$AADSOYMM%Bt&a_Q3nE3BB$A\";i:574;s:178:\"78=hT?KUTClB&!BA(a6Axt+BJHNzij*T$AzDSOYM*+#nlBgM.4Fx}MUAO/=hT?GUPOlBoM.4Fx}MUA,>=hT?GUYDlBwM.4Fxs@EAl_=hT?GUYDlB4M.4FxrjEAD\"_Q3nE3xB$AQDSOYM?ICt;v_Q3nE35B$ASDSOYMLUCt6y_Q3nE35B$A\";i:575;s:13:\"t8=hT?GUGJlBA\";i:576;s:14:\"EH?hT?GU~@{ACA\";i:577;s:14:\"EH?hT?GU}jWBEA\";i:578;s:14:\"EH?hT?GU~@^ACA\";i:579;s:14:\"EH?hT?GU~@WBEA\";i:580;s:14:\"EH?hT?GU~@KBEA\";i:581;s:13:\"t8=hT?GUGJlBA\";i:582;s:13:\"sP?hT?GUr6lBA\";i:583;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:584;s:13:\"t8=hT?GUr6lBA\";i:585;s:13:\"EH=hT?GU4DlBA\";i:586;s:46:\"f#=hT?GUeRlBYM.4Fx~5YAw(=hT?GUeRlBMM.4Fxs@CABA\";i:587;s:13:\"sP>hT?GUtElBA\";i:588;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:589;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:590;s:36:\"*a>hT?GU[IlBRN.4Fxs@AAvW=hT?GU}jXBEA\";i:591;s:12:\"sP=hT?GUpA$A\";i:592;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:593;s:64:\"wP>hT?IU~@@A]Q~@{A/h#(k)No9P:CLXzXJI|+CADt#(k)No9P:CbXzXJI|+CACA\";i:594;s:45:\"HH=hT?GUSVlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOItA\";i:595;s:24:\"Am>hT?GUITlB_M.4FxrjbABA\";i:596;s:47:\"HH=hT?GU~@EB/hht,ub@/B5F%tLvSQ[zCAc4ht,ub@0@5FA\";i:597;s:24:\"Am>hT?GUITlB_M.4FxrjbABA\";i:598;s:45:\"HH=hT?GUSVlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOItA\";i:599;s:111:\"qg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA6F=hT?GUOBlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:600;s:71:\"mg=hT?GU~QlB,L.4Fx}MYA1k=hT?GU~QlB?L.4Fx}M2,6F7vLvSQ[zcQ1WXLqI:$vbX%e\"A\";i:601;s:111:\"qg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA6F=hT?GUOBlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:602;s:71:\"mg=hT?GU~QlB,L.4Fx}MYA1k=hT?GU~QlB?L.4Fx}M2,6F7vLvSQ[zcQ1WXLqI:$vbX%e\"A\";i:603;s:34:\"v8=hT?GUGJlBjL.4Fxs@AAHO=hT?GU5A$A\";i:604;s:78:\"z8=hT?GUGJlBbL.4FxrjMApI=hT?GU5A$A?CSOYMLUBt#T_Q3nE3&G$A~CSOYM*+FtuW_Q3nE3&G$A\";i:605;s:25:\"u8>hT?GU}jVBz(nt,ub@uC5FA\";i:606;s:13:\"t8=hT?GUGJlBA\";i:607;s:24:\"Am>hT?GURIlBfL.4Fx~5AABA\";i:608;s:12:\"EH=hT?GUpA$A\";i:609;s:13:\"Qj>hT?GU%IlBA\";i:610;s:13:\"t8=hT?GUqNlBA\";i:611;s:50:\"1d>hT?GU~@LBFtmt,ub@=1vES\";\",ub@=1vES\"^\",ub@=1GFQA\";i:612;s:13:\"t8=hT?GUqNlBA\";i:613;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:614;s:13:\"bS=hT?GU4DlBA\";i:615;s:14:\"bS=hT?GU~@YBEA\";i:616;s:67:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3IE$A?CSOYMtOBt[9_Q3nE3gE$AfDSOYM*+FtA\";i:617;s:67:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3IE$A?CSOYMtOBt[9_Q3nE3gE$AfDSOYM*+FtA\";i:618;s:45:\"HH=hT?GUpA$A=CSOYM)ZIt5F_Q3nE3UAi\"nBJHNz@5xWA\";i:619;s:67:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3IE$A?CSOYMifBtv(_Q3nE3AE$AbDSOYM5qEtA\";i:620;s:67:\"JH=hT?GUpA$A=CSOYMifBt5F_Q3nE3IE$A?CSOYMtOBtv(_Q3nE3\"G$AbDSOYM5qEtA\";i:621;s:26:\"LV=hT?GU}jZBbLit,ub@=1KFQA\";i:622;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:623;s:46:\"eS=hT?GU~AlBzL.4Fx~5BAvW=hT?GUOBlB7L.4Fx~5BABA\";i:624;s:48:\"+a>hT?GU~@ZBFtmt,ub@>i5F#zLvSQ[zxAG\"#(k)No`,0CIA\";i:625;s:12:\"sP=hT?GUpA$A\";i:626;s:46:\"eS=hT?GU4DlBzL.4Fx}MFAvW=hT?GUtElB7L.4Fx}MFABA\";i:627;s:46:\"eS=hT?GU4DlBzL.4Fx~5BAvW=hT?GU~AlB7L.4Fx~5BABA\";i:628;s:17:\"sP>hT?IU<HlBqGJAB\";i:629;s:17:\"sP>hT?IU<HlBqGJAB\";i:630;s:20:\"sP>hT?IU~@aB/h`,2CQA\";i:631;s:20:\"sP>hT?IU~@aB/h`,2CQA\";i:632;s:66:\"OV?hT?GU~@bBG\"((k)NonR:C_czXJI|+YAOc%(k)Ro`,+B3(=1:DgA{\",ub@=14FQA\";i:633;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:634;s:13:\"t8=hT?GUGJlBA\";i:635;s:25:\"u8=hT?GU{JlBuO.4Fx}M_=6FA\";i:636;s:24:\"u8=hT?GUqNlB_M.4Fx~5AABA\";i:637;s:13:\"t8=hT?GUqNlBA\";i:638;s:37:\"T@>hT?GU4TlByO.4Fx}MTAeZ@hT?GUO[=JYLA\";i:639;s:12:\"Qj?hT?GUpA$A\";i:640;s:14:\"),>hT?GU~@cBEA\";i:641;s:14:\"\"l?hT?GU}jdBEA\";i:642;s:14:\"/o?hT?GU~@dBEA\";i:643;s:69:\"wP>hT?GUALlBfL.4?z}M(@6F=ZXA_Q#(k)No]AlBnL.4?z}M(@6F=Z8AQc#(k)No]AlBA\";i:644;s:26:\"S@>hT?GU~@eBz(pt,ub@=1iFQA\";i:645;s:14:\"sP>hT?GU~@fBEA\";i:646;s:48:\"vP>hT?GU}j:Aa4%(k)No]AlBFN.4Fx~5MANc?hT?GU}jcBEA\";i:647;s:14:\"\"l>hT?GU}jgBEA\";i:648;s:14:\"hg>hT?GU~@gBEA\";i:649;s:34:\"6r>hT?GUpA$AVDSOYMLUBtlB_Q3nE3gE$A\";i:650;s:14:\"4r?hT?GU}jhBEA\";i:651;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:652;s:100:\"uu?hT?GU~@hBz(lt,uj@/B5F>+NAo_%(k)No]AlBfL.4FxrjYB8A3(&\",ub@/B5F%tLvSQ[zGF&C$A?CSOYMtOBt[9_Q3nE3gE$A\";i:653;s:225:\"oCB*`\",ub@uC5Ft5LvSQ[zGF@AgA6BJHNzRm9(CA;C=hT?GU%IlBfL.4Fx~5AApI=hT?GUpA$A>CSOYM*+amlBrL.4Fx~5AA[Q=hT?GU~@RB:>ht,ub@=1,EQA)\",ub@=1,ERtpBJHNzijNT$ArDSOYMj<cADATq>hT?GUO[aSXL[dVE^2*NNKqClB&!7\"HA/h)(k)Noa.CtuWCaqI/TwbWUW\"&aX%VAB\";i:654;s:25:\"LV?hT?GU}jiBc4lt,ub@lt5FA\";i:655;s:70:\"gS?hT?GU}jYB:>pt,ub@=1GFS\"&\",ub@/B5FxtLvSQ[zCAFtht,ub@/B5F[tLvSQ[zCAEA\";i:656;s:14:\"4r?hT?GU~@iBEA\";i:657;s:13:\"Wx?hT?GUqNlBA\";i:658;s:26:\"G0?hT?GU}jjB/hrt,ub@=10FQA\";i:659;s:14:\"?2?hT?GU}jkBEA\";i:660;s:56:\"8r>hT?GUpA$A@CSOYMtOBt=J_Q3nE3UAgApBJHNzWHuWeGqI:$vbKAQA\";i:661;s:14:\"yd>hT?GU}jVBEA\";i:662;s:58:\"ru?hT?GU~@kBz(ht,ub@/B5FWuLvSQ[zCAG\"#(k)No]AlB7L.4Fx~5AABA\";i:663;s:12:\"bS>hT?GU5A$A\";i:664;s:27:\"G0?hT?GUO[AA5FH7LvSQ[z0.1WA\";i:665;s:13:\"F0?hT?GUqNlBA\";i:666;s:112:\"$r>hT?GUO[lBXL&\"LvSQ[zCA/hht,ub@jT5F%tLvSQ[zCAc4ht,ub@jT5FGuLvSQ[zGFQAi\"oBJHNzRm9(AAvW=hT?GUO[5FXLPDVElg*NNKwA$A\";i:667;s:56:\"8r>hT?GUpA$A@CSOYMtOBt=J_Q3nE3UAgApBJHNzWHuWeGqI:$vbKAQA\";i:668;s:49:\"7r?hT?GU5A$AbDSOYM?IEtGO_Q3nE30o3r5F7#LvSQ[zFF1WA\";i:669;s:14:\"\"l?hT?GU}jdBEA\";i:670;s:82:\")5?hT?GUO[DHXL>WVElg*NFAJt&\",ub@/B5FxtLvSQ[zCAFtht,ub@=1,ERtnBJHNzWHuW{eqI:$vbQCgA\";i:671;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:672;s:15:\"\"l?hT?GUO[oIXLA\";i:673;s:48:\"HH=hT?GUO[=JXLFBVElg*NFAK\"ht,ub@@85F[tLvSQ[zCAEA\";i:674;s:13:\"9M=hT?GUiFlBA\";i:675;s:46:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GU4DlBrL.4Fx~5AABA\";i:676;s:13:\"9M=hT?GUSFlBA\";i:677;s:46:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GU?OlBrL.4Fx~5AABA\";i:678;s:13:\"9M=hT?GU9ElBA\";i:679;s:46:\"HH=hT?GU9ElBjL.4Fx~5AAYL=hT?GU?OlBrL.4Fx~5AABA\";i:680;s:13:\"9M=hT?GU^SlBA\";i:681;s:46:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GU^SlBrL.4Fx~5AABA\";i:682;s:15:\"9M=hT?GUO[=JXLA\";i:683;s:15:\"Wx?hT?GUO[XLXLA\";i:684;s:48:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE30oeG5F[tLvSQ[zCAEA\";i:685;s:14:\"/o?hT?GU~@dBEA\";i:686;s:117:\"1P>hT?IU<HlBqGJA!5_Q3nE3oE$A<CSOYMtOBtUE_Q3nE3UAgAnBJHNz4BwWvDqI:$vbKAS\"(\",ub@=1=CRtoBJHNzWHuW5FqI:$vbpDi\"pBJHNz!PuWA\";i:687;s:86:\"yP>hT?IU4DlBrz=)5FhdzXJI{ZMuaLjHVElg*NMBS\"(\",ub@cY5FWuLvSQ[zCAG\"#(k)No#J:CbXzXJI{ZjACA\";i:688;s:46:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3so2AHO=hT?GUpA$A\";i:689;s:31:\"LV?hT?GUO[^XXLBNVE^2*NCBRtnGvWA\";i:690;s:48:\"eS=hT?GU~@QB:>ht,ub@5x5FmuLvSQ[z{&0WeGqI:$vbJDgA\";i:691;s:29:\"@2?hT?GUO[dZXLEUVElg*NNKfDlBA\";i:692;s:38:\";o?hT?GU~@dB/hqt,ub@=15FD3LvSQ[zGF*B$A\";i:693;s:15:\"sP>hT?GUO[xdXLA\";i:694;s:45:\"vP=hT?GU5A$A=CSOYMLUBt8M_Q3nE3LD$A[CSOYMLUDtA\";i:695;s:45:\"vP=hT?GU5A$A=CSOYMLUBt8M_Q3nE3LD$A[CSOYMLUDtA\";i:696;s:77:\"y8=hT?KUTClB&!BA(a6AxtxBJHNz5uwWaSqI:$vbxDi\"yBJHNz5uwWvDqI:$vb`Di\"mBJHNz{,wWA\";i:697;s:23:\"tP=hT?GUpA$A=CSOYMtOBtA\";i:698;s:23:\"LV=hT?GUpA$A^CSOYMtOBtA\";i:699;s:47:\"+a>hT?GU[IlB#L.4Fx}M)96F2uLvSQ[zjA:>ht,ub@BZ5FA\";i:700;s:50:\"<o=hT?GU}j&Am_#(k)No`,pBIAjt,ub@=1^CRtlBJHNzij*L$A\";i:701;s:50:\"<o=hT?GU}j(Am_#(k)No`,rBIAjt,ub@=1|CRtlBJHNzij`L$A\";i:702;s:50:\"<o=hT?GU}j)Am_#(k)No`,tBIAjt,ub@=1ADRtlBJHNzijKM$A\";i:703;s:50:\"<o=hT?GU}j*Am_#(k)No`,vBIAjt,ub@=1EDRtlBJHNzijaM$A\";i:704;s:50:\"<o=hT?GU}j+Am_#(k)No`,xBIAjt,ub@=1IDRtlBJHNzijqM$A\";i:705;s:49:\"<o=hT?GU}j,Am_#(k)No`,zBIAjt,ub@=1MDRtlBJHNzd&vWA\";i:706;s:50:\"<o=hT?GU~@,Am_#(k)No`,0BIAjt,ub@=1ODRtlBJHNzij&M$A\";i:707;s:50:\"<o=hT?GU~@.Am_#(k)No`,2BIAjt,ub@=1SDRtlBJHNzij]M$A\";i:708;s:50:\"<o=hT?GU~@/Am_#(k)No`,4BIAjt,ub@=1WDRtlBJHNzijHN$A\";i:709;s:50:\"<o=hT?GU~@:Am_#(k)No`,6BIAjt,ub@=1aDRtlBJHNzijXN$A\";i:710;s:50:\"<o=hT?GU~@;Am_#(k)No`,8BIAjt,ub@=1eDRtlBJHNzijnN$A\";i:711;s:49:\"<o=hT?GU~@<Am_#(k)No`,!BIAjt,ub@=1iDRtlBJHNzoxvWA\";i:712;s:12:\"KV>hT?GU5A$A\";i:713;s:14:\"KV>hT?GU~@&ACA\";i:714;s:14:\"KV>hT?GU~@(ACA\";i:715;s:14:\"KV>hT?GU~@)ACA\";i:716;s:14:\"KV>hT?GU~@*ACA\";i:717;s:14:\"KV>hT?GU~@+ACA\";i:718;s:13:\"KV>hT?GU+JlBA\";i:719;s:14:\"KV>hT?GU}j.ACA\";i:720;s:14:\"KV>hT?GU}j/ACA\";i:721;s:14:\"KV>hT?GU}j:ACA\";i:722;s:14:\"KV>hT?GU}j;ACA\";i:723;s:14:\"KV>hT?GU}j<ACA\";i:724;s:13:\"KV>hT?GU%IlBA\";i:725;s:12:\"_X>hT?GU5A$A\";i:726;s:14:\"_X>hT?GU~@&ACA\";i:727;s:14:\"_X>hT?GU~@(ACA\";i:728;s:14:\"_X>hT?GU~@)ACA\";i:729;s:14:\"_X>hT?GU~@*ACA\";i:730;s:14:\"_X>hT?GU~@+ACA\";i:731;s:13:\"_X>hT?GU+JlBA\";i:732;s:14:\"_X>hT?GU}j.ACA\";i:733;s:14:\"_X>hT?GU}j/ACA\";i:734;s:14:\"_X>hT?GU}j:ACA\";i:735;s:14:\"_X>hT?GU}j;ACA\";i:736;s:14:\"_X>hT?GU}j<ACA\";i:737;s:13:\"_X>hT?GU%IlBA\";i:738;s:14:\"sP=hT?GU}j=ACA\";i:739;s:14:\"sP=hT?GU~@&ACA\";i:740;s:14:\"sP=hT?GU~@(ACA\";i:741;s:14:\"sP=hT?GU~@)ACA\";i:742;s:14:\"sP=hT?GU~@*ACA\";i:743;s:14:\"sP=hT?GU~@+ACA\";i:744;s:13:\"sP=hT?GU+JlBA\";i:745;s:14:\"sP=hT?GU}j.ACA\";i:746;s:14:\"sP=hT?GU}j/ACA\";i:747;s:14:\"sP=hT?GU}j:ACA\";i:748;s:14:\"sP=hT?GU}j;ACA\";i:749;s:14:\"sP=hT?GU}j<ACA\";i:750;s:13:\"sP=hT?GU%IlBA\";i:751;s:38:\"jg=hT?GU~@%Ax(#(k)No`,oB2W*\",ub@=1[CQA\";i:752;s:35:\"jg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlBA\";i:753;s:35:\"GH>hT?GUYDlB.M.4Fxs@EAYL>hT?GUYDlBA\";i:754;s:35:\"GH>hT?GUDClB.M.4Fxs@CAYL>hT?GUDClBA\";i:755;s:35:\"GH>hT?GU>BlB.M.4FxrjCAYL>hT?GU>BlBA\";i:756;s:35:\"H0=hT?GUYDlBAM.4Fxs@EAq1=hT?GUYDlBA\";i:757;s:35:\"H0=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBA\";i:758;s:35:\"H0=hT?GU>BlBAM.4FxrjCAq1=hT?GU>BlBA\";i:759;s:13:\"L&?hT?GUqNlBA\";i:760;s:15:\"z:>hT?GUO[{eXLA\";i:761;s:61:\"fS=hT?GU:NlBzL.4Fx~5AAvW=hT?GU:NlB7L.4FxrjBAHO>hT?IU<HlBqGJAB\";i:762;s:74:\"xP>hT?IU<HlBqGJApI_Q3nE3UAi\"oBJHNzWHuW5FqI:$vbKARtpBJHNzRm9(FAYL=hT?GUpA$A\";i:763;s:46:\"eS=hT?GU1MlBzL.4Fx~5AAvW=hT?GU=ElB7L.4Fx~5RABA\";i:764;s:32:\"Am>hT?GU~@QBc4lt,uj@tV5F>+wCZB$A\";i:765;s:46:\"eS=hT?GU:NlBzL.4Fx~5AAvW=hT?GU:NlB7L.4FxrjBABA\";i:766;s:46:\"HH=hT?GU9ElBjL.4Fx~5AAYL=hT?GUCFlBrL.4Fx~5AABA\";i:767;s:56:\"IH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuW<cqI:$vbUCgA\";i:768;s:13:\"EH=hT?GUgLlBA\";i:769;s:81:\"5:>hT?GUoTlBRN.4Fx~5LA[Q>hT?GU=ElBjL.4Fx}MHAeZ>hT?GU[IlBQM.4Fx}MOA2[>hT?GUO[*hXLA\";i:770;s:157:\"48=hT?GU{JlB6O.4Fx}MH)6F&6LvSQ[zWC1W`xqI:$vbaU.I:C*ZzXgT{Z02aL#zsA=hvZoIWezXJI|+BA8y)(k)Noa.O/uWb#qI:$vbaUtJ:C3bzXJI|+wCVBi\"5BJHNzLYxW7fqI:$vb%DgA5BJHNzWHuWA\";i:771;s:13:\"EH=hT?GU9ElBA\";i:772;s:12:\"EH=hT?GUpA$A\";i:773;s:79:\"y8=hT?KUTClB&!BA(a6AwA/\",ub@h55FKyLvSQ[z]Az(kt,ub@h55FGuLvSQ[z)YzW5FqI:$vb\"IX\"A\";i:774;s:84:\"KH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3so2AHO=hT?GUpA$A^CSOYMtOBt~l`Q3nE30ouW5FR9LvSQ[zGF]C$A\";i:775;s:68:\"n=?hT?GUqNlB7L.4Fx~5AA6F=hT?GUpA$A=CSOYMtOBt5F_Q3nE3so2AHO=hT?GUpA$A\";i:776;s:36:\"#M=hT?GUpA$A?CSOYM*+amlBfL.4Fx~5BABA\";i:777;s:14:\"\"l?hT?GU}jdBEA\";i:778;s:49:\"HH=hT?GUpA$A=CSOYM*+amlBnL.4Fx}MO#6F[tLvSQ[z0.0WA\";i:779;s:100:\"jS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWlBqI:$vbKARtmBJHNzWHuW:CqI:$vbKARtnBJHNzWHuWA$qI:$vbhDgA\";i:780;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:781;s:71:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3so2AHO=hT?GUpA$A;CSOYM?IEtK&_Q3nE30o4Y5FA\";i:782;s:72:\"gS=hT?GU/A$A[CSOYM)ZBtXL_Q3nE3kAi\"pBJHNz?MuWE0qI:$vbaU|L:C6azXJI|+wCxBgA\";i:783;s:29:\"zd?hT?GUO[6yXLEUVElg*NNKOGlBA\";i:784;s:15:\"/o>hT?GUO[VxXLA\";i:785;s:99:\":a>hT?GU[IlBVN.4Fxs@NAvW>hT?GU+JlBRN.4Fxs@BA[Q>hT?GUeBlBfL.4Fxs@cAHO=hT?GUdUlB`N.4?zrjYB<A#(y2PcDtA\";i:786;s:92:\":a>hT?GUkPlBlN.4FxrjdA1k>hT?GUpA$AXDSOYMtOBtxd_Q3nE3wE$AbDSOYM?IEtp1_Q3nE3gE$ArDSOYMj<dtTACA\";i:787;s:59:\",a>hT?GU[IlBhN.4Fxs@TA+h>hT?GU+JlB_M.4Fxs@NA2[>hT?GUO[Y4XLA\";i:788;s:123:\"<a>hT?GUjSlBVN.4Fx~5AAvW>hT?GUpA$AbDSOYM?IEtp1_Q3nE3gE$ApDSOYMj<e\"FA2[?hT?GUO[95XLFhVElg*NNKjHlBnP.4FxrjYB_AK\"ot,ub@y2_9DtA\";i:789;s:22:\"A^>hT?IUO[b#uW#zGF?D$A\";i:790;s:29:\"nB@hT?GUO[$$XLKiVElg*NNKIIlBA\";i:791;s:22:\"A^>hT?IUO[v(uW#zGFME$A\";i:792;s:29:\"nB@hT?GUO[_)XLKiVElg*NNK4IlBA\";i:793;s:22:\"A^>hT?IUO[(,uW#zGFkE$A\";i:794;s:29:\"nB@hT?GUO[N/XLKiVElg*NNKNJlBA\";i:795;s:124:\"38=hT?GUqNlByO.4Fx}MTAeZ>hT?GUkPlBNN.4Fx}MFA$T>hT?GUCVlB&O.4Fx}M|_6F)0LvSQ[zrAz(lt,ub@6e5F51LvSQ[zaBJt\"\",ub@6e5FwwLvSQ[zLAEA\";i:796;s:273:\"oCp*^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0LvSQ[zvAbLrt,ub@=15Fm!LvSQ[zWC1Ws8qI:$vb\"Ie\"xd`Q3nE3pB$A^DSOYMj<e\"NAf+?hT?GUO[0kXL{eVElg*NNK9JlBTP.4FxrjYB2A2W~AyD1+ITJ\"Etp1`Q3nE30ojn5F)0LvSQ[zxAyWht,ub@=1$DRtmBJHNzWHuW:CqI:$vbKARtnBJHNzWHuWCaqI:$vb)qY\"1[_Q3nE30oIo5FA\";i:797;s:13:\"Qj?hT?GUqNlBA\";i:798;s:163:\"#d>hT?GUhIlBQM.4Fx}MOA;C=hT?GU%IlBvL.4Fx}MLA$T=hT?GU~AlB3L.4Fx}MLAeZ=hT?GU~AlB]O.4Fx}Mr}6FwwLvSQ[zLAyWqt,ub@y2aLDtxd`Q3nE3~R4A$T@hT?GUO[1[XLqiVElg*N|AIAut,ub@=15FA\";i:799;s:174:\"vg?hT?GUqNlBJN.4Fxs@LAI7=hT?GU{JlBbL.4FxrjMA[Q=hT?GU<HlBzL.4FxrjBAvW=hT?GU<HlB7L.4FxrjBAq1?hT?GU~@jBFtjt,ub@MI5FC6LvSQ[zGF\"C$A)DSOYM*+vnlB,P.4FxrjYBZBS\"\"\",ub@6e5Fb#LvSQ[z<AEA\";i:800;s:13:\"hg?hT?GUqNlBA\";i:801;s:26:\"Rj?hT?GUqNlB;P.4FxrjYBbBQA\";i:802;s:13:\"Qj>hT?GU%IlBA\";i:803;s:13:\"t8?hT?GU^ClBA\";i:804;s:88:\"yP>hT?IU~@@A]Q~@{A/h#(k)NoiQ:CLXzXJI{ZKADt#(k)NoiQ:CbXzXJI{ZKAm_%(k)No_a:C(fzXJI|+wC6CgA\";i:805;s:26:\"Rj?hT?GUqNlB?P.4FxrjYBfBQA\";i:806;s:13:\"Qj?hT?GUqNlBA\";i:807;s:13:\"4r>hT?GUqNlBA\";i:808;s:13:\"i=>hT?GUhIlBA\";i:809;s:13:\"i=>hT?GUhIlBA\";i:810;s:89:\"LH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWUEqI:$vbKARtoBJHNzWHuW5FqI:$vbKARtpBJHNzWHuWA\";i:811;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:812;s:50:\"w8=hT?GUGJlB|P.4FxrjYBjBQA=\",ub@>i5FT3LvSQ[zGF`B$A\";i:813;s:60:\"ru>hT?GU\"NlB+O.4Fx}M@~6F)0LvSQ[zGF5F$AVDSOYM@1Ct=J_Q3nE3OC$A\";i:814;s:96:\"Xj>hT?GUO[T|XLhNVElg*NLAJt(\",ub@=1$DRtoBJHNzij<O$A]CSOYM*+`llB7L.4Fx~5AATq>hT?GUqNlBaO.4Fx}MTABA\";i:815;s:13:\"_X@hT?GUqNlBA\";i:816;s:116:\"wu>hT?GU\"NlBRN.4FxrjGA$T=hT?GUpA$A^CSOYMtOBtoI_Q3nE3IE$A]CSOYMB]DtDH_Q3nE30o%t5FZ1LvSQ[z<AyWtt,ub@>i5Fr#LvSQ[zGF/F$A\";i:817;s:78:\"yP=hT?GUpA$AbDSOYMifBtoI_Q3nE3kAi\"oBJHNzWHuW5FqI:$vbSARtpBJHNzWHuWSqqI:$vb]EgA\";i:818;s:95:\"5d>hT?GU4DlBQM.4Fxs@MA[Q>hT?GU4DlBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAi\"3BJHtzS^uWhNB.M\"A\";i:819;s:23:\"sP>hT?IUO[UEYL#zGF~FlBA\";i:820;s:13:\"sP?hT?GUqNlBA\";i:821;s:13:\"_X@hT?GUqNlBA\";i:822;s:45:\"HH=hT?GUgLlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:823;s:45:\"HH=hT?GUgLlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:824;s:26:\"Rj>hT?GU%IlBuO.4FxrjYB)AIA\";i:825;s:15:\"R@>hT?GUO[>2XLA\";i:826;s:46:\"HH=hT?GUgLlBjL.4Fx~5AAYL=hT?GUgLlBrL.4Fx~5AABA\";i:827;s:13:\"_X=hT?GUALlBA\";i:828;s:26:\"5r>hT?GUqNlB?P.4FxrjYBvBQA\";i:829;s:20:\"sP>hT?IU9ElB&!5AjAEA\";i:830;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:831;s:26:\"5r>hT?GUqNlB?P.4FxrjYBpBQA\";i:832;s:15:\"Qj?hT?GUO[XLYLA\";i:833;s:26:\"ig?hT?GUqNlB?P.4FxrjYBvBQA\";i:834;s:14:\"bS?hT?GU}jYBEA\";i:835;s:13:\"_X=hT?GU9ElBA\";i:836;s:13:\"!5=hT?GUDClBA\";i:837;s:50:\"HH=hT?GU}jGB/hht,ub@=1ZEQA(\",ub@=1ZERtnBJHNzijLR$A\";i:838;s:13:\"hg?hT?GUqNlBA\";i:839;s:13:\"Qj?hT?GUqNlBA\";i:840;s:15:\"hg?hT?GUO[8MYLA\";i:841;s:37:\"v8=hT?GUGJlB|P.4FxrjYBjBQA=\",ub@>i5FA\";i:842;s:78:\"z8=hT?GUqNlBfL.4Fx~5AApI=hT?GUpA$A>CSOYMtOBtDH_Q3nE3UAi\"pBJHNzWHuWA$qI:$vbhDgA\";i:843;s:34:\"*a>hT?GU[IlBMM.4Fxs@TA6F=hT?GUpA$A\";i:844;s:79:\"/a>hT?GU[IlBQM.4Fxs@MA|e?hT?GUqNlBvL.4Fx~5BA$T=hT?GUOBlB3L.4Fx~5BAeZ=hT?GUOBlBA\";i:845;s:13:\"Qj?hT?GUqNlBA\";i:846;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:848;s:38:\"v8=hT?GU{JlB+O.4Fx}M@~6FZ1LvSQ[zGFuG$A\";i:849;s:42:\"XE=hT?GUO[rPYLpVVElg*NNKhNlBfL.4FxrjYB#BQA\";i:850;s:13:\"),>hT?GUqNlBA\";i:852;s:13:\"t8=hT?GUqNlBA\";i:853;s:82:\"/a>hT?GUjSlBQM.4Fx}MTA1k>hT?GUpA$AVDSOYM*+=dlBRN.4Fx~5fA$T>hT?GUpA$AgDSOYMj<e\"TABA\";i:854;s:137:\"=a>hT?GUjSlBVN.4Fxs@NAvW>hT?GU+JlBfL.4FxrjYB(BRt(BJHNzRmOAM\"1[_Q3nE30o}45Fd5LvSQ[zGFnD$A2DSOYMj<e\"UAHO>hT?GUiFlBJN.4Fxs@LAeZ@hT?GUO[&aYLA\";i:855;s:15:\"A^>hT?GUO[McYLA\";i:856;s:23:\"`X>hT?GU5A$AWDSOYMtOBtA\";i:857;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:858;s:26:\"`X>hT?GUO[aSYL%NVElg*NIBQA\";i:861;s:13:\"t8=hT?GUqNlBA\";i:862;s:13:\"t8=hT?GUGJlBA\";i:863;s:155:\">a>hT?GUjSlBVN.4Fx}MQA$T>hT?GUgLlB]O.4Fx}Mr}6F$wLvSQ[z4Ac4qt,ub@=1`ES\"`\",ub@=1`ERt.BJHNzRm8WGAHO>hT?KU}jYB/h9P5F_MSAy(?hT?GU5A$A.DSOYMj<e\"GAO/?hT?GUO[~lXLA\";i:864;s:43:\"uP>hT?IUaNlBrzm/5F5dzXJI{ZmAa4%(k)Noa.I7wWA\";i:865;s:129:\"1P>hT?IU~@@A]Q~@{Ac4%(k)No`,jCJt(\",ub@y2.hGt=J_Q3nE3UAgApBJHNzRmPtVAeZ=hT?GUpA$AeDSOYM*+Ft^X`Q3nE30o5F5FN5LvSQ[z<AbLut,ub@y2mnGtA\";i:866;s:15:\"z:>hT?GUO[*hYLA\";i:867;s:26:\"zd?hT?GUO[;vXLBNVElg*N7AIA\";i:868;s:65:\"3:>hT?GUO[PjYL}YVElg*NNKdJlB6O.4FxrjYB~BS\"`\",ub@=1`ERtmBJHNzWHuWA\";i:869;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:870;s:154:\"58=hT?KUTClB&!BA(a6Ay\"&\",ub@/B5FxtLvSQ[zCAFtht,ub@/B5F[tLvSQ[zCAbLit,ub@/B5FB9LvSQ[z<AbLkt,ub@845F1xLvSQ[z@A/hkt,ub@845F`xLvSQ[zLAc4kt,ub@MI5FayLvSQ[zLAEA\";i:871;s:110:\"18=hT?KUTClB&!BA(a6Ay\"(\",ub@/B5FWuLvSQ[zEAG\"#(k)No]AlB7L.4Fx}MBA6F>hT?GUYDlB.M.4Fxs@EAYL>hT?GUYDlBFN.4Fx~5MABA\";i:872;s:104:\"18=hT?GUqNlB_M.4Fxs@SA+h>hT?GU~@QByWot,ub@*=5Fz3LvSQ[zGFAI$A<CSOYM)ZBtUE_Q3nE30AgAnBJHNzWHuWvDqI:$vbKAQA\";i:873;s:13:\"hg?hT?GUqNlBA\";i:874;s:71:\"9r?hT?GU}jhBz(ht,ub@/B5FWuLvSQ[zCAG\"#(k)Noa.,>wWeGqI:$vbKAS\"&\",ub@ZR5FA\";i:875;s:30:\"tP>hT?IU4DlBrz=)5F>WzXJI{ZDACA\";i:876;s:29:\"zd>hT?GUO[.oYL_kVElg*NNKMMlBA\";i:877;s:69:\"9r?hT?GU}jhBc4jt,ub@Yk5FhtLvSQ[z$A/hht,ub@/B5F%tLvSQ[z$Ac4ht,ub@/B5FA\";i:878;s:84:\"/a>hT?GU[IlBvL.4FxrjYBGCRtoBJHNzApvW5FqI:$vbaUFh:CbXzXJI{ZXAOc$(k)NoMS:CiazXJI|+YACA\";i:879;s:316:\"oC$Y\"AyD1+ITf4K\"1[_Q3nE30orP5FU0LvSQ[zNB2W=\",ub@Hn5FhtLvSQ[zGFgI$AbDSOYM*+3flB_M.4Fx}Mnk6FwwLvSQ[zLAyWtt,ub@im5Ft5LvSQ[zGF8E$A8DSOYM*+vnlB!O.4Fx}MH)6F$wLvSQ[z4AyWmt,uj@ph5F>+SA9F)(k)No_a:CTfzXJI{ZMuaLWeVElg*NtEPtxd`Q3nE3pB$A^DSOYMj<e\"NAf+?hT?GUO[0kXL{eVElg*NNK9JlBTP.4FxrjYB2A2W~AyD1+ITJ\"Etp1`Q3nE30ojn5FvzLvSQ[zQBIA\";i:880;s:13:\"!5=hT?GU\"NlBA\";i:881;s:13:\"(a=hT?GUeBlBA\";i:882;s:26:\"0:>hT?GUO[BtYLGOVElg*NFAIA\";i:883;s:13:\"!5=hT?GUBIlBA\";i:884;s:13:\"KV=hT?GUeBlBA\";i:885;s:26:\"0:>hT?GUO[muYL%NVElg*NFAIA\";i:886;s:46:\"HH=hT?GUALlBjL.4Fx~5AAYL=hT?GUALlBrL.4Fx~5AABA\";i:887;s:12:\"EH=hT?GUpA$A\";i:888;s:144:\"58=hT?GU{JlB%N.4FxrjBA[Q>hT?GU5A$AZDSOYMM%Ht:C_Q3nE3UAi\"mBJHNzWHuW:CqI:$vbSARtnBJHNzWHuWGOqI:$vbuARt:BJHNzijwWFhqI:$vbhDgA{BJHNzoxvWCaqI:$vb]AQA\";i:889;s:13:\"Qj?hT?GUqNlBA\";i:890;s:35:\"|)>hT?GUALlBdN.4Fx}MTA,>>hT?GU4TlBA\";i:891;s:56:\"8r>hT?GUqNlB%N.4Fxs@aA[Q>hT?GU^SlBJN.4Fxs@aApI=hT?GU/A$A\";i:892;s:26:\"zd?hT?GUO[;vYLBNVElg*N~AQA\";i:893;s:23:\"?J=hT?GUpA$A?CSOYM)ZBtA\";i:894;s:59:\"lg@hT?GUO[4}XL&\"LvSQ[zCA/hht,ub@/B5F%tLvSQ[z$Ac4ht,ub@/B5FA\";i:895;s:12:\">J=hT?GU/A$A\";i:896;s:122:\"8d>hT?GU^SlBQM.4Fx}MOAw(>hT?GU^SlB_M.4Fxs@aA6F=hT?GUpA$A=CSOYM)ZBt5F_Q3nE3kAi\"nBJHNzWHuW_)qI:$vbkCgAvBJHNzzguWFhqI:$vbhDgA\";i:897;s:13:\"hg?hT?GUqNlBA\";i:898;s:75:\".a>hT?GU[IlBfL.4FxrjYBQCRtmBJHNzWHuW:CqI:$vbaUPj:C{WzXJI{ZBA7F)(k)Noa.vWuWA\";i:899;s:48:\"qu>hT?GU\"NlBjL.4Fx~5PA$T=hT?GUALlBAQ.4FxrjYBUCQA\";i:900;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:901;s:13:\"nu>hT?GU\"NlBA\";i:902;s:26:\"ou>hT?GU\"NlBjL.4FxrjYB[BQA\";i:903;s:56:\"ru>hT?GU\"NlBfL.4Fx~5AApI=hT?GUpA$A>CSOYMtOBtDH_Q3nE3UAgA\";i:904;s:13:\"nu>hT?GU\"NlBA\";i:905;s:50:\"HH=hT?GUpA$A=CSOYMj<e\"VAYL=hT?GUpA$A?CSOYMj<e\"VABA\";i:906;s:13:\"hg?hT?GUqNlBA\";i:907;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:908;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:909;s:13:\"t8=hT?GUqNlBA\";i:910;s:35:\"v8=hT?GUGJlByO.4Fx}MTAZ4=hT?GUDClBA\";i:911;s:13:\"hg?hT?GUqNlBA\";i:912;s:13:\"Qj?hT?GUqNlBA\";i:913;s:15:\"z:>hT?GUO[p1YLA\";i:914;s:15:\"z:>hT?GUO[>2YLA\";i:915;s:15:\"z:>hT?GUO[Y4YLA\";i:916;s:15:\"z:>hT?GUO[95YLA\";i:917;s:15:\"z:>hT?GUO[H7YLA\";i:918;s:15:\"z:>hT?GUO[s8YLA\";i:919;s:15:\"z:>hT?GUO[[9YLA\";i:920;s:15:\"z:>hT?GUO[b#YLA\";i:921;s:15:\"z:>hT?GUO[$$YLA\";i:922;s:15:\"z:>hT?GUO[K&YLA\";i:923;s:15:\"z:>hT?GUO[v(YLA\";i:924;s:15:\"z:>hT?GUO[_)YLA\";i:925;s:15:\"z:>hT?GUO[e+YLA\";i:926;s:15:\"z:>hT?GUO[(,YLA\";i:927;s:15:\"z:>hT?GUO[N/YLA\";i:928;s:15:\"z:>hT?GUO[y:YLA\";i:929;s:15:\"z:>hT?GUO[|;YLA\";i:930;s:15:\"z:>hT?GUO[h=YLA\";i:931;s:15:\"z:>hT?GUO[+>YLA\";i:932;s:15:\"z:>hT?GUO[Q@YLA\";i:933;s:15:\"z:>hT?GUO[1[YLA\";i:934;s:15:\"z:>hT?GUO[\"]YLA\";i:935;s:15:\"z:>hT?GUO[k_YLA\";i:936;s:15:\"z:>hT?GUO[/`YLA\";i:937;s:15:\"z:>hT?GUO[T|YLA\";i:938;s:15:\"z:>hT?GUO[4}YLA\";i:939;s:15:\"z:>hT?GUO[AA6FA\";i:940;s:15:\"z:>hT?GUO[lBZLA\";i:941;s:15:\"z:>hT?GUO[:CZLA\";i:942;s:15:\"z:>hT?GUO[UEZLA\";i:943;s:15:\"z:>hT?GUO[5FZLA\";i:944;s:15:\"z:>hT?GUO[DHZLA\";i:945;s:15:\"z:>hT?GUO[oIZLA\";i:946;s:15:\"z:>hT?GUO[=JZLA\";i:947;s:15:\"z:>hT?GUO[XLZLA\";i:948;s:15:\"z:>hT?GUO[8MZLA\";i:949;s:15:\"z:>hT?GUO[GOZLA\";i:950;s:15:\"z:>hT?GUO[rPZLA\";i:951;s:15:\"z:>hT?GUO[@QZLA\";i:952;s:15:\"z:>hT?GUO[aSZLA\";i:953;s:15:\"z:>hT?GUO[#TZLA\";i:954;s:15:\"z:>hT?GUO[JVZLA\";i:955;s:15:\"z:>hT?GUO[uWZLA\";i:956;s:15:\"z:>hT?GUO[^XZLA\";i:957;s:15:\"z:>hT?GUO[dZZLA\";i:958;s:15:\"z:>hT?GUO[&aZLA\";i:959;s:15:\"z:>hT?GUO[McZLA\";i:960;s:15:\"(a@hT?GUO[DHYLA\";i:961;s:13:\"t8=hT?GUqNlBA\";i:962;s:13:\"i=>hT?GUhIlBA\";i:963;s:13:\"i=>hT?GUhIlBA\";i:964;s:159:\"48=hT?IU{JlBUoGAbS`Q3nE3~R4Akn?hT?GU}jVB:>pt,ub@y2PcKtE0_Q3nG3\"!5Aq1sA&\"Dy*h{eVElg*NHA2W}\",ub@y2b4Ct0k`Q3nE30o\"S5FhtLvSQ[zDA/hht,ub@uC5F%tLvSQ[zDAc4ht,ub@uC5FA\";i:965;s:13:\"t8=hT?GUqNlBA\";i:966;s:193:\"78=hT?IU{JlBUoGAbS`Q3nE3~R4Akn?hT?GU}jVB:>pt,ub@y29yCtE0_Q3nG3\"!5Aq12ClB)+ieUELP.4Fxs@AAf+?hT?GUO[0kXL7fVElg*NNK)ElBfL.4Fxs@AApI=hT?GU5A$A>CSOYMLUBtDH_Q3nE3cAgA7BJHNz!PuW&aqI:$vbWAS\"<\",ub@^D5FA\";i:967;s:13:\"t8=hT?GUqNlBA\";i:968;s:62:\"Dm@hT?GUO[{eZLmOVElg*N_HS\";\",ub@=1(EQA=\",ub@=1(ERt<BJHNzij?V$A\";i:969;s:233:\"oC9B[\",ub@y2mnKt;v`Q3nE3SG$A|DSOYMj<cAmA1k@hT?GU6tlBeO.4FxrjYBhDRtvBJHNzG3vWCaqI/TwbdDi\"!RQJ&\";BJHNzijPV$AVDSOYMLUBtY4_Q3nE3kAgA6BJHNzij*T$A@CSOYMB]Dt=J_Q3nE3~RwAvW=hT?GUaNlB7L.4Fx}M0t6FS6LvSQ[z<Ac4mt,ub@TD5F)0LvSQ[zDAbLnt,ub@y2b4KtA\";i:970;s:12:\"Qj?hT?GUpA$A\";i:971;s:60:\"ru>hT?GU\"NlBfL.4Fx}MVApI=hT?GUO[~lZLlBVElg*NM3LtDH_Q3nE3UAgA\";i:972;s:60:\"ru>hT?GUBIlBfL.4Fx}MVApI=hT?GUpA$A>CSOYM*+=dlBrL.4FxrjYBlDQA\";i:973;s:70:\"mg@hT?GUO[4}XLjHVElg*NMBRtnBJHNzFKuWKCqI:$vbOAQA(\",ub@PP5FhtLvSQ[zlAEA\";i:974;s:13:\"EH=hT?GUOBlBA\";i:975;s:37:\"1:>hT?GUoTlBQM.4FxrjYBnDS\"AByD1+OhYLA\";i:976;s:15:\"hg@hT?GUO[4}XLA\";i:977;s:13:\"t8=hT?GUqNlBA\";i:978;s:24:\")a>hT?GU[IlBnL.4Fx}MQABA\";i:979;s:15:\"9M=hT?GUO[.oZLA\";i:980;s:100:\"MH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWUEqI:$vbKARtoBJHNzWHuW5FqI:$vb]ARtpBJHNzWHuWA$qI:$vbhDgA\";i:981;s:34:\"uP=hT?GUpA$A^CSOYMAlBt~l`Q3nE3&G$A\";i:982;s:23:\"cS=hT?GU/A$A]CSOYM)ZGtA\";i:983;s:15:\"c#?hT?GUO[uWXLA\";i:984;s:46:\"eS=hT?GU4DlBzL.4Fx}MFAvW=hT?GU4DlB7L.4Fx}MFABA\";i:985;s:24:\")a>hT?GU[IlBzL.4Fx}MLABA\";i:986;s:89:\"uu>hT?GUqNlBRN.4FxrjJA6F=hT?GUpA$A=CSOYMtOBt5F_Q3nE30Ai\"nBJHNzWHuW_)qI:$vboCi\"vBJHNzG3vWA\";i:987;s:25:\"?J=hT?GUOBlB6O.4Fx}MH)6FA\";i:988;s:62:\",a>hT?GUjSlBlN.4FxrjYBrDRt7BJHNzWHuWnbqI:$vbKARt~BJHNzRm9(nABA\";i:989;s:13:\"sP>hT?GUiFlBA\";i:990;s:14:\"sP>hT?GU}jYBEA\";i:991;s:13:\"t8=hT?GU{JlBA\";i:992;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:993;s:111:\"8:>hT?GUoTlBRN.4Fx~5RA[Q>hT?GUlMlBzP.4Fx}MHA6F=hT?GUpA$A=CSOYM)ZBt5F_Q3nE3SG$A?CSOYM*+Ct95_Q3nE3oE$AEDSOYMXwEtA\";i:994;s:13:\"t8=hT?GUGJlBA\";i:995;s:46:\"HH=hT?GUALlBjL.4Fx~5AAYL=hT?GUALlBrL.4Fx~5AABA\";i:996;s:46:\"eS=hT?GUgLlBzL.4Fx}MQAvW=hT?GUgLlB7L.4Fx}MQABA\";i:997;s:56:\"ru>hT?GU\"NlBfL.4Fx}MQApI=hT?GUgLlBnL.4Fx}MQAHO=hT?GUpA$A\";i:998;s:38:\"Sj>hT?GU~@[Aa4((k)Noa.6FvW_)qI:$vboCgA\";i:999;s:13:\"_X=hT?GUsHlBA\";i:1000;s:35:\"pu>hT?GUqNlBvL.4Fx}MBAvW=hT?GURIlBA\";i:1001;s:24:\"ou>hT?GUqNlBvL.4Fx}MLABA\";i:1002;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:1003;s:13:\">J=hT?GUHGlBA\";i:1004;s:23:\"tP=hT?GUpA$A=CSOYMAlBtA\";i:1005;s:94:\"zP>hT?IU~AlBUoEAI7_Q3nE39F$AEDSOYMLUEt[9_Q3nE3cAgA4BJHNzFKuWGOqI:$vbuARt:BJHNzijwWtpqI:$vbICgA\";i:1006;s:66:\"x8=hT?GUGJlBMQ.4FxrjYBgAJt|\",ub@y2F\"uW+>qI:$vbaUY4:CogzXJI|+wC$AQA\";i:1007;s:38:\"e#?hT?GUO[uWXLIoVElg*NHA3(`\",ub@=1qFQA\";i:1008;s:23:\")a=hT?GUpA$A[CSOYMtOBtA\";i:1009;s:23:\")a=hT?GUpA$A[CSOYMtOBtA\";i:1010;s:36:\"XE=hT?GU}jYBbLit,ub@/B5FWuLvSQ[zCAEA\";i:1011;s:15:\"_X@hT?GUO[muZLA\";i:1012;s:13:\"_X@hT?GUqNlBA\";i:1013;s:48:\"eS=hT?GUiFlBzL.4Fx~5AAvW=hT?GUO[jnYLPDVElg*NFAIA\";i:1014;s:23:\"LV=hT?GUpA$A^CSOYMtOBtA\";i:1015;s:13:\"t8=hT?GUqNlBA\";i:1016;s:13:\"!5=hT?GUDClBA\";i:1017;s:57:\"fS=hT?GU~@$Aln#(k)No]AlB3L.4Fx}MFAeZ=hT?GUpA$ADDSOYMM%BtA\";i:1018;s:48:\"%5=hT?GU\"NlBvL.4Fx}MBA6F=hT?GUHGlBZN.4FxrjYBzDQA\";i:1019;s:24:\"ou>hT?GUqNlBfL.4Fx~5AABA\";i:1020;s:13:\"!5=hT?GUDClBA\";i:1021;s:57:\"fS=hT?GU~@$Aln#(k)No]AlB3L.4Fx}MFAeZ=hT?GUpA$ADDSOYMM%BtA\";i:1022;s:48:\"%5=hT?GU\"NlBvL.4Fx}MBA6F=hT?GUHGlBZN.4FxrjYBzDQA\";i:1023;s:24:\"ou>hT?GUqNlBfL.4Fx~5AABA\";i:1024;s:127:\"lS=hT?GU~@$Aln#(k)No]AlB3L.4Fx}MFAeZ=hT?GUpA$A`CSOYM6|Dt@Q_Q3nE3QE$A|CSOYM6|Dt#T_Q3nE3somATq=hT?GU~@<AE\"=hT?GU~@<AwW$(k)NoGE:CA\";i:1025;s:107:\"pg=hT?GU$LlB,L.4Fx~5QA1k=hT?GU$LlB?L.4Fx}M2,6F7vLvSQ[zcQ1WXLqI:$vbX%e\"oI_Q3nE3kAgAmBJHNzWHvWggqI:$vbaU}4:CA\";i:1026;s:144:\"tg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCAI7=hT?GUGJlBhN.4Fx}MTAZ4=hT?GUDClBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAgA\";i:1027;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GUPOlBkM.4Fx}MUA};=hT?GUPOlBwM.4Fx~5UA,>=hT?GUfOlB0M.4FxrjUAU|=hT?GUIDlB8M.4FxrjEA;C>hT?GUIDlB.M.4Fxs@EA6F>hT?GUYDlB<M.4Fx~5EABA\";i:1028;s:56:\",a>hT?GU[IlBVN.4Fx~5AAvW>hT?GUpA$AWDSOYMtOBt_)_Q3nE3,H$A\";i:1029;s:127:\"lS=hT?GU~@$Aln#(k)No]AlB3L.4Fx}MFAeZ=hT?GUpA$A`CSOYM6|Dt@Q_Q3nE3QE$A|CSOYM6|Dt#T_Q3nE3somATq=hT?GU~@<AE\"=hT?GU~@<AwW$(k)NoGE:CA\";i:1030;s:107:\"pg=hT?GU$LlB,L.4Fx~5QA1k=hT?GU$LlB?L.4Fx}M2,6F7vLvSQ[zcQ1WXLqI:$vbX%e\"oI_Q3nE3kAgAmBJHNzWHvWggqI:$vbaU}4:CA\";i:1031;s:144:\"tg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCAI7=hT?GUGJlBhN.4Fx}MTAZ4=hT?GUDClBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAgA\";i:1032;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GUPOlBkM.4Fx}MUA};=hT?GUPOlBwM.4Fx~5UA,>=hT?GUfOlB0M.4FxrjUAU|=hT?GUIDlB8M.4FxrjEA;C>hT?GUIDlB.M.4Fxs@EA6F>hT?GUYDlB<M.4Fx~5EABA\";i:1033;s:13:\"(a>hT?GU[IlBA\";i:1034;s:12:\"EH=hT?GUpA$A\";i:1035;s:12:\"bS=hT?GUpA$A\";i:1036;s:75:\"gS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWGOqI:$vbtDi\"3BJHtzijUO$AijZPlBA\";i:1037;s:23:\"LV=hT?GUpA$A^CSOYMtOBtA\";i:1038;s:13:\"t8=hT?GUGJlBA\";i:1039;s:50:\"w8=hT?GUGJlB|P.4FxrjYBjBQA=\",ub@>i5FT3LvSQ[zGF`B$A\";i:1040;s:57:\"fS=hT?GUaNlBzL.4Fx~5AAvW=hT?GUOBlB7L.4Fx~5AAZ4=hT?GUDClBA\";i:1041;s:12:\"EH=hT?GUpA$A\";i:1042;s:125:\"7d>hT?GUO[VxZLrPVElg*NmBS\";\",ub@y2_9Ft:C_Q3nE3UAi\"mBJHNztSwW:CqI:$vbKARtnBJHNzWHuWGOqI:$vbtDgA:BJHNzRmPtYAHO>hT?IU4DlBrz=)5FA\";i:1043;s:25:\"#5=hT?GUDClB3L.4Fx}M+X6FA\";i:1044;s:56:\"&5=hT?GUDClBvL.4Fx}MBA$T=hT?GUpA$A]CSOYMM%Ft8M_Q3nE3UAgA\";i:1045;s:56:\"IH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWxdqI:$vb<CgA\";i:1046;s:13:\"hg?hT?GUqNlBA\";i:1047;s:13:\"Qj?hT?GUqNlBA\";i:1048;s:45:\"HH=hT?GUgLlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:1049;s:12:\"EH=hT?GUpA$A\";i:1050;s:14:\"bS=hT?GU~@RBEA\";i:1051;s:13:\"bS=hT?GUQLlBA\";i:1052;s:13:\"(a>hT?GU[IlBA\";i:1053;s:37:\"GH=hT?GU~AlBvL.4Fx~5IAkn>hT?GUO[6yZLA\";i:1054;s:69:\"JH=hT?GUpA$A>CSOYMifBtoI_Q3nE3UAgApBJHNz!PvWggqI:$vbhDi\"%BJHNzRmQ\"W\"A\";i:1055;s:69:\"JH=hT?GUpA$A>CSOYMifBtoI_Q3nE3UAgApBJHNz!PvWggqI:$vbhDi\"%BJHNzRmQ\"W\"A\";i:1056;s:13:\"9M=hT?GUQLlBA\";i:1057;s:23:\"FH=hT?GUpA$A>CSOYM6|EtA\";i:1058;s:12:\"9M=hT?GUpA$A\";i:1059;s:47:\"HH=hT?GU9ElBjL.4Fx~5AAYL=hT?GU}jFBc4ht,ub@/B5FA\";i:1060;s:46:\"HH=hT?GU9ElBjL.4Fx~5AAYL=hT?GUCFlBrL.4Fx~5AABA\";i:1061;s:39:\"0d>hT?GUO[E0ZL&\"LvSQ[zGF4AgAnBJHNzApvWA\";i:1062;s:12:\"EH=hT?GUpA$A\";i:1063;s:13:\"EH=hT?GUgLlBA\";i:1064;s:48:\"qu>hT?GU\"NlB@M.4Fx}MeANc>hT?GUO[E0ZLFBVElg*N5AIA\";i:1065;s:13:\"t8=hT?GUqNlBA\";i:1066;s:12:\"EH=hT?GUpA$A\";i:1067;s:45:\"HH=hT?GUgLlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:1068;s:24:\")a>hT?GU[IlBfL.4Fx~5AABA\";i:1069;s:13:\"nu>hT?GU\"NlBA\";i:1070;s:13:\"bS=hT?GUOBlBA\";i:1071;s:13:\"(a>hT?GU[IlBA\";i:1072;s:110:\";a@hT?GUO[k_XLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GUpA$AXDSOYMtOBt>2_Q3nE3UAgA4BJHNzWHuWqiqI:$vbaUi6:C,bzXJI|+wC[BgA\";i:1073;s:12:\"bS>hT?GU/A$A\";i:1074;s:35:\"v8=hT?GUGJlBnL.4Fx~5LAZ4=hT?GUDClBA\";i:1075;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:1076;s:24:\"FH=hT?GU4DlBnL.4FxrjBABA\";i:1077;s:24:\"u8=hT?GUGJlBnL.4Fx}MQABA\";i:1078;s:36:\"*a>hT?GU[IlB&O.4Fx}M|_6F%tLvSQ[zGAEA\";i:1079;s:13:\"9M=hT?GUHGlBA\";i:1080;s:178:\"#d>hT?GUiFlBfL.4Fx~5AApI=hT?GU~@QBFtht,ub@=1(ERtnBJHNzWHuWUEqI:$vb*|c\"=J_Q3nE30o$$5FmuLvSQ[z{&0WeGqI:$vbaUgg:CBdzXJI|+wCtBgA9BJHNz:rwW)0qI:$vbhDi\"=BJHNzRm9(pAHO>hT?IU9ElB&!5AjAEA\";i:1081;s:71:\"wP>hT?IU9ElB&!5AjA/h#(k)No`,hC3((\",ub@y2y(GtXL_Q3nE3t`1AeZ=hT?GUO[jnYLA\";i:1082;s:48:\"+a>hT?GUjSlBlN.4FxrjYB%BRt7BJHNztSuWMcqI:$vbaAQA\";i:1083;s:48:\"+a>hT?GUjSlBlN.4FxrjYB%BRt7BJHNztSuWMcqI:$vbaAQA\";i:1084;s:38:\"uP>hT?GU~@@A]Q#(k)NocC:CBdzXJI|+wCcEgA\";i:1085;s:14:\"bS?hT?GU}jYBEA\";i:1086;s:13:\"hg?hT?GUqNlBA\";i:1087;s:26:\"?J=hT?GUpA$A?CSOYMj<cAXABA\";i:1088;s:112:\"8:>hT?GUoTlBRN.4Fx~5RA[Q>hT?GUlMlBzP.4Fx}MHA6F=hT?GUpA$A=CSOYM*+9dlBnL.4Fx~5RAHO=hT?GUpA$AYDSOYMtOEtxd_Q3nE3}E$A\";i:1089;s:13:\">J=hT?GURIlBA\";i:1090;s:26:\"?J=hT?GUpA$A?CSOYMj<cAXABA\";i:1091;s:112:\"8:>hT?GUoTlBRN.4Fx~5RA[Q>hT?GUlMlBzP.4Fx}MHA6F=hT?GUpA$A=CSOYM*+9dlBnL.4Fx~5RAHO=hT?GUpA$AYDSOYMtOEtxd_Q3nE3}E$A\";i:1092;s:15:\"EH=hT?GUO[{eYLA\";i:1093;s:12:\"EH=hT?GUpA$A\";i:1094;s:26:\"?J=hT?GUpA$A?CSOYMj<cAXABA\";i:1095;s:12:\"sP=hT?GUpA$A\";i:1096;s:13:\"t8=hT?GUqNlBA\";i:1097;s:15:\"hg?hT?GUO[8MYLA\";i:1098;s:24:\"?J=hT?GURIlBrL.4Fx~5AABA\";i:1099;s:59:\",a>hT?GUjSlBlN.4FxrjYB%BRt7BJHNztSuWMcqI:$vb7Bi\"4BJHNz!PvWA\";i:1100;s:13:\"9M=hT?GUQLlBA\";i:1101;s:46:\"HH=hT?GUOBlBjL.4Fx~5AAYL=hT?GUOBlBrL.4Fx~5AABA\";i:1102;s:24:\"Rj>hT?GU%IlB_M.4Fxs@AABA\";i:1103;s:13:\"t8=hT?GUGJlBA\";i:1104;s:12:\"EH=hT?GUpA$A\";i:1105;s:15:\"9M=hT?GUO[Y4ZLA\";i:1106;s:13:\"t8=hT?GUqNlBA\";i:1107;s:13:\"_X=hT?GUsHlBA\";i:1108;s:13:\"t8=hT?GUGJlBA\";i:1109;s:101:\"6d>hT?GUiFlBQM.4Fx}MOACt>hT?GUBIlBvL.4Fx~5AA$T=hT?GUOBlB3L.4Fx~5AAeZ=hT?GUOBlBMM.4Fxs@CA6F@hT?GU4DlBA\";i:1110;s:66:\"wP>hT?GUO[95ZL+OVElg*NqBRtvBJHNzG3vW{eqI/TwbOARtIT1WVAq1_Q3nE3tF$A\";i:1111;s:27:\"tP>hT?GUO[95ZL4YVElg*NXmPtA\";i:1112;s:59:\",a>hT?GUjSlBlN.4FxrjYB%BRt7BJHNztSuWnbqI:$vbaAQA>\",ub@=15FA\";i:1113;s:56:\"x8=hT?GU{JlBfL.4Fx~5AApI=hT?GU/A$A>CSOYMtOBtDH_Q3nE3UAgA\";i:1114;s:13:\"t8=hT?GUqNlBA\";i:1115;s:13:\"t8=hT?GU{JlBA\";i:1116;s:13:\"Qj>hT?GU%IlBA\";i:1118;s:46:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GU4DlBrL.4Fx~5AABA\";i:1119;s:68:\"gS=hT?GU4DlBzL.4Fx}MFAvW=hT?GU4DlB7L.4Fx}MFAYL=hT?GU4DlBMM.4Fxs@CABA\";i:1120;s:85:\"Fm?hT?GU}jdBbLht,ub@y2_9Lt^X`Q3nE30o5F5FhtLvSQ[zCA/hht,ub@uC5F%tLvSQ[zCAc4ht,ub@uC5FA\";i:1121;s:15:\"yd>hT?GUO[[9ZLA\";i:1122;s:46:\"HH=hT?GURIlBjL.4Fx~5AAYL=hT?GU,GlBrL.4Fx~5AABA\";i:1123;s:13:\"9M=hT?GUgLlBA\";i:1124;s:13:\"EH=hT?GUOBlBA\";i:1125;s:56:\"x8=hT?GUGJlBfL.4Fxs@AApI=hT?GU5A$A>CSOYMLUBtDH_Q3nE3cAgA\";i:1126;s:105:\"Hm>hT?GU+JlBQM.4Fx}MTA+h>hT?GU~AlB_M.4FxrjBA6F=hT?GUO[b#ZLDHVElg*NXA2W^\",ub@=15FW!LvSQ[zxAbLut,ub@y2PcFtA\";i:1127;s:13:\"_X>hT?GUOBlBA\";i:1128;s:13:\"KV>hT?GUOBlBA\";i:1129;s:30:\"zd>hT?GU~AlB@M.4?zs@SAq1~R0ACA\";i:1130;s:13:\"R@>hT?GU4TlBA\";i:1131;s:116:\"<a>hT?GUjSlB}M.4Fx~5AA|e>hT?GUpA$AXDSOYMtOBtoI_Q3nE3IE$A[CSOYMB]DtXL_Q3nE3IE$A^CSOYMB]DtoI`Q3nE30onb5Fz3LvSQ[zGFbP$A\";i:1132;s:13:\"t8=hT?GUGJlBA\";i:1133;s:114:\"28=hT?GU{JlBfL.4Fx~5BApI=hT?GUpA$A>CSOYMAlBtDH_Q3nE3UAgAoBJHNztSuW_EqI:$vbcCgApBJHNztSuWeGqI:$vb#Bi\":BJHNzRm8WSABA\";i:1134;s:64:\"fS=hT?GUOBlBzL.4Fx~5BAvW=hT?GUOBlB7L.4Fx~5BAHO>hT?IU9ElB&!5AjAEA\";i:1135;s:13:\"t8=hT?GUqNlBA\";i:1136;s:262:\"oCgY,\",ub@,n5FhtLvSQ[zCA/hht,ub@TD5F%tLvSQ[zCAc4ht,ub@/B5FT3LvSQ[zGFjP$A5DSOYMj<e\"YA$T?hT?GUO[y:XLHbVElg*NtEPt#T`Q3nE3~R4ANc>hT?GUhIlB:O.4Fx}MTApI@hT?GU}jVBz(rt,ub@=1`ERt?BJHNz5uuWe+qI:$vbaU\"S:CeezXJI|+wCNBgA[BJHNzRm9(NAO/?hT?GUO[~lXLvjVElg*NNK=JlB(P.4FxrjYBVBQA\";i:1137;s:13:\"(a>hT?GU[IlBA\";i:1138;s:67:\".a>hT?GUjSlBVN.4Fxs@NA$T>hT?GUpA$AaDSOYM5qEtY4_Q3nE3UAgAvBJHNzzguWA\";i:1139;s:48:\"HH=hT?GUO[v(ZLFBVElg*NFAK\"ht,ub@/B5F[tLvSQ[zCAEA\";i:1140;s:13:\"(a>hT?GU[IlBA\";i:1141;s:13:\"R@>hT?GU4TlBA\";i:1142;s:24:\"Rj>hT?GU%IlBfL.4Fx~5LABA\";i:1143;s:45:\"eS=hT?GU4DlBzL.4Fx~5AAvW=hT?GUpA$A^CSOYMtOBtA\";i:1144;s:13:\"sP?hT?GUqNlBA\";i:1145;s:58:\",a>hT?GU[IlB&O.4Fx}M|_6F%tLvSQ[ziAc4lt,ub@ff5Fk0LvSQ[zeAEA\";i:1146;s:78:\"/a>hT?GUjSlBVN.4Fx~5AAvW>hT?GUpA$A<CSOYMAlBtUE_Q3nE30AgAnBJHNztSuWvDqI:$vbaAQA\";i:1147;s:14:\"(a>hT?GU~@ZBEA\";i:1148;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE30Ai\"pBJHNzWHuWA\";i:1149;s:13:\"t8=hT?GUqNlBA\";i:1150;s:67:\"fS=hT?GU~@EB:>ht,ub@/B5FmuLvSQ[zp~zWeGqI:$vbKARt3BJHtz*:uWhNNKcM:CA\";i:1151;s:23:\"LV=hT?GUpA$A^CSOYMtOBtA\";i:1152;s:23:\"cS=hT?GUpA$A]CSOYMtOBtA\";i:1153;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3nH$A?CSOYMtOBtA\";i:1154;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3/B$A?CSOYMtOBtA\";i:1155;s:23:\"LV=hT?GUpA$A^CSOYMtOBtA\";i:1156;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fx~5YA%$=hT?GUeRlBcM.4Fx~5YAf+=hT?GU^ClBkM.4Fx}MEA};=hT?GU^ClBwM.4Fx~5UA,>=hT?GUfOlB0M.4FxrjUAU|=hT?GUIDlB8M.4FxrjEA;C>hT?GUIDlB)M.4Fx~5EApI>hT?GUoDlB<M.4Fx~5EABA\";i:1157;s:100:\"pg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzLYuWyKqI:$vbiAQA+\",ub@CG5FQwLvSQ[zLAbLjt,ub@MI5FgwLvSQ[zLAEA\";i:1158;s:101:\"pg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA7y=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBA\";i:1159;s:112:\",5=hT?GUDClB(L.4Fx~5QA+h=hT?GU$LlB;L.4Fx~5QAkn=hT?GUuBlB^L.4Fx}MCACt=hT?GUuBlBEM.4Fxs@CA<v=hT?GUDClBIM.4Fxs@CABA\";i:1160;s:26:\"u8=hT?GU{JlBuO.4FxrjYBOCQA\";i:1161;s:26:\"u8=hT?GU{JlBuO.4FxrjYBOCQA\";i:1162;s:24:\"!M=hT?GURIlBfL.4Fx~5BABA\";i:1163;s:13:\"!5=hT?GUDClBA\";i:1164;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3(D$A?CSOYMtOBtA\";i:1165;s:13:\"9M=hT?GUiFlBA\";i:1166;s:12:\"9M=hT?GUpA$A\";i:1167;s:13:\"!5=hT?GU\"NlBA\";i:1168;s:26:\"u8=hT?GU{JlBuO.4FxrjYBOCQA\";i:1169;s:26:\"u8=hT?GU{JlBuO.4FxrjYBOCQA\";i:1170;s:26:\"u8=hT?GU{JlBuO.4FxrjYBOCQA\";i:1171;s:26:\"u8=hT?GU{JlBuO.4FxrjYBOCQA\";i:1172;s:24:\"!M=hT?GURIlBfL.4Fx~5BABA\";i:1173;s:24:\"!M=hT?GUgLlBMM.4Fxs@CABA\";i:1174;s:75:\"JH=hT?GUsHlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBt^X`Q3nE30o5F5FvzLvpb[zFA/huM5FA\";i:1175;s:13:\"EH=hT?GU?OlBA\";i:1176;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3OC$A?CSOYMtOBtA\";i:1177;s:39:\"GH=hT?GU6NlBJN.4Fx}MNAHO>hT?IU<HlBqGJAB\";i:1178;s:45:\"HH=hT?GUpA$A=CSOYMLUBt5F_Q3nE3UAi\"nBJHNzFKuWA\";i:1179;s:46:\"eS=hT?GU3GlBzL.4FxrjBAvW=hT?GU3GlB7L.4FxrjBABA\";i:1180;s:77:\"3d>hT?GUO[_)ZL&\"LvSQ[zCA/hht,ub@/B5F%tLvSQ[z$Ac4ht,ub@/B5FvzLvpb[zeA/ha.2[BtA\";i:1181;s:48:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE30oPj6F[tLvSQ[zCAEA\";i:1182;s:13:\"EH=hT?GUgLlBA\";i:1183;s:14:\"EH=hT?GU~@RBEA\";i:1184;s:26:\"cS=hT?GU3GlBZN.4FxrjYB3DQA\";i:1185;s:31:\"tP>hT?IU~@@A]Q~@{AyW#(k)NocC:CA\";i:1186;s:13:\"9M=hT?GUgLlBA\";i:1187;s:13:\"VE=hT?GU%IlBA\";i:1188;s:67:\"&M=hT?GUpA$A?CSOYMtOBtoI_Q3nE3UAi\"oBJHNzWHuW5FqI:$vbKARtpBJHNzWHuWA\";i:1189;s:13:\"sP=hT?GUOBlBA\";i:1190;s:12:\"EH=hT?GUpA$A\";i:1191;s:48:\"+a>hT?GU[IlBrL.4Fx}MQA};?hT?GUqNlBfL.4FxrjYB`DQA\";i:1192;s:12:\"sP=hT?GUpA$A\";i:1193;s:12:\"sP=hT?GUpA$A\";i:1194;s:12:\"9M=hT?GUpA$A\";i:1195;s:59:\"8r>hT?GUO[N/ZLKCVElg*NFA3((\",ub@4E5FmuLvSQ[zuAbLit,ub@4E5FA\";i:1196;s:13:\"4r>hT?GUqNlBA\";i:1197;s:134:\"NH=hT?GUpA$A=CSOYM*+&elBnL.4Fx}MO#6F[tLvSQ[z5pzWUEqI:$vbaU7#:CLXzXJI|+wC,DgApBJHNzRmPttAeZ=hT?GUO[{eYLscVElg*NNKlBlB@M.4?z}MFAq1t`wACA\";i:1198;s:15:\"/o>hT?GUO[N/ZLA\";i:1199;s:13:\"bS=hT?GURIlBA\";i:1200;s:24:\")a>hT?GU[IlBJN.4FxrjHABA\";i:1201;s:59:\",a>hT?GU[IlBQM.4Fx}MOA+h>hT?GU4DlBlN.4Fxs@LAeZ@hT?GUO[h=ZLA\";i:1202;s:134:\"9:>hT?GUO[{eXLmOVElg*NbCQA=\",ub@wc5F#zLvSQ[zoAc4mt,ub@y2EtMtY4_Q3nE30oIo6F51LvSQ[z!KyW+OqI:$vbYCi\"nBJHNzWHuW_)qI:$vbQCi\"~BJHNzRm8WRABA\";i:1203;s:130:\"9:>hT?GUO[{eXLmOVElg*NbCQA=\",ub@wc5F#zLvSQ[zoAbLnt,ub@=1[CRtvBJHNzG3vW7fqI:$vboCgA5BJHNzd&vWvDqI:$vbX%W\":C_Q3nE30o.o6FW!LvSQ[zxAEA\";i:1204;s:79:\"gS=hT?GUO[\"]ZLqCVElg*NFAIAit,ub@y2_9Mt8M_Q3nE3UAgAvBJHNzzguWCaqI/TwbpDi\"ITItXAB\";i:1205;s:13:\"!5=hT?GUBIlBA\";i:1206;s:126:\"38=hT?GU{JlBfL.4Fx~5AApI=hT?GU~@@AwW#(k)NoEK:C{WzXJI{ZBA,h#(k)No]AlBzL.4Fx~5AAvW=hT?GUpA$A^CSOYMtOBtGO`Q3nE30o^X5FS6LvSQ[z<AEA\";i:1207;s:13:\"sP>hT?GU=0lBA\";i:1208;s:13:\"Qj?hT?GUqNlBA\";i:1209;s:200:\"oCAY,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GUPOlBkM.4Fx}MUA};=hT?GUPOlBsM.4Fx~5EA2[=hT?GUoDlB0M.4Fx~5EAU|=hT?GUIDlB8M.4FxrjEA;C>hT?GUIDlB)M.4Fx~5EApI>hT?GUoDlB<M.4Fx~5EAHO=hT?GUpA$A\";i:1210;s:13:\"t8=hT?GUqNlBA\";i:1211;s:15:\"EH=hT?GUO[/`ZLA\";i:1212;s:131:\"rg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA7y=hT?GU5A$AADSOYMLUBt&a_Q3nE3cAi\"3BJHtzcVvWhNtEK\"xdqI:$vbaUC6:CA\";i:1213;s:131:\"rg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzijSU$A~CSOYM*+kolB|L.4Fx}M2,6FQwLvSQ[zDAbLjt,ub@uC5FgwLvSQ[zDAc4lt,uj@ff5F=ZkAyW#(k)No3B:CA\";i:1214;s:12:\"sP=hT?GUpA$A\";i:1215;s:41:\"*a>hT?GU[IlB@M.4?zs@JAq1~RgAOc>hT?GUWJlBA\";i:1216;s:47:\"+a>hT?GU[IlBQM.4Fxs@MAO/>hT?GUoTlBfL.4Fx}M)96FA\";i:1217;s:13:\"t8=hT?GUqNlBA\";i:1218;s:15:\"EH=hT?GUO[rPYLA\";i:1219;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:1220;s:39:\"$5=hT?GUDClBvL.4Fx~5AA6F=hT?IU~AlB%RIAB\";i:1221;s:47:\"eS=hT?GU~@QB:>ht,ub@qO5FmuLvSQ[zqAbLit,ub@qO5FA\";i:1222;s:13:\"9M=hT?GU~AlBA\";i:1223;s:13:\"9M=hT?GU^SlBA\";i:1224;s:15:\"yd?hT?GUO[;vXLA\";i:1225;s:17:\"sP>hT?IU<HlBqGJAB\";i:1226;s:13:\"!5=hT?GUDClBA\";i:1227;s:57:\"fS=hT?GUgLlBzL.4Fx}MQAvW=hT?GUgLlB7L.4Fx}MQAZ4=hT?GU\"NlBA\";i:1228;s:13:\"!5=hT?GU\"NlBA\";i:1229;s:50:\"w8=hT?GUGJlB|P.4FxrjYBjBQA=\",ub@>i5FT3LvSQ[zGF`B$A\";i:1230;s:13:\"!5=hT?GUDClBA\";i:1231;s:56:\"IH=hT?GUpA$A=CSOYMtOBt5F_Q3nE39F$A?CSOYMtOBtlB_Q3nE3gE$A\";i:1232;s:13:\"EH@hT?GU%IlBA\";i:1233;s:14:\"4r?hT?GU}jhBEA\";i:1234;s:89:\"LH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWUEqI:$vb<Ci\"oBJHNzWHuW5FqI:$vb<Ci\"pBJHNzWHuWA\";i:1235;s:46:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3so2AeZ=hT?GUpA$A\";i:1236;s:26:\"cS=hT?GUgLlBZN.4FxrjYB+AIA\";i:1237;s:15:\"?2@hT?GUO[T|ZLA\";i:1238;s:26:\"u8=hT?GU{JlBuO.4FxrjYB)AIA\";i:1239;s:82:\"y8=hT?KUTClB&!BA(a6Ay\">\",ub@##5F~1LvSQ[z\"AK\"nt,ub@##5F[tLvSQ[zGFYQ$A=CSOYMj<dtBBEA\";i:1240;s:111:\";a>hT?GU[IlB?L.4Fxs@AATq=hT?GU5A$A\"CSOYMLUBtGO_Q3nE3t`1A[Q=hT?GUO[jnYLqCVElg*NNKQQlB3L.4FxrjYBCCRtpBJHNzRmQ\"N\"A\";i:1241;s:50:\"<o=hT?GU}j*Am_#(k)No`,vBIAjt,ub@=1EDRtlBJHNzijaM$A\";i:1242;s:36:\"*a>hT?GU[IlB&O.4Fx}M|_6F$wLvSQ[zzAEA\";i:1243;s:15:\"i=>hT?GUO[4}ZLA\";i:1244;s:37:\"v8=hT?GU{JlBuO.4FxrjYB)AK\"mt,ub@>i5FA\";i:1245;s:105:\";a>hT?GUjSlBVN.4Fx~5AA$T>hT?GUpA$AaDSOYMtOBtY4_Q3nE3UAgA.BJHNzRm9(JA};>hT?GUpA$ADDSOYMM%Bt95`Q3nE30oBt6FA\";i:1246;s:267:\"oCh*^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,uj@,n5F>+ZAc4%(k)No&Q:C5dzXJI{ZmA]Q*(k)No`,qCJt|\",ub@=1`ERt?BJHNz5uuWe+qI:$vbaU\"S:CeezXJI|+wCNBgA[BJHNzRm9(NAO/?hT?GUO[~lXLvjVElg*NNK=JlB(P.4FxrjYBVBRt5BJHNzLYxW7fqI:$vboCgA5BJHNzd&vW.oqI:$vbaU?(:C*ZzXJI{ZfAP/&(k)Noa.6F0WA\";i:1247;s:50:\"eS=hT?GUpA$A[CSOYMj<cAXAvW=hT?GUpA$A^CSOYMj<cAXABA\";i:1248;s:12:\"9M=hT?GUpA$A\";i:1249;s:43:\"Yx?hT?GUO[XLXLBNVE^2*N7A3(=1.DgA(\",ub@ZR5FA\";i:1250;s:23:\"cS=hT?GUpA$A<CSOYMM%DtA\";i:1251;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3/B$A^CSOYMtOBtA\";i:1252;s:46:\"eS=hT?GU4DlBzL.4Fx}MFAvW=hT?GU4DlB7L.4Fx}MFABA\";i:1253;s:15:\"9M=hT?GUO[SqYLA\";i:1254;s:13:\"sP=hT?GUOBlBA\";i:1255;s:21:\"sP>hT?IU}j`A]QO[UExWA\";i:1256;s:13:\"!5=hT?GUDClBA\";i:1257;s:57:\"fS=hT?GUtElBzL.4Fx~5AAvW=hT?GUtElB7L.4Fx~5AA+h>hT?GU%IlBA\";i:1258;s:45:\"eS=hT?GUpA$A[CSOYMifBtXL_Q3nE3sAi\"pBJHNz!PuWA\";i:1259;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3sAi\"pBJHNzWHuWA\";i:1260;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3/B$A^CSOYMtOBtA\";i:1261;s:46:\"eS=hT?GU4DlBzL.4Fx}MFAvW=hT?GU4DlB7L.4Fx}MFABA\";i:1262;s:13:\"9M=hT?GUiFlBA\";i:1263;s:13:\"_X=hT?GU~AlBA\";i:1264;s:57:\"Uj>hT?GU%IlBvL.4FxrjJA$T=hT?GU~AlB3L.4FxrjJAeZ=hT?GU~AlBA\";i:1265;s:13:\"!5=hT?GUDClBA\";i:1266;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fx~5YA%$=hT?GUeRlBcM.4Fx~5YAf+=hT?GUPOlBkM.4Fx}MUA};=hT?GUPOlBsM.4Fx~5EA2[=hT?GUoDlB0M.4Fx~5EAU|=hT?GUIDlB8M.4FxrjEA;C>hT?GUIDlB)M.4Fx~5EApI>hT?GUoDlB<M.4Fx~5EABA\";i:1267;s:35:\"T@=hT?GUDClBwM.4Fxs@CAl_=hT?GUDClBA\";i:1268;s:191:\"oCtB=\",ub@>i5FA$LvSQ[z<AFtvt,ub@/B5F1%LvSQ[zCA/hit,ub@/B5FLvLvSQ[zCAc4it,ub@/B5FrvLvSQ[zIA:>it,ub@CG5F;vLvSQ[zIAyWjt,ub@MI5FAwLvSQ[zLA/hjt,ub@MI5FhtLvSQ[zCA/hht,ub@uC5F%tLvSQ[zCAc4ht,ub@uC5FA\";i:1269;s:35:\"T@=hT?GUDClBwM.4Fxs@CAl_=hT?GUDClBA\";i:1270;s:15:\"_X@hT?GUO[5FaLA\";i:1271;s:26:\"S@>hT?GUO[>2XL0kVElg*N!BQA\";i:1272;s:15:\"VE=hT?GUO[C\"5FA\";i:1273;s:127:\"rg=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA7y=hT?GUDClBAM.4Fxs@CAq1=hT?GUDClBfL.4Fx}MFAHO>hT?IU<HlBqGJAB\";i:1274;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3IE$A^CSOYMtOBtA\";i:1275;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3bD$A^CSOYMtOBtA\";i:1276;s:13:\"_X=hT?GU4DlBA\";i:1277;s:46:\"HH=hT?GUOBlBjL.4Fx~5AAYL=hT?GUOBlBrL.4Fx~5AABA\";i:1278;s:15:\"bS?hT?GUO[DHaLA\";i:1279;s:14:\"EH=hT?GU~@RBEA\";i:1280;s:46:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3so2AHO=hT?GUpA$A\";i:1281;s:13:\"EH=hT?GURIlBA\";i:1282;s:24:\"LV=hT?GUXGlB7L.4Fxs@IABA\";i:1283;s:12:\"sP=hT?GUpA$A\";i:1284;s:37:\"uP>hT?GUALlB`N.4FxrjYBgERtmBJHNz?MuWA\";i:1285;s:13:\"Qj>hT?GU%IlBA\";i:1286;s:29:\"d#@hT?GUO[DHaLJVVElg*NNK\"ilBA\";i:1287;s:15:\"bS?hT?GUO[DHaLA\";i:1288;s:116:\"NH=hT?GU~@RB/hht,ub@/B5F%tLvSQ[z0.0WvDqI:$vbKAS\"(\",ub@lt5FWuLvSQ[z!AG\"#(k)No$W:CbXzXJI{ZfA,h((k)Noa.$TvWFhqI:$vbhDgA\";i:1289;s:15:\"R@>hT?GUO[DHaLA\";i:1290;s:15:\"R@>hT?GUO[XLaLA\";i:1291;s:78:\"KH=hT?GUpA$A>CSOYMtOBtoI_Q3nE3UAi\"oBJHNzWHuW5FqI:$vbKARtpBJHNzWHuWFhqI:$vbhDgA\";i:1292;s:13:\"VE=hT?GU%IlBA\";i:1293;s:71:\"su>hT?GU\"NlBRN.4Fxs@NA6F=hT?GUpA$A=CSOYMj<dtJBFtht,ub@=10DRtnBJHNzWHuWA\";i:1294;s:71:\"su>hT?GUBIlBRN.4Fxs@NA6F=hT?GUpA$A=CSOYMtOBt5F_Q3nE3\"!oAHO=hT?GUO[8MaLA\";i:1295;s:25:\"!M=hT?GU~@RBbLht,ub@>i5FA\";i:1296;s:34:\"v8=hT?GUGJlBrL.4Fxs@AApI=hT?GU5A$A\";i:1297;s:69:\"IH=hT?GUO[GOaLFBVElg*NFAK\"ht,ub@y2b4NtDH_Q3nE3UAi\"3BJHtz*:uWhNNKcM:CA\";i:1298;s:13:\"!5=hT?GUDClBA\";i:1299;s:14:\"9M=hT?GU~@RBEA\";i:1300;s:48:\"w8=hT?GU{JlBMM.4Fxs@CANc?hT?GUO[;vXLrPVElg*NIBQA\";i:1301;s:13:\"VE=hT?GU+JlBA\";i:1302;s:15:\"VE=hT?GUO[rPaLA\";i:1303;s:14:\"VE=hT?GU~@)ACA\";i:1304;s:15:\"VE=hT?GUO[@QaLA\";i:1305;s:15:\"VE=hT?GUO[aSaLA\";i:1306;s:15:\"VE=hT?GUO[#TaLA\";i:1307;s:15:\"VE=hT?GUO[JVaLA\";i:1308;s:15:\"VE=hT?GUO[uWaLA\";i:1309;s:13:\"t8=hT?GUGJlBA\";i:1310;s:67:\".a>hT?GU[IlBQM.4Fxs@MA[Q=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:1311;s:78:\"/a>hT?GUjSlBVN.4Fx~5AAvW>hT?GUpA$AaDSOYMtOBtp1_Q3nE3gE$AbDSOYM?IEtK&_Q3nE3UAgA\";i:1312;s:15:\"_X=hT?GUO[^XaLA\";i:1313;s:14:\"_X=hT?GU}j:ACA\";i:1314;s:13:\"VE=hT?GU%IlBA\";i:1315;s:13:\"VE=hT?GU%IlBA\";i:1316;s:100:\";a>hT?GU[IlBfL.4Fx~5AApI=hT?GUpA$A>CSOYMWDFtDH_Q3nE3UAgAoBJHNzWHuW_EqI:$vbKAQA)\",ub@/B5F2uLvSQ[zpAEA\";i:1317;s:162:\"!:>hT?GUO[jnXL;PVElg*NNK_klBBN.4Fxs@GAeZ>hT?GUjSlBQM.4Fx}MOA1k?hT?GU}jVBz(qt,ub@=1`ERt.BJHNzRm8WGAHO>hT?KU}jYB/hYO5FnjYB6EwA}\",ub@uC5F88LvSQ[zGFaC$A/DSOYMj<dtNACA\";i:1318;s:76:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWxdqI:$vbaUT3:C*ZzX&N{ZKA]Q~@GBIA\";i:1319;s:13:\"EH=hT?GUgLlBA\";i:1320;s:56:\"x8=hT?GUGJlBvL.4Fx~5IA$T=hT?GUpA$A]CSOYMM%Ct8M_Q3nE3SG$A\";i:1321;s:81:\"5:>hT?GUoTlBRN.4Fx~5LA[Q>hT?GU=ElBjL.4Fx}MHAeZ>hT?GU[IlBQM.4Fx}MOA2[>hT?GUO[*hXLA\";i:1322;s:15:\"VE=hT?GUO[McaLA\";i:1323;s:46:\"eS=hT?GU~@)Aln#(k)No]AlB3L.4Fxs@FAeZ=hT?GUpA$A\";i:1324;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:1325;s:68:\"wP>hT?KU~@@A]Q~@{A_QdEUEfL.4Fx~5BApI=hT?GUpA$A>CSOYMAlFtDH_Q3nE3UAgA\";i:1326;s:74:\"bx?hT?GUO[>2ZLBNVElg*NzAJt&\",ub@y2y(GtUE_Q3nE3UAgAnBJHNzRmQ\"N\"DH_Q3nE3UAgA\";i:1327;s:67:\"aE=hT?GU%IlBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAgAvBJHNzzguWA\";i:1328;s:67:\"aE=hT?GU%IlBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAgAvBJHNzzguWA\";i:1329;s:67:\"JH=hT?GUpA$A=CSOYMLUBt5F_Q3nE3UAi\"nBJHNzFKuWGOqI:$vbuARtlBJHNzoxvWA\";i:1330;s:45:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:1331;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:1332;s:23:\"tP=hT?GUpA$AEDSOYMLUEtA\";i:1333;s:80:\"Wj>hT?GUWJlB_M.4Fx}MNANc>hT?GU}j`AP/%(k)NoXB:CaazXJI{ZDAZL*(k)NonR:CYYzXJI|+FACA\";i:1334;s:218:\"oC_)^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0Lvpb[zvA/h`,?B!W{\",ub@=15Fm!LvSQ[zWC1Ws8qI:$vb\"Ie\"xd`Q3nE3pB$A^DSOYMj<e\"NAf+?hT?GUO[0kXL{eVElg*NNK9JlBTP.4FxrjYB2A2W~AyD1+ITJ\"Etp1`Q3nE30ojn5FvzLvpb[zGF&S$ARmPt1ACA\";i:1335;s:15:\"z:>hT?GUO[ggaLA\";i:1336;s:15:\"z:>hT?GUO[*haLA\";i:1337;s:12:\"hg>hT?GU/A$A\";i:1338;s:35:\"GH@hT?GU<HlBRN.4Fx}MLA[Q>hT?GU<HlBA\";i:1339;s:36:\"0d>hT?GUpA$A!DSOYM*+(rlBFN.4Fx~5MABA\";i:1340;s:147:\">a@hT?GUO[:CYLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GURIlBBN.4Fx~5LA$T>hT?GURIlBNN.4Fx~5LAvW@hT?GUO[PjaLVRVElg*NNKRdlBsQ.4Fx}M|_6Fj3LvSQ[zCAc4ot,ub@y2b4OtA\";i:1341;s:64:\",a@hT?GUO[=JYLpVVElg*NNKumlBRN.4FxrjMAw(@hT?GUO[jnaLyqVElg*NXAIA\";i:1342;s:38:\"N&@hT?GU~@iB/hot,ub@ph5F(3LvSQ[zGFXT$A\";i:1343;s:15:\"A^>hT?GUO[.oaLA\";i:1344;s:87:\"cx?hT?GUO[XLXLBNVE^2*N7A3(=1.Di\"&\",ub@r75FxtLvSQ[zCAFtht,ub@qO5F[tLvSQ[zCAyWmt,ub@lt5FA\";i:1345;s:13:\">J=hT?GUCFlBA\";i:1346;s:13:\"EH=hT?GU4DlBA\";i:1347;s:13:\"!5=hT?GUDClBA\";i:1348;s:106:\"iS=hT?GUpA$A[CSO}MtOBt&aEC$ApBJHNzWHuWeGqI/TwbKARtu%uWqiVElg*NPAJt<\",ub@=1LERt8BJHNzijwWCaqI/Twb]ARt!R3I$A\";i:1349;s:13:\"9M=hT?GUcHlBA\";i:1350;s:70:\"gS=hT?GU~AlBzL.4Fx}MFAvW=hT?GU~AlB7L.4Fx}MFAeZ>hT?GU[IlB?P.4FxrjYBdBQA\";i:1351;s:82:\"5:>hT?GUoTlBFN.4Fx}MaA[Q>hT?GU~@$A^9%(k)No]AlBBN.4Fx~5AA$T>hT?GUpA$A}DSOYMj<e\"3ABA\";i:1352;s:26:\"cS>hT?GU9ElB?P.4FxrjYBtDQA\";i:1353;s:62:\"wP>hT?IU2JlBrzJ@5FDXzXJI{ZBAln#(k)No]AlB3L.4Fx}MKAeZ=hT?GUpA$A\";i:1354;s:39:\"uP>hT?IU<HlBqGJA6F_Q3nE3UAgApBJHNzijvWA\";i:1355;s:15:\"i=>hT?GUO[3raLA\";i:1356;s:13:\"9M=hT?GU4DlBA\";i:1357;s:23:\")a=hT?GUpA$AEDSOYMLUEtA\";i:1358;s:29:\"Xx?hT?GUO[XLXLHbVElg*NNKjnlBA\";i:1359;s:26:\"0:@hT?GUO[muaLwQVElg*N!BQA\";i:1360;s:91:\"6:>hT?GUoTlBFN.4Fx}MaA|e>hT?GUpA$AbDSOYM5qEtp1_Q3nE3mC$AXDSOYMtOBt_)_Q3nE3t`gAI7=hT?GUqNlBA\";i:1361;s:47:\"eS>hT?GU=ElBBN.4Fxs@AA$T>hT?GUpA$ALESOYM*+YslBA\";i:1362;s:136:\">a>hT?GU[IlBQM.4Fxs@MA6F=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWUEqI:$vbECi\"oBJHNzApvW5FqI:$vbECi\"pBJHNzApvWDHqI:$vbOARt~BJHNzRm8WRABA\";i:1363;s:224:\"oC!u(\",ub@4E5F$wLv$m[zMA/h+E5F`5DA_9=hT?GU(ClBYM.4Fxs@DAw(=hT?GU(ClBgM.4Fx}MUAO/=hT?GUPOlBoM.4Fx}MUA,>=hT?GUDClBwM.4Fxs@CAl_=hT?GUDClB4M.4Fxs@CAD\"_Q3nE3BB$AQDSOYMM%Bt;v_Q3nE3BB$ASDSOYMM%Bt6y_Q3nE3BB$ADDSOYMM%BtGO_Q3nE3t`oABA\";i:1364;s:93:\"Xj>hT?GU%IlB_M.4Fx~5AAO/>hT?GUoTlBNN.4Fx~5AAvW>hT?GUpA$AYDSOYMXwHt_)_Q3nE3t`gAeZ@hT?GUO[;vaLA\";i:1365;s:26:\"cS>hT?GU%IlB?P.4FxrjYB^BQA\";i:1366;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:1367;s:147:\"t=?hT?GUO[BtXLkUVElg*NNK^nlB8Q.4FxrjYB{ERt5BJHNzX0vW+OqI:$vbsCgAmBJHNzWHuWKCqI:$vbaAQA(\",ub@/B5F[tLvSQ[zCAc4mt,ub@/B5FvzLvpb[z;A/h`,aCS\"jt,ub@|35FA\";i:1368;s:15:\"yd>hT?GUO[E0ZLA\";i:1369;s:12:\"hg>hT?GUpA$A\";i:1370;s:45:\"eS=hT?GUpA$A[CSOYMXwCtXL_Q3nE3UAi\"pBJHNzM*uWA\";i:1371;s:12:\"bS=hT?GUpA$A\";i:1372;s:12:\"bS=hT?GUpA$A\";i:1373;s:15:\"yd>hT?GUO[6yaLA\";i:1374;s:20:\"sP>hT?IU9ElB&!5AjAEA\";i:1375;s:45:\"HH=hT?GUpA$A=CSOYM5qBt5F_Q3nE3IE$A?CSOYMtOBtA\";i:1376;s:48:\"HH=hT?GUpA$A=CSOYMj<dtLAwW#(k)NoiQ:C{WzXJI{ZBACA\";i:1377;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3IE$A?CSOYM5qBtA\";i:1378;s:48:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3IE$A?CSOYMj<dtLACA\";i:1379;s:92:\"KH@hT?GU~AlB@M.4?z}M+X6F=Zm$wW+OVElg*NNKYolBvL.4Fx}M)96FWuLvSQ[zGAG\"#(k)No`,hC2W)\",ub@=1(EQA\";i:1380;s:28:\"tP>hT?IU<HlBqGJA6F_Q3nE3nH$A\";i:1381;s:13:\"EH@hT?GU~AlBA\";i:1382;s:74:\"xP>hT?IU~@@A]Q~@{A/h#(k)No]AlBzL.4Fx~5AAvW=hT?GUpA$A^CSOYMtOBt:C_Q3nE3UAgA\";i:1383;s:17:\"sP>hT?IU~AlBUoEAB\";i:1384;s:13:\"VE=hT?GU%IlBA\";i:1385;s:13:\"VE=hT?GU%IlBA\";i:1386;s:62:\"%M=hT?GUOBlBvL.4FxrjYBFFRtoBJHNzWHuW5FqI:$vbaUV[:CbXzXJI{ZBACA\";i:1387;s:24:\"WE=hT?GU&1lB_M.4Fxs@$ABA\";i:1388;s:71:\"JH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWUEqI:$vbaU1[:CSazXJI{ZakaLA\";i:1389;s:14:\"4r?hT?GU~@iBEA\";i:1390;s:23:\"sP>hT?IUO[Y4aL#zGFsUlBA\";i:1391;s:13:\"9M=hT?GUtElBA\";i:1392;s:15:\"Qj>hT?GUO[H7aLA\";i:1393;s:12:\"sP=hT?GUpA$A\";i:1394;s:59:\"fS=hT?GU~AlBzL.4Fx}MFAvW=hT?GU4DlB7L.4Fx}MFAHO=hT?GUO[H7aLA\";i:1395;s:113:\"kS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWlBqI:$vbKARtmBJHNzWHuW:CqI:$vbpDi\"nBJHNzWHuWCaqI:$vb]ARt=BJHNzRmOAD\"A\";i:1396;s:25:\"tP>hT?GU<HlBJN.4Fx}MPs6FA\";i:1397;s:13:\"EH=hT?GU,GlBA\";i:1398;s:13:\"t8=hT?GUqNlBA\";i:1399;s:25:\"tP>hT?GU~@@AOc#(k)NocC:CA\";i:1400;s:24:\"tP>hT?GU9ElBJN.4FxrjBABA\";i:1401;s:13:\">J=hT?GUOBlBA\";i:1402;s:48:\"+a>hT?GU~@ZBFtmt,ub@>i5F#zLvSQ[zxAG\"#(k)No`,0CIA\";i:1403;s:12:\"sP=hT?GUpA$A\";i:1404;s:19:\"sP>hT?IU2JlBrzJ@5FA\";i:1405;s:274:\"oCh*^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0Lvpb[zvA/ha.+hIt}4qI:$vbhDi\"{BJHNzij*T$A*DSOYM*+vnlB\"O.4Fx}MEAYL@hT?GUO[|;XLbfVElg*NNK0ElBLP.4FxrjYBTBS\"}\",ub@y2_9CtE0`Q3nE30ojn5F{!LvSQ[zGF_E$ApDSOYMj<dtaBFtjt,ub@MI5FC6LvSQ[zGF4I$A[DSOYM?IEt[9_Q3nE30o|;6F#zLvSQ[zGF)U$A\";i:1406;s:46:\"eS=hT?GU4DlBzL.4FxrjGAvW=hT?GU4DlB7L.4FxrjGABA\";i:1407;s:52:\"eS=hT?GUO[~lZLqCVElg*NiVLtXL_Q3nE3t`qAeZ=hT?GU~@[ACA\";i:1408;s:56:\"fS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuW:CqI:$vb(BgA\";i:1409;s:48:\"1d>hT?GUO[b#aL&\"LvSQ[zmAFtht,ub@!S5FmuLvSQ[zCAEA\";i:1410;s:46:\"eS=hT?GU~AlBzL.4Fx~5AAvW=hT?GU~AlB7L.4Fx~5AABA\";i:1411;s:15:\"),>hT?GUO[McXLA\";i:1412;s:13:\"),>hT?GUqNlBA\";i:1413;s:13:\"t8=hT?GUqNlBA\";i:1414;s:117:\"Zj>hT?GUO[$$aLhNVElg*NNK=plBfL.4Fx~5AApI=hT?GU5A$A>CSOYMtOBtDH_Q3nE3cAgAvBJHNzzguW_)qI:$vbQCi\"<BJHNzij?V$A]CSOYMtOBtA\";i:1415;s:212:\"oCIY,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GUPOlBkM.4Fx}MUA};=hT?GUPOlBsM.4Fxs@CA2[=hT?GUDClB0M.4Fxs@CAU|=hT?GUDClB8M.4Fxs@CA;C>hT?GUDClB)M.4Fxs@CApI>hT?GUDClB<M.4Fxs@CAZ4=hT?GUDClB_M.4FxrjMABA\";i:1416;s:122:\"qg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzijSU$A~CSOYM*+kolB|L.4Fx}M2,6FQwLvSQ[zDAbLjt,ub@uC5FgwLvSQ[zDAc4lt,uj@=1yDRt!R6H$A\";i:1417;s:187:\"oC_))\",ub@ph5FLvLvSQ[zvAc4it,ub@ph5FrvLvSQ[zIA:>it,ub@CG5F;vLvSQ[zIAyWjt,ub@uC5FAwLvSQ[zDA/hjt,ub@uC5FvzLvpb[zFA/huM5F!WzXJI{ZBA]Q#(k)No]AlBnL.4Fx~5AAHO=hT?GUpA$AYDSOYMtOEtH7_Q3nE30oCa6FA\";i:1418;s:17:\"sP>hT?IU<HlBqGJAB\";i:1419;s:13:\"(a>hT?GU[IlBA\";i:1420;s:47:\"+a>hT?GU[IlB&O.4Fx}MG|6Fp1LvSQ[z<AFtjt,ub@|35FA\";i:1421;s:24:\"FH=hT?GU1MlBjL.4Fx}MFABA\";i:1422;s:35:\"#M=hT?GUWJlBfL.4Fx~5AANc>hT?GUWJlBA\";i:1423;s:13:\"EH=hT?GUCFlBA\";i:1424;s:24:\"#5=hT?GU\"NlBRN.4FxrjMABA\";i:1425;s:23:\"!M=hT?GU/A$AEDSOYMLUEtA\";i:1426;s:53:\"I0?hT?GUqNlBaO.4FxrjYBXFQAEByD1+ITHAQtQ@`Q3nE30or?6FA\";i:1427;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3eC$A?CSOYMtOBtA\";i:1428;s:15:\"_X@hT?GUO[5FaLA\";i:1429;s:92:\"zP>hT?GUaNlB[N.4FxrjYBkES\"(\",ub@4E5FWuLvSQ[zuAG\"#(k)NocC:CbXzXJI{ZXAOc$(k)NoMS:CYYzXJI|+nACA\";i:1430;s:70:\".a>hT?GU[IlBVN.4Fx~5AA$T>hT?GUpA$ADDSOYM6|Ft5F_Q3nE30AgA.BJHNzRm8WxABA\";i:1431;s:13:\"sP>hT?GU9ElBA\";i:1432;s:23:\"!M=hT?GUpA$A[CSOYMu7CtA\";i:1433;s:15:\"t8=hT?GUO[e+aLA\";i:1434;s:24:\"0:>hT?GUoTlBQM.4Fxs@MABA\";i:1435;s:81:\"z8=hT?GU{JlBvL.4Fxs@GA$T=hT?GUOBlB3L.4Fxs@GAeZ=hT?GUOBlBjL.4Fxs@GA[Q?hT?GUO[DHaLA\";i:1436;s:25:\"u8=hT?GU{JlBjL.4Fx}MYB6FA\";i:1437;s:13:\"t8=hT?GUqNlBA\";i:1438;s:56:\"8r>hT?GUqNlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMtOBt8M_Q3nE3UAgA\";i:1439;s:15:\"(a@hT?GUO[(,aLA\";i:1440;s:119:\"kS=hT?GURIlBzL.4FxrjBAvW=hT?GURIlB7L.4FxrjbA6F=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuW}4qI:$vbaU:C:C*ZzX&N{ZWA]Q*M:CA\";i:1441;s:247:\"oCR*^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0LvSQ[zvAbLrt,ub@=15Fm!LvSQ[zWC1Ws8qI:$vb\"Ie\"xd`Q3nE3pB$A^DSOYMj<e\"NAf+?hT?GUO[0kXL{eVElg*NNK9JlBTP.4FxrjYB2A2W~AyD1+ITJ\"Etp1`Q3nE30ojn5FvzLvpb[zQB3(=1~Ei\"@\",ub@y2xWQt95`Q3nE30oa]6FE0LvSQ[zFFyWA\";i:1442;s:15:\"A^>hT?GUO[|;aLA\";i:1443;s:46:\"eS=hT?GURIlBzL.4FxrjBAvW=hT?GURIlB7L.4FxrjBABA\";i:1444;s:12:\"9M=hT?GUpA$A\";i:1445;s:49:\"vP>hT?GU}jYByWmt,ub@=1GFRt;BJHNzijPV$A=CSOYM)ZBtA\";i:1446;s:13:\"9M=hT?GU=ElBA\";i:1447;s:46:\"eS=hT?GURIlBzL.4FxrjbAvW=hT?GURIlB7L.4FxrjBABA\";i:1448;s:25:\"`X>hT?GU5A$AWDSOYM*+:WlBA\";i:1449;s:46:\"eS=hT?GUHGlBzL.4FxrjBAvW=hT?GU?OlB7L.4FxrjBABA\";i:1450;s:15:\"z:>hT?GUO[h=aLA\";i:1451;s:29:\"0:>hT?GUO[+>aLpVVElg*NNK,rlBA\";i:1452;s:12:\"EH=hT?GUpA$A\";i:1453;s:52:\"eS>hT?GUMHlBRN.4Fx}MKApI=hT?GU4DlB@M.4?zs@SAq1~R0ACA\";i:1454;s:13:\"EH@hT?GU%IlBA\";i:1455;s:13:\"Qj>hT?GU%IlBA\";i:1456;s:30:\"tP>hT?IU4DlBrz=)5F>WzXJI{ZBACA\";i:1457;s:15:\"i=>hT?GUO[1[aLA\";i:1458;s:58:\"8r?hT?GU}jhBz(ht,ub@cY5FWuLvSQ[zGAG\"#(k)NoOM:CbXzXJI{ZDACA\";i:1459;s:13:\"9M=hT?GU4DlBA\";i:1460;s:55:\"w8=hT?KUTClB&!BA(a6Ay\",\",ub@d*5FFxLvSQ[zHBIAkt,ub@d*5FA\";i:1461;s:94:\"og=hT?GUhIlB,L.4Fxs@LA1k=hT?GUhIlB@M.4?zrjBAq1LDlB9FkcwY\"cC\"UE_Q3nE3UAgAnBJHNzApvWvDqI:$vbKAQA\";i:1462;s:105:\"pg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgA7BJHNzRm9(!A[Q>hT?GUO[\"]aL&\"LvSQ[zCA/hht,ub@uC5F%tLvSQ[zUAc4ht,ub@uC5FA\";i:1463;s:35:\"jg=hT?GU$LlB,L.4Fx~5QA1k=hT?GU$LlBA\";i:1464;s:68:\"gS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuW{eqI:$vblLgA=BJHNzijsW$A\";i:1465;s:15:\"9M=hT?GUO[e+ZLA\";i:1466;s:37:\"v8=hT?GUGJlBfL.4Fx~5AA<v?hT?GUO[XLXLA\";i:1467;s:13:\"(a>hT?GU[IlBA\";i:1468;s:48:\"eS=hT?GUO[95ZLqCVElg*NFAIAit,ub@/B5F2uLvSQ[zCAEA\";i:1469;s:48:\"eS=hT?GU~AlBzL.4Fx}MrY6FmuLvSQ[zqAbLit,ub@=10DQA\";i:1470;s:13:\"9M=hT?GUOBlBA\";i:1471;s:30:\"tP>hT?IU4DlBrz=)5FSazXJI{ZgACA\";i:1472;s:13:\"t8=hT?GUqNlBA\";i:1473;s:17:\"sP>hT?IU~AlBUoEAB\";i:1474;s:30:\"tP>hT?IU4DlBrz=)5FSazXJI{ZgACA\";i:1475;s:36:\"Xx?hT?GUO[XLXLBNVE^2*NNKcslB&!7\"jBIA\";i:1476;s:17:\"sP>hT?IU~AlBUoEAB\";i:1477;s:230:\"oCR*_\",ub@=15Fk0LvSQ[zvAc4jt,ub@,n5FRtLvSQ[zxAz(ht,ub@ff5FWuLvSQ[zFAG\"#(k)No9P:CbXzXJI|+CA]Q)(k)No`,,CK\"jt,ub@MI5FC6LvSQ[zGF\"C$A)DSOYM*+vnlB,P.4FxrjYBZBS\"\"\",ub@6e5Fb#LvSQ[z<A:>mt,ub@=15FvzLvpb[zsA/hvZ5FZdzXJI|+wCPLi\"~BJHNzRm9(RABA\";i:1478;s:189:\"oC_)_\",ub@=15Fk0LvSQ[zvAc4jt,ub@,n5FRtLvSQ[zxAz(ht,ub@ff5FWuLvSQ[zFAG\"#(k)No9P:CbXzXJI|+CA]Q)(k)No`,,CK\"jt,ub@MI5FC6LvSQ[zGF\"C$A)DSOYM*+vnlB,P.4FxrjYBZBS\"\"\",ub@6e5Fb#LvSQ[z<AbLut,ub@y2PcFtA\";i:1479;s:40:\"Sj?hT?GUqNlB;P.4FxrjYBbBRt~BJHNzRm8WRABA\";i:1480;s:13:\"Qj>hT?GU%IlBA\";i:1481;s:255:\"oC{u(\",ub@^D5FWuLvSQ[zUAG\"#(k)No|B:CbXzXJI{ZKAOc$(k)VomE:CnjDAr1ZBKCKGkcwYX`D\"gg_Q3nE3hB$AHDSOYM6|BtPj_Q3nE3HH$AJDSOYMWDGt~l_Q3nE3HH$ALDSOYMM%Bt.o_Q3nE3BB$ANDSOYMM%Bt3r_Q3nE3BB$APDSOYMM%Btmu_Q3nE3BB$ARDSOYMM%BtVx_Q3nE3BB$ATDSOYMM%BtMc_Q3nE3BB$AVDSOYM?IEtA\";i:1482;s:104:\"pg=hT?GUpA$A{CSOYMtOBtaS_Q3nE3UAgAsBJHNzijSU$A~CSOYM*+kolB|L.4Fx}M2,6FQwLvSQ[zDAbLjt,ub@uC5FgwLvSQ[zDAEA\";i:1483;s:12:\"EH=hT?GUpA$A\";i:1484;s:25:\"!M=hT?GUHGlBfL.4Fx}MJe6FA\";i:1485;s:12:\"9M=hT?GUpA$A\";i:1486;s:13:\"EH=hT?GURIlBA\";i:1487;s:25:\"5r?hT?GU}jhByWmt,ub@/B5FA\";i:1488;s:13:\"Qj>hT?GU%IlBA\";i:1489;s:47:\"1d>hT?GUpA$AEDSOYMLUEtJV`Q3nE3~R!AeZ>hT?GU[IlBA\";i:1490;s:147:\">a@hT?GUO[:CYLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GURIlBBN.4Fx~5LA$T>hT?GURIlBNN.4Fx~5LAvW@hT?GUO[PjaLVRVElg*NNKRdlBsQ.4Fx}M|_6Fj3LvSQ[zCAc4ot,ub@y2b4OtA\";i:1491;s:64:\",a@hT?GUO[=JYLpVVElg*NNKumlBRN.4FxrjMAw(@hT?GUO[jnaLyqVElg*NXAIA\";i:1492;s:38:\"N&@hT?GU~@iB/hot,ub@ph5F(3LvSQ[zGFXT$A\";i:1493;s:15:\"A^>hT?GUO[.oaLA\";i:1494;s:20:\"sP>hT?IU~@~A/h`,~BQA\";i:1495;s:45:\"vP=hT?GU5A$A=CSOYMLUBt8M_Q3nE3LD$A[CSOYMLUDtA\";i:1496;s:77:\"y8=hT?KUTClB&!BA(a6AxtxBJHNz5uwWaSqI:$vbxDi\"yBJHNz5uwWvDqI:$vb`Di\"mBJHNz{,wWA\";i:1497;s:47:\"+a>hT?GU[IlB#L.4Fx}M)96F2uLvSQ[zjA:>ht,ub@BZ5FA\";i:1498;s:70:\"JH=hT?GUaNlBjL.4Fx~5AAYL=hT?GU,GlBrL.4Fx~5AAZ4=hT?GUDClB:O.4FxrjYBQAIA\";i:1499;s:32:\"tP>hT?IU4DlBrz=)5FZdzXJI|+wC=JgA\";i:1500;s:57:\"&5=hT?GUDClBvL.4Fx~5AA$T=hT?GU~AlB3L.4Fx~5AAeZ=hT?GU~AlBA\";i:1501;s:15:\"z:@hT?GUO[muaLA\";i:1502;s:137:\"9:>hT?GUO[4}aLXrVElg*NNKznlBFN.4Fx~5MAI7=hT?GU{JlB@M.4?zrjGAq1H#AA5F=ZzXJI{ZzAP/%(k)No]AlB%N.4FxrjJAZ4=hT?GU\"NlBOO.4FxrjYBGEQA(\",ub@r75FA\";i:1503;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:1504;s:13:\"!5=hT?GUDClBA\";i:1505;s:47:\"1d>hT?GUpA$AEDSOYMLUEtJV`Q3nE3~R!AeZ>hT?GU[IlBA\";i:1506;s:147:\">a@hT?GUO[:CYLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GURIlBBN.4Fx~5LA$T>hT?GURIlBNN.4Fx~5LAvW@hT?GUO[PjaLVRVElg*NNKRdlBsQ.4Fx}M|_6Fj3LvSQ[zCAc4ot,ub@y2b4OtA\";i:1507;s:64:\",a@hT?GUO[=JYLpVVElg*NNKumlBRN.4FxrjMAw(@hT?GUO[jnaLyqVElg*NXAIA\";i:1508;s:38:\"N&@hT?GU~@iB/hot,ub@ph5F(3LvSQ[zGFXT$A\";i:1509;s:15:\"A^>hT?GUO[.oaLA\";i:1510;s:46:\"HH=hT?GU4DlBjL.4Fx~5AAYL=hT?GU4DlBrL.4Fx~5AABA\";i:1511;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:1512;s:28:\"tP>hT?GUNkmBXLHbVElg*N+PgA$A\";i:1513;s:96:\"iS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuW_)qI:$vbeAS\"<\",ub@=1LERt8BJHNzijwWCaqI/Twb]ARt!R3I$A\";i:1514;s:39:\"|)@hT?GUO[jnaLyqVElg*NXAJt)\",ub@y2`QBtA\";i:1515;s:15:\"Wx?hT?GUNk6FXLA\";i:1516;s:24:\"cS=hT?GU~AlB3L.4Fx}MFABA\";i:1517;s:13:\"!5=hT?GUDClBA\";i:1518;s:46:\"HH=hT?GU~AlBjL.4Fx~5AAYL=hT?GU~AlBrL.4Fx~5AABA\";i:1519;s:57:\"IH=hT?GU4DlBjL.4Fxs@AAYL=hT?GU4DlBrL.4Fxs@AA;C=hT?GUqNlBA\";i:1520;s:59:\"fS=hT?GU4DlBzL.4Fx~5AAvW=hT?GU4DlB7L.4Fx~5AAO/@hT?GUO[muaLA\";i:1521;s:100:\";a>hT?GU[IlBfL.4Fx~5KApI=hT?GUpA$A>CSOYMu7DtDH_Q3nE3UAgAoBJHNzWHuW_EqI:$vbKAQA)\",ub@/B5F2uLvSQ[zCAEA\";i:1522;s:30:\"u8=hT?GUGJlB@M.4?zrjHAq1~RrACA\";i:1523;s:145:\"!:>hT?GUO[4}aLXrVElg*NNKznlBFN.4Fx~5MAI7=hT?GU{JlB@M.4?z}MNAq1sotA]Q>hT?GU}j]AP/%(k)No]AlBBN.4Fx~5AAw(>hT?GU3GlBMM.4Fxs@TA6F?hT?GUpA$A>CSOYM)ZGtA\";i:1524;s:46:\"eS=hT?GUsHlBzL.4Fx~5AAvW=hT?GUYTlB7L.4Fx~5AABA\";i:1525;s:26:\"5r>hT?GUqNlB?P.4FxrjYBzBQA\";i:1526;s:26:\"ig?hT?GUqNlB?P.4FxrjYBvBQA\";i:1527;s:13:\"9M=hT?GU4DlBA\";i:1528;s:36:\"v8=hT?GUGJlB&O.4Fx}M|_6FU0LvSQ[zyAEA\";i:1529;s:147:\">a@hT?GUO[:CYLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GURIlBBN.4Fx~5LA$T>hT?GURIlBNN.4Fx~5LAvW@hT?GUO[PjaLVRVElg*NNKRdlBsQ.4Fx}M|_6Fj3LvSQ[zCAc4ot,ub@y2b4OtA\";i:1530;s:64:\",a@hT?GUO[=JYLpVVElg*NNKumlBRN.4FxrjMAw(@hT?GUO[jnaLyqVElg*NXAIA\";i:1531;s:38:\"N&@hT?GU~@iB/hot,ub@ph5F(3LvSQ[zGFXT$A\";i:1532;s:15:\"A^>hT?GUO[.oaLA\";i:1533;s:13:\"9M=hT?GU4DlBA\";i:1534;s:12:\"bS=hT?GUpA$A\";i:1535;s:13:\"_X=hT?GU3GlBA\";i:1536;s:13:\"!5=hT?GUDClBA\";i:1537;s:47:\"1d>hT?GUpA$AEDSOYMLUEtJV`Q3nE3~R!AeZ>hT?GU[IlBA\";i:1538;s:147:\">a@hT?GUO[:CYLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GURIlBBN.4Fx~5LA$T>hT?GURIlBNN.4Fx~5LAvW@hT?GUO[PjaLVRVElg*NNKRdlBsQ.4Fx}M|_6Fj3LvSQ[zCAc4ot,ub@y2b4OtA\";i:1539;s:64:\",a@hT?GUO[=JYLpVVElg*NNKumlBRN.4FxrjMAw(@hT?GUO[jnaLyqVElg*NXAIA\";i:1540;s:38:\"N&@hT?GU~@iB/hot,ub@ph5F(3LvSQ[zGFXT$A\";i:1541;s:15:\"A^>hT?GUO[.oaLA\";i:1542;s:48:\"HH=hT?GUO[SqYLFBVElg*NFAK\"ht,ub@jT5F[tLvSQ[zCAEA\";i:1543;s:13:\"9M=hT?GU4DlBA\";i:1544;s:27:\"zd>hT?GU~@RBFtht,ub@y2mnBtA\";i:1545;s:13:\">J=hT?GUOBlBA\";i:1546;s:13:\"bS=hT?GU4DlBA\";i:1547;s:15:\"i=>hT?GUO[3raLA\";i:1548;s:17:\"sP>hT?IU~AlBUoEAB\";i:1549;s:96:\"iS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuW_)qI:$vbeAS\"<\",ub@=1LERt8BJHNzijwWCaqI/Twb]ARt!R3I$A\";i:1550;s:13:\"i=>hT?GUhIlBA\";i:1551;s:15:\"i=>hT?GUO[3raLA\";i:1552;s:13:\"!5=hT?GUDClBA\";i:1553;s:69:\"gS=hT?GUOBlBzL.4Fx~5BAvW=hT?GUOBlB7L.4Fx~5BATq?hT?GU}jhBFtht,ub@~R5FA\";i:1554;s:56:\"ru>hT?GUqNlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMtOBt8M_Q3nE3UAgA\";i:1555;s:13:\"t8=hT?GUqNlBA\";i:1556;s:13:\"9M=hT?GUOBlBA\";i:1557;s:56:\"%M=hT?GU4DlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMtOBt8M_Q3nE3UAgA\";i:1558;s:23:\"Rj>hT?GU5A$AVDSOYMLUBtA\";i:1559;s:19:\"sP>hT?IUWJlBrz_#5FA\";i:1560;s:15:\"i=>hT?GUO[3raLA\";i:1561;s:56:\"ru>hT?GUqNlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMtOBt8M_Q3nE3UAgA\";i:1562;s:80:\"/a>hT?GU[IlB+O.4Fx}M@~6FGuLvSQ[zuA:>ht,ub@)g5FmuLvSQ[zuAbLit,ub@)g5FhtLvSQ[zUAEA\";i:1563;s:12:\"EH=hT?GUpA$A\";i:1564;s:12:\"(a=hT?GUpA$A\";i:1565;s:35:\"*a>hT?GUjSlBQM.4Fx}MTAZ4=hT?GUDClBA\";i:1566;s:46:\"HH=hT?GURIlBjL.4Fx~5AAYL=hT?GURIlBrL.4Fx~5AABA\";i:1567;s:13:\"sP>hT?GU^SlBA\";i:1568;s:13:\"9M=hT?GU4DlBA\";i:1569;s:36:\"v8=hT?GUGJlB&O.4Fx}M|_6FU0LvSQ[zyAEA\";i:1570;s:147:\">a@hT?GUO[:CYLkUVElg*NNK?DlBFN.4Fx}MaA1k>hT?GURIlBBN.4Fx~5LA$T>hT?GURIlBNN.4Fx~5LAvW@hT?GUO[PjaLVRVElg*NNKRdlBsQ.4Fx}M|_6Fj3LvSQ[zCAc4ot,ub@y2b4OtA\";i:1571;s:64:\",a@hT?GUO[=JYLpVVElg*NNKumlBRN.4FxrjMAw(@hT?GUO[jnaLyqVElg*NXAIA\";i:1572;s:38:\"N&@hT?GU~@iB/hot,ub@ph5F(3LvSQ[zGFXT$A\";i:1573;s:15:\"A^>hT?GUO[.oaLA\";i:1574;s:15:\"bS>hT?GUNkEHXLA\";i:1575;s:15:\"bS>hT?GUNkEHXLA\";i:1576;s:45:\"eS=hT?GUOBlBzL.4Fx}MBAvW=hT?GU/A$A^CSOYM)ZBtA\";i:1577;s:30:\"tP>hT?IU4DlBrz=)5F>WzXJI{ZqACA\";i:1578;s:31:\"!M=hT?GUpA$AUDSO}M*+oclBrzK95FA\";i:1579;s:60:\"IH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3so2AHO=hT?GUO[E0ZLPDVElg*NFAIA\";i:1580;s:15:\"i=?hT?GUNkpIbLA\";i:1581;s:83:\"4d>hT?GUNk>JXL&\"LvSQ[zCA/hht,ub@/B5F%tLvSQ[zCAc4ht,ub@/B5Fy6LvSQ[z@HQAi\"3BJHNz{,uWA\";i:1582;s:83:\"4d>hT?GUNkYLXL&\"LvSQ[zCA/hht,ub@/B5F%tLvSQ[zCAc4ht,ub@/B5Fy6LvSQ[z@HQAi\"3BJHNz{,vWA\";i:1583;s:97:\"5d>hT?GUNk>JXL&\"LvSQ[zCA/hht,ub@/B5F%tLvSQ[zCAc4ht,ub@/B5Fy6LvSQ[z@HQAi\"3BJHNz*:vW}4qI:$vbaU&6:CA\";i:1584;s:83:\"4d>hT?GUNk>JXL&\"LvSQ[zCA/hht,ub@/B5F%tLvSQ[zCAc4ht,ub@/B5Fy6LvSQ[z@HQAi\"3BJHNzzgxWA\";i:1585;s:46:\"eS=hT?GU~AlBzL.4Fx}MFAvW=hT?GUtElB7L.4Fx}MFABA\";i:1586;s:190:\"oC^X,\",ur@<I5F>+GA_QzCUEUM.4Fxs@DA%$=hT?GU(ClBcM.4Fxs@DAf+=hT?GU^ClBkM.4Fx}MEA};=hT?GU^ClBsM.4FxrjUA2[=hT?GUvOlB0M.4FxrjUAU|=hT?GUDClB8M.4Fxs@CA;C>hT?GUDClB)M.4Fxs@CApI>hT?GUDClB<M.4Fxs@CABA\";i:1587;s:13:\"9M=hT?GUSFlBA\";i:1588;s:13:\"EH@hT?GU%IlBA\";i:1589;s:13:\"9M=hT?GU=ElBA\";i:1590;s:15:\"i=>hT?GUNk9MXLA\";i:1591;s:57:\"V@>hT?GU4TlBvL.4FxrjJA$T=hT?GU4DlB3L.4Fx}MFAeZ=hT?GU4DlBA\";i:1592;s:12:\"9M=hT?GUpA$A\";i:1593;s:35:\"v8=hT?GUGJlBdN.4Fx}MTAHO?hT?GUqNlBA\";i:1594;s:13:\"t8=hT?GUqNlBA\";i:1595;s:24:\"u8=hT?GUGJlBaO.4Fx}M^ABA\";i:1596;s:71:\"IH=hT?GU}j@A]Q#(k)No`,*BK\"ht,ub@=1wDRtnBJHNzijMO$AEDSO9Nj<Bt&a6Aht!R*hA\";i:1597;s:68:\"Vj>hT?GU%IlBdN.4Fx}MTA[Q=hT?GU4zlBzL.4Fx~5$AvW=hT?GU@7lB7L.4Fx~5$ABA\";i:1598;s:108:\"MH=hT?GUpA$A=CSOYMj<e\"0AYL=hT?GUpA$A?CSOYMj<e\"0A[Q=hT?GUNkHOXLqCVElg*NFAIAit,ub@=10DRtpBJHNzWHuWwwqI:$vb4OgA\";i:1599;s:135:\"48=hT?GUGJlBRN.4Fxs@$AHO>hT?GUDylB6O.4Fx}MH)6FGuLvSQ[zJD3((\",ub@/B7FmuLvSQ[zJD2W)\",ub@/B7FhtLvSQ[zCA/hht,ub@jT5F%tLvSQ[zCAc4ht,ub@jT5FA\";i:1600;s:13:\"Qj>hT?GU%IlBA\";i:1601;s:67:\"xP>hT?GUOBlBFN.4Fx~5MA6F=hT?GUOBlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:1602;s:58:\",a>hT?GU[IlB/N.4Fx~5bAI7=hT?GUGJlBRN.4FxrjMA[Q>hT?GU~@QBEA\";i:1603;s:105:\"18=hT?GUGJlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMAlCt8M_Q3nE3UAgAmBJHNzWHuWKCqI:$vbaU=/:C>WzXJI{ZBAOc#(k)Noa.7y0WA\";i:1604;s:22:\"t8=hT?KUTClB&!BA(a6AwA\";i:1605;s:101:\"18=hT?GUGJlBRN.4FxrjMA6F=hT?GU=ElBjL.4Fxs@GAYL=hT?GU=ElBrL.4Fxs@GAZ4=hT?GUDClBdN.4Fx}MTAHO>hT?GU:NlBA\";i:1606;s:26:\"5r>hT?GUqNlB?P.4Fxrj}BWAIA\";i:1607;s:49:\"eS?hT?GUO[>2bLBNVElg*N8BRt;BJHNzij*T$AsDSOYM*+VtA\";i:1608;s:13:\"sP?hT?GUqNlBA\";i:1609;s:142:\"yu?hT?GU~@hByWht,ub@=10DRtmBJHNzijcO$A>CSOYM*+YclBrL.4Fx}MrY6FGuLvSQ[zCA:>ht,ub@/B5FmuLvSQ[zGAbLit,ub@/B5FU0LvSQ[zyA:>mt,ub@=15F51LvSQ[z@HFB$A\";i:1610;s:13:\"4r>hT?GUqNlBA\";i:1611;s:13:\"sP?hT?GUr6lBA\";i:1612;s:26:\"u8=hT?GUGJlBnL.4Fxrj}BUAIA\";i:1613;s:80:\"y8=hT?GUGJlBvL.4Fxrj}B=FRtoBJHNzRmXt&AvW=hT?GUNkHObLPDVElg*N+P+ulBdN.4Fxrj}B^FQA\";i:1614;s:37:\"GH@hT?GUpA$AeDSOYM*+Ft95`Q3nE30o`x5FA\";i:1615;s:26:\"5r>hT?GUqNlB?P.4FxrjYBzBQA\";i:1616;s:13:\"t8=hT?GUGJlBA\";i:1617;s:12:\"9M=hT?GUpA$A\";i:1618;s:35:\"v8=hT?GUGJlBdN.4Fx}MTAHO?hT?GUqNlBA\";i:1619;s:13:\"t8=hT?GUqNlBA\";i:1620;s:35:\"v8=hT?GUzClBcM.4Fx~5YAHO?hT?GUr6lBA\";i:1621;s:66:\"IH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuW+OqI:$wb2ARt!RuW#zOAMA\";i:1622;s:69:\"su=hT?GU~@XB:>mt,ub@=15FGuLvSQ[z9D3((\",ub@/B7FmuLvSQ[zJD2W)\",ub@/B7FA\";i:1623;s:108:\"MH=hT?GUpA$A=CSOYMj<e\"0AYL=hT?GUpA$A?CSOYMj<e\"0A[Q=hT?GUNkHOXLqCVElg*NFAIAit,ub@=10DRtpBJHNzWHuWwwqI:$vb4OgA\";i:1624;s:113:\"1P>hT?GUDylB6O.4Fx}MH)6FGuLvSQ[zJD3((\",ub@/B7FmuLvSQ[zJD2W)\",ub@/B7FhtLvSQ[zCA/hht,ub@jT5F%tLvSQ[zCAc4ht,ub@jT5FA\";i:1625;s:13:\"Qj>hT?GU%IlBA\";i:1626;s:67:\"xP>hT?GUOBlBFN.4Fx~5MA6F=hT?GUOBlBjL.4Fx~5AAYL=hT?GUpA$A?CSOYMtOBtA\";i:1627;s:58:\",a>hT?GU[IlB/N.4Fx~5bAI7=hT?GUGJlBRN.4FxrjMA[Q>hT?GU~@QBEA\";i:1628;s:105:\"18=hT?GUGJlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMAlCt8M_Q3nE3UAgAmBJHNzWHuWKCqI:$vbaU=/:C>WzXJI{ZBAOc#(k)Noa.7y0WA\";i:1629;s:22:\"t8=hT?KUTClB&!BA(a6AwA\";i:1630;s:101:\"18=hT?GUGJlBRN.4FxrjMA6F=hT?GU=ElBjL.4Fxs@GAYL=hT?GU=ElBrL.4Fxs@GAZ4=hT?GUDClBdN.4Fx}MTAHO>hT?GU:NlBA\";i:1631;s:26:\"5r>hT?GUqNlB?P.4Fxrj}BWAIA\";i:1632;s:49:\"eS?hT?GUO[>2bLBNVElg*N8BRt;BJHNzij*T$AsDSOYM*+VtA\";i:1633;s:13:\"sP?hT?GUqNlBA\";i:1634;s:142:\"yu?hT?GU~@hByWht,ub@=10DRtmBJHNzijcO$A>CSOYM*+YclBrL.4Fx}MrY6FGuLvSQ[zCA:>ht,ub@/B5FmuLvSQ[zGAbLit,ub@/B5FU0LvSQ[zyA:>mt,ub@=15F51LvSQ[z@HFB$A\";i:1635;s:13:\"4r>hT?GUqNlBA\";i:1636;s:13:\"sP?hT?GUr6lBA\";i:1637;s:58:\"x8=hT?GUGJlBfL.4Fx~5AApI=hT?GU/A$A>CSOYM*+9dlBrL.4Fx}MBABA\";i:1638;s:80:\"y8=hT?GUGJlBvL.4Fxrj}B=FRtoBJHNzRmXt&AvW=hT?GUNkHObLPDVElg*N+P+ulBdN.4Fxrj}B^FQA\";i:1639;s:37:\"GH@hT?GUpA$AeDSOYM*+Ft95`Q3nE30o`x5FA\";i:1640;s:26:\"5r>hT?GUqNlB?P.4FxrjYBzBQA\";i:1641;s:13:\"t8=hT?GUGJlBA\";i:1642;s:12:\"EH@hT?GUpA$A\";i:1643;s:26:\"5r>hT?GUqNlB?P.4FxrjYBvBQA\";i:1644;s:13:\"4r>hT?GUr6lBA\";i:1645;s:74:\"JH@hT?GUpA$A@CSOYMj<cAXA$T=hT?GUOBlB3L.4FxrjYBCCRtpBJHNzRmOAf\"5F_Q3nE36G$A\";i:1646;s:53:\"vP?hT?GUNk$TbL3rVElg*NNKT|lB0Q.4FxrjYB_KS\"\"\",ub@/B5FA\";i:1647;s:35:\"#M=hT?GU:NlBrL.4Fx~5AAvW@hT?GUqNlBA\";i:1648;s:48:\"7r>hT?GUqNlB{O.4Fxrj}BeA2W]\",ub@/B5FhtLvSQ[zCAEA\";i:1649;s:13:\"4r>hT?GUqNlBA\";i:1650;s:118:\"Yj>hT?GUNkvWXLKCVElg*N+P\"ClBzL.4Fxrj}BkAIAit,ub@y2`QCt8M_Q3nE3H#8M5FZ1LvSQ[z<Ac4lt,ub@!S5Fk0LvSQ[zGFzP$A$DSOYMj<cACABA\";i:1651;s:26:\"Rj>hT?GUO[8MaLmOVElg*NKBQA\";i:1652;s:245:\"oCQY<\",ub@x/5FT3LvSQ[z@H*B$A2DSOYMj<dtaAP/((k)No`,qCJt`\",ub@=1`ERtvBJHNzM*vWxdqI:$vbICi\"=BJHNzijwW5*qI:$vb\"Ie\"{e`Q3nE3~R4AI7?hT?GU^ClB7P.4FxrjYBRBRt[BJHNzRmPtGAw(?hT?GUO[h=XL7fVElg*NNK)ElB#P.4FxrjYBVBS\"~AyD1+ITJ\"EtE0_Q3nF32C$AijRPlB}GkcwYtz<3:CA\";i:1653;s:13:\"sP?hT?GUqNlBA\";i:1654;s:13:\"4r>hT?GUqNlBA\";i:1655;s:73:\"(5=hT?GUDClBvL.4Fx~5$A$T=hT?GU:tlB3L.4Fx~5$AeZ=hT?GU:tlB@M.4?z}MLAq1iGlBA\";i:1656;s:146:\"bj?hT?GUqNlBQM.4!2}MDAq1RBlBA]Bt|e_Q3nE38I$AGDSOYMtOHt*h_Q3nE38I$ARDSOYMM%BtVx_Q3nE3BB$ATDSOYMM%Btjn_Q3nE3BB$AMDSOYMM%BtSq_Q3nE3BB$A}DSOYMj<ttKACA\";i:1657;s:114:\"0P>hT?IUiFlB&!7\"OAc4%(k)Noa.^9uWO2qI:$vb\"Ie\"rP`Q3nE3&G$A<CSOYMtOBtUE_Q3nE3UAgAnBJHNzWHuWvDqI:$vbKARt~BJHNzRm)WFABA\";i:1658;s:43:\"uP>hT?IU<HlBqGJAbS`Q3nE3~R8AeZ@hT?GUNkydXLA\";i:1659;s:22:\"t8=hT?KUTClB&!BA(a6AwA\";i:1660;s:13:\"hg?hT?GUqNlBA\";i:1661;s:13:\"(a=hT?GUS1lBA\";i:1662;s:14:\"EH=hT?GU}j]ACA\";i:1663;s:57:\"fS=hT?GUQLlBzL.4Fxs@PAvW=hT?GUQLlB7L.4Fxs@PAYL=hT?GU3GlBA\";i:1664;s:13:\"9M=hT?GUQLlBA\";i:1665;s:13:\"9M=hT?GUQLlBA\";i:1666;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:1667;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:1668;s:12:\"sP=hT?GUpA$A\";i:1669;s:112:\"<a>hT?GU[IlBvL.4Fx~5AA$T=hT?GUpA$A]CSOYMtOBt8M_Q3nE3WC$A<CSOYMtOBtUE_Q3nE3UAgAnBJHNzijNT$A?CSOYMtOBt~l`Q3nE3&G$A\";i:1670;s:94:\":a>hT?GUjSlBVN.4Fx}MBAvW>hT?GUpA$ApDSOYMj<ttLAln((k)Noa.x(uWCaqI:$vbWAS\"<\",ub@ph5FxtLvSQ[zUAEA\";i:1671;s:13:\"t8=hT?GUqNlBA\";i:1672;s:119:\"NH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3H#1R5F[tLvSQ[zCAbLmt,ub@zj5FGuLvSQ[z@HSC$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWggqI:$vbxfNJ:CA\";i:1673;s:76:\"4:>hT?GUO[{eXLmOVElg*NbCQA=\",ub@y2{9Ctp1_Q3nE3sogA1k>hT?GUO[dZaLGOVElg*NFAIA\";i:1674;s:13:\"t8=hT?GUqNlBA\";i:1675;s:100:\";a>hT?GU[IlBvL.4Fx~5LA$T=hT?GURIlB3L.4Fx~5LAeZ=hT?GUtElBfL.4Fx~5AApI=hT?GUpA$A>CSOYMWDFtDH_Q3nE3UAgA\";i:1676;s:255:\"oCZ*^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0LvSQ[zvAbLrt,ub@=15Fm!LvSQ[zWC1Ws8qI:$vb\"Ie\"xd`Q3nE3pB$A^DSOYMj<e\"NAf+?hT?GUO[0kXL{eVElg*NNK9JlBTP.4FxrjYB2A2W~AyD1+ITJ\"Etp1`Q3nE30ojn5FT3LvSQ[z@HqC$AXDSOYMu7Ctb#_Q3nE3!C$AYDSOYMXwHtE0_Q3nF32C$AijRPlBA\";i:1677;s:62:\"wP>hT?IUSFlBrz*85F!WzXJI{ZBA]Q#(k)No]AlBnL.4FxrjaAHO=hT?GUpA$A\";i:1678;s:45:\"eS=hT?GU/A$A[CSOYMtOBtXL_Q3nE3WC$A^CSOYMtOBtA\";i:1679;s:50:\"HH=hT?GUNk/oXLFBVElg*NFAK\"ht,ub@y2S/CtDH_Q3nE3UAgA\";i:1680;s:19:\"sP>hT?IU4DlBrz=)5FA\";i:1681;s:92:\"iS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuW_)qI:$vbxfgAlB#L.4Fx~5NAw(>hT?GU2JlBdN.4Fx}MTABA\";i:1682;s:212:\"oC_)^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0Lvpb[zvA/hRT5F5dzXJI{ZmA]Q*(k)No`,qCJt|\",ub@=1`ERt?BJHNz5uuWe+qI:$vbaU\"S:CeezXJI|+wCNBgA[BJHNzRm9(NAO/?hT?GUO[~lXLvjVElg*NNK=JlB(P.4FxrjYBVBRt3BJHtz!PvWhNQBgA\";i:1683;s:68:\"xP?hT?GUqNlBFN.4Fx~5MA+h>hT?GU5A$AVDSOYMLUBtGO_Q3nE3\"!5AYL=hT?GU/A$A\";i:1684;s:233:\"oCB*^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,uj@,n5F>+ZAc4%(k)Ro&Q:C_MJeYLX7LvSQ[z<A/htt,ub@=1`ES\"|\",ub@=1`ERt?BJHNz5uuWe+qI:$vbaU\"S:CeezXJI|+wCNBgA[BJHNzRm9(NAO/?hT?GUO[~lXLvjVElg*NNK=JlB(P.4FxrjYBVBRt3BJHtzS^uWhNB.M\".oqI:$vbxfyK:CA\";i:1685;s:46:\"eS=hT?GU}DlBzL.4Fx~5FAvW=hT?GU}DlB7L.4Fx~5FABA\";i:1686;s:58:\"fS=hT?GU/A$A[CSOYMM%FtXL_Q3nE3sogAeZ=hT?GUaNlBJN.4Fx}MQABA\";i:1687;s:31:\"tP>hT?IU<HlBqGJA!5`Q3nE30oww5FA\";i:1688;s:37:\"*a>hT?GU[IlBvL.4FxrjHAeZ@hT?GUO[DHYLA\";i:1689;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:1690;s:19:\"sP>hT?IUaNlBrzm/5FA\";i:1691;s:13:\"!5=hT?GUDClBA\";i:1692;s:189:\"oC_)_\",ub@=15Fk0LvSQ[zvAc4jt,ub@,n5FRtLvSQ[zxAz(ht,ub@ff5FWuLvSQ[zFAG\"#(k)No9P:CbXzXJI|+CA]Q)(k)No`,,CK\"jt,ub@MI5FC6LvSQ[zGF\"C$A)DSOYM*+vnlB,P.4FxrjYBZBS\"\"\",ub@6e5Fb#LvSQ[z<AbLut,ub@y2PcFtA\";i:1693;s:26:\"ig?hT?GUqNlB?P.4FxrjYBvBQA\";i:1694;s:26:\"Rj?hT?GUqNlB;P.4FxrjYBbBQA\";i:1695;s:129:\"38=hT?GU{JlBRN.4Fx~5NA[Q>hT?GU2JlBJN.4Fxrj}B!AK\"jt,ub@MI5FW!LvSQ[z@HIAgAmBJHNzWHuWKCqI:$vbOAQA(\",ub@/B5F[tLvSQ[zDAbLut,ub@y2PcFtA\";i:1696;s:48:\"+a>hT?GU[IlBnL.4FxrjABa4+(k)Noa.;C1WFhqI:$vbhDgA\";i:1697;s:90:\"6:>hT?GUoTlBFN.4Fx}MaA|e>hT?GUpA$AbDSOYM?IEtp1_Q3nE3mC$AXDSOYMtOBt>2_Q3nE3UAi\"9BJHNzij1L$A\";i:1698;s:13:\"t8=hT?GUH2lBA\";i:1699;s:37:\"*a>hT?GU[IlBQM.4Fxs@MAeZ@hT?GUO[DHYLA\";i:1700;s:75:\"(5=hT?GUDClBvL.4Fx~5BA$T=hT?GUiFlB3L.4Fx~5BAeZ=hT?GUiFlB@M.4?z}M+X6F=Zm$wWA\";i:1701;s:13:\"t8=hT?GUqNlBA\";i:1702;s:12:\"hg>hT?GUpA$A\";i:1703;s:13:\"EH=hT?GUtElBA\";i:1704;s:13:\"9M=hT?GUOBlBA\";i:1705;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3WC$A^CSOYMtOBtA\";i:1706;s:116:\"NH@hT?GUNkmBXLhNVElg*NSBQA=\",ub@im5FZ1LvSQ[z<Az(ht,ub@/B5FWuLvSQ[zCAG\"#(k)No]AlB7L.4Fx~5AAZ4=hT?GUDClB?P.4FxrjYBvBQA\";i:1707;s:212:\"oC_)^\",ub@y2PcEtaS`Q3nE3~R4Akn?hT?GU}jVBc4jt,ub@,n5Fk0Lvpb[zvA/hRT5F5dzXJI{ZmA]Q*(k)No`,qCJt|\",ub@=1`ERt?BJHNz5uuWe+qI:$vbaU\"S:CeezXJI|+wCNBgA[BJHNzRm9(NAO/?hT?GUO[~lXLvjVElg*NNK=JlB(P.4FxrjYBVBRt3BJHtz!PvWhNQBgA\";i:1708;s:15:\"(a@hT?GUO[DHYLA\";i:1709;s:17:\"sP>hT?IU~AlBUoEAB\";i:1710;s:31:\"tP>hT?IU~AlBUoEA2[_Q3nE3H#uW5FA\";i:1711;s:13:\"t8=hT?GUqNlBA\";i:1712;s:15:\"z:>hT?GUNknuXLA\";i:1713;s:15:\"z:>hT?GUNk<vXLA\";i:1714;s:15:\"z:>hT?GUNkWxXLA\";i:1715;s:15:\"z:>hT?GUNk7yXLA\";i:1716;s:15:\"z:>hT?GUNkF0XLA\";i:1717;s:15:\"z:>hT?GUNkq1XLA\";i:1718;s:13:\"(a>hT?GU[IlBA\";i:1719;s:13:\"VE=hT?GU%IlBA\";i:1720;s:13:\"bS=hT?GU9ElBA\";i:1721;s:33:\"u8=hT?KUTClB&!BA(a6AwA(\",ub@/B5FA\";i:1722;s:13:\"t8=hT?GUqNlBA\";i:1723;s:48:\"eS=hT?GU}j_Aln#(k)No]AlB3L.4Fx}M#c6F2uLvSQ[zCAEA\";i:1724;s:104:\"18=hT?GU{JlB?L.4Fx}MCATq=hT?GUuBlB|L.4Fx}MCA+h>hT?GU}jYBc4rt,ub@7L5FZ1LvSQ[z<AbLnt,ub@ph5Fr#LvSQ[zGF~N$A\";i:1725;s:59:\"fS=hT?GU/A$A[CSOYMu7DtXL_Q3nE3kAi\"pBJHNz)dvWvDqI:$vbxf%N:CA\";i:1726;s:13:\"sP=hT?GUOBlBA\";i:1727;s:13:\"t8=hT?GUqNlBA\";i:1728;s:15:\"(a@hT?GUO[DHYLA\";i:1729;s:20:\"sP>hT?IU~@@A]Q~@{AEA\";i:1730;s:14:\"\"l?hT?GU}jVBEA\";i:1731;s:19:\"sP>hT?IUaNlBrzm/5FA\";i:1732;s:14:\"/o?hT?GU}jVBEA\";i:1733;s:92:\"LH=hT?GUaNlBvL.4Fx}MFA$T=hT?GU4DlB3L.4Fx}MFAeZ=hT?GU4DlBzP.4Fx~5KATq>hT?GUr6lB;P.4Fxrj}B@AIA\";i:1734;s:15:\"/o>hT?GUNk!5XLA\";i:1735;s:48:\"eS=hT?GU~@$Aln#(k)NocC:CTXzXJI{ZwCZLPDVElg*NNAIA\";i:1736;s:46:\"eS=hT?GU4DlBzL.4Fx~5AAvW=hT?GU4DlB7L.4Fx~5AABA\";i:1737;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3/B$A^CSOYMtOBtA\";i:1738;s:45:\"eS=hT?GU4DlBzL.4Fx~5AAvW=hT?GUpA$A^CSOYMtOBtA\";i:1739;s:13:\"R@>hT?GU4TlBA\";i:1740;s:101:\"08=hT?GU{JlB6O.4Fx}MH)6F&6LvSQ[zWC1W`xqI:$vbaU.I:C*ZzXJI{Z02aL{eVElg*NHA2W}\",ub@y2b4Ct0k`Q3nE30o\"S5FA\";i:1741;s:42:\"uP>hT?GUNkI7XL+OVElg*N+PzHlBuO.4Fxrj}B}AIA\";i:1742;s:13:\"sP>hT?GUALlBA\";i:1743;s:13:\"sP>hT?GUQLlBA\";i:1744;s:15:\"sP>hT?GUNkc#XLA\";i:1745;s:15:\"sP>hT?GUNk%$XLA\";i:1746;s:26:\"Rj>hT?GUNkL&XLDHVElg*NXAIA\";i:1747;s:37:\"*a=hT?GUpA$A?CSOYMj<sAMA2[@hT?GUqNlBA\";i:1748;s:13:\"(a>hT?GU[IlBA\";i:1749;s:64:\",a>hT?GUjSlBBN.4Fxrj}BHBQA=\",ub@y2H\"vW7fqI:$vbxf1R:CYYzXJI|+FACA\";i:1750;s:15:\"_X>hT?GUNk),XLA\";i:1751;s:80:\"gS=hT?GUNkO/XLqCVElg*N)PNtXL_Q3nE3H#Zl5F2uLvSQ[z?H0WFhqI:$vbxf\"S:CLfzXJI|+`DmCgA\";i:1752;s:13:\"nu>hT?GU\"NlBA\";i:1753;s:13:\"nu>hT?GUBIlBA\";i:1754;s:15:\">J=hT?GUNk,>XLA\";i:1755;s:15:\"sP=hT?GUNk,>XLA\";i:1756;s:13:\"nu>hT?GUBIlBA\";i:1757;s:13:\"nu>hT?GU\"NlBA\";i:1758;s:15:\">J=hT?GUNk,>XLA\";i:1759;s:15:\"sP=hT?GUNk,>XLA\";i:1760;s:29:\";`?hT?GUNkR@XLlhVElg*N+PCKlBA\";i:1761;s:29:\";`?hT?GUNk2[XLlhVElg*N+PSKlBA\";i:1762;s:29:\";`@hT?GUNkA^XLpVVElg*NNKXrlBA\";i:1763;s:29:\";`@hT?GUNkl_XLpVVElg*N+P&KlBA\";i:1764;s:29:\";`@hT?GUNkU|XLpVVElg*N+PHLlBA\";i:1765;s:28:\";`@hT?GUNkD\"5F(3LvSQ[z@H%F$A\";i:1766;s:29:\";`@hT?GUNk;CYLpVVElg*N+P,LlBA\";i:1767;s:13:\"5}@hT?GUqNlBA\";i:1768;s:70:\".a>hT?GU[IlBQM.4Fx}MOA+h>hT?GUALlB_M.4Fx~5PANc>hT?GUALlBuO.4FxrjYBOCQA\";i:1769;s:46:\"+a>hT?GUjSlBBN.4Fx~5AA+h>hT?GU%IlBMM.4Fxs@CABA\";i:1770;s:14:\"yd>hT?GU}jYBEA\";i:1771;s:13:\"sP>hT?GUALlBA\";i:1772;s:15:\"bS?hT?GUO[>2XLA\";i:1773;s:15:\"z:>hT?GUNk6FYLA\";i:1774;s:15:\"z:>hT?GUNkEHYLA\";i:1775;s:15:\"z:>hT?GUNkpIYLA\";i:1776;s:15:\"z:>hT?GUNk>JYLA\";i:1777;s:15:\"z:>hT?GUNkYLYLA\";i:1778;s:15:\"z:>hT?GUNk9MYLA\";i:1779;s:15:\"z:>hT?GUNkHOYLA\";i:1780;s:15:\"z:>hT?GUNksPYLA\";i:1781;s:15:\"z:>hT?GUNk[QYLA\";i:1782;s:15:\"z:>hT?GUNkbSYLA\";i:1783;s:15:\"z:>hT?GUNk$TYLA\";i:1784;s:15:\"z:>hT?GUNkKVYLA\";i:1785;s:15:\"z:>hT?GUNkvWYLA\";i:1786;s:15:\"z:>hT?GUNk_XYLA\";i:1787;s:15:\"z:>hT?GUNkeZYLA\";i:1788;s:15:\"z:>hT?GUNk(aYLA\";i:1789;s:15:\"z:>hT?GUNkNcYLA\";i:1790;s:15:\"z:>hT?GUNkydYLA\";i:1791;s:15:\"z:>hT?GUNk|eYLA\";i:1792;s:15:\"z:>hT?GUNkhgYLA\";i:1793;s:15:\"z:>hT?GUNk+hYLA\";i:1794;s:15:\"z:>hT?GUNkQjYLA\";i:1795;s:15:\"z:>hT?GUNk1kYLA\";i:1796;s:15:\"z:>hT?GUNk\"lYLA\";i:1797;s:15:\"z:>hT?GUNkknYLA\";i:1798;s:15:\"z:>hT?GUNk/oYLA\";i:1799;s:15:\"z:>hT?GUNkTqYLA\";i:1800;s:15:\"z:>hT?GUNk4rYLA\";i:1801;s:15:\"z:>hT?GUNkCtYLA\";i:1802;s:15:\"z:>hT?GUNknuYLA\";i:1803;s:15:\"z:>hT?GUNk<vYLA\";i:1804;s:15:\"z:>hT?GUNkWxYLA\";i:1805;s:15:\"z:>hT?GUNk7yYLA\";i:1806;s:15:\"z:>hT?GUNkF0YLA\";i:1807;s:15:\"z:>hT?GUNkq1YLA\";i:1808;s:15:\"z:>hT?GUNk?2YLA\";i:1809;s:15:\"z:>hT?GUNkZ4YLA\";i:1810;s:15:\"z:>hT?GUNk!5YLA\";i:1811;s:15:\"z:>hT?GUNkI7YLA\";i:1812;s:15:\"z:>hT?GUNkt8YLA\";i:1813;s:15:\"z:>hT?GUNk]9YLA\";i:1814;s:15:\"z:>hT?GUNkc#YLA\";i:1815;s:15:\"z:>hT?GUNk%$YLA\";i:1816;s:15:\"z:>hT?GUNkL&YLA\";i:1817;s:15:\"z:>hT?GUNkw(YLA\";i:1818;s:15:\"z:>hT?GUNk`)YLA\";i:1819;s:15:\"z:>hT?GUNkf+YLA\";i:1820;s:15:\"z:>hT?GUNk),YLA\";i:1821;s:15:\"z:>hT?GUNkO/YLA\";i:1822;s:15:\"z:>hT?GUNkz:YLA\";i:1823;s:15:\"z:>hT?GUNk};YLA\";i:1824;s:15:\"z:>hT?GUNki=YLA\";i:1825;s:15:\"z:>hT?GUNk,>YLA\";i:1826;s:15:\"z:>hT?GUNkR@YLA\";i:1827;s:15:\"z:>hT?GUNk2[YLA\";i:1828;s:15:\"z:>hT?GUNkA^YLA\";i:1829;s:15:\"z:>hT?GUNkl_YLA\";i:1830;s:15:\"z:>hT?GUNk:`YLA\";i:1831;s:15:\"z:>hT?GUNkU|YLA\";i:1832;s:15:\"z:>hT?GUNk5}YLA\";i:1833;s:15:\"z:>hT?GUNkBA6FA\";i:1834;s:15:\"z:>hT?GUNkmBZLA\";i:1835;s:15:\"z:>hT?GUNk;CZLA\";i:1836;s:15:\"z:>hT?GUNkVEZLA\";i:1837;s:15:\"z:>hT?GUNk6FZLA\";i:1838;s:15:\"z:>hT?GUNkEHZLA\";i:1839;s:15:\"z:>hT?GUNkpIZLA\";i:1840;s:15:\"z:>hT?GUNk>JZLA\";i:1841;s:15:\"z:>hT?GUNkYLZLA\";i:1842;s:15:\"z:>hT?GUNk9MZLA\";i:1843;s:15:\"z:>hT?GUNkHOZLA\";i:1844;s:15:\"z:>hT?GUNksPZLA\";i:1845;s:15:\"z:>hT?GUNk[QZLA\";i:1846;s:15:\"z:>hT?GUNkbSZLA\";i:1847;s:15:\"z:>hT?GUNk$TZLA\";i:1848;s:15:\"z:>hT?GUNkKVZLA\";i:1849;s:15:\"z:>hT?GUNkvWZLA\";i:1850;s:15:\"z:>hT?GUNk_XZLA\";i:1851;s:15:\"z:>hT?GUNkeZZLA\";i:1852;s:15:\"z:>hT?GUNk(aZLA\";i:1853;s:15:\"z:>hT?GUNkNcZLA\";i:1854;s:15:\"z:>hT?GUNkydZLA\";i:1855;s:15:\"z:>hT?GUNk|eZLA\";i:1856;s:15:\"z:>hT?GUNkhgZLA\";i:1857;s:15:\"z:>hT?GUNk+hZLA\";i:1858;s:15:\"z:>hT?GUNkQjZLA\";i:1859;s:15:\"z:>hT?GUNk1kZLA\";i:1860;s:15:\"z:>hT?GUNk\"lZLA\";i:1861;s:15:\"z:>hT?GUNkknZLA\";i:1862;s:15:\"z:>hT?GUNk/oZLA\";i:1863;s:15:\"z:>hT?GUNkTqZLA\";i:1864;s:15:\"z:>hT?GUNk4rZLA\";i:1865;s:15:\"z:>hT?GUNkCtZLA\";i:1866;s:15:\"z:>hT?GUNknuZLA\";i:1867;s:15:\"z:>hT?GUNk<vZLA\";i:1868;s:15:\"z:>hT?GUNkWxZLA\";i:1869;s:15:\"z:>hT?GUNk7yZLA\";i:1870;s:15:\"z:>hT?GUNkF0ZLA\";i:1871;s:15:\"z:>hT?GUNkq1ZLA\";i:1872;s:15:\"z:>hT?GUNk?2ZLA\";i:1873;s:15:\"z:>hT?GUNkZ4ZLA\";i:1874;s:15:\"z:>hT?GUNk!5ZLA\";i:1875;s:15:\"z:>hT?GUNkI7ZLA\";i:1876;s:15:\"z:>hT?GUNkt8ZLA\";i:1877;s:15:\"z:>hT?GUNk]9ZLA\";i:1878;s:15:\"z:>hT?GUNkc#ZLA\";i:1879;s:15:\"z:>hT?GUNk%$ZLA\";i:1880;s:15:\"z:>hT?GUNkL&ZLA\";i:1881;s:15:\"z:>hT?GUNkw(ZLA\";i:1882;s:15:\"z:>hT?GUNk`)ZLA\";i:1883;s:15:\"z:>hT?GUNkf+ZLA\";i:1884;s:15:\"z:>hT?GUNk),ZLA\";i:1885;s:15:\"z:>hT?GUNkO/ZLA\";i:1886;s:15:\"z:>hT?GUNkz:ZLA\";i:1887;s:15:\"z:>hT?GUNk};ZLA\";i:1888;s:15:\"z:>hT?GUNki=ZLA\";i:1889;s:15:\"z:>hT?GUNk,>ZLA\";i:1890;s:15:\"z:>hT?GUNkR@ZLA\";i:1891;s:15:\"z:>hT?GUNk2[ZLA\";i:1892;s:15:\"z:>hT?GUNkA^ZLA\";i:1893;s:15:\"z:>hT?GUNkl_ZLA\";i:1894;s:15:\"z:>hT?GUNk:`ZLA\";i:1895;s:15:\"z:>hT?GUNkU|ZLA\";i:1896;s:15:\"z:>hT?GUNk5}ZLA\";i:1897;s:15:\"z:>hT?GUNkD\"6FA\";i:1898;s:15:\"z:>hT?GUNkmBaLA\";i:1899;s:15:\"z:>hT?GUNk;CaLA\";i:1900;s:15:\"z:>hT?GUNkVEaLA\";i:1901;s:15:\"z:>hT?GUNk6FaLA\";i:1902;s:15:\"z:>hT?GUNkEHaLA\";i:1903;s:15:\"z:>hT?GUNkpIaLA\";i:1904;s:15:\"z:>hT?GUNk>JaLA\";i:1905;s:15:\"z:>hT?GUNkYLaLA\";i:1906;s:15:\"z:>hT?GUNk9MaLA\";i:1907;s:15:\"z:>hT?GUNkHOaLA\";i:1908;s:15:\"z:>hT?GUNksPaLA\";i:1909;s:15:\"z:>hT?GUNk[QaLA\";i:1910;s:15:\"z:>hT?GUNkbSaLA\";i:1911;s:15:\"z:>hT?GUNk$TaLA\";i:1912;s:15:\"z:>hT?GUNkKVaLA\";i:1913;s:15:\"z:>hT?GUNkvWaLA\";i:1914;s:15:\"z:>hT?GUNk_XaLA\";i:1915;s:15:\"z:>hT?GUNkeZaLA\";i:1916;s:15:\"z:>hT?GUNk(aaLA\";i:1917;s:15:\"z:>hT?GUNkNcaLA\";i:1918;s:15:\"z:>hT?GUNkydaLA\";i:1919;s:15:\"z:>hT?GUNk|eaLA\";i:1920;s:15:\"z:>hT?GUNkhgaLA\";i:1921;s:15:\"z:>hT?GUNk+haLA\";i:1922;s:15:\"z:>hT?GUNkQjaLA\";i:1923;s:15:\"z:>hT?GUNk1kaLA\";i:1924;s:15:\"z:>hT?GUNk\"laLA\";i:1925;s:15:\"z:>hT?GUNkknaLA\";i:1926;s:15:\"z:>hT?GUNk/oaLA\";i:1927;s:15:\"z:>hT?GUNkTqaLA\";i:1928;s:15:\"z:>hT?GUNk4raLA\";i:1929;s:15:\"z:>hT?GUNkCtaLA\";i:1930;s:15:\"z:>hT?GUNknuaLA\";i:1931;s:15:\"z:>hT?GUNk<vaLA\";i:1932;s:15:\"z:>hT?GUNkWxaLA\";i:1933;s:15:\"z:>hT?GUNk7yaLA\";i:1934;s:15:\"z:>hT?GUNkF0aLA\";i:1935;s:15:\"z:>hT?GUNkq1aLA\";i:1936;s:15:\"z:>hT?GUNk?2aLA\";i:1937;s:15:\"z:>hT?GUNkZ4aLA\";i:1938;s:15:\"z:>hT?GUNk!5aLA\";i:1939;s:15:\"z:>hT?GUNkI7aLA\";i:1940;s:15:\"z:>hT?GUNkt8aLA\";i:1941;s:15:\"z:>hT?GUNk]9aLA\";i:1942;s:15:\"z:>hT?GUNkc#aLA\";i:1943;s:15:\"z:>hT?GUNk%$aLA\";i:1944;s:15:\"z:>hT?GUNkL&aLA\";i:1945;s:15:\"z:>hT?GUNkw(aLA\";i:1946;s:15:\"z:>hT?GUNk`)aLA\";i:1947;s:15:\"z:>hT?GUNkf+aLA\";i:1948;s:15:\"z:>hT?GUNk),aLA\";i:1949;s:15:\"z:>hT?GUNkO/aLA\";i:1950;s:15:\"z:>hT?GUNkz:aLA\";i:1951;s:15:\"z:>hT?GUNk};aLA\";i:1952;s:15:\"z:>hT?GUNki=aLA\";i:1953;s:15:\"z:>hT?GUNk,>aLA\";i:1954;s:15:\"z:>hT?GUNkR@aLA\";i:1955;s:15:\"z:>hT?GUNk2[aLA\";i:1956;s:15:\"z:>hT?GUNkA^aLA\";i:1957;s:15:\"z:>hT?GUNkl_aLA\";i:1958;s:15:\"z:>hT?GUNk:`aLA\";i:1959;s:15:\"z:>hT?GUNkU|aLA\";i:1960;s:15:\"z:>hT?GUNk5}aLA\";i:1961;s:15:\"z:>hT?GUO[BA5FA\";i:1962;s:15:\"z:>hT?GUO[mBXLA\";i:1963;s:15:\"z:>hT?GUO[;CXLA\";i:1964;s:15:\"z:>hT?GUO[VEXLA\";i:1965;s:15:\"z:>hT?GUO[6FXLA\";i:1966;s:15:\"z:>hT?GUO[EHXLA\";i:1967;s:15:\"z:>hT?GUO[pIXLA\";i:1968;s:15:\"z:>hT?GUO[>JXLA\";i:1969;s:15:\"z:>hT?GUO[YLXLA\";i:1970;s:15:\"z:>hT?GUO[9MXLA\";i:1971;s:15:\"z:>hT?GUO[HOXLA\";i:1972;s:15:\"z:>hT?GUO[sPXLA\";i:1973;s:15:\"z:>hT?GUO[[QXLA\";i:1974;s:15:\"z:>hT?GUO[bSXLA\";i:1975;s:15:\"z:>hT?GUO[$TXLA\";i:1976;s:15:\"z:>hT?GUO[KVXLA\";i:1977;s:15:\"z:>hT?GUO[vWXLA\";i:1978;s:15:\"z:>hT?GUO[_XXLA\";i:1979;s:15:\"z:>hT?GUO[eZXLA\";i:1980;s:15:\"z:>hT?GUO[(aXLA\";i:1981;s:15:\"z:>hT?GUO[NcXLA\";i:1982;s:15:\"z:>hT?GUO[ydXLA\";i:1983;s:15:\"z:>hT?GUO[|eXLA\";i:1984;s:15:\"z:>hT?GUO[hgXLA\";i:1985;s:15:\"z:>hT?GUO[+hXLA\";i:1986;s:15:\"z:>hT?GUO[QjXLA\";i:1987;s:15:\"z:>hT?GUO[1kXLA\";i:1988;s:15:\"z:>hT?GUO[\"lXLA\";i:1989;s:15:\"z:>hT?GUO[knXLA\";i:1990;s:15:\"z:>hT?GUO[/oXLA\";i:1991;s:15:\"z:>hT?GUO[TqXLA\";i:1992;s:15:\"z:>hT?GUO[4rXLA\";i:1993;s:15:\"z:>hT?GUO[CtXLA\";i:1994;s:15:\"z:>hT?GUO[nuXLA\";i:1995;s:15:\"z:>hT?GUO[<vXLA\";i:1996;s:15:\"z:>hT?GUO[WxXLA\";i:1997;s:15:\"z:>hT?GUO[7yXLA\";i:1998;s:15:\"z:>hT?GUO[F0XLA\";i:1999;s:15:\"z:>hT?GUO[q1XLA\";i:2000;s:15:\"z:>hT?GUO[?2XLA\";i:2001;s:15:\"z:>hT?GUO[Z4XLA\";i:2002;s:15:\"z:>hT?GUO[!5XLA\";i:2003;s:15:\"z:>hT?GUO[I7XLA\";i:2004;s:15:\"z:>hT?GUO[t8XLA\";i:2005;s:15:\"z:>hT?GUO[]9XLA\";i:2006;s:15:\"z:>hT?GUO[c#XLA\";i:2007;s:15:\"z:>hT?GUO[%$XLA\";i:2008;s:15:\"z:>hT?GUO[L&XLA\";i:2009;s:15:\"z:>hT?GUO[w(XLA\";i:2010;s:15:\"z:>hT?GUO[`)XLA\";i:2011;s:15:\"z:>hT?GUO[f+XLA\";i:2012;s:15:\"z:>hT?GUO[),XLA\";i:2013;s:15:\"z:>hT?GUO[O/XLA\";i:2014;s:15:\"z:>hT?GUO[jnXLA\";i:2015;s:15:\"z:>hT?GUO[z:XLA\";i:2016;s:15:\"z:>hT?GUO[};XLA\";i:2017;s:15:\"z:>hT?GUO[i=XLA\";i:2018;s:15:\"z:>hT?GUO[,>XLA\";i:2019;s:15:\"z:>hT?GUO[R@XLA\";i:2020;s:15:\"z:>hT?GUO[2[XLA\";i:2021;s:15:\"z:>hT?GUO[A^XLA\";i:2022;s:15:\"z:>hT?GUO[l_XLA\";i:2023;s:15:\"z:>hT?GUO[:`XLA\";i:2024;s:15:\"z:>hT?GUO[U|XLA\";i:2025;s:15:\"z:>hT?GUO[5}XLA\";i:2026;s:15:\"z:>hT?GUO[D\"5FA\";i:2027;s:15:\"z:>hT?GUO[mBYLA\";i:2028;s:15:\"z:>hT?GUO[;CYLA\";i:2029;s:15:\"z:>hT?GUO[VEYLA\";i:2030;s:15:\"z:>hT?GUO[6FYLA\";i:2031;s:15:\"z:>hT?GUO[EHYLA\";i:2032;s:15:\"z:>hT?GUO[pIYLA\";i:2033;s:15:\"z:>hT?GUO[>JYLA\";i:2034;s:15:\"z:>hT?GUO[YLYLA\";i:2035;s:15:\"z:>hT?GUO[9MYLA\";i:2036;s:15:\"z:>hT?GUO[HOYLA\";i:2037;s:15:\"z:>hT?GUO[sPYLA\";i:2038;s:15:\"z:>hT?GUO[[QYLA\";i:2039;s:15:\"z:>hT?GUO[bSYLA\";i:2040;s:15:\"z:>hT?GUO[$TYLA\";i:2041;s:15:\"z:>hT?GUO[KVYLA\";i:2042;s:15:\"z:>hT?GUO[vWYLA\";i:2043;s:15:\"z:>hT?GUO[_XYLA\";i:2044;s:15:\"z:>hT?GUO[eZYLA\";i:2045;s:15:\"z:>hT?GUO[(aYLA\";i:2046;s:15:\"z:>hT?GUO[NcYLA\";i:2047;s:15:\"z:>hT?GUO[ydYLA\";i:2048;s:15:\"z:>hT?GUO[|eYLA\";i:2049;s:15:\"z:>hT?GUO[hgYLA\";i:2050;s:15:\"z:>hT?GUO[+hYLA\";i:2051;s:15:\"z:>hT?GUO[QjYLA\";i:2052;s:15:\"z:>hT?GUO[1kYLA\";i:2053;s:15:\"z:>hT?GUO[\"lYLA\";i:2054;s:15:\"z:>hT?GUO[knYLA\";i:2055;s:15:\"z:>hT?GUO[/oYLA\";i:2056;s:15:\"z:>hT?GUO[TqYLA\";i:2057;s:15:\"z:>hT?GUO[4rYLA\";i:2058;s:15:\"z:>hT?GUO[CtYLA\";i:2059;s:15:\"z:>hT?GUO[nuYLA\";i:2060;s:15:\"z:>hT?GUO[<vYLA\";i:2061;s:15:\"z:>hT?GUO[WxYLA\";i:2062;s:15:\"z:>hT?GUO[7yYLA\";i:2063;s:15:\"z:>hT?GUO[F0YLA\";i:2064;s:15:\"z:>hT?GUO[q1YLA\";i:2065;s:15:\"z:>hT?GUO[?2YLA\";i:2066;s:15:\"z:>hT?GUO[Z4YLA\";i:2067;s:15:\"z:>hT?GUO[!5YLA\";i:2068;s:15:\"z:>hT?GUO[I7YLA\";i:2069;s:15:\"z:>hT?GUO[t8YLA\";i:2070;s:15:\"z:>hT?GUO[]9YLA\";i:2071;s:15:\"z:>hT?GUO[c#YLA\";i:2072;s:15:\"z:>hT?GUO[%$YLA\";i:2073;s:15:\"z:>hT?GUO[L&YLA\";i:2074;s:15:\"z:>hT?GUO[w(YLA\";i:2075;s:15:\"z:>hT?GUO[`)YLA\";i:2076;s:15:\"z:>hT?GUO[f+YLA\";i:2077;s:15:\"z:>hT?GUO[),YLA\";i:2078;s:15:\"z:>hT?GUO[O/YLA\";i:2079;s:15:\"z:>hT?GUO[z:YLA\";i:2080;s:15:\"z:>hT?GUO[};YLA\";i:2081;s:15:\"z:>hT?GUO[i=YLA\";i:2082;s:15:\"z:>hT?GUO[,>YLA\";i:2083;s:15:\"z:>hT?GUO[R@YLA\";i:2084;s:15:\"z:>hT?GUO[2[YLA\";i:2085;s:15:\"z:>hT?GUO[A^YLA\";i:2086;s:15:\"z:>hT?GUO[l_YLA\";i:2087;s:15:\"z:>hT?GUO[:`YLA\";i:2088;s:15:\"z:>hT?GUO[U|YLA\";i:2089;s:15:\"z:>hT?GUO[5}YLA\";i:2090;s:15:\"z:>hT?GUO[BA6FA\";i:2091;s:15:\"z:>hT?GUO[mBZLA\";i:2092;s:15:\"z:>hT?GUO[;CZLA\";i:2093;s:15:\"z:>hT?GUO[VEZLA\";i:2094;s:15:\"z:>hT?GUO[6FZLA\";i:2095;s:15:\"z:>hT?GUO[EHZLA\";i:2096;s:15:\"z:>hT?GUO[pIZLA\";i:2097;s:15:\"z:>hT?GUO[>JZLA\";i:2098;s:15:\"z:>hT?GUO[YLZLA\";i:2099;s:15:\"z:>hT?GUO[9MZLA\";i:2100;s:15:\"z:>hT?GUO[HOZLA\";i:2101;s:15:\"z:>hT?GUO[sPZLA\";i:2102;s:15:\"z:>hT?GUO[[QZLA\";i:2103;s:15:\"z:>hT?GUO[bSZLA\";i:2104;s:15:\"z:>hT?GUO[$TZLA\";i:2105;s:15:\"z:>hT?GUO[KVZLA\";i:2106;s:15:\"z:>hT?GUO[vWZLA\";i:2107;s:15:\"z:>hT?GUO[_XZLA\";i:2108;s:15:\"z:>hT?GUO[eZZLA\";i:2109;s:15:\"z:>hT?GUO[(aZLA\";i:2110;s:15:\"z:>hT?GUO[NcZLA\";i:2111;s:15:\"z:>hT?GUO[ydZLA\";i:2112;s:15:\"z:>hT?GUO[|eZLA\";i:2113;s:15:\"z:>hT?GUO[hgZLA\";i:2114;s:15:\"z:>hT?GUO[+hZLA\";i:2115;s:15:\"z:>hT?GUO[QjZLA\";i:2116;s:15:\"z:>hT?GUO[1kZLA\";i:2117;s:15:\"z:>hT?GUO[\"lZLA\";i:2118;s:15:\"z:>hT?GUO[knZLA\";i:2119;s:15:\"z:>hT?GUO[/oZLA\";i:2120;s:15:\"z:>hT?GUO[TqZLA\";i:2121;s:15:\"z:>hT?GUO[4rZLA\";i:2122;s:15:\"z:>hT?GUO[CtZLA\";i:2123;s:15:\"z:>hT?GUO[nuZLA\";i:2124;s:15:\"z:>hT?GUO[<vZLA\";i:2125;s:15:\"z:>hT?GUO[WxZLA\";i:2126;s:15:\"z:>hT?GUO[7yZLA\";i:2127;s:15:\"z:>hT?GUO[F0ZLA\";i:2128;s:15:\"z:>hT?GUO[q1ZLA\";i:2129;s:15:\"z:>hT?GUO[?2ZLA\";i:2130;s:15:\"z:>hT?GUO[Z4ZLA\";i:2131;s:15:\"z:>hT?GUO[!5ZLA\";i:2132;s:15:\"z:>hT?GUO[I7ZLA\";i:2133;s:15:\"z:>hT?GUO[t8ZLA\";i:2134;s:15:\"z:>hT?GUO[]9ZLA\";i:2135;s:15:\"z:>hT?GUO[c#ZLA\";i:2136;s:15:\"z:>hT?GUO[%$ZLA\";i:2137;s:15:\"z:>hT?GUO[L&ZLA\";i:2138;s:15:\"z:>hT?GUO[w(ZLA\";i:2139;s:15:\"z:>hT?GUO[`)ZLA\";i:2140;s:15:\"z:>hT?GUO[f+ZLA\";i:2141;s:15:\"z:>hT?GUO[),ZLA\";i:2142;s:15:\"z:>hT?GUO[O/ZLA\";i:2143;s:15:\"z:>hT?GUO[z:ZLA\";i:2144;s:15:\"z:>hT?GUO[};ZLA\";i:2145;s:15:\"z:>hT?GUO[i=ZLA\";i:2146;s:15:\"z:>hT?GUO[,>ZLA\";i:2147;s:15:\"z:>hT?GUO[R@ZLA\";i:2148;s:15:\"z:>hT?GUO[2[ZLA\";i:2149;s:15:\"z:>hT?GUO[A^ZLA\";i:2150;s:15:\"z:>hT?GUO[l_ZLA\";i:2151;s:15:\"z:>hT?GUO[:`ZLA\";i:2152;s:15:\"z:>hT?GUO[U|ZLA\";i:2153;s:15:\"z:>hT?GUO[5}ZLA\";i:2154;s:15:\"z:>hT?GUO[D\"6FA\";i:2155;s:15:\"z:>hT?GUO[mBaLA\";i:2156;s:15:\"z:>hT?GUO[;CaLA\";i:2157;s:15:\"z:>hT?GUO[VEaLA\";i:2158;s:15:\"z:>hT?GUO[6FaLA\";i:2159;s:15:\"z:>hT?GUO[EHaLA\";i:2160;s:15:\"z:>hT?GUO[pIaLA\";i:2161;s:15:\"z:>hT?GUO[>JaLA\";i:2162;s:15:\"z:>hT?GUO[YLaLA\";i:2163;s:15:\"z:>hT?GUO[9MaLA\";i:2164;s:15:\"z:>hT?GUO[HOaLA\";i:2165;s:15:\"z:>hT?GUO[sPaLA\";i:2166;s:15:\"z:>hT?GUO[[QaLA\";i:2167;s:15:\"z:>hT?GUO[bSaLA\";i:2168;s:15:\"z:>hT?GUO[$TaLA\";i:2169;s:15:\"z:>hT?GUO[KVaLA\";i:2170;s:15:\"z:>hT?GUO[vWaLA\";i:2171;s:15:\"z:>hT?GUO[_XaLA\";i:2172;s:15:\"z:>hT?GUO[eZaLA\";i:2173;s:15:\"z:>hT?GUO[(aaLA\";i:2174;s:15:\"z:>hT?GUO[NcaLA\";i:2175;s:15:\"z:>hT?GUO[ydaLA\";i:2176;s:15:\"z:>hT?GUO[|eaLA\";i:2177;s:15:\"z:>hT?GUO[hgaLA\";i:2178;s:15:\"z:>hT?GUO[+haLA\";i:2179;s:15:\"z:>hT?GUO[QjaLA\";i:2180;s:15:\"z:>hT?GUO[1kaLA\";i:2181;s:15:\"z:>hT?GUO[\"laLA\";i:2182;s:15:\"z:>hT?GUO[knaLA\";i:2183;s:15:\"z:>hT?GUO[/oaLA\";i:2184;s:15:\"z:>hT?GUO[TqaLA\";i:2185;s:15:\"z:>hT?GUO[4raLA\";i:2186;s:15:\"z:>hT?GUO[CtaLA\";i:2187;s:15:\"z:>hT?GUO[nuaLA\";i:2188;s:15:\"z:>hT?GUO[<vaLA\";i:2189;s:15:\"z:>hT?GUO[WxaLA\";i:2190;s:15:\"z:>hT?GUO[7yaLA\";i:2191;s:15:\"z:>hT?GUO[F0aLA\";i:2192;s:15:\"z:>hT?GUO[q1aLA\";i:2193;s:15:\"z:>hT?GUO[?2aLA\";i:2194;s:15:\"z:>hT?GUO[Z4aLA\";i:2195;s:15:\"z:>hT?GUO[!5aLA\";i:2196;s:15:\"z:>hT?GUO[I7aLA\";i:2197;s:15:\"z:>hT?GUO[t8aLA\";i:2198;s:15:\"z:>hT?GUO[]9aLA\";i:2199;s:15:\"z:>hT?GUO[c#aLA\";i:2200;s:15:\"z:>hT?GUO[%$aLA\";i:2201;s:15:\"z:>hT?GUO[L&aLA\";i:2202;s:15:\"z:>hT?GUO[w(aLA\";i:2203;s:15:\"z:>hT?GUO[`)aLA\";i:2204;s:15:\"z:>hT?GUO[f+aLA\";i:2205;s:15:\"z:>hT?GUO[),aLA\";i:2206;s:15:\"z:>hT?GUO[O/aLA\";i:2207;s:15:\"z:>hT?GUO[z:aLA\";i:2208;s:15:\"z:>hT?GUO[};aLA\";i:2209;s:15:\"z:>hT?GUO[i=aLA\";i:2210;s:15:\"z:>hT?GUO[,>aLA\";i:2211;s:15:\"z:>hT?GUO[R@aLA\";i:2212;s:15:\"z:>hT?GUO[2[aLA\";i:2213;s:15:\"z:>hT?GUO[A^aLA\";i:2214;s:15:\"z:>hT?GUO[l_aLA\";i:2215;s:15:\"z:>hT?GUO[:`aLA\";i:2216;s:15:\"z:>hT?GUO[U|aLA\";i:2217;s:15:\"z:>hT?GUO[5}aLA\";i:2218;s:15:\"z:>hT?GUNkCA5FA\";i:2219;s:15:\"z:>hT?GUNknBXLA\";i:2220;s:15:\"z:>hT?GUNk<CXLA\";i:2221;s:15:\"z:>hT?GUNkWEXLA\";i:2222;s:15:\"z:>hT?GUNk7FXLA\";i:2223;s:15:\"z:>hT?GUNkFHXLA\";i:2224;s:15:\"z:>hT?GUNkqIXLA\";i:2225;s:15:\"z:>hT?GUNk?JXLA\";i:2226;s:15:\"z:>hT?GUNkZLXLA\";i:2227;s:15:\"z:>hT?GUNk!MXLA\";i:2228;s:15:\"z:>hT?GUNkIOXLA\";i:2229;s:15:\"z:>hT?GUNktPXLA\";i:2230;s:15:\"z:>hT?GUNk]QXLA\";i:2231;s:15:\"z:>hT?GUNkcSXLA\";i:2232;s:15:\"z:>hT?GUNk%TXLA\";i:2233;s:15:\"z:>hT?GUNkLVXLA\";i:2234;s:15:\"z:>hT?GUNkwWXLA\";i:2235;s:15:\"z:>hT?GUNk`XXLA\";i:2236;s:15:\"z:>hT?GUNkfZXLA\";i:2237;s:15:\"z:>hT?GUNk)aXLA\";i:2238;s:15:\"z:>hT?GUNkOcXLA\";i:2239;s:15:\"z:>hT?GUNkzdXLA\";i:2240;s:15:\"z:>hT?GUNk}eXLA\";i:2241;s:15:\"z:>hT?GUNkigXLA\";i:2242;s:15:\"z:>hT?GUNk,hXLA\";i:2243;s:15:\"z:>hT?GUNkRjXLA\";i:2244;s:15:\"z:>hT?GUNk2kXLA\";i:2245;s:15:\"z:>hT?GUNkAmXLA\";i:2246;s:15:\"z:>hT?GUNklnXLA\";i:2247;s:15:\"z:>hT?GUNk:oXLA\";i:2248;s:15:\"z:>hT?GUNkUqXLA\";i:2249;s:15:\"z:>hT?GUNk5rXLA\";i:2250;s:15:\"z:>hT?GUNkDtXLA\";i:2251;s:15:\"z:>hT?GUNkouXLA\";i:2252;s:15:\"z:>hT?GUNk=vXLA\";i:2253;s:15:\"z:>hT?GUNkXxXLA\";i:2254;s:15:\"z:>hT?GUNk8yXLA\";i:2255;s:15:\"z:>hT?GUNkG0XLA\";i:2256;s:15:\"z:>hT?GUNkr1XLA\";i:2257;s:15:\"z:>hT?GUNk@2XLA\";i:2258;s:15:\"z:>hT?GUNka4XLA\";i:2259;s:15:\"z:>hT?GUNk#5XLA\";i:2260;s:15:\"z:>hT?GUNkJ7XLA\";i:2261;s:15:\"z:>hT?GUNku8XLA\";i:2262;s:15:\"z:>hT?GUNk^9XLA\";i:2263;s:15:\"z:>hT?GUNkd#XLA\";i:2264;s:15:\"z:>hT?GUNk&$XLA\";i:2265;s:15:\"z:>hT?GUNkM&XLA\";i:2266;s:15:\"z:>hT?GUNkx(XLA\";i:2267;s:15:\"z:>hT?GUNk{)XLA\";i:2268;s:15:\"z:>hT?GUNkg+XLA\";i:2269;s:15:\"z:>hT?GUNk*,XLA\";i:2270;s:15:\"z:>hT?GUNkP/XLA\";i:2271;s:15:\"z:>hT?GUNk0:XLA\";i:2272;s:15:\"z:>hT?GUNk~;XLA\";i:2273;s:15:\"z:>hT?GUNkj=XLA\";i:2274;s:15:\"z:>hT?GUNk.>XLA\";i:2275;s:15:\"z:>hT?GUNkS@XLA\";i:2276;s:15:\"z:>hT?GUNk3[XLA\";i:2277;s:15:\"z:>hT?GUNkB^XLA\";i:2278;s:15:\"z:>hT?GUNkm_XLA\";i:2279;s:15:\"z:>hT?GUNk;`XLA\";i:2280;s:15:\"z:>hT?GUNkV|XLA\";i:2281;s:15:\"z:>hT?GUNk6}XLA\";i:2282;s:15:\"z:>hT?GUNkE\"5FA\";i:2283;s:15:\"z:>hT?GUNknBYLA\";i:2284;s:15:\"z:>hT?GUNk<CYLA\";i:2285;s:15:\"z:>hT?GUNkWEYLA\";i:2286;s:15:\"z:>hT?GUNk7FYLA\";i:2287;s:15:\"z:>hT?GUNkFHYLA\";i:2288;s:15:\"z:>hT?GUNkqIYLA\";i:2289;s:15:\"z:>hT?GUNk?JYLA\";i:2290;s:15:\"z:>hT?GUNkZLYLA\";i:2291;s:15:\"z:>hT?GUNk!MYLA\";i:2292;s:15:\"z:>hT?GUNkIOYLA\";i:2293;s:15:\"z:>hT?GUNktPYLA\";i:2294;s:15:\"z:>hT?GUNk]QYLA\";i:2295;s:15:\"z:>hT?GUNkcSYLA\";i:2296;s:15:\"z:>hT?GUNk%TYLA\";i:2297;s:15:\"z:>hT?GUNkLVYLA\";i:2298;s:15:\"z:>hT?GUNkwWYLA\";i:2299;s:15:\"z:>hT?GUNk`XYLA\";i:2300;s:15:\"z:>hT?GUNkfZYLA\";i:2301;s:15:\"z:>hT?GUNk)aYLA\";i:2302;s:15:\"z:>hT?GUNkOcYLA\";i:2303;s:15:\"z:>hT?GUNkzdYLA\";i:2304;s:15:\"z:>hT?GUNk}eYLA\";i:2305;s:15:\"z:>hT?GUNkigYLA\";i:2306;s:15:\"z:>hT?GUNk,hYLA\";i:2307;s:15:\"z:>hT?GUNkRjYLA\";i:2308;s:15:\"z:>hT?GUNk2kYLA\";i:2309;s:15:\"z:>hT?GUNkAmYLA\";i:2310;s:15:\"z:>hT?GUNklnYLA\";i:2311;s:15:\"z:>hT?GUNk:oYLA\";i:2312;s:15:\"z:>hT?GUNkUqYLA\";i:2313;s:15:\"z:>hT?GUNk5rYLA\";i:2314;s:15:\"z:>hT?GUNkDtYLA\";i:2315;s:15:\"z:>hT?GUNkouYLA\";i:2316;s:15:\"z:>hT?GUNk=vYLA\";i:2317;s:15:\"z:>hT?GUNkXxYLA\";i:2318;s:15:\"z:>hT?GUNk8yYLA\";i:2319;s:15:\"z:>hT?GUNkG0YLA\";i:2320;s:15:\"z:>hT?GUNkr1YLA\";i:2321;s:15:\"z:>hT?GUNk@2YLA\";i:2322;s:15:\"z:>hT?GUNka4YLA\";i:2323;s:15:\"z:>hT?GUNk#5YLA\";i:2324;s:15:\"z:>hT?GUNkJ7YLA\";i:2325;s:15:\"z:>hT?GUNku8YLA\";i:2326;s:15:\"z:>hT?GUNk^9YLA\";i:2327;s:15:\"z:>hT?GUNkd#YLA\";i:2328;s:15:\"z:>hT?GUNk&$YLA\";i:2329;s:15:\"z:>hT?GUNkM&YLA\";i:2330;s:15:\"z:>hT?GUNkx(YLA\";i:2331;s:15:\"z:>hT?GUNk{)YLA\";i:2332;s:15:\"z:>hT?GUNkg+YLA\";i:2333;s:15:\"z:>hT?GUNk*,YLA\";i:2334;s:15:\"z:>hT?GUNkP/YLA\";i:2335;s:15:\"z:>hT?GUNk0:YLA\";i:2336;s:15:\"z:>hT?GUNk~;YLA\";i:2337;s:15:\"z:>hT?GUNkj=YLA\";i:2338;s:15:\"z:>hT?GUNk.>YLA\";i:2339;s:15:\"z:>hT?GUNkS@YLA\";i:2340;s:15:\"z:>hT?GUNk3[YLA\";i:2341;s:15:\"z:>hT?GUNkB^YLA\";i:2342;s:15:\"z:>hT?GUNkm_YLA\";i:2343;s:15:\"z:>hT?GUNk;`YLA\";i:2344;s:15:\"z:>hT?GUNkV|YLA\";i:2345;s:15:\"z:>hT?GUNk6}YLA\";i:2346;s:15:\"z:>hT?GUNkCA6FA\";i:2347;s:15:\"z:>hT?GUNknBZLA\";i:2348;s:15:\"z:>hT?GUNk<CZLA\";i:2349;s:15:\"z:>hT?GUNkWEZLA\";i:2350;s:15:\"z:>hT?GUNk7FZLA\";i:2351;s:15:\"z:>hT?GUNkFHZLA\";i:2352;s:15:\"z:>hT?GUNkqIZLA\";i:2353;s:15:\"z:>hT?GUNk?JZLA\";i:2354;s:15:\"z:>hT?GUNkZLZLA\";i:2355;s:15:\"z:>hT?GUNk!MZLA\";i:2356;s:15:\"z:>hT?GUNkIOZLA\";i:2357;s:15:\"z:>hT?GUNktPZLA\";i:2358;s:15:\"z:>hT?GUNk]QZLA\";i:2359;s:15:\"z:>hT?GUNkcSZLA\";i:2360;s:15:\"z:>hT?GUNk%TZLA\";i:2361;s:15:\"z:>hT?GUNkLVZLA\";i:2362;s:15:\"z:>hT?GUNkwWZLA\";i:2363;s:15:\"z:>hT?GUNk`XZLA\";i:2364;s:15:\"z:>hT?GUNkfZZLA\";i:2365;s:15:\"z:>hT?GUNk)aZLA\";i:2366;s:15:\"z:>hT?GUNkOcZLA\";i:2367;s:15:\"z:>hT?GUNkzdZLA\";i:2368;s:15:\"z:>hT?GUNk}eZLA\";i:2369;s:15:\"z:>hT?GUNkigZLA\";i:2370;s:15:\"z:>hT?GUNk,hZLA\";i:2371;s:15:\"z:>hT?GUNkRjZLA\";i:2372;s:15:\"z:>hT?GUNk2kZLA\";i:2373;s:15:\"z:>hT?GUNkAmZLA\";i:2374;s:15:\"z:>hT?GUNklnZLA\";i:2375;s:15:\"z:>hT?GUNk:oZLA\";i:2376;s:15:\"z:>hT?GUNkUqZLA\";i:2377;s:15:\"z:>hT?GUNk5rZLA\";i:2378;s:15:\"z:>hT?GUNkDtZLA\";i:2379;s:15:\"z:>hT?GUNkouZLA\";i:2380;s:15:\"z:>hT?GUNk=vZLA\";i:2381;s:15:\"z:>hT?GUNkXxZLA\";i:2382;s:15:\"z:>hT?GUNk8yZLA\";i:2383;s:15:\"z:>hT?GUNkG0ZLA\";i:2384;s:15:\"z:>hT?GUNkr1ZLA\";i:2385;s:15:\"z:>hT?GUNk@2ZLA\";i:2386;s:15:\"z:>hT?GUNka4ZLA\";i:2387;s:15:\"z:>hT?GUNk#5ZLA\";i:2388;s:15:\"z:>hT?GUNkJ7ZLA\";i:2389;s:15:\"z:>hT?GUNku8ZLA\";i:2390;s:15:\"z:>hT?GUNk^9ZLA\";i:2391;s:15:\"z:>hT?GUNkd#ZLA\";i:2392;s:15:\"z:>hT?GUNk&$ZLA\";i:2393;s:15:\"z:>hT?GUNkM&ZLA\";i:2394;s:15:\"z:>hT?GUNkx(ZLA\";i:2395;s:15:\"z:>hT?GUNk{)ZLA\";i:2396;s:15:\"z:>hT?GUNkg+ZLA\";i:2397;s:15:\"z:>hT?GUNk*,ZLA\";i:2398;s:15:\"z:>hT?GUNkP/ZLA\";i:2399;s:15:\"z:>hT?GUNk0:ZLA\";i:2400;s:15:\"z:>hT?GUNk~;ZLA\";i:2401;s:15:\"z:>hT?GUNkj=ZLA\";i:2402;s:15:\"z:>hT?GUNk.>ZLA\";i:2403;s:15:\"z:>hT?GUNkS@ZLA\";i:2404;s:15:\"z:>hT?GUNk3[ZLA\";i:2405;s:15:\"z:>hT?GUNkB^ZLA\";i:2406;s:15:\"z:>hT?GUNkm_ZLA\";i:2407;s:166:\"@a>hT?GUjSlBRN.4Fx}M)96F#zLvSQ[z{&0WUEqI:$vbKARtoBJHNzWHuW5FqI:$vbKARtpBJHNzWHuWlBqI:$vb\"IW\"UE_Q3nE3~RoAYL=hT?GU}j@AOc#(k)No`,*B3(`\",ub@=1qFRtACJHNzRm_WvATq>hT?GUpA$A\";i:2408;s:103:\";a>hT?GU~@ZBFtmt,ub@uC5F#zLvSQ[zDAyWht,ub@/B5FxtLvSQ[zCAFtht,ub@/B5F[tLvSQ[zCA:>qt,ub@=1wFRtACJHNzFKuWA\";i:2409;s:15:\"KV?hT?GUNkV|ZLA\";i:2410;s:53:\"NV?hT?GUNkV|ZLBNVElg*NXmPtaS`Q3nE30ob#5F&6LvSQ[zWC1WA\";i:2411;s:15:\"z:>hT?GUNk6}ZLA\";i:2412;s:15:\"z:>hT?GUNkE\"6FA\";i:2413;s:15:\"z:>hT?GUNknBaLA\";i:2414;s:15:\"z:>hT?GUNk<CaLA\";i:2415;s:15:\"z:>hT?GUNkWEaLA\";i:2416;s:15:\"z:>hT?GUNk7FaLA\";i:2417;s:15:\"z:>hT?GUNkFHaLA\";i:2418;s:15:\"z:>hT?GUNkqIaLA\";i:2419;s:15:\"z:>hT?GUNk?JaLA\";i:2420;s:15:\"z:>hT?GUNkZLaLA\";i:2421;s:15:\"z:>hT?GUNk!MaLA\";i:2422;s:15:\"z:>hT?GUNkIOaLA\";i:2423;s:15:\"z:>hT?GUNktPaLA\";i:2424;s:15:\"z:>hT?GUNk]QaLA\";i:2425;s:15:\"z:>hT?GUNkcSaLA\";i:2426;s:15:\"z:>hT?GUNk%TaLA\";i:2427;s:15:\"z:>hT?GUNkLVaLA\";i:2428;s:15:\"z:>hT?GUNkwWaLA\";i:2429;s:15:\"z:>hT?GUNk`XaLA\";i:2430;s:15:\"z:>hT?GUNkfZaLA\";i:2431;s:15:\"z:>hT?GUNk)aaLA\";i:2432;s:15:\"z:>hT?GUNkOcaLA\";i:2433;s:15:\"z:>hT?GUNkzdaLA\";i:2434;s:15:\"z:>hT?GUNk}eaLA\";i:2435;s:15:\"z:>hT?GUNkigaLA\";i:2436;s:15:\"z:>hT?GUNk,haLA\";i:2437;s:15:\"z:>hT?GUNkRjaLA\";i:2438;s:15:\"z:>hT?GUNk2kaLA\";i:2439;s:15:\"z:>hT?GUNkAmaLA\";i:2440;s:15:\"z:>hT?GUNklnaLA\";i:2441;s:15:\"z:>hT?GUNk:oaLA\";i:2442;s:15:\"z:>hT?GUNkUqaLA\";i:2443;s:15:\"z:>hT?GUNk5raLA\";i:2444;s:15:\"z:>hT?GUNkDtaLA\";i:2445;s:15:\"z:>hT?GUNkouaLA\";i:2446;s:15:\"z:>hT?GUNk=vaLA\";i:2447;s:15:\"z:>hT?GUNkXxaLA\";i:2448;s:15:\"z:>hT?GUNk8yaLA\";i:2449;s:15:\"z:>hT?GUNkG0aLA\";i:2450;s:15:\"z:>hT?GUNkr1aLA\";i:2451;s:15:\"z:>hT?GUNk@2aLA\";i:2452;s:15:\"z:>hT?GUNka4aLA\";i:2453;s:15:\"z:>hT?GUNk#5aLA\";i:2454;s:15:\"z:>hT?GUNkJ7aLA\";i:2455;s:15:\"z:>hT?GUNku8aLA\";i:2456;s:15:\"z:>hT?GUNk^9aLA\";i:2457;s:15:\"z:>hT?GUNkd#aLA\";i:2458;s:15:\"z:>hT?GUNk&$aLA\";i:2459;s:15:\"z:>hT?GUNkM&aLA\";i:2460;s:15:\"z:>hT?GUNkx(aLA\";i:2461;s:15:\"z:>hT?GUNk{)aLA\";i:2462;s:15:\"z:>hT?GUNkg+aLA\";i:2463;s:15:\"z:>hT?GUNk*,aLA\";i:2464;s:15:\"z:>hT?GUNkP/aLA\";i:2465;s:15:\"z:>hT?GUNk0:aLA\";i:2466;s:15:\"z:>hT?GUNk~;aLA\";i:2467;s:15:\"z:>hT?GUNkj=aLA\";i:2468;s:15:\"z:>hT?GUNk.>aLA\";i:2469;s:15:\"z:>hT?GUNkS@aLA\";i:2470;s:15:\"z:>hT?GUNk3[aLA\";i:2471;s:15:\"z:>hT?GUNkB^aLA\";i:2472;s:15:\"z:>hT?GUNkm_aLA\";i:2473;s:15:\"z:>hT?GUNk;`aLA\";i:2474;s:15:\"z:>hT?GUNkV|aLA\";i:2475;s:15:\"z:>hT?GUNk6}aLA\";i:2476;s:15:\"z:>hT?GUO[CA5FA\";i:2477;s:15:\"z:>hT?GUO[nBXLA\";i:2478;s:15:\"z:>hT?GUO[<CXLA\";i:2479;s:15:\"z:>hT?GUO[WEXLA\";i:2480;s:15:\"z:>hT?GUO[7FXLA\";i:2481;s:15:\"z:>hT?GUO[FHXLA\";i:2482;s:15:\"z:>hT?GUO[qIXLA\";i:2483;s:15:\"z:>hT?GUO[?JXLA\";i:2484;s:15:\"z:>hT?GUO[ZLXLA\";i:2485;s:15:\"z:>hT?GUO[!MXLA\";i:2486;s:15:\"z:>hT?GUO[IOXLA\";i:2487;s:15:\"z:>hT?GUO[tPXLA\";i:2488;s:15:\"z:>hT?GUO[]QXLA\";i:2489;s:15:\"z:>hT?GUO[cSXLA\";i:2490;s:15:\"z:>hT?GUO[%TXLA\";i:2491;s:15:\"z:>hT?GUO[LVXLA\";i:2492;s:15:\"z:>hT?GUO[wWXLA\";i:2493;s:15:\"z:>hT?GUO[`XXLA\";i:2494;s:15:\"z:>hT?GUO[fZXLA\";i:2495;s:15:\"z:>hT?GUO[)aXLA\";i:2496;s:15:\"z:>hT?GUO[OcXLA\";i:2497;s:15:\"z:>hT?GUO[zdXLA\";i:2498;s:15:\"z:>hT?GUO[}eXLA\";i:2499;s:15:\"z:>hT?GUO[igXLA\";i:2500;s:15:\"z:>hT?GUO[,hXLA\";i:2501;s:15:\"z:>hT?GUO[RjXLA\";i:2502;s:15:\"z:>hT?GUO[2kXLA\";i:2503;s:15:\"z:>hT?GUO[AmXLA\";i:2504;s:15:\"z:>hT?GUO[lnXLA\";i:2505;s:15:\"z:>hT?GUO[:oXLA\";i:2506;s:15:\"z:>hT?GUO[UqXLA\";i:2507;s:15:\"z:>hT?GUO[5rXLA\";i:2508;s:15:\"z:>hT?GUO[DtXLA\";i:2509;s:15:\"z:>hT?GUO[ouXLA\";i:2510;s:15:\"z:>hT?GUO[=vXLA\";i:2511;s:15:\"z:>hT?GUO[XxXLA\";i:2512;s:15:\"z:>hT?GUO[8yXLA\";i:2513;s:15:\"z:>hT?GUO[G0XLA\";i:2514;s:15:\"z:>hT?GUO[r1XLA\";i:2515;s:15:\"z:>hT?GUO[@2XLA\";i:2516;s:15:\"z:>hT?GUO[a4XLA\";i:2517;s:15:\"z:>hT?GUO[#5XLA\";i:2518;s:15:\"z:>hT?GUO[J7XLA\";i:2519;s:15:\"z:>hT?GUO[u8XLA\";i:2520;s:15:\"z:>hT?GUO[^9XLA\";i:2521;s:15:\"z:>hT?GUO[d#XLA\";i:2522;s:15:\"z:>hT?GUO[&$XLA\";i:2523;s:15:\"z:>hT?GUO[M&XLA\";i:2524;s:15:\"z:>hT?GUO[x(XLA\";i:2525;s:15:\"z:>hT?GUO[{)XLA\";i:2526;s:15:\"z:>hT?GUO[g+XLA\";i:2527;s:15:\"z:>hT?GUO[*,XLA\";i:2528;s:15:\"z:>hT?GUO[P/XLA\";i:2529;s:15:\"z:>hT?GUO[0:XLA\";i:2530;s:15:\"z:>hT?GUO[~;XLA\";i:2531;s:15:\"z:>hT?GUO[j=XLA\";i:2532;s:15:\"z:>hT?GUO[.>XLA\";i:2533;s:15:\"z:>hT?GUO[S@XLA\";i:2534;s:15:\"z:>hT?GUO[3[XLA\";i:2535;s:15:\"z:>hT?GUO[B^XLA\";i:2536;s:15:\"z:>hT?GUO[m_XLA\";i:2537;s:15:\"z:>hT?GUO[;`XLA\";i:2538;s:15:\"z:>hT?GUO[V|XLA\";i:2539;s:15:\"z:>hT?GUO[6}XLA\";i:2540;s:15:\"z:>hT?GUO[E\"5FA\";i:2541;s:15:\"z:>hT?GUO[nBYLA\";i:2542;s:15:\"z:>hT?GUO[<CYLA\";i:2543;s:15:\"z:>hT?GUO[WEYLA\";i:2544;s:15:\"z:>hT?GUO[7FYLA\";i:2545;s:15:\"z:>hT?GUO[FHYLA\";i:2546;s:15:\"z:>hT?GUO[qIYLA\";i:2547;s:15:\"z:>hT?GUO[?JYLA\";i:2548;s:15:\"z:>hT?GUO[ZLYLA\";i:2549;s:15:\"z:>hT?GUO[!MYLA\";i:2550;s:15:\"z:>hT?GUO[IOYLA\";i:2551;s:15:\"z:>hT?GUO[tPYLA\";i:2552;s:15:\"z:>hT?GUO[]QYLA\";i:2553;s:15:\"z:>hT?GUO[cSYLA\";i:2554;s:15:\"z:>hT?GUO[%TYLA\";i:2555;s:15:\"z:>hT?GUO[LVYLA\";i:2556;s:15:\"z:>hT?GUO[wWYLA\";i:2557;s:15:\"z:>hT?GUO[`XYLA\";i:2558;s:15:\"z:>hT?GUO[fZYLA\";i:2559;s:15:\"z:>hT?GUO[)aYLA\";i:2560;s:15:\"z:>hT?GUO[OcYLA\";i:2561;s:15:\"z:>hT?GUO[zdYLA\";i:2562;s:15:\"z:>hT?GUO[}eYLA\";i:2563;s:15:\"z:>hT?GUO[igYLA\";i:2564;s:15:\"z:>hT?GUO[,hYLA\";i:2565;s:15:\"z:>hT?GUO[RjYLA\";i:2566;s:15:\"z:>hT?GUO[2kYLA\";i:2567;s:15:\"z:>hT?GUO[AmYLA\";i:2568;s:15:\"z:>hT?GUO[lnYLA\";i:2569;s:15:\"z:>hT?GUO[:oYLA\";i:2570;s:15:\"z:>hT?GUO[UqYLA\";i:2571;s:15:\"z:>hT?GUO[5rYLA\";i:2572;s:15:\"z:>hT?GUO[DtYLA\";i:2573;s:15:\"z:>hT?GUO[ouYLA\";i:2574;s:15:\"z:>hT?GUO[=vYLA\";i:2575;s:15:\"z:>hT?GUO[XxYLA\";i:2576;s:15:\"z:>hT?GUO[8yYLA\";i:2577;s:15:\"z:>hT?GUO[G0YLA\";i:2578;s:15:\"z:>hT?GUO[r1YLA\";i:2579;s:15:\"z:>hT?GUO[@2YLA\";i:2580;s:15:\"z:>hT?GUO[a4YLA\";i:2581;s:15:\"z:>hT?GUO[#5YLA\";i:2582;s:15:\"z:>hT?GUO[J7YLA\";i:2583;s:15:\"z:>hT?GUO[u8YLA\";i:2584;s:15:\"z:>hT?GUO[^9YLA\";i:2585;s:15:\"z:>hT?GUO[d#YLA\";i:2586;s:15:\"z:>hT?GUO[&$YLA\";i:2587;s:15:\"z:>hT?GUO[M&YLA\";i:2588;s:15:\"z:>hT?GUO[x(YLA\";i:2589;s:15:\"z:>hT?GUO[{)YLA\";i:2590;s:15:\"z:>hT?GUO[g+YLA\";i:2591;s:15:\"z:>hT?GUO[*,YLA\";i:2592;s:15:\"z:>hT?GUO[P/YLA\";i:2593;s:15:\"z:>hT?GUO[0:YLA\";i:2594;s:15:\"z:>hT?GUO[~;YLA\";i:2595;s:15:\"z:>hT?GUO[j=YLA\";i:2596;s:15:\"z:>hT?GUO[.>YLA\";i:2597;s:15:\"z:>hT?GUO[S@YLA\";i:2598;s:15:\"z:>hT?GUO[3[YLA\";i:2599;s:15:\"z:>hT?GUO[B^YLA\";i:2600;s:15:\"z:>hT?GUO[m_YLA\";i:2601;s:15:\"z:>hT?GUO[;`YLA\";i:2602;s:15:\"z:>hT?GUO[V|YLA\";i:2603;s:15:\"z:>hT?GUO[6}YLA\";i:2604;s:15:\"z:>hT?GUO[CA6FA\";i:2605;s:15:\"z:>hT?GUO[nBZLA\";i:2606;s:15:\"z:>hT?GUO[<CZLA\";i:2607;s:15:\"z:>hT?GUO[WEZLA\";i:2608;s:15:\"z:>hT?GUO[7FZLA\";i:2609;s:15:\"z:>hT?GUO[FHZLA\";i:2610;s:15:\"z:>hT?GUO[qIZLA\";i:2611;s:15:\"z:>hT?GUO[?JZLA\";i:2612;s:15:\"z:>hT?GUO[ZLZLA\";i:2613;s:15:\"z:>hT?GUO[!MZLA\";i:2614;s:15:\"z:>hT?GUO[IOZLA\";i:2615;s:15:\"z:>hT?GUO[tPZLA\";i:2616;s:15:\"z:>hT?GUO[]QZLA\";i:2617;s:15:\"z:>hT?GUO[cSZLA\";i:2618;s:15:\"z:>hT?GUO[%TZLA\";i:2619;s:15:\"z:>hT?GUO[LVZLA\";i:2620;s:15:\"z:>hT?GUO[wWZLA\";i:2621;s:15:\"z:>hT?GUO[`XZLA\";i:2622;s:15:\"z:>hT?GUO[fZZLA\";i:2623;s:15:\"z:>hT?GUO[)aZLA\";i:2624;s:15:\"z:>hT?GUO[OcZLA\";i:2625;s:15:\"z:>hT?GUO[zdZLA\";i:2626;s:15:\"z:>hT?GUO[}eZLA\";i:2627;s:15:\"z:>hT?GUO[igZLA\";i:2628;s:15:\"z:>hT?GUO[,hZLA\";i:2629;s:15:\"z:>hT?GUO[RjZLA\";i:2630;s:15:\"z:>hT?GUO[2kZLA\";i:2631;s:15:\"z:>hT?GUO[AmZLA\";i:2632;s:15:\"z:>hT?GUO[lnZLA\";i:2633;s:15:\"z:>hT?GUO[:oZLA\";i:2634;s:15:\"z:>hT?GUO[UqZLA\";i:2635;s:15:\"z:>hT?GUO[5rZLA\";i:2636;s:15:\"z:>hT?GUO[DtZLA\";i:2637;s:15:\"z:>hT?GUO[ouZLA\";i:2638;s:15:\"z:>hT?GUO[=vZLA\";i:2639;s:15:\"z:>hT?GUO[XxZLA\";i:2640;s:15:\"z:>hT?GUO[8yZLA\";i:2641;s:15:\"z:>hT?GUO[G0ZLA\";i:2642;s:15:\"z:>hT?GUO[r1ZLA\";i:2643;s:15:\"z:>hT?GUO[@2ZLA\";i:2644;s:15:\"z:>hT?GUO[a4ZLA\";i:2645;s:15:\"z:>hT?GUO[#5ZLA\";i:2646;s:15:\"z:>hT?GUO[J7ZLA\";i:2647;s:15:\"z:>hT?GUO[u8ZLA\";i:2648;s:15:\"z:>hT?GUO[^9ZLA\";i:2649;s:15:\"z:>hT?GUO[d#ZLA\";i:2650;s:15:\"z:>hT?GUO[&$ZLA\";i:2651;s:15:\"z:>hT?GUO[M&ZLA\";i:2652;s:15:\"z:>hT?GUO[x(ZLA\";i:2653;s:15:\"z:>hT?GUO[{)ZLA\";i:2654;s:15:\"z:>hT?GUO[g+ZLA\";i:2655;s:15:\"z:>hT?GUO[*,ZLA\";i:2656;s:15:\"z:>hT?GUO[P/ZLA\";i:2657;s:15:\"z:>hT?GUO[0:ZLA\";i:2658;s:15:\"z:>hT?GUO[~;ZLA\";i:2659;s:15:\"z:>hT?GUO[j=ZLA\";i:2660;s:15:\"z:>hT?GUO[.>ZLA\";i:2661;s:15:\"z:>hT?GUO[S@ZLA\";i:2662;s:15:\"z:>hT?GUO[3[ZLA\";i:2663;s:15:\"z:>hT?GUO[B^ZLA\";i:2664;s:15:\"z:>hT?GUO[m_ZLA\";i:2665;s:15:\"z:>hT?GUO[;`ZLA\";i:2666;s:15:\"z:>hT?GUO[V|ZLA\";i:2667;s:15:\"z:>hT?GUO[6}ZLA\";i:2668;s:15:\"z:>hT?GUO[E\"6FA\";i:2669;s:15:\"z:>hT?GUO[nBaLA\";i:2670;s:15:\"z:>hT?GUO[<CaLA\";i:2671;s:15:\"z:>hT?GUO[WEaLA\";i:2672;s:15:\"z:>hT?GUO[7FaLA\";i:2673;s:15:\"z:>hT?GUO[FHaLA\";i:2674;s:15:\"z:>hT?GUO[qIaLA\";i:2675;s:15:\"z:>hT?GUO[?JaLA\";i:2676;s:15:\"z:>hT?GUO[ZLaLA\";i:2677;s:15:\"z:>hT?GUO[!MaLA\";i:2678;s:15:\"z:>hT?GUO[IOaLA\";i:2679;s:15:\"z:>hT?GUO[tPaLA\";i:2680;s:15:\"z:>hT?GUO[]QaLA\";i:2681;s:15:\"z:>hT?GUO[cSaLA\";i:2682;s:15:\"z:>hT?GUO[%TaLA\";i:2683;s:15:\"z:>hT?GUO[LVaLA\";i:2684;s:15:\"z:>hT?GUO[wWaLA\";i:2685;s:15:\"z:>hT?GUO[`XaLA\";i:2686;s:15:\"z:>hT?GUO[fZaLA\";i:2687;s:15:\"z:>hT?GUO[)aaLA\";i:2688;s:15:\"z:>hT?GUO[OcaLA\";i:2689;s:15:\"z:>hT?GUO[zdaLA\";i:2690;s:15:\"z:>hT?GUO[}eaLA\";i:2691;s:15:\"z:>hT?GUO[igaLA\";i:2692;s:15:\"z:>hT?GUO[,haLA\";i:2693;s:15:\"z:>hT?GUO[RjaLA\";i:2694;s:15:\"z:>hT?GUO[2kaLA\";i:2695;s:15:\"z:>hT?GUO[AmaLA\";i:2696;s:15:\"z:>hT?GUO[lnaLA\";i:2697;s:15:\"z:>hT?GUO[:oaLA\";i:2698;s:15:\"z:>hT?GUO[UqaLA\";i:2699;s:15:\"z:>hT?GUO[5raLA\";i:2700;s:15:\"z:>hT?GUO[DtaLA\";i:2701;s:15:\"z:>hT?GUO[ouaLA\";i:2702;s:15:\"z:>hT?GUO[=vaLA\";i:2703;s:15:\"z:>hT?GUO[XxaLA\";i:2704;s:15:\"z:>hT?GUO[8yaLA\";i:2705;s:15:\"z:>hT?GUO[G0aLA\";i:2706;s:15:\"z:>hT?GUO[r1aLA\";i:2707;s:15:\"z:>hT?GUO[@2aLA\";i:2708;s:15:\"z:>hT?GUO[a4aLA\";i:2709;s:15:\"z:>hT?GUO[#5aLA\";i:2710;s:15:\"z:>hT?GUO[J7aLA\";i:2711;s:15:\"z:>hT?GUO[u8aLA\";i:2712;s:15:\"z:>hT?GUO[^9aLA\";i:2713;s:15:\"z:>hT?GUO[d#aLA\";i:2714;s:15:\"z:>hT?GUO[&$aLA\";i:2715;s:15:\"z:>hT?GUO[M&aLA\";i:2716;s:15:\"z:>hT?GUO[x(aLA\";i:2717;s:15:\"z:>hT?GUO[{)aLA\";i:2718;s:15:\"z:>hT?GUO[g+aLA\";i:2719;s:15:\"z:>hT?GUO[*,aLA\";i:2720;s:15:\"z:>hT?GUO[P/aLA\";i:2721;s:15:\"z:>hT?GUO[0:aLA\";i:2722;s:15:\"z:>hT?GUO[~;aLA\";i:2723;s:15:\"z:>hT?GUO[j=aLA\";i:2724;s:15:\"z:>hT?GUO[.>aLA\";i:2725;s:15:\"z:>hT?GUO[S@aLA\";i:2726;s:15:\"z:>hT?GUO[3[aLA\";i:2727;s:15:\"z:>hT?GUO[B^aLA\";i:2728;s:15:\"z:>hT?GUO[m_aLA\";i:2729;s:15:\"z:>hT?GUO[;`aLA\";i:2730;s:15:\"z:>hT?GUO[V|aLA\";i:2731;s:15:\"z:>hT?GUO[6}aLA\";i:2732;s:15:\"z:>hT?GUNkDA5FA\";i:2733;s:15:\"z:>hT?GUNkoBXLA\";i:2734;s:15:\"z:>hT?GUNk=CXLA\";i:2735;s:15:\"z:>hT?GUNkXEXLA\";i:2736;s:15:\"z:>hT?GUNk8FXLA\";i:2737;s:15:\"z:>hT?GUNkGHXLA\";i:2738;s:15:\"z:>hT?GUNkrIXLA\";i:2739;s:15:\"z:>hT?GUNk@JXLA\";i:2740;s:15:\"z:>hT?GUNkaLXLA\";i:2741;s:15:\"z:>hT?GUNk#MXLA\";i:2742;s:15:\"z:>hT?GUNkJOXLA\";i:2743;s:15:\"z:>hT?GUNkuPXLA\";i:2744;s:15:\"z:>hT?GUNk^QXLA\";i:2745;s:15:\"z:>hT?GUNkdSXLA\";i:2746;s:15:\"z:>hT?GUNk&TXLA\";i:2747;s:15:\"z:>hT?GUNkMVXLA\";i:2748;s:15:\"z:>hT?GUNkxWXLA\";i:2749;s:15:\"z:>hT?GUNk{XXLA\";i:2750;s:15:\"z:>hT?GUNkgZXLA\";i:2751;s:15:\"z:>hT?GUNk*aXLA\";i:2752;s:15:\"z:>hT?GUNkPcXLA\";i:2753;s:15:\"z:>hT?GUNk0dXLA\";i:2754;s:15:\"z:>hT?GUNk~eXLA\";i:2755;s:15:\"z:>hT?GUNkjgXLA\";i:2756;s:15:\"z:>hT?GUNk.hXLA\";i:2757;s:15:\"z:>hT?GUNkSjXLA\";i:2758;s:15:\"z:>hT?GUNk3kXLA\";i:2759;s:15:\"z:>hT?GUNkBmXLA\";i:2760;s:15:\"z:>hT?GUNkmnXLA\";i:2761;s:15:\"z:>hT?GUNk;oXLA\";i:2762;s:15:\"z:>hT?GUNkVqXLA\";i:2763;s:15:\"z:>hT?GUNk6rXLA\";i:2764;s:15:\"z:>hT?GUNkEtXLA\";i:2765;s:15:\"z:>hT?GUNkpuXLA\";i:2766;s:15:\"z:>hT?GUNk>vXLA\";i:2767;s:15:\"z:>hT?GUNkYxXLA\";i:2768;s:15:\"z:>hT?GUNk9yXLA\";i:2769;s:15:\"z:>hT?GUNkH0XLA\";i:2770;s:15:\"z:>hT?GUNks1XLA\";i:2771;s:15:\"z:>hT?GUNk[2XLA\";i:2772;s:15:\"z:>hT?GUNkb4XLA\";i:2773;s:15:\"z:>hT?GUNk$5XLA\";i:2774;s:15:\"z:>hT?GUNkK7XLA\";i:2775;s:15:\"z:>hT?GUNkv8XLA\";i:2776;s:15:\"z:>hT?GUNk_9XLA\";i:2777;s:15:\"z:>hT?GUNke#XLA\";i:2778;s:15:\"z:>hT?GUNk($XLA\";i:2779;s:15:\"z:>hT?GUNkN&XLA\";i:2780;s:15:\"z:>hT?GUNky(XLA\";i:2781;s:15:\"z:>hT?GUNk|)XLA\";i:2782;s:15:\"z:>hT?GUNkh+XLA\";i:2783;s:15:\"z:>hT?GUNk+,XLA\";i:2784;s:15:\"z:>hT?GUNkQ/XLA\";i:2785;s:15:\"z:>hT?GUNk1:XLA\";i:2786;s:15:\"z:>hT?GUNk\";XLA\";i:2787;s:15:\"z:>hT?GUNkk=XLA\";i:2788;s:15:\"z:>hT?GUNk/>XLA\";i:2789;s:15:\"z:>hT?GUNkT@XLA\";i:2790;s:15:\"z:>hT?GUNk4[XLA\";i:2791;s:15:\"z:>hT?GUNkC^XLA\";i:2792;s:15:\"z:>hT?GUNkn_XLA\";i:2793;s:15:\"z:>hT?GUNk<`XLA\";i:2794;s:15:\"z:>hT?GUNkW|XLA\";i:2795;s:15:\"z:>hT?GUNk7}XLA\";i:2796;s:15:\"z:>hT?GUNkF\"5FA\";i:2797;s:15:\"z:>hT?GUNkoBYLA\";i:2798;s:15:\"z:>hT?GUNk=CYLA\";i:2799;s:15:\"z:>hT?GUNkXEYLA\";i:2800;s:15:\"z:>hT?GUNk8FYLA\";i:2801;s:15:\"z:>hT?GUNkGHYLA\";i:2802;s:15:\"z:>hT?GUNkrIYLA\";i:2803;s:15:\"z:>hT?GUNk@JYLA\";i:2804;s:15:\"z:>hT?GUNkaLYLA\";i:2805;s:15:\"z:>hT?GUNk#MYLA\";i:2806;s:15:\"z:>hT?GUNkJOYLA\";i:2807;s:15:\"z:>hT?GUNkuPYLA\";i:2808;s:15:\"z:>hT?GUNk^QYLA\";i:2809;s:15:\"z:>hT?GUNkdSYLA\";i:2810;s:15:\"z:>hT?GUNk&TYLA\";i:2811;s:15:\"z:>hT?GUNkMVYLA\";i:2812;s:15:\"z:>hT?GUNkxWYLA\";i:2813;s:15:\"z:>hT?GUNk{XYLA\";i:2814;s:15:\"z:>hT?GUNkgZYLA\";i:2815;s:15:\"z:>hT?GUNk*aYLA\";i:2816;s:15:\"z:>hT?GUNkPcYLA\";i:2817;s:15:\"z:>hT?GUNk0dYLA\";i:2818;s:15:\"z:>hT?GUNk~eYLA\";i:2819;s:15:\"z:>hT?GUNkjgYLA\";i:2820;s:15:\"z:>hT?GUNk.hYLA\";i:2821;s:15:\"z:>hT?GUNkSjYLA\";i:2822;s:15:\"z:>hT?GUNk3kYLA\";i:2823;s:15:\"z:>hT?GUNkBmYLA\";i:2824;s:15:\"z:>hT?GUNkmnYLA\";i:2825;s:15:\"z:>hT?GUNk;oYLA\";i:2826;s:15:\"z:>hT?GUNkVqYLA\";i:2827;s:15:\"z:>hT?GUNk6rYLA\";i:2828;s:15:\"z:>hT?GUNkEtYLA\";i:2829;s:15:\"z:>hT?GUNkpuYLA\";i:2830;s:15:\"z:>hT?GUNk>vYLA\";i:2831;s:15:\"z:>hT?GUNkYxYLA\";i:2832;s:15:\"z:>hT?GUNk9yYLA\";i:2833;s:15:\"z:>hT?GUNkH0YLA\";i:2834;s:15:\"KV?hT?GUNks1YLA\";i:2835;s:53:\"NV?hT?GUNk[2YLBNVElg*NXmPtaS`Q3nE30ob#5F&6LvSQ[zWC1WA\";i:2836;s:15:\"z:>hT?GUNk6}ZLA\";i:2837;s:15:\"z:>hT?GUNkE\"6FA\";i:2838;s:15:\"z:>hT?GUNknBaLA\";i:2839;s:15:\"z:>hT?GUNk<CaLA\";i:2840;s:15:\"z:>hT?GUNkWEaLA\";i:2841;s:15:\"z:>hT?GUNk7FaLA\";i:2842;s:15:\"z:>hT?GUNkFHaLA\";i:2843;s:15:\"z:>hT?GUNkqIaLA\";i:2844;s:15:\"z:>hT?GUNk?JaLA\";i:2845;s:15:\"z:>hT?GUNkZLaLA\";i:2846;s:15:\"z:>hT?GUNk!MaLA\";i:2847;s:15:\"z:>hT?GUNkIOaLA\";i:2848;s:15:\"z:>hT?GUNktPaLA\";i:2849;s:15:\"z:>hT?GUNk]QaLA\";i:2850;s:15:\"z:>hT?GUNkcSaLA\";i:2851;s:15:\"z:>hT?GUNk%TaLA\";i:2852;s:15:\"z:>hT?GUNkLVaLA\";i:2853;s:15:\"z:>hT?GUNkwWaLA\";i:2854;s:15:\"z:>hT?GUNk`XaLA\";i:2855;s:15:\"z:>hT?GUNkfZaLA\";i:2856;s:15:\"z:>hT?GUNk)aaLA\";i:2857;s:15:\"z:>hT?GUNkOcaLA\";i:2858;s:15:\"z:>hT?GUNkzdaLA\";i:2859;s:15:\"z:>hT?GUNk}eaLA\";i:2860;s:15:\"z:>hT?GUNkigaLA\";i:2861;s:15:\"z:>hT?GUNk,haLA\";i:2862;s:15:\"z:>hT?GUNkRjaLA\";i:2863;s:15:\"z:>hT?GUNk2kaLA\";i:2864;s:15:\"z:>hT?GUNkAmaLA\";i:2865;s:15:\"z:>hT?GUNklnaLA\";i:2866;s:15:\"z:>hT?GUNk:oaLA\";i:2867;s:15:\"z:>hT?GUNkUqaLA\";i:2868;s:15:\"z:>hT?GUNk5raLA\";i:2869;s:15:\"z:>hT?GUNkDtaLA\";i:2870;s:15:\"z:>hT?GUNkouaLA\";i:2871;s:15:\"z:>hT?GUNk=vaLA\";i:2872;s:15:\"z:>hT?GUNkXxaLA\";i:2873;s:15:\"z:>hT?GUNk8yaLA\";i:2874;s:15:\"z:>hT?GUNkG0aLA\";i:2875;s:15:\"z:>hT?GUNkr1aLA\";i:2876;s:15:\"z:>hT?GUNk@2aLA\";i:2877;s:15:\"z:>hT?GUNka4aLA\";i:2878;s:15:\"z:>hT?GUNk#5aLA\";i:2879;s:15:\"z:>hT?GUNkJ7aLA\";i:2880;s:15:\"z:>hT?GUNku8aLA\";i:2881;s:15:\"z:>hT?GUNk^9aLA\";i:2882;s:15:\"z:>hT?GUNkd#aLA\";i:2883;s:15:\"z:>hT?GUNk&$aLA\";i:2884;s:15:\"z:>hT?GUNkM&aLA\";i:2885;s:15:\"z:>hT?GUNkx(aLA\";i:2886;s:15:\"z:>hT?GUNk{)aLA\";i:2887;s:15:\"z:>hT?GUNkg+aLA\";i:2888;s:15:\"z:>hT?GUNk*,aLA\";i:2889;s:15:\"z:>hT?GUNkP/aLA\";i:2890;s:15:\"z:>hT?GUNk0:aLA\";i:2891;s:15:\"z:>hT?GUNk~;aLA\";i:2892;s:15:\"z:>hT?GUNkj=aLA\";i:2893;s:15:\"z:>hT?GUNk.>aLA\";i:2894;s:15:\"z:>hT?GUNkS@aLA\";i:2895;s:15:\"z:>hT?GUNk3[aLA\";i:2896;s:15:\"z:>hT?GUNkB^aLA\";i:2897;s:15:\"z:>hT?GUNkm_aLA\";i:2898;s:15:\"z:>hT?GUNk;`aLA\";i:2899;s:15:\"z:>hT?GUNkV|aLA\";i:2900;s:15:\"KV?hT?GUNkb4YLA\";i:2901;s:186:\"YV?hT?GUNkb4YLnbVElg*NtEPtaS`Q3nE3~R4A+h;hzXJI{ZmAOc$(k)No[T:CJdzXJI{Z02aLrPVElg*NmBRtmBJHNzRmY\"I\"Mc_Q3nE3BB$AFF[hT?GU}jVBbLrt,ub@=15Fk0LvSQ[z$Ac4ht,ub@y2zWEtPj`Q3nE30oaS5F<8LvSQ[zGFiC$A\";i:2902;s:15:\"z:>hT?GUNk$5YLA\";i:2903;s:15:\"z:>hT?GUNkK7YLA\";i:2904;s:15:\"z:>hT?GUNkv8YLA\";i:2905;s:23:\")a=hT?GUpA$A[CSOYMtOBtA\";i:2906;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:2907;s:23:\"Am>hT?GUpA$AaDSOYMtOBtA\";i:2908;s:26:\"u8=hT?GUO[e+aL*BVElg*NJAIA\";i:2909;s:148:\"d@>hT?GUNk_9YLLPVElg*NFAJt&\",ub@/B5FxtLvSQ[zCAFtht,ub@/B5F[tLvSQ[zCAc4mt,ub@uC5FGuLvSQ[z+A:>ht,ub@TD5FmuLvSQ[z+AbLit,ub@TD5FU0LvSQ[z|AEA)(k)No`,/CIA\";i:2910;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:2911;s:23:\"LV>hT?GU/A$AcDSOYMAlFtA\";i:2912;s:135:\"Km>hT?GUpA$AWDSOYMtOBt[9_Q3nE3OC$AVDSOYMXwCtH7_Q3nE3OC$ArDSOYMj<RB2A8y%(k)No.e:CYYzXJI|+FA,h#(k)No]AlBzL.4Fx~5AAvW=hT?GUpA$A^CSOYMtOBtA\";i:2913;s:15:\"A^>hT?GUNke#YLA\";i:2914;s:12:\"A^?hT?GUpA$A\";i:2915;s:13:\"A^?hT?GU%IlBA\";i:2916;s:26:\")a=hT?GU~@$Aln#(k)No`,mBIA\";i:2917;s:123:\"Im>hT?GUpA$AXDSOYMtOBt[9_Q3nE3gE$AVDSOYM?IEt_)_Q3nE3H#i=5F]6LvSQ[z**1W<cqI:$vb=DgA(BJHNzRmK)bA};>hT?GUNky(YL8sVElg*NZm?TlBA\";i:2918;s:94:\"Gm>hT?GUpA$AXDSOYMtOBt[9_Q3nE3gE$AVDSOYM?IEt_)_Q3nE3H#R@5FU0LvSQ[z|AFtqt,ub@/B7F?jLCJHNzij?V$A\";i:2919;s:123:\".5=hT?GUDClBFN.4Fx}MaA+h>hT?GU%IlB_M.4FxrjMAvW>hT?GUpA$AcDSOYMtOBtoI_Q3nE3UAi\"oBJHNzj@uW5FqI:$vbKARtpBJHNzj@uWY4qI:$vb*|h\"A\";i:2920;s:50:\"2:>hT?GUO[{eXLjHVElg*NWBS\";\",ub@>i5FC6LvSQ[zGF4I$A\";i:2921;s:13:\"t8=hT?GUqNlBA\";i:2922;s:105:\";a>hT?GU[IlBQM.4Fx}MOANc?hT?GUO[;vYL&\"LvSQ[zCA/hht,ub@uC5F%tLvSQ[zCAc4ht,ub@uC5FwwLvSQ[z?AbLnt,ub@y2CRItA\";i:2923;s:24:\"Rj>hT?GU%IlB]O.4Fxs@AABA\";i:2924;s:15:\"?2?hT?GUNkQ/YLA\";i:2925;s:30:\"?2?hT?KUNk1:YL#zMTiKlBi<Su7AGA\";i:2926;s:36:\"?2?hT?MU~@jB/ha.1(EthNZmZVUE&!jCfBgA\";i:2927;s:12:\"?2?hT?GU5A$A\";i:2928;s:38:\"SjIizXJI{ZmAx(g)LvSQ[z<AFtEvVElg*N!BQA\";i:2929;s:13:\"t8=hT?GUqNlBA\";i:2930;s:13:\"t8=hT?GUr6lBA\";i:2931;s:108:\"jS?hT?GUNkC^YLmOVElg*NbCRt7BJHNzd&vW{eqI:$vbOAQA,\",ub@MI5FhtLvSQ[zMT]K$AXDSOYM*+Ct>2_Q3nE3uC$AgDSOYMj<Su!ACA\";i:2932;s:15:\"bS?hT?GUNkC^YLA\";i:2933;s:15:\"bS?hT?GUO[>2XLA\";i:2934;s:13:\"t8=hT?GUqNlBA\";i:2935;s:152:\")r?hT?GU~@iB/hrt,ub@=10FRtGCJHNzRm3tfATq>hT?GUpA$A%DSOYM*+Ftxd_Q3nE3wE$A7DSOYMtOBtoI_Q3nE3UAi\"oBJHNzWHuW5FqI:$vbKARtpBJHNzWHuWqiqI:$vby<8s:C7fzXJI{ZmACA\";i:2936;s:56:\"fS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWFhqI:$vbKAQA\";i:2937;s:216:\"oC1B=\",ub@=1{DS\";\",ub@=1{DS\"<\",ub@=1{DRt5BJHNzLYxWnbqI:$vbKARt7BJHNzWHuW)0qI:$vbhDgAvBJHNzzguWtpqI:$vbaU^|:C9hzXJI|+zJ5FgAoBJHNzWHuW_EqI:$vbKAQA)\",ub@ff5F2uLvSQ[zGAz(pt,ub@y2mnDt#T`Q3nE3~R4AHO>hT?GUMHlBiO.4Fxrj,E<CQA\";i:2938;s:26:\"j=>hT?GUhIlB<Q.4Fxrj,E>CQA\";i:2939;s:14:\"\"l>hT?GU~@QBEA\";i:2940;s:15:\"bS?hT?GUNkXEZLA\";i:2941;s:63:\"fS?hT?GUO[>2XL%NVElg*NZmTXlBMM.4FxrjLA$T=hT?GU~@$Ax(%(k)NonR:CA\";i:2942;s:81:\"/a>hT?GUjSlBVN.4Fx~5AA$T>hT?GUpA$A1DSOYMj<Su9AOc%(k)NofJ:CSazXJI{ZWAOc)(k)No;F:CA\";i:2943;s:182:\"[a>hT?GUjSlB=N.4FxrjYBtFRtJCJHNzRm2AS\":C_Q3nF3UAi\"ITz4QAVE_Q3nE3UAgAnBJHNzWHuWvDqI:$vbKARt7BJHNzd&vWUEqI:$vbKARtoBJHNzWHuW5FqI:$vbKARtpBJHNzWHuW{eqI:$vbwCgA4BJHNzRm3thA+hgizXJI|+3ACA\";i:2944;s:15:\"EH=hT?GUNk@JZLA\";i:2945;s:26:\"j=>hT?GUhIlB<Q.4Fxrj,E>CQA\";i:2946;s:116:\"8:>hT?GUO[{eXLjHVElg*NMBQA=\",ub@/B5F#zLvSQ[zCAbLmt,ub@x/5FE0LvSQ[zCAc4mt,ub@/B5FhtLvSQ[zYAc4ht,ub@ZR5FZ1LvSQ[zMT|L$A\";i:2947;s:37:\"SjoizXJI{ZnAx(F*LvSQ[z>Ac4mt,ub@IU5FA\";i:2948;s:44:\"SjoizXJI|+wCnHgAiM{Q3nE30o<c6Fj3LvSQ[zGF3T$A\";i:2949;s:12:\"_X>hT?GUpA$A\";i:2950;s:26:\"Rj@hT?GUNk#MZL*BVElg*N]BQA\";i:2951;s:26:\"tP=hT?GUsHlBAQ.4Fxrj,EDDQA\";i:2952;s:12:\"KV>hT?GUpA$A\";i:2953;s:27:\"Rj4izXJI|+zJCGi\"nBJHNzRmwWA\";i:2954;s:16:\"Qj4izXJI|+zJGGgA\";i:2955;s:24:\"cS=hT?GU3GlB3L.4FxrjJABA\";i:2956;s:37:\"0d>hT?GUpA$AbDSOYM?IEtlB_Q3nE3H#)H6FA\";i:2957;s:15:\"\"l>hT?GUNk?2XLA\";i:2958;s:49:\"Tj>hT?GU%IlB_M.4Fx~5AATq?hT?GU}jhBz(ht,ub@y28(JtA\";i:2959;s:93:\":a>hT?GUjSlBQM.4Fxs@MA1k>hT?GUpA$AXDSOYMtOBt[9_Q3nE3gE$AVDSOYM?IEtY4`Q3nE3H#OJ6Fz3LvSQ[zu61WA\";i:2960;s:155:\"dj>hT?GU5A$A;CSOYM?IEtp1_Q3nE3cAi\"vBJHNzG3vWxdqI:$vbKAQA{\",ub@=14FS\"(\",ub@ma5FWuLvSQ[zCAG\"#(k)NoTN:CbXzXJI{ZBAZL#(k)No]AlBjL.4Fxs@AAYL=hT?GUpA$A?CSOYMLUBtA\";i:2961;s:12:\"yd>hT?GUpA$A\";i:2962;s:142:\"!:>hT?GUO[{eXLmOVElg*NbCQA<\",ub@/B5F_0LvSQ[zlA/hmt,ub@ma5F$wLvSQ[zzA:>lt,ub@/B5F)0LvSQ[zDAz(lt,ub@uC5F51LvSQ[z!KyWN/qI:$vby<1x:C,bzXJI|+zJWGgA\";i:2963;s:48:\"eS?hT?GUNkMVZLjHVElg*NMBRt3BJHNz*:uWxdqI:$vbdDgA\";i:2964;s:45:\"HH=hT?GUpA$A=CSOYMtOBt5F_Q3nE3UAi\"nBJHNzWHuWA\";i:2965;s:70:\"JH=hT?GUNkxWZLmOVElg*NbCRt7BJHNzoxvWMcqI:$vbKAQA=\",ub@>i5F37LvSQ[zDAEA\";i:2966;s:62:\"&5=hT?GU\"NlBJN.4Fx}MLA[Q?hT?GUNk{XZLWeVElg*NNK:ClBzL.4Fx}MNABA\";i:2967;s:13:\"VE=hT?GU%IlBA\";i:2968;s:14:\"?2?hT?GU~@jBEA\";i:2969;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:2970;s:61:\"Uj>hT?GUNkgZZLGOVElg*NUBRtnBJHNzRmK)kA6F=hT?GU/A$A]CSOYM)ZBtA\";i:2971;s:45:\"eS=hT?GUpA$A[CSOYMtOBtXL_Q3nE3UAi\"pBJHNzWHuWA\";i:2972;s:14:\"bS=hT?GU~@~AEA\";i:2973;s:34:\"Bm>hT?GUpA$AWDSOYMtOBtoI_Q3nE3UAgA\";i:2974;s:187:\"YV?hT?GUO[y:XLHbVElg*NNK;PlB!O.4Fx}MH)6FvzLvSQ[zdAc4jt,ub@,n5Fk0LvSQ[zvAbLrt,ub@=15Fm!LvSQ[zWC1Ws8qI:$vb\"Ie\"xd`Q3nE3pB$A^DSOYMj<e\"NAf+?hT?GUO[0kXL{eVElg*NNK9JlBTP.4FxrjYB2AJt~AyD1+ITJ\"EtA\";i:2975;s:79:\"KH=hT?GUpA$A=CSOYMLUBt5F_Q3nE3UAi\"nBJHNzFKuW<cqI:$vbUCi\"<BJHNzij?V$AgDSOYM6|DtA\";i:2976;s:13:\"nu>hT?GU\"NlBA\";i:2977;s:60:\"%M?hT?GU~@VBFt/wVElg*NLKPtgg_Q3nE38I$AFDSOYMtOHt*h_Q3nE38I$A\";i:2978;s:136:\"/a>hT?GU[IlBRN.4FxrjMA[Q>hT?GU%IlBlN.4Fxs@LAI7=hT?OUNkPcZL#zMTJNlBi<Bt(ayA%ttUY4OWVElg+NZmialB&!jC8B#(y2OtKt(ay</1XLnj,EjD@A{\",ub@=1sFQA\";i:2979;s:22:\"A^>hT?IUNkmnwW#zMT5N$A\";i:2980;s:64:\"Uj.izXJI|+zJ]GgAAS{Q3nE3H#lU6F1xLvSQ[z@AbLkt,ub@845F*xLvSQ[z@AEA\";i:2981;s:59:\">`>hT?GUNkVqZL&\"LvSQ[zCA/hht,ub@uC5F%tLvSQ[zCAc4ht,ub@uC5FA\";i:2982;s:70:\"Vj}izXJI{ZBAm_#(k)NoIe:C{!IByD1+4DXLrPVElg*NIBS\";\",ub@>i5FU0LvSQ[zyAEA\";i:2983;s:12:\"bS>hT?GU5A$A\";i:2984;s:89:\"UjNjzXJI|+JA]Q%(k)No@G:CtZzXJI{ZJAwW%(k)NowG:CEczX3e|+zJ\"Gi\"ITG?SA(ay<p1oInj,EhD%tITbALtC\";i:2985;s:71:\".a>hT?GUjSlBBN.4Fx~5AA1k>hT?GUpA$AXv[hT?GUqNlB=N.4Fx~5AA<v>hT?GUNkpuZLA\";i:2986;s:31:\"RjdjzXJI|+zJLHgAoa{Q3nE3H#_X6FA\";i:2987;s:31:\"RjdjzXJI|+zJPHgAoa{Q3nE3H#5Y6FA\";i:2988;s:156:\">a>hT?GUjSlBVN.4Fxs@NA+h>hT?GUO[SqYLhNVElg*NiVMt:C_Q3nE30o:&5F51LvSQ[z@HFB$A&DSOYM*+4slB&qzt,ub@y27WLt@Q.R.4Fxrj,E3DQADByD1+ITctW\"Q@`Q3nE3BB$AQESOYMj<cA8ABA\";i:2989;s:26:\"j=>hT?GUNkH0ZLRdVElg*NHAIA\";i:2990;s:37:\"uP?hT?GUNks1ZLGOVElg*NNA3(;\",ub@uC5FA\";i:2991;s:15:\"sP?hT?GUNk[2ZLA\";i:2992;s:15:\"sP?hT?GUNkb4ZLA\";i:2993;s:37:\"uP?hT?GUNk$5ZL%NVElg*NNAIAmt,ub@uC5FA\";i:2994;s:15:\"sP?hT?GUNkK7ZLA\";i:2995;s:15:\"sP?hT?GUNkv8ZLA\";i:2996;s:64:\",a>hT?GUjSlBMM.4Fxs@CAeZ@hT?GUNk_9ZLpVVElg*NZmXblBlN.4Fxrj}BYAIA\";i:2997;s:12:\"i=>hT?GUpA$A\";i:2998;s:35:\"jg>hT?GUOBlBBN.4Fx~5AA+h>hT?GU%IlBA\";i:2999;s:71:\"Vj>hT?GUCFlB_M.4Fx}MHAI7=hT?GU{JlBzP.4FxrjMA,>>hT?GU}jfB/hot,ub@y2a/LtA\";i:3000;s:159:\"*r>hT?GUqNlBfL.4Fx~5AApI=hT?GUpA$A>CSOYMtOBtDH_Q3nE3UAgAoBJHNzWHuW_EqI:$vbKAQA)\",ub@/B5F2uLvSQ[zCAG\"*(k)No_a:CooKByD1+!RYL(,qESOYM*+FtdZ`Q3nE3&G$A{&[hT?GUqNlBA\";i:3001;s:14:\"?2?hT?GU~@jBEA\";i:3002;s:15:\"R@>hT?GUO[>2XLA\";i:3003;s:26:\"j=>hT?GUhIlB[N.4Fxrj,E;DQA\";i:3004;s:15:\"R@>hT?GUO[>2XLA\";i:3005;s:14:\"R@>hT?GU}jfBEA\";i:3006;s:44:\"MV>hT?GUOBlBVN.4Fxs@NA2[>hT?IUNky(wW#zMTjP$A\";i:3007;s:56:\"IH=hT?GU/A$A=CSOYMtOBt5F_Q3nE3kAi\"nBJHNzWHuW+OqI:$vbYCgA\";i:3008;s:45:\"HH=hT?GUpA$A=CSOYM)ZBt5F_Q3nE3UAi\"nBJHNz?MuWA\";i:3009;s:26:\"S@>hT?GUNk|)ZLmOVElg*NbCQA\";i:3010;s:97:\"Y@>hT?GUNk($ZLmOVElg*NbCQA<\",ub@/B5F_0LvSQ[zCAFtmt,ub@>i5F#zLvSQ[zxAc4ot,ub@y2kLMt.o`Q3nE3H#@j6FA\";i:3011;s:15:\"A^?hT?GUNkQ/ZLA\";i:3012;s:48:\"Tj>hT?GU%IlB_M.4FxrjYBCCQA<\",ub@/B5F_0LvSQ[zCAEA\";i:3013;s:48:\"Tj>hT?GUO[jnYLhNVElg*NIBQA<\",ub@/B5F_0LvSQ[zCAEA\";i:3014;s:15:\"R@>hT?GUNk1:ZLA\";i:3015;s:15:\"R@>hT?GUO[>2XLA\";i:3016;s:14:\"R@>hT?GU}jfBEA\";i:3017;s:60:\"Tj`jzXJI|+zJAIgAak{Q3nE3H#\"l6F?jXCJHNzRm3ttA+hSkzXJI|+zJAIgA\";i:3018;s:16:\"QjakzXJI|+zJEIgA\";i:3019;s:82:\"/a>hT?GUjSlBBN.4Fx~5AA1k>hT?GUpA$AbDSOYM?IEtp1_Q3nE3gE$AXv[hT?GUqNlBlN.4Fxrj}BYAIA\";i:3020;s:15:\"sP?hT?GUNk/>ZLA\";i:3021;s:15:\"sP?hT?GUNkT@ZLA\";i:3022;s:15:\"sP?hT?GUNk4[ZLA\";i:3023;s:15:\"sP?hT?GUNkC^ZLA\";i:3024;s:16:\"QjikzXJI|+zJAIgA\";i:3025;s:14:\"4r?hT?GU~@iBEA\";i:3026;s:79:\"VjVjzXJI{ZmAx(A)LvSQ[z**1Wp1KJkcwYtzs|:Cp`MByD1+!R`KgAMu{Q3nE3~R!A<v>hT?GUhIlBA\";i:3027;s:14:\"QjVjzXJI{ZmACA\";i:3028;s:14:\"QjVjzXJI|+BACA\";i:3029;s:66:\"ax>hT?GUpA$A?H[hT?GU}jhBFt<3VElg*NuxQt@QZS.4Fx}M|_6F?jaCJHNzij?V$A\";i:3030;s:49:\"O&@hT?GU}jhBc4st,ub@y2^>It[9_Q3nE3gE$AVDSOYM?IEtA\";i:3031;s:15:\"A^?hT?GUNkn_ZLA\";i:3032;s:26:\"RjVjzXJI|+BAln+(k)No`,*CIA\";i:3033;s:121:\"<a>hT?GUjSlBBN.4Fx~5AA|e>hT?GUpA$AbDSOYM?IEtp1_Q3nE3gE$ArDSOYM*+DrlB=N.4Fxrj,EOEQA+XrI:$vby<:&:C9hzXJI|+zJgIi\"9BJHNzWHuWA\";i:3034;s:15:\":`>hT?GUNkVqZLA\";i:3035;s:27:\"RjVjzXJI{ZmAm_&(k)Noa.Z|zWA\";i:3036;s:14:\"QjVjzXJI{ZmACA\";i:3037;s:14:\"QjVjzXJI|+BACA\";i:3038;s:49:\"HH@hT?GUOBlBFN.4Fx~5MA+hdjzXJI{ZmAx(&(k)Noa.GAaLA\";i:3039;s:74:\".a>hT?GUjSlBBN.4Fx}MrY6F00LvSQ[z+AbLnt,ub@y2+FNtp1_Q3nE3kAgA7BJHNzRm3twABA\";i:3040;s:73:\".a>hT?GUjSlB}M.4Fx~5RA1k>hT?GU}j[A7F&(k)Noa.@C0W{eqI:$vbSAS\";\",ub@y2kLNtA\";i:3041;s:81:\"hS>hT?GU%IlBRN.4FxrjMAeZ>hT?GU[IlB[N.4Fxrj,EaES\"\"\",ub@4E5FE0LvSQ[zCAc4mt,ub@/B5FA\";i:3042;s:15:\"?2?hT?GUNk8FaLA\";i:3043;s:152:\"bj>hT?GU~@EBz(lt,ub@=1TERt5BJHNzLYxWMcqI:$vboCi\"7BJHNzd&vWvDqI:$vby<Z*:C!WzXJI|+zJ8Ii\"9BJHNzRmY\"D\".o`Q3nE3@E$A=DSOYMj<RBIBFtW5VElg*NZm:ilBnP.4Fxrj,EgEQA\";i:3044;s:107:\"18=hT?GUGJlB/N.4Fx~5bA+h>hT?GU%IlB_M.4FxrjMAHO?hT?GUNk@JaLyqVElg*NUBQA5OrI:$vbQCgAGCJHNzoxvWT|qI:$vbaUk_:CA\";i:3045;s:15:\"sP?hT?GUNkaLaLA\";}", "no");
INSERT INTO `wp_options` VALUES("167", "cherry-search-default", "a:21:{s:22:\"change_standard_search\";b:1;s:18:\"search_button_icon\";s:0:\"\";s:18:\"search_button_text\";s:0:\"\";s:23:\"search_placeholder_text\";s:6:\"Search\";s:13:\"search_source\";a:1:{i:0;s:3:\"any\";}s:23:\"exclude_source_category\";s:8:\"projects\";s:19:\"exclude_source_tags\";s:0:\"\";s:26:\"exclude_source_post_format\";s:0:\"\";s:11:\"limit_query\";i:5;s:16:\"results_order_by\";s:4:\"date\";s:13:\"results_order\";s:3:\"asc\";s:13:\"title_visible\";b:1;s:18:\"limit_content_word\";i:50;s:14:\"author_visible\";b:1;s:13:\"author_prefix\";s:10:\"Posted by:\";s:17:\"thumbnail_visible\";b:1;s:13:\"enable_scroll\";b:1;s:18:\"result_area_height\";i:500;s:11:\"more_button\";s:10:\"View more.\";s:15:\"negative_search\";s:45:\"Sorry, but nothing matched your search terms.\";s:12:\"server_error\";s:75:\"Sorry, but we cannot handle your search query now. Please, try again later!\";}", "yes");
INSERT INTO `wp_options` VALUES("168", "tm_pg_plugin_notice", "0", "yes");
INSERT INTO `wp_options` VALUES("171", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("172", "group_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("173", "mp-event_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5566", "layout_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("175", "tm_pg_post_tag_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("176", "tm_pg_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("177", "cherry-services_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("381", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("382", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("383", "revslider_table_version", "1.0.6", "yes");
INSERT INTO `wp_options` VALUES("384", "revslider-global-settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("387", "revslider_update_version", "5.2.5.5", "yes");
INSERT INTO `wp_options` VALUES("388", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("389", "rs_cache_overlay", "5.4.8", "yes");
INSERT INTO `wp_options` VALUES("620", "revslider-stable-version", "4.2", "yes");
INSERT INTO `wp_options` VALUES("621", "revslider-notices", "a:9:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.0.9\";s:4:\"text\";s:230:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow51_banner.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1 is out\" ></a>\";s:4:\"code\";s:9:\"TPRS51-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.4\";s:4:\"text\";s:242:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=515b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner515.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.6\";s:4:\"text\";s:240:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=52b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner52.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.2.9\";s:4:\"text\";s:249:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=530b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner_large_5.3.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.3.0 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS530-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.3.9\";s:4:\"text\";s:232:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=54b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_54.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS540-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:5;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.4.1\";s:4:\"text\";s:249:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=542b\" target=\"_blank\"><img src=\"http://updates.themepunch.tools/banners/updatenow_banner_large_542.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.2 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS540-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:6;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.4.4\";s:4:\"text\";s:236:\"<a href=\"http://revolution.themepunch.com/direct-customer-benefits/?ref=545b\" target=\"_blank\"><img src=\"htt